/*!
 * tui-editor
 * @version 1.1.0
 * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com> (https://nhnent.github.io/tui.editor/)
 * @license MIT
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("jquery"), require("tui-code-snippet"), require("codemirror"), require("to-mark"), require("tui-chart"), require("squire-rte"), require("markdown-it"), require("highlight.js"), require("tui-color-picker"), require("plantuml-encoder"));
	else if(typeof define === 'function' && define.amd)
		define(["jquery", "tui-code-snippet", "codemirror", "to-mark", "tui-chart", "squire-rte", "markdown-it", "highlight.js", "tui-color-picker", "plantuml-encoder"], factory);
	else if(typeof exports === 'object')
		exports["Editor"] = factory(require("jquery"), require("tui-code-snippet"), require("codemirror"), require("to-mark"), require("tui-chart"), require("squire-rte"), require("markdown-it"), require("highlight.js"), require("tui-color-picker"), require("plantuml-encoder"));
	else
		root["tui"] = root["tui"] || {}, root["tui"]["Editor"] = factory(root["$"], (root["tui"] && root["tui"]["util"]), root["CodeMirror"], root["toMark"], (root["tui"] && root["tui"]["chart"]), root["Squire"], root["markdownit"], root["hljs"], (root["tui"] && root["tui"]["colorPicker"]), root["plantumlEncoder"]);
})(typeof self !== 'undefined' ? self : this, function(__WEBPACK_EXTERNAL_MODULE_0__, __WEBPACK_EXTERNAL_MODULE_1__, __WEBPACK_EXTERNAL_MODULE_10__, __WEBPACK_EXTERNAL_MODULE_40__, __WEBPACK_EXTERNAL_MODULE_55__, __WEBPACK_EXTERNAL_MODULE_75__, __WEBPACK_EXTERNAL_MODULE_81__, __WEBPACK_EXTERNAL_MODULE_89__, __WEBPACK_EXTERNAL_MODULE_192__, __WEBPACK_EXTERNAL_MODULE_194__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "dist/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 53);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_0__;

/***/ }),
/* 1 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_1__;

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements CommandManager
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _command = __webpack_require__(80);

var _command2 = _interopRequireDefault(_command);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var isMac = /Mac/.test(navigator.platform);
var KEYMAP_OS_INDEX = isMac ? 1 : 0;

/**
 * Class CommandManager
 */

var CommandManager = function () {
  /**
   * @param {ToastUIEditor} base nedInstance
   * @param {object} [options={}] - option object
   *  @param {boolean} [options.useCommandShortcut=true] - execute command with keyMap
   */
  function CommandManager(base) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, CommandManager);

    this._command = new _tuiCodeSnippet2.default.Map();
    this._mdCommand = new _tuiCodeSnippet2.default.Map();
    this._wwCommand = new _tuiCodeSnippet2.default.Map();
    this._options = _jquery2.default.extend({
      'useCommandShortcut': true
    }, options);

    this.base = base;

    this.keyMapCommand = {};

    this._initEvent();
  }

  /**
   * You can change command before command addition by addCommandBefore event.
   * @param {object} command - command
   * @returns {object}
   * @private
   */


  _createClass(CommandManager, [{
    key: '_addCommandBefore',
    value: function _addCommandBefore(command) {
      var commandWrapper = { command: command };

      this.base.eventManager.emit('addCommandBefore', commandWrapper);

      return commandWrapper.command || command;
    }

    /**
     * Add command
     * @memberof CommandManager
     * @param {Command} command Command instance
     * @returns {Command} Command
     */

  }, {
    key: 'addCommand',
    value: function addCommand(command) {
      for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      if (args.length) {
        command = CommandManager.command.apply(CommandManager, [command].concat(args));
      }

      command = this._addCommandBefore(command);

      var name = command.getName();

      var commandBase = void 0;

      if (command.isMDType()) {
        commandBase = this._mdCommand;
      } else if (command.isWWType()) {
        commandBase = this._wwCommand;
      } else if (command.isGlobalType()) {
        commandBase = this._command;
      }

      commandBase.set(name, command);

      if (command.keyMap) {
        this.keyMapCommand[command.keyMap[KEYMAP_OS_INDEX]] = name;
      }

      return command;
    }

    /**
     * _initEvent
     * Bind event handler to eventManager
     * @private
     * @memberof CommandManager
     */

  }, {
    key: '_initEvent',
    value: function _initEvent() {
      var _this = this;

      this.base.eventManager.listen('command', function () {
        _this.exec.apply(_this, arguments);
      });

      this.base.eventManager.listen('keyMap', function (ev) {
        if (!_this._options.useCommandShortcut) {
          return;
        }
        var command = _this.keyMapCommand[ev.keyMap];

        if (command) {
          ev.data.preventDefault();
          _this.exec(command);
        }
      });
    }

    /**
     * Execute command
     * @memberof CommandManager
     * @param {String} name Command name
     * @returns {*}
     */

  }, {
    key: 'exec',
    value: function exec(name) {
      var commandToRun = void 0,
          result = void 0;
      var context = this.base;

      commandToRun = this._command.get(name);

      if (!commandToRun) {
        if (this.base.isMarkdownMode()) {
          commandToRun = this._mdCommand.get(name);
          context = this.base.mdEditor;
        } else {
          commandToRun = this._wwCommand.get(name);
          context = this.base.wwEditor;
        }
      }

      if (commandToRun) {
        var _commandToRun;

        for (var _len2 = arguments.length, args = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
          args[_key2 - 1] = arguments[_key2];
        }

        args.unshift(context);
        result = (_commandToRun = commandToRun).exec.apply(_commandToRun, args);
      }

      return result;
    }
  }]);

  return CommandManager;
}();

/**
 * Create command by given editor type and property object
 * @memberof ComponentManager
 * @param {string} type Command type
 * @param {{name: string, keyMap: object}} props Property
 * @returns {*}
 */


CommandManager.command = function (type, props) {
  var command = _command2.default.factory(type, props.name, props.keyMap);

  _tuiCodeSnippet2.default.extend(command, props);

  return command;
};

exports.default = CommandManager;

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.I18n = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements i18n
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var sharedInstance = void 0;

var DEFAULT_CODE = 'en_US';

/**
 * Class I18n
 */

var I18n = function () {
  /**
   * Creates an instance of I18n.
   * @memberof I18n
   */
  function I18n() {
    _classCallCheck(this, I18n);

    this._code = DEFAULT_CODE;
    this._langs = new _tuiCodeSnippet2.default.Map();
  }

  /**
   * Set locale code
   * @param {string} code locale code
   */


  _createClass(I18n, [{
    key: 'setCode',
    value: function setCode(code) {
      this._code = code;
    }

    /**
     * Set language set
     * @param {string|string[]} codes locale code
     * @param {object} data language set
     */

  }, {
    key: 'setLanguage',
    value: function setLanguage(codes, data) {
      var _this = this;

      codes = [].concat(codes);

      codes.forEach(function (code) {
        if (!_this._langs.has(code)) {
          _this._langs.set(code, data);
        } else {
          var langData = _this._langs.get(code);
          _this._langs.set(code, _tuiCodeSnippet2.default.extend(langData, data));
        }
      });
    }

    /**
     * Get text of key
     * @param {string} key key of text
     * @param {string} code locale code
     * @returns {string}
     */

  }, {
    key: 'get',
    value: function get(key, code) {
      if (!code) {
        code = this._code;
      }

      var langSet = this._langs.get(code);

      if (!langSet) {
        langSet = this._langs.get(DEFAULT_CODE);
      }

      var text = langSet[key];

      if (!text) {
        throw new Error('There is no text key "' + key + '" in ' + code);
      }

      return text;
    }
  }], [{
    key: 'getSharedInstance',
    value: function getSharedInstance() {
      if (!sharedInstance) {
        sharedInstance = new I18n();
      }

      return sharedInstance;
    }
  }]);

  return I18n;
}();

exports.I18n = I18n;
exports.default = new I18n();

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @fileoverview DOM Utils
 * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */
var FIND_ZWB = /\u200B/g;

/**
 * isTextNode
 * Check if node is text node
 * @param {Node} node node to check
 * @returns {boolean} result
 * @ignore
 */
var isTextNode = function isTextNode(node) {
  return node && node.nodeType === Node.TEXT_NODE;
};

/**
 * isElemNode
 * Check if node is element node
 * @param {Node} node node to check
 * @returns {boolean} result
 * @ignore
 */
var isElemNode = function isElemNode(node) {
  return node && node.nodeType === Node.ELEMENT_NODE;
};

/**
 * getNodeName
 * Get node name of node
 * @param {Node} node node
 * @returns {string} node name
 * @ignore
 */
var getNodeName = function getNodeName(node) {
  if (isElemNode(node)) {
    return node.tagName;
  }

  return 'TEXT';
};

/**
 * getTextLength
 * Get node offset length of node(for Range API)
 * @param {Node} node node
 * @returns {number} length
 * @ignore
 */
var getTextLength = function getTextLength(node) {
  var len = void 0;

  if (isElemNode(node)) {
    len = node.textContent.replace(FIND_ZWB, '').length;
  } else if (isTextNode(node)) {
    len = node.nodeValue.replace(FIND_ZWB, '').length;
  }

  return len;
};

/**
 * getOffsetLength
 * Get node offset length of node(for Range API)
 * @param {Node} node node
 * @returns {number} length
 * @ignore
 */
var getOffsetLength = function getOffsetLength(node) {
  var len = void 0;

  if (isElemNode(node)) {
    len = node.childNodes.length;
  } else if (isTextNode(node)) {
    len = node.nodeValue.replace(FIND_ZWB, '').length;
  }

  return len;
};

/**
 * getNodeOffsetOfParent
 * get node offset between parent's childnodes
 * @param {Node} node node
 * @returns {number} offset(index)
 * @ignore
 */
var getNodeOffsetOfParent = function getNodeOffsetOfParent(node) {
  var childNodesOfParent = node.parentNode.childNodes;
  var i = void 0,
      t = void 0,
      found = void 0;

  for (i = 0, t = childNodesOfParent.length; i < t; i += 1) {
    if (childNodesOfParent[i] === node) {
      found = i;
      break;
    }
  }

  return found;
};

/**
 * getChildNodeByOffset
 * get child node by offset
 * @param {Node} node node
 * @param {number} index offset index
 * @returns {Node} foudned node
 * @ignore
 */
var getChildNodeByOffset = function getChildNodeByOffset(node, index) {
  var currentNode = void 0;

  if (isTextNode(node)) {
    currentNode = node;
  } else if (node.childNodes.length && index >= 0) {
    currentNode = node.childNodes[index];
  }

  return currentNode;
};

/**
 * getNodeWithDirectionUntil
 * find next node from passed node
 * @param {strong} direction previous or next
 * @param {Node} node node
 * @param {string} untilNodeName parent node name to limit
 * @returns {Node} founded node
 * @ignore
 */
var getNodeWithDirectionUntil = function getNodeWithDirectionUntil(direction, node, untilNodeName) {
  var directionKey = direction + 'Sibling';
  var nodeName = void 0,
      foundedNode = void 0;

  while (node && !node[directionKey]) {
    nodeName = getNodeName(node.parentNode);

    if (nodeName === untilNodeName || nodeName === 'BODY') {
      break;
    }

    node = node.parentNode;
  }

  if (node[directionKey]) {
    foundedNode = node[directionKey];
  }

  return foundedNode;
};

/**
 * getPrevOffsetNodeUntil
 * get prev node of childnode pointed with index
 * @param {Node} node node
 * @param {number} index offset index
 * @param {string} untilNodeName parent node name to limit
 * @returns {Node} founded node
 * @ignore
 */
var getPrevOffsetNodeUntil = function getPrevOffsetNodeUntil(node, index, untilNodeName) {
  var prevNode = void 0;

  if (index > 0) {
    prevNode = getChildNodeByOffset(node, index - 1);
  } else {
    prevNode = getNodeWithDirectionUntil('previous', node, untilNodeName);
  }

  return prevNode;
};

var getParentUntilBy = function getParentUntilBy(node, condition) {
  var foundedNode = void 0;

  while (node.parentNode && !condition(node.parentNode)) {
    node = node.parentNode;
  }

  if (condition(node.parentNode)) {
    foundedNode = node;
  }

  return foundedNode;
};

/**
 * getParentUntil
 * get parent node until paseed node name
 * @param {Node} node node
 * @param {string|HTMLNode} untilNode node name or node to limit
 * @returns {Node} founded node
 * @ignore
 */
var getParentUntil = function getParentUntil(node, untilNode) {
  var foundedNode = void 0;

  if (_tuiCodeSnippet2.default.isString(untilNode)) {
    foundedNode = getParentUntilBy(node, function (targetNode) {
      return untilNode === getNodeName(targetNode);
    });
  } else {
    foundedNode = getParentUntilBy(node, function (targetNode) {
      return untilNode === targetNode;
    });
  }

  return foundedNode;
};

/**
 * getNodeWithDirectionUnderParent
 * get node on the given direction under given parent
 * @param {strong} direction previous or next
 * @param {Node} node node
 * @param {string|Node} underNode parent node name to limit
 * @returns {Node} founded node
 * @ignore
 */
var getNodeWithDirectionUnderParent = function getNodeWithDirectionUnderParent(direction, node, underNode) {
  var directionKey = direction + 'Sibling';
  var foundedNode = void 0;

  node = getParentUntil(node, underNode);

  if (node && node[directionKey]) {
    foundedNode = node[directionKey];
  }

  return foundedNode;
};

/**
 * getTopPrevNodeUnder
 * get top previous top level node under given node
 * @param {Node} node node
 * @param {Node} underNode underNode
 * @returns {Node} founded node
 * @ignore
 */
var getTopPrevNodeUnder = function getTopPrevNodeUnder(node, underNode) {
  return getNodeWithDirectionUnderParent('previous', node, underNode);
};

/**
 * getNextTopBlockNode
 * get next top level block node
 * @param {Node} node node
 * @param {Node} underNode underNode
 * @returns {Node} founded node
 * @ignore
 */
var getTopNextNodeUnder = function getTopNextNodeUnder(node, underNode) {
  return getNodeWithDirectionUnderParent('next', node, underNode);
};

/**
 * Get parent element the body element
 * @param {Node} node Node for start searching
 * @returns {Node}
 * @ignore
 */
var getTopBlockNode = function getTopBlockNode(node) {
  return getParentUntil(node, 'BODY');
};

/**
 * Get previous text node
 * @param {Node} node Node for start searching
 * @returns {Node}
 * @ignore
 */
var getPrevTextNode = function getPrevTextNode(node) {
  node = node.previousSibling || node.parentNode;

  while (!isTextNode(node) && getNodeName(node) !== 'BODY') {
    if (node.previousSibling) {
      node = node.previousSibling;

      while (node.lastChild) {
        node = node.lastChild;
      }
    } else {
      node = node.parentNode;
    }
  }

  if (getNodeName(node) === 'BODY') {
    node = null;
  }

  return node;
};

/**
 * find node by offset
 * @param {HTMLElement} root Root element
 * @param {Array.<number>} offsetList offset list
 * @param {function} textNodeFilter Text node filter
 * @returns {Array}
 * @ignore
 */
var findOffsetNode = function findOffsetNode(root, offsetList, textNodeFilter) {
  var result = [];
  var text = '';
  var walkerOffset = 0;
  var newWalkerOffset = void 0;

  if (!offsetList.length) {
    return result;
  }

  var offset = offsetList.shift();
  var walker = document.createTreeWalker(root, 4, null, false);

  while (walker.nextNode()) {
    text = walker.currentNode.nodeValue || '';

    if (textNodeFilter) {
      text = textNodeFilter(text);
    }

    newWalkerOffset = walkerOffset + text.length;

    while (newWalkerOffset >= offset) {
      result.push({
        container: walker.currentNode,
        offsetInContainer: offset - walkerOffset,
        offset: offset
      });

      if (!offsetList.length) {
        return result;
      }
      offset = offsetList.shift();
    }
    walkerOffset = newWalkerOffset;
  }

  // there should be offset left
  do {
    result.push({
      container: walker.currentNode,
      offsetInContainer: text.length,
      offset: offset
    });
    offset = offsetList.shift();
  } while (!_tuiCodeSnippet2.default.isUndefined(offset));

  return result;
};

var getNodeInfo = function getNodeInfo(node) {
  var path = {};

  path.tagName = node.nodeName;

  if (node.id) {
    path.id = node.id;
  }

  var className = node.className.trim();

  if (className) {
    path.className = className;
  }

  return path;
};

var getPath = function getPath(node, root) {
  var paths = [];

  while (node && node !== root) {
    if (isElemNode(node)) {
      paths.unshift(getNodeInfo(node));
    }

    node = node.parentNode;
  }

  return paths;
};

/**
 * Find next, previous TD or TH element by given TE element
 * @param {HTMLElement} node TD element
 * @param {string} direction Boolean value for direction true is find next cell
 * @returns {HTMLElement|null}
 * @ignore
 */
var getTableCellByDirection = function getTableCellByDirection(node, direction) {
  var isForward = true;
  var targetElement = null;

  if (_tuiCodeSnippet2.default.isUndefined(direction) || direction !== 'next' && direction !== 'previous') {
    return null;
  } else if (direction === 'previous') {
    isForward = false;
  }

  if (isForward) {
    targetElement = node.nextElementSibling;
  } else {
    targetElement = node.previousElementSibling;
  }

  return targetElement;
};

/**
 * Find sibling TR's TD element by given TD and direction
 * @param {HTMLElement} node TD element
 * @param {string} direction Boolean value for find first TD in next line
 * @param {boolean} [needEdgeCell=false] Boolean value for find first TD in next line
 * @returns {HTMLElement|null}
 * @ignore
 */
var getSiblingRowCellByDirection = function getSiblingRowCellByDirection(node, direction, needEdgeCell) {
  var isForward = true;
  var tableCellElement = null;
  var $node = void 0,
      index = void 0,
      $targetRowElement = void 0,
      $currentContainer = void 0,
      $siblingContainer = void 0,
      isSiblingContainerExists = void 0;

  if (_tuiCodeSnippet2.default.isUndefined(direction) || direction !== 'next' && direction !== 'previous') {
    return null;
  } else if (direction === 'previous') {
    isForward = false;
  }

  if (node) {
    $node = (0, _jquery2.default)(node);

    if (isForward) {
      $targetRowElement = $node.parent().next();
      $currentContainer = $node.parents('thead');
      $siblingContainer = $currentContainer[0] && $currentContainer.next();
      isSiblingContainerExists = $siblingContainer && getNodeName($siblingContainer[0]) === 'TBODY';

      index = 0;
    } else {
      $targetRowElement = $node.parent().prev();
      $currentContainer = $node.parents('tbody');
      $siblingContainer = $currentContainer[0] && $currentContainer.prev();
      isSiblingContainerExists = $siblingContainer && getNodeName($siblingContainer[0]) === 'THEAD';

      index = node.parentNode.childNodes.length - 1;
    }

    if (_tuiCodeSnippet2.default.isUndefined(needEdgeCell) || !needEdgeCell) {
      index = getNodeOffsetOfParent(node);
    }

    if ($targetRowElement[0]) {
      tableCellElement = $targetRowElement.children('td,th')[index];
    } else if ($currentContainer[0] && isSiblingContainerExists) {
      tableCellElement = $siblingContainer.find('td,th')[index];
    }

    return tableCellElement;
  }

  return null;
};

exports.default = {
  getNodeName: getNodeName,
  isTextNode: isTextNode,
  isElemNode: isElemNode,
  getTextLength: getTextLength,
  getOffsetLength: getOffsetLength,
  getPrevOffsetNodeUntil: getPrevOffsetNodeUntil,
  getNodeOffsetOfParent: getNodeOffsetOfParent,
  getChildNodeByOffset: getChildNodeByOffset,
  getTopPrevNodeUnder: getTopPrevNodeUnder,
  getTopNextNodeUnder: getTopNextNodeUnder,
  getParentUntil: getParentUntil,
  getTopBlockNode: getTopBlockNode,
  getPrevTextNode: getPrevTextNode,
  findOffsetNode: findOffsetNode,
  getPath: getPath,
  getNodeInfo: getNodeInfo,
  getTableCellByDirection: getTableCellByDirection,
  getSiblingRowCellByDirection: getSiblingRowCellByDirection
};

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
/**
* @fileoverview Editor/Viewer proxy for extensions
* @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
*/
/* eslint global-require: 0 no-empty: 0 */

var Editor = void 0;
try {
  Editor = __webpack_require__(27);
} catch (e) {}
if (!Editor) {
  try {
    Editor = __webpack_require__(!(function webpackMissingModule() { var e = new Error("Cannot find module \"../viewer\""); e.code = 'MODULE_NOT_FOUND'; throw e; }()));
  } catch (e) {}
}

exports.default = Editor;

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTableData = createTableData;
exports.createCellIndexData = createCellIndexData;

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Parse cell like td or th.
 * @param {HTMLElement} cell - cell element like td or th
 * @param {number} rowIndex - row index
 * @param {number} colIndex - column index
 * @returns {{
 *   nodeName: string,
 *   colspan: number,
 *   rowspan: number,
 *   content: string,
 *   align: ?string
 * }}
 * @private
 */
/**
* @fileoverview Implements tableDataHandler
* @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
*/
function _parseCell(cell, rowIndex, colIndex) {
  var $cell = (0, _jquery2.default)(cell);
  var colspan = $cell.attr('colspan');
  var rowspan = $cell.attr('rowspan');
  var nodeName = cell.nodeName;


  if (nodeName !== 'TH' && nodeName !== 'TD') {
    return null;
  }

  var cellData = {
    nodeName: cell.nodeName,
    colspan: colspan ? parseInt(colspan, 10) : 1,
    rowspan: rowspan ? parseInt(rowspan, 10) : 1,
    content: $cell.html(),
    elementIndex: {
      rowIndex: rowIndex,
      colIndex: colIndex
    }
  };

  if (cell.nodeName === 'TH' && cell.align) {
    cellData.align = cell.align;
  }

  return cellData;
}

/**
 * Add merged cell.
 * @param {object} base - base table data
 * @param {object} cellData - cell data
 * @param {number} startRowIndex - start row index
 * @param {number} startCellIndex - start cell index
 * @private
 */
function _addMergedCell(base, cellData, startRowIndex, startCellIndex) {
  var colspan = cellData.colspan,
      rowspan = cellData.rowspan,
      nodeName = cellData.nodeName;

  var colMerged = colspan > 1;
  var rowMerged = rowspan > 1;

  if (!colMerged && !rowMerged) {
    return;
  }

  var limitRowIndex = startRowIndex + rowspan;
  var limitCellIndex = startCellIndex + colspan;

  _tuiCodeSnippet2.default.range(startRowIndex, limitRowIndex).forEach(function (rowIndex) {
    base[rowIndex] = base[rowIndex] || [];

    _tuiCodeSnippet2.default.range(startCellIndex, limitCellIndex).forEach(function (cellIndex) {
      var mergedData = {
        nodeName: nodeName
      };

      if (rowIndex === startRowIndex && cellIndex === startCellIndex) {
        return;
      }

      if (colMerged) {
        mergedData.colMergeWith = startCellIndex;
      }

      if (rowMerged) {
        mergedData.rowMergeWith = startRowIndex;
      }

      base[rowIndex][cellIndex] = mergedData;
    });
  });
}

/**
 * Create table data from jQuery table Element.
 * @param {jQuery} $table - jQuery table element
 * @returns {Array.<Array.<object>>}
 * @ignore
 */
function createTableData($table) {
  var tableData = [];

  $table.find('tr').each(function (rowIndex, tr) {
    var stackedColCount = 0;

    tableData[rowIndex] = tableData[rowIndex] || [];

    (0, _jquery2.default)(tr).children().each(function (colIndex, cell) {
      var cellData = _parseCell(cell, rowIndex, colIndex);

      if (!cellData) {
        return;
      }
      var dataColIndex = colIndex + stackedColCount;

      while (tableData[rowIndex][dataColIndex]) {
        dataColIndex += 1;
        stackedColCount += 1;
      }

      tableData[rowIndex][dataColIndex] = cellData;
      _addMergedCell(tableData, cellData, rowIndex, dataColIndex);
    });
  });

  if ($table[0].className) {
    tableData.className = $table[0].className;
  }

  return tableData;
}

/**
 * Create cell index data of table data.
 * @param {Array.<Array.<object>>} tableData - table data
 * @returns {Array.<Array.<object>>}
 * @ignore
 */
function createCellIndexData(tableData) {
  var mappingData = [];

  tableData.forEach(function (row, rowIndex) {
    var mappingRow = [];

    row.forEach(function (cell, colIndex) {
      if (_tuiCodeSnippet2.default.isUndefined(cell.colMergeWith) && _tuiCodeSnippet2.default.isUndefined(cell.rowMergeWith)) {
        mappingRow.push({
          rowIndex: rowIndex,
          colIndex: colIndex
        });
      }
    });
    mappingData.push(mappingRow);
  });

  return mappingData;
}

/**
 * Get header aligns.
 * @param {Array.<Array.<object>>} tableData - table data
 * @returns {Array.<?string>}
 * @private
 */
function _getHeaderAligns(tableData) {
  var headRowData = tableData[0];


  return headRowData.map(function (cellData) {
    var align = void 0;

    if (_tuiCodeSnippet2.default.isExisty(cellData.colMergeWith)) {
      align = headRowData[cellData.colMergeWith].align;
    } else {
      align = cellData.align;
    }

    return align;
  });
}

/**
 * Create render data.
 * @param {Array.<object>} tableData - table data
 * @param {Array.<object>} cellIndexData - cell index data
 * @returns {Array.<Array.<object>>}
 * @ignore
 */
function createRenderData(tableData, cellIndexData) {
  var headerAligns = _getHeaderAligns(tableData);
  var renderData = cellIndexData.map(function (row) {
    return row.map(function (_ref) {
      var rowIndex = _ref.rowIndex,
          colIndex = _ref.colIndex;
      return _tuiCodeSnippet2.default.extend({
        align: headerAligns[colIndex]
      }, tableData[rowIndex][colIndex]);
    });
  });

  if (tableData.className) {
    renderData.className = tableData.className;
  }

  return renderData;
}

var BASIC_CELL_CONTENT = _tuiCodeSnippet2.default.browser.msie ? '' : '<br>';

/**
 * Create basic cell data.
 * @param {number} rowIndex - row index
 * @param {number} colIndex - column index
 * @param {string} nodeName - node name
 * @returns {{
 *   nodeName: string,
 *   colspan: number,
 *   rowspan: number,
 *   content: string
 * }}
 * @ignore
 */
function createBasicCell(rowIndex, colIndex, nodeName) {
  return {
    nodeName: nodeName || 'TD',
    colspan: 1,
    rowspan: 1,
    content: BASIC_CELL_CONTENT,
    elementIndex: {
      rowIndex: rowIndex,
      colIndex: colIndex
    }
  };
}

/**
 * Find element row index.
 * @param {jQuery} $cell - cell jQuery element like td or th
 * @returns {number}
 * @ignore
 */
function findElementRowIndex($cell) {
  var $tr = $cell.closest('tr');
  var rowIndex = $tr.prevAll().length;

  if ($tr.parent()[0].nodeName === 'TBODY') {
    rowIndex += 1;
  }

  return rowIndex;
}

/**
 * Find element col index.
 * @param {jQuery} $cell - cell jQuery element like td or th
 * @returns {number}
 * @ignore
 */
function findElementColIndex($cell) {
  return $cell.closest('td, th').prevAll().length;
}

/**
 * Find indexes of base table data from mappin data.
 * @param {Array.<Array.<object>>} cellIndexData - cell index data
 * @param {jQuery} $cell - cell jQuery element like td or th
 * @returns {{rowIndex: number, cellIndex: number}}
 * @ignore
 */
function findCellIndex(cellIndexData, $cell) {
  var elementRowIndex = findElementRowIndex($cell);
  var elementColIndex = findElementColIndex($cell);

  return cellIndexData[elementRowIndex][elementColIndex];
}

/**
 * Find last index of col merged cells.
 * @param {Array.<Array.<object>>} tableData - tableData data
 * @param {number} rowIndex - row index of base data
 * @param {number} colIndex - column index of tabld data
 * @returns {number}
 * @ignore
 */
function findRowMergedLastIndex(tableData, rowIndex, colIndex) {
  var cellData = tableData[rowIndex][colIndex];
  var foundRowIndex = rowIndex;

  if (cellData.rowspan > 1) {
    foundRowIndex += cellData.rowspan - 1;
  }

  return foundRowIndex;
}

/**
 * Find last index of col merged cells.
 * @param {Array.<Array.<object>>} tableData - tableData data
 * @param {number} rowIndex - row index of base data
 * @param {number} colIndex - column index of tabld data
 * @returns {number}
 * @ignore
 */
function findColMergedLastIndex(tableData, rowIndex, colIndex) {
  var cellData = tableData[rowIndex][colIndex];
  var foundColIndex = colIndex;

  if (cellData.colspan > 1) {
    foundColIndex += cellData.colspan - 1;
  }

  return foundColIndex;
}

/**
 * Find cell element index.
 * @param {Array.<Array.<object>>} tableData - tableData data
 * @param {number} rowIndex - row index of base data
 * @param {number} colIndex - col index of base data
 * @returns {{rowIndex: number, colIndex: number}}
 * @ignore
 */
function findElementIndex(tableData, rowIndex, colIndex) {
  var cellData = tableData[rowIndex][colIndex];

  rowIndex = _tuiCodeSnippet2.default.isExisty(cellData.rowMergeWith) ? cellData.rowMergeWith : rowIndex;
  colIndex = _tuiCodeSnippet2.default.isExisty(cellData.colMergeWith) ? cellData.colMergeWith : colIndex;

  return tableData[rowIndex][colIndex].elementIndex;
}

/**
 * Stuff cells into incomplete row.
 * @param {Array.<Array.<object>>} tableData - table data
 * @param {number} limitIndex - limit index
 * @ignore
 */
function stuffCellsIntoIncompleteRow(tableData, limitIndex) {
  tableData.forEach(function (rowData, rowIndex) {
    var startIndex = rowData.length;
    var nodeName = rowData[0].nodeName;


    _tuiCodeSnippet2.default.range(startIndex, limitIndex).forEach(function (colIndex) {
      rowData.push(createBasicCell(rowIndex, colIndex, nodeName));
    });
  });
}

/**
 * Add tbody or thead of table data if need.
 * @param {Array.<Array.<object>>} tableData - table data
 * @returns {boolean}
 * @ignore
 */
function addTbodyOrTheadIfNeed(tableData) {
  var header = tableData[0];

  var cellCount = header.length;
  var added = true;

  if (!cellCount && tableData[1]) {
    _tuiCodeSnippet2.default.range(0, tableData[1].length).forEach(function (colIndex) {
      header.push(createBasicCell(0, colIndex, 'TH'));
    });
  } else if (tableData[0][0].nodeName !== 'TH') {
    var _ref2;

    var newHeader = _tuiCodeSnippet2.default.range(0, cellCount).map(function (colIndex) {
      return createBasicCell(0, colIndex, 'TH');
    });

    (_ref2 = []).concat.apply(_ref2, tableData).forEach(function (cellData) {
      if (cellData.elementIndex) {
        cellData.elementIndex.rowIndex += 1;
      }
    });

    tableData.unshift(newHeader);
  } else if (tableData.length === 1) {
    var newRow = _tuiCodeSnippet2.default.range(0, cellCount).map(function (colIndex) {
      return createBasicCell(1, colIndex, 'TD');
    });

    tableData.push(newRow);
  } else {
    added = false;
  }

  return added;
}

exports.default = {
  createTableData: createTableData,
  createCellIndexData: createCellIndexData,
  createRenderData: createRenderData,
  findElementRowIndex: findElementRowIndex,
  findElementColIndex: findElementColIndex,
  findCellIndex: findCellIndex,
  createBasicCell: createBasicCell,
  findRowMergedLastIndex: findRowMergedLastIndex,
  findColMergedLastIndex: findColMergedLastIndex,
  findElementIndex: findElementIndex,
  stuffCellsIntoIncompleteRow: stuffCellsIntoIncompleteRow,
  addTbodyOrTheadIfNeed: addTbodyOrTheadIfNeed
};

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _uicontroller = __webpack_require__(14);

var _uicontroller2 = _interopRequireDefault(_uicontroller);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements LayerPopup
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var CLASS_PREFIX = 'tui-popup-';
var CLASS_FIT_WINDOW = 'fit-window';

var LAYOUT_TEMPLATE_MODELESS = '<div class="' + CLASS_PREFIX + 'header">\n        <span class="' + CLASS_PREFIX + 'title"></span>\n        <div class="' + CLASS_PREFIX + 'header-buttons">\n            <button type="button" class="' + CLASS_PREFIX + 'close-button"></button>\n        </div>\n    </div>\n    <div class="' + CLASS_PREFIX + 'body"></div>';

var LAYOUT_TEMPLATE_MODAL = '<div class="' + CLASS_PREFIX + 'wrapper">\n        <div class="' + CLASS_PREFIX + 'header">\n            <span class="' + CLASS_PREFIX + 'title"></span>\n            <div class="' + CLASS_PREFIX + 'header-buttons">\n                <button type="button" class="' + CLASS_PREFIX + 'close-button"></button>\n            </div>\n        </div>\n        <div class="' + CLASS_PREFIX + 'body"></div>\n    </div>';

/**
 * A number, or a string containing a number.
 * @typedef {Object} LayerPopupOption
    * @property {string[]} openerCssQuery - Css Query list to bind clickevent that open popup
    * @property {string[]} closerCssQuery - Css Query list to bind clickevent that close popup
    * @property {jQuery} $el - popup root element
    * @property {jQuery|string} content - popup content that html string or jQuery element
    * @property {string} textContent - popup text content
    * @property {string} title - popup title
    * @property {boolean} header - whether to draw header
    * @property {jQuery} $target - element to append popup
    * @property {boolean} modal - true: modal, false: modeless
    * @property {string} headerButtons - replace header(close) button
 */

/**
 * Class LayerPopup
 * @extends {UIController}
 */

var LayerPopup = function (_UIController) {
  _inherits(LayerPopup, _UIController);

  /**
   * Creates an instance of LayerPopup.
   * @param {LayerPopupOption} options - popup option
   * @memberof LayerPopup
   */
  function LayerPopup(options) {
    _classCallCheck(this, LayerPopup);

    options = _tuiCodeSnippet2.default.extend({
      header: true,
      $target: (0, _jquery2.default)('body'),
      textContent: ''
    }, options);

    var _this = _possibleConstructorReturn(this, (LayerPopup.__proto__ || Object.getPrototypeOf(LayerPopup)).call(this, {
      tagName: 'div',
      className: options.modal ? CLASS_PREFIX + 'modal-background' : CLASS_PREFIX + 'wrapper',
      rootElement: options.$el
    }));

    _this._initInstance(options);
    _this._initDOM(options);
    _this._initDOMEvent(options);
    _this._initEditorEvent(options);
    return _this;
  }

  /**
   * init instance.
   * store properties & prepare before initialize DOM
   * @param {LayerPopupOption} options - layer popup options
   * @memberof LayerPopup
   * @protected
   */


  _createClass(LayerPopup, [{
    key: '_initInstance',
    value: function _initInstance(options) {
      this._$target = options.$target;

      if (options.$el) {
        this.$el = options.$el;
        this._isExternalHtmlUse = true;
      }

      if (options.content) {
        this.$content = (0, _jquery2.default)(options.content);
      } else {
        this.$content = options.textContent;
      }

      this.options = options;
    }

    /**
     * initialize DOM, render popup
     * @memberof LayerPopup
     * @protected
     */

  }, {
    key: '_initDOM',
    value: function _initDOM() {
      this._initLayout();

      if (!this._isExternalHtmlUse) {
        if (_tuiCodeSnippet2.default.isExisty(this.options.title)) {
          this.setTitle(this.options.title);
        }
        this.setContent(this.$content);
      }

      var buttons = this.options.headerButtons;
      if (buttons) {
        this.$el.find('.' + CLASS_PREFIX + 'close-button').remove();

        var $buttonWrapper = this.$el.find('.' + CLASS_PREFIX + 'header-buttons');
        $buttonWrapper.empty();
        $buttonWrapper.append((0, _jquery2.default)(buttons));
      }

      if (this.options.css) {
        this.$el.css(this.options.css);
      }
    }

    /**
     * bind DOM events
     * @memberof LayerPopup
     * @protected
     */

  }, {
    key: '_initDOMEvent',
    value: function _initDOMEvent() {
      var _this2 = this;

      var _options = this.options,
          openerCssQuery = _options.openerCssQuery,
          closerCssQuery = _options.closerCssQuery;

      if (openerCssQuery) {
        (0, _jquery2.default)(openerCssQuery).on('click.' + this._id, function () {
          return _this2.show();
        });
      }
      if (closerCssQuery) {
        (0, _jquery2.default)(closerCssQuery).on('click.' + this._id, function () {
          return _this2.hide();
        });
      }

      this.on('click .' + CLASS_PREFIX + 'close-button', function () {
        return _this2.hide();
      });
    }

    /**
     * bind editor events
     * @memberof LayerPopup
     * @protected
     * @abstract
     */

  }, {
    key: '_initEditorEvent',
    value: function _initEditorEvent() {}
  }, {
    key: '_initLayout',
    value: function _initLayout() {
      var options = this.options;


      if (!this._isExternalHtmlUse) {
        var layout = options.modal ? LAYOUT_TEMPLATE_MODAL : LAYOUT_TEMPLATE_MODELESS;
        this.$el.html(layout);
        this.$el.addClass(options.className);
        this.hide();
        this._$target.append(this.$el);
        this.$body = this.$el.find('.' + CLASS_PREFIX + 'body');

        if (!options.header) {
          this.$el.find('.' + CLASS_PREFIX + 'header').remove();
        }
      } else {
        this.hide();
        this._$target.append(this.$el);
      }
    }

    /**
     * set popup content
     * @param {jQuery|HTMLElement|string} $content - content
     * @memberof LayerPopup
     */

  }, {
    key: 'setContent',
    value: function setContent($content) {
      this.$body.empty();
      this.$body.append($content);
    }

    /**
     * set title
     * @param {string} title - title text
     * @memberof LayerPopup
     */

  }, {
    key: 'setTitle',
    value: function setTitle(title) {
      var $title = this.$el.find('.' + CLASS_PREFIX + 'title');

      $title.empty();
      $title.append(title);
    }

    /**
     * get title element
     * @memberof LayerPopup
     * @returns {HTMLElement} - title html element
     */

  }, {
    key: 'getTitleElement',
    value: function getTitleElement() {
      return this.$el.find('.' + CLASS_PREFIX + 'title').get(0);
    }

    /**
     * hide popup
     * @memberof LayerPopup
     */

  }, {
    key: 'hide',
    value: function hide() {
      this.$el.css('display', 'none');
      this._isShow = false;
      this.trigger('hidden', this);
    }

    /**
     * show popup
     * @memberof LayerPopup
     */

  }, {
    key: 'show',
    value: function show() {
      this.$el.css('display', 'block');
      this._isShow = true;
      this.trigger('shown', this);
    }

    /**
     * whether this popup is visible
     * @returns {boolean} - true: shown, false: hidden
     * @memberof LayerPopup
     */

  }, {
    key: 'isShow',
    value: function isShow() {
      return this._isShow;
    }

    /**
     * remove popup content
     * @memberof LayerPopup
     */

  }, {
    key: 'remove',
    value: function remove() {
      var _options2 = this.options,
          openerCssQuery = _options2.openerCssQuery,
          closerCssQuery = _options2.closerCssQuery;


      this.trigger('remove', this);
      this.off();

      if (openerCssQuery) {
        (0, _jquery2.default)(openerCssQuery).off('.' + this._id);
      }
      if (closerCssQuery) {
        (0, _jquery2.default)(closerCssQuery).off('.' + this._id);
      }

      this.$el.remove();
    }

    /**
     * make popup size fit to window
     * @param {boolean} fit - true to make popup fit to window
     * @memberof LayerPopup
     * @protected
     */

  }, {
    key: 'setFitToWindow',
    value: function setFitToWindow(fit) {
      this.$el.toggleClass(CLASS_FIT_WINDOW, fit);
    }

    /**
     * make popup size fit to window
     * @memberof LayerPopup
     * @protected
     * @returns {boolean} - true for fit to window
     */

  }, {
    key: 'isFitToWindow',
    value: function isFitToWindow() {
      return this.$el.hasClass(CLASS_FIT_WINDOW);
    }

    /**
     * toggle size fit to window
     * @memberof LayerPopup
     * @protected
     * @returns {boolean} - true for fit to window
     */

  }, {
    key: 'toggleFitToWindow',
    value: function toggleFitToWindow() {
      var fitToWindow = !this.isFitToWindow();
      this.setFitToWindow(fitToWindow);

      return fitToWindow;
    }
  }]);

  return LayerPopup;
}(_uicontroller2.default);

exports.default = LayerPopup;

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tableDataHandler = __webpack_require__(6);

var _tableDataHandler2 = _interopRequireDefault(_tableDataHandler);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Create cell html.
 * @param {object} cell - cell data of table base data
 * @returns {string}
 * @private
 */
/**
* @fileoverview Implements tableRenderer
* @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
*/
function _createCellHtml(cell) {
  var attrs = cell.colspan > 1 ? ' colspan="' + cell.colspan + '"' : '';
  attrs += cell.rowspan > 1 ? ' rowspan="' + cell.rowspan + '"' : '';
  attrs += cell.align ? ' align="' + cell.align + '"' : '';

  return '<' + cell.nodeName + attrs + '>' + cell.content + '</' + cell.nodeName + '>';
}

/**
 * Create html for thead or tbody.
 * @param {Array.<Array.<object>>} trs - tr list
 * @param {string} wrapperNodeName - wrapper node name like THEAD, TBODY
 * @returns {string}
 * @private
 */
function _createTheadOrTbodyHtml(trs, wrapperNodeName) {
  var html = '';

  if (trs.length) {
    html = trs.map(function (tr) {
      var tdHtml = tr.map(_createCellHtml).join('');

      return '<tr>' + tdHtml + '</tr>';
    }).join('');
    html = '<' + wrapperNodeName + '>' + html + '</' + wrapperNodeName + '>';
  }

  return html;
}

/**
 * Create table html.
 * @param {Array.<Array.<object>>} renderData - table data for render
 * @returns {string}
 * @private
 */
function createTableHtml(renderData) {
  var thead = [renderData[0]];
  var tbody = renderData.slice(1);
  var theadHtml = _createTheadOrTbodyHtml(thead, 'THEAD');
  var tbodyHtml = _createTheadOrTbodyHtml(tbody, 'TBODY');
  var className = renderData.className ? ' class="' + renderData.className + '"' : '';

  return '<table' + className + '>' + (theadHtml + tbodyHtml) + '</renderData>';
}

/**
 * Replace table.
 * @param {jQuery} $table - table jQuery element
 * @param {Array.<Array.<object>>} tableData - table data
 * @returns {jQuery}
 * @ignore
 */
function replaceTable($table, tableData) {
  var cellIndexData = _tableDataHandler2.default.createCellIndexData(tableData);
  var renderData = _tableDataHandler2.default.createRenderData(tableData, cellIndexData);
  var $newTable = (0, _jquery2.default)(createTableHtml(renderData));

  $table.replaceWith($newTable);

  return $newTable;
}

/**
 * Focus to cell.
 * @param {squireext} sq - squire instance
 * @param {range} range - range object
 * @param {HTMLElement} targetCell - cell element for focus
 * @ignore
 */
function focusToCell(sq, range, targetCell) {
  range.selectNodeContents(targetCell);
  range.collapse(true);
  sq.setSelection(range);
}

exports.default = {
  createTableHtml: createTableHtml,
  replaceTable: replaceTable,
  focusToCell: focusToCell
};

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _tableDataHandler = __webpack_require__(6);

var _tableDataHandler2 = _interopRequireDefault(_tableDataHandler);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Find unmerged table range.
 * @param {Array.<Array.<object>>} tableData - table data
 * @param {jQuery} $start - start talbe cell jQuery element
 * @param {jQuery} $end - end table cell jQuery element
 * @returns {{
 *   start: {rowIndex: number, colIndex: number},
 *   end: {rowIndex: number, colIndex: number}
 * }}
 * @private
 */
function _findUnmergedRange(tableData, $start, $end) {
  var cellIndexData = _tableDataHandler2.default.createCellIndexData(tableData);
  var startCellIndex = _tableDataHandler2.default.findCellIndex(cellIndexData, $start);
  var endCellIndex = _tableDataHandler2.default.findCellIndex(cellIndexData, $end);
  var startRowIndex = void 0,
      endRowIndex = void 0,
      startColIndex = void 0,
      endColIndex = void 0;

  if (startCellIndex.rowIndex > endCellIndex.rowIndex) {
    startRowIndex = endCellIndex.rowIndex;
    endRowIndex = startCellIndex.rowIndex;
  } else {
    startRowIndex = startCellIndex.rowIndex;
    endRowIndex = endCellIndex.rowIndex;
  }

  if (startCellIndex.colIndex > endCellIndex.colIndex) {
    startColIndex = endCellIndex.colIndex;
    endColIndex = startCellIndex.colIndex;
  } else {
    startColIndex = startCellIndex.colIndex;
    endColIndex = endCellIndex.colIndex;
  }

  return {
    start: {
      rowIndex: startRowIndex,
      colIndex: startColIndex
    },
    end: {
      rowIndex: endRowIndex,
      colIndex: endColIndex
    }
  };
}

/**
 * Expand table range by row merge properties like rowspan, rowMergeWith.
 * @param {Array.<Array.<object>>} tableData - table data
 * @param {{
 *   start: {rowIndex: number, colIndex: number},
 *   end: {rowIndex: number, colIndex: number}
 * }} tableRange - table range
 * @param {string} rangeType - range type like start, end
 * @private
 */
/**
* @fileoverview Implements tableRangeHandler
* @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
*/
function _expandRowMergedRange(tableData, tableRange, rangeType) {
  var rowIndex = tableRange[rangeType].rowIndex;

  var rowData = tableData[rowIndex];

  _tuiCodeSnippet2.default.range(tableRange.start.colIndex, tableRange.end.colIndex + 1).forEach(function (colIndex) {
    var cellData = rowData[colIndex];
    var rowMergeWith = cellData.rowMergeWith;

    var lastRowMergedIndex = -1;

    if (_tuiCodeSnippet2.default.isExisty(rowMergeWith)) {
      if (rowMergeWith < tableRange.start.rowIndex) {
        tableRange.start.rowIndex = rowMergeWith;
      }

      lastRowMergedIndex = rowMergeWith + tableData[rowMergeWith][colIndex].rowspan - 1;
    } else if (cellData.rowspan > 1) {
      lastRowMergedIndex = rowIndex + cellData.rowspan - 1;
    }

    if (lastRowMergedIndex > tableRange.end.rowIndex) {
      tableRange.end.rowIndex = lastRowMergedIndex;
    }
  });
}

/**
 * Expand table range by column merge properties like colspan, colMergeWith.
 * @param {Array.<Array.<object>>} tableData - table data
 * @param {{
 *   start: {rowIndex: number, colIndex: number},
 *   end: {rowIndex: number, colIndex: number}
 * }} tableRange - table range
 * @param {number} rowIndex - row index
 * @param {number} colIndex - column index
 * @private
 */
function _expandColMergedRange(tableData, tableRange, rowIndex, colIndex) {
  var rowData = tableData[rowIndex];
  var cellData = rowData[colIndex];
  var colMergeWith = cellData.colMergeWith;

  var lastColMergedIndex = -1;

  if (_tuiCodeSnippet2.default.isExisty(colMergeWith)) {
    if (colMergeWith < tableRange.start.colIndex) {
      tableRange.start.colIndex = colMergeWith;
    }

    lastColMergedIndex = colMergeWith + rowData[colMergeWith].colspan - 1;
  } else if (cellData.colspan > 1) {
    lastColMergedIndex = colIndex + cellData.colspan - 1;
  }

  if (lastColMergedIndex > tableRange.end.colIndex) {
    tableRange.end.colIndex = lastColMergedIndex;
  }
}

/**
 * Expand table range by merge properties like colspan, rowspan.
 * @param {Array.<Array.<object>>} tableData - table data
 * @param {{
 *   start: {rowIndex: number, colIndex: number},
 *   end: {rowIndex: number, colIndex: number}
 * }} tableRange - table range
 * @returns {{
 *   start: {rowIndex: number, colIndex: number},
 *   end: {rowIndex: number, colIndex: number}
 * }}
 * @private
 */
function _expandMergedRange(tableData, tableRange) {
  var rangeStr = '';

  while (rangeStr !== JSON.stringify(tableRange)) {
    rangeStr = JSON.stringify(tableRange);

    _expandRowMergedRange(tableData, tableRange, 'start');
    _expandRowMergedRange(tableData, tableRange, 'end');

    _tuiCodeSnippet2.default.range(tableRange.start.rowIndex, tableRange.end.rowIndex + 1).forEach(function (rowIndex) {
      _expandColMergedRange(tableData, tableRange, rowIndex, tableRange.start.colIndex);
      _expandColMergedRange(tableData, tableRange, rowIndex, tableRange.end.colIndex);
    });
  }

  return tableRange;
}

/**
 * Find table range for selection.
 * @param {Array.<Array.<object>>} tableData - table data
 * @param {jQuery} $start - start jQuery element
 * @param {jQuery} $end - end jQuery element
 * @returns {{
 *   start: {rowIndex: number, colIndex: number},
 *   end: {rowIndex: number, colIndex: number}
 * }}
 * @ignore
 */
function findSelectionRange(tableData, $start, $end) {
  var unmergedRange = _findUnmergedRange(tableData, $start, $end);

  return _expandMergedRange(tableData, unmergedRange);
}

/**
 * Get table selection range.
 * @param {Array.<Array.<object>>} tableData - table data
 * @param {jQuery} $selectedCells - selected cells jQuery elements
 * @param {jQuery} $startContainer - start container jQuery element of text range
 * @returns {{
 *   start: {rowIndex: number, colIndex: number},
 *   end: {rowIndex: number, colIndex: number}
 *}}
 * @ignore
 */
function getTableSelectionRange(tableData, $selectedCells, $startContainer) {
  var cellIndexData = _tableDataHandler2.default.createCellIndexData(tableData);
  var tableRange = {};

  if ($selectedCells.length) {
    var startRange = _tableDataHandler2.default.findCellIndex(cellIndexData, $selectedCells.first());
    var endRange = _tuiCodeSnippet2.default.extend({}, startRange);

    $selectedCells.each(function (index, cell) {
      var cellIndex = _tableDataHandler2.default.findCellIndex(cellIndexData, (0, _jquery2.default)(cell));
      var cellData = tableData[cellIndex.rowIndex][cellIndex.colIndex];
      var lastRowMergedIndex = cellIndex.rowIndex + cellData.rowspan - 1;
      var lastColMergedIndex = cellIndex.colIndex + cellData.colspan - 1;

      endRange.rowIndex = Math.max(endRange.rowIndex, lastRowMergedIndex);
      endRange.colIndex = Math.max(endRange.colIndex, lastColMergedIndex);
    });

    tableRange.start = startRange;
    tableRange.end = endRange;
  } else {
    var cellIndex = _tableDataHandler2.default.findCellIndex(cellIndexData, $startContainer);

    tableRange.start = cellIndex;
    tableRange.end = _tuiCodeSnippet2.default.extend({}, cellIndex);
  }

  return tableRange;
}

exports.default = {
  findSelectionRange: findSelectionRange,
  getTableSelectionRange: getTableSelectionRange
};

/***/ }),
/* 10 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_10__;

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// a duplex stream is just a stream that is both readable and writable.
// Since JS doesn't have multiple prototypal inheritance, this class
// prototypally inherits from Readable, and then parasitically from
// Writable.



/*<replacement>*/

var processNextTick = __webpack_require__(18);
/*</replacement>*/

/*<replacement>*/
var objectKeys = Object.keys || function (obj) {
  var keys = [];
  for (var key in obj) {
    keys.push(key);
  }return keys;
};
/*</replacement>*/

module.exports = Duplex;

/*<replacement>*/
var util = __webpack_require__(15);
util.inherits = __webpack_require__(13);
/*</replacement>*/

var Readable = __webpack_require__(46);
var Writable = __webpack_require__(26);

util.inherits(Duplex, Readable);

var keys = objectKeys(Writable.prototype);
for (var v = 0; v < keys.length; v++) {
  var method = keys[v];
  if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable.prototype[method];
}

function Duplex(options) {
  if (!(this instanceof Duplex)) return new Duplex(options);

  Readable.call(this, options);
  Writable.call(this, options);

  if (options && options.readable === false) this.readable = false;

  if (options && options.writable === false) this.writable = false;

  this.allowHalfOpen = true;
  if (options && options.allowHalfOpen === false) this.allowHalfOpen = false;

  this.once('end', onend);
}

// the no-half-open enforcer
function onend() {
  // if we allow half-open state, or if the writable side ended,
  // then we're ok.
  if (this.allowHalfOpen || this._writableState.ended) return;

  // no more data can be written.
  // But allow more writes to happen in this tick.
  processNextTick(onEndNT, this);
}

function onEndNT(self) {
  self.end();
}

Object.defineProperty(Duplex.prototype, 'destroyed', {
  get: function () {
    if (this._readableState === undefined || this._writableState === undefined) {
      return false;
    }
    return this._readableState.destroyed && this._writableState.destroyed;
  },
  set: function (value) {
    // we ignore the value if the stream
    // has not been initialized yet
    if (this._readableState === undefined || this._writableState === undefined) {
      return;
    }

    // backward compatibility, the user is explicitly
    // managing destroyed
    this._readableState.destroyed = value;
    this._writableState.destroyed = value;
  }
});

Duplex.prototype._destroy = function (err, cb) {
  this.push(null);
  this.end();

  processNextTick(cb, err);
};

function forEach(xs, f) {
  for (var i = 0, l = xs.length; i < l; i++) {
    f(xs[i], i);
  }
}

/***/ }),
/* 12 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || Function("return this")() || (1,eval)("this");
} catch(e) {
	// This works if the window reference is available
	if(typeof window === "object")
		g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 13 */
/***/ (function(module, exports) {

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    var TempCtor = function () {}
    TempCtor.prototype = superCtor.prototype
    ctor.prototype = new TempCtor()
    ctor.prototype.constructor = ctor
  }
}


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements ui controller
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _uiInstanceId = -1;

/**
 * get ui instance id
 * @returns {number} - new instance id
 * @ignore
 */
function makeUIInstanceId() {
  _uiInstanceId += 1;

  return _uiInstanceId;
}

/**
 * Class UIController
 */

var UIController = function () {

  /**
   * Creates an instance of UIController.
   * @param {Object} [options] - options
   * @param {jQuery} [options.rootElement] - root element
   * @param {string} [options.tagName] - tag name
   * @param {string} [options.className] - class name
   * @memberof UIController
   */


  /**
   * UI jQuery element
   * @type {Object}
   * @memberof UIController
   */

  /**
   * tag name
   * @type {string}
   * @memberof UIController
   */
  function UIController() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, UIController);

    options = _tuiCodeSnippet2.default.extend({
      tagName: 'div'
    }, options);

    this.tagName = options.tagName;

    this.className = options.className;

    this._id = makeUIInstanceId();

    this._setRootElement(options.rootElement);
  }

  /**
   * @param {string|object} aType - event name and selector string
   * @param {function} aFn - event handler
   * @memberof UIController
   */


  /**
   * UI Id
   * @type {number}
   * @private
   * @memberof UIController
   */


  /**
   * ui controller class name
   * @type {string}
   * @memberof UIController
   */


  _createClass(UIController, [{
    key: 'on',
    value: function on(aType, aFn) {
      var _this = this;

      if (_tuiCodeSnippet2.default.isObject(aType)) {
        _tuiCodeSnippet2.default.forEach(aType, function (fn, type) {
          _this._addEvent(type, fn);
        });
      } else {
        this._addEvent(aType, aFn);
      }
    }

    /**
     * bind event
     * @param {string} type - event name and selector
     * @param {function} fn - handler function
     * @memberof UIController
     * @private
     */

  }, {
    key: '_addEvent',
    value: function _addEvent(type, fn) {
      var _parseEventType2 = this._parseEventType(type),
          event = _parseEventType2.event,
          selector = _parseEventType2.selector;

      if (selector) {
        this.$el.on(event, selector, fn);
      } else {
        this.$el.on(event, fn);
      }
    }

    /**
     * unbind event handler
     * @param {string} type - event name and selector
     * @param {function} fn - handler function
     * @memberof UIController
     */

  }, {
    key: 'off',
    value: function off(type, fn) {
      if (type) {
        var _parseEventType3 = this._parseEventType(type),
            event = _parseEventType3.event,
            selector = _parseEventType3.selector;

        if (selector) {
          this.$el.off(event, selector, fn);
        } else {
          this.$el.off(event, fn);
        }
      } else {
        this.$el.off();
      }
    }

    /**
     * parse string into event name & selector
     * 'click td' => ['click', 'td]
     * @param {string} type - string to be parsed
     * @returns {Object} event, selector
     * @private
     */

  }, {
    key: '_parseEventType',
    value: function _parseEventType(type) {
      var splitType = type.split(' ');
      var event = splitType.shift();
      var selector = splitType.join(' ');

      return {
        event: event,
        selector: selector
      };
    }

    /**
     * set root element
     * @param {jQuery} $el - root jQuery element
     * @private
     */

  }, {
    key: '_setRootElement',
    value: function _setRootElement($el) {
      var tagName = this.tagName;
      var className = this.className;


      if (!$el) {
        className = className || 'uic' + this._id;
        $el = (0, _jquery2.default)('<' + tagName + ' class="' + className + '"/>');
      }
      this.$el = $el;
    }

    /**
     * trigger event
     * @param {...object} args - event name & extra params
     * @memberof UIController
     */

  }, {
    key: 'trigger',
    value: function trigger() {
      var _$el;

      (_$el = this.$el).trigger.apply(_$el, arguments);
    }
  }, {
    key: '_getEventNameWithNamespace',
    value: function _getEventNameWithNamespace(event) {
      var eventSplited = event.split(' ');
      eventSplited[0] += '.uicEvent' + this._id;

      return eventSplited.join(' ');
    }

    /**
     * remove
     * @memberof UIController
     */

  }, {
    key: 'remove',
    value: function remove() {
      if (this.$el) {
        this.$el.remove();
      }
    }

    /**
     * destroy
     * @memberof UIController
     */

  }, {
    key: 'destroy',
    value: function destroy() {
      var _this2 = this;

      this.remove();

      _tuiCodeSnippet2.default.forEachOwnProperties(this, function (value, key) {
        _this2[key] = null;
      });
    }
  }]);

  return UIController;
}();

exports.default = UIController;

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Buffer) {// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// NOTE: These type checking functions intentionally don't use `instanceof`
// because it is fragile and can be easily faked with `Object.create()`.

function isArray(arg) {
  if (Array.isArray) {
    return Array.isArray(arg);
  }
  return objectToString(arg) === '[object Array]';
}
exports.isArray = isArray;

function isBoolean(arg) {
  return typeof arg === 'boolean';
}
exports.isBoolean = isBoolean;

function isNull(arg) {
  return arg === null;
}
exports.isNull = isNull;

function isNullOrUndefined(arg) {
  return arg == null;
}
exports.isNullOrUndefined = isNullOrUndefined;

function isNumber(arg) {
  return typeof arg === 'number';
}
exports.isNumber = isNumber;

function isString(arg) {
  return typeof arg === 'string';
}
exports.isString = isString;

function isSymbol(arg) {
  return typeof arg === 'symbol';
}
exports.isSymbol = isSymbol;

function isUndefined(arg) {
  return arg === void 0;
}
exports.isUndefined = isUndefined;

function isRegExp(re) {
  return objectToString(re) === '[object RegExp]';
}
exports.isRegExp = isRegExp;

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}
exports.isObject = isObject;

function isDate(d) {
  return objectToString(d) === '[object Date]';
}
exports.isDate = isDate;

function isError(e) {
  return (objectToString(e) === '[object Error]' || e instanceof Error);
}
exports.isError = isError;

function isFunction(arg) {
  return typeof arg === 'function';
}
exports.isFunction = isFunction;

function isPrimitive(arg) {
  return arg === null ||
         typeof arg === 'boolean' ||
         typeof arg === 'number' ||
         typeof arg === 'string' ||
         typeof arg === 'symbol' ||  // ES6 symbol
         typeof arg === 'undefined';
}
exports.isPrimitive = isPrimitive;

exports.isBuffer = Buffer.isBuffer;

function objectToString(o) {
  return Object.prototype.toString.call(o);
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(49).Buffer))

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _uicontroller = __webpack_require__(14);

var _uicontroller2 = _interopRequireDefault(_uicontroller);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements Toolbar Item
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


/**
 * Toolbar Item
 * @extends {UIController}
 */
var ToolbarItem = function (_UIController) {
  _inherits(ToolbarItem, _UIController);

  /**
   * toolbar item constructor
   * @memberof ToolbarItem
   * @param {Object} [options={name: 'toolbar-item'}] [description]
   */

  /**
   * item name
   * @memberof ToolbarDivider
   * @type {String}
   * @static
   */
  function ToolbarItem() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
      name: ToolbarItem.name
    };

    _classCallCheck(this, ToolbarItem);

    var _this = _possibleConstructorReturn(this, (ToolbarItem.__proto__ || Object.getPrototypeOf(ToolbarItem)).call(this, _tuiCodeSnippet2.default.extend({
      className: ToolbarItem.className
    }, options)));

    _this._name = options.name;
    return _this;
  }

  /**
   * get the name of the toolbar item
   * @memberof ToolbarItem
   * @returns {string} - the name of the toolbar item
   */


  /**
   * toolbar item class name
   * @memberof ToolbarItem
   * @type {String}
   */


  _createClass(ToolbarItem, [{
    key: 'getName',
    value: function getName() {
      return this._name;
    }
  }]);

  return ToolbarItem;
}(_uicontroller2.default);

Object.defineProperty(ToolbarItem, 'name', {
  enumerable: true,
  writable: true,
  value: 'item'
});
Object.defineProperty(ToolbarItem, 'className', {
  enumerable: true,
  writable: true,
  value: 'tui-toolbar-item'
});
exports.default = ToolbarItem;

/***/ }),
/* 17 */
/***/ (function(module, exports) {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

if (!process.version ||
    process.version.indexOf('v0.') === 0 ||
    process.version.indexOf('v1.') === 0 && process.version.indexOf('v1.8.') !== 0) {
  module.exports = nextTick;
} else {
  module.exports = process.nextTick;
}

function nextTick(fn, arg1, arg2, arg3) {
  if (typeof fn !== 'function') {
    throw new TypeError('"callback" argument must be a function');
  }
  var len = arguments.length;
  var args, i;
  switch (len) {
  case 0:
  case 1:
    return process.nextTick(fn);
  case 2:
    return process.nextTick(function afterTickOne() {
      fn.call(null, arg1);
    });
  case 3:
    return process.nextTick(function afterTickTwo() {
      fn.call(null, arg1, arg2);
    });
  case 4:
    return process.nextTick(function afterTickThree() {
      fn.call(null, arg1, arg2, arg3);
    });
  default:
    args = new Array(len - 1);
    i = 0;
    while (i < args.length) {
      args[i++] = arguments[i];
    }
    return process.nextTick(function afterTick() {
      fn.apply(null, args);
    });
  }
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(17)))

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

/* eslint-disable node/no-deprecated-api */
var buffer = __webpack_require__(49)
var Buffer = buffer.Buffer

// alternative to using Object.keys for old browsers
function copyProps (src, dst) {
  for (var key in src) {
    dst[key] = src[key]
  }
}
if (Buffer.from && Buffer.alloc && Buffer.allocUnsafe && Buffer.allocUnsafeSlow) {
  module.exports = buffer
} else {
  // Copy properties from require('buffer')
  copyProps(buffer, exports)
  exports.Buffer = SafeBuffer
}

function SafeBuffer (arg, encodingOrOffset, length) {
  return Buffer(arg, encodingOrOffset, length)
}

// Copy static methods from Buffer
copyProps(Buffer, SafeBuffer)

SafeBuffer.from = function (arg, encodingOrOffset, length) {
  if (typeof arg === 'number') {
    throw new TypeError('Argument must not be a number')
  }
  return Buffer(arg, encodingOrOffset, length)
}

SafeBuffer.alloc = function (size, fill, encoding) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  var buf = Buffer(size)
  if (fill !== undefined) {
    if (typeof encoding === 'string') {
      buf.fill(fill, encoding)
    } else {
      buf.fill(fill)
    }
  } else {
    buf.fill(0)
  }
  return buf
}

SafeBuffer.allocUnsafe = function (size) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  return Buffer(size)
}

SafeBuffer.allocUnsafeSlow = function (size) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  return buffer.SlowBuffer(size)
}


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _toolbarItem = __webpack_require__(16);

var _toolbarItem2 = _interopRequireDefault(_toolbarItem);

var _tooltip = __webpack_require__(28);

var _tooltip2 = _interopRequireDefault(_tooltip);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements UI Button
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


/**
 * Class Button UI
 * @extends {ToolbarItem}
 * @deprecated
 */
var Button = function (_ToolbarItem) {
  _inherits(Button, _ToolbarItem);

  /**
   * Creates an instance of Button.
   * @param {object} options - button options
   *  @param {string} options.className - button class name
   *  @param {string} options.command - command name to execute on click
   *  @param {string} options.event - event name to trigger on click
   *  @param {string} options.text - text on button
   *  @param {string} options.tooltip - text on tooltip
   *  @param {string} options.style - button style
   *  @param {string} options.state - button state
   * @memberof Button
   */

  /**
   * item name
   * @memberof Button
   * @type {String}
   * @static
   */
  function Button() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
      tagName: 'button',
      name: Button.name
    };

    _classCallCheck(this, Button);

    var _this = _possibleConstructorReturn(this, (Button.__proto__ || Object.getPrototypeOf(Button)).call(this, {
      name: options.name,
      tagName: 'button',
      className: options.className + ' ' + Button.className,
      rootElement: options.$el
    }));

    _this._setOptions(options);

    _this._render();
    _this.on('click', _this._onClick.bind(_this));
    if (options.tooltip) {
      _this.on('mouseover', _this._onOver.bind(_this));
      _this.on('mouseout', _this._onOut.bind(_this));
    }
    return _this;
  }

  /**
   * ToolbarItem className
   * @type {String}
   * @memberof Button
   * @static
   */


  _createClass(Button, [{
    key: '_setOptions',
    value: function _setOptions(options) {
      this._command = options.command;
      this._event = options.event;
      this._text = options.text;
      this._tooltip = options.tooltip;
      this._style = options.style;
      this._state = options.state;
    }
  }, {
    key: '_render',
    value: function _render() {
      this.$el.text(this._text);
      this.$el.attr('type', 'button');

      if (this._style) {
        this.$el.attr('style', this._style);
      }
    }
  }, {
    key: '_onClick',
    value: function _onClick() {
      if (this._command) {
        this.trigger('command', this._command);
      } else if (this._event) {
        this.trigger('event', this._event);
      }

      this.trigger('clicked');
    }
  }, {
    key: '_onOver',
    value: function _onOver() {
      _tooltip2.default.show(this.$el, this._tooltip);
    }
  }, {
    key: '_onOut',
    value: function _onOut() {
      _tooltip2.default.hide();
    }
  }]);

  return Button;
}(_toolbarItem2.default);

Object.defineProperty(Button, 'name', {
  enumerable: true,
  writable: true,
  value: 'button'
});
Object.defineProperty(Button, 'className', {
  enumerable: true,
  writable: true,
  value: 'tui-toolbar-icons'
});
exports.default = Button;

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @fileoverview Implements KeyMapper
 * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */

/**
 * Constant of key mapping
 * @type {string[]}
 * @ignore
 */
var KEYBOARD_MAP = ['', // [0]
'', // [1]
'', // [2]
'CANCEL', // [3]
'', // [4]
'', // [5]
'HELP', // [6]
'', // [7]
'BACK_SPACE', // [8]
'TAB', // [9]
'', // [10]
'', // [11]
'CLEAR', // [12]
'ENTER', // [13]
'ENTER_SPECIAL', // [14]
'', // [15]
'', // [16] SHIFT
'', // [17] CONTROL
'', // [18] ALT
'PAUSE', // [19]
'CAPS_LOCK', // [20]
'KANA', // [21]
'EISU', // [22]
'JUNJA', // [23]
'FINAL', // [24]
'HANJA', // [25]
'', // [26]
'ESCAPE', // [27]
'CONVERT', // [28]
'NONCONVERT', // [29]
'ACCEPT', // [30]
'MODECHANGE', // [31]
'SPACE', // [32]
'PAGE_UP', // [33]
'PAGE_DOWN', // [34]
'END', // [35]
'HOME', // [36]
'LEFT', // [37]
'UP', // [38]
'RIGHT', // [39]
'DOWN', // [40]
'SELECT', // [41]
'PRINT', // [42]
'EXECUTE', // [43]
'PRINTSCREEN', // [44]
'INSERT', // [45]
'DELETE', // [46]
'', // [47]
'0', // [48]
'1', // [49]
'2', // [50]
'3', // [51]
'4', // [52]
'5', // [53]
'6', // [54]
'7', // [55]
'8', // [56]
'9', // [57]
':', // [58]
';', // [59]
'<', // [60]
'=', // [61]
'>', // [62]
'?', // [63]
'AT', // [64]
'A', // [65]
'B', // [66]
'C', // [67]
'D', // [68]
'E', // [69]
'F', // [70]
'G', // [71]
'H', // [72]
'I', // [73]
'J', // [74]
'K', // [75]
'L', // [76]
'M', // [77]
'N', // [78]
'O', // [79]
'P', // [80]
'Q', // [81]
'R', // [82]
'S', // [83]
'T', // [84]
'U', // [85]
'V', // [86]
'W', // [87]
'X', // [88]
'Y', // [89]
'Z', // [90]
'', // [91] META
'', // [92]
'CONTEXT_MENU', // [93]
'', // [94]
'SLEEP', // [95]
'NUMPAD0', // [96]
'NUMPAD1', // [97]
'NUMPAD2', // [98]
'NUMPAD3', // [99]
'NUMPAD4', // [100]
'NUMPAD5', // [101]
'NUMPAD6', // [102]
'NUMPAD7', // [103]
'NUMPAD8', // [104]
'NUMPAD9', // [105]
'MULTIPLY', // [106]
'ADD', // [107]
'SEPARATOR', // [108]
'SUBTRACT', // [109]
'DECIMAL', // [110]
'DIVIDE', // [111]
'F1', // [112]
'F2', // [113]
'F3', // [114]
'F4', // [115]
'F5', // [116]
'F6', // [117]
'F7', // [118]
'F8', // [119]
'F9', // [120]
'F10', // [121]
'F11', // [122]
'F12', // [123]
'F13', // [124]
'F14', // [125]
'F15', // [126]
'F16', // [127]
'F17', // [128]
'F18', // [129]
'F19', // [130]
'F20', // [131]
'F21', // [132]
'F22', // [133]
'F23', // [134]
'F24', // [135]
'', // [136]
'', // [137]
'', // [138]
'', // [139]
'', // [140]
'', // [141]
'', // [142]
'', // [143]
'NUM_LOCK', // [144]
'SCROLL_LOCK', // [145]
'WIN_OEM_FJ_JISHO', // [146]
'WIN_OEM_FJ_MASSHOU', // [147]
'WIN_OEM_FJ_TOUROKU', // [148]
'WIN_OEM_FJ_LOYA', // [149]
'WIN_OEM_FJ_ROYA', // [150]
'', // [151]
'', // [152]
'', // [153]
'', // [154]
'', // [155]
'', // [156]
'', // [157]
'', // [158]
'', // [159]
'@', // [160]
'!', // [161]
'"', // [162]
'#', // [163]
'$', // [164]
'%', // [165]
'&', // [166]
'_', // [167]
'(', // [168]
')', // [169]
'*', // [170]
'+', // [171]
'|', // [172]
'-', // [173]
'{', // [174]
'}', // [175]
'~', // [176]
'', // [177]
'', // [178]
'', // [179]
'', // [180]
'VOLUME_MUTE', // [181]
'VOLUME_DOWN', // [182]
'VOLUME_UP', // [183]
'', // [184]
'', // [185]
';', // [186]
'=', // [187]
',', // [188]
'-', // [189]
'.', // [190]
'/', // [191]
'`', // [192]
'', // [193]
'', // [194]
'', // [195]
'', // [196]
'', // [197]
'', // [198]
'', // [199]
'', // [200]
'', // [201]
'', // [202]
'', // [203]
'', // [204]
'', // [205]
'', // [206]
'', // [207]
'', // [208]
'', // [209]
'', // [210]
'', // [211]
'', // [212]
'', // [213]
'', // [214]
'', // [215]
'', // [216]
'', // [217]
'', // [218]
'[', // [219]
'\\', // [220]
']', // [221]
'\'', // [222]
'', // [223]
'META', // [224]
'ALTGR', // [225]
'', // [226]
'WIN_ICO_HELP', // [227]
'WIN_ICO_00', // [228]
'', // [229]
'WIN_ICO_CLEAR', // [230]
'', // [231]
'', // [232]
'WIN_OEM_RESET', // [233]
'WIN_OEM_JUMP', // [234]
'WIN_OEM_PA1', // [235]
'WIN_OEM_PA2', // [236]
'WIN_OEM_PA3', // [237]
'WIN_OEM_WSCTRL', // [238]
'WIN_OEM_CUSEL', // [239]
'WIN_OEM_ATTN', // [240]
'WIN_OEM_FINISH', // [241]
'WIN_OEM_COPY', // [242]
'WIN_OEM_AUTO', // [243]
'WIN_OEM_ENLW', // [244]
'WIN_OEM_BACKTAB', // [245]
'ATTN', // [246]
'CRSEL', // [247]
'EXSEL', // [248]
'EREOF', // [249]
'PLAY', // [250]
'ZOOM', // [251]
'', // [252]
'PA1', // [253]
'WIN_OEM_CLEAR', // [254]
'' // [255]
];

var sharedInstance = void 0;

/**
 * Class KeyMapper
 */

var KeyMapper = function () {
  /**
   * Creates an instance of KeyMapper.
   * @param {object} [options] options
   *  @param {string} options.splitter splitter string default is +
   * @memberof KeyMapper
   */
  function KeyMapper(options) {
    _classCallCheck(this, KeyMapper);

    this._setSplitter(options);
  }

  /**
   * Set key splitter
   * @param {object} options Option object
   * @memberof KeyMapper
   * @private
   */


  _createClass(KeyMapper, [{
    key: '_setSplitter',
    value: function _setSplitter(options) {
      var splitter = options ? options.splitter : '+';
      this._splitter = splitter;
    }

    /**
     * Convert event to keyMap
     * @memberof KeyMapper
     * @param {event} event Event object
     * @returns {string}
     */

  }, {
    key: 'convert',
    value: function convert(event) {
      var keyMap = [];

      if (event.shiftKey) {
        keyMap.push('SHIFT');
      }

      if (event.ctrlKey) {
        keyMap.push('CTRL');
      }

      if (event.metaKey) {
        keyMap.push('META');
      }

      if (event.altKey) {
        keyMap.push('ALT');
      }

      var keyChar = this._getKeyCodeChar(event.keyCode);

      if (keyChar) {
        keyMap.push(keyChar);
      }

      return keyMap.join(this._splitter);
    }

    /**
     * Get character from key code
     * @memberof KeyMapper
     * @param {number} keyCode Key code
     * @returns {string}
     * @private
     */

  }, {
    key: '_getKeyCodeChar',
    value: function _getKeyCodeChar(keyCode) {
      var keyCodeCharacter = KEYBOARD_MAP[keyCode];

      return keyCodeCharacter;
    }

    /**
     * Get sharedInstance
     * @memberof KeyMapper
     * @returns {KeyMapper}
     */

  }], [{
    key: 'getSharedInstance',
    value: function getSharedInstance() {
      if (!sharedInstance) {
        sharedInstance = new KeyMapper();
      }

      return sharedInstance;
    }

    /**
     * get key code for a character
     * @static
     * @param {string} char - a character to be converted
     * @returns {number} key code for the char
     * @memberof KeyMapper
     */

  }, {
    key: 'keyCode',
    value: function keyCode(char) {
      return KEYBOARD_MAP.indexOf(char);
    }
  }]);

  return KeyMapper;
}();

exports.default = KeyMapper;

/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implement Module for managing import external data such as image
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var URLRegex = /^(https?:\/\/)?([\da-z.-]+)\.([a-z.]{2,6})(\/([^\s]*))?$/g;

/**
 * Class ImportManager
 */

var ImportManager = function () {
  /**
   * Creates an instance of ImportManager.
   * @param {EventManager} eventManager - eventManager
   * @memberof ImportManager
   */
  function ImportManager(eventManager) {
    _classCallCheck(this, ImportManager);

    this.eventManager = eventManager;
    this._lastState = null;

    this._initEvent();
    this._initDefaultImageImporter();
  }

  /**
   * graceful decode uri component
   * @param {string} originalURI - string to be decoded
   * @returns {string} decoded string
   * @memberof ImportManager
   * @static
   */


  _createClass(ImportManager, [{
    key: '_initEvent',


    /**
     * Initialize event handler
     * @memberof ImportManager
     * @private
     */
    value: function _initEvent() {
      var _this = this;

      this.eventManager.listen('stateChange', function (ev) {
        _this._lastState = ev;
      });

      this.eventManager.listen('drop', function (ev) {
        var items = ev.data.dataTransfer && ev.data.dataTransfer.files;
        _this._processBlobItems(items, ev.data);
      });

      this.eventManager.listen('willPaste', function (ev) {
        // IE has no interface to handle clipboard image. #976
        var fragment = ev.data.fragment;
        var descendant = fragment.querySelectorAll('*');
        // only if paste event data has one img element and the element has base64 encoded image
        if (descendant.length !== 1 || descendant[0].tagName !== 'IMG' || !/^data:image/.test(descendant[0].src)) {
          return;
        }
        ev.data.preventDefault();

        var blob = dataURItoBlob(descendant[0].src);
        _this._emitAddImageBlobHook(blob, 'paste');
      });

      this.eventManager.listen('paste', function (ev) {
        _this._processClipboard(ev.data);
      });

      this.eventManager.listen('pasteBefore', function (ev) {
        _this._decodeURL(ev);
      });
    }

    /**
     * Initialize default image importer
     * @memberof ImportManager
     * @private
     */

  }, {
    key: '_initDefaultImageImporter',
    value: function _initDefaultImageImporter() {
      this.eventManager.listen('addImageBlobHook', function (blob, callback) {
        var reader = new FileReader();

        reader.onload = function (event) {
          callback(event.target.result);
        };

        reader.readAsDataURL(blob);
      });
    }

    /**
     * Emit add image blob hook
     * @memberof ImportManager
     * @param {object} blob - blob or file
     * @param {string} type - type of an event the item belongs to. paste or drop
     * @private
     */

  }, {
    key: '_emitAddImageBlobHook',
    value: function _emitAddImageBlobHook(blob, type) {
      var _this2 = this;

      this.eventManager.emit('addImageBlobHook', blob, function (imageUrl, altText) {
        _this2.eventManager.emit('command', 'AddImage', {
          imageUrl: imageUrl,
          altText: altText || blob.name || 'image'
        });
      }, type);
    }

    /**
     * Decode url when paste link
     * @param {object} ev - event object
     * @private
     */

  }, {
    key: '_decodeURL',
    value: function _decodeURL(ev) {
      var decodeURIGraceful = ImportManager.decodeURIGraceful,
          encodeMarkdownCharacters = ImportManager.encodeMarkdownCharacters;


      if (ev.source === 'markdown' && ev.data.text) {
        var texts = ev.data.text;
        var text = texts[0];
        if (texts.length === 1 && text.match(URLRegex)) {
          text = decodeURIGraceful(text);
          text = encodeMarkdownCharacters(text);
          ev.data.update(null, null, [text]);
        }
      } else if (ev.source === 'wysiwyg') {
        var container = ev.$clipboardContainer.get(0);
        var firstChild = container.childNodes[0];
        var _text = firstChild.innerText;
        if (container.childNodes.length === 1 && firstChild.tagName === 'A' && _text.match(URLRegex)) {
          firstChild.innerText = decodeURIGraceful(_text);
          firstChild.href = encodeMarkdownCharacters(firstChild.href);
        }
      }
    }

    /**
     * Get blob or excel data from clipboard
     * @memberof ImportManager
     * @param {object} evData Clipboard data
     * @private
     */

  }, {
    key: '_processClipboard',
    value: function _processClipboard(evData) {
      var cbData = evData.clipboardData || window.clipboardData;
      var blobItems = cbData && cbData.items;
      var types = cbData.types;


      if (blobItems && types && types.length === 1 && _tuiCodeSnippet2.default.inArray('Files', [].slice.call(types)) !== -1) {
        this._processBlobItems(blobItems, evData);
      }
    }

    /**
     * Process for blob item
     * @memberof ImportManager
     * @param {Array.<string>} items Item array
     * @param {object} evData Event data
     * @private
     */

  }, {
    key: '_processBlobItems',
    value: function _processBlobItems(items, evData) {
      var _this3 = this;

      if (items) {
        _tuiCodeSnippet2.default.forEachArray(items, function (item) {
          if (item.type.indexOf('image') !== -1) {
            evData.preventDefault();
            evData.stopPropagation();
            evData.codemirrorIgnore = true;

            var blob = item.name ? item : item.getAsFile(); // Blob or File
            _this3._emitAddImageBlobHook(blob, evData.type);

            return false;
          }

          return true;
        });
      }
    }

    /**
     * Returns if current cursor state is in block format ex) blockquote, list, task, codeblock
     * @returns {boolean}
     * @private
     */

  }, {
    key: '_isInBlockFormat',
    value: function _isInBlockFormat() {
      var state = this._lastState;

      return state && (state.codeBlock || state.list || state.task || state.code);
    }
  }], [{
    key: 'decodeURIGraceful',
    value: function decodeURIGraceful(originalURI) {
      var uris = originalURI.split(' ');
      var decodedURIs = [];
      var decodedURI = void 0;

      _tuiCodeSnippet2.default.forEachArray(uris, function (uri) {
        try {
          decodedURI = decodeURIComponent(uri);
          decodedURI = decodedURI.replace(/ /g, '%20');
        } catch (e) {
          decodedURI = uri;
        }

        return decodedURIs.push(decodedURI);
      });

      return decodedURIs.join(' ');
    }

    /**
     * encode markdown critical characters
     * @static
     * @param {string} text - string to encode
     * @returns {string} - markdown character encoded string
     * @memberof ImportManager
     */

  }, {
    key: 'encodeMarkdownCharacters',
    value: function encodeMarkdownCharacters(text) {
      return text.replace(/\(/g, '%28').replace(/\)/g, '%29').replace(/\[/g, '%5B').replace(/\]/g, '%5D').replace(/</g, '%3C').replace(/>/g, '%3E');
    }

    /**
     * escape markdown critical characters
     * @static
     * @param {string} text - string to escape
     * @returns {string} - markdown character escaped string
     * @memberof ImportManager
     */

  }, {
    key: 'escapeMarkdownCharacters',
    value: function escapeMarkdownCharacters(text) {
      return text.replace(/\(/g, '\\(').replace(/\)/g, '\\)').replace(/\[/g, '\\[').replace(/\]/g, '\\]').replace(/</g, '\\<').replace(/>/g, '\\>');
    }
  }]);

  return ImportManager;
}();

/**
 * data URI to Blob
 * @param {string} dataURI - data URI string
 * @returns {Blob} - blob data
 * @ignore
 */


function dataURItoBlob(dataURI) {
  var byteString = atob(dataURI.split(',')[1]);
  var mimeString = dataURI.split(',')[0].split(':')[1].split(';')[0];
  var ab = new ArrayBuffer(byteString.length);
  var ia = new Uint8Array(ab);
  for (var i = 0; i < byteString.length; i += 1) {
    ia[i] = byteString.charCodeAt(i);
  }
  var blob = new Blob([ab], { type: mimeString });

  return blob;
}

exports.default = ImportManager;

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CodeBlockManager = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements CodeBlockManager
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _highlight = __webpack_require__(89);

var _highlight2 = _interopRequireDefault(_highlight);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Class Code Block Manager
 */
var CodeBlockManager = function () {
  /**
   * Creates an instance of CodeBlockManager.
   * @memberof CodeBlockManager
   */
  function CodeBlockManager() {
    _classCallCheck(this, CodeBlockManager);

    this._replacers = {};
  }

  /**
   * Set replacer for code block
   * @param {string} language - code block language
   * @param {function} replacer - replacer function to code block element
   */


  _createClass(CodeBlockManager, [{
    key: 'setReplacer',
    value: function setReplacer(language, replacer) {
      this._replacers[language] = replacer;
    }

    /**
     * get replacer for code block
     * @param {string} language - code block type
     * @returns {function} - replacer function
     * @memberof CodeBlockManager
     */

  }, {
    key: 'getReplacer',
    value: function getReplacer(language) {
      return this._replacers[language];
    }

    /**
     * Create code block html.
     * @param {string} language - code block language
     * @param {string} codeText - code text
     * @returns {string}
     */

  }, {
    key: 'createCodeBlockHtml',
    value: function createCodeBlockHtml(language, codeText) {
      var replacer = this.getReplacer(language);
      var html = void 0;

      if (replacer) {
        html = replacer(codeText, language);
      } else {
        html = _highlight2.default.getLanguage(language) ? _highlight2.default.highlight(language, codeText).value : escape(codeText, false);
      }

      return html;
    }

    /**
     * get supported languages by highlight-js
     * @returns {Array<string>} - supported languages by highlight-js
     * @static
     */

  }], [{
    key: 'getHighlightJSLanguages',
    value: function getHighlightJSLanguages() {
      return _highlight2.default.listLanguages();
    }
  }]);

  return CodeBlockManager;
}();

/**
 * escape code from markdown-it
 * @param {string} html HTML string
 * @param {string} encode Boolean value of whether encode or not
 * @returns {string}
 * @ignore
 */


function escape(html, encode) {
  return html.replace(!encode ? /&(?!#?\w+;)/g : /&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
}

exports.CodeBlockManager = CodeBlockManager;
exports.default = new CodeBlockManager();

/***/ }),
/* 24 */
/***/ (function(module, exports) {

// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

function EventEmitter() {
  this._events = this._events || {};
  this._maxListeners = this._maxListeners || undefined;
}
module.exports = EventEmitter;

// Backwards-compat with node 0.10.x
EventEmitter.EventEmitter = EventEmitter;

EventEmitter.prototype._events = undefined;
EventEmitter.prototype._maxListeners = undefined;

// By default EventEmitters will print a warning if more than 10 listeners are
// added to it. This is a useful default which helps finding memory leaks.
EventEmitter.defaultMaxListeners = 10;

// Obviously not all Emitters should be limited to 10. This function allows
// that to be increased. Set to zero for unlimited.
EventEmitter.prototype.setMaxListeners = function(n) {
  if (!isNumber(n) || n < 0 || isNaN(n))
    throw TypeError('n must be a positive number');
  this._maxListeners = n;
  return this;
};

EventEmitter.prototype.emit = function(type) {
  var er, handler, len, args, i, listeners;

  if (!this._events)
    this._events = {};

  // If there is no 'error' event listener then throw.
  if (type === 'error') {
    if (!this._events.error ||
        (isObject(this._events.error) && !this._events.error.length)) {
      er = arguments[1];
      if (er instanceof Error) {
        throw er; // Unhandled 'error' event
      } else {
        // At least give some kind of context to the user
        var err = new Error('Uncaught, unspecified "error" event. (' + er + ')');
        err.context = er;
        throw err;
      }
    }
  }

  handler = this._events[type];

  if (isUndefined(handler))
    return false;

  if (isFunction(handler)) {
    switch (arguments.length) {
      // fast cases
      case 1:
        handler.call(this);
        break;
      case 2:
        handler.call(this, arguments[1]);
        break;
      case 3:
        handler.call(this, arguments[1], arguments[2]);
        break;
      // slower
      default:
        args = Array.prototype.slice.call(arguments, 1);
        handler.apply(this, args);
    }
  } else if (isObject(handler)) {
    args = Array.prototype.slice.call(arguments, 1);
    listeners = handler.slice();
    len = listeners.length;
    for (i = 0; i < len; i++)
      listeners[i].apply(this, args);
  }

  return true;
};

EventEmitter.prototype.addListener = function(type, listener) {
  var m;

  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  if (!this._events)
    this._events = {};

  // To avoid recursion in the case that type === "newListener"! Before
  // adding it to the listeners, first emit "newListener".
  if (this._events.newListener)
    this.emit('newListener', type,
              isFunction(listener.listener) ?
              listener.listener : listener);

  if (!this._events[type])
    // Optimize the case of one listener. Don't need the extra array object.
    this._events[type] = listener;
  else if (isObject(this._events[type]))
    // If we've already got an array, just append.
    this._events[type].push(listener);
  else
    // Adding the second element, need to change to array.
    this._events[type] = [this._events[type], listener];

  // Check for listener leak
  if (isObject(this._events[type]) && !this._events[type].warned) {
    if (!isUndefined(this._maxListeners)) {
      m = this._maxListeners;
    } else {
      m = EventEmitter.defaultMaxListeners;
    }

    if (m && m > 0 && this._events[type].length > m) {
      this._events[type].warned = true;
      console.error('(node) warning: possible EventEmitter memory ' +
                    'leak detected. %d listeners added. ' +
                    'Use emitter.setMaxListeners() to increase limit.',
                    this._events[type].length);
      if (typeof console.trace === 'function') {
        // not supported in IE 10
        console.trace();
      }
    }
  }

  return this;
};

EventEmitter.prototype.on = EventEmitter.prototype.addListener;

EventEmitter.prototype.once = function(type, listener) {
  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  var fired = false;

  function g() {
    this.removeListener(type, g);

    if (!fired) {
      fired = true;
      listener.apply(this, arguments);
    }
  }

  g.listener = listener;
  this.on(type, g);

  return this;
};

// emits a 'removeListener' event iff the listener was removed
EventEmitter.prototype.removeListener = function(type, listener) {
  var list, position, length, i;

  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  if (!this._events || !this._events[type])
    return this;

  list = this._events[type];
  length = list.length;
  position = -1;

  if (list === listener ||
      (isFunction(list.listener) && list.listener === listener)) {
    delete this._events[type];
    if (this._events.removeListener)
      this.emit('removeListener', type, listener);

  } else if (isObject(list)) {
    for (i = length; i-- > 0;) {
      if (list[i] === listener ||
          (list[i].listener && list[i].listener === listener)) {
        position = i;
        break;
      }
    }

    if (position < 0)
      return this;

    if (list.length === 1) {
      list.length = 0;
      delete this._events[type];
    } else {
      list.splice(position, 1);
    }

    if (this._events.removeListener)
      this.emit('removeListener', type, listener);
  }

  return this;
};

EventEmitter.prototype.removeAllListeners = function(type) {
  var key, listeners;

  if (!this._events)
    return this;

  // not listening for removeListener, no need to emit
  if (!this._events.removeListener) {
    if (arguments.length === 0)
      this._events = {};
    else if (this._events[type])
      delete this._events[type];
    return this;
  }

  // emit removeListener for all listeners on all events
  if (arguments.length === 0) {
    for (key in this._events) {
      if (key === 'removeListener') continue;
      this.removeAllListeners(key);
    }
    this.removeAllListeners('removeListener');
    this._events = {};
    return this;
  }

  listeners = this._events[type];

  if (isFunction(listeners)) {
    this.removeListener(type, listeners);
  } else if (listeners) {
    // LIFO order
    while (listeners.length)
      this.removeListener(type, listeners[listeners.length - 1]);
  }
  delete this._events[type];

  return this;
};

EventEmitter.prototype.listeners = function(type) {
  var ret;
  if (!this._events || !this._events[type])
    ret = [];
  else if (isFunction(this._events[type]))
    ret = [this._events[type]];
  else
    ret = this._events[type].slice();
  return ret;
};

EventEmitter.prototype.listenerCount = function(type) {
  if (this._events) {
    var evlistener = this._events[type];

    if (isFunction(evlistener))
      return 1;
    else if (evlistener)
      return evlistener.length;
  }
  return 0;
};

EventEmitter.listenerCount = function(emitter, type) {
  return emitter.listenerCount(type);
};

function isFunction(arg) {
  return typeof arg === 'function';
}

function isNumber(arg) {
  return typeof arg === 'number';
}

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}

function isUndefined(arg) {
  return arg === void 0;
}


/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(46);
exports.Stream = exports;
exports.Readable = exports;
exports.Writable = __webpack_require__(26);
exports.Duplex = __webpack_require__(11);
exports.Transform = __webpack_require__(52);
exports.PassThrough = __webpack_require__(167);


/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process, setImmediate, global) {// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// A bit simpler than readable streams.
// Implement an async ._write(chunk, encoding, cb), and it'll handle all
// the drain event emission and buffering.



/*<replacement>*/

var processNextTick = __webpack_require__(18);
/*</replacement>*/

module.exports = Writable;

/* <replacement> */
function WriteReq(chunk, encoding, cb) {
  this.chunk = chunk;
  this.encoding = encoding;
  this.callback = cb;
  this.next = null;
}

// It seems a linked list but it is not
// there will be only 2 of these for each stream
function CorkedRequest(state) {
  var _this = this;

  this.next = null;
  this.entry = null;
  this.finish = function () {
    onCorkedFinish(_this, state);
  };
}
/* </replacement> */

/*<replacement>*/
var asyncWrite = !process.browser && ['v0.10', 'v0.9.'].indexOf(process.version.slice(0, 5)) > -1 ? setImmediate : processNextTick;
/*</replacement>*/

/*<replacement>*/
var Duplex;
/*</replacement>*/

Writable.WritableState = WritableState;

/*<replacement>*/
var util = __webpack_require__(15);
util.inherits = __webpack_require__(13);
/*</replacement>*/

/*<replacement>*/
var internalUtil = {
  deprecate: __webpack_require__(166)
};
/*</replacement>*/

/*<replacement>*/
var Stream = __webpack_require__(48);
/*</replacement>*/

/*<replacement>*/
var Buffer = __webpack_require__(19).Buffer;
var OurUint8Array = global.Uint8Array || function () {};
function _uint8ArrayToBuffer(chunk) {
  return Buffer.from(chunk);
}
function _isUint8Array(obj) {
  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
}
/*</replacement>*/

var destroyImpl = __webpack_require__(50);

util.inherits(Writable, Stream);

function nop() {}

function WritableState(options, stream) {
  Duplex = Duplex || __webpack_require__(11);

  options = options || {};

  // object stream flag to indicate whether or not this stream
  // contains buffers or objects.
  this.objectMode = !!options.objectMode;

  if (stream instanceof Duplex) this.objectMode = this.objectMode || !!options.writableObjectMode;

  // the point at which write() starts returning false
  // Note: 0 is a valid value, means that we always return false if
  // the entire buffer is not flushed immediately on write()
  var hwm = options.highWaterMark;
  var defaultHwm = this.objectMode ? 16 : 16 * 1024;
  this.highWaterMark = hwm || hwm === 0 ? hwm : defaultHwm;

  // cast to ints.
  this.highWaterMark = Math.floor(this.highWaterMark);

  // if _final has been called
  this.finalCalled = false;

  // drain event flag.
  this.needDrain = false;
  // at the start of calling end()
  this.ending = false;
  // when end() has been called, and returned
  this.ended = false;
  // when 'finish' is emitted
  this.finished = false;

  // has it been destroyed
  this.destroyed = false;

  // should we decode strings into buffers before passing to _write?
  // this is here so that some node-core streams can optimize string
  // handling at a lower level.
  var noDecode = options.decodeStrings === false;
  this.decodeStrings = !noDecode;

  // Crypto is kind of old and crusty.  Historically, its default string
  // encoding is 'binary' so we have to make this configurable.
  // Everything else in the universe uses 'utf8', though.
  this.defaultEncoding = options.defaultEncoding || 'utf8';

  // not an actual buffer we keep track of, but a measurement
  // of how much we're waiting to get pushed to some underlying
  // socket or file.
  this.length = 0;

  // a flag to see when we're in the middle of a write.
  this.writing = false;

  // when true all writes will be buffered until .uncork() call
  this.corked = 0;

  // a flag to be able to tell if the onwrite cb is called immediately,
  // or on a later tick.  We set this to true at first, because any
  // actions that shouldn't happen until "later" should generally also
  // not happen before the first write call.
  this.sync = true;

  // a flag to know if we're processing previously buffered items, which
  // may call the _write() callback in the same tick, so that we don't
  // end up in an overlapped onwrite situation.
  this.bufferProcessing = false;

  // the callback that's passed to _write(chunk,cb)
  this.onwrite = function (er) {
    onwrite(stream, er);
  };

  // the callback that the user supplies to write(chunk,encoding,cb)
  this.writecb = null;

  // the amount that is being written when _write is called.
  this.writelen = 0;

  this.bufferedRequest = null;
  this.lastBufferedRequest = null;

  // number of pending user-supplied write callbacks
  // this must be 0 before 'finish' can be emitted
  this.pendingcb = 0;

  // emit prefinish if the only thing we're waiting for is _write cbs
  // This is relevant for synchronous Transform streams
  this.prefinished = false;

  // True if the error was already emitted and should not be thrown again
  this.errorEmitted = false;

  // count buffered requests
  this.bufferedRequestCount = 0;

  // allocate the first CorkedRequest, there is always
  // one allocated and free to use, and we maintain at most two
  this.corkedRequestsFree = new CorkedRequest(this);
}

WritableState.prototype.getBuffer = function getBuffer() {
  var current = this.bufferedRequest;
  var out = [];
  while (current) {
    out.push(current);
    current = current.next;
  }
  return out;
};

(function () {
  try {
    Object.defineProperty(WritableState.prototype, 'buffer', {
      get: internalUtil.deprecate(function () {
        return this.getBuffer();
      }, '_writableState.buffer is deprecated. Use _writableState.getBuffer ' + 'instead.', 'DEP0003')
    });
  } catch (_) {}
})();

// Test _writableState for inheritance to account for Duplex streams,
// whose prototype chain only points to Readable.
var realHasInstance;
if (typeof Symbol === 'function' && Symbol.hasInstance && typeof Function.prototype[Symbol.hasInstance] === 'function') {
  realHasInstance = Function.prototype[Symbol.hasInstance];
  Object.defineProperty(Writable, Symbol.hasInstance, {
    value: function (object) {
      if (realHasInstance.call(this, object)) return true;

      return object && object._writableState instanceof WritableState;
    }
  });
} else {
  realHasInstance = function (object) {
    return object instanceof this;
  };
}

function Writable(options) {
  Duplex = Duplex || __webpack_require__(11);

  // Writable ctor is applied to Duplexes, too.
  // `realHasInstance` is necessary because using plain `instanceof`
  // would return false, as no `_writableState` property is attached.

  // Trying to use the custom `instanceof` for Writable here will also break the
  // Node.js LazyTransform implementation, which has a non-trivial getter for
  // `_writableState` that would lead to infinite recursion.
  if (!realHasInstance.call(Writable, this) && !(this instanceof Duplex)) {
    return new Writable(options);
  }

  this._writableState = new WritableState(options, this);

  // legacy.
  this.writable = true;

  if (options) {
    if (typeof options.write === 'function') this._write = options.write;

    if (typeof options.writev === 'function') this._writev = options.writev;

    if (typeof options.destroy === 'function') this._destroy = options.destroy;

    if (typeof options.final === 'function') this._final = options.final;
  }

  Stream.call(this);
}

// Otherwise people can pipe Writable streams, which is just wrong.
Writable.prototype.pipe = function () {
  this.emit('error', new Error('Cannot pipe, not readable'));
};

function writeAfterEnd(stream, cb) {
  var er = new Error('write after end');
  // TODO: defer error events consistently everywhere, not just the cb
  stream.emit('error', er);
  processNextTick(cb, er);
}

// Checks that a user-supplied chunk is valid, especially for the particular
// mode the stream is in. Currently this means that `null` is never accepted
// and undefined/non-string values are only allowed in object mode.
function validChunk(stream, state, chunk, cb) {
  var valid = true;
  var er = false;

  if (chunk === null) {
    er = new TypeError('May not write null values to stream');
  } else if (typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
    er = new TypeError('Invalid non-string/buffer chunk');
  }
  if (er) {
    stream.emit('error', er);
    processNextTick(cb, er);
    valid = false;
  }
  return valid;
}

Writable.prototype.write = function (chunk, encoding, cb) {
  var state = this._writableState;
  var ret = false;
  var isBuf = _isUint8Array(chunk) && !state.objectMode;

  if (isBuf && !Buffer.isBuffer(chunk)) {
    chunk = _uint8ArrayToBuffer(chunk);
  }

  if (typeof encoding === 'function') {
    cb = encoding;
    encoding = null;
  }

  if (isBuf) encoding = 'buffer';else if (!encoding) encoding = state.defaultEncoding;

  if (typeof cb !== 'function') cb = nop;

  if (state.ended) writeAfterEnd(this, cb);else if (isBuf || validChunk(this, state, chunk, cb)) {
    state.pendingcb++;
    ret = writeOrBuffer(this, state, isBuf, chunk, encoding, cb);
  }

  return ret;
};

Writable.prototype.cork = function () {
  var state = this._writableState;

  state.corked++;
};

Writable.prototype.uncork = function () {
  var state = this._writableState;

  if (state.corked) {
    state.corked--;

    if (!state.writing && !state.corked && !state.finished && !state.bufferProcessing && state.bufferedRequest) clearBuffer(this, state);
  }
};

Writable.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
  // node::ParseEncoding() requires lower case.
  if (typeof encoding === 'string') encoding = encoding.toLowerCase();
  if (!(['hex', 'utf8', 'utf-8', 'ascii', 'binary', 'base64', 'ucs2', 'ucs-2', 'utf16le', 'utf-16le', 'raw'].indexOf((encoding + '').toLowerCase()) > -1)) throw new TypeError('Unknown encoding: ' + encoding);
  this._writableState.defaultEncoding = encoding;
  return this;
};

function decodeChunk(state, chunk, encoding) {
  if (!state.objectMode && state.decodeStrings !== false && typeof chunk === 'string') {
    chunk = Buffer.from(chunk, encoding);
  }
  return chunk;
}

// if we're already writing something, then just put this
// in the queue, and wait our turn.  Otherwise, call _write
// If we return false, then we need a drain event, so set that flag.
function writeOrBuffer(stream, state, isBuf, chunk, encoding, cb) {
  if (!isBuf) {
    var newChunk = decodeChunk(state, chunk, encoding);
    if (chunk !== newChunk) {
      isBuf = true;
      encoding = 'buffer';
      chunk = newChunk;
    }
  }
  var len = state.objectMode ? 1 : chunk.length;

  state.length += len;

  var ret = state.length < state.highWaterMark;
  // we must ensure that previous needDrain will not be reset to false.
  if (!ret) state.needDrain = true;

  if (state.writing || state.corked) {
    var last = state.lastBufferedRequest;
    state.lastBufferedRequest = {
      chunk: chunk,
      encoding: encoding,
      isBuf: isBuf,
      callback: cb,
      next: null
    };
    if (last) {
      last.next = state.lastBufferedRequest;
    } else {
      state.bufferedRequest = state.lastBufferedRequest;
    }
    state.bufferedRequestCount += 1;
  } else {
    doWrite(stream, state, false, len, chunk, encoding, cb);
  }

  return ret;
}

function doWrite(stream, state, writev, len, chunk, encoding, cb) {
  state.writelen = len;
  state.writecb = cb;
  state.writing = true;
  state.sync = true;
  if (writev) stream._writev(chunk, state.onwrite);else stream._write(chunk, encoding, state.onwrite);
  state.sync = false;
}

function onwriteError(stream, state, sync, er, cb) {
  --state.pendingcb;

  if (sync) {
    // defer the callback if we are being called synchronously
    // to avoid piling up things on the stack
    processNextTick(cb, er);
    // this can emit finish, and it will always happen
    // after error
    processNextTick(finishMaybe, stream, state);
    stream._writableState.errorEmitted = true;
    stream.emit('error', er);
  } else {
    // the caller expect this to happen before if
    // it is async
    cb(er);
    stream._writableState.errorEmitted = true;
    stream.emit('error', er);
    // this can emit finish, but finish must
    // always follow error
    finishMaybe(stream, state);
  }
}

function onwriteStateUpdate(state) {
  state.writing = false;
  state.writecb = null;
  state.length -= state.writelen;
  state.writelen = 0;
}

function onwrite(stream, er) {
  var state = stream._writableState;
  var sync = state.sync;
  var cb = state.writecb;

  onwriteStateUpdate(state);

  if (er) onwriteError(stream, state, sync, er, cb);else {
    // Check if we're actually ready to finish, but don't emit yet
    var finished = needFinish(state);

    if (!finished && !state.corked && !state.bufferProcessing && state.bufferedRequest) {
      clearBuffer(stream, state);
    }

    if (sync) {
      /*<replacement>*/
      asyncWrite(afterWrite, stream, state, finished, cb);
      /*</replacement>*/
    } else {
      afterWrite(stream, state, finished, cb);
    }
  }
}

function afterWrite(stream, state, finished, cb) {
  if (!finished) onwriteDrain(stream, state);
  state.pendingcb--;
  cb();
  finishMaybe(stream, state);
}

// Must force callback to be called on nextTick, so that we don't
// emit 'drain' before the write() consumer gets the 'false' return
// value, and has a chance to attach a 'drain' listener.
function onwriteDrain(stream, state) {
  if (state.length === 0 && state.needDrain) {
    state.needDrain = false;
    stream.emit('drain');
  }
}

// if there's something in the buffer waiting, then process it
function clearBuffer(stream, state) {
  state.bufferProcessing = true;
  var entry = state.bufferedRequest;

  if (stream._writev && entry && entry.next) {
    // Fast case, write everything using _writev()
    var l = state.bufferedRequestCount;
    var buffer = new Array(l);
    var holder = state.corkedRequestsFree;
    holder.entry = entry;

    var count = 0;
    var allBuffers = true;
    while (entry) {
      buffer[count] = entry;
      if (!entry.isBuf) allBuffers = false;
      entry = entry.next;
      count += 1;
    }
    buffer.allBuffers = allBuffers;

    doWrite(stream, state, true, state.length, buffer, '', holder.finish);

    // doWrite is almost always async, defer these to save a bit of time
    // as the hot path ends with doWrite
    state.pendingcb++;
    state.lastBufferedRequest = null;
    if (holder.next) {
      state.corkedRequestsFree = holder.next;
      holder.next = null;
    } else {
      state.corkedRequestsFree = new CorkedRequest(state);
    }
  } else {
    // Slow case, write chunks one-by-one
    while (entry) {
      var chunk = entry.chunk;
      var encoding = entry.encoding;
      var cb = entry.callback;
      var len = state.objectMode ? 1 : chunk.length;

      doWrite(stream, state, false, len, chunk, encoding, cb);
      entry = entry.next;
      // if we didn't call the onwrite immediately, then
      // it means that we need to wait until it does.
      // also, that means that the chunk and cb are currently
      // being processed, so move the buffer counter past them.
      if (state.writing) {
        break;
      }
    }

    if (entry === null) state.lastBufferedRequest = null;
  }

  state.bufferedRequestCount = 0;
  state.bufferedRequest = entry;
  state.bufferProcessing = false;
}

Writable.prototype._write = function (chunk, encoding, cb) {
  cb(new Error('_write() is not implemented'));
};

Writable.prototype._writev = null;

Writable.prototype.end = function (chunk, encoding, cb) {
  var state = this._writableState;

  if (typeof chunk === 'function') {
    cb = chunk;
    chunk = null;
    encoding = null;
  } else if (typeof encoding === 'function') {
    cb = encoding;
    encoding = null;
  }

  if (chunk !== null && chunk !== undefined) this.write(chunk, encoding);

  // .end() fully uncorks
  if (state.corked) {
    state.corked = 1;
    this.uncork();
  }

  // ignore unnecessary end() calls.
  if (!state.ending && !state.finished) endWritable(this, state, cb);
};

function needFinish(state) {
  return state.ending && state.length === 0 && state.bufferedRequest === null && !state.finished && !state.writing;
}
function callFinal(stream, state) {
  stream._final(function (err) {
    state.pendingcb--;
    if (err) {
      stream.emit('error', err);
    }
    state.prefinished = true;
    stream.emit('prefinish');
    finishMaybe(stream, state);
  });
}
function prefinish(stream, state) {
  if (!state.prefinished && !state.finalCalled) {
    if (typeof stream._final === 'function') {
      state.pendingcb++;
      state.finalCalled = true;
      processNextTick(callFinal, stream, state);
    } else {
      state.prefinished = true;
      stream.emit('prefinish');
    }
  }
}

function finishMaybe(stream, state) {
  var need = needFinish(state);
  if (need) {
    prefinish(stream, state);
    if (state.pendingcb === 0) {
      state.finished = true;
      stream.emit('finish');
    }
  }
  return need;
}

function endWritable(stream, state, cb) {
  state.ending = true;
  finishMaybe(stream, state);
  if (cb) {
    if (state.finished) processNextTick(cb);else stream.once('finish', cb);
  }
  state.ended = true;
  stream.writable = false;
}

function onCorkedFinish(corkReq, state, err) {
  var entry = corkReq.entry;
  corkReq.entry = null;
  while (entry) {
    var cb = entry.callback;
    state.pendingcb--;
    cb(err);
    entry = entry.next;
  }
  if (state.corkedRequestsFree) {
    state.corkedRequestsFree.next = corkReq;
  } else {
    state.corkedRequestsFree = corkReq;
  }
}

Object.defineProperty(Writable.prototype, 'destroyed', {
  get: function () {
    if (this._writableState === undefined) {
      return false;
    }
    return this._writableState.destroyed;
  },
  set: function (value) {
    // we ignore the value if the stream
    // has not been initialized yet
    if (!this._writableState) {
      return;
    }

    // backward compatibility, the user is explicitly
    // managing destroyed
    this._writableState.destroyed = value;
  }
});

Writable.prototype.destroy = destroyImpl.destroy;
Writable.prototype._undestroy = destroyImpl.undestroy;
Writable.prototype._destroy = function (err, cb) {
  this.end();
  cb(err);
};
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(17), __webpack_require__(164).setImmediate, __webpack_require__(12)))

/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implemtents Editor
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


// markdown commands


// wysiwyg Commands


// langs


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _button = __webpack_require__(20);

var _button2 = _interopRequireDefault(_button);

var _markdownEditor = __webpack_require__(56);

var _markdownEditor2 = _interopRequireDefault(_markdownEditor);

var _mdPreview = __webpack_require__(31);

var _mdPreview2 = _interopRequireDefault(_mdPreview);

var _wysiwygEditor = __webpack_require__(66);

var _wysiwygEditor2 = _interopRequireDefault(_wysiwygEditor);

var _layout = __webpack_require__(79);

var _layout2 = _interopRequireDefault(_layout);

var _eventManager = __webpack_require__(37);

var _eventManager2 = _interopRequireDefault(_eventManager);

var _commandManager2 = __webpack_require__(2);

var _commandManager3 = _interopRequireDefault(_commandManager2);

var _extManager = __webpack_require__(38);

var _extManager2 = _interopRequireDefault(_extManager);

var _importManager = __webpack_require__(22);

var _importManager2 = _interopRequireDefault(_importManager);

var _wwCodeBlockManager = __webpack_require__(36);

var _wwCodeBlockManager2 = _interopRequireDefault(_wwCodeBlockManager);

var _convertor = __webpack_require__(39);

var _convertor2 = _interopRequireDefault(_convertor);

var _viewer = __webpack_require__(90);

var _viewer2 = _interopRequireDefault(_viewer);

var _i18n = __webpack_require__(3);

var _i18n2 = _interopRequireDefault(_i18n);

var _defaultUI = __webpack_require__(91);

var _defaultUI2 = _interopRequireDefault(_defaultUI);

var _domUtils = __webpack_require__(4);

var _domUtils2 = _interopRequireDefault(_domUtils);

var _wwTableManager = __webpack_require__(34);

var _wwTableManager2 = _interopRequireDefault(_wwTableManager);

var _wwTableSelectionManager = __webpack_require__(35);

var _wwTableSelectionManager2 = _interopRequireDefault(_wwTableSelectionManager);

var _codeBlockManager = __webpack_require__(23);

var _codeBlockManager2 = _interopRequireDefault(_codeBlockManager);

var _bold = __webpack_require__(108);

var _bold2 = _interopRequireDefault(_bold);

var _italic = __webpack_require__(109);

var _italic2 = _interopRequireDefault(_italic);

var _strike = __webpack_require__(110);

var _strike2 = _interopRequireDefault(_strike);

var _blockquote = __webpack_require__(111);

var _blockquote2 = _interopRequireDefault(_blockquote);

var _heading = __webpack_require__(112);

var _heading2 = _interopRequireDefault(_heading);

var _paragraph = __webpack_require__(113);

var _paragraph2 = _interopRequireDefault(_paragraph);

var _hr = __webpack_require__(114);

var _hr2 = _interopRequireDefault(_hr);

var _addLink = __webpack_require__(115);

var _addLink2 = _interopRequireDefault(_addLink);

var _addImage = __webpack_require__(116);

var _addImage2 = _interopRequireDefault(_addImage);

var _ul = __webpack_require__(117);

var _ul2 = _interopRequireDefault(_ul);

var _ol = __webpack_require__(118);

var _ol2 = _interopRequireDefault(_ol);

var _indent = __webpack_require__(119);

var _indent2 = _interopRequireDefault(_indent);

var _outdent = __webpack_require__(120);

var _outdent2 = _interopRequireDefault(_outdent);

var _table = __webpack_require__(121);

var _table2 = _interopRequireDefault(_table);

var _task = __webpack_require__(122);

var _task2 = _interopRequireDefault(_task);

var _code = __webpack_require__(123);

var _code2 = _interopRequireDefault(_code);

var _codeBlock = __webpack_require__(124);

var _codeBlock2 = _interopRequireDefault(_codeBlock);

var _bold3 = __webpack_require__(125);

var _bold4 = _interopRequireDefault(_bold3);

var _italic3 = __webpack_require__(126);

var _italic4 = _interopRequireDefault(_italic3);

var _strike3 = __webpack_require__(127);

var _strike4 = _interopRequireDefault(_strike3);

var _blockquote3 = __webpack_require__(128);

var _blockquote4 = _interopRequireDefault(_blockquote3);

var _addImage3 = __webpack_require__(129);

var _addImage4 = _interopRequireDefault(_addImage3);

var _addLink3 = __webpack_require__(130);

var _addLink4 = _interopRequireDefault(_addLink3);

var _hr3 = __webpack_require__(131);

var _hr4 = _interopRequireDefault(_hr3);

var _heading3 = __webpack_require__(132);

var _heading4 = _interopRequireDefault(_heading3);

var _paragraph3 = __webpack_require__(133);

var _paragraph4 = _interopRequireDefault(_paragraph3);

var _ul3 = __webpack_require__(134);

var _ul4 = _interopRequireDefault(_ul3);

var _ol3 = __webpack_require__(135);

var _ol4 = _interopRequireDefault(_ol3);

var _table3 = __webpack_require__(136);

var _table4 = _interopRequireDefault(_table3);

var _tableAddRow = __webpack_require__(137);

var _tableAddRow2 = _interopRequireDefault(_tableAddRow);

var _tableAddCol = __webpack_require__(138);

var _tableAddCol2 = _interopRequireDefault(_tableAddCol);

var _tableRemoveRow = __webpack_require__(139);

var _tableRemoveRow2 = _interopRequireDefault(_tableRemoveRow);

var _tableRemoveCol = __webpack_require__(140);

var _tableRemoveCol2 = _interopRequireDefault(_tableRemoveCol);

var _tableAlignCol = __webpack_require__(141);

var _tableAlignCol2 = _interopRequireDefault(_tableAlignCol);

var _tableRemove = __webpack_require__(142);

var _tableRemove2 = _interopRequireDefault(_tableRemove);

var _indent3 = __webpack_require__(143);

var _indent4 = _interopRequireDefault(_indent3);

var _outdent3 = __webpack_require__(144);

var _outdent4 = _interopRequireDefault(_outdent3);

var _task3 = __webpack_require__(145);

var _task4 = _interopRequireDefault(_task3);

var _code3 = __webpack_require__(146);

var _code4 = _interopRequireDefault(_code3);

var _codeBlock3 = __webpack_require__(147);

var _codeBlock4 = _interopRequireDefault(_codeBlock3);

var _util = __webpack_require__(148);

__webpack_require__(149);

__webpack_require__(150);

__webpack_require__(151);

__webpack_require__(152);

__webpack_require__(153);

__webpack_require__(154);

__webpack_require__(155);

__webpack_require__(156);

__webpack_require__(157);

__webpack_require__(158);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var __nedInstance = [];

/**
 * @callback addImageBlobHook
 * @param  {File|Blob} fileOrBlob - image blob
 * @param  {callback} callback - callback function to be called after
 * @param  {string} source - source of an event the item belongs to. 'paste', 'drop', 'ui'
 */

/**
 * Class ToastUIEditor
 */

var ToastUIEditor = function () {
  /**
     * ToastUI Editor
     * @param {object} options Option object
         * @param {string} [options.height='300px'] - Editor's height style value. Height is applied as border-box ex) '300px', '100%', 'auto'
         * @param {string} [options.minHeight='200px'] - Editor's min-height style value in pixel ex) '300px'
         * @param {string} options.initialValue - Editor's initial value
         * @param {string} options.previewStyle - Markdown editor's preview style (tab, vertical)
         * @param {string} options.initialEditType - Initial editor type (markdown, wysiwyg)
         * @param {object} options.events - eventlist Event list
             * @param {function} options.events.load - It would be emitted when editor fully load
             * @param {function} options.events.change - It would be emitted when content changed
             * @param {function} options.events.stateChange - It would be emitted when format change by cursor position
             * @param {function} options.events.focus - It would be emitted when editor get focus
             * @param {function} options.events.blur - It would be emitted when editor loose focus
         * @param {object} options.hooks - Hook list
             * @param {function} options.hooks.previewBeforeHook - Submit preview to hook URL before preview be shown
             * @param {addImageBlobHook} options.hooks.addImageBlobHook - hook for image upload.
        * @param {string} [options.language='en_US'] - language
        * @param {boolean} [options.useCommandShortcut=true] - whether use keyboard shortcuts to perform commands
        * @param {boolean} [options.useDefaultHTMLSanitizer=true] - use default htmlSanitizer
        * @param {string[]} [options.codeBlockLanguages] - supported code block languages to be listed. default is what highlight.js supports
        * @param {boolean} [options.usageStatistics=true] - send hostname to google analytics
        * @param {object[]} [options.toolbarItems] - toolbar items.
        * @param {boolean} [options.hideModeSwitch=false] - hide mode switch tab bar
    */
  function ToastUIEditor(options) {
    var _this = this;

    _classCallCheck(this, ToastUIEditor);

    this.options = _jquery2.default.extend({
      previewStyle: 'tab',
      initialEditType: 'markdown',
      height: '300px',
      minHeight: '200px',
      language: 'en_US',
      useDefaultHTMLSanitizer: true,
      useCommandShortcut: true,
      codeBlockLanguages: _codeBlockManager.CodeBlockManager.getHighlightJSLanguages(),
      usageStatistics: true,
      toolbarItems: ['heading', 'bold', 'italic', 'strike', 'divider', 'hr', 'quote', 'divider', 'ul', 'ol', 'task', 'indent', 'outdent', 'divider', 'table', 'image', 'link', 'divider', 'code', 'codeblock'],
      hideModeSwitch: false
    }, options);

    this.eventManager = new _eventManager2.default();

    this.importManager = new _importManager2.default(this.eventManager);

    this.commandManager = new _commandManager3.default(this, {
      useCommandShortcut: this.options.useCommandShortcut
    });

    this.convertor = new _convertor2.default(this.eventManager);

    if (this.options.useDefaultHTMLSanitizer) {
      this.convertor.initHtmlSanitizer();
    }

    if (this.options.hooks) {
      _tuiCodeSnippet2.default.forEach(this.options.hooks, function (fn, key) {
        return _this.addHook(key, fn);
      });
    }

    if (this.options.events) {
      _tuiCodeSnippet2.default.forEach(this.options.events, function (fn, key) {
        return _this.on(key, fn);
      });
    }

    this.layout = new _layout2.default(options, this.eventManager);

    this.i18n = _i18n2.default;
    this.i18n.setCode(this.options.language);

    this.setUI(this.options.UI || new _defaultUI2.default(this));

    this.mdEditor = _markdownEditor2.default.factory(this.layout.getMdEditorContainerEl(), this.eventManager);
    this.preview = new _mdPreview2.default(this.layout.getPreviewEl(), this.eventManager, this.convertor);
    this.wwEditor = _wysiwygEditor2.default.factory(this.layout.getWwEditorContainerEl(), this.eventManager, {
      useCommandShortcut: this.options.useCommandShortcut
    });
    this.toMarkOptions = null;

    this.changePreviewStyle(this.options.previewStyle);

    this.changeMode(this.options.initialEditType, true);

    this.minHeight(this.options.minHeight);

    this.height(this.options.height);

    this.setValue(this.options.initialValue, false);

    _extManager2.default.applyExtension(this, this.options.exts);

    this.eventManager.emit('load', this);

    __nedInstance.push(this);

    this._addDefaultCommands();

    if (this.options.usageStatistics) {
      (0, _util.sendHostName)();
    }
  }

  /**
   * change preview style
   * @memberof ToastUIEditor
   * @param {string} style - 'tab'|'vertical'
   */


  _createClass(ToastUIEditor, [{
    key: 'changePreviewStyle',
    value: function changePreviewStyle(style) {
      this.layout.changePreviewStyle(style);
      this.mdPreviewStyle = style;
      this.eventManager.emit('changePreviewStyle', style);
      this.eventManager.emit('previewNeedsRefresh');
    }

    /**
     * call commandManager's exec method
     * @memberof ToastUIEditor
     */

  }, {
    key: 'exec',
    value: function exec() {
      var _commandManager;

      (_commandManager = this.commandManager).exec.apply(_commandManager, arguments);
    }

    /**
     * add default commands
     * @memberof ToastUIEditor
     * @private
     */

  }, {
    key: '_addDefaultCommands',
    value: function _addDefaultCommands() {
      this.addCommand(_bold2.default);
      this.addCommand(_italic2.default);
      this.addCommand(_blockquote2.default);
      this.addCommand(_heading2.default);
      this.addCommand(_paragraph2.default);
      this.addCommand(_hr2.default);
      this.addCommand(_addLink2.default);
      this.addCommand(_addImage2.default);
      this.addCommand(_ul2.default);
      this.addCommand(_ol2.default);
      this.addCommand(_indent2.default);
      this.addCommand(_outdent2.default);
      this.addCommand(_table2.default);
      this.addCommand(_task2.default);
      this.addCommand(_code2.default);
      this.addCommand(_codeBlock2.default);
      this.addCommand(_strike2.default);

      this.addCommand(_bold4.default);
      this.addCommand(_italic4.default);
      this.addCommand(_blockquote4.default);
      this.addCommand(_ul4.default);
      this.addCommand(_ol4.default);
      this.addCommand(_addImage4.default);
      this.addCommand(_addLink4.default);
      this.addCommand(_hr4.default);
      this.addCommand(_heading4.default);
      this.addCommand(_paragraph4.default);
      this.addCommand(_indent4.default);
      this.addCommand(_outdent4.default);
      this.addCommand(_task4.default);
      this.addCommand(_table4.default);
      this.addCommand(_tableAddRow2.default);
      this.addCommand(_tableAddCol2.default);
      this.addCommand(_tableRemoveRow2.default);
      this.addCommand(_tableRemoveCol2.default);
      this.addCommand(_tableAlignCol2.default);
      this.addCommand(_tableRemove2.default);
      this.addCommand(_code4.default);
      this.addCommand(_codeBlock4.default);
      this.addCommand(_strike4.default);
    }
  }, {
    key: 'addCommand',
    value: function addCommand(type, props) {
      if (!props) {
        this.commandManager.addCommand(type);
      } else {
        this.commandManager.addCommand(_commandManager3.default.command(type, props));
      }
    }

    /**
     * After added command.
     */

  }, {
    key: 'afterAddedCommand',
    value: function afterAddedCommand() {
      this.eventManager.emit('afterAddedCommand', this);
    }

    /**
     * Bind eventHandler to event type
     * @memberof ToastUIEditor
     * @param {string} type Event type
     * @param {function} handler Event handler
     */

  }, {
    key: 'on',
    value: function on(type, handler) {
      this.eventManager.listen(type, handler);
    }

    /**
     * Unbind eventHandler from event type
     * @memberof ToastUIEditor
     * @param {string} type Event type
     */

  }, {
    key: 'off',
    value: function off(type) {
      this.eventManager.removeEventHandler(type);
    }

    /**
     * Add hook to TUIEditor event
     * @memberof ToastUIEditor
     * @param {string} type Event type
     * @param {function} handler Event handler
     */

  }, {
    key: 'addHook',
    value: function addHook(type, handler) {
      this.eventManager.removeEventHandler(type);
      this.eventManager.listen(type, handler);
    }

    /**
     * Remove hook from TUIEditor event
     * @memberof ToastUIEditor
     * @param {string} type Event type
     */

  }, {
    key: 'removeHook',
    value: function removeHook(type) {
      this.eventManager.removeEventHandler(type);
    }

    /**
     * Get CodeMirror instance
     * @memberof ToastUIEditor
     * @returns {CodeMirror}
     */

  }, {
    key: 'getCodeMirror',
    value: function getCodeMirror() {
      return this.mdEditor.getEditor();
    }

    /**
     * Get SquireExt instance
     * @memberof ToastUIEditor
     * @returns {SquireExt}
     */

  }, {
    key: 'getSquire',
    value: function getSquire() {
      return this.wwEditor.getEditor();
    }

    /**
     * Set focus to current Editor
     * @memberof ToastUIEditor
     */

  }, {
    key: 'focus',
    value: function focus() {
      this.getCurrentModeEditor().focus();
    }

    /**
     * Remove focus of current Editor
     * @memberof ToastUIEditor
     */

  }, {
    key: 'blur',
    value: function blur() {
      this.getCurrentModeEditor().blur();
    }

    /**
     * Set cursor position to end
     * @memberof ToastUIEditor
     */

  }, {
    key: 'moveCursorToEnd',
    value: function moveCursorToEnd() {
      this.getCurrentModeEditor().moveCursorToEnd();
    }

    /**
     * Set cursor position to start
     * @memberof ToastUIEditor
     */

  }, {
    key: 'moveCursorToStart',
    value: function moveCursorToStart() {
      this.getCurrentModeEditor().moveCursorToStart();
    }

    /**
     * Set markdown syntax text.
     * @memberof ToastUIEditor
     * @param {string} markdown - markdown syntax text.
     * @param {boolean} [cursorToEnd=true] - move cursor to contents end
     */

  }, {
    key: 'setMarkdown',
    value: function setMarkdown(markdown) {
      var cursorToEnd = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      markdown = markdown || '';

      if (this.isMarkdownMode()) {
        this.mdEditor.setValue(markdown, cursorToEnd);
      } else {
        this.wwEditor.setValue(this.convertor.toHTML(markdown), cursorToEnd);
      }

      this.eventManager.emit('setMarkdownAfter', markdown);
    }

    /**
     * Set html value.
     * @memberof ToastUIEditor
     * @param {string} html - html syntax text
     * @param {boolean} [cursorToEnd=true] - move cursor to contents end
     */

  }, {
    key: 'setHtml',
    value: function setHtml(html) {
      var cursorToEnd = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      html = html || '';
      this.wwEditor.setValue(html);

      if (this.isMarkdownMode()) {
        var markdown = this.convertor.toMarkdown(this.wwEditor.getValue(), this.toMarkOptions);
        this.mdEditor.setValue(markdown, cursorToEnd);
        this.eventManager.emit('setMarkdownAfter', markdown);
      }
    }

    /**
     * Set markdown syntax text.
     * @memberof ToastUIEditor
     * @param {string} value - markdown syntax text
     * @param {boolean} [cursorToEnd=true] - move cursor to contents end
     * @deprecated
     */

  }, {
    key: 'setValue',
    value: function setValue(value) {
      var cursorToEnd = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      this.setMarkdown(value, cursorToEnd);
    }

    /**
     * Get markdown syntax text.
     * @memberof ToastUIEditor
     * @returns {string}
     */

  }, {
    key: 'getMarkdown',
    value: function getMarkdown() {
      var markdown = void 0;

      if (this.isMarkdownMode()) {
        markdown = this.mdEditor.getValue();
      } else {
        markdown = this.convertor.toMarkdown(this.wwEditor.getValue(), this.toMarkOptions);
      }

      return markdown;
    }

    /**
     * Get html syntax text.
     * @memberof ToastUIEditor
     * @returns {string}
     */

  }, {
    key: 'getHtml',
    value: function getHtml() {
      if (this.isWysiwygMode()) {
        this.mdEditor.setValue(this.convertor.toMarkdown(this.wwEditor.getValue(), this.toMarkOptions));
      }

      return this.convertor.toHTML(this.mdEditor.getValue());
    }

    /**
     * Get editor value.
     * @memberof ToastUIEditor
     * @returns {string}
     * @deprecated
     */

  }, {
    key: 'getValue',
    value: function getValue() {
      return this.getMarkdown();
    }

    /**
     * insert text
     * @param {string} text - text string to insert
     * @memberof ToastUIEditor
     */

  }, {
    key: 'insertText',
    value: function insertText(text) {
      if (this.isMarkdownMode()) {
        this.mdEditor.replaceSelection(text);
      } else {
        this.wwEditor.insertText(text);
      }
    }

    /**
     * Add widget to selection
     * @memberof ToastUIEditor
     * @param {Range} selection Current selection
     * @param {Node} node widget node
     * @param {string} style Adding style "over" or "bottom"
     * @param {number} [offset] Offset for adjust position
     */

  }, {
    key: 'addWidget',
    value: function addWidget(selection, node, style, offset) {
      this.getCurrentModeEditor().addWidget(selection, node, style, offset);
    }

    /**
     * Set and return edithr height
     * @memberof ToastUIEditor
     * @param {string} height - editor height
     * @returns {string} editor height
     */

  }, {
    key: 'height',
    value: function height(_height) {
      if (_tuiCodeSnippet2.default.isExisty(_height)) {
        if (_height === 'auto') {
          this.options.el.classList.add('auto-height');
          this.minHeight(this.minHeight());
        } else {
          this.options.el.classList.remove('auto-height');
          this.minHeight(_height);
        }
        if (_tuiCodeSnippet2.default.isNumber(_height)) {
          _height = _height + 'px';
        }

        this.options.el.style.height = _height;
        this._height = _height;
      }

      return this._height;
    }

    /**
     * Set / Get min content height
     * @param {string} minHeight - min content height in pixel
     * @memberof ToastUIEditor
     * @returns {string} - min height in pixel
     */

  }, {
    key: 'minHeight',
    value: function minHeight(_minHeight) {
      if (_tuiCodeSnippet2.default.isExisty(_minHeight)) {
        var editorHeight = this._ui.getEditorHeight();
        var editorSectionHeight = this._ui.getEditorSectionHeight();
        var diffHeight = editorHeight - editorSectionHeight;
        this._minHeight = _minHeight;

        _minHeight = parseInt(_minHeight, 10);
        _minHeight = Math.max(_minHeight - diffHeight, 0);

        this.wwEditor.setMinHeight(_minHeight);
        this.mdEditor.setMinHeight(_minHeight);
        this.preview.setMinHeight(_minHeight);
      }

      return this._minHeight;
    }

    /**
     * Get current editor mode name
     * @memberof ToastUIEditor
     * @returns {string}
     */

  }, {
    key: 'getCurrentModeEditor',
    value: function getCurrentModeEditor() {
      var editor = void 0;

      if (this.isMarkdownMode()) {
        editor = this.mdEditor;
      } else {
        editor = this.wwEditor;
      }

      return editor;
    }

    /**
     * Return true if current editor mode is Markdown
     * @memberof ToastUIEditor
     * @returns {boolean}
     */

  }, {
    key: 'isMarkdownMode',
    value: function isMarkdownMode() {
      return this.currentMode === 'markdown';
    }

    /**
     * Return true if current editor mode is WYSIWYG
     * @memberof ToastUIEditor
     * @returns {boolean}
     */

  }, {
    key: 'isWysiwygMode',
    value: function isWysiwygMode() {
      return this.currentMode === 'wysiwyg';
    }

    /**
     * Return false
     * @memberof ToastUIEditor
     * @returns {boolean}
     */

  }, {
    key: 'isViewer',
    value: function isViewer() {
      return false;
    }

    /**
     * Get current Markdown editor's preview style
     * @memberof ToastUIEditor
     * @returns {string}
     */

  }, {
    key: 'getCurrentPreviewStyle',
    value: function getCurrentPreviewStyle() {
      return this.mdPreviewStyle;
    }

    /**
     * Change editor's mode to given mode string
     * @memberof ToastUIEditor
     * @param {string} mode - Editor mode name of want to change
     * @param {boolean} isWithoutFocus - Change mode without focus
     */

  }, {
    key: 'changeMode',
    value: function changeMode(mode, isWithoutFocus) {
      if (this.currentMode === mode) {
        return;
      }

      this.eventManager.emit('changeModeBefore', this.currentMode);

      this.currentMode = mode;

      if (this.isWysiwygMode()) {
        this.layout.switchToWYSIWYG();
        this.wwEditor.setValue(this.convertor.toHTML(this.mdEditor.getValue()), !isWithoutFocus);
        this.eventManager.emit('changeModeToWysiwyg');
      } else {
        this.layout.switchToMarkdown();
        this.mdEditor.setValue(this.convertor.toMarkdown(this.wwEditor.getValue(), this.toMarkOptions), !isWithoutFocus);
        this.getCodeMirror().refresh();
        this.eventManager.emit('changeModeToMarkdown');
      }

      this.eventManager.emit('changeMode', mode);

      if (!isWithoutFocus) {
        this.focus();
      }
    }

    /**
     * Remove TUIEditor from document
     * @memberof ToastUIEditor
     */

  }, {
    key: 'remove',
    value: function remove() {
      var self = this;
      var i = __nedInstance.length - 1;
      this.wwEditor.remove();
      this.mdEditor.remove();
      this.layout.remove();

      if (this.getUI()) {
        this.getUI().remove();
      }

      this.eventManager.emit('removeEditor');
      this.eventManager.events.forEach(function (value, key) {
        self.off(key);
      });
      this.eventManager = null;

      for (; i >= 0; i -= 1) {
        if (__nedInstance[i] === this) {
          __nedInstance.splice(i, 1);
        }
      }
    }

    /**
     * Hide TUIEditor
     * @memberof ToastUIEditor
     */

  }, {
    key: 'hide',
    value: function hide() {
      this.eventManager.emit('hide', this);
    }

    /**
     * Show TUIEditor
     * @memberof ToastUIEditor
     */

  }, {
    key: 'show',
    value: function show() {
      this.eventManager.emit('show', this);
      this.getCodeMirror().refresh();
    }

    /**
     * Scroll Editor content to Top
     * @memberof ToastUIEditor
     * @param {number} value Scroll amount
     * @returns {number}
     */

  }, {
    key: 'scrollTop',
    value: function scrollTop(value) {
      return this.getCurrentModeEditor().scrollTop(value);
    }

    /**
     * Set UI to private UI property
     * @memberof ToastUIEditor
     * @param {UI} UI UI instance
     */

  }, {
    key: 'setUI',
    value: function setUI(UI) {
      this._ui = UI;
    }

    /**
     * Get _ui property
     * @memberof ToastUIEditor
     * @returns {UI}
     */

  }, {
    key: 'getUI',
    value: function getUI() {
      return this._ui;
    }

    /**
     * Reset TUIEditor
     * @memberof ToastUIEditor
     */

  }, {
    key: 'reset',
    value: function reset() {
      this.wwEditor.reset();
      this.mdEditor.reset();
    }

    /**
     * Get current range
     * @memberof ToastUIEditor
     * @returns {{start, end}|Range}
     */

  }, {
    key: 'getRange',
    value: function getRange() {
      return this.getCurrentModeEditor().getRange();
    }

    /**
     * Get text object of current range
     * @memberof ToastUIEditor
     * @param {{start, end}|Range} range Range object of each editor
     * @returns {object} TextObject class
     */

  }, {
    key: 'getTextObject',
    value: function getTextObject(range) {
      return this.getCurrentModeEditor().getTextObject(range);
    }

    /**
     * get selected text
     * @returns {string} - selected text
     * @memberof ToastUIEditor
     */

  }, {
    key: 'getSelectedText',
    value: function getSelectedText() {
      var range = this.getRange();
      var textObject = this.getTextObject(range);

      return textObject.getTextContent() || '';
    }

    /**
     * Get instance of TUIEditor
     * @memberof ToastUIEditor
     * @returns {Array}
     */

  }], [{
    key: 'getInstances',
    value: function getInstances() {
      return __nedInstance;
    }

    /**
     * Define extension
     * @memberof ToastUIEditor
     * @param {string} name Extension name
     * @param {ExtManager~extension} ext extension
     */

  }, {
    key: 'defineExtension',
    value: function defineExtension(name, ext) {
      _extManager2.default.defineExtension(name, ext);
    }

    /**
     * Factory method for Editor
     * @memberof ToastUIEditor
     * @param {object} options Option for initialize TUIEditor
     * @returns {ToastUIEditor}
     */

  }, {
    key: 'factory',
    value: function factory(options) {
      var tuiEditor = void 0;

      if (options.viewer) {
        tuiEditor = new _viewer2.default(options);
      } else {
        tuiEditor = new ToastUIEditor(options);
      }

      return tuiEditor;
    }
  }]);

  return ToastUIEditor;
}();

/**
 * check whther is viewer
 * @type {boolean}
 */


ToastUIEditor.isViewer = false;

/**
 * I18n instance
 * @type {I18n}
 */
ToastUIEditor.i18n = _i18n2.default;

/**
 * domUtil instance
 * @type {DomUtil}
 */
ToastUIEditor.domUtils = _domUtils2.default;

/**
 * CodeBlockManager instance
 * @type {CodeBlockManager}
 */
ToastUIEditor.codeBlockManager = _codeBlockManager2.default;

/**
 * Button class
 * @type {Class.<Button>}
 * @deprecated
 */
ToastUIEditor.Button = _button2.default;

/**
 * WwCodeBlockManager class
 * @type {Class.<WwCodeBlockManager>}
 */
ToastUIEditor.WwCodeBlockManager = _wwCodeBlockManager2.default;

/**
 * WwTableManager class
 * @type {Class.<WwTableManager>}
 */
ToastUIEditor.WwTableManager = _wwTableManager2.default;

/**
 * WwTableManager class
 * @type {Class.<WwTableSelectionManager>}
 */
ToastUIEditor.WwTableSelectionManager = _wwTableSelectionManager2.default;

/**
 * CommandManager class
 * @type {Class.<CommandManager>}
 */
ToastUIEditor.CommandManager = _commandManager3.default;

/**
 * MarkdownIt hightlight instance
 * @type {MarkdownIt}
 */
ToastUIEditor.markdownitHighlight = _convertor2.default.getMarkdownitHighlightRenderer();

module.exports = ToastUIEditor;

/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements tooltip
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var TOOLTIP_CONTENT = '<div class="tui-tooltip"><div class="arrow"></div><span class="text"></span></span></div>';

/**
 * Class Tooltip
 */

var Tooltip = function () {
  /**
   * Creates an instance of Tooltip.
   * @memberof Tooltip
   */
  function Tooltip() {
    _classCallCheck(this, Tooltip);

    this.$el = (0, _jquery2.default)(TOOLTIP_CONTENT);
    this.$el.appendTo('body');
    this.hide();
  }

  /**
   * show tooltop
   * @param {jQuery} target - target jQuery element to bind
   * @param {String} text - text to show
   */


  _createClass(Tooltip, [{
    key: 'show',
    value: function show(target, text) {
      this.$el.css({
        'top': target.offset().top + target.height() + 13, // below the button
        'left': target.offset().left + 3
      }).find('.text').html(text).end().show();
    }
  }, {
    key: 'hide',
    value: function hide() {
      this.$el.hide();
    }
  }, {
    key: 'remove',
    value: function remove() {
      this.$el.remove();
    }
  }]);

  return Tooltip;
}();

exports.default = new Tooltip();

/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements CodeBlockExt
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _codemirror = __webpack_require__(10);

var _codemirror2 = _interopRequireDefault(_codemirror);

__webpack_require__(57);

__webpack_require__(58);

__webpack_require__(59);

__webpack_require__(60);

__webpack_require__(61);

__webpack_require__(62);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Class CodeMirrorExt
 */
var CodeMirrorExt = function () {
  /**
   * Creates an instance of CodeMirrorExt.
   * @param {HTMLElement} el - container jquery element
   * @param {Object} [options={}] - codeMirror options
   * @memberof CodeMirrorExt
   */
  function CodeMirrorExt(el) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, CodeMirrorExt);

    this.editorContainerEl = el;

    /**
     * @memberof CodeMirrorExt
     * @protected
     * @member
     */
    this.cm = null;

    this._init(options);
  }

  /**
   * init
   * @param {Object} options - codeMirror option
   * @memberof CodeMirrorExt
   * @private
   */


  _createClass(CodeMirrorExt, [{
    key: '_init',
    value: function _init(options) {
      var cmTextarea = document.createElement('textarea');
      this.editorContainerEl.appendChild(cmTextarea);

      options = _jquery2.default.extend(true, {
        lineWrapping: true,
        theme: 'default',
        extraKeys: {
          'Shift-Tab': 'indentLess',
          'Alt-Up': 'replaceLineTextToUpper',
          'Alt-Down': 'replaceLineTextToLower'
        },
        indentUnit: 4
      }, options);

      this.cm = _codemirror2.default.fromTextArea(cmTextarea, options);
    }

    /**
     * getCurrentRange
     * @memberof CodeMirrorExt
     * @returns {Object} - selection range
     */

  }, {
    key: 'getCurrentRange',
    value: function getCurrentRange() {
      var from = this.cm.getCursor('from');
      var to = this.cm.getCursor('to');

      return {
        from: from,
        to: to,
        collapsed: from.line === to.line && from.ch === to.ch
      };
    }

    /**
     * Set focus to current Editor
     * @memberof CodeMirrorExt
     */

  }, {
    key: 'focus',
    value: function focus() {
      this.cm.focus();
    }

    /**
     * blur focus to current Editor
     * @memberof CodeMirrorExt
     */

  }, {
    key: 'blur',
    value: function blur() {
      this.cm.getInputField().blur();
    }

    /**
     * Remove Editor from document
     * @memberof CodeMirrorExt
     */

  }, {
    key: 'remove',
    value: function remove() {
      this.cm.toTextArea();
    }

    /**
     * Set Editor value
     * @memberof CodeMirrorExt
     * @param {string} markdown - Markdown syntax text
     * @param {boolean} [cursorToEnd=true] - move cursor to contents end
     */

  }, {
    key: 'setValue',
    value: function setValue(markdown) {
      var cursorToEnd = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      this.cm.setValue(markdown);
      if (cursorToEnd) {
        this.moveCursorToEnd();
      }
      this.cm.refresh();
    }

    /**
     * Get editor value
     * @memberof CodeMirrorExt
     * @returns {string} - codeMirror text value
     */

  }, {
    key: 'getValue',
    value: function getValue() {
      return this.cm.getValue('\n');
    }

    /**
     * Get CodeMirror instance
     * @memberof CodeMirrorExt
     * @returns {CodeMirror}
     */

  }, {
    key: 'getEditor',
    value: function getEditor() {
      return this.cm;
    }

    /**
     * Reset Editor
     * @memberof CodeMirrorExt
     */

  }, {
    key: 'reset',
    value: function reset() {
      this.setValue('');
    }

    /**
     * Get current caret position
     * @memberof CodeMirrorExt
     * @returns {{from: {line: number, ch: number}, to: {line: number, ch: number}}}
     */

  }, {
    key: 'getCaretPosition',
    value: function getCaretPosition() {
      return this.cm.cursorCoords();
    }

    /**
     * Add widget
     * @memberof CodeMirrorExt
     * @param {object} selection - Selection object
     * @param {HTMLElement} node - Widget node
     * @param {string} style - Adding style "over" or "bottom"
     * @param {number} offset - Adding offset
     */

  }, {
    key: 'addWidget',
    value: function addWidget(selection, node, style, offset) {
      if (offset) {
        selection.ch += offset;
      }

      this.cm.addWidget(selection.end, node, true, style);
    }

    /**
     * Replace selection with given replacement content
     * @memberof CodeMirrorExt
     * @param {string} content - Replacement content text
     * @param {object} selection - Selection object
     */

  }, {
    key: 'replaceSelection',
    value: function replaceSelection(content, selection) {
      if (selection) {
        this.cm.setSelection(selection.from, selection.to);
      }

      this.cm.replaceSelection(content);
      this.focus();
    }

    /**
     * Replace selection with replacement content and offset
     * @memberof CodeMirrorExt
     * @param {string} content - Replacement content text
     * @param {number} offset - Offset
     * @param {number} overwriteLength - Length to overwrite
     */

  }, {
    key: 'replaceRelativeOffset',
    value: function replaceRelativeOffset(content, offset, overwriteLength) {
      var cursor = this.cm.getCursor();
      var selection = {
        from: {
          line: cursor.line,
          ch: cursor.ch + offset
        },
        to: {
          line: cursor.line,
          ch: cursor.ch + offset + overwriteLength
        }
      };

      this.replaceSelection(content, selection);
    }

    /**
     * Set Editor height
     * @memberof CodeMirrorExt
     * @param {number} height - Editor height
     */

  }, {
    key: 'setHeight',
    value: function setHeight(height) {
      var contentWrapper = this.getWrapperElement();

      contentWrapper.style.height = height + 'px';
    }

    /**
     * set min height
     * @param {number} minHeight - min height
     * @memberof CodeMirrorExt
     */

  }, {
    key: 'setMinHeight',
    value: function setMinHeight(minHeight) {
      var contentWrapper = this.getWrapperElement();

      contentWrapper.style.minHeight = minHeight + 'px';
    }

    /**
     * get code mirror wrapper element
     * @returns {HTMLElement} - code mirror wrapper element
     * @memberof CodeMirrorExt
     */

  }, {
    key: 'getWrapperElement',
    value: function getWrapperElement() {
      return this.cm.getWrapperElement();
    }

    /**
     * get code mirror cursor
     * @param {string} [start='head'] - which end of the selection. 'from'|'to'|'head'|'anchor'
     * @returns {Cursor} - code mirror cursor
     * @memberof CodeMirrorExt
     */

  }, {
    key: 'getCursor',
    value: function getCursor(start) {
      return this.cm.getCursor(start);
    }

    /**
     * Set cursor position to end
     * @memberof CodeMirrorExt
     */

  }, {
    key: 'moveCursorToEnd',
    value: function moveCursorToEnd() {
      var doc = this.getEditor().getDoc();
      var lastLine = doc.lastLine();

      doc.setCursor(lastLine, doc.getLine(lastLine).length);
    }

    /**
     * Set cursor position to start
     * @memberof CodeMirrorExt
     */

  }, {
    key: 'moveCursorToStart',
    value: function moveCursorToStart() {
      var doc = this.getEditor().getDoc();
      var firstLine = doc.firstLine();

      doc.setCursor(firstLine, 0);
    }

    /**
     * Scroll Editor content to Top
     * @memberof CodeMirrorExt
     * @param {number} value - Scroll amount
     * @returns {number} - changed scroll top
     */

  }, {
    key: 'scrollTop',
    value: function scrollTop(value) {
      if (value) {
        this.cm.scrollTo(0, value);
      }

      return this.cm.getScrollInfo().top;
    }

    /**
     * Get start, end position of current selection
     * @memberof CodeMirrorExt
     * @returns {{start: {line: *, ch: *}, end: {line: *, ch: *}}}
     */

  }, {
    key: 'getRange',
    value: function getRange() {
      var start = this.cm.getCursor('from');
      var end = this.cm.getCursor('to');

      return {
        start: {
          line: start.line,
          ch: start.ch
        },
        end: {
          line: end.line,
          ch: end.ch
        }
      };
    }

    /**
     * add codemirror event handler
     * @param {string} type - event type
     * @param {function} func - handler function
     * @memberof CodeMirrorExt
     */

  }, {
    key: 'on',
    value: function on(type, func) {
      this.cm.on(type, func);
    }

    /**
     * remove codemirror event handler
     * @param {string} type - event type
     * @param {function} func - handler function
     * @memberof CodeMirrorExt
     */

  }, {
    key: 'off',
    value: function off(type, func) {
      this.cm.off(type, func);
    }
  }]);

  return CodeMirrorExt;
}();

exports.default = CodeMirrorExt;

/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @fileoverview Implements ComponentManager
 * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */

/**
 * Class ComponentManager
 */
var ComponentManager = function () {
  /**
   * Constructor
   * @param {MarkdownEditor|WysiwygEditor} editor - Editor instance
   */
  function ComponentManager(editor) {
    _classCallCheck(this, ComponentManager);

    /**
     * private
     * @type {object}
     * @private
     */
    this._managers = {};
    this._editor = editor;
  }

  /**
   * addManager
   * Add manager
   * @memberof ComponentManager
   * @param {string|function} nameOrConstructor Manager name or constructor
   * @param {function} [ManagerConstructor] Constructor
   */


  _createClass(ComponentManager, [{
    key: "addManager",
    value: function addManager(nameOrConstructor, ManagerConstructor) {
      if (!ManagerConstructor) {
        ManagerConstructor = nameOrConstructor;
        nameOrConstructor = null;
      }

      var instance = new ManagerConstructor(this._editor);

      this._managers[nameOrConstructor || instance.name] = instance;
    }

    /**
     * getManager
     * Get manager by manager name
     * @memberof ComponentManager
     * @param {string} name Manager name
     * @returns {object} manager
     */

  }, {
    key: "getManager",
    value: function getManager(name) {
      return this._managers[name];
    }

    /**
     * Remove Manager.
     * @param {string} name - manager name
     */

  }, {
    key: "removeManager",
    value: function removeManager(name) {
      var manager = this.getManager(name);

      if (!manager) {
        return;
      }

      if (manager.destroy) {
        manager.destroy();
      }

      delete this._managers[name];
    }
  }]);

  return ComponentManager;
}();

exports.default = ComponentManager;

/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _preview = __webpack_require__(32);

var _preview2 = _interopRequireDefault(_preview);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements markdown preview
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


/**
 * Class Markdown Preview
 * @extends {Preview}
 */
var MarkdownPreview = function (_Preview) {
  _inherits(MarkdownPreview, _Preview);

  /**
   * Creates an instance of MarkdownPreview.
   * @param {jQuery} $el - base jQuery element
   * @param {EventManager} eventManager - event manager
   * @param {Convertor} convertor - convertor
   * @param {boolean} isViewer - true for view only mode
   * @memberof MarkdownPreview
   */
  function MarkdownPreview($el, eventManager, convertor, isViewer) {
    _classCallCheck(this, MarkdownPreview);

    var _this = _possibleConstructorReturn(this, (MarkdownPreview.__proto__ || Object.getPrototypeOf(MarkdownPreview)).call(this, $el, eventManager, convertor, isViewer));

    _this._initEvent();
    return _this;
  }

  /**
   * Initialize event
   * @private
   */


  _createClass(MarkdownPreview, [{
    key: '_initEvent',
    value: function _initEvent() {
      var _this2 = this;

      var latestMarkdownValue = '';

      this.eventManager.listen('contentChangedFromMarkdown', function (markdownEditor) {
        latestMarkdownValue = markdownEditor.getValue();

        if (_this2.isVisible()) {
          _this2.lazyRunner.run('refresh', latestMarkdownValue.replace(/<br>\n/g, '<br>'));
        }
      });

      this.eventManager.listen('previewNeedsRefresh', function (value) {
        _this2.refresh(value || latestMarkdownValue);
      });

      this.$el.on('scroll', function (event) {
        _this2.eventManager.emit('scroll', {
          source: 'preview',
          data: event
        });
      });
    }

    /**
     * render
     * @param {string} html - html string to render
     * @memberof MarkdownPreview
     * @override
     */

  }, {
    key: 'render',
    value: function render(html) {
      _get(MarkdownPreview.prototype.__proto__ || Object.getPrototypeOf(MarkdownPreview.prototype), 'render', this).call(this, html);

      this.eventManager.emit('previewRenderAfter', this);
    }
  }]);

  return MarkdownPreview;
}(_preview2.default);

exports.default = MarkdownPreview;

/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements preview
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _lazyRunner = __webpack_require__(65);

var _lazyRunner2 = _interopRequireDefault(_lazyRunner);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Class Preview
 **/
var Preview = function () {
  /**
   * Creates an instance of Preview.
   * @param {jQuery} $el Container element for preview
   * @param {EventManager} eventManager Event manager instance
   * @param {Convertor} convertor Convertor instance
   * @param {boolean} isViewer - whether viewer mode or not
   * @memberof Preview
   */
  function Preview($el, eventManager, convertor, isViewer) {
    _classCallCheck(this, Preview);

    this.eventManager = eventManager;
    this.convertor = convertor;
    this.$el = $el;
    this.isViewer = !!isViewer;

    this._initContentSection();

    this.lazyRunner = new _lazyRunner2.default();

    this.lazyRunner.registerLazyRunFunction('refresh', this.refresh, 800, this);
  }

  /**
   * Initialize content selection
   * @private
   */


  _createClass(Preview, [{
    key: '_initContentSection',
    value: function _initContentSection() {
      this._$previewContent = (0, _jquery2.default)('<div class="tui-editor-contents" />');
      this.$el.append(this._$previewContent);
    }

    /**
     * Refresh rendering
     * @memberof Preview
     * @param {string} markdown Markdown text
     */

  }, {
    key: 'refresh',
    value: function refresh(markdown) {
      this.render(this.convertor.toHTMLWithCodeHightlight(markdown));
    }

    /**
     * get html string
     * @returns {string} - html preview string
     * @memberof Preview
     */

  }, {
    key: 'getHTML',
    value: function getHTML() {
      return this._$previewContent.html();
    }

    /**
     * set html string
     * @param {string} html - html preview string
     * @memberof Preview
     */

  }, {
    key: 'setHTML',
    value: function setHTML(html) {
      this._$previewContent.html(html);
    }

    /**
     * Render HTML on preview
     * @memberof Preview
     * @param {string} html HTML string
     * @protected
     */

  }, {
    key: 'render',
    value: function render(html) {
      var _$previewContent = this._$previewContent;

      html = this.eventManager.emit('previewBeforeHook', html) || html;

      _$previewContent.empty();
      _$previewContent.html(html);
    }

    /**
     * Set preview height
     * @memberof Preview
     * @param {number} height - Height for preview container
     */

  }, {
    key: 'setHeight',
    value: function setHeight(height) {
      this.$el.get(0).style.height = height + 'px';
    }

    /**
     * set min height
     * @param {number} minHeight - min height
     * @memberof Preview
     */

  }, {
    key: 'setMinHeight',
    value: function setMinHeight(minHeight) {
      this.$el.get(0).style.minHeight = minHeight + 'px';
    }

    /**
     * Is Preview visible
     * @returns {boolean} result
     */

  }, {
    key: 'isVisible',
    value: function isVisible() {
      return this.$el.css('display') !== 'none';
    }
  }]);

  return Preview;
}();

exports.default = Preview;

/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @fileoverview Implements htmlSanitizer
 * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */
var HTML_ATTR_LIST_RX = new RegExp('^(abbr|align|alt|axis|bgcolor|border|cellpadding|cellspacing|class|clear|' + 'color|cols|compact|coords|dir|face|headers|height|hreflang|hspace|' + 'ismap|lang|language|nohref|nowrap|rel|rev|rows|rules|' + 'scope|scrolling|shape|size|span|start|summary|tabindex|target|title|type|' + 'valign|value|vspace|width|checked|mathvariant|encoding|id|name|' + 'background|cite|href|longdesc|src|usemap|xlink:href|data-+|checked|style)', 'g');

var SVG_ATTR_LIST_RX = new RegExp('^(accent-height|accumulate|additive|alphabetic|arabic-form|ascent|' + 'baseProfile|bbox|begin|by|calcMode|cap-height|class|color|color-rendering|content|' + 'cx|cy|d|dx|dy|descent|display|dur|end|fill|fill-rule|font-family|font-size|font-stretch|' + 'font-style|font-variant|font-weight|from|fx|fy|g1|g2|glyph-name|gradientUnits|hanging|' + 'height|horiz-adv-x|horiz-origin-x|ideographic|k|keyPoints|keySplines|keyTimes|lang|' + 'marker-end|marker-mid|marker-start|markerHeight|markerUnits|markerWidth|mathematical|' + 'max|min|offset|opacity|orient|origin|overline-position|overline-thickness|panose-1|' + 'path|pathLength|points|preserveAspectRatio|r|refX|refY|repeatCount|repeatDur|' + 'requiredExtensions|requiredFeatures|restart|rotate|rx|ry|slope|stemh|stemv|stop-color|' + 'stop-opacity|strikethrough-position|strikethrough-thickness|stroke|stroke-dasharray|' + 'stroke-dashoffset|stroke-linecap|stroke-linejoin|stroke-miterlimit|stroke-opacity|' + 'stroke-width|systemLanguage|target|text-anchor|to|transform|type|u1|u2|underline-position|' + 'underline-thickness|unicode|unicode-range|units-per-em|values|version|viewBox|visibility|' + 'width|widths|x|x-height|x1|x2|xlink:actuate|xlink:arcrole|xlink:role|xlink:show|xlink:title|' + 'xlink:type|xml:base|xml:lang|xml:space|xmlns|xmlns:xlink|y|y1|y2|zoomAndPan)', 'g');

/**
 * htmlSanitizer
 * @param {string|Node} html html or Node
 * @param {boolean} [needHtmlText] pass true if need html text
 * @returns {string|DocumentFragment} result
 * @ignore
 */
function htmlSanitizer(html, needHtmlText) {
  var $html = (0, _jquery2.default)('<div />');

  html = html.replace(/<!--[\s\S]*?-->/g, '');

  $html.append(html);

  removeUnnecessaryTags($html);
  leaveOnlyWhitelistAttribute($html);

  return finalizeHtml($html, needHtmlText);
}

/**
 * Remove unnecessary tags
 * @private
 * @param {jQuery} $html jQuery instance
 */
function removeUnnecessaryTags($html) {
  $html.find('script, iframe, textarea, form, button, select, meta, style, link, title').remove();
}

/**
 * Leave only white list attributes
 * @private
 * @param {jQuery} $html jQuery instance
 */
function leaveOnlyWhitelistAttribute($html) {
  $html.find('*').each(function (index, node) {
    var attrs = node.attributes;
    var blacklist = _tuiCodeSnippet2.default.toArray(attrs).filter(function (attr) {
      var isHTMLAttr = attr.name.match(HTML_ATTR_LIST_RX);
      var isSVGAttr = attr.name.match(SVG_ATTR_LIST_RX);

      return !isHTMLAttr && !isSVGAttr;
    });

    _tuiCodeSnippet2.default.forEachArray(blacklist, function (attr) {
      // Edge svg attribute name returns uppercase bug. error guard.
      // https://developer.microsoft.com/en-us/microsoft-edge/platform/issues/5579311/
      if (attrs.getNamedItem(attr.name)) {
        attrs.removeNamedItem(attr.name);
      }
    });
  });
}

/**
 * Finalize html result
 * @private
 * @param {jQuery} $html jQuery instance
 * @param {boolean} needHtmlText pass true if need html text
 * @returns {string|DocumentFragment} result
 */
function finalizeHtml($html, needHtmlText) {
  var returnValue = void 0;

  if (needHtmlText) {
    returnValue = $html[0].innerHTML;
  } else {
    var frag = document.createDocumentFragment();
    var childNodes = _tuiCodeSnippet2.default.toArray($html[0].childNodes);
    var length = childNodes.length;


    for (var i = 0; i < length; i += 1) {
      frag.appendChild(childNodes[i]);
    }
    returnValue = frag;
  }

  return returnValue;
}

exports.default = htmlSanitizer;

/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements wysiwyg table manager
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _domUtils = __webpack_require__(4);

var _domUtils2 = _interopRequireDefault(_domUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var isIE10 = _tuiCodeSnippet2.default.browser.msie && _tuiCodeSnippet2.default.browser.version === 10;
var TABLE_CLASS_PREFIX = 'te-content-table-';
var isIE10And11 = _tuiCodeSnippet2.default.browser.msie && (_tuiCodeSnippet2.default.browser.version === 10 || _tuiCodeSnippet2.default.browser.version === 11);
var BASIC_CELL_CONTENT = _tuiCodeSnippet2.default.browser.msie ? '' : '<br>';
var TABLE_CELL_SELECTED_CLASS_NAME = 'te-cell-selected';

/**
 * Class WwTableManager
 */

var WwTableManager = function () {
  /**
   * Creates an instance of WwTableManager.
   * @param {WysiwygEditor} wwe - WysiwygEditor instance
   * @memberof WwTableManager
   */
  function WwTableManager(wwe) {
    _classCallCheck(this, WwTableManager);

    this.wwe = wwe;
    this.eventManager = wwe.eventManager;

    /**
     * Name property
     * @memberof WwTableManager#
     * @type {string}
     */
    this.name = 'table';

    this._lastCellNode = null;
    this._init();
  }

  /**
   * _init
   * Initialize
   * @memberof WwTableManager
   * @private
   */


  _createClass(WwTableManager, [{
    key: '_init',
    value: function _init() {
      this._initKeyHandler();
      this._initEvent();
      this.tableID = 0;
    }

    /**
     * _initEvent
     * Initialize event
     * @memberof WwTableManager
     * @private
     */

  }, {
    key: '_initEvent',
    value: function _initEvent() {
      var _this = this;

      this.eventManager.listen('wysiwygRangeChangeAfter.table', function () {
        var range = _this.wwe.getEditor().getSelection();
        var isRangeInTable = _this.isInTable(range);

        _this._unwrapBlockInTable();
        _this._completeTableIfNeed();

        if (!isRangeInTable) {
          var selectionManager = _this.wwe.componentManager.getManager('tableSelection');
          selectionManager.removeClassAttrbuteFromAllCellsIfNeed();
        }

        _this._insertDefaultBlockBetweenTable();
      });

      this.eventManager.listen('wysiwygSetValueAfter.table', function () {
        _this._unwrapBlockInTable();
        _this._insertDefaultBlockBetweenTable();
      });

      // remove last br in td or th
      this.eventManager.listen('wysiwygProcessHTMLText.table', function (html) {
        return html.replace(/<br \/>(<\/td>|<\/th>)/g, '$1');
      });

      this.eventManager.listen('cut.table', function () {
        var selectionManager = _this.wwe.componentManager.getManager('tableSelection');
        var $selectedCells = selectionManager.getSelectedCells();

        if ($selectedCells.length) {
          $selectedCells.get().forEach(function (cell) {
            return (0, _jquery2.default)(cell).html(BASIC_CELL_CONTENT);
          });
        }

        selectionManager.removeClassAttrbuteFromAllCellsIfNeed();
      });

      this.eventManager.listen('copyBefore.table', function (_ref) {
        var $clipboardContainer = _ref.$clipboardContainer;
        return _this.updateTableHtmlOfClipboardIfNeed($clipboardContainer);
      });

      this.onBindedPaste = this._onPaste.bind(this);
      this.wwe.getEditor().addEventListener('paste', this.onBindedPaste);
    }

    /**
     * Update table html of clipboard data, if has selected cells.
     * @param {jQuery} $clipboardContainer - jQuery element
     */

  }, {
    key: 'updateTableHtmlOfClipboardIfNeed',
    value: function updateTableHtmlOfClipboardIfNeed($clipboardContainer) {
      var _this2 = this;

      var selectionManager = this.wwe.componentManager.getManager('tableSelection');
      var $selectedCells = selectionManager.getSelectedCells();

      if ($selectedCells.length) {
        selectionManager.createRangeBySelectedCells();

        var fragment = this.wwe.getEditor().getSelection().cloneContents();

        (0, _jquery2.default)(fragment).children().each(function (index, node) {
          var $node = (0, _jquery2.default)(node);

          if (!_this2.isTableOrSubTableElement(node.nodeName)) {
            return;
          }

          if (node.nodeName === 'TABLE' && $node.find('thead').length === 0 && $node.find('tbody').length === 0) {
            $node.remove();
          } else if (node.previousSibling && node.previousSibling.nodeName === 'TABLE') {
            node.previousSibling.appendChild(node);
          } else {
            _this2._completeIncompleteTable(node);

            if (node.nodeName !== 'TABLE' && node.nodeName !== 'THEAD') {
              (0, _jquery2.default)(node).closest('table').find('thead').remove();
            }
          }
        });

        $clipboardContainer.append(fragment);
        $clipboardContainer.find('.' + TABLE_CELL_SELECTED_CLASS_NAME).removeClass(TABLE_CELL_SELECTED_CLASS_NAME);
      }
    }

    /**
     * Paste clibpard data.
     * @param {jQuery} $clipboardTable - jQuery table element of clipboard
     */

  }, {
    key: 'pasteClipboardData',
    value: function pasteClipboardData($clipboardTable) {
      if (this.wwe.componentManager.getManager('tableSelection').getSelectedCells().length) {
        return;
      }

      this._expandTableIfNeed($clipboardTable);
      this._pasteDataIntoTable($clipboardTable);
    }

    /**
     * On paste.
     * @param {MouseEvent} ev - event
     * @private
     */

  }, {
    key: '_onPaste',
    value: function _onPaste(ev) {
      var range = this.wwe.getEditor().getSelection();
      var isNotPastingIntoTextNode = !_domUtils2.default.isTextNode(range.commonAncestorContainer);

      if (this.isInTable(range) && !range.collapsed && isNotPastingIntoTextNode) {
        ev.preventDefault();
      }
    }

    /**
     * _initKeyHandler
     * Initialize key event handler
     * @memberof WwTableManager
     * @private
     */

  }, {
    key: '_initKeyHandler',
    value: function _initKeyHandler() {
      var _this3 = this;

      this.keyEventHandlers = {
        'DEFAULT': function DEFAULT(ev, range, keymap) {
          var isRangeInTable = _this3.isInTable(range);

          if (isRangeInTable && !_this3._isSingleModifierKey(keymap)) {
            _this3._recordUndoStateIfNeed(range);
            _this3._removeBRIfNeed(range);
            _this3._removeContentsAndChangeSelectionIfNeed(range, keymap, ev);
          } else if (!isRangeInTable && _this3._lastCellNode) {
            _this3._recordUndoStateAndResetCellNode(range);
          }

          if (isRangeInTable && !_this3._isModifierKeyPushed(ev)) {
            _this3.wwe.getEditor().modifyDocument(function () {
              var selectionManager = _this3.wwe.componentManager.getManager('tableSelection');
              selectionManager.removeClassAttrbuteFromAllCellsIfNeed();
            });
          }
        },
        'ENTER': function ENTER(ev, range) {
          var isNeedNext = void 0;

          if (_this3._isAfterTable(range)) {
            ev.preventDefault();
            range.setStart(range.startContainer, range.startOffset - 1);
            _this3.wwe.breakToNewDefaultBlock(range);
            isNeedNext = false;
          } else if (_this3._isBeforeTable(range)) {
            ev.preventDefault();
            _this3.wwe.breakToNewDefaultBlock(range, 'before');
            isNeedNext = false;
          } else if (_this3.isInTable(range)) {
            _this3._appendBrIfTdOrThNotHaveAsLastChild(range);
            isNeedNext = false;
          }

          return isNeedNext;
        },
        'BACK_SPACE': function BACK_SPACE(ev, range, keymap) {
          return _this3._handleBackspaceAndDeleteKeyEvent(ev, range, keymap);
        },
        'DELETE': function DELETE(ev, range, keymap) {
          return _this3._handleBackspaceAndDeleteKeyEvent(ev, range, keymap);
        },
        'TAB': function TAB() {
          return _this3._moveCursorTo('next', 'cell');
        },
        'SHIFT+TAB': function SHIFTTAB(ev) {
          return _this3._moveCursorTo('previous', 'cell', ev);
        },
        'UP': function UP(ev) {
          return _this3._moveCursorTo('previous', 'row', ev);
        },
        'DOWN': function DOWN(ev) {
          return _this3._moveCursorTo('next', 'row', ev);
        }
      };

      _tuiCodeSnippet2.default.forEach(this.keyEventHandlers, function (handler, key) {
        return _this3.wwe.addKeyEventHandler(key, handler);
      });
    }

    /**
     * isInTable
     * Check whether passed range is in table or not
     * @param {Range} range range
     * @returns {boolean} result
     * @memberof WwTableManager
     */

  }, {
    key: 'isInTable',
    value: function isInTable(range) {
      var target = void 0,
          result = void 0;

      if (range.collapsed) {
        target = range.startContainer;
        result = !!(0, _jquery2.default)(target).closest('[contenteditable=true] table').length;
      } else {
        target = range.commonAncestorContainer;
        result = !!(0, _jquery2.default)(target).closest('[contenteditable=true] table').length || !!(0, _jquery2.default)(range.cloneContents()).find('table').length;
      }

      return result;
    }

    /**
     * _isBeforeTable
     * Check whether passed range is right before table or not
     * @param {Range} range range
     * @returns {boolean} result
     * @memberof WwTableManager
     * @private
     */

  }, {
    key: '_isBeforeTable',
    value: function _isBeforeTable(range) {
      return _domUtils2.default.getNodeName(_domUtils2.default.getChildNodeByOffset(range.startContainer, range.startOffset)) === 'TABLE';
    }

    /**
     * _isAfterTable
     * Check whether passed range is right after table or not
     * @param {Range} range range
     * @returns {boolean} result
     * @memberof WwTableManager
     * @private
     */

  }, {
    key: '_isAfterTable',
    value: function _isAfterTable(range) {
      var prevElem = _domUtils2.default.getPrevOffsetNodeUntil(range.startContainer, range.startOffset);

      return _domUtils2.default.getNodeName(prevElem) === 'TABLE' && range.commonAncestorContainer === this.wwe.get$Body()[0];
    }

    /**
     * Handle backspace and delete key event
     * @param {object} ev - Event object
     * @param {Range} range - Range Object
     * @param {string} keymap - keymap
     * @returns {boolean} - need next
     * @private
     */

  }, {
    key: '_handleBackspaceAndDeleteKeyEvent',
    value: function _handleBackspaceAndDeleteKeyEvent(ev, range, keymap) {
      var isBackspace = keymap === 'BACK_SPACE';
      var selectionManager = this.wwe.componentManager.getManager('tableSelection');
      var $selectedCells = selectionManager.getSelectedCells();
      var isNeedNext = true;

      if (range.collapsed) {
        if (this.isInTable(range)) {
          if (isBackspace) {
            this._tableHandlerOnBackspace(range, ev);
          } else {
            this._tableHandlerOnDelete(range, ev);
          }

          this._insertBRIfNeed(range);
          this._removeContentsAndChangeSelectionIfNeed(range, keymap, ev);
          isNeedNext = false;
        } else if (!isBackspace && this._isBeforeTable(range) || isBackspace && this._isAfterTable(range)) {
          ev.preventDefault();
          var startOffset = isBackspace ? range.startOffset - 1 : range.startOffset;
          this._removeTable(range, _domUtils2.default.getChildNodeByOffset(range.startContainer, startOffset));
          isNeedNext = false;
        }
      } else if (this.isInTable(range)) {
        if ($selectedCells.length > 0) {
          var removed = this._removeContentsAndChangeSelectionIfNeed(range, keymap, ev);
          if (removed) {
            ev.preventDefault();
            isNeedNext = false;
          }
        }
      }

      return isNeedNext;
    }

    /**
     * _tableHandlerOnBackspace
     * Backspace handler in table
     * @param {Range} range range
     * @param {Event} event event
     * @memberof WwTableManager
     * @private
     */

  }, {
    key: '_tableHandlerOnBackspace',
    value: function _tableHandlerOnBackspace(range, event) {
      var prevNode = _domUtils2.default.getPrevOffsetNodeUntil(range.startContainer, range.startOffset, 'TR'),
          prevNodeName = _domUtils2.default.getNodeName(prevNode);

      if (!prevNode || prevNodeName === 'TD' || prevNodeName === 'TH') {
        event.preventDefault();
      } else if (prevNodeName === 'BR' && prevNode.parentNode.childNodes.length !== 1) {
        event.preventDefault();
        (0, _jquery2.default)(prevNode).remove();
      }
    }
    /**
     * Return whether delete non text or not
     * @param {Range} range Range object
     * @returns {boolean}
     */

  }, {
    key: 'isNonTextDeleting',
    value: function isNonTextDeleting(range) {
      var currentElement = range.startContainer;
      var nextNode = currentElement.nextSibling;
      var nextNodeName = _domUtils2.default.getNodeName(nextNode);
      var currentNodeName = _domUtils2.default.getNodeName(currentElement);

      var isCellDeleting = currentNodeName === nextNodeName && currentNodeName !== 'TEXT';
      var isEndOfText = (!nextNode || nextNodeName === 'BR' && nextNode.parentNode.lastChild === nextNode) && _domUtils2.default.isTextNode(currentElement) && range.startOffset === currentElement.nodeValue.length;
      var isLastCellOfRow = !isEndOfText && (0, _jquery2.default)(currentElement).parents('tr').children().last()[0] === currentElement && (currentNodeName === 'TD' || currentNodeName === 'TH');

      return isCellDeleting || isEndOfText || isLastCellOfRow;
    }
    /**
     * _tableHandlerOnDelete
     * Delete handler in table
     * @param {Range} range range
     * @param {Event} event event
     * @memberof WwTableManager
     * @private
     */

  }, {
    key: '_tableHandlerOnDelete',
    value: function _tableHandlerOnDelete(range, event) {
      var needPreventDefault = this.isNonTextDeleting(range);

      if (needPreventDefault) {
        event.preventDefault();
        range.startContainer.normalize();
      }
    }

    /**
     * _appendBrIfTdOrThNotHaveAsLastChild
     * Append br if td or th doesn't have br as last child
     * @param {Range} range range
     * @memberof WwTableManager
     * @private
     */

  }, {
    key: '_appendBrIfTdOrThNotHaveAsLastChild',
    value: function _appendBrIfTdOrThNotHaveAsLastChild(range) {
      var startContainerNodeName = _domUtils2.default.getNodeName(range.startContainer);
      var tdOrTh = void 0;

      if (startContainerNodeName === 'TD' || startContainerNodeName === 'TH') {
        tdOrTh = range.startContainer;
      } else {
        var paths = (0, _jquery2.default)(range.startContainer).parentsUntil('tr');
        tdOrTh = paths[paths.length - 1];
      }

      if (_domUtils2.default.getNodeName(tdOrTh.lastChild) !== 'BR' && _domUtils2.default.getNodeName(tdOrTh.lastChild) !== 'DIV' && !isIE10And11) {
        (0, _jquery2.default)(tdOrTh).append((0, _jquery2.default)('<br />')[0]);
      }
    }

    /**
     * _unwrapBlockInTable
     * Unwrap default block tag in table
     * For Squire default action making abnormal behavior, remove default blocks in Table after setValue() called
     * @memberof WwTableManager
     * @private
     */

  }, {
    key: '_unwrapBlockInTable',
    value: function _unwrapBlockInTable() {
      this.wwe.get$Body().find('td div,th div,tr>br,td>br,th>br').each(function (index, node) {
        if (_domUtils2.default.getNodeName(node) === 'BR') {
          var parentNodeName = _domUtils2.default.getNodeName(node.parentNode);
          var isInTableCell = /TD|TH/.test(parentNodeName);
          var isEmptyTableCell = node.parentNode.textContent.length === 0;
          var isLastBR = node.parentNode.lastChild === node;

          if (parentNodeName === 'TR' || isInTableCell && !isEmptyTableCell && isLastBR) {
            (0, _jquery2.default)(node).remove();
          }
        } else {
          (0, _jquery2.default)(node).children().unwrap();
        }
      });
    }

    /**
     * Insert default block between table element
     * @private
     */

  }, {
    key: '_insertDefaultBlockBetweenTable',
    value: function _insertDefaultBlockBetweenTable() {
      this.wwe.get$Body().find('table').each(function (index, node) {
        if (node.nextElementSibling && node.nextElementSibling.nodeName === 'TABLE') {
          (0, _jquery2.default)('<div><br /></div>').insertAfter(node);
        }
      });
    }

    /**
     * _removeTable
     * Remove table
     * @param {Range} range range
     * @param {Node} table table
     * @memberof WwTableManager
     * @private
     */

  }, {
    key: '_removeTable',
    value: function _removeTable(range, table) {
      if (table.tagName === 'TABLE') {
        this.wwe.getEditor().saveUndoState(range);
        this.wwe.saveSelection(range);
        (0, _jquery2.default)(table).remove();
        this.wwe.restoreSavedSelection();
      }
    }

    /**
     * _recordUndoStateIfNeed
     * record undo state if need
     * @param {Range} range range
     * @memberof WwTableManager
     * @private
     */

  }, {
    key: '_recordUndoStateIfNeed',
    value: function _recordUndoStateIfNeed(range) {
      var currentCellNode = _domUtils2.default.getParentUntil(range.startContainer, 'TR');

      if (range.collapsed && currentCellNode && this._lastCellNode !== currentCellNode) {
        this.wwe.getEditor().saveUndoState(range);
        this._lastCellNode = currentCellNode;
      }
    }

    /**
     * _recordUndoStateAndResetCellNode
     * record undo state and reset last cell node
     * @param {Range} range range
     * @memberof WwTableManager
     * @private
     */

  }, {
    key: '_recordUndoStateAndResetCellNode',
    value: function _recordUndoStateAndResetCellNode(range) {
      this.wwe.getEditor().saveUndoState(range);
      this.resetLastCellNode();
    }

    /**
     * Paste table data into table element
     * @param {DocumentFragment} fragment Fragment of table element within
     * @private
     */

  }, {
    key: '_pasteDataIntoTable',
    value: function _pasteDataIntoTable(fragment) {
      var _wwe$getEditor$getSel = this.wwe.getEditor().getSelection(),
          startContainer = _wwe$getEditor$getSel.startContainer;

      var parentNode = startContainer.parentNode;

      var tableData = this._getTableDataFromTable(fragment);
      var isTextInTableCell = parentNode.tagName === 'TD' || parentNode.tagName === 'TH';
      var isTableCell = startContainer.tagName === 'TD' || startContainer.tagName === 'TH';
      var isTextNode = startContainer.nodeType === 3;
      var brString = isIE10 ? '' : '<br />';
      var anchorElement = void 0,
          td = void 0,
          tr = void 0,
          tdContent = void 0;

      if (isTextNode && isTextInTableCell) {
        anchorElement = parentNode;
      } else if (isTableCell) {
        anchorElement = startContainer;
      } else {
        anchorElement = (0, _jquery2.default)(startContainer).find('th,td').get(0);
      }

      td = anchorElement;

      while (tableData.length) {
        tr = tableData.shift();

        while (td && tr.length) {
          tdContent = tr.shift();

          if (tdContent.length) {
            td.textContent = tdContent;
          } else {
            td.innerHTML = brString;
          }

          td = _domUtils2.default.getTableCellByDirection(td, 'next');
        }

        td = _domUtils2.default.getSiblingRowCellByDirection(anchorElement, 'next', false);
        anchorElement = td;
      }
    }

    /**
     * Get array data from table element
     * @param {DocumentFragment} fragment table element
     * @returns {Array}
     * @private
     */

  }, {
    key: '_getTableDataFromTable',
    value: function _getTableDataFromTable(fragment) {
      var $fragment = (0, _jquery2.default)(fragment);
      var tableData = [];
      var trs = $fragment.find('tr');

      trs.each(function (i, tr) {
        var trData = [];
        var tds = (0, _jquery2.default)(tr).children();

        tds.each(function (index, cell) {
          trData.push(cell.textContent);
        });

        if (trData.length) {
          tableData.push(trData);
        }
      });

      return tableData;
    }

    /**
     * Remove selected table contents
     * @param {jQuery} $selectedCells Selected cells wrapped by jQuery
     * @private
     */

  }, {
    key: '_removeTableContents',
    value: function _removeTableContents($selectedCells) {
      this.wwe.getEditor().saveUndoState();

      $selectedCells.each(function (i, cell) {
        var brHTMLString = isIE10 ? '' : '<br />';
        (0, _jquery2.default)(cell).html(brHTMLString);
      });
    }

    /**
     * Wrap dangling table cells with new TR
     * @param {jQuery} $container - clipboard container
     * @returns {HTMLElement|null}
     */

  }, {
    key: 'wrapDanglingTableCellsIntoTrIfNeed',
    value: function wrapDanglingTableCellsIntoTrIfNeed($container) {
      var danglingTableCells = $container.children('td,th');
      var tr = void 0;

      if (danglingTableCells.length) {
        var $wrapperTr = (0, _jquery2.default)('<tr></tr>');

        danglingTableCells.each(function (i, cell) {
          $wrapperTr.append(cell);
        });

        tr = $wrapperTr.get(0);
      }

      return tr;
    }

    /**
     * Wrap TRs with new TBODY
     * @param {jQuery} $container - clipboard container
     * @returns {HTMLElement|null}
     */

  }, {
    key: 'wrapTrsIntoTbodyIfNeed',
    value: function wrapTrsIntoTbodyIfNeed($container) {
      var danglingTrs = $container.children('tr');
      var ths = danglingTrs.find('th');
      var tbody = void 0;

      if (ths.length) {
        ths.each(function (i, node) {
          var $node = (0, _jquery2.default)(node);
          var td = (0, _jquery2.default)('<td></td>');

          td.html($node.html());
          td.insertBefore(node);

          $node.detach();
        });
      }

      if (danglingTrs.length) {
        var $wrapperTableBody = (0, _jquery2.default)('<tbody></tbody>');

        danglingTrs.each(function (i, tr) {
          $wrapperTableBody.append(tr);
        });

        tbody = $wrapperTableBody.get(0);
      }

      return tbody;
    }

    /**
     * Wrap THEAD followed by TBODY both into Table
     * @param {jQuery} $container - clipboard container
     * @returns {HTMLElement|null}
     */

  }, {
    key: 'wrapTheadAndTbodyIntoTableIfNeed',
    value: function wrapTheadAndTbodyIntoTableIfNeed($container) {
      var danglingThead = $container.children('thead');
      var danglingTbody = $container.children('tbody');
      var $wrapperTable = (0, _jquery2.default)('<table></table>');
      var table = void 0;

      if (!danglingTbody.length && danglingThead.length) {
        $wrapperTable.append(danglingThead[0]);
        $wrapperTable.append('<tbody><tr></tr></tbody>');
        table = $wrapperTable.get(0);
      } else if (danglingTbody.length && !danglingThead.length) {
        $wrapperTable.append('<thead><tr></tr></thead>');
        $wrapperTable.append(danglingTbody[0]);
        table = $wrapperTable.get(0);
      } else if (danglingTbody.length && danglingThead.length) {
        $wrapperTable.append(danglingThead[0]);
        $wrapperTable.append(danglingTbody[0]);
        table = $wrapperTable.get(0);
      }

      return table;
    }

    /**
     * Whether pasting element is table element
     * @param {string} pastingNodeName Pasting node name
     * @returns {boolean}
     */

  }, {
    key: 'isTableOrSubTableElement',
    value: function isTableOrSubTableElement(pastingNodeName) {
      return pastingNodeName === 'TABLE' || pastingNodeName === 'TBODY' || pastingNodeName === 'THEAD' || pastingNodeName === 'TR' || pastingNodeName === 'TD';
    }

    /**
     * Stuff table cells into incomplete rows
     * @param {jQuery} $trs jQuery wrapped TRs
     * @param {number} maximumCellLength maximum cell length of table
     * @private
     */

  }, {
    key: '_stuffTableCellsIntoIncompleteRow',
    value: function _stuffTableCellsIntoIncompleteRow($trs, maximumCellLength) {
      $trs.each(function (rowIndex, row) {
        var $row = (0, _jquery2.default)(row);
        var tableCells = $row.find('th,td');
        var parentNodeName = _domUtils2.default.getNodeName($row.parent()[0]);
        var cellTagName = parentNodeName === 'THEAD' ? 'th' : 'td';

        for (var cellLength = tableCells.length; cellLength < maximumCellLength; cellLength += 1) {
          $row.append((0, _jquery2.default)(tableCellGenerator(1, cellTagName))[0]);
        }
      });
    }

    /**
     * Prepare to table cell stuffing
     * @param {jQuery} $trs jQuery wrapped TRs
     * @returns {{maximumCellLength: *, needTableCellStuffingAid: boolean}}
     */

  }, {
    key: 'prepareToTableCellStuffing',
    value: function prepareToTableCellStuffing($trs) {
      var maximumCellLength = $trs.eq(0).find('th,td').length;
      var needTableCellStuffingAid = false;

      $trs.each(function (i, row) {
        var cellCount = (0, _jquery2.default)(row).find('th,td').length;

        if (maximumCellLength !== cellCount) {
          needTableCellStuffingAid = true;

          if (maximumCellLength < cellCount) {
            maximumCellLength = cellCount;
          }
        }
      });

      return {
        maximumCellLength: maximumCellLength,
        needTableCellStuffingAid: needTableCellStuffingAid
      };
    }

    /**
     * Add TBODY or THEAD if need
     * @param {jQuery} $table - Table jQuery element
     * @private
     */

  }, {
    key: '_addTbodyOrTheadIfNeed',
    value: function _addTbodyOrTheadIfNeed($table) {
      var isTheadNotExists = !$table.find('thead').length;
      var isTbodyNotExists = !$table.find('tbody').length;
      var absentNode = void 0;

      if (isTheadNotExists) {
        absentNode = (0, _jquery2.default)('<thead><tr></tr></thead>').get(0);
        $table.prepend(absentNode);
      } else if (isTbodyNotExists) {
        absentNode = (0, _jquery2.default)('<tbody><tr></tr></tbody>').get(0);
        $table.append(absentNode);
      }
    }

    /**
     * Append table cells
     * @param {HTMLElement} node Table element
     */

  }, {
    key: 'tableCellAppendAidForTableElement',
    value: function tableCellAppendAidForTableElement(node) {
      var $table = (0, _jquery2.default)(node);

      this._addTbodyOrTheadIfNeed($table);
      this._addTrIntoContainerIfNeed($table);

      var $trs = $table.find('tr');
      var tableAidInformation = this.prepareToTableCellStuffing($trs);
      var maximumCellLength = tableAidInformation.maximumCellLength,
          needTableCellStuffingAid = tableAidInformation.needTableCellStuffingAid;


      if (needTableCellStuffingAid) {
        this._stuffTableCellsIntoIncompleteRow($trs, maximumCellLength);
      }
    }

    /**
     * Generate THEAD and append TDs with same amount of given TBODY
     * @param {HTMLElement} node TR element
     * @returns {{thead: HTMLElement, tbody: HTMLElement}}
     * @private
     */

  }, {
    key: '_generateTheadAndTbodyFromTbody',
    value: function _generateTheadAndTbodyFromTbody(node) {
      var tr = (0, _jquery2.default)('<tr></tr>');
      var thead = (0, _jquery2.default)('<thead></thead>');

      tr.append(tableCellGenerator((0, _jquery2.default)(node).find('tr').eq(0).find('td').length, 'th'));
      thead.append(tr);

      return {
        thead: thead[0],
        tbody: node
      };
    }

    /**
     * Generate TBODY and append TDs with same amount of given THEAD
     * @param {HTMLElement} node TR element
     * @returns {{thead: HTMLElement, tbody: HTMLElement}}
     * @private
     */

  }, {
    key: '_generateTheadAndTbodyFromThead',
    value: function _generateTheadAndTbodyFromThead(node) {
      var tr = (0, _jquery2.default)('<tr></tr>');
      var tbody = (0, _jquery2.default)('<tbody></tbody>');

      tr.append(tableCellGenerator((0, _jquery2.default)(node).find('th').length, 'td'));
      tbody.append(tr);

      return {
        thead: node,
        tbody: tbody[0]
      };
    }

    /**
     * Generate THEAD and TBODY and append given TR within
     * @param {HTMLElement} node TR element
     * @returns {{thead: HTMLElement, tbody: HTMLElement}}
     * @private
     */

  }, {
    key: '_generateTheadAndTbodyFromTr',
    value: function _generateTheadAndTbodyFromTr(node) {
      var $node = (0, _jquery2.default)(node);
      var thead = (0, _jquery2.default)('<thead></thead>');
      var tbody = (0, _jquery2.default)('<tbody></tbody>');
      var theadRow = void 0,
          tbodyRow = void 0;

      if ($node.children()[0].tagName === 'TH') {
        theadRow = node;
        tbodyRow = (0, _jquery2.default)('<tr>' + tableCellGenerator($node.find('th').length, 'td') + '</tr>').get(0);
      } else {
        theadRow = (0, _jquery2.default)('<tr>' + tableCellGenerator($node.find('td').length, 'th') + '</tr>').get(0);
        tbodyRow = node;
      }

      thead.append(theadRow);
      tbody.append(tbodyRow);

      return {
        thead: thead[0],
        tbody: tbody[0]
      };
    }

    /**
     * Complete passed table
     * @param {HTMLElement} node - Table inner element
     * @param {?boolean} useHeader - whether use header or not
     * @private
     */

  }, {
    key: '_completeIncompleteTable',
    value: function _completeIncompleteTable(node, useHeader) {
      var nodeName = node.tagName;
      var table = void 0,
          completedTableContents = void 0;

      useHeader = _tuiCodeSnippet2.default.isUndefined(useHeader) ? true : useHeader;

      if (nodeName === 'TABLE') {
        table = node;
      } else {
        table = (0, _jquery2.default)('<table></table>');
        table.insertAfter(node);

        if (nodeName === 'TBODY') {
          completedTableContents = this._generateTheadAndTbodyFromTbody(node);
        } else if (nodeName === 'THEAD') {
          completedTableContents = this._generateTheadAndTbodyFromThead(node);
        } else if (nodeName === 'TR') {
          completedTableContents = this._generateTheadAndTbodyFromTr(node);
        }

        if (useHeader) {
          table.append(completedTableContents.thead);
        }

        table.append(completedTableContents.tbody);
      }

      this.tableCellAppendAidForTableElement(table);
    }

    /**
     * Whole editor body searching incomplete table completion
     * @private
     */

  }, {
    key: '_completeTableIfNeed',
    value: function _completeTableIfNeed() {
      var _this4 = this;

      var $body = this.wwe.getEditor().get$Body();

      $body.children().each(function (index, node) {
        var $node = (0, _jquery2.default)(node);

        if (!_this4.isTableOrSubTableElement(node.nodeName)) {
          return;
        } else if (node.nodeName === 'TABLE' && $node.find('thead').length === 0 && $node.find('tbody').length === 0) {
          $node.remove();
        }

        _this4._completeIncompleteTable(node);
      });
    }

    /**
     * Reset _lastCellNode to null
     * @memberof WwTableManager
     */

  }, {
    key: 'resetLastCellNode',
    value: function resetLastCellNode() {
      this._lastCellNode = null;
    }
    /**
     * Set _lastCellNode to given node
     * @param {HTMLElement} node Table cell
     * @memberof WwTableManager
     */

  }, {
    key: 'setLastCellNode',
    value: function setLastCellNode(node) {
      this._lastCellNode = node;
    }

    /**
     * Return whether only modifier key pressed or not
     * @param {string} keymap Pressed keymap string
     * @returns {boolean}
     * @private
     */

  }, {
    key: '_isSingleModifierKey',
    value: function _isSingleModifierKey(keymap) {
      return keymap === 'META' || keymap === 'SHIFT' || keymap === 'ALT' || keymap === 'CONTROL';
    }

    /**
     * Return whether modifier keys pressed or not
     * @param {object} ev keyboard event object
     * @returns {boolean}
     * @private
     */

  }, {
    key: '_isModifierKeyPushed',
    value: function _isModifierKeyPushed(ev) {
      return ev.metaKey || ev.ctrlKey || ev.altKey || ev.shiftKey;
    }

    /**
     * Add one row into empty TBODY
     * @param {jQuery} $table Currently processing table
     * @private
     */

  }, {
    key: '_addTrIntoContainerIfNeed',
    value: function _addTrIntoContainerIfNeed($table) {
      var $trContainers = $table.children();

      $trContainers.each(function (i, container) {
        var hasNoRows = (0, _jquery2.default)(container).find('tr').length === 0;

        if (hasNoRows) {
          (0, _jquery2.default)(container).append((0, _jquery2.default)('<tr></tr>')[0]);
        }
      });
    }
  }, {
    key: '_expandTableIfNeed',
    value: function _expandTableIfNeed(fragment) {
      var range = this.wwe.getEditor().getSelection().cloneRange();
      var $table = (0, _jquery2.default)(range.startContainer).parents('table');
      var difference = this._getColumnAndRowDifference(fragment, range);

      if (difference.column < 0) {
        this._appendCellForAllRow($table, difference.column);
      }

      if (difference.row < 0) {
        this._appendRow($table, difference.row);
      }
    }
  }, {
    key: '_getColumnAndRowDifference',
    value: function _getColumnAndRowDifference(fragment, range) {
      var tableData = this._getTableDataFromTable(fragment);
      var rowLength = tableData.length;
      var columnLength = tableData[0].length;
      var $currentCell = (0, _jquery2.default)(range.startContainer).closest('th,td');
      var $currentRow = $currentCell.parent();
      var currentColumnIndex = _domUtils2.default.getNodeOffsetOfParent($currentCell[0]);
      var currentRowIndex = _domUtils2.default.getNodeOffsetOfParent($currentCell[0].parentNode);
      var $table = $currentRow.parents('table');
      var tableColumnLength = $table.find('tr').eq(0).children().length;
      var tableRowLength = $table.find('tr').length;
      var isInTbody = $currentRow.parents('tbody').length;

      if (isInTbody) {
        currentRowIndex += 1;
      }

      return {
        row: tableRowLength - (currentRowIndex + rowLength),
        column: tableColumnLength - (currentColumnIndex + columnLength)
      };
    }
  }, {
    key: '_appendCellForAllRow',
    value: function _appendCellForAllRow($table, columnDifference) {
      var brString = isIE10 ? '' : '<br />';

      $table.find('tr').each(function (i, row) {
        var tagName = void 0;

        for (var index = columnDifference; index < 0; index += 1) {
          if (i === 0) {
            tagName = 'th';
          } else {
            tagName = 'td';
          }
          (0, _jquery2.default)(row).append((0, _jquery2.default)('<' + tagName + '>' + brString + '</' + tagName + '>')[0]);
        }
      });
    }
  }, {
    key: '_appendRow',
    value: function _appendRow($table, rowDifference) {
      var newRow = $table.find('tr').last().clone();
      var brHTMLSting = isIE10 ? '' : '<br />';

      newRow.find('td').html(brHTMLSting);

      for (; rowDifference < 0; rowDifference += 1) {
        $table.find('tbody').append(newRow.clone()[0]);
      }
    }

    /**
     * Get sibling textNode by given direction
     * @param {HTMLElement} currentTextNode Current text node
     * @param {boolean} isNext Boolean value whether direction equals 'next'
     * @returns {boolean|null}
     * @private
     */

  }, {
    key: '_getSiblingTextNodeByDirection',
    value: function _getSiblingTextNodeByDirection(currentTextNode, isNext) {
      var isPreviousLineExist = currentTextNode.previousSibling && currentTextNode.previousSibling.nodeName === 'BR' && currentTextNode.previousSibling.previousSibling && currentTextNode.previousSibling.previousSibling.nodeType === 3;
      var isNextLineExist = currentTextNode.nextSibling && currentTextNode.nextSibling.nodeName === 'BR' && currentTextNode.nextSibling.nextSibling && currentTextNode.nextSibling.nextSibling.nodeType === 3;
      var target = void 0;

      if (isNext && isNextLineExist) {
        target = currentTextNode.nextSibling.nextSibling;
      } else if (!isNext && isPreviousLineExist) {
        target = currentTextNode.previousSibling.previousSibling;
      }

      return target;
    }

    /**
     * Change selection to sibling cell
     * @param {HTMLElement} currentCell current TD or TH
     * @param {Range} range Range object
     * @param {string} direction 'next' or 'previous'
     * @param {string} scale 'row' or 'cell'
     * @private
     */

  }, {
    key: '_changeSelectionToTargetCell',
    value: function _changeSelectionToTargetCell(currentCell, range, direction, scale) {
      var startContainer = range.startContainer;

      var isNext = direction === 'next';
      var isRow = scale === 'row';
      var target = void 0,
          textOffset = void 0;

      if (isRow) {
        if (_domUtils2.default.isTextNode(startContainer)) {
          target = this._getSiblingTextNodeByDirection(startContainer, isNext);
          if (target) {
            textOffset = target.length < range.startOffset ? target.length : range.startOffset;

            range.setStart(target, textOffset);
            range.collapse(true);

            return;
          }
        }

        target = _domUtils2.default.getSiblingRowCellByDirection(currentCell, direction, false);
      } else {
        target = _domUtils2.default.getTableCellByDirection(currentCell, direction);
        if (!target) {
          target = _domUtils2.default.getSiblingRowCellByDirection(currentCell, direction, true);
        }
      }

      if (target) {
        range.setStart(target, 0);
        range.collapse(true);
      } else {
        target = (0, _jquery2.default)(currentCell).parents('table').get(0);
        if (isNext) {
          range.setStart(target.nextElementSibling, 0);
        } else if (target.previousElementSibling && target.previousElementSibling.nodeName !== 'TABLE') {
          range.setStart(target.previousElementSibling, 1);
        } else {
          range.setStartBefore(target);
        }

        range.collapse(true);
      }
    }

    /**
     * Move cursor to given direction by interval formatter
     * @param {string} direction 'next' or 'previous'
     * @param {string} interval 'row' or 'cell'
     * @param {object} [ev] Event object
     * @returns {boolean | null}
     * @private
     */

  }, {
    key: '_moveCursorTo',
    value: function _moveCursorTo(direction, interval, ev) {
      var sq = this.wwe.getEditor();
      var range = sq.getSelection().cloneRange();
      var currentCell = (0, _jquery2.default)(range.startContainer).closest('td,th').get(0);
      var isNeedNext = void 0;

      if (range.collapsed) {
        if (this.isInTable(range) && currentCell) {
          if ((direction === 'previous' || interval === 'row') && !_tuiCodeSnippet2.default.isUndefined(ev)) {
            ev.preventDefault();
          }

          this._changeSelectionToTargetCell(currentCell, range, direction, interval);
          sq.setSelection(range);

          isNeedNext = false;
        }
      }

      return isNeedNext;
    }

    /**
     * Remove contents and change selection if need
     * @param {Range} range - Range object
     * @param {string} keymap - keymap
     * @param {object} ev - Event object
     * @returns {boolean} - true if contents has been removed
     * @private
     */

  }, {
    key: '_removeContentsAndChangeSelectionIfNeed',
    value: function _removeContentsAndChangeSelectionIfNeed(range, keymap, ev) {
      var isTextInput = keymap.length <= 1;
      var isDeleteOperation = keymap === 'BACK_SPACE' || keymap === 'DELETE';
      var $selectedCells = this.wwe.componentManager.getManager('tableSelection').getSelectedCells();
      var firstSelectedCell = $selectedCells.first().get(0);
      var processed = false;

      if ((isTextInput || isDeleteOperation) && !this._isModifierKeyPushed(ev) && $selectedCells.length) {
        if (isDeleteOperation) {
          this._recordUndoStateIfNeed(range);
        }
        this._removeTableContents($selectedCells);

        this._lastCellNode = firstSelectedCell;

        range.setStart(firstSelectedCell, 0);
        range.collapse(true);
        this.wwe.getEditor().setSelection(range);
        processed = true;
      }

      return processed;
    }

    /**
     * Return new table ID class name string
     * @returns {string}
     * @memberof WwTableManager
     */

  }, {
    key: 'getTableIDClassName',
    value: function getTableIDClassName() {
      var tableClassName = TABLE_CLASS_PREFIX + this.tableID;
      this.tableID += 1;

      return tableClassName;
    }

    /**
     * Remove br when text inputted
     * @param {Range} range Range object
     * @private
     */

  }, {
    key: '_removeBRIfNeed',
    value: function _removeBRIfNeed(range) {
      var isText = _domUtils2.default.isTextNode(range.startContainer);
      var startContainer = isText ? range.startContainer.parentNode : range.startContainer;
      var nodeName = _domUtils2.default.getNodeName(startContainer);

      if (/td|th/i.test(nodeName) && range.collapsed && startContainer.textContent.length === 1) {
        (0, _jquery2.default)(startContainer).find('br').remove();
      }
    }

    /**
     * Insert br when text deleted
     * @param {Range} range Range object
     * @private
     */

  }, {
    key: '_insertBRIfNeed',
    value: function _insertBRIfNeed(range) {
      var isText = _domUtils2.default.isTextNode(range.startContainer);
      var currentCell = isText ? range.startContainer.parentNode : range.startContainer;
      var nodeName = _domUtils2.default.getNodeName(currentCell);
      var $currentCell = (0, _jquery2.default)(currentCell);

      if (/td|th/i.test(nodeName) && range.collapsed && !currentCell.textContent.length && !$currentCell.children().length && !isIE10And11) {
        currentCell.normalize();
        $currentCell.append('<br>');
      }
    }

    /**
     * Destroy.
     */

  }, {
    key: 'destroy',
    value: function destroy() {
      var _this5 = this;

      this.eventManager.removeEventHandler('wysiwygRangeChangeAfter.table');
      this.eventManager.removeEventHandler('wysiwygSetValueAfter.table');
      this.eventManager.removeEventHandler('wysiwygProcessHTMLText.table');
      this.eventManager.removeEventHandler('cut.table');
      this.eventManager.removeEventHandler('copyBefore.table');
      this.wwe.getEditor().removeEventListener('paste', this.onBindedPaste);
      _tuiCodeSnippet2.default.forEach(this.keyEventHandlers, function (handler, key) {
        return _this5.wwe.removeKeyEventHandler(key, handler);
      });
    }
  }]);

  return WwTableManager;
}();

/**
 * Generate table cell HTML text
 * @param {number} amount Amount of cells
 * @param {string} tagName Tag name of cell 'td' or 'th'
 * @private
 * @returns {string}
 */


function tableCellGenerator(amount, tagName) {
  var brHTMLString = '<br />';
  var cellString = '<' + tagName + '>' + brHTMLString + '</' + tagName + '>';
  var tdString = '';

  for (var i = 0; i < amount; i += 1) {
    tdString = tdString + cellString;
  }

  return tdString;
}

exports.default = WwTableManager;

/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements wysiwyg table selection manager
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _domUtils = __webpack_require__(4);

var _domUtils2 = _interopRequireDefault(_domUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var TABLE_CELL_SELECTED_CLASS_NAME = 'te-cell-selected';

/**
 * Class WwTableSelectionManager
 */

var WwTableSelectionManager = function () {
  /**
     * Creates an instance of WwTableSelectionManager.
     * @param {WysiwygEditor} wwe - WysiwygEditor instance
     * @memberof WwTableSelectionManager
     */
  function WwTableSelectionManager(wwe) {
    _classCallCheck(this, WwTableSelectionManager);

    this.wwe = wwe;
    this.eventManager = wwe.eventManager;

    /**
         * Name property
         * @memberof WwTableSelectionManager#
         * @type {string}
         */
    this.name = 'tableSelection';

    this._init();
  }

  /**
     * _init
     * Initialize
     * @memberof WwTableSelectionManager
     * @private
     */


  _createClass(WwTableSelectionManager, [{
    key: '_init',
    value: function _init() {
      this._initEvent();

      // For disable firefox's table tool UI and table resize handler
      if (_tuiCodeSnippet2.default.browser.firefox) {
        document.execCommand('enableObjectResizing', false, 'false');
        document.execCommand('enableInlineTableEditing', false, 'false');
      }
    }

    /**
       * _initEvent
       * Initialize event
       * @memberof WwTableSelectionManager
       * @private
       */

  }, {
    key: '_initEvent',
    value: function _initEvent() {
      var _this = this;

      var selectionStart = void 0,
          selectionEnd = void 0,
          validSelectionEnd = void 0;

      /**
           * Start table selection timer
           * @type {object}
           * @private
           */
      this._tableSelectionTimer = null;
      /**
           * Remove selection timer for Firefox table selection
           * @type {object}
           * @private
           */
      this._removeSelectionTimer = null;
      /**
           * Boolean value for whether selection started
           * @type {boolean}
           * @private
           */
      this._isSelectionStarted = false;

      var onMouseover = function onMouseover(ev) {
        selectionEnd = (0, _jquery2.default)(ev.data.target).closest('[contenteditable=true] td,th').get(0);

        var range = _this.wwe.getEditor().getSelection();
        var isEndsInTable = (0, _jquery2.default)(selectionEnd).parents('[contenteditable=true] table').get(0);
        var isSameCell = selectionStart === selectionEnd;
        var isTextSelect = _this._isTextSelect(range, isSameCell) && !(0, _jquery2.default)(selectionStart).hasClass(TABLE_CELL_SELECTED_CLASS_NAME);

        if (_this._isSelectionStarted && isEndsInTable && !isTextSelect) {
          window.getSelection().removeAllRanges();
          // For disable firefox's native table cell selection
          if (_tuiCodeSnippet2.default.browser.firefox && !_this._removeSelectionTimer) {
            _this._removeSelectionTimer = setInterval(function () {
              window.getSelection().removeAllRanges();
            }, 10);
          }
          _this.highlightTableCellsBy(selectionStart, selectionEnd);
          validSelectionEnd = selectionEnd;
        }
      };

      var finishSelection = function finishSelection() {
        if (_this._isSelectionStarted) {
          _this._isSelectionStarted = false;
          _this.eventManager.removeEventHandler('mouseover.tableSelection');
          _this.eventManager.removeEventHandler('mouseup.tableSelection');
        }
      };

      var onMouseup = function onMouseup(ev) {
        selectionEnd = (0, _jquery2.default)(ev.data.target).closest('[contenteditable=true] td,th').get(0);

        var range = _this.wwe.getEditor().getSelection();
        var isSameCell = selectionStart === selectionEnd;
        var isTextSelect = _this._isTextSelect(range, isSameCell) && !(0, _jquery2.default)(selectionStart).hasClass(TABLE_CELL_SELECTED_CLASS_NAME);

        _this._clearTableSelectionTimerIfNeed();

        if (_this._isSelectionStarted) {
          if (isTextSelect) {
            _this.removeClassAttrbuteFromAllCellsIfNeed();
          } else {
            _this.wwe.componentManager.getManager('table').resetLastCellNode();

            selectionEnd = selectionEnd || validSelectionEnd;

            range = _this.wwe.getEditor().getSelection();
            range.setStart(selectionEnd, 0);
            // IE wont fire copy/cut event if there is no selected range.
            // trick IE to fire the event
            if (_tuiCodeSnippet2.default.browser.msie) {
              range.setEnd(selectionEnd, 1);
            } else {
              range.setEnd(selectionEnd, 0);
              range.collapse(false);
            }
            _this.wwe.getEditor().setSelection(range);
          }
          if (_this.onDragEnd) {
            _this.onDragEnd();
          }
        }

        finishSelection();
      };

      var onMousedown = function onMousedown(ev) {
        var MOUSE_RIGHT_BUTTON = 2;
        selectionStart = (0, _jquery2.default)(ev.data.target).closest('[contenteditable=true] td,th').get(0);
        var isSelectedCell = (0, _jquery2.default)(selectionStart).hasClass(TABLE_CELL_SELECTED_CLASS_NAME);
        selectionEnd = null;

        if (!isSelectedCell || isSelectedCell && ev.data.button !== MOUSE_RIGHT_BUTTON) {
          _this.removeClassAttrbuteFromAllCellsIfNeed();
          _this.setTableSelectionTimerIfNeed(selectionStart);
          _this.eventManager.listen('mouseover.tableSelection', onMouseover);
          _this.eventManager.listen('mouseup.tableSelection', onMouseup);
          if (_this.onDragStart && selectionStart) {
            _this.onDragStart(selectionStart);
          }
        } else if (ev.data.button === MOUSE_RIGHT_BUTTON) {
          finishSelection();
        }
      };

      this.eventManager.listen('mousedown.tableSelection', onMousedown);
      this.eventManager.listen('copyBefore.tableSelection', finishSelection);
      this.eventManager.listen('pasteBefore.tableSelection', finishSelection);
    }

    /**
       * Return whether single cell text selection or not
       * @param {Range} range Range object
       * @param {boolean} isSameCell Boolean value for same cell selection
       * @returns {boolean}
       * @private
       */

  }, {
    key: '_isTextSelect',
    value: function _isTextSelect(range, isSameCell) {
      return (/TD|TH|TEXT/i.test(range.commonAncestorContainer.nodeName) && isSameCell
      );
    }

    /**
       * Set setTimeout and setInterval timer execution if table selecting situation
       * @param {HTMLElement} selectionStart Start element
       */

  }, {
    key: 'setTableSelectionTimerIfNeed',
    value: function setTableSelectionTimerIfNeed(selectionStart) {
      var isTableSelecting = (0, _jquery2.default)(selectionStart).parents('[contenteditable=true] table').length;

      if (isTableSelecting) {
        this._isSelectionStarted = true;
      }
    }

    /**
       * Clear setTimeout and setInterval timer execution
       * @private
       */

  }, {
    key: '_clearTableSelectionTimerIfNeed',
    value: function _clearTableSelectionTimerIfNeed() {
      clearTimeout(this._tableSelectionTimer);
      // For disable firefox's native table selection
      if (_tuiCodeSnippet2.default.browser.firefox && this._removeSelectionTimer) {
        clearTimeout(this._removeSelectionTimer);
        this._removeSelectionTimer = null;
      }
    }

    /**
       * Re arrange selection when table does not include both start and end selection element
       * @param {HTMLElement} selectionStart Start element of selection
       * @param {HTMLElement} selectionEnd End element of selection
       * @returns {{startContainer: HTMLElement, endContainer: HTMLElement}}
       * @private
       */

  }, {
    key: '_reArrangeSelectionIfneed',
    value: function _reArrangeSelectionIfneed(selectionStart, selectionEnd) {
      var isRangeStartInTable = (0, _jquery2.default)(selectionStart).parents('[contenteditable=true] table').length;
      var isRangeEndInTable = (0, _jquery2.default)(selectionEnd).parents('[contenteditable=true] table').length;
      var isStartRangeOut = isRangeEndInTable && !isRangeStartInTable;
      var isEndRangeOut = !isRangeEndInTable && isRangeStartInTable;

      if (isStartRangeOut) {
        selectionStart = (0, _jquery2.default)(selectionEnd).parents('[contenteditable=true] table').find('th').first().get(0);
      } else if (isEndRangeOut) {
        selectionEnd = (0, _jquery2.default)(selectionStart).parents('[contenteditable=true] table').find('td').last().get(0);
      }

      return {
        startContainer: selectionStart,
        endContainer: selectionEnd
      };
    }

    /**
       * Apply select direction to editor
       * @param {{startContainer: HTMLElement, endContainer: HTMLElement}} selectionInformation
       *     Selection start and end element
       * @param {Range} range Range object
       * @returns {Range}
       * @private
       */

  }, {
    key: '_applySelectionDirection',
    value: function _applySelectionDirection(selectionInformation, range) {
      var nodeOffsetOfParent = _domUtils2.default.getNodeOffsetOfParent;
      var selectionStart = selectionInformation.startContainer;
      var selectionEnd = selectionInformation.endContainer;
      var rowDirection = nodeOffsetOfParent((0, _jquery2.default)(selectionStart).closest('[contenteditable=true] tr')[0]) - nodeOffsetOfParent((0, _jquery2.default)(selectionEnd).closest('[contenteditable=true] tr')[0]);
      var cellDirection = nodeOffsetOfParent(selectionStart) - nodeOffsetOfParent(selectionEnd);
      var isSameRow = rowDirection === 0;
      var isRowIncreases = rowDirection < 0;
      var isColumnIncreases = cellDirection > 0;

      if (isSameRow) {
        if (isColumnIncreases) {
          range.setStart(selectionEnd, 0);
          range.setEnd(selectionStart, 1);
        } else {
          range.setStart(selectionStart, 0);
          range.setEnd(selectionEnd, 1);
        }
      } else if (isRowIncreases) {
        range.setStart(selectionStart, 0);
        range.setEnd(selectionEnd, 1);
      } else {
        range.setStart(selectionEnd, 0);
        range.setEnd(selectionStart, 1);
      }

      return range;
    }

    /**
       * Get selection coordinate by current selection
       * @param {HTMLElement} selectionStart start element
       * @param {HTMLElement} selectionEnd end element
       * @returns {{from: {row: number, cell: number}, to: {row: number, cell: number}}}
       * @memberof WwTableSelectionManager
       */

  }, {
    key: 'getSelectionRangeFromTable',
    value: function getSelectionRangeFromTable(selectionStart, selectionEnd) {
      var nodeOffsetOfParent = _domUtils2.default.getNodeOffsetOfParent;
      var startRowOffset = nodeOffsetOfParent(selectionStart.parentNode);
      var endRowOffset = nodeOffsetOfParent(selectionEnd.parentNode);
      var startCellOffset = nodeOffsetOfParent(selectionStart);
      var endCellOffset = nodeOffsetOfParent(selectionEnd);
      var startCellContainer = _domUtils2.default.getParentUntil(selectionStart, 'TABLE');
      var endCellContainer = _domUtils2.default.getParentUntil(selectionEnd, 'TABLE');
      var isReversedTheadAndTbodySelect = _domUtils2.default.getNodeName(startCellContainer) === 'TBODY' && _domUtils2.default.getNodeName(endCellContainer) === 'THEAD';
      var isTheadAndTbodySelect = startCellContainer !== endCellContainer;
      var isBothInTbody = !!(0, _jquery2.default)(selectionStart).parents('tbody').length && !!(0, _jquery2.default)(selectionEnd).parents('tbody').length;
      var start = {
        row: startRowOffset,
        cell: startCellOffset
      };
      var end = {
        row: endRowOffset,
        cell: endCellOffset
      };
      var from = void 0,
          to = void 0;

      if (isReversedTheadAndTbodySelect) {
        start.row += 1;
      } else if (isTheadAndTbodySelect) {
        end.row += 1;
      } else if (isBothInTbody) {
        start.row += 1;
        end.row += 1;
      }

      if (startRowOffset > endRowOffset || startRowOffset === endRowOffset && startCellOffset > endCellOffset) {
        from = end;
        to = start;
      } else {
        from = start;
        to = end;
      }

      return {
        from: from,
        to: to
      };
    }

    /**
       * Highlight selected table cells
       * @param {HTMLElement} selectionStart start element
       * @param {HTMLElement} selectionEnd end element
       */

  }, {
    key: 'highlightTableCellsBy',
    value: function highlightTableCellsBy(selectionStart, selectionEnd) {
      var trs = (0, _jquery2.default)(selectionStart).parents('[contenteditable=true] table').find('tr');
      var selection = this.getSelectionRangeFromTable(selectionStart, selectionEnd);
      var rowFrom = selection.from.row;
      var cellFrom = selection.from.cell;
      var rowTo = selection.to.row;
      var cellTo = selection.to.cell;

      trs.each(function (rowIndex, row) {
        (0, _jquery2.default)(row).find('td,th').each(function (cellIndex, cell) {
          var $cell = (0, _jquery2.default)(cell);
          var isFromRow = rowIndex === rowFrom;
          var isToRow = rowIndex === rowTo;

          if (isFromRow && cellIndex < cellFrom || isToRow && cellIndex > cellTo || rowIndex < rowFrom || rowIndex > rowTo) {
            $cell.removeClass(TABLE_CELL_SELECTED_CLASS_NAME);
          } else {
            $cell.addClass(TABLE_CELL_SELECTED_CLASS_NAME);
          }
        });
      });
    }

    /**
       * Remove '.te-cell-selected' class from all of table Cell
       * @memberof WwTableSelectionManager
       */

  }, {
    key: 'removeClassAttrbuteFromAllCellsIfNeed',
    value: function removeClassAttrbuteFromAllCellsIfNeed() {
      this.wwe.get$Body().find('td.' + TABLE_CELL_SELECTED_CLASS_NAME + ',th.' + TABLE_CELL_SELECTED_CLASS_NAME).each(function (i, node) {
        var $node = (0, _jquery2.default)(node);

        $node.removeClass(TABLE_CELL_SELECTED_CLASS_NAME);

        if (!$node.attr('class').length) {
          $node.removeAttr('class');
        }
      });
    }

    /**
       * gets selected cells
       * @returns {jQuery} selected cells
       * @memberof WwTableSelectionManager
       */

  }, {
    key: 'getSelectedCells',
    value: function getSelectedCells() {
      return this.wwe.get$Body().find('.' + TABLE_CELL_SELECTED_CLASS_NAME);
    }

    /**
       * Create selection by selected cells and collapse that selection to end
       */

  }, {
    key: 'createRangeBySelectedCells',
    value: function createRangeBySelectedCells() {
      var sq = this.wwe.getEditor();
      var range = sq.getSelection().cloneRange();
      var $selectedCells = this.getSelectedCells();
      var tableManager = this.wwe.componentManager.getManager('table');
      var firstSelectedCell = $selectedCells.first().get(0);
      var lastSelectedCell = $selectedCells.last().get(0);

      if ($selectedCells.length && tableManager.isInTable(range)) {
        range.setStart(firstSelectedCell, 0);
        range.setEnd(lastSelectedCell, lastSelectedCell.childNodes.length);
        sq.setSelection(range);
      }
    }

    /**
       * Style to selected cells.
       * @param {function} onStyle - function for styling
       */

  }, {
    key: 'styleToSelectedCells',
    value: function styleToSelectedCells(onStyle) {
      this.createRangeBySelectedCells();
      onStyle(this.wwe.getEditor());
    }

    /**
       * Destroy.
       */

  }, {
    key: 'destroy',
    value: function destroy() {
      this.eventManager.removeEventHandler('mousedown.tableSelection');
      this.eventManager.removeEventHandler('mouseover.tableSelection');
      this.eventManager.removeEventHandler('mouseup.tableSelection');
      this.eventManager.removeEventHandler('copyBefore.tableSelection');
      this.eventManager.removeEventHandler('pasteBefore.tableSelection');
    }
  }]);

  return WwTableSelectionManager;
}();

exports.default = WwTableSelectionManager;

/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements wysiwyg code block manager
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _domUtils = __webpack_require__(4);

var _domUtils2 = _interopRequireDefault(_domUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var tagEntities = {
  '&': '&amp;',
  '<': '&lt;',
  '>': '&gt;'
};

var FIND_ZWS_RX = /\u200B/g;
var CODEBLOCK_ATTR_NAME = 'data-te-codeblock';

/**
 * Class WwCodeBlockManager
 */

var WwCodeBlockManager = function () {
  /**
   * Creates an instance of WwCodeBlockManager.
   * @param {WysiwygEditor} wwe - wysiwygEditor instance
   * @memberof WwCodeBlockManager
   */
  function WwCodeBlockManager(wwe) {
    _classCallCheck(this, WwCodeBlockManager);

    this.wwe = wwe;
    this.eventManager = wwe.eventManager;

    /**
     * Name property
     * @memberof WwCodeBlockManager#
     * @type {string}
     */
    this.name = 'codeblock';

    this._init();
  }
  /**
   * _init
   * Initialize
   * @memberof WwCodeBlockManager
   * @private
   */


  _createClass(WwCodeBlockManager, [{
    key: '_init',
    value: function _init() {
      this._initKeyHandler();
      this._initEvent();
    }

    /**
     * _initKeyHandler
     * Initialize key event handler
     * @memberof WwCodeBlockManager
     * @private
     */

  }, {
    key: '_initKeyHandler',
    value: function _initKeyHandler() {
      this._onKeyEventHandler = this._removeCodeblockIfNeed.bind(this);
      this.wwe.addKeyEventHandler('BACK_SPACE', this._onKeyEventHandler);
    }

    /**
     * _initEvent
     * Initialize eventmanager event
     * @memberof WwCodeBlockManager
     * @private
     */

  }, {
    key: '_initEvent',
    value: function _initEvent() {
      var self = this;

      this.eventManager.listen('wysiwygSetValueAfter.codeblock', function () {
        self.splitCodeblockToEachLine();
      });

      this.eventManager.listen('wysiwygProcessHTMLText.codeblock', function (html) {
        return self._mergeCodeblockEachlinesFromHTMLText(html);
      });
    }

    /**
     * Convert copied nodes to code block if need
     * @memberof WwCodeBlockManager
     * @param {Array.<Node>} nodes Node array
     * @returns {DocumentFragment}
     */

  }, {
    key: 'prepareToPasteOnCodeblock',
    value: function prepareToPasteOnCodeblock(nodes) {
      var range = this.wwe.getEditor().getSelection().cloneRange();
      var frag = this.wwe.getEditor().getDocument().createDocumentFragment();

      if (nodes.length === 1 && this._isCodeBlock(nodes[0])) {
        frag.appendChild(this._copyCodeblockTypeFromRangeCodeblock(nodes.shift(), range));
      } else {
        frag.appendChild(this._copyCodeblockTypeFromRangeCodeblock(this.convertToCodeblock(nodes), range));
      }

      return frag;
    }

    /**
     * Wrap nodes into code block
     * @memberof WwCodeBlockManager
     * @param {Array.<Node>} nodes Node array
     * @returns {HTMLElement} Code block element
     */

  }, {
    key: 'convertToCodeblock',
    value: function convertToCodeblock(nodes) {
      var $codeblock = (0, _jquery2.default)('<pre />');
      var self = this;
      var node = nodes.shift();

      while (_tuiCodeSnippet2.default.isTruthy(node)) {
        $codeblock.append(self._makeCodeBlockLineHtml(_tuiCodeSnippet2.default.isString(node) ? node : node.textContent));
        node = nodes.shift();
      }

      $codeblock.attr(CODEBLOCK_ATTR_NAME, '');

      return $codeblock[0];
    }

    /**
     * Copy content with code block style from code block selection
     * @memberof WwCodeBlockManager
     * @param {HTMLElement} element Copied element
     * @param {Range} range Range object
     * @returns {HTMLElement}
     * @private
     */

  }, {
    key: '_copyCodeblockTypeFromRangeCodeblock',
    value: function _copyCodeblockTypeFromRangeCodeblock(element, range) {
      var blockNode = _domUtils2.default.getParentUntil(range.commonAncestorContainer, this.wwe.get$Body()[0]);

      if (_domUtils2.default.getNodeName(blockNode) === 'PRE') {
        var attrs = (0, _jquery2.default)(blockNode).prop('attributes');

        _tuiCodeSnippet2.default.forEach(attrs, function (attr) {
          (0, _jquery2.default)(element).attr(attr.name, attr.value);
        });
      }

      return element;
    }

    /**
     * Merge code block lines
     * @memberof WwCodeBlockManager
     * @param {string} html HTML string
     * @returns {string}
     * @private
     */

  }, {
    key: '_mergeCodeblockEachlinesFromHTMLText',
    value: function _mergeCodeblockEachlinesFromHTMLText(html) {
      html = html.replace(/<pre( .*?)?>(.*?)<\/pre>/g, function (match, codeAttr, code) {
        code = code.replace(/<br \/>/g, '\n');
        code = code.replace(/<div ?(.*?)>/g, '');
        code = code.replace(/\n$/, '');

        return '<pre><code' + (codeAttr || '') + '>' + code + '</code></pre>';
      });

      return html;
    }

    /**
     * Split code block to lines
     * @memberof WwCodeBlockManager
     * @param {HTMLElement} node root node to find pre
     * @private
     */

  }, {
    key: 'splitCodeblockToEachLine',
    value: function splitCodeblockToEachLine(node) {
      var self = this;

      if (!node) {
        node = this.wwe.get$Body();
      }

      (0, _jquery2.default)(node).find('pre').each(function (index, pre) {
        var $pre = (0, _jquery2.default)(pre);
        var lang = $pre.find('code').attr('data-language');
        var numberOfBackticks = $pre.find('code').attr('data-backticks');
        var textLines = void 0;

        // if this pre can have lines
        if ($pre.children().length > 1) {
          textLines = [];

          $pre.children().each(function (idx, childNode) {
            if ((childNode.nodeName === 'DIV' || childNode.nodeName === 'P') && !(0, _jquery2.default)(childNode).find('br').length) {
              (0, _jquery2.default)(childNode).append('<br>');
            }
          });
        }

        $pre.find('br').replaceWith('\n');
        textLines = $pre.text().replace(/\s+$/, '').split(/\n/g);

        if (lang) {
          $pre.attr('data-language', lang);
          $pre.addClass('lang-' + lang);
        }
        if (numberOfBackticks) {
          $pre.attr('data-backticks', numberOfBackticks);
        }

        $pre.empty();

        _tuiCodeSnippet2.default.forEach(textLines, function (line) {
          $pre.append(self._makeCodeBlockLineHtml(line));
        });

        $pre.attr(CODEBLOCK_ATTR_NAME, '');
      });
    }

    /**
     * Make code HTML text
     * @memberof WwCodeBlockManager
     * @param {string} lineContent Content text
     * @returns {string}
     * @private
     */

  }, {
    key: '_makeCodeBlockLineHtml',
    value: function _makeCodeBlockLineHtml(lineContent) {
      if (!lineContent) {
        lineContent = '<br>';
      } else {
        lineContent = sanitizeHtmlCode(lineContent);
      }

      return '<div>' + lineContent + '</div>';
    }

    /**
     * Remove codeblock if need
     * @memberof WwCodeBlockManager
     * @param {Event} ev Event object
     * @param {Range} range Range object
     * @returns {boolean}
     * @private
     */

  }, {
    key: '_removeCodeblockIfNeed',
    value: function _removeCodeblockIfNeed(ev, range) {
      var self = this;

      if (!this.isInCodeBlock(range)) {
        return true;
      }

      var pre = (0, _jquery2.default)(range.startContainer).closest('pre');
      var $div = (0, _jquery2.default)(pre).find('div').eq(0);
      var codeContent = $div.text().replace(FIND_ZWS_RX, '');

      // only one code
      if ((range.startOffset === 0 || codeContent.length === 0) && (0, _jquery2.default)(pre).find('div').length <= 1) {
        this.wwe.getEditor().modifyBlocks(function () {
          var newFrag = self.wwe.getEditor().getDocument().createDocumentFragment();
          var content = void 0;

          if (codeContent.length === 0) {
            content = '<br>';
          } else {
            content = $div.html().replace(FIND_ZWS_RX, '');
          }

          (0, _jquery2.default)(newFrag).append((0, _jquery2.default)('<div>' + content + '</div>'));

          return newFrag;
        });

        return false;
      }

      return true;
    }

    /**
     * Return boolean value of whether current range is in the code block
     * @memberof WwCodeBlockManager
     * @param {Range} range Range object
     * @returns {boolean}
     */

  }, {
    key: 'isInCodeBlock',
    value: function isInCodeBlock(range) {
      var target = void 0;

      if (range.collapsed) {
        target = range.startContainer;
      } else {
        target = range.commonAncestorContainer;
      }

      return this._isCodeBlock(target);
    }

    /**
     * Verify given element is code block
     * @memberof WwCodeBlockManager
     * @param {HTMLElement} element Element
     * @returns {boolean}
     * @private
     */

  }, {
    key: '_isCodeBlock',
    value: function _isCodeBlock(element) {
      return !!(0, _jquery2.default)(element).closest('pre').length;
    }

    /**
     * Destroy.
     */

  }, {
    key: 'destroy',
    value: function destroy() {
      this.eventManager.removeEventHandler('wysiwygSetValueAfter.codeblock');
      this.eventManager.removeEventHandler('wysiwygProcessHTMLText.codeblock');
      this.wwe.removeKeyEventHandler('BACK_SPACE', this._onKeyEventHandler);
    }
  }]);

  return WwCodeBlockManager;
}();

/**
 * Sanitize HTML code
 * @param {string} code code string
 * @returns {string}
 * @ignore
 */


function sanitizeHtmlCode(code) {
  return code.replace(/[<>&]/g, function (tag) {
    return tagEntities[tag] || tag;
  });
}

exports.default = WwCodeBlockManager;

/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements EventManager
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var eventList = ['previewBeforeHook', 'previewRenderAfter', 'previewNeedsRefresh', 'addImageBlobHook', 'setMarkdownAfter', 'contentChangedFromWysiwyg', 'changeFromWysiwyg', 'contentChangedFromMarkdown', 'changeFromMarkdown', 'change', 'changeModeToWysiwyg', 'changeModeToMarkdown', 'changeModeBefore', 'changeMode', 'changePreviewStyle', 'openPopupAddLink', 'openPopupAddImage', 'openPopupAddTable', 'openPopupTableUtils', 'openHeadingSelect', 'openPopupCodeBlockLanguages', 'openPopupCodeBlockEditor', 'openDropdownToolbar', 'closePopupCodeBlockLanguages', 'closePopupCodeBlockEditor', 'closeAllPopup', 'command', 'addCommandBefore', 'htmlUpdate', 'markdownUpdate', 'renderedHtmlUpdated', 'removeEditor', 'convertorAfterMarkdownToHtmlConverted', 'convertorBeforeHtmlToMarkdownConverted', 'convertorAfterHtmlToMarkdownConverted', 'stateChange', 'wysiwygSetValueAfter', 'wysiwygSetValueBefore', 'wysiwygGetValueBefore', 'wysiwygProcessHTMLText', 'wysiwygRangeChangeAfter', 'wysiwygKeyEvent', 'scroll', 'click', 'mousedown', 'mouseover', 'mouseout', 'mouseup', 'contextmenu', 'keydown', 'keyup', 'keyMap', 'load', 'focus', 'blur', 'paste', 'pasteBefore', 'willPaste', 'copy', 'copyBefore', 'copyAfter', 'cut', 'cutAfter', 'drop', 'show', 'hide'];

/**
 * Class EventManager
 */

var EventManager = function () {
  /**
   * Creates an instance of EventManager.
   * @memberof EventManager
   */
  function EventManager() {
    _classCallCheck(this, EventManager);

    this.events = new _tuiCodeSnippet2.default.Map();
    this.TYPE = new _tuiCodeSnippet2.default.Enum(eventList);
  }

  /**
   * Listen event and bind event handler
   * @memberof EventManager
   * @param {string} typeStr Event type string
   * @param {function} handler Event handler
   */


  _createClass(EventManager, [{
    key: 'listen',
    value: function listen(typeStr, handler) {
      var typeInfo = this._getTypeInfo(typeStr);
      var eventHandlers = this.events.get(typeInfo.type) || [];

      if (!this._hasEventType(typeInfo.type)) {
        throw new Error('There is no event type ' + typeInfo.type);
      }

      if (typeInfo.namespace) {
        handler.namespace = typeInfo.namespace;
      }

      eventHandlers.push(handler);

      this.events.set(typeInfo.type, eventHandlers);
    }

    /**
     * Emit event
     * @memberof EventManager
     * @param {string} eventName Event name to emit
     * @returns {Array}
     */

  }, {
    key: 'emit',
    value: function emit() {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      var typeStr = args.shift();
      var typeInfo = this._getTypeInfo(typeStr);
      var eventHandlers = this.events.get(typeInfo.type);
      var results = void 0;

      if (eventHandlers) {
        _tuiCodeSnippet2.default.forEach(eventHandlers, function (handler) {
          var result = handler.apply(undefined, args);

          if (!_tuiCodeSnippet2.default.isUndefined(result)) {
            results = results || [];
            results.push(result);
          }
        });
      }

      return results;
    }

    /**
     * Emit given event and return result
     * @memberof EventManager
     * @param {string} eventName Event name to emit
     * @param {string} sourceText Source text to change
     * @returns {string}
     */

  }, {
    key: 'emitReduce',
    value: function emitReduce() {
      for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      var type = args.shift();
      var eventHandlers = this.events.get(type);

      if (eventHandlers) {
        _tuiCodeSnippet2.default.forEach(eventHandlers, function (handler) {
          var result = handler.apply(undefined, args);

          if (!_tuiCodeSnippet2.default.isFalsy(result)) {
            args[0] = result;
          }
        });
      }

      return args[0];
    }

    /**
     * Get event type and namespace
     * @memberof EventManager
     * @param {string} typeStr Event type name
     * @returns {{type: string, namespace: string}}
     * @private
     */

  }, {
    key: '_getTypeInfo',
    value: function _getTypeInfo(typeStr) {
      var splited = typeStr.split('.');

      return {
        type: splited[0],
        namespace: splited[1]
      };
    }

    /**
     * Check whether event type exists or not
     * @param {string} type Event type name
     * @returns {boolean}
     * @private
     */

  }, {
    key: '_hasEventType',
    value: function _hasEventType(type) {
      return !_tuiCodeSnippet2.default.isUndefined(this.TYPE[this._getTypeInfo(type).type]);
    }

    /**
     * Add event type when given event not exists
     * @memberof EventManager
     * @param {string} type Event type name
     */

  }, {
    key: 'addEventType',
    value: function addEventType(type) {
      if (this._hasEventType(type)) {
        throw new Error('There is already have event type ' + type);
      }

      this.TYPE.set(type);
    }

    /**
     * Remove event handler from given event type
     * @memberof EventManager
     * @param {string} typeStr Event type name
     * @param {function} [handler] - registered event handler
     */

  }, {
    key: 'removeEventHandler',
    value: function removeEventHandler(typeStr, handler) {
      var _this = this;

      var _getTypeInfo2 = this._getTypeInfo(typeStr),
          type = _getTypeInfo2.type,
          namespace = _getTypeInfo2.namespace;

      if (type && handler) {
        this._removeEventHandlerWithHandler(type, handler);
      } else if (type && !namespace) {
        // dont use dot notation cuz eslint
        this.events['delete'](type);
      } else if (!type && namespace) {
        this.events.forEach(function (eventHandlers, eventType) {
          _this._removeEventHandlerWithTypeInfo(eventType, namespace);
        });
      } else if (type && namespace) {
        this._removeEventHandlerWithTypeInfo(type, namespace);
      }
    }

    /**
     * Remove event handler with event handler
     * @param {string} type - event type name
     * @param {function} handler - event handler
     * @memberof EventManager
     * @private
     */

  }, {
    key: '_removeEventHandlerWithHandler',
    value: function _removeEventHandlerWithHandler(type, handler) {
      var eventHandlers = this.events.get(type) || [];
      var handlerIndex = eventHandlers.indexOf(handler);
      if (handlerIndex >= 0) {
        eventHandlers.splice(handlerIndex, 1);
      }
    }

    /**
     * Remove event handler with event type information
     * @memberof EventManager
     * @param {string} type Event type name
     * @param {string} namespace Event namespace
     * @private
     */

  }, {
    key: '_removeEventHandlerWithTypeInfo',
    value: function _removeEventHandlerWithTypeInfo(type, namespace) {
      var handlersToSurvive = [];
      var eventHandlers = this.events.get(type);

      if (!eventHandlers) {
        return;
      }

      eventHandlers.map(function (handler) {
        if (handler.namespace !== namespace) {
          handlersToSurvive.push(handler);
        }
      });

      this.events.set(type, handlersToSurvive);
    }
  }]);

  return EventManager;
}();

exports.default = EventManager;

/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview extension manager
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Class ExtManager
 */
var ExtManager = function () {
  /**
   * Creates an instance of ExtManager.
   * @memberof ExtManager
   */
  function ExtManager() {
    _classCallCheck(this, ExtManager);

    this.exts = new _tuiCodeSnippet2.default.Map();
  }

  /**
   * defineExtension
   * Defined Extension
   * @memberof ExtManager
   * @param {string} name extension name
   * @param {ExtManager~extension} ext extension
   */


  _createClass(ExtManager, [{
    key: 'defineExtension',
    value: function defineExtension(name, ext) {
      this.exts.set(name, ext);
    }

    /**
     * Apply extensions
     * @memberof ExtManager
     * @param {object} context Context
     * @param {Array.<string|object>} options - options or names array
     */

  }, {
    key: 'applyExtension',
    value: function applyExtension(context, options) {
      var _this = this;

      if (options) {
        options.forEach(function (option) {
          var hasOption = _tuiCodeSnippet2.default.isObject(option);
          var name = hasOption ? option.name : option;

          if (_this.exts.has(name)) {
            var ext = _this.exts.get(name);
            if (hasOption) {
              ext(context, option);
            } else {
              ext(context);
            }
          }
        });
      }
    }
  }]);

  return ExtManager;
}();

exports.default = new ExtManager();

/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Convertor have responsible to convert markdown and html
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _markdownIt = __webpack_require__(81);

var _markdownIt2 = _interopRequireDefault(_markdownIt);

var _toMark = __webpack_require__(40);

var _toMark2 = _interopRequireDefault(_toMark);

var _htmlSanitizer = __webpack_require__(33);

var _htmlSanitizer2 = _interopRequireDefault(_htmlSanitizer);

var _markdownitTaskPlugin = __webpack_require__(82);

var _markdownitTaskPlugin2 = _interopRequireDefault(_markdownitTaskPlugin);

var _markdownitCodeBlockPlugin = __webpack_require__(83);

var _markdownitCodeBlockPlugin2 = _interopRequireDefault(_markdownitCodeBlockPlugin);

var _markdownitCodeRenderer = __webpack_require__(84);

var _markdownitCodeRenderer2 = _interopRequireDefault(_markdownitCodeRenderer);

var _markdownitBlockQuoteRenderer = __webpack_require__(85);

var _markdownitBlockQuoteRenderer2 = _interopRequireDefault(_markdownitBlockQuoteRenderer);

var _markdownitTableRenderer = __webpack_require__(86);

var _markdownitTableRenderer2 = _interopRequireDefault(_markdownitTableRenderer);

var _markdownitHtmlBlockRenderer = __webpack_require__(87);

var _markdownitHtmlBlockRenderer2 = _interopRequireDefault(_markdownitHtmlBlockRenderer);

var _markdownitBackticksRenderer = __webpack_require__(88);

var _markdownitBackticksRenderer2 = _interopRequireDefault(_markdownitBackticksRenderer);

var _codeBlockManager = __webpack_require__(23);

var _codeBlockManager2 = _interopRequireDefault(_codeBlockManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var markdownitHighlight = new _markdownIt2.default({
  html: true,
  breaks: true,
  quotes: '“”‘’',
  langPrefix: 'lang-',
  highlight: function highlight(codeText, type) {
    return _codeBlockManager2.default.createCodeBlockHtml(type, codeText);
  }
});
var markdownit = new _markdownIt2.default({
  html: true,
  breaks: true,
  quotes: '“”‘’',
  langPrefix: 'lang-'
});

// markdownitHighlight
markdownitHighlight.block.ruler.at('code', _markdownitCodeRenderer2.default);
markdownitHighlight.block.ruler.at('table', _markdownitTableRenderer2.default, {
  alt: ['paragraph', 'reference']
});
markdownitHighlight.block.ruler.at('blockquote', _markdownitBlockQuoteRenderer2.default, {
  alt: ['paragraph', 'reference', 'blockquote', 'list']
});
markdownitHighlight.block.ruler.at('html_block', _markdownitHtmlBlockRenderer2.default, {
  alt: ['paragraph', 'reference', 'blockquote']
});
markdownitHighlight.inline.ruler.at('backticks', _markdownitBackticksRenderer2.default);
markdownitHighlight.use(_markdownitTaskPlugin2.default);
markdownitHighlight.use(_markdownitCodeBlockPlugin2.default);

// markdownit
markdownit.block.ruler.at('code', _markdownitCodeRenderer2.default);
markdownit.block.ruler.at('table', _markdownitTableRenderer2.default, {
  alt: ['paragraph', 'reference']
});
markdownit.block.ruler.at('blockquote', _markdownitBlockQuoteRenderer2.default, {
  alt: ['paragraph', 'reference', 'blockquote', 'list']
});
markdownit.block.ruler.at('html_block', _markdownitHtmlBlockRenderer2.default, {
  alt: ['paragraph', 'reference', 'blockquote']
});
markdownit.inline.ruler.at('backticks', _markdownitBackticksRenderer2.default);
markdownit.use(_markdownitTaskPlugin2.default);
markdownit.use(_markdownitCodeBlockPlugin2.default);

/**
 * Class Convertor
 */

var Convertor = function () {
  /**
   * Convertor constructor
   * @param {EventManager} em - EventManager instance
   */
  function Convertor(em) {
    _classCallCheck(this, Convertor);

    this.eventManager = em;
  }

  /**
   * _markdownToHtmlWithCodeHighlight
   * Convert markdown to html with Codehighlight
   * @private
   * @memberof Convertor
   * @param {string} markdown markdown text
   * @returns {string} html text
   */


  _createClass(Convertor, [{
    key: '_markdownToHtmlWithCodeHighlight',
    value: function _markdownToHtmlWithCodeHighlight(markdown) {
      markdown = markdown.replace(/<br>/ig, '<br data-tomark-pass>');
      // eslint-disable-next-line
      var onerrorStripeRegex = /(<img[^>]*)(onerror\s*=\s*[\"']?[^\"']*[\"']?)(.*)/i;
      while (onerrorStripeRegex.exec(markdown)) {
        markdown = markdown.replace(onerrorStripeRegex, '$1$3');
      }

      var renderedHTML = markdownitHighlight.render(markdown);
      renderedHTML = this._removeBrToMarkPassAttributeInCode(renderedHTML);

      return renderedHTML;
    }

    /**
     * _markdownToHtml
     * Convert markdown to html
     * @private
     * @memberof Convertor
     * @param {string} markdown markdown text
     * @returns {string} html text
     */

  }, {
    key: '_markdownToHtml',
    value: function _markdownToHtml(markdown) {
      markdown = markdown.replace(/<br>/ig, '<br data-tomark-pass>');
      // eslint-disable-next-line
      var onerrorStripeRegex = /(<img[^>]*)(onerror\s*=\s*[\"']?[^\"']*[\"']?)(.*)/i;
      while (onerrorStripeRegex.exec(markdown)) {
        markdown = markdown.replace(onerrorStripeRegex, '$1$3');
      }

      var renderedHTML = markdownit.render(markdown);
      renderedHTML = this._removeBrToMarkPassAttributeInCode(renderedHTML);

      return renderedHTML;
    }

    /**
     * Remove BR's data-tomark-pass attribute text when br in code element
     * @param {string} renderedHTML Rendered HTML string from markdown editor
     * @returns {string}
     * @private
     */

  }, {
    key: '_removeBrToMarkPassAttributeInCode',
    value: function _removeBrToMarkPassAttributeInCode(renderedHTML) {
      var $wrapperDiv = (0, _jquery2.default)('<div />');

      $wrapperDiv.html(renderedHTML);

      $wrapperDiv.find('code, pre').each(function (i, codeOrPre) {
        var $code = (0, _jquery2.default)(codeOrPre);
        $code.html($code.html().replace(/&lt;br data-tomark-pass&gt;/, '&lt;br&gt;'));
      });

      renderedHTML = $wrapperDiv.html();

      return renderedHTML;
    }

    /**
     * toHTMLWithCodeHightlight
     * Convert markdown to html with Codehighlight
     * emit convertorAfterMarkdownToHtmlConverted
     * @memberof Convertor
     * @param {string} markdown markdown text
     * @returns {string} html text
     */

  }, {
    key: 'toHTMLWithCodeHightlight',
    value: function toHTMLWithCodeHightlight(markdown) {
      var html = this._markdownToHtmlWithCodeHighlight(markdown);
      html = this.eventManager.emitReduce('convertorAfterMarkdownToHtmlConverted', html);

      return html;
    }

    /**
     * toHTML
     * Convert markdown to html
     * emit convertorAfterMarkdownToHtmlConverted
     * @memberof Convertor
     * @param {string} markdown markdown text
     * @returns {string} html text
     */

  }, {
    key: 'toHTML',
    value: function toHTML(markdown) {
      var html = this._markdownToHtml(markdown);

      html = this.eventManager.emitReduce('convertorAfterMarkdownToHtmlConverted', html);

      return html;
    }
  }, {
    key: 'initHtmlSanitizer',
    value: function initHtmlSanitizer() {
      this.eventManager.listen('convertorAfterMarkdownToHtmlConverted', function (html) {
        return (0, _htmlSanitizer2.default)(html, true);
      });
    }

    /**
     * toMarkdown
     * Convert html to markdown
     * emit convertorAfterHtmlToMarkdownConverted
     * @memberof Convertor
     * @param {string} html html text
     * @param {object | null} toMarkOptions - toMark library options
     * @returns {string} markdown text
     */

  }, {
    key: 'toMarkdown',
    value: function toMarkdown(html, toMarkOptions) {
      var resultArray = [];

      html = this.eventManager.emitReduce('convertorBeforeHtmlToMarkdownConverted', html);

      var markdown = (0, _toMark2.default)(this._appendAttributeForBrIfNeed(html), toMarkOptions);

      markdown = this.eventManager.emitReduce('convertorAfterHtmlToMarkdownConverted', markdown);

      _tuiCodeSnippet2.default.forEach(markdown.split('\n'), function (line, index) {
        var FIND_TABLE_RX = /^\|[^|]*\|/ig;
        var FIND_CODE_RX = /`[^`]*<br>[^`]*`/ig;

        if (!FIND_CODE_RX.test(line) && !FIND_TABLE_RX.test(line)) {
          line = line.replace(/<br>/ig, '<br>\n');
        }
        resultArray[index] = line;
      });

      return resultArray.join('\n');
    }
  }, {
    key: '_appendAttributeForBrIfNeed',
    value: function _appendAttributeForBrIfNeed(html) {
      var FIND_BR_RX = /<br>/ig;
      var FIND_DOUBLE_BR_RX = /<br \/><br \/>/ig;
      var FIND_PASSING_AND_NORMAL_BR_RX = /<br data-tomark-pass \/><br \/>(.)/ig;
      var FIRST_TWO_BRS_BEFORE_RX = /([^>]|<\/b>|<\/i>|<\/s>|<img [^>]*>)/;
      var TWO_BRS_RX = /<br data-tomark-pass \/><br data-tomark-pass \/>/;
      var FIND_FIRST_TWO_BRS_RX = new RegExp(FIRST_TWO_BRS_BEFORE_RX.source + TWO_BRS_RX.source, 'g');

      html = html.replace(FIND_BR_RX, '<br />');

      html = html.replace(FIND_DOUBLE_BR_RX, '<br data-tomark-pass /><br data-tomark-pass />');

      var div = document.createElement('div');
      var $div = (0, _jquery2.default)(div);
      $div.html(html);
      $div.find('pre br,code br').each(function (index, node) {
        if (node.hasAttribute('data-tomark-pass')) {
          node.removeAttribute('data-tomark-pass');
        }
      });

      html = $div.html().replace(/<br data-tomark-pass="">/ig, '<br data-tomark-pass />');
      html = html.replace(FIND_BR_RX, '<br />');

      html = html.replace(FIND_PASSING_AND_NORMAL_BR_RX, '<br data-tomark-pass /><br data-tomark-pass />$1');
      html = html.replace(FIND_FIRST_TWO_BRS_RX, '$1<br /><br />');

      return html;
    }

    /**
     * get markdownit with code highlight
     * @returns {markdownit} - markdownit instance
     * @memberof Convertor
     * @static
     */

  }], [{
    key: 'getMarkdownitHighlightRenderer',
    value: function getMarkdownitHighlightRenderer() {
      return markdownitHighlight;
    }
  }]);

  return Convertor;
}();

exports.default = Convertor;

/***/ }),
/* 40 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_40__;

/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _uicontroller = __webpack_require__(14);

var _uicontroller2 = _interopRequireDefault(_uicontroller);

var _button = __webpack_require__(20);

var _button2 = _interopRequireDefault(_button);

var _toolbarItem = __webpack_require__(16);

var _toolbarItem2 = _interopRequireDefault(_toolbarItem);

var _toolbarDivider = __webpack_require__(42);

var _toolbarDivider2 = _interopRequireDefault(_toolbarDivider);

var _toolbarItemFactory = __webpack_require__(43);

var _toolbarItemFactory2 = _interopRequireDefault(_toolbarItemFactory);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements toolbar
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


/**
 * Class Toolbar
 * @extends {UIController}
 */
var Toolbar = function (_UIController) {
  _inherits(Toolbar, _UIController);

  /**
   * Creates an instance of Toolbar.
   * @param {EventManager} eventManager - event manager
   * @param {ToolbarItem[]} [items=[]] - toolbar items
   * @memberof Toolbar
   */

  /**
   * items
   * @memberof Toolbar
   * @private
   * @type {Array}
   */
  function Toolbar(eventManager) {
    var items = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

    _classCallCheck(this, Toolbar);

    var _this = _possibleConstructorReturn(this, (Toolbar.__proto__ || Object.getPrototypeOf(Toolbar)).call(this, {
      tagName: 'div',
      className: 'tui-editor-defaultUI-toolbar'
    }));

    Object.defineProperty(_this, '_items', {
      enumerable: true,
      writable: true,
      value: []
    });


    _this._eventManager = eventManager;

    _this.setItems(items);
    _this._initEvent(eventManager);
    return _this;
  }

  /**
   * init event
   * @param  {EventManager} eventManager - event manager
   */


  /**
   * event manager
   * @memberof Toolbar
   * @private
   * @type {EventManager}
   */


  _createClass(Toolbar, [{
    key: '_initEvent',
    value: function _initEvent(eventManager) {
      var _this2 = this;

      eventManager.listen('stateChange', function (ev) {
        _this2._items.forEach(function (item) {
          if (item._state) {
            if (ev[item._state]) {
              item.$el.addClass('active');
            } else {
              item.$el.removeClass('active');
            }
          }
        });
      });
    }

    /**
     * get toolbar items
     * @returns {ToolbarItem[]} - toolbar items
     * @memberof Toolbar
     */

  }, {
    key: 'getItems',
    value: function getItems() {
      return this._items.slice(0);
    }

    /**
     * get toolbar item at given index
     * @param  {number} index - item index
     * @returns {ToolbarItem} - toolbar item at the index
     */

  }, {
    key: 'getItem',
    value: function getItem(index) {
      return this._items[index];
    }

    /**
     * set toolbar items
     * @param {ToolbarItem[]} items - toolbar items
     * @memberof Toolbar
     */

  }, {
    key: 'setItems',
    value: function setItems(items) {
      this.removeAllItems();
      items.forEach(this.addItem.bind(this));
    }

    /**
     * add toolbar item
     * @param {ToolbarItem|string|object} item - toolbar item
     * @memberof Toolbar
     */

  }, {
    key: 'addItem',
    value: function addItem(item) {
      this.insertItem(this._items.length, item);
    }

    /**
     * insert toolbar item
     * @param  {number} index - index at given item inserted
     * @param  {ToolbarItem|string|object} item - toolbar item
     * @memberof Toolbar
     */

  }, {
    key: 'insertItem',
    value: function insertItem(index, item) {
      var _this3 = this;

      if (_tuiCodeSnippet2.default.isString(item)) {
        item = _toolbarItemFactory2.default.create(item);
      } else if (_tuiCodeSnippet2.default.isString(item.type)) {
        item = _toolbarItemFactory2.default.create(item.type, item.options);
      }

      var children = this.$el.children();
      if (index >= 0 && index < children.length) {
        item.$el.insertBefore(children.eq(index));
        this._items.splice(index, 0, item);
      } else {
        item.$el.appendTo(this.$el);
        this._items.push(item);
      }

      item.onCommandHandler = function (e, commandName) {
        return _this3._eventManager.emit('command', commandName);
      };
      item.onEventHandler = function (e, eventName) {
        return _this3._eventManager.emit(eventName);
      };
      item.on('command', item.onCommandHandler);
      item.on('event', item.onEventHandler);
    }

    /**
     * get index of given item
     * @param  {ToolbarItem} item - toolbar item
     * @returns {number} - index of given toolbar item
     * @memberof Toolbar
     */

  }, {
    key: 'indexOfItem',
    value: function indexOfItem(item) {
      var index = void 0;
      if (item instanceof _toolbarItem2.default) {
        index = this._items.indexOf(item);
      } else if (_tuiCodeSnippet2.default.isString(item)) {
        var itemName = item;
        index = this._items.map(function (itemToTest) {
          return itemToTest.getName();
        }).indexOf(itemName);
      }

      return index;
    }

    /**
     * remove an item
     * @param  {ToolbarItem|number} item - an toolbar item or index of the item to remove
     * @param  {boolean} destroy - destroy item or not
     * @returns {ToolbarItem|undefined} - removed item
     * @memberof Toolbar
     */

  }, {
    key: 'removeItem',
    value: function removeItem(item) {
      var destroy = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      var index = void 0;
      var removedItem = void 0;

      if (item instanceof _toolbarItem2.default) {
        index = this.indexOfItem(item);
      } else {
        index = item;
      }

      if (index >= 0) {
        removedItem = this._items.splice(index, 1)[0];
      }
      if (removedItem) {
        if (destroy) {
          removedItem.destroy();
        } else {
          removedItem.off('command', removedItem.onCommandHandler);
          removedItem.off('event', removedItem.onEventHandler);
          removedItem.$el.detach();
        }
      }

      return removedItem;
    }

    /**
     * remove all toolbar items
     * @memberof Toolbar
     */

  }, {
    key: 'removeAllItems',
    value: function removeAllItems() {
      while (this._items && this._items.length > 0) {
        this.removeItem(0);
      }
    }

    /**
     * destroy instance
     * @memberof Toolbar
     * @override
     */

  }, {
    key: 'destroy',
    value: function destroy() {
      this.removeAllItems();
      _get(Toolbar.prototype.__proto__ || Object.getPrototypeOf(Toolbar.prototype), 'destroy', this).call(this);
    }

    /**
     * add button
     * @param {Button} button - button instance
     * @param {Number} [index] - location the button will be placed
     * @memberof Toolbar
     * @deprecated
     */

  }, {
    key: 'addButton',
    value: function addButton(button, index) {
      if (_tuiCodeSnippet2.default.isArray(button)) {
        var arrayIndex = button.length - 1;
        for (; arrayIndex >= 0; arrayIndex -= 1) {
          if (_tuiCodeSnippet2.default.isNumber(index)) {
            this._addButton(button[arrayIndex], index);
          } else {
            this._addButton(button);
          }
        }
      } else {
        this._addButton(button, index);
      }
    }

    /**
     * _addButton
     * @param {Button} button - button instance
     * @param {Number} index - location the button will be placed
     * @private
     * @deprecated
     */

  }, {
    key: '_addButton',
    value: function _addButton(button, index) {
      var $btn = this._setButton(button, index).$el;

      if (_tuiCodeSnippet2.default.isNumber(index)) {
        this.$el.find('.' + _button2.default.className).eq(index - 1).before($btn);
      } else {
        this.$el.append($btn);
      }
    }

    /**
     * add divider
     * @returns {jQuery} - created divider jquery element
     * @memberof Toolbar
     * @deprecated
     */

  }, {
    key: 'addDivider',
    value: function addDivider() {
      var $el = (0, _jquery2.default)('<div class="' + _toolbarDivider2.default.className + '"></div>');
      this.$el.append($el);

      return $el;
    }

    /**
     * _setButton
     * @param {Button} button - button instance
     * @param {Number} index - location the button will be placed
     * @returns {Button} - button instance
     * @private
     * @deprecated
     */

  }, {
    key: '_setButton',
    value: function _setButton(button, index) {
      var ev = this._eventManager;
      if (!(button instanceof _button2.default)) {
        button = new _button2.default(button);
      }

      button.on('command', function (e, commandName) {
        return ev.emit('command', commandName);
      });
      button.on('event', function (e, eventName) {
        return ev.emit(eventName);
      });
      if (_tuiCodeSnippet2.default.isNumber(index)) {
        this._items.splice(index, 0, button);
      } else {
        this._items.push(button);
      }

      return button;
    }
  }]);

  return Toolbar;
}(_uicontroller2.default);

exports.default = Toolbar;

/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _toolbarItem = __webpack_require__(16);

var _toolbarItem2 = _interopRequireDefault(_toolbarItem);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements Toolbar Divider
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var ToolbarDivider = function (_ToolbarItem) {
  _inherits(ToolbarDivider, _ToolbarItem);

  /**
   * toolbar divider constructor
   * @memberof ToolbarDivider
   */

  /**
   * item name
   * @memberof ToolbarDivider
   * @type {String}
   * @static
   */
  function ToolbarDivider() {
    _classCallCheck(this, ToolbarDivider);

    return _possibleConstructorReturn(this, (ToolbarDivider.__proto__ || Object.getPrototypeOf(ToolbarDivider)).call(this, {
      name: ToolbarDivider.name,
      tagName: 'div',
      className: ToolbarDivider.className
    }));
  }

  /**
   * item class name
   * @memberof ToolbarDivider
   * @type {String}
   * @static
   */


  return ToolbarDivider;
}(_toolbarItem2.default);

Object.defineProperty(ToolbarDivider, 'name', {
  enumerable: true,
  writable: true,
  value: 'divider'
});
Object.defineProperty(ToolbarDivider, 'className', {
  enumerable: true,
  writable: true,
  value: 'tui-toolbar-divider'
});
exports.default = ToolbarDivider;

/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements Toolbar Item Factory
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */

var _toolbarItem = __webpack_require__(16);

var _toolbarItem2 = _interopRequireDefault(_toolbarItem);

var _toolbarButton = __webpack_require__(94);

var _toolbarButton2 = _interopRequireDefault(_toolbarButton);

var _toolbarDivider = __webpack_require__(42);

var _toolbarDivider2 = _interopRequireDefault(_toolbarDivider);

var _i18n = __webpack_require__(3);

var _i18n2 = _interopRequireDefault(_i18n);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Toolbar Item Factory
 */
var ToolbarItemFactory = function () {
  function ToolbarItemFactory() {
    _classCallCheck(this, ToolbarItemFactory);
  }

  _createClass(ToolbarItemFactory, null, [{
    key: 'create',

    /**
     * create toolbar item instance
     * @memberof ToolbarItemFactory
     * @param {string} name - toolbar item name
     * @param {object} [options] - options to the constructor
     * @return {ToolbarItem} - created toolbar item instance
     * @static
     */
    /* eslint-disable complexity */
    value: function create(name, options) {
      var toolbarItem = void 0;

      switch (name) {
        case 'heading':
          toolbarItem = new _toolbarButton2.default({
            name: 'heading',
            className: 'tui-heading',
            event: 'openHeadingSelect',
            tooltip: _i18n2.default.get('Headings')
          });
          break;
        case 'bold':
          toolbarItem = new _toolbarButton2.default({
            name: 'bold',
            className: 'tui-bold',
            command: 'Bold',
            tooltip: _i18n2.default.get('Bold'),
            state: 'bold'
          });
          break;
        case 'italic':
          toolbarItem = new _toolbarButton2.default({
            name: 'italic',
            className: 'tui-italic',
            command: 'Italic',
            tooltip: _i18n2.default.get('Italic'),
            state: 'italic'
          });
          break;
        case 'strike':
          toolbarItem = new _toolbarButton2.default({
            name: 'strike',
            className: 'tui-strike',
            command: 'Strike',
            tooltip: _i18n2.default.get('Strike'),
            state: 'strike'
          });
          break;
        case 'hr':
          toolbarItem = new _toolbarButton2.default({
            name: 'hr',
            className: 'tui-hrline',
            command: 'HR',
            tooltip: _i18n2.default.get('Line')
          });
          break;
        case 'quote':
          toolbarItem = new _toolbarButton2.default({
            name: 'quote',
            className: 'tui-quote',
            command: 'Blockquote',
            tooltip: _i18n2.default.get('Blockquote'),
            state: 'quote'
          });
          break;
        case 'ul':
          toolbarItem = new _toolbarButton2.default({
            name: 'ul',
            className: 'tui-ul',
            command: 'UL',
            tooltip: _i18n2.default.get('Unordered list')
          });
          break;
        case 'ol':
          toolbarItem = new _toolbarButton2.default({
            name: 'ol',
            className: 'tui-ol',
            command: 'OL',
            tooltip: _i18n2.default.get('Ordered list')
          });
          break;
        case 'task':
          toolbarItem = new _toolbarButton2.default({
            name: 'task',
            className: 'tui-task',
            command: 'Task',
            tooltip: _i18n2.default.get('Task')
          });
          break;
        case 'table':
          toolbarItem = new _toolbarButton2.default({
            name: 'table',
            className: 'tui-table',
            event: 'openPopupAddTable',
            tooltip: _i18n2.default.get('Insert table')
          });
          break;
        case 'image':
          toolbarItem = new _toolbarButton2.default({
            name: 'image',
            className: 'tui-image',
            event: 'openPopupAddImage',
            tooltip: _i18n2.default.get('Insert image'),
            state: ''
          });
          break;
        case 'link':
          toolbarItem = new _toolbarButton2.default({
            name: 'link',
            className: 'tui-link',
            event: 'openPopupAddLink',
            tooltip: _i18n2.default.get('Insert link')
          });
          break;
        case 'code':
          toolbarItem = new _toolbarButton2.default({
            name: 'code',
            className: 'tui-code',
            command: 'Code',
            tooltip: _i18n2.default.get('Code'),
            state: 'code'
          });
          break;
        case 'codeblock':
          toolbarItem = new _toolbarButton2.default({
            name: 'codeblock',
            className: 'tui-codeblock',
            command: 'CodeBlock',
            tooltip: _i18n2.default.get('Insert CodeBlock'),
            state: 'codeBlock'
          });
          break;
        case 'indent':
          toolbarItem = new _toolbarButton2.default({
            name: 'indent',
            className: 'tui-indent',
            command: 'Indent',
            tooltip: _i18n2.default.get('Indent')
          });
          break;
        case 'outdent':
          toolbarItem = new _toolbarButton2.default({
            name: 'outdent',
            className: 'tui-outdent',
            command: 'Outdent',
            tooltip: _i18n2.default.get('Outdent')
          });
          break;
        case 'divider':
          toolbarItem = new _toolbarDivider2.default();
          break;
        case 'button':
          toolbarItem = new _toolbarButton2.default(options);
          break;
        case 'item':
        default:
          toolbarItem = new _toolbarItem2.default(options);
      }

      return toolbarItem;
    }
    /* eslint-enable complexity */

  }]);

  return ToolbarItemFactory;
}();

exports.default = ToolbarItemFactory;

/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _uicontroller = __webpack_require__(14);

var _uicontroller2 = _interopRequireDefault(_uicontroller);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements tab button ui
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var CLASS_TAB_ACTIVE = 'te-tab-active';

/**
 * Class Tab
 * @extends {UIController}
 */

var Tab = function (_UIController) {
  _inherits(Tab, _UIController);

  /**
   * Creates an instance of Tab.
   * @param {object} options - options
   *  @param {string} [options.initName] - name of the default activated button
   *  @param {string[]} options.items - Button names to be created
   *  @param {DOMElement[]} options.sections - Dom elements for tab
   *  @param {function} [options.onItemClick] - when button is clicked pass button name to function
   * @memberof Tab
   */
  function Tab() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, Tab);

    var _this = _possibleConstructorReturn(this, (Tab.__proto__ || Object.getPrototypeOf(Tab)).call(this, {
      tagName: 'div',
      className: 'te-tab'
    }));

    _this.sections = options.sections;

    _this._$activeButton = null;

    _this._render(options);
    _this._initEvent(options);
    return _this;
  }

  _createClass(Tab, [{
    key: '_initEvent',
    value: function _initEvent(options) {
      var onItemClick = options.onItemClick;

      if (onItemClick) {
        this.on('itemClick', onItemClick);
      }

      this.on('click button', this._onTabButton.bind(this));
    }
  }, {
    key: '_render',
    value: function _render(options) {
      var items = options.items,
          initName = options.initName;

      var tabButtons = [];
      for (var i = 0, len = items.length; i < len; i += 1) {
        tabButtons.push('<button type="button" data-index="' + i + '">' + items[i] + '</button>');
      }
      this.$el.html(tabButtons.join(''));
      this.activate(initName);
    }

    /**
     * activate
     * Activate Section & Button
     * @param {string} name button name to activate
     */

  }, {
    key: 'activate',
    value: function activate(name) {
      var $button = this.$el.find('button:contains("' + name + '")');
      this._activateTabByButton($button);
    }
  }, {
    key: '_onTabButton',
    value: function _onTabButton(ev) {
      var $button = (0, _jquery2.default)(ev.target);
      this._activateTabByButton($button);
      this.trigger('itemClick', $button.text());
    }
  }, {
    key: '_activateTabByButton',
    value: function _activateTabByButton($button) {
      if (this._isActivatedButton($button)) {
        return;
      }

      this._updateClassByButton($button);
    }
  }, {
    key: '_updateClassByButton',
    value: function _updateClassByButton($activeButton) {
      // deactivate previously activated button
      if (this._$activeButton) {
        var sectionIndex = this._$activeButton.attr('data-index');
        this._$activeButton.removeClass(CLASS_TAB_ACTIVE);
        if (this.sections) {
          this.sections[sectionIndex].removeClass(CLASS_TAB_ACTIVE);
        }
      }

      // activate new button
      $activeButton.addClass(CLASS_TAB_ACTIVE);
      this._$activeButton = $activeButton;
      var index = $activeButton.attr('data-index');
      if (this.sections) {
        this.sections[index].addClass(CLASS_TAB_ACTIVE);
      }
    }
  }, {
    key: '_isActivatedButton',
    value: function _isActivatedButton($button) {
      return this._$activeButton && this._$activeButton.text() === $button.text();
    }
  }]);

  return Tab;
}(_uicontroller2.default);

exports.default = Tab;

/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

module.exports = Stream;

var EE = __webpack_require__(24).EventEmitter;
var inherits = __webpack_require__(13);

inherits(Stream, EE);
Stream.Readable = __webpack_require__(25);
Stream.Writable = __webpack_require__(168);
Stream.Duplex = __webpack_require__(169);
Stream.Transform = __webpack_require__(170);
Stream.PassThrough = __webpack_require__(171);

// Backwards-compat with node 0.4.x
Stream.Stream = Stream;



// old-style streams.  Note that the pipe method (the only relevant
// part of this class) is overridden in the Readable class.

function Stream() {
  EE.call(this);
}

Stream.prototype.pipe = function(dest, options) {
  var source = this;

  function ondata(chunk) {
    if (dest.writable) {
      if (false === dest.write(chunk) && source.pause) {
        source.pause();
      }
    }
  }

  source.on('data', ondata);

  function ondrain() {
    if (source.readable && source.resume) {
      source.resume();
    }
  }

  dest.on('drain', ondrain);

  // If the 'end' option is not supplied, dest.end() will be called when
  // source gets the 'end' or 'close' events.  Only dest.end() once.
  if (!dest._isStdio && (!options || options.end !== false)) {
    source.on('end', onend);
    source.on('close', onclose);
  }

  var didOnEnd = false;
  function onend() {
    if (didOnEnd) return;
    didOnEnd = true;

    dest.end();
  }


  function onclose() {
    if (didOnEnd) return;
    didOnEnd = true;

    if (typeof dest.destroy === 'function') dest.destroy();
  }

  // don't leave dangling pipes when there are errors.
  function onerror(er) {
    cleanup();
    if (EE.listenerCount(this, 'error') === 0) {
      throw er; // Unhandled stream error in pipe.
    }
  }

  source.on('error', onerror);
  dest.on('error', onerror);

  // remove all the event listeners that were added.
  function cleanup() {
    source.removeListener('data', ondata);
    dest.removeListener('drain', ondrain);

    source.removeListener('end', onend);
    source.removeListener('close', onclose);

    source.removeListener('error', onerror);
    dest.removeListener('error', onerror);

    source.removeListener('end', cleanup);
    source.removeListener('close', cleanup);

    dest.removeListener('close', cleanup);
  }

  source.on('end', cleanup);
  source.on('close', cleanup);

  dest.on('close', cleanup);

  dest.emit('pipe', source);

  // Allow for unix-like usage: A.pipe(B).pipe(C)
  return dest;
};


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global, process) {// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



/*<replacement>*/

var processNextTick = __webpack_require__(18);
/*</replacement>*/

module.exports = Readable;

/*<replacement>*/
var isArray = __webpack_require__(47);
/*</replacement>*/

/*<replacement>*/
var Duplex;
/*</replacement>*/

Readable.ReadableState = ReadableState;

/*<replacement>*/
var EE = __webpack_require__(24).EventEmitter;

var EElistenerCount = function (emitter, type) {
  return emitter.listeners(type).length;
};
/*</replacement>*/

/*<replacement>*/
var Stream = __webpack_require__(48);
/*</replacement>*/

// TODO(bmeurer): Change this back to const once hole checks are
// properly optimized away early in Ignition+TurboFan.
/*<replacement>*/
var Buffer = __webpack_require__(19).Buffer;
var OurUint8Array = global.Uint8Array || function () {};
function _uint8ArrayToBuffer(chunk) {
  return Buffer.from(chunk);
}
function _isUint8Array(obj) {
  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
}
/*</replacement>*/

/*<replacement>*/
var util = __webpack_require__(15);
util.inherits = __webpack_require__(13);
/*</replacement>*/

/*<replacement>*/
var debugUtil = __webpack_require__(162);
var debug = void 0;
if (debugUtil && debugUtil.debuglog) {
  debug = debugUtil.debuglog('stream');
} else {
  debug = function () {};
}
/*</replacement>*/

var BufferList = __webpack_require__(163);
var destroyImpl = __webpack_require__(50);
var StringDecoder;

util.inherits(Readable, Stream);

var kProxyEvents = ['error', 'close', 'destroy', 'pause', 'resume'];

function prependListener(emitter, event, fn) {
  // Sadly this is not cacheable as some libraries bundle their own
  // event emitter implementation with them.
  if (typeof emitter.prependListener === 'function') {
    return emitter.prependListener(event, fn);
  } else {
    // This is a hack to make sure that our error handler is attached before any
    // userland ones.  NEVER DO THIS. This is here only because this code needs
    // to continue to work with older versions of Node.js that do not include
    // the prependListener() method. The goal is to eventually remove this hack.
    if (!emitter._events || !emitter._events[event]) emitter.on(event, fn);else if (isArray(emitter._events[event])) emitter._events[event].unshift(fn);else emitter._events[event] = [fn, emitter._events[event]];
  }
}

function ReadableState(options, stream) {
  Duplex = Duplex || __webpack_require__(11);

  options = options || {};

  // object stream flag. Used to make read(n) ignore n and to
  // make all the buffer merging and length checks go away
  this.objectMode = !!options.objectMode;

  if (stream instanceof Duplex) this.objectMode = this.objectMode || !!options.readableObjectMode;

  // the point at which it stops calling _read() to fill the buffer
  // Note: 0 is a valid value, means "don't call _read preemptively ever"
  var hwm = options.highWaterMark;
  var defaultHwm = this.objectMode ? 16 : 16 * 1024;
  this.highWaterMark = hwm || hwm === 0 ? hwm : defaultHwm;

  // cast to ints.
  this.highWaterMark = Math.floor(this.highWaterMark);

  // A linked list is used to store data chunks instead of an array because the
  // linked list can remove elements from the beginning faster than
  // array.shift()
  this.buffer = new BufferList();
  this.length = 0;
  this.pipes = null;
  this.pipesCount = 0;
  this.flowing = null;
  this.ended = false;
  this.endEmitted = false;
  this.reading = false;

  // a flag to be able to tell if the event 'readable'/'data' is emitted
  // immediately, or on a later tick.  We set this to true at first, because
  // any actions that shouldn't happen until "later" should generally also
  // not happen before the first read call.
  this.sync = true;

  // whenever we return null, then we set a flag to say
  // that we're awaiting a 'readable' event emission.
  this.needReadable = false;
  this.emittedReadable = false;
  this.readableListening = false;
  this.resumeScheduled = false;

  // has it been destroyed
  this.destroyed = false;

  // Crypto is kind of old and crusty.  Historically, its default string
  // encoding is 'binary' so we have to make this configurable.
  // Everything else in the universe uses 'utf8', though.
  this.defaultEncoding = options.defaultEncoding || 'utf8';

  // the number of writers that are awaiting a drain event in .pipe()s
  this.awaitDrain = 0;

  // if true, a maybeReadMore has been scheduled
  this.readingMore = false;

  this.decoder = null;
  this.encoding = null;
  if (options.encoding) {
    if (!StringDecoder) StringDecoder = __webpack_require__(51).StringDecoder;
    this.decoder = new StringDecoder(options.encoding);
    this.encoding = options.encoding;
  }
}

function Readable(options) {
  Duplex = Duplex || __webpack_require__(11);

  if (!(this instanceof Readable)) return new Readable(options);

  this._readableState = new ReadableState(options, this);

  // legacy
  this.readable = true;

  if (options) {
    if (typeof options.read === 'function') this._read = options.read;

    if (typeof options.destroy === 'function') this._destroy = options.destroy;
  }

  Stream.call(this);
}

Object.defineProperty(Readable.prototype, 'destroyed', {
  get: function () {
    if (this._readableState === undefined) {
      return false;
    }
    return this._readableState.destroyed;
  },
  set: function (value) {
    // we ignore the value if the stream
    // has not been initialized yet
    if (!this._readableState) {
      return;
    }

    // backward compatibility, the user is explicitly
    // managing destroyed
    this._readableState.destroyed = value;
  }
});

Readable.prototype.destroy = destroyImpl.destroy;
Readable.prototype._undestroy = destroyImpl.undestroy;
Readable.prototype._destroy = function (err, cb) {
  this.push(null);
  cb(err);
};

// Manually shove something into the read() buffer.
// This returns true if the highWaterMark has not been hit yet,
// similar to how Writable.write() returns true if you should
// write() some more.
Readable.prototype.push = function (chunk, encoding) {
  var state = this._readableState;
  var skipChunkCheck;

  if (!state.objectMode) {
    if (typeof chunk === 'string') {
      encoding = encoding || state.defaultEncoding;
      if (encoding !== state.encoding) {
        chunk = Buffer.from(chunk, encoding);
        encoding = '';
      }
      skipChunkCheck = true;
    }
  } else {
    skipChunkCheck = true;
  }

  return readableAddChunk(this, chunk, encoding, false, skipChunkCheck);
};

// Unshift should *always* be something directly out of read()
Readable.prototype.unshift = function (chunk) {
  return readableAddChunk(this, chunk, null, true, false);
};

function readableAddChunk(stream, chunk, encoding, addToFront, skipChunkCheck) {
  var state = stream._readableState;
  if (chunk === null) {
    state.reading = false;
    onEofChunk(stream, state);
  } else {
    var er;
    if (!skipChunkCheck) er = chunkInvalid(state, chunk);
    if (er) {
      stream.emit('error', er);
    } else if (state.objectMode || chunk && chunk.length > 0) {
      if (typeof chunk !== 'string' && !state.objectMode && Object.getPrototypeOf(chunk) !== Buffer.prototype) {
        chunk = _uint8ArrayToBuffer(chunk);
      }

      if (addToFront) {
        if (state.endEmitted) stream.emit('error', new Error('stream.unshift() after end event'));else addChunk(stream, state, chunk, true);
      } else if (state.ended) {
        stream.emit('error', new Error('stream.push() after EOF'));
      } else {
        state.reading = false;
        if (state.decoder && !encoding) {
          chunk = state.decoder.write(chunk);
          if (state.objectMode || chunk.length !== 0) addChunk(stream, state, chunk, false);else maybeReadMore(stream, state);
        } else {
          addChunk(stream, state, chunk, false);
        }
      }
    } else if (!addToFront) {
      state.reading = false;
    }
  }

  return needMoreData(state);
}

function addChunk(stream, state, chunk, addToFront) {
  if (state.flowing && state.length === 0 && !state.sync) {
    stream.emit('data', chunk);
    stream.read(0);
  } else {
    // update the buffer info.
    state.length += state.objectMode ? 1 : chunk.length;
    if (addToFront) state.buffer.unshift(chunk);else state.buffer.push(chunk);

    if (state.needReadable) emitReadable(stream);
  }
  maybeReadMore(stream, state);
}

function chunkInvalid(state, chunk) {
  var er;
  if (!_isUint8Array(chunk) && typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
    er = new TypeError('Invalid non-string/buffer chunk');
  }
  return er;
}

// if it's past the high water mark, we can push in some more.
// Also, if we have no data yet, we can stand some
// more bytes.  This is to work around cases where hwm=0,
// such as the repl.  Also, if the push() triggered a
// readable event, and the user called read(largeNumber) such that
// needReadable was set, then we ought to push more, so that another
// 'readable' event will be triggered.
function needMoreData(state) {
  return !state.ended && (state.needReadable || state.length < state.highWaterMark || state.length === 0);
}

Readable.prototype.isPaused = function () {
  return this._readableState.flowing === false;
};

// backwards compatibility.
Readable.prototype.setEncoding = function (enc) {
  if (!StringDecoder) StringDecoder = __webpack_require__(51).StringDecoder;
  this._readableState.decoder = new StringDecoder(enc);
  this._readableState.encoding = enc;
  return this;
};

// Don't raise the hwm > 8MB
var MAX_HWM = 0x800000;
function computeNewHighWaterMark(n) {
  if (n >= MAX_HWM) {
    n = MAX_HWM;
  } else {
    // Get the next highest power of 2 to prevent increasing hwm excessively in
    // tiny amounts
    n--;
    n |= n >>> 1;
    n |= n >>> 2;
    n |= n >>> 4;
    n |= n >>> 8;
    n |= n >>> 16;
    n++;
  }
  return n;
}

// This function is designed to be inlinable, so please take care when making
// changes to the function body.
function howMuchToRead(n, state) {
  if (n <= 0 || state.length === 0 && state.ended) return 0;
  if (state.objectMode) return 1;
  if (n !== n) {
    // Only flow one buffer at a time
    if (state.flowing && state.length) return state.buffer.head.data.length;else return state.length;
  }
  // If we're asking for more than the current hwm, then raise the hwm.
  if (n > state.highWaterMark) state.highWaterMark = computeNewHighWaterMark(n);
  if (n <= state.length) return n;
  // Don't have enough
  if (!state.ended) {
    state.needReadable = true;
    return 0;
  }
  return state.length;
}

// you can override either this method, or the async _read(n) below.
Readable.prototype.read = function (n) {
  debug('read', n);
  n = parseInt(n, 10);
  var state = this._readableState;
  var nOrig = n;

  if (n !== 0) state.emittedReadable = false;

  // if we're doing read(0) to trigger a readable event, but we
  // already have a bunch of data in the buffer, then just trigger
  // the 'readable' event and move on.
  if (n === 0 && state.needReadable && (state.length >= state.highWaterMark || state.ended)) {
    debug('read: emitReadable', state.length, state.ended);
    if (state.length === 0 && state.ended) endReadable(this);else emitReadable(this);
    return null;
  }

  n = howMuchToRead(n, state);

  // if we've ended, and we're now clear, then finish it up.
  if (n === 0 && state.ended) {
    if (state.length === 0) endReadable(this);
    return null;
  }

  // All the actual chunk generation logic needs to be
  // *below* the call to _read.  The reason is that in certain
  // synthetic stream cases, such as passthrough streams, _read
  // may be a completely synchronous operation which may change
  // the state of the read buffer, providing enough data when
  // before there was *not* enough.
  //
  // So, the steps are:
  // 1. Figure out what the state of things will be after we do
  // a read from the buffer.
  //
  // 2. If that resulting state will trigger a _read, then call _read.
  // Note that this may be asynchronous, or synchronous.  Yes, it is
  // deeply ugly to write APIs this way, but that still doesn't mean
  // that the Readable class should behave improperly, as streams are
  // designed to be sync/async agnostic.
  // Take note if the _read call is sync or async (ie, if the read call
  // has returned yet), so that we know whether or not it's safe to emit
  // 'readable' etc.
  //
  // 3. Actually pull the requested chunks out of the buffer and return.

  // if we need a readable event, then we need to do some reading.
  var doRead = state.needReadable;
  debug('need readable', doRead);

  // if we currently have less than the highWaterMark, then also read some
  if (state.length === 0 || state.length - n < state.highWaterMark) {
    doRead = true;
    debug('length less than watermark', doRead);
  }

  // however, if we've ended, then there's no point, and if we're already
  // reading, then it's unnecessary.
  if (state.ended || state.reading) {
    doRead = false;
    debug('reading or ended', doRead);
  } else if (doRead) {
    debug('do read');
    state.reading = true;
    state.sync = true;
    // if the length is currently zero, then we *need* a readable event.
    if (state.length === 0) state.needReadable = true;
    // call internal read method
    this._read(state.highWaterMark);
    state.sync = false;
    // If _read pushed data synchronously, then `reading` will be false,
    // and we need to re-evaluate how much data we can return to the user.
    if (!state.reading) n = howMuchToRead(nOrig, state);
  }

  var ret;
  if (n > 0) ret = fromList(n, state);else ret = null;

  if (ret === null) {
    state.needReadable = true;
    n = 0;
  } else {
    state.length -= n;
  }

  if (state.length === 0) {
    // If we have nothing in the buffer, then we want to know
    // as soon as we *do* get something into the buffer.
    if (!state.ended) state.needReadable = true;

    // If we tried to read() past the EOF, then emit end on the next tick.
    if (nOrig !== n && state.ended) endReadable(this);
  }

  if (ret !== null) this.emit('data', ret);

  return ret;
};

function onEofChunk(stream, state) {
  if (state.ended) return;
  if (state.decoder) {
    var chunk = state.decoder.end();
    if (chunk && chunk.length) {
      state.buffer.push(chunk);
      state.length += state.objectMode ? 1 : chunk.length;
    }
  }
  state.ended = true;

  // emit 'readable' now to make sure it gets picked up.
  emitReadable(stream);
}

// Don't emit readable right away in sync mode, because this can trigger
// another read() call => stack overflow.  This way, it might trigger
// a nextTick recursion warning, but that's not so bad.
function emitReadable(stream) {
  var state = stream._readableState;
  state.needReadable = false;
  if (!state.emittedReadable) {
    debug('emitReadable', state.flowing);
    state.emittedReadable = true;
    if (state.sync) processNextTick(emitReadable_, stream);else emitReadable_(stream);
  }
}

function emitReadable_(stream) {
  debug('emit readable');
  stream.emit('readable');
  flow(stream);
}

// at this point, the user has presumably seen the 'readable' event,
// and called read() to consume some data.  that may have triggered
// in turn another _read(n) call, in which case reading = true if
// it's in progress.
// However, if we're not ended, or reading, and the length < hwm,
// then go ahead and try to read some more preemptively.
function maybeReadMore(stream, state) {
  if (!state.readingMore) {
    state.readingMore = true;
    processNextTick(maybeReadMore_, stream, state);
  }
}

function maybeReadMore_(stream, state) {
  var len = state.length;
  while (!state.reading && !state.flowing && !state.ended && state.length < state.highWaterMark) {
    debug('maybeReadMore read 0');
    stream.read(0);
    if (len === state.length)
      // didn't get any data, stop spinning.
      break;else len = state.length;
  }
  state.readingMore = false;
}

// abstract method.  to be overridden in specific implementation classes.
// call cb(er, data) where data is <= n in length.
// for virtual (non-string, non-buffer) streams, "length" is somewhat
// arbitrary, and perhaps not very meaningful.
Readable.prototype._read = function (n) {
  this.emit('error', new Error('_read() is not implemented'));
};

Readable.prototype.pipe = function (dest, pipeOpts) {
  var src = this;
  var state = this._readableState;

  switch (state.pipesCount) {
    case 0:
      state.pipes = dest;
      break;
    case 1:
      state.pipes = [state.pipes, dest];
      break;
    default:
      state.pipes.push(dest);
      break;
  }
  state.pipesCount += 1;
  debug('pipe count=%d opts=%j', state.pipesCount, pipeOpts);

  var doEnd = (!pipeOpts || pipeOpts.end !== false) && dest !== process.stdout && dest !== process.stderr;

  var endFn = doEnd ? onend : unpipe;
  if (state.endEmitted) processNextTick(endFn);else src.once('end', endFn);

  dest.on('unpipe', onunpipe);
  function onunpipe(readable, unpipeInfo) {
    debug('onunpipe');
    if (readable === src) {
      if (unpipeInfo && unpipeInfo.hasUnpiped === false) {
        unpipeInfo.hasUnpiped = true;
        cleanup();
      }
    }
  }

  function onend() {
    debug('onend');
    dest.end();
  }

  // when the dest drains, it reduces the awaitDrain counter
  // on the source.  This would be more elegant with a .once()
  // handler in flow(), but adding and removing repeatedly is
  // too slow.
  var ondrain = pipeOnDrain(src);
  dest.on('drain', ondrain);

  var cleanedUp = false;
  function cleanup() {
    debug('cleanup');
    // cleanup event handlers once the pipe is broken
    dest.removeListener('close', onclose);
    dest.removeListener('finish', onfinish);
    dest.removeListener('drain', ondrain);
    dest.removeListener('error', onerror);
    dest.removeListener('unpipe', onunpipe);
    src.removeListener('end', onend);
    src.removeListener('end', unpipe);
    src.removeListener('data', ondata);

    cleanedUp = true;

    // if the reader is waiting for a drain event from this
    // specific writer, then it would cause it to never start
    // flowing again.
    // So, if this is awaiting a drain, then we just call it now.
    // If we don't know, then assume that we are waiting for one.
    if (state.awaitDrain && (!dest._writableState || dest._writableState.needDrain)) ondrain();
  }

  // If the user pushes more data while we're writing to dest then we'll end up
  // in ondata again. However, we only want to increase awaitDrain once because
  // dest will only emit one 'drain' event for the multiple writes.
  // => Introduce a guard on increasing awaitDrain.
  var increasedAwaitDrain = false;
  src.on('data', ondata);
  function ondata(chunk) {
    debug('ondata');
    increasedAwaitDrain = false;
    var ret = dest.write(chunk);
    if (false === ret && !increasedAwaitDrain) {
      // If the user unpiped during `dest.write()`, it is possible
      // to get stuck in a permanently paused state if that write
      // also returned false.
      // => Check whether `dest` is still a piping destination.
      if ((state.pipesCount === 1 && state.pipes === dest || state.pipesCount > 1 && indexOf(state.pipes, dest) !== -1) && !cleanedUp) {
        debug('false write response, pause', src._readableState.awaitDrain);
        src._readableState.awaitDrain++;
        increasedAwaitDrain = true;
      }
      src.pause();
    }
  }

  // if the dest has an error, then stop piping into it.
  // however, don't suppress the throwing behavior for this.
  function onerror(er) {
    debug('onerror', er);
    unpipe();
    dest.removeListener('error', onerror);
    if (EElistenerCount(dest, 'error') === 0) dest.emit('error', er);
  }

  // Make sure our error handler is attached before userland ones.
  prependListener(dest, 'error', onerror);

  // Both close and finish should trigger unpipe, but only once.
  function onclose() {
    dest.removeListener('finish', onfinish);
    unpipe();
  }
  dest.once('close', onclose);
  function onfinish() {
    debug('onfinish');
    dest.removeListener('close', onclose);
    unpipe();
  }
  dest.once('finish', onfinish);

  function unpipe() {
    debug('unpipe');
    src.unpipe(dest);
  }

  // tell the dest that it's being piped to
  dest.emit('pipe', src);

  // start the flow if it hasn't been started already.
  if (!state.flowing) {
    debug('pipe resume');
    src.resume();
  }

  return dest;
};

function pipeOnDrain(src) {
  return function () {
    var state = src._readableState;
    debug('pipeOnDrain', state.awaitDrain);
    if (state.awaitDrain) state.awaitDrain--;
    if (state.awaitDrain === 0 && EElistenerCount(src, 'data')) {
      state.flowing = true;
      flow(src);
    }
  };
}

Readable.prototype.unpipe = function (dest) {
  var state = this._readableState;
  var unpipeInfo = { hasUnpiped: false };

  // if we're not piping anywhere, then do nothing.
  if (state.pipesCount === 0) return this;

  // just one destination.  most common case.
  if (state.pipesCount === 1) {
    // passed in one, but it's not the right one.
    if (dest && dest !== state.pipes) return this;

    if (!dest) dest = state.pipes;

    // got a match.
    state.pipes = null;
    state.pipesCount = 0;
    state.flowing = false;
    if (dest) dest.emit('unpipe', this, unpipeInfo);
    return this;
  }

  // slow case. multiple pipe destinations.

  if (!dest) {
    // remove all.
    var dests = state.pipes;
    var len = state.pipesCount;
    state.pipes = null;
    state.pipesCount = 0;
    state.flowing = false;

    for (var i = 0; i < len; i++) {
      dests[i].emit('unpipe', this, unpipeInfo);
    }return this;
  }

  // try to find the right one.
  var index = indexOf(state.pipes, dest);
  if (index === -1) return this;

  state.pipes.splice(index, 1);
  state.pipesCount -= 1;
  if (state.pipesCount === 1) state.pipes = state.pipes[0];

  dest.emit('unpipe', this, unpipeInfo);

  return this;
};

// set up data events if they are asked for
// Ensure readable listeners eventually get something
Readable.prototype.on = function (ev, fn) {
  var res = Stream.prototype.on.call(this, ev, fn);

  if (ev === 'data') {
    // Start flowing on next tick if stream isn't explicitly paused
    if (this._readableState.flowing !== false) this.resume();
  } else if (ev === 'readable') {
    var state = this._readableState;
    if (!state.endEmitted && !state.readableListening) {
      state.readableListening = state.needReadable = true;
      state.emittedReadable = false;
      if (!state.reading) {
        processNextTick(nReadingNextTick, this);
      } else if (state.length) {
        emitReadable(this);
      }
    }
  }

  return res;
};
Readable.prototype.addListener = Readable.prototype.on;

function nReadingNextTick(self) {
  debug('readable nexttick read 0');
  self.read(0);
}

// pause() and resume() are remnants of the legacy readable stream API
// If the user uses them, then switch into old mode.
Readable.prototype.resume = function () {
  var state = this._readableState;
  if (!state.flowing) {
    debug('resume');
    state.flowing = true;
    resume(this, state);
  }
  return this;
};

function resume(stream, state) {
  if (!state.resumeScheduled) {
    state.resumeScheduled = true;
    processNextTick(resume_, stream, state);
  }
}

function resume_(stream, state) {
  if (!state.reading) {
    debug('resume read 0');
    stream.read(0);
  }

  state.resumeScheduled = false;
  state.awaitDrain = 0;
  stream.emit('resume');
  flow(stream);
  if (state.flowing && !state.reading) stream.read(0);
}

Readable.prototype.pause = function () {
  debug('call pause flowing=%j', this._readableState.flowing);
  if (false !== this._readableState.flowing) {
    debug('pause');
    this._readableState.flowing = false;
    this.emit('pause');
  }
  return this;
};

function flow(stream) {
  var state = stream._readableState;
  debug('flow', state.flowing);
  while (state.flowing && stream.read() !== null) {}
}

// wrap an old-style stream as the async data source.
// This is *not* part of the readable stream interface.
// It is an ugly unfortunate mess of history.
Readable.prototype.wrap = function (stream) {
  var state = this._readableState;
  var paused = false;

  var self = this;
  stream.on('end', function () {
    debug('wrapped end');
    if (state.decoder && !state.ended) {
      var chunk = state.decoder.end();
      if (chunk && chunk.length) self.push(chunk);
    }

    self.push(null);
  });

  stream.on('data', function (chunk) {
    debug('wrapped data');
    if (state.decoder) chunk = state.decoder.write(chunk);

    // don't skip over falsy values in objectMode
    if (state.objectMode && (chunk === null || chunk === undefined)) return;else if (!state.objectMode && (!chunk || !chunk.length)) return;

    var ret = self.push(chunk);
    if (!ret) {
      paused = true;
      stream.pause();
    }
  });

  // proxy all the other methods.
  // important when wrapping filters and duplexes.
  for (var i in stream) {
    if (this[i] === undefined && typeof stream[i] === 'function') {
      this[i] = function (method) {
        return function () {
          return stream[method].apply(stream, arguments);
        };
      }(i);
    }
  }

  // proxy certain important events.
  for (var n = 0; n < kProxyEvents.length; n++) {
    stream.on(kProxyEvents[n], self.emit.bind(self, kProxyEvents[n]));
  }

  // when we try to consume some more bytes, simply unpause the
  // underlying stream.
  self._read = function (n) {
    debug('wrapped _read', n);
    if (paused) {
      paused = false;
      stream.resume();
    }
  };

  return self;
};

// exposed for testing purposes only.
Readable._fromList = fromList;

// Pluck off n bytes from an array of buffers.
// Length is the combined lengths of all the buffers in the list.
// This function is designed to be inlinable, so please take care when making
// changes to the function body.
function fromList(n, state) {
  // nothing buffered
  if (state.length === 0) return null;

  var ret;
  if (state.objectMode) ret = state.buffer.shift();else if (!n || n >= state.length) {
    // read it all, truncate the list
    if (state.decoder) ret = state.buffer.join('');else if (state.buffer.length === 1) ret = state.buffer.head.data;else ret = state.buffer.concat(state.length);
    state.buffer.clear();
  } else {
    // read part of list
    ret = fromListPartial(n, state.buffer, state.decoder);
  }

  return ret;
}

// Extracts only enough buffered data to satisfy the amount requested.
// This function is designed to be inlinable, so please take care when making
// changes to the function body.
function fromListPartial(n, list, hasStrings) {
  var ret;
  if (n < list.head.data.length) {
    // slice is the same for buffers and strings
    ret = list.head.data.slice(0, n);
    list.head.data = list.head.data.slice(n);
  } else if (n === list.head.data.length) {
    // first chunk is a perfect match
    ret = list.shift();
  } else {
    // result spans more than one buffer
    ret = hasStrings ? copyFromBufferString(n, list) : copyFromBuffer(n, list);
  }
  return ret;
}

// Copies a specified amount of characters from the list of buffered data
// chunks.
// This function is designed to be inlinable, so please take care when making
// changes to the function body.
function copyFromBufferString(n, list) {
  var p = list.head;
  var c = 1;
  var ret = p.data;
  n -= ret.length;
  while (p = p.next) {
    var str = p.data;
    var nb = n > str.length ? str.length : n;
    if (nb === str.length) ret += str;else ret += str.slice(0, n);
    n -= nb;
    if (n === 0) {
      if (nb === str.length) {
        ++c;
        if (p.next) list.head = p.next;else list.head = list.tail = null;
      } else {
        list.head = p;
        p.data = str.slice(nb);
      }
      break;
    }
    ++c;
  }
  list.length -= c;
  return ret;
}

// Copies a specified amount of bytes from the list of buffered data chunks.
// This function is designed to be inlinable, so please take care when making
// changes to the function body.
function copyFromBuffer(n, list) {
  var ret = Buffer.allocUnsafe(n);
  var p = list.head;
  var c = 1;
  p.data.copy(ret);
  n -= p.data.length;
  while (p = p.next) {
    var buf = p.data;
    var nb = n > buf.length ? buf.length : n;
    buf.copy(ret, ret.length - n, 0, nb);
    n -= nb;
    if (n === 0) {
      if (nb === buf.length) {
        ++c;
        if (p.next) list.head = p.next;else list.head = list.tail = null;
      } else {
        list.head = p;
        p.data = buf.slice(nb);
      }
      break;
    }
    ++c;
  }
  list.length -= c;
  return ret;
}

function endReadable(stream) {
  var state = stream._readableState;

  // If we get here before consuming all the bytes, then that is a
  // bug in node.  Should never happen.
  if (state.length > 0) throw new Error('"endReadable()" called on non-empty stream');

  if (!state.endEmitted) {
    state.ended = true;
    processNextTick(endReadableNT, state, stream);
  }
}

function endReadableNT(state, stream) {
  // Check that we didn't get one last unshift.
  if (!state.endEmitted && state.length === 0) {
    state.endEmitted = true;
    stream.readable = false;
    stream.emit('end');
  }
}

function forEach(xs, f) {
  for (var i = 0, l = xs.length; i < l; i++) {
    f(xs[i], i);
  }
}

function indexOf(xs, x) {
  for (var i = 0, l = xs.length; i < l; i++) {
    if (xs[i] === x) return i;
  }
  return -1;
}
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(12), __webpack_require__(17)))

/***/ }),
/* 47 */
/***/ (function(module, exports) {

var toString = {}.toString;

module.exports = Array.isArray || function (arr) {
  return toString.call(arr) == '[object Array]';
};


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(24).EventEmitter;


/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */



var base64 = __webpack_require__(160)
var ieee754 = __webpack_require__(161)
var isArray = __webpack_require__(47)

exports.Buffer = Buffer
exports.SlowBuffer = SlowBuffer
exports.INSPECT_MAX_BYTES = 50

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Use Object implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * Due to various browser bugs, sometimes the Object implementation will be used even
 * when the browser supports typed arrays.
 *
 * Note:
 *
 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
 *
 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
 *
 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
 *     incorrect length in some situations.

 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
 * get the Object implementation, which is slower but behaves correctly.
 */
Buffer.TYPED_ARRAY_SUPPORT = global.TYPED_ARRAY_SUPPORT !== undefined
  ? global.TYPED_ARRAY_SUPPORT
  : typedArraySupport()

/*
 * Export kMaxLength after typed array support is determined.
 */
exports.kMaxLength = kMaxLength()

function typedArraySupport () {
  try {
    var arr = new Uint8Array(1)
    arr.__proto__ = {__proto__: Uint8Array.prototype, foo: function () { return 42 }}
    return arr.foo() === 42 && // typed array instances can be augmented
        typeof arr.subarray === 'function' && // chrome 9-10 lack `subarray`
        arr.subarray(1, 1).byteLength === 0 // ie10 has broken `subarray`
  } catch (e) {
    return false
  }
}

function kMaxLength () {
  return Buffer.TYPED_ARRAY_SUPPORT
    ? 0x7fffffff
    : 0x3fffffff
}

function createBuffer (that, length) {
  if (kMaxLength() < length) {
    throw new RangeError('Invalid typed array length')
  }
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = new Uint8Array(length)
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    if (that === null) {
      that = new Buffer(length)
    }
    that.length = length
  }

  return that
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
    return new Buffer(arg, encodingOrOffset, length)
  }

  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new Error(
        'If encoding is specified then the first argument must be a string'
      )
    }
    return allocUnsafe(this, arg)
  }
  return from(this, arg, encodingOrOffset, length)
}

Buffer.poolSize = 8192 // not used by this implementation

// TODO: Legacy, not needed anymore. Remove in next major version.
Buffer._augment = function (arr) {
  arr.__proto__ = Buffer.prototype
  return arr
}

function from (that, value, encodingOrOffset, length) {
  if (typeof value === 'number') {
    throw new TypeError('"value" argument must not be a number')
  }

  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
    return fromArrayBuffer(that, value, encodingOrOffset, length)
  }

  if (typeof value === 'string') {
    return fromString(that, value, encodingOrOffset)
  }

  return fromObject(that, value)
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(null, value, encodingOrOffset, length)
}

if (Buffer.TYPED_ARRAY_SUPPORT) {
  Buffer.prototype.__proto__ = Uint8Array.prototype
  Buffer.__proto__ = Uint8Array
  if (typeof Symbol !== 'undefined' && Symbol.species &&
      Buffer[Symbol.species] === Buffer) {
    // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
    Object.defineProperty(Buffer, Symbol.species, {
      value: null,
      configurable: true
    })
  }
}

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be a number')
  } else if (size < 0) {
    throw new RangeError('"size" argument must not be negative')
  }
}

function alloc (that, size, fill, encoding) {
  assertSize(size)
  if (size <= 0) {
    return createBuffer(that, size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpretted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(that, size).fill(fill, encoding)
      : createBuffer(that, size).fill(fill)
  }
  return createBuffer(that, size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(null, size, fill, encoding)
}

function allocUnsafe (that, size) {
  assertSize(size)
  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0)
  if (!Buffer.TYPED_ARRAY_SUPPORT) {
    for (var i = 0; i < size; ++i) {
      that[i] = 0
    }
  }
  return that
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(null, size)
}
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(null, size)
}

function fromString (that, string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8'
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('"encoding" must be a valid string encoding')
  }

  var length = byteLength(string, encoding) | 0
  that = createBuffer(that, length)

  var actual = that.write(string, encoding)

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    that = that.slice(0, actual)
  }

  return that
}

function fromArrayLike (that, array) {
  var length = array.length < 0 ? 0 : checked(array.length) | 0
  that = createBuffer(that, length)
  for (var i = 0; i < length; i += 1) {
    that[i] = array[i] & 255
  }
  return that
}

function fromArrayBuffer (that, array, byteOffset, length) {
  array.byteLength // this throws if `array` is not a valid ArrayBuffer

  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('\'offset\' is out of bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('\'length\' is out of bounds')
  }

  if (byteOffset === undefined && length === undefined) {
    array = new Uint8Array(array)
  } else if (length === undefined) {
    array = new Uint8Array(array, byteOffset)
  } else {
    array = new Uint8Array(array, byteOffset, length)
  }

  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = array
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    that = fromArrayLike(that, array)
  }
  return that
}

function fromObject (that, obj) {
  if (Buffer.isBuffer(obj)) {
    var len = checked(obj.length) | 0
    that = createBuffer(that, len)

    if (that.length === 0) {
      return that
    }

    obj.copy(that, 0, 0, len)
    return that
  }

  if (obj) {
    if ((typeof ArrayBuffer !== 'undefined' &&
        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
      if (typeof obj.length !== 'number' || isnan(obj.length)) {
        return createBuffer(that, 0)
      }
      return fromArrayLike(that, obj)
    }

    if (obj.type === 'Buffer' && isArray(obj.data)) {
      return fromArrayLike(that, obj.data)
    }
  }

  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
}

function checked (length) {
  // Note: cannot use `length < kMaxLength()` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= kMaxLength()) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
  }
  return length | 0
}

function SlowBuffer (length) {
  if (+length != length) { // eslint-disable-line eqeqeq
    length = 0
  }
  return Buffer.alloc(+length)
}

Buffer.isBuffer = function isBuffer (b) {
  return !!(b != null && b._isBuffer)
}

Buffer.compare = function compare (a, b) {
  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
    throw new TypeError('Arguments must be Buffers')
  }

  if (a === b) return 0

  var x = a.length
  var y = b.length

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i]
      y = b[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
}

Buffer.concat = function concat (list, length) {
  if (!isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  var i
  if (length === undefined) {
    length = 0
    for (i = 0; i < list.length; ++i) {
      length += list[i].length
    }
  }

  var buffer = Buffer.allocUnsafe(length)
  var pos = 0
  for (i = 0; i < list.length; ++i) {
    var buf = list[i]
    if (!Buffer.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    }
    buf.copy(buffer, pos)
    pos += buf.length
  }
  return buffer
}

function byteLength (string, encoding) {
  if (Buffer.isBuffer(string)) {
    return string.length
  }
  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    string = '' + string
  }

  var len = string.length
  if (len === 0) return 0

  // Use a for loop to avoid recursion
  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
      case undefined:
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) return utf8ToBytes(string).length // assume utf8
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}
Buffer.byteLength = byteLength

function slowToString (encoding, start, end) {
  var loweredCase = false

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length
  }

  if (end <= 0) {
    return ''
  }

  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0
  start >>>= 0

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8'

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase()
        loweredCase = true
    }
  }
}

// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
// Buffer instances.
Buffer.prototype._isBuffer = true

function swap (b, n, m) {
  var i = b[n]
  b[n] = b[m]
  b[m] = i
}

Buffer.prototype.swap16 = function swap16 () {
  var len = this.length
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')
  }
  for (var i = 0; i < len; i += 2) {
    swap(this, i, i + 1)
  }
  return this
}

Buffer.prototype.swap32 = function swap32 () {
  var len = this.length
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits')
  }
  for (var i = 0; i < len; i += 4) {
    swap(this, i, i + 3)
    swap(this, i + 1, i + 2)
  }
  return this
}

Buffer.prototype.swap64 = function swap64 () {
  var len = this.length
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits')
  }
  for (var i = 0; i < len; i += 8) {
    swap(this, i, i + 7)
    swap(this, i + 1, i + 6)
    swap(this, i + 2, i + 5)
    swap(this, i + 3, i + 4)
  }
  return this
}

Buffer.prototype.toString = function toString () {
  var length = this.length | 0
  if (length === 0) return ''
  if (arguments.length === 0) return utf8Slice(this, 0, length)
  return slowToString.apply(this, arguments)
}

Buffer.prototype.equals = function equals (b) {
  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
  if (this === b) return true
  return Buffer.compare(this, b) === 0
}

Buffer.prototype.inspect = function inspect () {
  var str = ''
  var max = exports.INSPECT_MAX_BYTES
  if (this.length > 0) {
    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ')
    if (this.length > max) str += ' ... '
  }
  return '<Buffer ' + str + '>'
}

Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
  if (!Buffer.isBuffer(target)) {
    throw new TypeError('Argument must be a Buffer')
  }

  if (start === undefined) {
    start = 0
  }
  if (end === undefined) {
    end = target ? target.length : 0
  }
  if (thisStart === undefined) {
    thisStart = 0
  }
  if (thisEnd === undefined) {
    thisEnd = this.length
  }

  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index')
  }

  if (thisStart >= thisEnd && start >= end) {
    return 0
  }
  if (thisStart >= thisEnd) {
    return -1
  }
  if (start >= end) {
    return 1
  }

  start >>>= 0
  end >>>= 0
  thisStart >>>= 0
  thisEnd >>>= 0

  if (this === target) return 0

  var x = thisEnd - thisStart
  var y = end - start
  var len = Math.min(x, y)

  var thisCopy = this.slice(thisStart, thisEnd)
  var targetCopy = target.slice(start, end)

  for (var i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i]
      y = targetCopy[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset
    byteOffset = 0
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff
  } else if (byteOffset < -0x80000000) {
    byteOffset = -0x80000000
  }
  byteOffset = +byteOffset  // Coerce to Number.
  if (isNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : (buffer.length - 1)
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
  if (byteOffset >= buffer.length) {
    if (dir) return -1
    else byteOffset = buffer.length - 1
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0
    else return -1
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding)
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (Buffer.isBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
  } else if (typeof val === 'number') {
    val = val & 0xFF // Search for a byte value [0-255]
    if (Buffer.TYPED_ARRAY_SUPPORT &&
        typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
      }
    }
    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
  }

  throw new TypeError('val must be string, number or Buffer')
}

function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
  var indexSize = 1
  var arrLength = arr.length
  var valLength = val.length

  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase()
    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
        encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1
      }
      indexSize = 2
      arrLength /= 2
      valLength /= 2
      byteOffset /= 2
    }
  }

  function read (buf, i) {
    if (indexSize === 1) {
      return buf[i]
    } else {
      return buf.readUInt16BE(i * indexSize)
    }
  }

  var i
  if (dir) {
    var foundIndex = -1
    for (i = byteOffset; i < arrLength; i++) {
      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
      } else {
        if (foundIndex !== -1) i -= i - foundIndex
        foundIndex = -1
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
    for (i = byteOffset; i >= 0; i--) {
      var found = true
      for (var j = 0; j < valLength; j++) {
        if (read(arr, i + j) !== read(val, j)) {
          found = false
          break
        }
      }
      if (found) return i
    }
  }

  return -1
}

Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1
}

Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
}

Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
}

function hexWrite (buf, string, offset, length) {
  offset = Number(offset) || 0
  var remaining = buf.length - offset
  if (!length) {
    length = remaining
  } else {
    length = Number(length)
    if (length > remaining) {
      length = remaining
    }
  }

  // must be an even number of digits
  var strLen = string.length
  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

  if (length > strLen / 2) {
    length = strLen / 2
  }
  for (var i = 0; i < length; ++i) {
    var parsed = parseInt(string.substr(i * 2, 2), 16)
    if (isNaN(parsed)) return i
    buf[offset + i] = parsed
  }
  return i
}

function utf8Write (buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
}

function asciiWrite (buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length)
}

function latin1Write (buf, string, offset, length) {
  return asciiWrite(buf, string, offset, length)
}

function base64Write (buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length)
}

function ucs2Write (buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
}

Buffer.prototype.write = function write (string, offset, length, encoding) {
  // Buffer#write(string)
  if (offset === undefined) {
    encoding = 'utf8'
    length = this.length
    offset = 0
  // Buffer#write(string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset
    length = this.length
    offset = 0
  // Buffer#write(string, offset[, length][, encoding])
  } else if (isFinite(offset)) {
    offset = offset | 0
    if (isFinite(length)) {
      length = length | 0
      if (encoding === undefined) encoding = 'utf8'
    } else {
      encoding = length
      length = undefined
    }
  // legacy write(string, encoding, offset, length) - remove in v0.13
  } else {
    throw new Error(
      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
    )
  }

  var remaining = this.length - offset
  if (length === undefined || length > remaining) length = remaining

  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
    throw new RangeError('Attempt to write outside buffer bounds')
  }

  if (!encoding) encoding = 'utf8'

  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'hex':
        return hexWrite(this, string, offset, length)

      case 'utf8':
      case 'utf-8':
        return utf8Write(this, string, offset, length)

      case 'ascii':
        return asciiWrite(this, string, offset, length)

      case 'latin1':
      case 'binary':
        return latin1Write(this, string, offset, length)

      case 'base64':
        // Warning: maxLength not taken into account in base64Write
        return base64Write(this, string, offset, length)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return ucs2Write(this, string, offset, length)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}

Buffer.prototype.toJSON = function toJSON () {
  return {
    type: 'Buffer',
    data: Array.prototype.slice.call(this._arr || this, 0)
  }
}

function base64Slice (buf, start, end) {
  if (start === 0 && end === buf.length) {
    return base64.fromByteArray(buf)
  } else {
    return base64.fromByteArray(buf.slice(start, end))
  }
}

function utf8Slice (buf, start, end) {
  end = Math.min(buf.length, end)
  var res = []

  var i = start
  while (i < end) {
    var firstByte = buf[i]
    var codePoint = null
    var bytesPerSequence = (firstByte > 0xEF) ? 4
      : (firstByte > 0xDF) ? 3
      : (firstByte > 0xBF) ? 2
      : 1

    if (i + bytesPerSequence <= end) {
      var secondByte, thirdByte, fourthByte, tempCodePoint

      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 0x80) {
            codePoint = firstByte
          }
          break
        case 2:
          secondByte = buf[i + 1]
          if ((secondByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
            if (tempCodePoint > 0x7F) {
              codePoint = tempCodePoint
            }
          }
          break
        case 3:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
              codePoint = tempCodePoint
            }
          }
          break
        case 4:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          fourthByte = buf[i + 3]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
              codePoint = tempCodePoint
            }
          }
      }
    }

    if (codePoint === null) {
      // we did not generate a valid codePoint so insert a
      // replacement char (U+FFFD) and advance only 1 byte
      codePoint = 0xFFFD
      bytesPerSequence = 1
    } else if (codePoint > 0xFFFF) {
      // encode to utf16 (surrogate pair dance)
      codePoint -= 0x10000
      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
      codePoint = 0xDC00 | codePoint & 0x3FF
    }

    res.push(codePoint)
    i += bytesPerSequence
  }

  return decodeCodePointsArray(res)
}

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
var MAX_ARGUMENTS_LENGTH = 0x1000

function decodeCodePointsArray (codePoints) {
  var len = codePoints.length
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
  }

  // Decode in chunks to avoid "call stack size exceeded".
  var res = ''
  var i = 0
  while (i < len) {
    res += String.fromCharCode.apply(
      String,
      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
    )
  }
  return res
}

function asciiSlice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 0x7F)
  }
  return ret
}

function latin1Slice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i])
  }
  return ret
}

function hexSlice (buf, start, end) {
  var len = buf.length

  if (!start || start < 0) start = 0
  if (!end || end < 0 || end > len) end = len

  var out = ''
  for (var i = start; i < end; ++i) {
    out += toHex(buf[i])
  }
  return out
}

function utf16leSlice (buf, start, end) {
  var bytes = buf.slice(start, end)
  var res = ''
  for (var i = 0; i < bytes.length; i += 2) {
    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256)
  }
  return res
}

Buffer.prototype.slice = function slice (start, end) {
  var len = this.length
  start = ~~start
  end = end === undefined ? len : ~~end

  if (start < 0) {
    start += len
    if (start < 0) start = 0
  } else if (start > len) {
    start = len
  }

  if (end < 0) {
    end += len
    if (end < 0) end = 0
  } else if (end > len) {
    end = len
  }

  if (end < start) end = start

  var newBuf
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    newBuf = this.subarray(start, end)
    newBuf.__proto__ = Buffer.prototype
  } else {
    var sliceLen = end - start
    newBuf = new Buffer(sliceLen, undefined)
    for (var i = 0; i < sliceLen; ++i) {
      newBuf[i] = this[i + start]
    }
  }

  return newBuf
}

/*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
function checkOffset (offset, ext, length) {
  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
}

Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }

  return val
}

Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    checkOffset(offset, byteLength, this.length)
  }

  var val = this[offset + --byteLength]
  var mul = 1
  while (byteLength > 0 && (mul *= 0x100)) {
    val += this[offset + --byteLength] * mul
  }

  return val
}

Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length)
  return this[offset]
}

Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  return this[offset] | (this[offset + 1] << 8)
}

Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  return (this[offset] << 8) | this[offset + 1]
}

Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return ((this[offset]) |
      (this[offset + 1] << 8) |
      (this[offset + 2] << 16)) +
      (this[offset + 3] * 0x1000000)
}

Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] * 0x1000000) +
    ((this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    this[offset + 3])
}

Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var i = byteLength
  var mul = 1
  var val = this[offset + --i]
  while (i > 0 && (mul *= 0x100)) {
    val += this[offset + --i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length)
  if (!(this[offset] & 0x80)) return (this[offset])
  return ((0xff - this[offset] + 1) * -1)
}

Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset] | (this[offset + 1] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset + 1] | (this[offset] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset]) |
    (this[offset + 1] << 8) |
    (this[offset + 2] << 16) |
    (this[offset + 3] << 24)
}

Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] << 24) |
    (this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    (this[offset + 3])
}

Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, true, 23, 4)
}

Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, false, 23, 4)
}

Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, true, 52, 8)
}

Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, false, 52, 8)
}

function checkInt (buf, value, offset, ext, max, min) {
  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
}

Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var mul = 1
  var i = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var i = byteLength - 1
  var mul = 1
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
  this[offset] = (value & 0xff)
  return offset + 1
}

function objectWriteUInt16 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffff + value + 1
  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
      (littleEndian ? i : 1 - i) * 8
  }
}

Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
  } else {
    objectWriteUInt16(this, value, offset, true)
  }
  return offset + 2
}

Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8)
    this[offset + 1] = (value & 0xff)
  } else {
    objectWriteUInt16(this, value, offset, false)
  }
  return offset + 2
}

function objectWriteUInt32 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffffffff + value + 1
  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff
  }
}

Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset + 3] = (value >>> 24)
    this[offset + 2] = (value >>> 16)
    this[offset + 1] = (value >>> 8)
    this[offset] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, true)
  }
  return offset + 4
}

Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24)
    this[offset + 1] = (value >>> 16)
    this[offset + 2] = (value >>> 8)
    this[offset + 3] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, false)
  }
  return offset + 4
}

Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = 0
  var mul = 1
  var sub = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = byteLength - 1
  var mul = 1
  var sub = 0
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
  if (value < 0) value = 0xff + value + 1
  this[offset] = (value & 0xff)
  return offset + 1
}

Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
  } else {
    objectWriteUInt16(this, value, offset, true)
  }
  return offset + 2
}

Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8)
    this[offset + 1] = (value & 0xff)
  } else {
    objectWriteUInt16(this, value, offset, false)
  }
  return offset + 2
}

Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
    this[offset + 2] = (value >>> 16)
    this[offset + 3] = (value >>> 24)
  } else {
    objectWriteUInt32(this, value, offset, true)
  }
  return offset + 4
}

Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (value < 0) value = 0xffffffff + value + 1
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24)
    this[offset + 1] = (value >>> 16)
    this[offset + 2] = (value >>> 8)
    this[offset + 3] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, false)
  }
  return offset + 4
}

function checkIEEE754 (buf, value, offset, ext, max, min) {
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
  if (offset < 0) throw new RangeError('Index out of range')
}

function writeFloat (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
  }
  ieee754.write(buf, value, offset, littleEndian, 23, 4)
  return offset + 4
}

Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
  return writeFloat(this, value, offset, true, noAssert)
}

Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
  return writeFloat(this, value, offset, false, noAssert)
}

function writeDouble (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
  }
  ieee754.write(buf, value, offset, littleEndian, 52, 8)
  return offset + 8
}

Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
  return writeDouble(this, value, offset, true, noAssert)
}

Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
  return writeDouble(this, value, offset, false, noAssert)
}

// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
Buffer.prototype.copy = function copy (target, targetStart, start, end) {
  if (!start) start = 0
  if (!end && end !== 0) end = this.length
  if (targetStart >= target.length) targetStart = target.length
  if (!targetStart) targetStart = 0
  if (end > 0 && end < start) end = start

  // Copy 0 bytes; we're done
  if (end === start) return 0
  if (target.length === 0 || this.length === 0) return 0

  // Fatal error conditions
  if (targetStart < 0) {
    throw new RangeError('targetStart out of bounds')
  }
  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
  if (end < 0) throw new RangeError('sourceEnd out of bounds')

  // Are we oob?
  if (end > this.length) end = this.length
  if (target.length - targetStart < end - start) {
    end = target.length - targetStart + start
  }

  var len = end - start
  var i

  if (this === target && start < targetStart && targetStart < end) {
    // descending copy from end
    for (i = len - 1; i >= 0; --i) {
      target[i + targetStart] = this[i + start]
    }
  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
    // ascending copy from start
    for (i = 0; i < len; ++i) {
      target[i + targetStart] = this[i + start]
    }
  } else {
    Uint8Array.prototype.set.call(
      target,
      this.subarray(start, start + len),
      targetStart
    )
  }

  return len
}

// Usage:
//    buffer.fill(number[, offset[, end]])
//    buffer.fill(buffer[, offset[, end]])
//    buffer.fill(string[, offset[, end]][, encoding])
Buffer.prototype.fill = function fill (val, start, end, encoding) {
  // Handle string cases:
  if (typeof val === 'string') {
    if (typeof start === 'string') {
      encoding = start
      start = 0
      end = this.length
    } else if (typeof end === 'string') {
      encoding = end
      end = this.length
    }
    if (val.length === 1) {
      var code = val.charCodeAt(0)
      if (code < 256) {
        val = code
      }
    }
    if (encoding !== undefined && typeof encoding !== 'string') {
      throw new TypeError('encoding must be a string')
    }
    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
      throw new TypeError('Unknown encoding: ' + encoding)
    }
  } else if (typeof val === 'number') {
    val = val & 255
  }

  // Invalid ranges are not set to a default, so can range check early.
  if (start < 0 || this.length < start || this.length < end) {
    throw new RangeError('Out of range index')
  }

  if (end <= start) {
    return this
  }

  start = start >>> 0
  end = end === undefined ? this.length : end >>> 0

  if (!val) val = 0

  var i
  if (typeof val === 'number') {
    for (i = start; i < end; ++i) {
      this[i] = val
    }
  } else {
    var bytes = Buffer.isBuffer(val)
      ? val
      : utf8ToBytes(new Buffer(val, encoding).toString())
    var len = bytes.length
    for (i = 0; i < end - start; ++i) {
      this[i + start] = bytes[i % len]
    }
  }

  return this
}

// HELPER FUNCTIONS
// ================

var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g

function base64clean (str) {
  // Node strips out invalid characters like \n and \t from the string, base64-js does not
  str = stringtrim(str).replace(INVALID_BASE64_RE, '')
  // Node converts strings with length < 2 to ''
  if (str.length < 2) return ''
  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
  while (str.length % 4 !== 0) {
    str = str + '='
  }
  return str
}

function stringtrim (str) {
  if (str.trim) return str.trim()
  return str.replace(/^\s+|\s+$/g, '')
}

function toHex (n) {
  if (n < 16) return '0' + n.toString(16)
  return n.toString(16)
}

function utf8ToBytes (string, units) {
  units = units || Infinity
  var codePoint
  var length = string.length
  var leadSurrogate = null
  var bytes = []

  for (var i = 0; i < length; ++i) {
    codePoint = string.charCodeAt(i)

    // is surrogate component
    if (codePoint > 0xD7FF && codePoint < 0xE000) {
      // last char was a lead
      if (!leadSurrogate) {
        // no lead yet
        if (codePoint > 0xDBFF) {
          // unexpected trail
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        } else if (i + 1 === length) {
          // unpaired lead
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        }

        // valid lead
        leadSurrogate = codePoint

        continue
      }

      // 2 leads in a row
      if (codePoint < 0xDC00) {
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
        leadSurrogate = codePoint
        continue
      }

      // valid surrogate pair
      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
    } else if (leadSurrogate) {
      // valid bmp char, but last char was a lead
      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
    }

    leadSurrogate = null

    // encode utf8
    if (codePoint < 0x80) {
      if ((units -= 1) < 0) break
      bytes.push(codePoint)
    } else if (codePoint < 0x800) {
      if ((units -= 2) < 0) break
      bytes.push(
        codePoint >> 0x6 | 0xC0,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x10000) {
      if ((units -= 3) < 0) break
      bytes.push(
        codePoint >> 0xC | 0xE0,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x110000) {
      if ((units -= 4) < 0) break
      bytes.push(
        codePoint >> 0x12 | 0xF0,
        codePoint >> 0xC & 0x3F | 0x80,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else {
      throw new Error('Invalid code point')
    }
  }

  return bytes
}

function asciiToBytes (str) {
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    // Node's code seems to be doing this and not & 0x7F..
    byteArray.push(str.charCodeAt(i) & 0xFF)
  }
  return byteArray
}

function utf16leToBytes (str, units) {
  var c, hi, lo
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    if ((units -= 2) < 0) break

    c = str.charCodeAt(i)
    hi = c >> 8
    lo = c % 256
    byteArray.push(lo)
    byteArray.push(hi)
  }

  return byteArray
}

function base64ToBytes (str) {
  return base64.toByteArray(base64clean(str))
}

function blitBuffer (src, dst, offset, length) {
  for (var i = 0; i < length; ++i) {
    if ((i + offset >= dst.length) || (i >= src.length)) break
    dst[i + offset] = src[i]
  }
  return i
}

function isnan (val) {
  return val !== val // eslint-disable-line no-self-compare
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(12)))

/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/*<replacement>*/

var processNextTick = __webpack_require__(18);
/*</replacement>*/

// undocumented cb() API, needed for core, not for public API
function destroy(err, cb) {
  var _this = this;

  var readableDestroyed = this._readableState && this._readableState.destroyed;
  var writableDestroyed = this._writableState && this._writableState.destroyed;

  if (readableDestroyed || writableDestroyed) {
    if (cb) {
      cb(err);
    } else if (err && (!this._writableState || !this._writableState.errorEmitted)) {
      processNextTick(emitErrorNT, this, err);
    }
    return;
  }

  // we set destroyed to true before firing error callbacks in order
  // to make it re-entrance safe in case destroy() is called within callbacks

  if (this._readableState) {
    this._readableState.destroyed = true;
  }

  // if this is a duplex stream mark the writable part as destroyed as well
  if (this._writableState) {
    this._writableState.destroyed = true;
  }

  this._destroy(err || null, function (err) {
    if (!cb && err) {
      processNextTick(emitErrorNT, _this, err);
      if (_this._writableState) {
        _this._writableState.errorEmitted = true;
      }
    } else if (cb) {
      cb(err);
    }
  });
}

function undestroy() {
  if (this._readableState) {
    this._readableState.destroyed = false;
    this._readableState.reading = false;
    this._readableState.ended = false;
    this._readableState.endEmitted = false;
  }

  if (this._writableState) {
    this._writableState.destroyed = false;
    this._writableState.ended = false;
    this._writableState.ending = false;
    this._writableState.finished = false;
    this._writableState.errorEmitted = false;
  }
}

function emitErrorNT(self, err) {
  self.emit('error', err);
}

module.exports = {
  destroy: destroy,
  undestroy: undestroy
};

/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var Buffer = __webpack_require__(19).Buffer;

var isEncoding = Buffer.isEncoding || function (encoding) {
  encoding = '' + encoding;
  switch (encoding && encoding.toLowerCase()) {
    case 'hex':case 'utf8':case 'utf-8':case 'ascii':case 'binary':case 'base64':case 'ucs2':case 'ucs-2':case 'utf16le':case 'utf-16le':case 'raw':
      return true;
    default:
      return false;
  }
};

function _normalizeEncoding(enc) {
  if (!enc) return 'utf8';
  var retried;
  while (true) {
    switch (enc) {
      case 'utf8':
      case 'utf-8':
        return 'utf8';
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return 'utf16le';
      case 'latin1':
      case 'binary':
        return 'latin1';
      case 'base64':
      case 'ascii':
      case 'hex':
        return enc;
      default:
        if (retried) return; // undefined
        enc = ('' + enc).toLowerCase();
        retried = true;
    }
  }
};

// Do not cache `Buffer.isEncoding` when checking encoding names as some
// modules monkey-patch it to support additional encodings
function normalizeEncoding(enc) {
  var nenc = _normalizeEncoding(enc);
  if (typeof nenc !== 'string' && (Buffer.isEncoding === isEncoding || !isEncoding(enc))) throw new Error('Unknown encoding: ' + enc);
  return nenc || enc;
}

// StringDecoder provides an interface for efficiently splitting a series of
// buffers into a series of JS strings without breaking apart multi-byte
// characters.
exports.StringDecoder = StringDecoder;
function StringDecoder(encoding) {
  this.encoding = normalizeEncoding(encoding);
  var nb;
  switch (this.encoding) {
    case 'utf16le':
      this.text = utf16Text;
      this.end = utf16End;
      nb = 4;
      break;
    case 'utf8':
      this.fillLast = utf8FillLast;
      nb = 4;
      break;
    case 'base64':
      this.text = base64Text;
      this.end = base64End;
      nb = 3;
      break;
    default:
      this.write = simpleWrite;
      this.end = simpleEnd;
      return;
  }
  this.lastNeed = 0;
  this.lastTotal = 0;
  this.lastChar = Buffer.allocUnsafe(nb);
}

StringDecoder.prototype.write = function (buf) {
  if (buf.length === 0) return '';
  var r;
  var i;
  if (this.lastNeed) {
    r = this.fillLast(buf);
    if (r === undefined) return '';
    i = this.lastNeed;
    this.lastNeed = 0;
  } else {
    i = 0;
  }
  if (i < buf.length) return r ? r + this.text(buf, i) : this.text(buf, i);
  return r || '';
};

StringDecoder.prototype.end = utf8End;

// Returns only complete characters in a Buffer
StringDecoder.prototype.text = utf8Text;

// Attempts to complete a partial non-UTF-8 character using bytes from a Buffer
StringDecoder.prototype.fillLast = function (buf) {
  if (this.lastNeed <= buf.length) {
    buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);
    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
  }
  buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);
  this.lastNeed -= buf.length;
};

// Checks the type of a UTF-8 byte, whether it's ASCII, a leading byte, or a
// continuation byte.
function utf8CheckByte(byte) {
  if (byte <= 0x7F) return 0;else if (byte >> 5 === 0x06) return 2;else if (byte >> 4 === 0x0E) return 3;else if (byte >> 3 === 0x1E) return 4;
  return -1;
}

// Checks at most 3 bytes at the end of a Buffer in order to detect an
// incomplete multi-byte UTF-8 character. The total number of bytes (2, 3, or 4)
// needed to complete the UTF-8 character (if applicable) are returned.
function utf8CheckIncomplete(self, buf, i) {
  var j = buf.length - 1;
  if (j < i) return 0;
  var nb = utf8CheckByte(buf[j]);
  if (nb >= 0) {
    if (nb > 0) self.lastNeed = nb - 1;
    return nb;
  }
  if (--j < i) return 0;
  nb = utf8CheckByte(buf[j]);
  if (nb >= 0) {
    if (nb > 0) self.lastNeed = nb - 2;
    return nb;
  }
  if (--j < i) return 0;
  nb = utf8CheckByte(buf[j]);
  if (nb >= 0) {
    if (nb > 0) {
      if (nb === 2) nb = 0;else self.lastNeed = nb - 3;
    }
    return nb;
  }
  return 0;
}

// Validates as many continuation bytes for a multi-byte UTF-8 character as
// needed or are available. If we see a non-continuation byte where we expect
// one, we "replace" the validated continuation bytes we've seen so far with
// UTF-8 replacement characters ('\ufffd'), to match v8's UTF-8 decoding
// behavior. The continuation byte check is included three times in the case
// where all of the continuation bytes for a character exist in the same buffer.
// It is also done this way as a slight performance increase instead of using a
// loop.
function utf8CheckExtraBytes(self, buf, p) {
  if ((buf[0] & 0xC0) !== 0x80) {
    self.lastNeed = 0;
    return '\ufffd'.repeat(p);
  }
  if (self.lastNeed > 1 && buf.length > 1) {
    if ((buf[1] & 0xC0) !== 0x80) {
      self.lastNeed = 1;
      return '\ufffd'.repeat(p + 1);
    }
    if (self.lastNeed > 2 && buf.length > 2) {
      if ((buf[2] & 0xC0) !== 0x80) {
        self.lastNeed = 2;
        return '\ufffd'.repeat(p + 2);
      }
    }
  }
}

// Attempts to complete a multi-byte UTF-8 character using bytes from a Buffer.
function utf8FillLast(buf) {
  var p = this.lastTotal - this.lastNeed;
  var r = utf8CheckExtraBytes(this, buf, p);
  if (r !== undefined) return r;
  if (this.lastNeed <= buf.length) {
    buf.copy(this.lastChar, p, 0, this.lastNeed);
    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
  }
  buf.copy(this.lastChar, p, 0, buf.length);
  this.lastNeed -= buf.length;
}

// Returns all complete UTF-8 characters in a Buffer. If the Buffer ended on a
// partial character, the character's bytes are buffered until the required
// number of bytes are available.
function utf8Text(buf, i) {
  var total = utf8CheckIncomplete(this, buf, i);
  if (!this.lastNeed) return buf.toString('utf8', i);
  this.lastTotal = total;
  var end = buf.length - (total - this.lastNeed);
  buf.copy(this.lastChar, 0, end);
  return buf.toString('utf8', i, end);
}

// For UTF-8, a replacement character for each buffered byte of a (partial)
// character needs to be added to the output.
function utf8End(buf) {
  var r = buf && buf.length ? this.write(buf) : '';
  if (this.lastNeed) return r + '\ufffd'.repeat(this.lastTotal - this.lastNeed);
  return r;
}

// UTF-16LE typically needs two bytes per character, but even if we have an even
// number of bytes available, we need to check if we end on a leading/high
// surrogate. In that case, we need to wait for the next two bytes in order to
// decode the last character properly.
function utf16Text(buf, i) {
  if ((buf.length - i) % 2 === 0) {
    var r = buf.toString('utf16le', i);
    if (r) {
      var c = r.charCodeAt(r.length - 1);
      if (c >= 0xD800 && c <= 0xDBFF) {
        this.lastNeed = 2;
        this.lastTotal = 4;
        this.lastChar[0] = buf[buf.length - 2];
        this.lastChar[1] = buf[buf.length - 1];
        return r.slice(0, -1);
      }
    }
    return r;
  }
  this.lastNeed = 1;
  this.lastTotal = 2;
  this.lastChar[0] = buf[buf.length - 1];
  return buf.toString('utf16le', i, buf.length - 1);
}

// For UTF-16LE we do not explicitly append special replacement characters if we
// end on a partial character, we simply let v8 handle that.
function utf16End(buf) {
  var r = buf && buf.length ? this.write(buf) : '';
  if (this.lastNeed) {
    var end = this.lastTotal - this.lastNeed;
    return r + this.lastChar.toString('utf16le', 0, end);
  }
  return r;
}

function base64Text(buf, i) {
  var n = (buf.length - i) % 3;
  if (n === 0) return buf.toString('base64', i);
  this.lastNeed = 3 - n;
  this.lastTotal = 3;
  if (n === 1) {
    this.lastChar[0] = buf[buf.length - 1];
  } else {
    this.lastChar[0] = buf[buf.length - 2];
    this.lastChar[1] = buf[buf.length - 1];
  }
  return buf.toString('base64', i, buf.length - n);
}

function base64End(buf) {
  var r = buf && buf.length ? this.write(buf) : '';
  if (this.lastNeed) return r + this.lastChar.toString('base64', 0, 3 - this.lastNeed);
  return r;
}

// Pass bytes on through for single-byte encodings (e.g. ascii, latin1, hex)
function simpleWrite(buf) {
  return buf.toString(this.encoding);
}

function simpleEnd(buf) {
  return buf && buf.length ? this.write(buf) : '';
}

/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// a transform stream is a readable/writable stream where you do
// something with the data.  Sometimes it's called a "filter",
// but that's not a great name for it, since that implies a thing where
// some bits pass through, and others are simply ignored.  (That would
// be a valid example of a transform, of course.)
//
// While the output is causally related to the input, it's not a
// necessarily symmetric or synchronous transformation.  For example,
// a zlib stream might take multiple plain-text writes(), and then
// emit a single compressed chunk some time in the future.
//
// Here's how this works:
//
// The Transform stream has all the aspects of the readable and writable
// stream classes.  When you write(chunk), that calls _write(chunk,cb)
// internally, and returns false if there's a lot of pending writes
// buffered up.  When you call read(), that calls _read(n) until
// there's enough pending readable data buffered up.
//
// In a transform stream, the written data is placed in a buffer.  When
// _read(n) is called, it transforms the queued up data, calling the
// buffered _write cb's as it consumes chunks.  If consuming a single
// written chunk would result in multiple output chunks, then the first
// outputted bit calls the readcb, and subsequent chunks just go into
// the read buffer, and will cause it to emit 'readable' if necessary.
//
// This way, back-pressure is actually determined by the reading side,
// since _read has to be called to start processing a new chunk.  However,
// a pathological inflate type of transform can cause excessive buffering
// here.  For example, imagine a stream where every byte of input is
// interpreted as an integer from 0-255, and then results in that many
// bytes of output.  Writing the 4 bytes {ff,ff,ff,ff} would result in
// 1kb of data being output.  In this case, you could write a very small
// amount of input, and end up with a very large amount of output.  In
// such a pathological inflating mechanism, there'd be no way to tell
// the system to stop doing the transform.  A single 4MB write could
// cause the system to run out of memory.
//
// However, even in such a pathological case, only a single written chunk
// would be consumed, and then the rest would wait (un-transformed) until
// the results of the previous transformed chunk were consumed.



module.exports = Transform;

var Duplex = __webpack_require__(11);

/*<replacement>*/
var util = __webpack_require__(15);
util.inherits = __webpack_require__(13);
/*</replacement>*/

util.inherits(Transform, Duplex);

function TransformState(stream) {
  this.afterTransform = function (er, data) {
    return afterTransform(stream, er, data);
  };

  this.needTransform = false;
  this.transforming = false;
  this.writecb = null;
  this.writechunk = null;
  this.writeencoding = null;
}

function afterTransform(stream, er, data) {
  var ts = stream._transformState;
  ts.transforming = false;

  var cb = ts.writecb;

  if (!cb) {
    return stream.emit('error', new Error('write callback called multiple times'));
  }

  ts.writechunk = null;
  ts.writecb = null;

  if (data !== null && data !== undefined) stream.push(data);

  cb(er);

  var rs = stream._readableState;
  rs.reading = false;
  if (rs.needReadable || rs.length < rs.highWaterMark) {
    stream._read(rs.highWaterMark);
  }
}

function Transform(options) {
  if (!(this instanceof Transform)) return new Transform(options);

  Duplex.call(this, options);

  this._transformState = new TransformState(this);

  var stream = this;

  // start out asking for a readable event once data is transformed.
  this._readableState.needReadable = true;

  // we have implemented the _read method, and done the other things
  // that Readable wants before the first _read call, so unset the
  // sync guard flag.
  this._readableState.sync = false;

  if (options) {
    if (typeof options.transform === 'function') this._transform = options.transform;

    if (typeof options.flush === 'function') this._flush = options.flush;
  }

  // When the writable side finishes, then flush out anything remaining.
  this.once('prefinish', function () {
    if (typeof this._flush === 'function') this._flush(function (er, data) {
      done(stream, er, data);
    });else done(stream);
  });
}

Transform.prototype.push = function (chunk, encoding) {
  this._transformState.needTransform = false;
  return Duplex.prototype.push.call(this, chunk, encoding);
};

// This is the part where you do stuff!
// override this function in implementation classes.
// 'chunk' is an input chunk.
//
// Call `push(newChunk)` to pass along transformed output
// to the readable side.  You may call 'push' zero or more times.
//
// Call `cb(err)` when you are done with this chunk.  If you pass
// an error, then that'll put the hurt on the whole operation.  If you
// never call cb(), then you'll never get another chunk.
Transform.prototype._transform = function (chunk, encoding, cb) {
  throw new Error('_transform() is not implemented');
};

Transform.prototype._write = function (chunk, encoding, cb) {
  var ts = this._transformState;
  ts.writecb = cb;
  ts.writechunk = chunk;
  ts.writeencoding = encoding;
  if (!ts.transforming) {
    var rs = this._readableState;
    if (ts.needTransform || rs.needReadable || rs.length < rs.highWaterMark) this._read(rs.highWaterMark);
  }
};

// Doesn't matter what the args are here.
// _transform does all the work.
// That we got here means that the readable side wants more data.
Transform.prototype._read = function (n) {
  var ts = this._transformState;

  if (ts.writechunk !== null && ts.writecb && !ts.transforming) {
    ts.transforming = true;
    this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
  } else {
    // mark that we need a transform, so that any data that comes in
    // will get processed, now that we've asked for it.
    ts.needTransform = true;
  }
};

Transform.prototype._destroy = function (err, cb) {
  var _this = this;

  Duplex.prototype._destroy.call(this, err, function (err2) {
    cb(err2);
    _this.emit('close');
  });
};

function done(stream, er, data) {
  if (er) return stream.emit('error', er);

  if (data !== null && data !== undefined) stream.push(data);

  // if there's nothing in the write buffer, then that means
  // that nothing more will ever be provided
  var ws = stream._writableState;
  var ts = stream._transformState;

  if (ws.length) throw new Error('Calling transform done when ws.length != 0');

  if (ts.transforming) throw new Error('Calling transform done when still transforming');

  return stream.push(null);
}

/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(54);

__webpack_require__(173);

__webpack_require__(176);

__webpack_require__(191);

__webpack_require__(193);

/**
 * @fileoverview entry point for editor with all extension included
 * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */
var Editor = __webpack_require__(195);

module.exports = Editor;

/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.detectDelimiter = exports.parseDSV2ChartData = exports.parseCode2ChartOption = exports.parseURL2ChartData = exports.parseCode2DataAndOptions = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _tuiChart = __webpack_require__(55);

var _tuiChart2 = _interopRequireDefault(_tuiChart);

var _editorProxy = __webpack_require__(5);

var _editorProxy2 = _interopRequireDefault(_editorProxy);

var _csv = __webpack_require__(159);

var _csv2 = _interopRequireDefault(_csv);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               * @fileoverview tsv, csv format chart plugin
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               * consumes tab separated values and make data/options for tui chart
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               */

/**
 * @example
 * tsv, csv format chart plugin
 * consumes tab separated values and make data/options for tui-chart
 *
 * ```chart
 * \tcat1\tcat2           => tsv, csv format chart data
 * jan\t21\t23
 * feb\t351\t45
 *                          => space required as a separator
 * type: area               => tui.chart.areaChart()
 * url: http://url.to/csv   => fetch data from the url
 * width: 700               => chart.width
 * height: 300              => chart.height
 * title: Monthly Revenue   => chart.title
 * format: 1000             => chart.format
 * x.title: Amount          => xAxis.title
 * x.min: 0                 => xAxis.min
 * x.max 9000               => xAxis.max
 * x.suffix: $              => xAxis.suffix
 * y.title: Month           => yAxis.title
 * ```
 */


var WwCodeBlockManager = _editorProxy2.default.WwCodeBlockManager,
    codeBlockManager = _editorProxy2.default.codeBlockManager;

var LANG = 'chart';

// csv configuration
_csv2.default.IGNORE_QUOTE_WHITESPACE = false;
_csv2.default.IGNORE_RECORD_LENGTH = true;
_csv2.default.DETECT_TYPES = false;

var REGEX_LINE_ENDING = /[\n\r]/;
var DSV_DELIMITERS = [',', '\t', /\s+/];
var OPTION_DELIMITER = ':';
var SUPPORTED_CHART_TYPES = ['barChart', 'columnChart', 'lineChart', 'areaChart', 'pieChart'];
var CATEGORY_CHART_TYPES = ['lineChart', 'areaChart'];

/**
 * parse data and options for tui.chart
 * data format can be csv, tsv
 * options format is colon separated keys & values
 * @param {string} code - plain text format data & options
 * @param {Function} callback - callback which provides json format data & options
 * @ignore
 */
function parseCode2DataAndOptions(code, callback) {
  code = trimKeepingTabs(code);

  var _code$split = code.split(/\n{2,}/),
      firstCode = _code$split[0],
      secondCode = _code$split[1];

  // try to parse first code block as `options`


  var options = parseCode2ChartOption(firstCode);
  var url = options && options.editorChart && options.editorChart.url;

  // if first code block is `options` and has `url` option, fetch data from url
  var dataAndOptions = void 0;
  if (_tuiCodeSnippet2.default.isString(url)) {
    // url option provided
    // fetch data from url
    var success = function success(dataCode) {
      dataAndOptions = _parseCode2DataAndOptions(dataCode, firstCode);
      callback(dataAndOptions);
    };
    var fail = function fail() {
      return callback(null);
    };

    _jquery2.default.get(url).done(success).fail(fail);
  } else {
    // else first block is `data`
    dataAndOptions = _parseCode2DataAndOptions(firstCode, secondCode);
    callback(dataAndOptions);
  }
}

/**
 * parse codes to chart data & options Object
 * @param {string} dataCode - code block containing chart data
 * @param {string} optionCode - code block containing chart options
 * @returns {Object} - tui.chart data & options
 * @see https://nhnent.github.io/tui.chart/latest/tui.chart.html
 * @ignore
 */
function _parseCode2DataAndOptions(dataCode, optionCode) {
  var data = parseDSV2ChartData(dataCode);
  var options = parseCode2ChartOption(optionCode);

  return {
    data: data,
    options: options
  };
}

/**
 * detect delimiter the comma, tab, regex
 * @param {string} code - code to detect delimiter
 * @returns {string|RegExp} - detected delimiter
 * @ignore
 */
function detectDelimiter(code) {
  code = trimKeepingTabs(code);

  // chunk first max 10 lines to detect
  var chunk = code.split(REGEX_LINE_ENDING).slice(0, 10).join('\n');

  // calc delta for each delimiters
  // then pick a delimiter having the minimum value delta
  return DSV_DELIMITERS.map(function (delimiter) {
    return {
      delimiter: delimiter,
      delta: calcDSVDelta(chunk, delimiter)
    };
  }).sort(function (a, b) {
    return a.delta - b.delta;
  })[0].delimiter;
}

/**
 * calculate delta(sum of length difference of rows) values of given DSV
 * @param {string} code - code to be test
 * @param {string|RegExp} delimiter - delimiter to test
 * @returns {number} delta value for code
 * @ignore
 */
function calcDSVDelta(code, delimiter) {
  var rows = void 0,
      delta = void 0;

  try {
    _csv2.default.COLUMN_SEPARATOR = delimiter;
    rows = _csv2.default.parse(code);

    if (rows[0].length < 2) {
      // parsing completely failed
      throw new Error('parser fail');
    }

    // sum of all length difference of all rows
    delta = rows.map(function (row) {
      return row.length;
    }).reduce(function (a, b) {
      return {
        deltaSum: a.deltaSum + Math.abs(a.length - b),
        length: b
      };
    }, {
      deltaSum: 0,
      length: rows[0].length
    }).deltaSum;
  } catch (e) {
    delta = Infinity;
  }

  return delta;
}

/**
 * parse csv, tsv to chart data
 * @param {string} code - data code
 * @param {string|RegExp} delimiter - delimiter
 * @returns {Object} - tui.chart data
 * @see https://nhnent.github.io/tui.chart/latest/tui.chart.html
 * @ignore
 */
function parseDSV2ChartData(code, delimiter) {
  // trim all heading/trailing blank lines
  code = trimKeepingTabs(code);

  _csv2.default.COLUMN_SEPARATOR = delimiter || detectDelimiter(code);
  var dsv = _csv2.default.parse(code);

  // trim all values in 2D array
  dsv = dsv.map(function (arr) {
    return arr.map(function (val) {
      return val.trim();
    });
  });

  // test a first row for legends. ['anything', '1', '2', '3'] === false, ['anything', 't1', '2', 't3'] === true
  var hasLegends = dsv[0].filter(function (v, i) {
    return i > 0;
  }).reduce(function (hasNaN, item) {
    return hasNaN || !isNumeric(item);
  }, false);
  var legends = hasLegends ? dsv.shift() : [];

  // test a first column for categories
  var hasCategories = dsv.slice(1).reduce(function (hasNaN, row) {
    return hasNaN || !isNumeric(row[0]);
  }, false);
  var categories = hasCategories ? dsv.map(function (arr) {
    return arr.shift();
  }) : [];
  if (hasCategories) {
    legends.shift();
  }

  // transpose dsv, parse number
  // [['1','2','3']    [[1,4,7]
  //  ['4','5','6'] =>  [2,5,8]
  //  ['7','8','9']]    [3,6,9]]
  dsv = dsv[0].map(function (t, i) {
    return dsv.map(function (x) {
      return parseFloat(x[i]);
    });
  });

  // make series
  var series = dsv.map(function (data, i) {
    return hasLegends ? {
      name: legends[i],
      data: data
    } : {
      data: data
    };
  });

  return {
    categories: categories,
    series: series
  };
}

/**
 * parse code from url
 * @param {string} url - remote csv/tsv file url
 * @param {Function} callback - callback function
 * @ignore
 */
function parseURL2ChartData(url, callback) {
  var success = function success(code) {
    var chartData = parseDSV2ChartData(code);

    callback(chartData);
  };
  var fail = function fail() {
    return callback(null);
  };

  _jquery2.default.get(url).done(success).fail(fail);
}

/**
 * parse option code
 * @param {string} optionCode - option code
 * @returns {Object} - tui.chart option string
 * @see https://nhnent.github.io/tui.chart/latest/tui.chart.html
 * @ignore
 */
function parseCode2ChartOption(optionCode) {
  var reservedKeys = ['type', 'url'];
  var options = {};
  if (_tuiCodeSnippet2.default.isUndefined(optionCode)) {
    return options;
  }

  var optionLines = optionCode.split(REGEX_LINE_ENDING);
  optionLines.forEach(function (line) {
    var _line$split = line.split(OPTION_DELIMITER),
        keyString = _line$split[0],
        values = _line$split.slice(1);

    var value = values.join(OPTION_DELIMITER);
    keyString = keyString.trim();
    if (value.length === 0) {
      return;
    }

    try {
      value = JSON.parse(value.trim());
    } catch (e) {
      value = value.trim();
    }

    // parse keys

    var _keyString$split = keyString.split('.'),
        keys = _keyString$split.slice(0);

    var topKey = keys[0];
    if (_tuiCodeSnippet2.default.inArray(topKey, reservedKeys) >= 0) {
      // reserved keys for chart plugin option
      keys.unshift('editorChart');
    } else if (keys.length === 1) {
      // short names for `chart`
      keys.unshift('chart');
    } else if (topKey === 'x' || topKey === 'y') {
      // short-handed keys
      keys[0] = topKey + 'Axis';
    }

    var option = options;
    for (var i = 0; i < keys.length; i += 1) {
      var key = keys[i];
      option[key] = option[key] || (keys.length - 1 === i ? value : {});
      option = option[key];
    }
  });

  return options;
}

/**
 * trim whitespace and newlines at head/tail
 * it should not trim \t in tsv
 * @param {string} code - code to trim
 * @returns {string} - trimmed code
 * @ignore
 */
function trimKeepingTabs(code) {
  return code.replace(/(^(\s*[\n\r])+)|([\n\r]+\s*$)/g, '');
}

/**
 * test given string is numeric
 * @param {string} str - string to be tested
 * @returns {boolean} - true for numeric string
 * @ignore
 */
function isNumeric(str) {
  return !isNaN(str) && isFinite(str);
}

/**
 * set default options
 * @param {Object} options - tui.chart options
 * @param {HTMLElement} chartContainer - chart container
 * @returns {Object} - options
 * @see https://nhnent.github.io/tui.chart/latest/tui.chart.html
 * @ignore
 */
function setDefaultOptions(options, chartContainer) {
  options = _tuiCodeSnippet2.default.extend({
    editorChart: {},
    chart: {},
    chartExportMenu: {}
  }, options);

  var _options$chart = options.chart,
      width = _options$chart.width,
      height = _options$chart.height;

  var isWidthUndefined = _tuiCodeSnippet2.default.isUndefined(width);
  var isHeightUndefined = _tuiCodeSnippet2.default.isUndefined(height);
  if (isWidthUndefined || isHeightUndefined) {
    // if no width or height specified, set width and height to container width
    var _chartContainer$getBo = chartContainer.getBoundingClientRect(),
        containerWidth = _chartContainer$getBo.width;

    options.chart.width = isWidthUndefined ? containerWidth : width;
    options.chart.height = isHeightUndefined ? containerWidth : height;
  }

  options.editorChart.type = options.editorChart.type ? options.editorChart.type + 'Chart' : 'columnChart';
  options.chartExportMenu.visible = options.chartExportMenu.visible || false;

  return options;
}

/**
 * replace html from chart data
 * @param {string} codeBlockChartDataAndOptions - chart data text
 * @returns {string} - rendered html
 * @ignore
 */
function chartReplacer(codeBlockChartDataAndOptions) {
  var randomId = 'chart-' + Math.random().toString(36).substr(2, 10);
  var renderedHTML = '<div id="' + randomId + '" class="chart" />';

  setTimeout(function () {
    var chartContainer = document.querySelector('#' + randomId);
    try {
      parseCode2DataAndOptions(codeBlockChartDataAndOptions, function (_ref) {
        var data = _ref.data,
            options = _ref.options;

        options = setDefaultOptions(options, chartContainer);

        var chartType = options.editorChart.type;
        if (SUPPORTED_CHART_TYPES.indexOf(chartType) < 0) {
          chartContainer.innerHTML = 'invalid chart type. type: bar, column, line, area, pie';
        } else if (CATEGORY_CHART_TYPES.indexOf(chartType) > -1 && data.categories.length !== data.series[0].data.length) {
          chartContainer.innerHTML = 'invalid chart data';
        } else {
          _tuiChart2.default[chartType](chartContainer, data, options);
        }
      });
    } catch (e) {
      chartContainer.innerHTML = 'invalid chart data';
    }
  }, 0);

  return renderedHTML;
}

/**
 * reduce 2D array to TSV rows
 * @param {Array.<Array.<string>>} arr - 2d array
 * @returns {Array.<string>} - TSV row array
 * @ignore
 */
function _reduceToTSV(arr) {
  // 2D array => quoted TSV row array
  // [['a', 'b b'], [1, 2]] => ['a\t"b b"', '1\t2']
  return arr.reduce(function (acc, row) {
    // ['a', 'b b', 'c c'] => ['a', '"b b"', '"c c"']
    var quoted = row.map(function (text) {
      if (!isNumeric(text) && text.indexOf(' ') >= 0) {
        text = '"' + text + '"';
      }

      return text;
    });
    // ['a', '"b b"', '"c c"'] => 'a\t"b b"\t"c c"'
    acc.push(quoted.join('\t'));

    return acc;
  }, []);
}

/**
 * override WwCodeBlockManager to enclose pasting data strings from wysiwyg in quotes
 * @param {Editor} editor - editor
 * @ignore
 */
function _setWwCodeBlockManagerForChart(editor) {
  var componentManager = editor.wwEditor.componentManager;
  componentManager.removeManager('codeblock');
  componentManager.addManager(function (_WwCodeBlockManager) {
    _inherits(_class, _WwCodeBlockManager);

    function _class() {
      _classCallCheck(this, _class);

      return _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).apply(this, arguments));
    }

    _createClass(_class, [{
      key: 'convertToCodeblock',

      /**
       * Wrap table nodes into code block as TSV
       * @memberof WwCodeBlockManager
       * @param {Array.<Node>} nodes Node array
       * @returns {HTMLElement} Code block element
       */
      value: function convertToCodeblock(nodes) {
        if (nodes.length !== 1 || nodes[0].tagName !== 'TABLE') {
          return _get(_class.prototype.__proto__ || Object.getPrototypeOf(_class.prototype), 'convertToCodeblock', this).call(this, nodes);
        }

        var $codeblock = (0, _jquery2.default)('<pre />');
        var node = nodes.shift();

        // convert table to 2-dim array
        var cells = [].slice.call(node.rows).map(function (row) {
          return [].slice.call(row.cells).map(function (cell) {
            return cell.innerText.trim();
          });
        });

        var tsvRows = _reduceToTSV(cells);
        $codeblock.append(tsvRows.reduce(function (acc, row) {
          return acc + ('<div>' + row + '</div>');
        }, []));

        $codeblock.attr('data-te-codeblock', '');

        return $codeblock[0];
      }
    }]);

    return _class;
  }(WwCodeBlockManager));
}

/**
 * determine the event is from codeblock in markdown/codeblock editor
 * @param {CodeMirror} cm - markdown codemirror editor
 * @param {string} source - event source
 * @param {Object} eventData - event data
 * @returns {boolean} - true for the event from codeblock in markdown/codeblock editor
 * @ignore
 */
function _isFromCodeBlockInCodeMirror(cm, source, eventData) {
  // cursor in codeblock in markdown editor
  var fromCodeBlockInCodeMirror = source === 'markdown' && cm.getTokenAt(eventData.from).state.overlay.codeBlock;
  // or codeblock editor
  fromCodeBlockInCodeMirror = fromCodeBlockInCodeMirror || source === 'codeblock';
  // but not from wysiwyg
  fromCodeBlockInCodeMirror = fromCodeBlockInCodeMirror && source !== 'wysiwyg';

  return fromCodeBlockInCodeMirror;
}

/**
 * enclose pasting data strings from markdown in quotes
 * wysiwyg event should be treated separately.
 * because pasteBefore event from wysiwyg has been already processed table data to string,
 * on the other hand we need a table element
 * @param {CodeMirror} cm - markdown codemirror editor
 * @param {string} source - event source
 * @param {Object} data - event data
 * @ignore
 */
function _onMDPasteBefore(cm, _ref2) {
  var source = _ref2.source,
      eventData = _ref2.data;

  if (!_isFromCodeBlockInCodeMirror(cm, source, eventData)) {
    return;
  }

  var code = eventData.text.join('\n');
  var delta = calcDSVDelta(code, '\t');

  if (delta === 0) {
    _csv2.default.COLUMN_SEPARATOR = '\t';
    var parsed = _reduceToTSV(_csv2.default.parse(code));
    eventData.update(eventData.from, eventData.to, parsed);
  }
}

/**
 * chart plugin
 * @param {Editor} editor - editor
 * @ignore
 */
function chartExtension(editor) {
  var optionLanguages = editor.options.codeBlockLanguages;
  if (optionLanguages && optionLanguages.indexOf(LANG) < 0) {
    optionLanguages.push(LANG);
  }
  codeBlockManager.setReplacer(LANG, chartReplacer);

  if (!editor.isViewer()) {
    // treat wysiwyg paste event
    _setWwCodeBlockManagerForChart(editor);

    // treat markdown paste event
    editor.eventManager.listen('pasteBefore', function (ev) {
      return _onMDPasteBefore(editor.mdEditor.cm, ev);
    });
  }
}

_editorProxy2.default.defineExtension('chart', chartExtension);

exports.parseCode2DataAndOptions = parseCode2DataAndOptions;
exports.parseURL2ChartData = parseURL2ChartData;
exports.parseCode2ChartOption = parseCode2ChartOption;
exports.parseDSV2ChartData = parseDSV2ChartData;
exports.detectDelimiter = detectDelimiter;

/***/ }),
/* 55 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_55__;

/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _codeMirrorExt = __webpack_require__(29);

var _codeMirrorExt2 = _interopRequireDefault(_codeMirrorExt);

var _keyMapper = __webpack_require__(21);

var _keyMapper2 = _interopRequireDefault(_keyMapper);

var _mdListManager = __webpack_require__(63);

var _mdListManager2 = _interopRequireDefault(_mdListManager);

var _componentManager = __webpack_require__(30);

var _componentManager2 = _interopRequireDefault(_componentManager);

var _mdTextObject = __webpack_require__(64);

var _mdTextObject2 = _interopRequireDefault(_mdTextObject);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements markdown editor
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var keyMapper = _keyMapper2.default.getSharedInstance();

/**
 * Class MarkdownEditor
 */

var MarkdownEditor = function (_CodeMirrorExt) {
  _inherits(MarkdownEditor, _CodeMirrorExt);

  /**
   * Creates an instance of MarkdownEditor.
   * @param {jQuery} $el - container jquery element
   * @param {EventManager} eventManager - event manager
   * @memberof MarkdownEditor
   */
  function MarkdownEditor($el, eventManager) {
    _classCallCheck(this, MarkdownEditor);

    var _this = _possibleConstructorReturn(this, (MarkdownEditor.__proto__ || Object.getPrototypeOf(MarkdownEditor)).call(this, $el.get(0), {
      mode: 'gfm',
      dragDrop: true,
      allowDropFileTypes: ['image'],
      extraKeys: {
        'Enter': 'newlineAndIndentContinue',
        'Tab': 'subListIndentTab',
        'Shift-Tab': 'indentLessOrderedList'
      }
    }));

    _this.eventManager = eventManager;
    _this.componentManager = new _componentManager2.default(_this);
    _this.componentManager.addManager(_mdListManager2.default);

    /**
     * latest state info
     * @type {object}
     * @private
     */
    _this._latestState = null;

    _this._initEvent();
    return _this;
  }

  /**
   * _initEvent
   * Initialize EventManager event handler
   * @memberof MarkdownEditor
   * @private
   */


  _createClass(MarkdownEditor, [{
    key: '_initEvent',
    value: function _initEvent() {
      var _this2 = this;

      this.cm.getWrapperElement().addEventListener('click', function () {
        _this2.eventManager.emit('click', {
          source: 'markdown'
        });
      });

      this.cm.on('beforeChange', function (cm, ev) {
        if (ev.origin === 'paste') {
          _this2.eventManager.emit('pasteBefore', {
            source: 'markdown',
            data: ev
          });
        }
      });

      this.cm.on('change', function (cm, cmEvent) {
        _this2._emitMarkdownEditorContentChangedEvent();
        _this2._emitMarkdownEditorChangeEvent(cmEvent);
      });

      this.cm.on('focus', function () {
        _this2.eventManager.emit('focus', {
          source: 'markdown'
        });
        _this2.getEditor().refresh();
      });

      this.cm.on('blur', function () {
        _this2.eventManager.emit('blur', {
          source: 'markdown'
        });
      });

      this.cm.on('scroll', function (cm, eventData) {
        _this2.eventManager.emit('scroll', {
          source: 'markdown',
          data: eventData
        });
      });

      this.cm.on('keydown', function (cm, keyboardEvent) {
        _this2.eventManager.emit('keydown', {
          source: 'markdown',
          data: keyboardEvent
        });

        _this2.eventManager.emit('keyMap', {
          source: 'markdown',
          keyMap: keyMapper.convert(keyboardEvent),
          data: keyboardEvent
        });
      });

      this.cm.on('keyup', function (cm, keyboardEvent) {
        _this2.eventManager.emit('keyup', {
          source: 'markdown',
          data: keyboardEvent
        });
      });

      this.cm.on('copy', function (cm, ev) {
        _this2.eventManager.emit('copy', {
          source: 'markdown',
          data: ev
        });
      });

      this.cm.on('cut', function (cm, ev) {
        _this2.eventManager.emit('cut', {
          source: 'markdown',
          data: ev
        });
      });

      this.cm.on('paste', function (cm, clipboardEvent) {
        _this2.eventManager.emit('paste', {
          source: 'markdown',
          data: clipboardEvent
        });
      });

      this.cm.on('drop', function (cm, eventData) {
        eventData.preventDefault();

        _this2.eventManager.emit('drop', {
          source: 'markdown',
          data: eventData
        });
      });

      this.cm.on('cursorActivity', function () {
        var token = _this2.cm.getTokenAt(_this2.cm.getCursor());

        var _token$state = token.state,
            base = _token$state.base,
            overlay = _token$state.overlay;


        var state = {
          bold: !!base.strong,
          italic: !!base.em,
          strike: !!base.strikethrough,
          code: !!overlay.code,
          codeBlock: !!overlay.codeBlock,
          quote: !!base.quote,
          list: !!base.list,
          task: !!base.task,
          source: 'markdown'
        };

        if (!_this2._latestState || _this2._isStateChanged(_this2._latestState, state)) {
          _this2.eventManager.emit('stateChange', state);
          _this2._latestState = state;
        }
      });
    }

    /**
     * Set Editor value
     * @memberof MarkdownEditor
     * @override
     * @param {string} markdown - Markdown syntax text
     * @param {boolean} [cursorToEnd=true] - move cursor to contents end
     */

  }, {
    key: 'setValue',
    value: function setValue(markdown, cursorToEnd) {
      _get(MarkdownEditor.prototype.__proto__ || Object.getPrototypeOf(MarkdownEditor.prototype), 'setValue', this).call(this, markdown, cursorToEnd);
      this._emitMarkdownEditorContentChangedEvent();
    }

    /**
     * Get text object of current range
     * @memberof MarkdownEditor
     * @param {{start, end}} range Range object of each editor
     * @returns {object}
     */

  }, {
    key: 'getTextObject',
    value: function getTextObject(range) {
      return new _mdTextObject2.default(this, range);
    }

    /**
     * Emit contentChangedFromMarkdown event
     * @memberof MarkdownEditor
     * @private
     */

  }, {
    key: '_emitMarkdownEditorContentChangedEvent',
    value: function _emitMarkdownEditorContentChangedEvent() {
      this.eventManager.emit('contentChangedFromMarkdown', this);
    }

    /**
     * Emit changeEvent
     * @memberof MarkdownEditor
     * @param {event} e - Event object
     * @private
     */

  }, {
    key: '_emitMarkdownEditorChangeEvent',
    value: function _emitMarkdownEditorChangeEvent(e) {
      if (e.origin !== 'setValue') {
        var eventObj = {
          source: 'markdown'
        };

        this.eventManager.emit('changeFromMarkdown', eventObj);
        this.eventManager.emit('change', eventObj);
      }
    }

    /**
     * Return whether state changed or not
     * @memberof MarkdownEditor
     * @param {object} previousState - Previous state
     * @param {object} currentState - Current state
     * @returns {boolean} - changed state
     * @private
     */

  }, {
    key: '_isStateChanged',
    value: function _isStateChanged(previousState, currentState) {
      var result = false;

      _tuiCodeSnippet2.default.forEach(currentState, function (currentStateTypeValue, stateType) {
        result = previousState[stateType] !== currentStateTypeValue;

        return !result;
      });

      return result;
    }

    /**
     * MarkdownEditor factory method
     * @memberof MarkdownEditor
     * @param {jQuery} $el - Container element for editor
     * @param {EventManager} eventManager - EventManager instance
     * @returns {MarkdownEditor} - MarkdownEditor
     */

  }], [{
    key: 'factory',
    value: function factory($el, eventManager) {
      var mde = new MarkdownEditor($el, eventManager);

      return mde;
    }
  }]);

  return MarkdownEditor;
}(_codeMirrorExt2.default);

exports.default = MarkdownEditor;

/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _codemirror = __webpack_require__(10);

var _codemirror2 = _interopRequireDefault(_codemirror);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var listRE = /^(\s*)((\d+)([.)]\s(?:\[(?:x|\s)\]\s)?))(.*)/;

/**
 * simple wrapper for indentLess command
 * to run fixOrderedListNumber on Shift-Tab
 * @param {CodeMirror} cm - CodeMirror instance
 * @returns {CodeMirror.Pass|null} - next command
 * @ignore
 */
/**
* @fileoverview codemirror extension for fix ordered list number
* @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
*/

_codemirror2.default.commands.indentLessOrderedList = function (cm) {
  if (cm.getOption('disableInput')) {
    return _codemirror2.default.Pass;
  }
  cm.execCommand('indentLess');
  cm.execCommand('fixOrderedListNumber');

  return null;
};

/**
 * fix ordered list number
 * @param {CodeMirror} cm - CodeMirror instance
 * @returns {CodeMirror.Pass|null} - next command
 * @ignore
 */
_codemirror2.default.commands.fixOrderedListNumber = function (cm) {
  if (cm.getOption('disableInput')) {
    return _codemirror2.default.Pass;
  }

  var ranges = cm.listSelections();
  for (var i = 0; i < ranges.length; i += 1) {
    var pos = ranges[i].head;
    var lineNumber = findFirstListItem(pos.line, cm);

    if (lineNumber >= 0) {
      var lineText = cm.getLine(lineNumber);

      var _listRE$exec = listRE.exec(lineText),
          indent = _listRE$exec[1],
          index = _listRE$exec[3];

      fixNumber(lineNumber, indent.length, parseInt(index, 10), cm);
    }
  }

  return null;
};

/**
 * fix list numbers
 * @param {number} lineNumber - line number of list item to be normalized
 * @param {number} prevIndentLength - previous indent length
 * @param {number} startIndex - start index
 * @param {CodeMirror} cm - CodeMirror instance
 * @returns {number} - next line number
 * @ignore
 */
function fixNumber(lineNumber, prevIndentLength, startIndex, cm) {
  var indent = void 0,
      delimiter = void 0,
      text = void 0,
      indentLength = void 0;
  var index = startIndex;
  var lineText = cm.getLine(lineNumber);

  do {
    var _listRE$exec2 = listRE.exec(lineText);

    indent = _listRE$exec2[1];
    delimiter = _listRE$exec2[4];
    text = _listRE$exec2[5];

    indentLength = indent.length;

    if (indentLength === prevIndentLength) {
      // fix number
      cm.replaceRange('' + indent + index + delimiter + text, {
        line: lineNumber,
        ch: 0
      }, {
        line: lineNumber,
        ch: lineText.length
      });
      index += 1;
      lineNumber += 1;
    } else if (indentLength > prevIndentLength) {
      // nested list start
      lineNumber = fixNumber(lineNumber, indentLength, 1, cm);
    } else {
      // nested list end
      return lineNumber;
    }

    lineText = cm.getLine(lineNumber);
  } while (listRE.test(lineText));

  return lineNumber;
}

/**
 * find line number of list item which contains given lineNumber
 * @param {number} lineNumber - line number of list item
 * @param {CodeMirror} cm - CodeMirror instance
 * @returns {number} - line number of first list item
 * @ignore
 */
function findFirstListItem(lineNumber, cm) {
  var nextLineNumber = lineNumber;
  var lineText = cm.getLine(lineNumber);

  while (listRE.test(lineText)) {
    nextLineNumber -= 1;
    lineText = cm.getLine(nextLineNumber);
  }

  if (lineNumber === nextLineNumber) {
    nextLineNumber = -1;
  } else {
    nextLineNumber += 1;
  }

  return nextLineNumber;
}

/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _codemirror = __webpack_require__(10);

var _codemirror2 = _interopRequireDefault(_codemirror);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*eslint-disable */
_codemirror2.default.overlayMode = function (base, overlay, combine) {
  return {
    startState: function startState() {
      return {
        base: _codemirror2.default.startState(base),
        overlay: _codemirror2.default.startState(overlay),
        basePos: 0, baseCur: null,
        overlayPos: 0, overlayCur: null,
        streamSeen: null
      };
    },
    copyState: function copyState(state) {
      return {
        base: _codemirror2.default.copyState(base, state.base),
        overlay: _codemirror2.default.copyState(overlay, state.overlay),
        basePos: state.basePos, baseCur: null,
        overlayPos: state.overlayPos, overlayCur: null
      };
    },

    token: function token(stream, state) {
      if (stream != state.streamSeen || Math.min(state.basePos, state.overlayPos) < stream.start) {
        state.streamSeen = stream;
        state.basePos = state.overlayPos = stream.start;
      }

      if (stream.start == state.basePos) {
        state.baseCur = base.token(stream, state.base);
        state.basePos = stream.pos;
      }
      if (stream.start == state.overlayPos) {
        stream.pos = stream.start;
        state.overlayCur = overlay.token(stream, state.overlay);
        state.overlayPos = stream.pos;
      }
      stream.pos = Math.min(state.basePos, state.overlayPos);

      // state.overlay.combineTokens always takes precedence over combine,
      // unless set to null
      if (state.overlayCur == null) return state.baseCur;else if (state.baseCur != null && state.overlay.combineTokens || combine && state.overlay.combineTokens == null) return state.baseCur + " " + state.overlayCur;else return state.overlayCur;
    },

    indent: base.indent && function (state, textAfter) {
      return base.indent(state.base, textAfter);
    },
    electricChars: base.electricChars,

    innerMode: function innerMode(state) {
      return { state: state.base, mode: base };
    },

    blankLine: function blankLine(state) {
      if (base.blankLine) base.blankLine(state.base);
      if (overlay.blankLine) overlay.blankLine(state.overlay);
    }
  };
}; // CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: http://codemirror.net/LICENSE

// Utility function that allows modes to be combined. The mode given
// as the base argument takes care of most of the normal mode
// functionality, but a second (typically simple) mode is used, which
// can override the style of text. Both modes get to parse all of the
// text, but when both assign a non-null style to a piece of code, the
// overlay wins, unless the combine argument was true and not overridden,
// or state.overlay.combineTokens was true, in which case the styles are
// combined.
/**
 * @modifier NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */

/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _codemirror = __webpack_require__(10);

var _codemirror2 = _interopRequireDefault(_codemirror);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*eslint-disable */
"use strict"; // CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: http://codemirror.net/LICENSE
/**
 * @modifier NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */
// based on https://github.com/codemirror/CodeMirror/blob/ff04f127ba8a736b97d06c505fb85d976e3f2980/mode/markdown/markdown.js


_codemirror2.default.defineMode("markdown", function (cmCfg, modeCfg) {

  var htmlFound = _codemirror2.default.modes.hasOwnProperty("xml");
  var htmlMode = _codemirror2.default.getMode(cmCfg, htmlFound ? { name: "xml", htmlMode: true } : "text/plain");

  function getMode(name) {
    if (_codemirror2.default.findModeByName) {
      var found = _codemirror2.default.findModeByName(name);
      if (found) name = found.mime || found.mimes[0];
    }
    var mode = _codemirror2.default.getMode(cmCfg, name);
    return mode.name == "null" ? null : mode;
  }

  // Should characters that affect highlighting be highlighted separate?
  // Does not include characters that will be output (such as `1.` and `-` for lists)
  if (modeCfg.highlightFormatting === undefined) modeCfg.highlightFormatting = false;

  // Maximum number of nested blockquotes. Set to 0 for infinite nesting.
  // Excess `>` will emit `error` token.
  if (modeCfg.maxBlockquoteDepth === undefined) modeCfg.maxBlockquoteDepth = 0;

  // Should underscores in words open/close em/strong?
  if (modeCfg.underscoresBreakWords === undefined) modeCfg.underscoresBreakWords = true;

  // TUI.EDITOR MODIFICATION START
  // scrollSync prototype
  // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
  // Use `fencedCodeBlocks` to configure fenced code blocks. false to
  // disable, string to specify a precise regexp that the fence should
  // match, and true to allow three or more backticks or tildes (as
  // per CommonMark).
  // Turn on fenced code blocks? ("```" to start/end)
  // if (modeCfg.fencedCodeBlocks === undefined) modeCfg.fencedCodeBlocks = false;
  // TUI.EDITOR MODIFICATION END

  // Turn on task lists? ("- [ ] " and "- [x] ")
  if (modeCfg.taskLists === undefined) modeCfg.taskLists = false;

  // Turn on strikethrough syntax
  if (modeCfg.strikethrough === undefined) modeCfg.strikethrough = false;

  var codeDepth = 0;

  var header = 'header',
      code = 'comment',
      quote = 'quote',
      list1 = 'variable-2',
      list2 = 'variable-3',
      list3 = 'keyword',
      hr = 'hr',
      image = 'tag',
      formatting = 'formatting',
      linkinline = 'link',
      linkemail = 'link',
      linktext = 'link',
      linkhref = 'string',
      em = 'em',
      strong = 'strong',
      strikethrough = 'strikethrough';

  var hrRE = /^([*\-_])(?:\s*\1){2,}\s*$/,
      ulRE = /^[*\-+]\s+/,
      olRE = /^[0-9]+([.)])\s+/,
      taskListRE = /^\[(x| )\](?=\s)/ // Must follow ulRE or olRE
  // TUI.EDITOR MODIFICATION START
  // scrollSync prototype
  // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
  ,
      atxHeaderRE = modeCfg.allowAtxHeaderWithoutSpace ? /^(#+)/ : /^(#+)(?: |$)/,
      setextHeaderRE = /^ *(?:\={1,}|-{1,})\s*$/,
      textRE = /^[^#!\[\]*_\\<>` "'(~]+/,
      fencedCodeRE = new RegExp("^(" + (modeCfg.fencedCodeBlocks === true ? "~~~+|```+" : modeCfg.fencedCodeBlocks) + ")[ \\t]*([\\w+#]*)");
  // ,   atxHeaderRE = /^(#+)(?: |$)/
  // ,   setextHeaderRE = /^ *(?:\={1,}|-{1,})\s*$/
  // ,   textRE = /^[^#!\[\]*_\\<>` "'(~]+/;
  // TUI.EDITOR MODIFICATION END

  function switchInline(stream, state, f) {
    state.f = state.inline = f;
    return f(stream, state);
  }

  function switchBlock(stream, state, f) {
    state.f = state.block = f;
    return f(stream, state);
  }

  // TUI.EDITOR MODIFICATION START
  // scrollSync prototype
  // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
  function lineIsEmpty(line) {
    return !line || !/\S/.test(line.string);
  }
  // TUI.EDITOR MODIFICATION END

  // Blocks

  function blankLine(state) {
    // Reset linkTitle state
    state.linkTitle = false;
    // Reset EM state
    state.em = false;
    // Reset STRONG state
    state.strong = false;
    // Reset strikethrough state
    state.strikethrough = false;
    // Reset state.quote
    state.quote = 0;
    // Reset state.indentedCode
    state.indentedCode = false;
    if (!htmlFound && state.f == htmlBlock) {
      state.f = inlineNormal;
      state.block = blockNormal;
    }
    // Reset state.trailingSpace
    state.trailingSpace = 0;
    state.trailingSpaceNewLine = false;
    // TUI.EDITOR MODIFICATION START
    // scrollSync prototype
    // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
    // Mark this line as blank
    state.prevLine = state.thisLine;
    state.thisLine = null;
    // state.thisLineHasContent = false;
    // TUI.EDITOR MODIFICATION END
    return null;
  }

  function blockNormal(stream, state) {

    var sol = stream.sol();

    var prevLineIsList = state.list !== false,
        prevLineIsIndentedCode = state.indentedCode;

    state.indentedCode = false;

    if (prevLineIsList) {
      if (state.indentationDiff >= 0) {
        // Continued list
        if (state.indentationDiff < 4) {
          // Only adjust indentation if *not* a code block
          state.indentation -= state.indentationDiff;
        }
        state.list = null;
        // TUI.EDITOR MODIFICATION START
        // bug: no highlight in list
        // https://github.nhnent.com/fe/tui.editor/commit/d42c37639942633ccaf755c0c0d20f460c0b2441
        // https://github.nhnent.com/fe/tui.editor/issues/1002
      }
      if (state.indentation > 0) {
        state.list = null;
        // state.listDepth = Math.floor(state.indentation / 4) + 1;
        // } else if (state.indentation > 0) {
        //   state.list = null;
        state.listDepth = Math.floor(state.indentation / 4);
        // TUI.EDITOR MODIFICATION END
      } else {
        // No longer a list
        state.list = false;
        state.listDepth = 0;
      }
    }

    var match = null;
    if (state.indentationDiff >= 4) {
      stream.skipToEnd();
      // TUI.EDITOR MODIFICATION START
      // scrollSync prototype
      // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
      if (prevLineIsIndentedCode || lineIsEmpty(state.prevLine)) {
        // if (prevLineIsIndentedCode || !state.prevLineHasContent) {
        // TUI.EDITOR MODIFICATION END
        state.indentation -= 4;
        state.indentedCode = true;
        return code;
      } else {
        return null;
      }
    } else if (stream.eatSpace()) {
      return null;
    } else if ((match = stream.match(atxHeaderRE)) && match[1].length <= 6) {
      state.header = match[1].length;
      if (modeCfg.highlightFormatting) state.formatting = "header";
      state.f = state.inline;
      return getType(state);
      // TUI.EDITOR MODIFICATION START
      // scrollSync prototype
      // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
    } else if (!lineIsEmpty(state.prevLine) && !state.quote && !prevLineIsList && !prevLineIsIndentedCode && (match = stream.match(setextHeaderRE))) {
      // } else if (state.prevLineHasContent && !state.quote && !prevLineIsList && !prevLineIsIndentedCode && (match = stream.match(setextHeaderRE))) {
      // TUI.EDITOR MODIFICATION END
      state.header = match[0].charAt(0) == '=' ? 1 : 2;
      if (modeCfg.highlightFormatting) state.formatting = "header";
      state.f = state.inline;
      return getType(state);
    } else if (stream.eat('>')) {
      state.quote = sol ? 1 : state.quote + 1;
      if (modeCfg.highlightFormatting) state.formatting = "quote";
      stream.eatSpace();
      return getType(state);
    } else if (stream.peek() === '[') {
      return switchInline(stream, state, footnoteLink);
    } else if (stream.match(hrRE, true)) {
      state.hr = true;
      return hr;
      // TUI.EDITOR MODIFICATION START
      // scrollSync prototype
      // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
    } else if ((lineIsEmpty(state.prevLine) || prevLineIsList) && (stream.match(ulRE, false) || stream.match(olRE, false))) {
      // } else if ((!state.prevLineHasContent || prevLineIsList) && (stream.match(ulRE, false) || stream.match(olRE, false))) {
      // TUI.EDITOR MODIFICATION END
      var listType = null;
      if (stream.match(ulRE, true)) {
        listType = 'ul';
      } else {
        stream.match(olRE, true);
        listType = 'ol';
      }
      // TUI.EDITOR MODIFICATION START
      // scrollSync prototype
      // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
      // Roll back to original #1002
      // https://github.nhnent.com/fe/tui.editor/issues/1002
      // state.indentation = stream.column() + stream.current().length;
      state.indentation += 4;
      // TUI.EDITOR MODIFICATION END
      state.list = true;
      state.listDepth++;
      if (modeCfg.taskLists && stream.match(taskListRE, false)) {
        state.taskList = true;
        // TUI.EDITOR MODIFICATION START
        // Do not show table format pasting confirm on paste event where in Bloc... (#720)
        // https://github.nhnent.com/fe/tui.editor/commit/ed0b8b6c0cd5928a962e533f797e5bafcbfd6b33
        state.task = true; // to manage task state
        // TUI.EDITOR MODIFICATION END
      }
      state.f = state.inline;
      if (modeCfg.highlightFormatting) state.formatting = ["list", "list-" + listType];
      return getType(state);
      // TUI.EDITOR MODIFICATION START
      // scrollSync prototype
      // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
    } else if (modeCfg.fencedCodeBlocks && (match = stream.match(fencedCodeRE, true))) {
      state.fencedChars = match[1];
      // try switching mode
      state.localMode = getMode(match[2]);
      // } else if (modeCfg.fencedCodeBlocks && stream.match(/^```[ \t]*([\w+#]*)/, true)) {
      //   // try switching mode
      //   state.localMode = getMode(RegExp.$1);
      // TUI.EDITOR MODIFICATION END
      if (state.localMode) state.localState = state.localMode.startState();
      state.f = state.block = local;
      if (modeCfg.highlightFormatting) state.formatting = "code-block";
      state.code = true;
      return getType(state);
    }

    return switchInline(stream, state, state.inline);
  }

  function htmlBlock(stream, state) {
    var style = htmlMode.token(stream, state.htmlState);
    if (htmlFound && state.htmlState.tagStart === null && !state.htmlState.context && state.htmlState.tokenize.isInText || state.md_inside && stream.current().indexOf(">") > -1) {
      state.f = inlineNormal;
      state.block = blockNormal;
      state.htmlState = null;
    }
    return style;
  }

  function local(stream, state) {
    // TUI.EDITOR MODIFICATION START
    // scrollSync prototype
    // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
    if (stream.sol() && state.fencedChars && stream.match(state.fencedChars, false)) {
      // if (stream.sol() && stream.match("```", false)) {
      // TUI.EDITOR MODIFICATION END
      state.localMode = state.localState = null;
      state.f = state.block = leavingLocal;
      return null;
    } else if (state.localMode) {
      return state.localMode.token(stream, state.localState);
    } else {
      stream.skipToEnd();
      return code;
    }
  }

  function leavingLocal(stream, state) {
    // TUI.EDITOR MODIFICATION START
    // scrollSync prototype
    // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
    stream.match(state.fencedChars);
    state.block = blockNormal;
    state.f = inlineNormal;
    state.fencedChars = null;
    // stream.match("```");
    // state.block = blockNormal;
    // state.f = inlineNormal;
    // TUI.EDITOR MODIFICATION END
    if (modeCfg.highlightFormatting) state.formatting = "code-block";
    state.code = true;
    var returnType = getType(state);
    state.code = false;
    return returnType;
  }

  // Inline
  function getType(state) {
    var styles = [];

    if (state.formatting) {
      styles.push(formatting);

      if (typeof state.formatting === "string") state.formatting = [state.formatting];

      for (var i = 0; i < state.formatting.length; i++) {
        styles.push(formatting + "-" + state.formatting[i]);

        if (state.formatting[i] === "header") {
          styles.push(formatting + "-" + state.formatting[i] + "-" + state.header);
        }

        // Add `formatting-quote` and `formatting-quote-#` for blockquotes
        // Add `error` instead if the maximum blockquote nesting depth is passed
        if (state.formatting[i] === "quote") {
          if (!modeCfg.maxBlockquoteDepth || modeCfg.maxBlockquoteDepth >= state.quote) {
            styles.push(formatting + "-" + state.formatting[i] + "-" + state.quote);
          } else {
            styles.push("error");
          }
        }
      }
    }

    if (state.taskOpen) {
      styles.push("meta");
      return styles.length ? styles.join(' ') : null;
    }
    if (state.taskClosed) {
      styles.push("property");
      return styles.length ? styles.join(' ') : null;
    }

    if (state.linkHref) {
      styles.push(linkhref, "url");
    } else {
      // Only apply inline styles to non-url text
      if (state.strong) {
        styles.push(strong);
      }
      if (state.em) {
        styles.push(em);
      }
      if (state.strikethrough) {
        styles.push(strikethrough);
      }

      if (state.linkText) {
        styles.push(linktext);
      }

      if (state.code) {
        styles.push(code);
      }
    }

    if (state.header) {
      styles.push(header);styles.push(header + "-" + state.header);
    }

    if (state.quote) {
      styles.push(quote);

      // Add `quote-#` where the maximum for `#` is modeCfg.maxBlockquoteDepth
      if (!modeCfg.maxBlockquoteDepth || modeCfg.maxBlockquoteDepth >= state.quote) {
        styles.push(quote + "-" + state.quote);
      } else {
        styles.push(quote + "-" + modeCfg.maxBlockquoteDepth);
      }
    }

    if (state.list !== false) {
      var listMod = (state.listDepth - 1) % 3;
      if (!listMod) {
        styles.push(list1);
      } else if (listMod === 1) {
        styles.push(list2);
      } else {
        styles.push(list3);
      }
    }

    if (state.trailingSpaceNewLine) {
      styles.push("trailing-space-new-line");
    } else if (state.trailingSpace) {
      styles.push("trailing-space-" + (state.trailingSpace % 2 ? "a" : "b"));
    }

    return styles.length ? styles.join(' ') : null;
  }

  function handleText(stream, state) {
    if (stream.match(textRE, true)) {
      return getType(state);
    }
    return undefined;
  }

  function inlineNormal(stream, state) {
    var style = state.text(stream, state);
    if (typeof style !== 'undefined') return style;

    if (state.list) {
      // List marker (*, +, -, 1., etc)
      state.list = null;
      return getType(state);
    }

    if (state.taskList) {
      var taskOpen = stream.match(taskListRE, true)[1] !== "x";
      if (taskOpen) state.taskOpen = true;else state.taskClosed = true;
      if (modeCfg.highlightFormatting) state.formatting = "task";
      state.taskList = false;
      return getType(state);
    }

    state.taskOpen = false;
    state.taskClosed = false;

    if (state.header && stream.match(/^#+$/, true)) {
      if (modeCfg.highlightFormatting) state.formatting = "header";
      return getType(state);
    }

    // Get sol() value now, before character is consumed
    var sol = stream.sol();

    var ch = stream.next();

    if (ch === '\\') {
      stream.next();
      if (modeCfg.highlightFormatting) {
        var type = getType(state);
        return type ? type + " formatting-escape" : "formatting-escape";
      }
    }

    // Matches link titles present on next line
    if (state.linkTitle) {
      state.linkTitle = false;
      var matchCh = ch;
      if (ch === '(') {
        matchCh = ')';
      }
      matchCh = (matchCh + '').replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1");
      var regex = '^\\s*(?:[^' + matchCh + '\\\\]+|\\\\\\\\|\\\\.)' + matchCh;
      if (stream.match(new RegExp(regex), true)) {
        return linkhref;
      }
    }

    // If this block is changed, it may need to be updated in GFM mode
    if (ch === '`') {
      var previousFormatting = state.formatting;
      if (modeCfg.highlightFormatting) state.formatting = "code";
      var t = getType(state);
      var before = stream.pos;
      stream.eatWhile('`');
      var difference = 1 + stream.pos - before;
      if (!state.code) {
        codeDepth = difference;
        state.code = true;
        return getType(state);
      } else {
        if (difference === codeDepth) {
          // Must be exact
          state.code = false;
          return t;
        }
        state.formatting = previousFormatting;
        return getType(state);
      }
    } else if (state.code) {
      return getType(state);
    }

    if (ch === '!' && stream.match(/\[[^\]]*\] ?(?:\(|\[)/, false)) {
      stream.match(/\[[^\]]*\]/);
      // TUI.EDITOR MODIFICATION START
      // remove image syntax from highlight
      // https://github.nhnent.com/fe/tui.editor/commit/d2160b8c16f392372569dc2a22f12957afd7d9f2
      // hash string in image link is too long to highligh. exclude image from highlight
      // state.inline = state.f = linkHref;
      // TUI.EDITOR MODIFICATION END
      return image;
    }

    if (ch === '[' && stream.match(/.*\](\(.*\)| ?\[.*\])/, false)) {
      state.linkText = true;
      if (modeCfg.highlightFormatting) state.formatting = "link";
      return getType(state);
    }

    if (ch === ']' && state.linkText && stream.match(/\(.*\)| ?\[.*\]/, false)) {
      if (modeCfg.highlightFormatting) state.formatting = "link";
      var type = getType(state);
      state.linkText = false;
      state.inline = state.f = linkHref;
      return type;
    }

    if (ch === '<' && stream.match(/^(https?|ftps?):\/\/(?:[^\\>]|\\.)+>/, false)) {
      state.f = state.inline = linkInline;
      if (modeCfg.highlightFormatting) state.formatting = "link";
      var type = getType(state);
      if (type) {
        type += " ";
      } else {
        type = "";
      }
      return type + linkinline;
    }

    if (ch === '<' && stream.match(/^[^> \\]+@(?:[^\\>]|\\.)+>/, false)) {
      state.f = state.inline = linkInline;
      if (modeCfg.highlightFormatting) state.formatting = "link";
      var type = getType(state);
      if (type) {
        type += " ";
      } else {
        type = "";
      }
      return type + linkemail;
    }
    // TUI.EDITOR MODIFICATION START
    // codemirror markdown mode fix to prevent htmlBlock
    // https://github.nhnent.com/fe/tui.editor/commit/35910adb507646b6129fd4d349c65bbe28832211
    // we dont need html Block it ruin markdown blocks
    /*
        if (ch === '<' && stream.match(/^(!--|\w)/, false)) {
          var end = stream.string.indexOf(">", stream.pos);
          if (end != -1) {
            var atts = stream.string.substring(stream.start, end);
            if (/markdown\s*=\s*('|"){0,1}1('|"){0,1}/.test(atts)) state.md_inside = true;
          }
          stream.backUp(1);
          state.htmlState = CodeMirror.startState(htmlMode);
          return switchBlock(stream, state, htmlBlock);
        }
    
        if (ch === '<' && stream.match(/^\/\w*?>/)) {
          state.md_inside = false;
          return "tag";
        }
    */
    // TUI.EDITOR MODIFICATION END

    var ignoreUnderscore = false;
    if (!modeCfg.underscoresBreakWords) {
      if (ch === '_' && stream.peek() !== '_' && stream.match(/(\w)/, false)) {
        var prevPos = stream.pos - 2;
        if (prevPos >= 0) {
          var prevCh = stream.string.charAt(prevPos);
          if (prevCh !== '_' && prevCh.match(/(\w)/, false)) {
            ignoreUnderscore = true;
          }
        }
      }
    }
    if (ch === '*' || ch === '_' && !ignoreUnderscore) {
      if (sol && stream.peek() === ' ') {
        // Do nothing, surrounded by newline and space
      } else if (state.strong === ch && stream.eat(ch)) {
        // Remove STRONG
        if (modeCfg.highlightFormatting) state.formatting = "strong";
        var t = getType(state);
        state.strong = false;
        return t;
      } else if (!state.strong && stream.eat(ch)) {
        // Add STRONG
        state.strong = ch;
        if (modeCfg.highlightFormatting) state.formatting = "strong";
        return getType(state);
      } else if (state.em === ch) {
        // Remove EM
        if (modeCfg.highlightFormatting) state.formatting = "em";
        var t = getType(state);
        state.em = false;
        return t;
      } else if (!state.em) {
        // Add EM
        state.em = ch;
        if (modeCfg.highlightFormatting) state.formatting = "em";
        return getType(state);
      }
    } else if (ch === ' ') {
      if (stream.eat('*') || stream.eat('_')) {
        // Probably surrounded by spaces
        if (stream.peek() === ' ') {
          // Surrounded by spaces, ignore
          return getType(state);
        } else {
          // Not surrounded by spaces, back up pointer
          stream.backUp(1);
        }
      }
    }

    if (modeCfg.strikethrough) {
      if (ch === '~' && stream.eatWhile(ch)) {
        if (state.strikethrough) {
          // Remove strikethrough
          if (modeCfg.highlightFormatting) state.formatting = "strikethrough";
          var t = getType(state);
          state.strikethrough = false;
          return t;
        } else if (stream.match(/^[^\s]/, false)) {
          // Add strikethrough
          state.strikethrough = true;
          if (modeCfg.highlightFormatting) state.formatting = "strikethrough";
          return getType(state);
        }
      } else if (ch === ' ') {
        if (stream.match(/^~~/, true)) {
          // Probably surrounded by space
          if (stream.peek() === ' ') {
            // Surrounded by spaces, ignore
            return getType(state);
          } else {
            // Not surrounded by spaces, back up pointer
            stream.backUp(2);
          }
        }
      }
    }

    if (ch === ' ') {
      if (stream.match(/ +$/, false)) {
        state.trailingSpace++;
      } else if (state.trailingSpace) {
        state.trailingSpaceNewLine = true;
      }
    }

    return getType(state);
  }

  function linkInline(stream, state) {
    var ch = stream.next();

    if (ch === ">") {
      state.f = state.inline = inlineNormal;
      if (modeCfg.highlightFormatting) state.formatting = "link";
      var type = getType(state);
      if (type) {
        type += " ";
      } else {
        type = "";
      }
      return type + linkinline;
    }

    stream.match(/^[^>]+/, true);

    return linkinline;
  }

  function linkHref(stream, state) {
    // Check if space, and return NULL if so (to avoid marking the space)
    if (stream.eatSpace()) {
      return null;
    }
    var ch = stream.next();
    if (ch === '(' || ch === '[') {
      state.f = state.inline = getLinkHrefInside(ch === "(" ? ")" : "]");
      if (modeCfg.highlightFormatting) state.formatting = "link-string";
      state.linkHref = true;
      return getType(state);
    }
    return 'error';
  }

  function getLinkHrefInside(endChar) {
    return function (stream, state) {
      var ch = stream.next();

      if (ch === endChar) {
        state.f = state.inline = inlineNormal;
        if (modeCfg.highlightFormatting) state.formatting = "link-string";
        var returnState = getType(state);
        state.linkHref = false;
        return returnState;
      }

      if (stream.match(inlineRE(endChar), true)) {
        stream.backUp(1);
      }

      state.linkHref = true;
      return getType(state);
    };
  }

  function footnoteLink(stream, state) {
    if (stream.match(/^[^\]]*\]:/, false)) {
      state.f = footnoteLinkInside;
      stream.next(); // Consume [
      if (modeCfg.highlightFormatting) state.formatting = "link";
      state.linkText = true;
      return getType(state);
    }
    return switchInline(stream, state, inlineNormal);
  }

  function footnoteLinkInside(stream, state) {
    if (stream.match(/^\]:/, true)) {
      state.f = state.inline = footnoteUrl;
      if (modeCfg.highlightFormatting) state.formatting = "link";
      var returnType = getType(state);
      state.linkText = false;
      return returnType;
    }

    stream.match(/^[^\]]+/, true);

    return linktext;
  }

  function footnoteUrl(stream, state) {
    // Check if space, and return NULL if so (to avoid marking the space)
    if (stream.eatSpace()) {
      return null;
    }
    // Match URL
    stream.match(/^[^\s]+/, true);
    // Check for link title
    if (stream.peek() === undefined) {
      // End of line, set flag to check next line
      state.linkTitle = true;
    } else {
      // More content on line, check if link title
      stream.match(/^(?:\s+(?:"(?:[^"\\]|\\\\|\\.)+"|'(?:[^'\\]|\\\\|\\.)+'|\((?:[^)\\]|\\\\|\\.)+\)))?/, true);
    }
    state.f = state.inline = inlineNormal;
    return linkhref + " url";
  }

  var savedInlineRE = [];
  function inlineRE(endChar) {
    if (!savedInlineRE[endChar]) {
      // Escape endChar for RegExp (taken from http://stackoverflow.com/a/494122/526741)
      endChar = (endChar + '').replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1");
      // Match any non-endChar, escaped character, as well as the closing
      // endChar.
      savedInlineRE[endChar] = new RegExp('^(?:[^\\\\]|\\\\.)*?(' + endChar + ')');
    }
    return savedInlineRE[endChar];
  }

  var mode = {
    startState: function startState() {
      return {
        f: blockNormal,
        // TUI.EDITOR MODIFICATION START
        // scrollSync prototype
        // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
        prevLine: null,
        thisLine: null,
        // prevLineHasContent: false,
        // thisLineHasContent: false,
        // TUI.EDITOR MODIFICATION END

        block: blockNormal,
        htmlState: null,
        indentation: 0,

        inline: inlineNormal,
        text: handleText,

        formatting: false,
        linkText: false,
        linkHref: false,
        linkTitle: false,
        em: false,
        strong: false,
        header: 0,
        hr: false,
        // TUI.EDITOR MODIFICATION START
        // Do not show table format pasting confirm on paste event where in Bloc... (#720)
        // https://github.nhnent.com/fe/tui.editor/commit/ed0b8b6c0cd5928a962e533f797e5bafcbfd6b33
        task: false,
        // TUI.EDITOR MODIFICATION END
        taskList: false,
        list: false,
        listDepth: 0,
        quote: 0,
        trailingSpace: 0,
        trailingSpaceNewLine: false,
        strikethrough: false,
        // TUI.EDITOR MODIFICATION START
        // scrollSync prototype
        // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
        fencedChars: null
        // TUI.EDITOR MODIFICATION END
      };
    },

    copyState: function copyState(s) {
      return {
        f: s.f,

        // TUI.EDITOR MODIFICATION START
        // scrollSync prototype
        // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
        prevLine: s.prevLine,
        thisLine: s.this,
        // prevLineHasContent: s.prevLineHasContent,
        // thisLineHasContent: s.thisLineHasContent,
        // TUI.EDITOR MODIFICATION END

        block: s.block,
        htmlState: s.htmlState && _codemirror2.default.copyState(htmlMode, s.htmlState),
        indentation: s.indentation,

        localMode: s.localMode,
        localState: s.localMode ? _codemirror2.default.copyState(s.localMode, s.localState) : null,

        inline: s.inline,
        text: s.text,
        formatting: false,
        linkTitle: s.linkTitle,
        // TUI.EDITOR MODIFICATION START
        // scrollSync prototype
        // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
        code: s.code,
        // TUI.EDITOR MODIFICATION END
        em: s.em,
        strong: s.strong,
        strikethrough: s.strikethrough,
        header: s.header,
        hr: s.hr,
        taskList: s.taskList,
        // TUI.EDITOR MODIFICATION START
        // Do not show table format pasting confirm on paste event where in Bloc... (#720)
        // https://github.nhnent.com/fe/tui.editor/commit/ed0b8b6c0cd5928a962e533f797e5bafcbfd6b33
        task: s.task, // to manage task state
        // TUI.EDITOR MODIFICATION END
        list: s.list,
        listDepth: s.listDepth,
        quote: s.quote,
        indentedCode: s.indentedCode,
        trailingSpace: s.trailingSpace,
        trailingSpaceNewLine: s.trailingSpaceNewLine,
        md_inside: s.md_inside,
        // TUI.EDITOR MODIFICATION START
        // scrollSync prototype
        // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
        fencedChars: s.fencedChars
        // TUI.EDITOR MODIFICATION END
      };
    },

    token: function token(stream, state) {

      // Reset state.formatting
      state.formatting = false;

      // TUI.EDITOR MODIFICATION START
      // scrollSync prototype
      // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
      if (stream != state.thisLine) {
        var forceBlankLine = state.header || state.hr;
        // if (stream.sol()) {
        //   var forceBlankLine = !!state.header || state.hr;
        // TUI.EDITOR MODIFICATION END

        // Reset state.header and state.hr
        state.header = 0;
        state.hr = false;

        if (stream.match(/^\s*$/, true) || forceBlankLine) {
          // TUI.EDITOR MODIFICATION START
          // scrollSync prototype
          // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
          blankLine(state);
          if (!forceBlankLine) return null;
          state.prevLine = null;
        }

        state.prevLine = state.thisLine;
        state.thisLine = stream;
        //   state.prevLineHasContent = false;
        //   blankLine(state);
        //   return forceBlankLine ? this.token(stream, state) : null;
        // } else {
        //   state.prevLineHasContent = state.thisLineHasContent;
        //   state.thisLineHasContent = true;
        // }
        // TUI.EDITOR MODIFICATION END

        // Reset state.taskList
        state.taskList = false;
        // TUI.EDITOR MODIFICATION START
        // Do not show table format pasting confirm on paste event where in Bloc... (#720)
        // https://github.nhnent.com/fe/tui.editor/commit/ed0b8b6c0cd5928a962e533f797e5bafcbfd6b33
        state.task = false; // to manage task status
        // Reset state.code
        // state.code = false;
        // TUI.EDITOR MODIFICATION END

        // Reset state.trailingSpace
        state.trailingSpace = 0;
        state.trailingSpaceNewLine = false;

        state.f = state.block;
        var indentation = stream.match(/^\s*/, true)[0].replace(/\t/g, '    ').length;
        var difference = Math.floor((indentation - state.indentation) / 4) * 4;
        if (difference > 4) difference = 4;
        var adjustedIndentation = state.indentation + difference;
        state.indentationDiff = adjustedIndentation - state.indentation;
        state.indentation = adjustedIndentation;
        if (indentation > 0) return null;
      }
      return state.f(stream, state);
    },

    innerMode: function innerMode(state) {
      if (state.block == htmlBlock) return { state: state.htmlState, mode: htmlMode };
      if (state.localState) return { state: state.localState, mode: state.localMode };
      return { state: state, mode: mode };
    },

    blankLine: blankLine,

    getType: getType,
    // TUI.EDITOR MODIFICATION START
    // Exclude closing tags highlighting fixes #789 (#801)
    // https://github.nhnent.com/fe/tui.editor/commit/815b271cd426c6939413136a0532846a58cd36ab
    closeBrackets: "()[]{}''\"\"``",
    // TUI.EDITOR MODIFICATION END
    fold: "markdown"
  };
  return mode;
}, "xml");

_codemirror2.default.defineMIME("text/x-markdown", "markdown");

/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _codemirror = __webpack_require__(10);

var _codemirror2 = _interopRequireDefault(_codemirror);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*eslint-disable */
var urlRE = /^((?:(?:aaas?|about|acap|adiumxtra|af[ps]|aim|apt|attachment|aw|beshare|bitcoin|bolo|callto|cap|chrome(?:-extension)?|cid|coap|com-eventbrite-attendee|content|crid|cvs|data|dav|dict|dlna-(?:playcontainer|playsingle)|dns|doi|dtn|dvb|ed2k|facetime|feed|file|finger|fish|ftp|geo|gg|git|gizmoproject|go|gopher|gtalk|h323|hcp|https?|iax|icap|icon|im|imap|info|ipn|ipp|irc[6s]?|iris(?:\.beep|\.lwz|\.xpc|\.xpcs)?|itms|jar|javascript|jms|keyparc|lastfm|ldaps?|magnet|mailto|maps|market|message|mid|mms|ms-help|msnim|msrps?|mtqp|mumble|mupdate|mvn|news|nfs|nih?|nntp|notes|oid|opaquelocktoken|palm|paparazzi|platform|pop|pres|proxy|psyc|query|res(?:ource)?|rmi|rsync|rtmp|rtsp|secondlife|service|session|sftp|sgn|shttp|sieve|sips?|skype|sm[bs]|snmp|soap\.beeps?|soldat|spotify|ssh|steam|svn|tag|teamspeak|tel(?:net)?|tftp|things|thismessage|tip|tn3270|tv|udp|unreal|urn|ut2004|vemmi|ventrilo|view-source|webcal|wss?|wtai|wyciwyg|xcon(?:-userid)?|xfire|xmlrpc\.beeps?|xmpp|xri|ymsgr|z39\.50[rs]?):(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]|\([^\s()<>]*\))+(?:\([^\s()<>]*\)|[^\s`*!()\[\]{};:'".,<>?«»“”‘’]))/i; // CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: http://codemirror.net/LICENSE
/**
 * @modifier NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */


_codemirror2.default.defineMode("gfm", function (config, modeConfig) {
  var codeDepth = 0;
  function blankLine(state) {
    state.code = false;
    return null;
  }
  var gfmOverlay = {
    startState: function startState() {
      return {
        code: false,
        codeBlock: false,
        ateSpace: false
      };
    },
    copyState: function copyState(s) {
      return {
        code: s.code,
        codeBlock: s.codeBlock,
        ateSpace: s.ateSpace
      };
    },
    token: function token(stream, state) {
      state.combineTokens = null;

      // Hack to prevent formatting override inside code blocks (block and inline)
      if (state.codeBlock) {
        if (stream.match(/^```+/)) {
          state.codeBlock = false;
          return null;
        }
        stream.skipToEnd();
        return null;
      }
      if (stream.sol()) {
        state.code = false;
      }
      if (stream.sol() && stream.match(/^```+/)) {
        stream.skipToEnd();
        state.codeBlock = true;
        return null;
      }
      // If this block is changed, it may need to be updated in Markdown mode
      if (stream.peek() === '`') {
        stream.next();
        var before = stream.pos;
        stream.eatWhile('`');
        var difference = 1 + stream.pos - before;
        if (!state.code) {
          codeDepth = difference;
          state.code = true;
        } else {
          if (difference === codeDepth) {
            // Must be exact
            state.code = false;
          }
        }
        return null;
      } else if (state.code) {
        stream.next();
        return null;
      }
      // Check if space. If so, links can be formatted later on
      if (stream.eatSpace()) {
        state.ateSpace = true;
        return null;
      }
      if (stream.sol() || state.ateSpace) {
        state.ateSpace = false;
        /*
        //we dont need this
        if (modeConfig.gitHubSpice !== false) {
          if(stream.match(/^(?:[a-zA-Z0-9\-_]+\/)?(?:[a-zA-Z0-9\-_]+@)?(?:[a-f0-9]{7,40}\b)/)) {
            // User/Project@SHA
            // User@SHA
            // SHA
            state.combineTokens = true;
            return "link";
          } else if (stream.match(/^(?:[a-zA-Z0-9\-_]+\/)?(?:[a-zA-Z0-9\-_]+)?#[0-9]+\b/)) {
            // User/Project#Num
            // User#Num
            // #Num
            state.combineTokens = true;
            return "link";
          }
        }
        }
        if (stream.match(urlRE) &&
          stream.string.slice(stream.start - 2, stream.start) != "](" &&
          (stream.start == 0 || /\W/.test(stream.string.charAt(stream.start - 1)))) {
        // URLs
        // Taken from http://daringfireball.net/2010/07/improved_regex_for_matching_urls
        // And then (issue #1160) simplified to make it not crash the Chrome Regexp engine
        // And then limited url schemes to the CommonMark list, so foo:bar isn't matched as a URL
        state.combineTokens = true;
        return "link";
        */
      }
      stream.next();
      return null;
    },
    blankLine: blankLine
  };

  var markdownConfig = {
    underscoresBreakWords: false,
    taskLists: true,
    fencedCodeBlocks: '```',
    strikethrough: true
  };
  for (var attr in modeConfig) {
    markdownConfig[attr] = modeConfig[attr];
  }
  markdownConfig.name = "markdown";
  return _codemirror2.default.overlayMode(_codemirror2.default.getMode(config, markdownConfig), gfmOverlay);
}, "markdown");

_codemirror2.default.defineMIME("text/x-gfm", "gfm");

/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _codemirror = __webpack_require__(10);

var _codemirror2 = _interopRequireDefault(_codemirror);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*eslint-disable */
var listRE = /^(\s*)(>[> ]*|[*+-]\s(?:\[(?:x|\s)\]\s)?|(\d+)([.)]\s(?:\[(?:x|\s)\]\s)?))(\s*)/,
    emptyListRE = /^(\s*)(>[> ]*|[*+-]\s(?:\[(?:x|\s)\]\s)?|(\d+)([.)]\s(?:\[(?:x|\s)\]\s)?))(\s*)$/,
    FIND_CODEBLOCK_START_RX = /^ *(`{3,}|~{3,})[ \.]*\S+ */,
    unorderedListRE = /[*+-]\s/; // CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: http://codemirror.net/LICENSE
/**
 * @modifier NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */


_codemirror2.default.commands.subListIndentTab = function (cm) {
    if (cm.getOption("disableInput")) return _codemirror2.default.Pass;
    var ranges = cm.listSelections();
    for (var i = 0; i < ranges.length; i++) {
        var pos = ranges[i].head;
        var line = cm.getLine(pos.line);
        var cursorBeforeTextInline = line.substr(0, pos.ch);

        if (listRE.test(cursorBeforeTextInline)) {
            cm.replaceRange(Array(cm.getOption("indentUnit") + 1).join(" ") + line, {
                line: pos.line, ch: 0
            }, {
                line: pos.line, ch: line.length
            }, '+input');
            cm.setCursor(pos.line, pos.ch + 4);
        } else {
            if (cm.somethingSelected()) cm.indentSelection("add");else cm.execCommand("insertSoftTab");
        }
    }
    // TUI.EDITOR MODIFICATION START
    // 
    // https://github.nhnent.com/fe/tui.editor/commit/f63d6ae79078923d369e6c170d07485f05c42fd7
    cm.execCommand('fixOrderedListNumber');
    /// TUI.EDITOR MODIFICATION END
};

_codemirror2.default.commands.newlineAndIndentContinue = function (cm) {
    if (cm.getOption("disableInput")) return _codemirror2.default.Pass;
    var ranges = cm.listSelections(),
        replacements = [];

    for (var i = 0; i < ranges.length; i++) {
        var pos = ranges[i].head;
        var eolState = cm.getStateAfter(pos.line);
        var inList = eolState.base.list !== false;
        var inQuote = eolState.base.quote !== 0;

        var line = cm.getLine(pos.line);
        var isCodeBlockStart = FIND_CODEBLOCK_START_RX.test(line);
        var match = listRE.exec(line);
        var cursor = cm.getCursor();

        if (!ranges[i].empty() || !inList && !inQuote && !isCodeBlockStart || !match && !isCodeBlockStart) {
            cm.execCommand("newlineAndIndent");
            return;
        }

        if (isCodeBlockStart) {
            cursor = cm.getCursor();

            if (cursor.line !== pos.line || cursor.ch !== line.length) {
                cm.execCommand("newlineAndIndent");
                return;
            }
        }

        if (emptyListRE.test(line) && cursor.ch > 0) {
            cm.replaceRange("", {
                line: pos.line, ch: 0
            }, {
                line: pos.line, ch: line.length
            });
            replacements[i] = "\n";
        } else if (isCodeBlockStart) {
            replacements[i] = '\n\n```';
        } else {
            var indent = match[1],
                after = match[5],
                bullet;
            if (indent.length === pos.ch) {
                bullet = "";
            } else if (unorderedListRE.test(match[2]) || match[2].indexOf(">") >= 0) {
                bullet = match[2];
            } else {
                bullet = parseInt(match[3], 10) + 1 + match[4];
            }
            replacements[i] = "\n" + indent + bullet + after;
        }
    }

    cm.replaceSelections(replacements);

    if (isCodeBlockStart) {
        cm.setCursor(pos.line + 1, 0);
    }
};

/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _codemirror = __webpack_require__(10);

var _codemirror2 = _interopRequireDefault(_codemirror);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*eslint-disable */
_codemirror2.default.commands.replaceLineTextToUpper = function (cm) {
    if (cm.getOption("disableInput")) {
        return _codemirror2.default.Pass;
    }

    var ranges = cm.listSelections();
    var lineAdjustment = -1;

    for (var i = 0; i < ranges.length; i++) {
        var range = ranges[i];
        var from = range.anchor;
        var to = range.head;

        if (isSameLineSelection(range) && to.line > 0) {
            replaceSingleLine(cm, from, to, lineAdjustment);
        } else if (!isRangeCollapsed(range)) {
            var topLine = from.line < to.line ? from.line : to.line;

            if (topLine > 0) {
                var upper = from.line === topLine ? from : to;
                var bottom = from.line === topLine ? to : from;
                replaceMultiLine(cm, upper, bottom, lineAdjustment);
            }
        }
    }
}; // CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: http://codemirror.net/LICENSE
/**
 * @modifier NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */


_codemirror2.default.commands.replaceLineTextToLower = function (cm) {
    if (cm.getOption("disableInput")) {
        return _codemirror2.default.Pass;
    }

    var ranges = cm.listSelections();
    var lineAdjustment = 1;

    for (var i = 0; i < ranges.length; i++) {
        var range = ranges[i];
        var from = range.anchor;
        var to = range.head;
        var isLastLine = to.line === cm.lastLine();

        if (isSameLineSelection(range) && !isLastLine) {
            replaceSingleLine(cm, from, to, lineAdjustment);
        } else if (!isRangeCollapsed(range)) {
            var topLine = from.line < to.line ? from.line : to.line;
            var upper = from.line === topLine ? from : to;
            var bottom = from.line === topLine ? to : from;

            if (bottom.line < cm.lastLine()) {
                replaceMultiLine(cm, upper, bottom, lineAdjustment);
            }
        }
    }
};

function isRangeCollapsed(range) {
    return isSameLineSelection(range) && range.anchor.ch === range.head.ch;
}

function isSameLineSelection(range) {
    return range.anchor.line === range.head.line;
}

function replaceSingleLine(cm, from, to, lineAdjustment) {
    var currentLine = cm.getLine(to.line);
    var replacement = cm.getLine(to.line + lineAdjustment);
    var range = {
        anchor: from,
        head: to
    };

    cm.replaceRange(replacement, {
        line: to.line, ch: 0
    }, {
        line: to.line, ch: currentLine.length
    }, '+input');

    cm.replaceRange(currentLine, {
        line: to.line + lineAdjustment, ch: 0
    }, {
        line: to.line + lineAdjustment, ch: replacement.length
    }, '+input');

    if (isRangeCollapsed(range)) {
        cm.setCursor({
            line: to.line + lineAdjustment,
            ch: to.ch
        });
    } else {
        cm.setSelection({
            line: from.line + lineAdjustment,
            ch: from.ch
        }, {
            line: to.line + lineAdjustment,
            ch: to.ch
        });
    }
}

function replaceMultiLine(cm, upper, bottom, lineAdjustment) {
    var rangeContent = cm.getRange({
        line: upper.line, ch: 0
    }, {
        line: bottom.line, ch: cm.getLine(bottom.line).length
    });
    var edgeLineOfConcern = lineAdjustment > 0 ? bottom : upper;
    var replacement = cm.getLine(edgeLineOfConcern.line + lineAdjustment);
    var targetLine = void 0;

    if (lineAdjustment > 0) {
        targetLine = upper;
    } else {
        targetLine = bottom;
    }

    cm.replaceRange(replacement, {
        line: targetLine.line, ch: 0
    }, {
        line: targetLine.line, ch: cm.getLine(targetLine.line).length
    }, '+input');

    cm.replaceRange(rangeContent, {
        line: upper.line + lineAdjustment, ch: 0
    }, {
        line: bottom.line + lineAdjustment, ch: cm.getLine(bottom.line + lineAdjustment).length
    }, '+input');

    cm.setSelection({
        line: upper.line + lineAdjustment, ch: upper.ch
    }, {
        line: bottom.line + lineAdjustment, ch: bottom.ch
    });
}

/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @fileoverview Implements markdown list manager
 * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */
var FIND_MD_OL_RX = /^[ \t]*[\d]+\. .*/;
var FIND_MD_UL_RX = /^[ \t]*[-*] .*/;
var FIND_MD_TASK_RX = /^[ \t]*[-*]( \[[ xX]])? .*/;
var FIND_TABLE_RX = /^\|([-\s\w\d\t<>?!@#$%^&*()_=+\\/'";: \r[\]]*\|+)+/i;
var FIND_HEADING_RX = /^#+\s/;
var FIND_BLOCK_RX = /^ {0,3}(```|\||>)/;

/**
 * Class MdListManager
 */

var MdListManager = function () {
  /**
   * Creates an instance of MdListManager.
   * @param {MarkdownEditor} mde - MarkdownEditor instance
   * @memberof MdListManager
   */
  function MdListManager(mde) {
    _classCallCheck(this, MdListManager);

    this.mde = mde;
    this.eventManager = mde.eventManager;

    /**
     * Name property
     * @memberof MdListManager#
     * @type {string}
     */
    this.name = 'list';
  }

  /**
   * Return whether passed line is list or paragraph or not
   * @param {string} line line text
   * @returns {boolean}
   */


  _createClass(MdListManager, [{
    key: 'isListOrParagraph',
    value: function isListOrParagraph(line) {
      return !FIND_BLOCK_RX.test(line) && !FIND_TABLE_RX.test(line) && !FIND_HEADING_RX.test(line);
    }

    /**
     * Append blank line at list top or bottom if needed
     * @param {CodeMirror} cm CodeMirror instance
     * @param {number} index index number
     * @param {number} endLineNumber end line index number
     * @param {number} startLineNumber start line index number
     */

  }, {
    key: 'appendBlankLineIfNeed',
    value: function appendBlankLineIfNeed(cm, index, endLineNumber, startLineNumber) {
      var doc = cm.getDoc();
      var cursorPositionFactor = 0;
      var isMultiLineSelection = startLineNumber !== endLineNumber;
      var nextLineOfLastIndex = doc.getLine(this._getEndLineNumberOfList(doc, endLineNumber) + 1);
      var previousLineOfFirstIndex = doc.getLine(this._getStartLineNumberOfList(doc, startLineNumber) - 1);

      var nextLine = doc.getLine(index + 1);
      if (isMultiLineSelection && this._isNeedAppendBlankLine(nextLineOfLastIndex) || !isMultiLineSelection && this._isNeedAppendBlankLine(nextLine)) {
        doc.replaceRange('\n', {
          line: index,
          ch: doc.getLine(index).length
        });
      }

      var previousLine = doc.getLine(index - 1);
      if (isMultiLineSelection && this._isNeedAppendBlankLine(previousLineOfFirstIndex) || !isMultiLineSelection && this._isNeedAppendBlankLine(previousLine)) {
        doc.replaceRange('\n', {
          line: startLineNumber,
          ch: 0
        });
        cursorPositionFactor += 1;
      }
      if (!isMultiLineSelection) {
        var currentLineNumber = index + cursorPositionFactor;
        cm.setCursor(currentLineNumber, doc.getLine(currentLineNumber).length);
      }
    }

    /**
     * Return whether need to append blank line or not
     * @param {string} line Line text
     * @returns {boolean}
     * @private
     */

  }, {
    key: '_isNeedAppendBlankLine',
    value: function _isNeedAppendBlankLine(line) {
      return line && line.length !== 0 && !this._isAList(line);
    }

    /**
     * Sort line number of selection descending
     * @param {{from, to}} range start, end CodeMirror range information
     * @returns {{start: {number}, end: {number}}}
     */

  }, {
    key: 'createSortedLineRange',
    value: function createSortedLineRange(range) {
      var isReversed = range.from.line > range.to.line;
      var rangeStart = {
        line: isReversed ? range.to.line : range.from.line,
        ch: 0
      };
      var rangeEnd = {
        line: isReversed ? range.from.line : range.to.line,
        ch: 0
      };

      return {
        start: rangeStart.line,
        end: rangeEnd.line
      };
    }

    /**
     * Expand line range if need
     * @param {object} doc doc instance
     * @param {{from, to}} range CodeMirror range information
     * @param {function} comparator comparator function
     * @returns {{start: number, end: number}}
     */

  }, {
    key: 'expandLineRangeIfNeed',
    value: function expandLineRangeIfNeed(doc, range, comparator) {
      var lineRange = this.createSortedLineRange(range);
      var start = lineRange.start,
          end = lineRange.end;


      var isRangeStartInUlOrTask = this._isDifferentListType(comparator, doc.getLine(start));
      var isRangeEndInUlOrTask = this._isDifferentListType(comparator, doc.getLine(end));

      if (isRangeStartInUlOrTask) {
        start = this._getStartLineNumberOfList(doc, start);
      }

      if (isRangeEndInUlOrTask) {
        end = this._getEndLineNumberOfList(doc, end);
      }

      return {
        start: start,
        end: end
      };
    }

    /**
     * Replace list syntax
     * @param {object} doc CodeMirror doc instance
     * @param {number} lineNumber Line number
     * @param {RegExp} regexp Regexp for find list syntax
     * @param {string} replacePattern Replacement string
     */

  }, {
    key: 'replaceLineText',
    value: function replaceLineText(doc, lineNumber, regexp, replacePattern) {
      var line = doc.getLine(lineNumber);
      var currentLineStart = {
        line: lineNumber,
        ch: 0
      };
      var currentLineEnd = {
        line: lineNumber,
        ch: line.length
      };

      line = line.replace(regexp, replacePattern);

      doc.replaceRange(line, currentLineStart, currentLineEnd);
    }

    /**
     * Return whether is a different list type or not
     * @param {function} comparator comparator function
     * @param {string} line line string
     * @returns {boolean}
     * @private
     */

  }, {
    key: '_isDifferentListType',
    value: function _isDifferentListType(comparator, line) {
      return line && line.length !== 0 && comparator.call(this, line);
    }

    /**
     * Return whether is a list or not
     * @param {string} line line string
     * @returns {boolean}
     * @private
     */

  }, {
    key: '_isAList',
    value: function _isAList(line) {
      return line && line.length !== 0 && this._isListLine(line);
    }

    /**
     * Return whether passed line is list or not
     * @param {string} line Line text
     * @returns {Boolean}
     * @private
     */

  }, {
    key: '_isListLine',
    value: function _isListLine(line) {
      return !!(line.match(FIND_MD_TASK_RX) || line.match(FIND_MD_UL_RX) || line.match(FIND_MD_OL_RX));
    }

    /**
     * Get start line number of current list
     * @param {object} doc CodeMirror doc instance
     * @param {number} startLineNumber start line number of selection
     * @returns {number|undefined}
     * @private
     */

  }, {
    key: '_getStartLineNumberOfList',
    value: function _getStartLineNumberOfList(doc, startLineNumber) {
      var lineNumber = void 0;

      for (lineNumber = startLineNumber; lineNumber > 0; lineNumber -= 1) {
        var previousLine = doc.getLine(lineNumber - 1);
        if (!previousLine || !this._isListLine(previousLine)) {
          break;
        }
      }

      return lineNumber;
    }

    /**
     * Get end line number of current list
     * @param {object} doc CodeMirror doc instance
     * @param {number} endLineNumber end line number of selection
     * @returns {number|undefined}
     * @private
     */

  }, {
    key: '_getEndLineNumberOfList',
    value: function _getEndLineNumberOfList(doc, endLineNumber) {
      var lineCount = doc.lineCount();
      var lineNumber = void 0;

      for (lineNumber = endLineNumber; lineNumber < lineCount; lineNumber += 1) {
        var nextLine = doc.getLine(lineNumber + 1);
        if (!nextLine || !this._isListLine(nextLine)) {
          break;
        }
      }

      return lineNumber;
    }
  }]);

  return MdListManager;
}();

exports.default = MdListManager;

/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @fileoverview Implements markdown textObject
 * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */

/**
 * Class Markdown textObject
 */
var mdTextObject = function () {
  /**
   * Creates an instance of mdTextObject.
   * @param {MarkdownEditor} mde - MarkdownEditor instance
   * @param {object} range - range
   * @memberof mdTextObject
   */
  function mdTextObject(mde, range) {
    _classCallCheck(this, mdTextObject);

    this._mde = mde;

    this.setRange(range || mde.getRange());
  }

  /**
   * Set start
   * @memberof mdTextObject
   * @param {object} rangeStart Start of range
   * @private
   */


  _createClass(mdTextObject, [{
    key: '_setStart',
    value: function _setStart(rangeStart) {
      this._start = rangeStart;
    }

    /**
     * Set end
     * @private
     * @memberof mdTextObject
     * @param {object} rangeEnd End of range
     * @private
     */

  }, {
    key: '_setEnd',
    value: function _setEnd(rangeEnd) {
      this._end = rangeEnd;
    }

    /**
     * Set range to given range
     * @private
     * @memberof mdTextObject
     * @param {object} range Range object
     */

  }, {
    key: 'setRange',
    value: function setRange(range) {
      this._setStart(range.start);
      this._setEnd(range.end);
    }

    /**
     * Set start to end
     * @private
     * @memberof mdTextObject
     * @param {object} range Range object
     */

  }, {
    key: 'setEndBeforeRange',
    value: function setEndBeforeRange(range) {
      this._setEnd(range.start);
    }

    /**
     * Expand startOffset by 1
     * @private
     * @memberof mdTextObject
     */

  }, {
    key: 'expandStartOffset',
    value: function expandStartOffset() {
      var start = this._start;

      if (start.ch !== 0) {
        start.ch -= 1;
      }
    }

    /**
     * Expand endOffset by 1
     * @private
     * @memberof mdTextObject
     */

  }, {
    key: 'expandEndOffset',
    value: function expandEndOffset() {
      var end = this._end;

      if (end.ch < this._mde.getEditor().getDoc().getLine(end.line).length) {
        end.ch += 1;
      }
    }

    /**
     * Get current selection's text content
     * @private
     * @memberof mdTextObject
     * @returns {{start: {line: number, ch: number}, end: {line: number, ch: number}}}
     */

  }, {
    key: 'getTextContent',
    value: function getTextContent() {
      return this._mde.getEditor().getRange(this._start, this._end);
    }

    /**
     * Replace current selection's content with given text content
     * @private
     * @memberof mdTextObject
     * @param {string} content Replacement content
     */

  }, {
    key: 'replaceContent',
    value: function replaceContent(content) {
      this._mde.getEditor().replaceRange(content, this._start, this._end, '+input');
    }

    /**
     * Delete current selection's content
     * @private
     * @memberof mdTextObject
     */

  }, {
    key: 'deleteContent',
    value: function deleteContent() {
      this._mde.getEditor().replaceRange('', this._start, this._end, '+delete');
    }

    /**
     * peek StartBeforeOffset
     * @private
     * @memberof mdTextObject
     * @param {number} offset Offset
     * @returns {{start: {line: number, ch: number}, end: {line: number, ch: number}}}
     */

  }, {
    key: 'peekStartBeforeOffset',
    value: function peekStartBeforeOffset(offset) {
      var peekStart = {
        line: this._start.line,
        ch: Math.max(this._start.ch - offset, 0)
      };

      return this._mde.getEditor().getRange(peekStart, this._start);
    }
  }]);

  return mdTextObject;
}();

exports.default = mdTextObject;

/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements LazyRunner
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Class LazyRunner
 */
var LazyRunner = function () {
  /**
   * Creates an instance of LazyRunner.
   * @memberof LazyRunner
   */
  function LazyRunner() {
    _classCallCheck(this, LazyRunner);

    this.globalTOID = null;
    this.lazyRunFunctions = {};
  }

  _createClass(LazyRunner, [{
    key: 'run',
    value: function run(fn, params, context, delay) {
      var TOID = void 0;

      if (_tuiCodeSnippet2.default.isString(fn)) {
        TOID = this._runRegisteredRun(fn, params, context, delay);
      } else {
        TOID = this._runSingleRun(fn, params, context, delay, this.globalTOID);
        this.globalTOID = TOID;
      }

      return TOID;
    }
  }, {
    key: 'registerLazyRunFunction',
    value: function registerLazyRunFunction(name, fn, delay, context) {
      context = context || this;

      this.lazyRunFunctions[name] = {
        fn: fn,
        delay: delay,
        context: context,
        TOID: null
      };
    }
  }, {
    key: '_runSingleRun',
    value: function _runSingleRun(fn, params, context, delay, TOID) {
      this._clearTOIDIfNeed(TOID);

      TOID = setTimeout(function () {
        fn.call(context, params);
      }, delay);

      return TOID;
    }
  }, {
    key: '_runRegisteredRun',
    value: function _runRegisteredRun(lazyRunName, params, context, delay) {
      var lazyRunFunction = this.lazyRunFunctions[lazyRunName];
      var fn = lazyRunFunction.fn;
      var TOID = lazyRunFunction.TOID;

      delay = delay || lazyRunFunction.delay;
      context = context || lazyRunFunction.context;

      TOID = this._runSingleRun(fn, params, context, delay, TOID);

      lazyRunFunction.TOID = TOID;

      return TOID;
    }
  }, {
    key: '_clearTOIDIfNeed',
    value: function _clearTOIDIfNeed(TOID) {
      if (TOID) {
        clearTimeout(TOID);
      }
    }
  }]);

  return LazyRunner;
}();

exports.default = LazyRunner;

/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implments wysiwygEditor
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _domUtils = __webpack_require__(4);

var _domUtils2 = _interopRequireDefault(_domUtils);

var _wwClipboardManager = __webpack_require__(67);

var _wwClipboardManager2 = _interopRequireDefault(_wwClipboardManager);

var _wwListManager = __webpack_require__(69);

var _wwListManager2 = _interopRequireDefault(_wwListManager);

var _wwTaskManager = __webpack_require__(70);

var _wwTaskManager2 = _interopRequireDefault(_wwTaskManager);

var _wwTableManager = __webpack_require__(34);

var _wwTableManager2 = _interopRequireDefault(_wwTableManager);

var _wwTableSelectionManager = __webpack_require__(35);

var _wwTableSelectionManager2 = _interopRequireDefault(_wwTableSelectionManager);

var _wwHrManager = __webpack_require__(71);

var _wwHrManager2 = _interopRequireDefault(_wwHrManager);

var _wwPManager = __webpack_require__(72);

var _wwPManager2 = _interopRequireDefault(_wwPManager);

var _wwHeadingManager = __webpack_require__(73);

var _wwHeadingManager2 = _interopRequireDefault(_wwHeadingManager);

var _wwCodeBlockManager = __webpack_require__(36);

var _wwCodeBlockManager2 = _interopRequireDefault(_wwCodeBlockManager);

var _squireExt = __webpack_require__(74);

var _squireExt2 = _interopRequireDefault(_squireExt);

var _keyMapper = __webpack_require__(21);

var _keyMapper2 = _interopRequireDefault(_keyMapper);

var _wwTextObject = __webpack_require__(76);

var _wwTextObject2 = _interopRequireDefault(_wwTextObject);

var _componentManager = __webpack_require__(30);

var _componentManager2 = _interopRequireDefault(_componentManager);

var _codeBlockGadget = __webpack_require__(77);

var _codeBlockGadget2 = _interopRequireDefault(_codeBlockGadget);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var keyMapper = _keyMapper2.default.getSharedInstance();

var FIND_EMPTY_LINE = /<(.+)>(<br>|<br \/>|<BR>|<BR \/>)<\/\1>/g,
    FIND_UNNECESSARY_BR = /(?:<br>|<br \/>|<BR>|<BR \/>)<\/(.+?)>/g,
    FIND_BLOCK_TAGNAME_RX = /\b(H[\d]|LI|P|BLOCKQUOTE|TD|PRE)\b/;

var EDITOR_CONTENT_CSS_CLASSNAME = 'tui-editor-contents';

var canObserveMutations = typeof MutationObserver !== 'undefined';

/**
 * Class WysiwygEditor
 */

var WysiwygEditor = function () {
  /**
   * Creates an instance of WysiwygEditor.
   * @param {jQuery} $el element to insert editor
   * @param {EventManager} eventManager EventManager instance
   * @param {object} [options={}] - option object
   *  @param {boolean} [options.useCommandShortcut=true] - whether to use squire command shortcuts
   * @memberof WysiwygEditor
   */
  function WysiwygEditor($el, eventManager) {
    var _this = this;

    var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    _classCallCheck(this, WysiwygEditor);

    this.componentManager = new _componentManager2.default(this);
    this.eventManager = eventManager;
    this.$editorContainerEl = $el;

    this._height = 0;

    this._silentChange = false;

    this._keyEventHandlers = {};
    this._managers = {};

    this._options = _jquery2.default.extend({
      'useCommandShortcut': true
    }, options);

    this._initEvent();
    this._initDefaultKeyEventHandler();

    this.debouncedPostProcessForChange = _tuiCodeSnippet2.default.debounce(function () {
      return _this.postProcessForChange();
    }, 0);
  }

  /**
   * init
   * @memberof WysiwygEditor
   */


  _createClass(WysiwygEditor, [{
    key: 'init',
    value: function init() {
      var $editorBody = (0, _jquery2.default)('<div />');

      this.$editorContainerEl.append($editorBody);

      this.editor = new _squireExt2.default($editorBody[0], {
        blockTag: 'DIV',
        leafNodeNames: {
          'HR': false
        }
      });
      if (!this._options.useCommandShortcut) {
        this.editor.blockCommandShortcuts();
      }

      this._clipboardManager = new _wwClipboardManager2.default(this);
      this._initSquireEvent();
      this._clipboardManager.init();

      this.get$Body().addClass(EDITOR_CONTENT_CSS_CLASSNAME);
      this.$editorContainerEl.css('position', 'relative');

      this.codeBlockGadget = new _codeBlockGadget2.default({
        eventManager: this.eventManager,
        container: this.$editorContainerEl,
        wysiwygEditor: this
      });
    }

    /**
     * _preprocessForInlineElement
     * Seperate anchor tags with \u200B and replace blank space between <br> and <img to <br>$1
     * @param {string} html Inner html of content editable
     * @returns {string}
     * @memberof WysiwygEditor
     * @private
     */

  }, {
    key: '_preprocessForInlineElement',
    value: function _preprocessForInlineElement(html) {
      return html.replace(/<br>( *)<img/g, '<br><br>$1<img');
    }
    /**
     * _initEvent
     * Initialize EventManager event handler
     * @memberof WysiwygEditor
     * @private
     */

  }, {
    key: '_initEvent',
    value: function _initEvent() {
      var _this2 = this;

      this.eventManager.listen('wysiwygSetValueBefore', function (html) {
        return _this2._preprocessForInlineElement(html);
      });
      this.eventManager.listen('wysiwygKeyEvent', function (ev) {
        return _this2._runKeyEventHandlers(ev.data, ev.keyMap);
      });
      this.eventManager.listen('wysiwygRangeChangeAfter', function () {
        return _this2._scrollToRangeIfNeed();
      });
    }

    /**
     * addKeyEventHandler
     * Add key event handler
     * @memberof WysiwygEditor
     * @param {string} keyMap keyMap string
     * @param {function} handler handler
     */

  }, {
    key: 'addKeyEventHandler',
    value: function addKeyEventHandler(keyMap, handler) {
      if (!handler) {
        handler = keyMap;
        keyMap = 'DEFAULT';
      }

      if (!this._keyEventHandlers[keyMap]) {
        this._keyEventHandlers[keyMap] = [];
      }

      this._keyEventHandlers[keyMap].push(handler);
    }

    /**
     * REmove key event handler.
     * @param {string} keyMap keyMap string
     * @param {function} handler handler
     */

  }, {
    key: 'removeKeyEventHandler',
    value: function removeKeyEventHandler(keyMap, handler) {
      if (!handler) {
        handler = keyMap;
        keyMap = 'DEFAULT';
      }

      var handlers = this._keyEventHandlers[keyMap];

      if (handlers) {
        this._keyEventHandlers[keyMap] = handlers.filter(function (_handler) {
          return _handler !== handler;
        });
      }
    }

    /**
     * _runKeyEventHandlers
     * Run key event handler
     * @param {Event} event event object
     * @param {string} keyMap keyMapString
     * @private
     */

  }, {
    key: '_runKeyEventHandlers',
    value: function _runKeyEventHandlers(event, keyMap) {
      var range = this.getRange();
      var handlers = void 0,
          isNeedNext = void 0;

      handlers = this._keyEventHandlers.DEFAULT;

      if (handlers) {
        _tuiCodeSnippet2.default.forEachArray(handlers, function (handler) {
          isNeedNext = handler(event, range, keyMap);

          return isNeedNext;
        });
      }

      handlers = this._keyEventHandlers[keyMap];

      if (handlers && isNeedNext !== false) {
        _tuiCodeSnippet2.default.forEachArray(handlers, function (handler) {
          return handler(event, range, keyMap);
        });
      }
    }

    /**
     * _initSquireEvent
     * Initialize squire event
     * @private
     */

  }, {
    key: '_initSquireEvent',
    value: function _initSquireEvent() {
      var _this3 = this;

      var squire = this.getEditor();
      var isNeedFirePostProcessForRangeChange = false;

      squire.addEventListener('copy', function (clipboardEvent) {
        _this3.eventManager.emit('copy', {
          source: 'wysiwyg',
          data: clipboardEvent
        });
        _tuiCodeSnippet2.default.debounce(function () {
          if (!_this3.isEditorValid()) {
            return;
          }

          _this3.eventManager.emit('copyAfter', {
            source: 'wysiwyg',
            data: clipboardEvent
          });
        })();
      });

      squire.addEventListener(_tuiCodeSnippet2.default.browser.msie ? 'beforecut' : 'cut', function (clipboardEvent) {
        _this3.eventManager.emit('cut', {
          source: 'wysiwyg',
          data: clipboardEvent
        });
        _tuiCodeSnippet2.default.debounce(function () {
          if (!_this3.isEditorValid()) {
            return;
          }

          _this3.eventManager.emit('cutAfter', {
            source: 'wysiwyg',
            data: clipboardEvent
          });
        })();
      });

      squire.addEventListener(_tuiCodeSnippet2.default.browser.msie ? 'beforepaste' : 'paste', function (clipboardEvent) {
        _this3.eventManager.emit('paste', {
          source: 'wysiwyg',
          data: clipboardEvent
        });
      });

      squire.addEventListener('dragover', function (ev) {
        ev.preventDefault();

        return false;
      });

      squire.addEventListener('drop', function (ev) {
        ev.preventDefault();

        _this3.eventManager.emit('drop', {
          source: 'wysiwyg',
          data: ev
        });

        return false;
      });

      // change event will fired after range has been updated
      squire.addEventListener('input', _tuiCodeSnippet2.default.debounce(function () {
        if (!_this3.isEditorValid()) {
          return;
        }

        if (!_this3._silentChange) {
          var eventObj = {
            source: 'wysiwyg'
          };

          _this3.eventManager.emit('changeFromWysiwyg', eventObj);
          _this3.eventManager.emit('change', eventObj);
          _this3.eventManager.emit('contentChangedFromWysiwyg', _this3);
        } else {
          _this3._silentChange = false;
        }

        _this3.getEditor().preserveLastLine();
      }, 0));

      squire.addEventListener('keydown', function (keyboardEvent) {
        var range = _this3.getEditor().getSelection();

        if (!range.collapsed) {
          isNeedFirePostProcessForRangeChange = true;
        }

        _this3.eventManager.emit('keydown', {
          source: 'wysiwyg',
          data: keyboardEvent
        });

        _this3._onKeyDown(keyboardEvent);
      });

      if (_tuiCodeSnippet2.default.browser.firefox) {
        squire.addEventListener('keypress', function (keyboardEvent) {
          var keyCode = keyboardEvent.keyCode;


          if (keyCode === 13 || keyCode === 9) {
            var range = _this3.getEditor().getSelection();

            if (!range.collapsed) {
              isNeedFirePostProcessForRangeChange = true;
            }

            _this3.eventManager.emit('keydown', {
              source: 'wysiwyg',
              data: keyboardEvent
            });

            _this3._onKeyDown(keyboardEvent);
          }
        });

        // firefox produces shattered text nodes
        squire.addEventListener('keyup', function () {
          var range = _this3.getRange();

          if (_domUtils2.default.isTextNode(range.commonAncestorContainer) && _domUtils2.default.isTextNode(range.commonAncestorContainer.previousSibling)) {
            var prevLen = range.commonAncestorContainer.previousSibling.length;
            var curEl = range.commonAncestorContainer;

            range.commonAncestorContainer.previousSibling.appendData(range.commonAncestorContainer.data);

            range.setStart(range.commonAncestorContainer.previousSibling, prevLen + range.startOffset);
            range.collapse(true);

            curEl.parentNode.removeChild(curEl);

            _this3.setRange(range);
            range.detach();
          }
        });
      }

      squire.addEventListener('keyup', function (keyboardEvent) {
        if (isNeedFirePostProcessForRangeChange) {
          _this3.debouncedPostProcessForChange();
          isNeedFirePostProcessForRangeChange = false;
        }

        _this3.eventManager.emit('keyup', {
          source: 'wysiwyg',
          data: keyboardEvent
        });
      });

      this.$editorContainerEl.on('scroll', function (ev) {
        _this3.eventManager.emit('scroll', {
          source: 'wysiwyg',
          data: ev
        });
      });

      squire.addEventListener('click', function (ev) {
        _this3.eventManager.emit('click', {
          source: 'wysiwyg',
          data: ev
        });
      });

      squire.addEventListener('mousedown', function (ev) {
        _this3.eventManager.emit('mousedown', {
          source: 'wysiwyg',
          data: ev
        });
      });

      squire.addEventListener('mouseover', function (ev) {
        _this3.eventManager.emit('mouseover', {
          source: 'wysiwyg',
          data: ev
        });
      });

      squire.addEventListener('mouseout', function (ev) {
        _this3.eventManager.emit('mouseout', {
          source: 'wysiwyg',
          data: ev
        });
      });

      squire.addEventListener('mouseup', function (ev) {
        _this3.eventManager.emit('mouseup', {
          source: 'wysiwyg',
          data: ev
        });
      });

      squire.addEventListener('contextmenu', function (ev) {
        _this3.eventManager.emit('contextmenu', {
          source: 'wysiwyg',
          data: ev
        });
      });

      squire.addEventListener('focus', function () {
        _this3.eventManager.emit('focus', {
          source: 'wysiwyg'
        });
      });

      squire.addEventListener('blur', function () {
        _this3.eventManager.emit('blur', {
          source: 'wysiwyg'
        });
      });

      // Toolbar status active/inactive
      squire.addEventListener('pathChange', function (data) {
        var state = {
          bold: /(>B|>STRONG|^B$|^STRONG$)/.test(data.path),
          italic: /(>I|>EM|^I$|^EM$)/.test(data.path),
          strike: /(^S>|>S$|>S>|^S$)/.test(data.path),
          code: /CODE/.test(data.path),
          codeBlock: /PRE/.test(data.path),
          quote: /BLOCKQUOTE/.test(data.path),
          list: /LI(?!.task-list-item)/.test(_this3._getLastLiString(data.path)),
          task: /LI.task-list-item/.test(_this3._getLastLiString(data.path)),
          source: 'wysiwyg'
        };

        _this3.eventManager.emit('stateChange', state);
      });

      squire.addEventListener('willPaste', function (ev) {
        _this3.eventManager.emit('willPaste', {
          source: 'wysiwyg',
          data: ev
        });
      });
    }

    /**
     * Return last matched list item path string matched index to end
     * @param {string} path Full path string of current selection
     * @returns {string}
     * @private
     */

  }, {
    key: '_getLastLiString',
    value: function _getLastLiString(path) {
      var foundedListItem = /LI[^UO]*$/.exec(path);
      var result = void 0;

      if (foundedListItem) {
        result = foundedListItem[0];
      } else {
        result = '';
      }

      return result;
    }

    /**
     * Handler of keydown event
     * @param {object} keyboardEvent Event object
     * @private
     */

  }, {
    key: '_onKeyDown',
    value: function _onKeyDown(keyboardEvent) {
      var keyMap = keyMapper.convert(keyboardEvent);

      // to avoid duplicate event firing in firefox
      if (keyboardEvent.keyCode) {
        this.eventManager.emit('keyMap', {
          source: 'wysiwyg',
          keyMap: keyMap,
          data: keyboardEvent
        });

        if (!keyboardEvent.defaultPrevented) {
          this.eventManager.emit('wysiwygKeyEvent', {
            keyMap: keyMap,
            data: keyboardEvent
          });
        }
      }
    }

    /**
     * _initDefaultKeyEventHandler
     * Initialize default event handler
     * @private
     */

  }, {
    key: '_initDefaultKeyEventHandler',
    value: function _initDefaultKeyEventHandler() {
      var _this4 = this;

      this.addKeyEventHandler('ENTER', function (ev, range) {
        if (_this4._isInOrphanText(range)) {
          // We need this cuz input text right after table make orphan text in webkit
          _this4.defer(function () {
            _this4._wrapDefaultBlockToOrphanTexts();
            _this4.breakToNewDefaultBlock(range, 'before');
          });
        }

        _this4.defer(function () {
          _this4._scrollToRangeIfNeed();
        });
      });

      this.addKeyEventHandler('TAB', function (ev) {
        var sq = _this4.getEditor();
        var range = sq.getSelection();
        var isAbleToInput4Spaces = range.collapsed && _this4._isCursorNotInRestrictedAreaOfTabAction(sq);
        var isTextSelection = !range.collapsed && _domUtils2.default.isTextNode(range.commonAncestorContainer);

        ev.preventDefault();
        if (isAbleToInput4Spaces || isTextSelection) {
          sq.insertPlainText('\xA0\xA0\xA0\xA0');

          return false;
        }

        return true;
      });
    }
  }, {
    key: '_wrapDefaultBlockToOrphanTexts',
    value: function _wrapDefaultBlockToOrphanTexts() {
      var textNodes = this.get$Body().contents().filter(this.findTextNodeFilter);

      textNodes.each(function (i, node) {
        if (node.nextSibling && node.nextSibling.tagName === 'BR') {
          (0, _jquery2.default)(node.nextSibling).remove();
        }

        (0, _jquery2.default)(node).wrap('<div />');
      });
    }

    /**
     * Scroll editor area to current cursor position if need
     * @private
     */

  }, {
    key: '_scrollToRangeIfNeed',
    value: function _scrollToRangeIfNeed() {
      var $editorContainerEl = this.$editorContainerEl;
      var range = this.getRange();
      var cursorTop = this.getEditor().getCursorPosition(range).top - $editorContainerEl.offset().top;

      if (cursorTop >= $editorContainerEl.height()) {
        var target = range.endContainer;
        if (!(target instanceof Element)) {
          target = target.parentNode;
        }
        target.scrollIntoView(false);
      }
    }

    /**
     * _isInOrphanText
     * check if range is orphan text
     * @param {Range} range range
     * @returns {boolean} result
     * @private
     */

  }, {
    key: '_isInOrphanText',
    value: function _isInOrphanText(range) {
      return range.startContainer.nodeType === Node.TEXT_NODE && range.startContainer.parentNode === this.get$Body()[0];
    }

    /**
     * _wrapDefaultBlockTo
     * Wrap default block to passed range
     * @param {Range} range range
     * @private
     */

  }, {
    key: '_wrapDefaultBlockTo',
    value: function _wrapDefaultBlockTo(range) {
      this.saveSelection(range);
      this._joinSplitedTextNodes();
      this.restoreSavedSelection();

      range = this.getRange();

      var textElem = range.startContainer;
      var cursorOffset = range.startOffset;

      // after code below, range range is arranged by body
      var block = this.getEditor().createDefaultBlock([range.startContainer]);

      // range for insert block
      var insertTargetNode = _domUtils2.default.getChildNodeByOffset(range.startContainer, range.startOffset);
      if (insertTargetNode) {
        range.setStartBefore(insertTargetNode);
      } else {
        // only child in container
        range.selectNodeContents(range.startContainer);
      }

      range.collapse(true);

      range.insertNode(block);

      // revert range to original node
      range.setStart(textElem, cursorOffset);
      range.collapse(true);

      this.setRange(range);
    }

    /**
     * findTextNodeFilter
     * @this Node
     * @returns {boolean} true or not
     */

  }, {
    key: 'findTextNodeFilter',
    value: function findTextNodeFilter() {
      return this.nodeType === Node.TEXT_NODE;
    }

    /**
     * _joinSplitedTextNodes
     * Join spliated text nodes
     * @private
     */

  }, {
    key: '_joinSplitedTextNodes',
    value: function _joinSplitedTextNodes() {
      var prevNode = void 0,
          lastGroup = void 0;
      var nodesToRemove = [];
      var textNodes = this.get$Body().contents().filter(this.findTextNodeFilter);

      textNodes.each(function (i, node) {
        if (prevNode === node.previousSibling) {
          lastGroup.nodeValue += node.nodeValue;
          nodesToRemove.push(node);
        } else {
          lastGroup = node;
        }

        prevNode = node;
      });

      (0, _jquery2.default)(nodesToRemove).remove();
    }

    /**
     * saveSelection
     * Save current selection before modification
     * @memberof WysiwygEditor
     * @param {Range} range Range object
     */

  }, {
    key: 'saveSelection',
    value: function saveSelection(range) {
      if (!range) {
        range = this.getRange();
      }

      this.getEditor()._saveRangeToBookmark(range);
    }

    /**
     * restoreSavedSelection
     * Restore saved selection
     * @memberof WysiwygEditor
     */

  }, {
    key: 'restoreSavedSelection',
    value: function restoreSavedSelection() {
      this.setRange(this.getEditor()._getRangeAndRemoveBookmark());
    }

    /**
     * reset
     * Reset wysiwyg editor
     * @memberof WysiwygEditor
     */

  }, {
    key: 'reset',
    value: function reset() {
      this.setValue('');
    }

    /**
     * changeBlockFormatTo
     * Change current range block format to passed tag
     * @memberof WysiwygEditor
     * @param {string} targetTagName Target element tag name
     */

  }, {
    key: 'changeBlockFormatTo',
    value: function changeBlockFormatTo(targetTagName) {
      this.getEditor().changeBlockFormatTo(targetTagName);
      this.eventManager.emit('wysiwygRangeChangeAfter', this);
    }

    /**
     * makeEmptyBlockCurrentSelection
     * Make empty block to current selection
     * @memberof WysiwygEditor
     */

  }, {
    key: 'makeEmptyBlockCurrentSelection',
    value: function makeEmptyBlockCurrentSelection() {
      var _this5 = this;

      this.getEditor().modifyBlocks(function (frag) {
        if (!frag.textContent) {
          frag = _this5.getEditor().createDefaultBlock();
        }

        return frag;
      });
    }

    /**
     * focus
     * Focus to editor
     * @memberof WysiwygEditor
     */

  }, {
    key: 'focus',
    value: function focus() {
      var scrollTop = this.scrollTop();

      this.editor.focus();

      // In webkit, if contenteditable element focus method have been invoked when another input element has focus,
      // contenteditable scroll to top automatically so we need scroll it back
      if (scrollTop !== this.scrollTop()) {
        this.scrollTop(scrollTop);
      }
    }

    /**
     * blur
     * Remove focus of editor
     * @memberof WysiwygEditor
     */

  }, {
    key: 'blur',
    value: function blur() {
      this.editor.blur();
    }

    /**
     * remove
     * Remove wysiwyg editor
     * @memberof WysiwygEditor
     */

  }, {
    key: 'remove',
    value: function remove() {
      this.getEditor().destroy();

      this.editor = null;
      this.$body = null;
      this.eventManager = null;
    }

    /**
     * setHeight
     * Set editor height
     * @memberof WysiwygEditor
     * @param {number|string} height pixel of height or "auto"
     */

  }, {
    key: 'setHeight',
    value: function setHeight(height) {
      this._height = height;

      this.$editorContainerEl.css('overflow', 'auto');
      this.$editorContainerEl.css('height', '100%');
      this.$editorContainerEl.parent().height(height);

      var paddingHeight = parseInt(this.$editorContainerEl.css('padding-top'), 10) - parseInt(this.$editorContainerEl.css('padding-bottom'), 10);
      var marginHeight = parseInt(this.get$Body().css('margin-top'), 10) - parseInt(this.get$Body().css('margin-bottom'), 10);
      this.get$Body().css('min-height', height - marginHeight - paddingHeight + 'px');
    }

    /**
     * set min height
     * @param {number} minHeight - min height in px
     * @memberof WysiwygEditor
     */

  }, {
    key: 'setMinHeight',
    value: function setMinHeight(minHeight) {
      var editorBody = this.get$Body().get(0);
      editorBody.style.minHeight = minHeight + 'px';
    }

    /**
     * setValue
     * Set value to wysiwyg editor
     * @memberof WysiwygEditor
     * @param {string} html - HTML text
     * @param {boolean} [cursorToEnd=true] - move cursor to contents end
     */

  }, {
    key: 'setValue',
    value: function setValue(html) {
      var cursorToEnd = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      html = this.eventManager.emitReduce('wysiwygSetValueBefore', html);

      this.editor.setHTML(html);

      this.eventManager.emit('wysiwygSetValueAfter', this);
      this.eventManager.emit('contentChangedFromWysiwyg', this);

      if (cursorToEnd) {
        this.moveCursorToEnd();
      }

      this.getEditor().preserveLastLine();

      this.getEditor().removeLastUndoStack();
      this.getEditor().saveUndoState();
    }

    /**
     * insert given text to cursor position or selected area
     * @param {string} text - text string to insert
     * @memberof WysiwygEditor
     */

  }, {
    key: 'insertText',
    value: function insertText(text) {
      this.editor.insertPlainText(text);
    }

    /**
     * getValue
     * Get value of wysiwyg editor
     * @memberof WysiwygEditor
     * @returns {string} html
     */

  }, {
    key: 'getValue',
    value: function getValue() {
      this._prepareGetHTML();

      var html = this.editor.getHTML();

      // empty line replace to br
      html = html.replace(FIND_EMPTY_LINE, function (match, tag) {
        var result = void 0;

        // we maintain empty list
        if (tag === 'li') {
          result = match;
          // we maintain empty table
        } else if (tag === 'td' || tag === 'th') {
          result = '<' + tag + '></' + tag + '>';
        } else {
          result = '<br />';
        }

        return result;
      });

      // remove unnecessary brs
      html = html.replace(FIND_UNNECESSARY_BR, '</$1>');

      // remove contenteditable block, in this case div
      html = html.replace(/<div[^>]*>/g, '');
      html = html.replace(/<\/div>/g, '<br />');

      html = this.eventManager.emitReduce('wysiwygProcessHTMLText', html);

      return html;
    }

    /**
     * _prepareGetHTML
     * Prepare before get html
     * @memberof WysiwygEditor
     * @private
     */

  }, {
    key: '_prepareGetHTML',
    value: function _prepareGetHTML() {
      var _this6 = this;

      this.getEditor().modifyDocument(function () {
        _this6._joinSplitedTextNodes();
        _this6.eventManager.emit('wysiwygGetValueBefore', _this6);
      });
    }

    /**
     * postProcessForChange
     * @memberof WysiwygEditor
     */

  }, {
    key: 'postProcessForChange',
    value: function postProcessForChange() {
      var _this7 = this;

      if (!this.isEditorValid()) {
        return;
      }

      this.getEditor().modifyDocument(function () {
        _this7.eventManager.emit('wysiwygRangeChangeAfter', _this7);
      });
    }

    /**
     * readySilentChange
     * Ready to silent change
     * @memberof WysiwygEditor
     */

  }, {
    key: 'readySilentChange',
    value: function readySilentChange() {
      if (canObserveMutations && !this.getEditor().isIgnoreChange()) {
        this._silentChange = true;
      }
    }

    /**
     * getEditor
     * Get squire
     * @memberof WysiwygEditor
     * @returns {SquireExt} squire
     */

  }, {
    key: 'getEditor',
    value: function getEditor() {
      return this.editor;
    }

    /**
     * replaceSelection
     * Replace text of passed range
     * @memberof WysiwygEditor
     * @param {string} content Content for change current selection
     * @param {Range} range range
     */

  }, {
    key: 'replaceSelection',
    value: function replaceSelection(content, range) {
      this.getEditor().replaceSelection(content, range);
    }

    /**
     * replaceRelativeOffset
     * Replace content by relative offset
     * @memberof WysiwygEditor
     * @param {string} content Content for change current selection
     * @param {number} offset Offset of current range
     * @param {number} overwriteLength Length to overwrite content
     */

  }, {
    key: 'replaceRelativeOffset',
    value: function replaceRelativeOffset(content, offset, overwriteLength) {
      this.getEditor().replaceRelativeOffset(content, offset, overwriteLength);
    }

    /**
     * addWidget
     * Add widget to selection
     * @memberof WysiwygEditor
     * @param {Range} range Range object
     * @param {Node} node Widget node
     * @param {string} style Adding style "over" or "bottom"
     * @param {number} [offset] Offset to adjust position
     */

  }, {
    key: 'addWidget',
    value: function addWidget(range, node, style, offset) {
      var pos = this.getEditor().getSelectionPosition(range, style, offset);
      var editorContainerPos = this.$editorContainerEl.offset();

      this.$editorContainerEl.append(node);

      (0, _jquery2.default)(node).css({
        position: 'absolute',
        top: pos.top - editorContainerPos.top + this.scrollTop(),
        left: pos.left - editorContainerPos.left
      });
    }

    /**
     * get$Body
     * Get jQuery wrapped body container of Squire
     * @memberof WysiwygEditor
     * @returns {JQuery} jquery body
     */

  }, {
    key: 'get$Body',
    value: function get$Body() {
      return this.getEditor().get$Body();
    }

    /**
     * hasFormatWithRx
     * Check with given regexp whether current path has some format or not
     * @memberof WysiwygEditor
     * @param {RegExp} rx Regexp
     * @returns {boolean} Match result
     */

  }, {
    key: 'hasFormatWithRx',
    value: function hasFormatWithRx(rx) {
      return this.getEditor().getPath().match(rx);
    }

    /**
     * breakToNewDefaultBlock
     * Break line to new default block from passed range
     * @memberof WysiwygEditor
     * @param {Range} range Range object
     * @param {string} [where] "before" or not
     */

  }, {
    key: 'breakToNewDefaultBlock',
    value: function breakToNewDefaultBlock(range, where) {
      var div = this.editor.createDefaultBlock();
      var currentNode = _domUtils2.default.getChildNodeByOffset(range.startContainer, range.startOffset) || _domUtils2.default.getChildNodeByOffset(range.startContainer, range.startOffset - 1);
      var appendBefore = _domUtils2.default.getParentUntil(currentNode, this.get$Body()[0]);

      if (where === 'before') {
        (0, _jquery2.default)(appendBefore).before(div);
      } else {
        (0, _jquery2.default)(appendBefore).after(div);
      }

      range.setStart(div, 0);
      range.collapse(true);
      this.setRange(range);
    }

    /**
     * replaceContentText
     * Replace textContet of node
     * @memberof WysiwygEditor
     * @param {Node} container Container node
     * @param {string} from Target text to change
     * @param {string} to Replacement text
     */

  }, {
    key: 'replaceContentText',
    value: function replaceContentText(container, from, to) {
      var before = (0, _jquery2.default)(container).html();
      (0, _jquery2.default)(container).html(before.replace(from, to));
    }

    /**
     * unwrapBlockTag
     * Unwrap Block tag of current range
     * @memberof WysiwygEditor
     * @param {function} [condition] iterate with tagName
     */

  }, {
    key: 'unwrapBlockTag',
    value: function unwrapBlockTag(condition) {
      if (!condition) {
        condition = function condition(tagName) {
          return FIND_BLOCK_TAGNAME_RX.test(tagName);
        };
      }

      this.getEditor().changeBlockFormat(condition);
      this.eventManager.emit('wysiwygRangeChangeAfter', this);
    }

    /**
     * Set cursor position to end
     * @memberof WysiwygEditor
     */

  }, {
    key: 'moveCursorToEnd',
    value: function moveCursorToEnd() {
      this.getEditor().moveCursorToEnd();
      var contentNodes = this.get$Body().get(0).childNodes;
      if (contentNodes.length > 0) {
        contentNodes[contentNodes.length - 1].scrollIntoView(false);
      }
      this._correctRangeAfterMoveCursor('end');
    }

    /**
     * Set cursor position to start
     * @memberof WysiwygEditor
     */

  }, {
    key: 'moveCursorToStart',
    value: function moveCursorToStart() {
      this.getEditor().moveCursorToStart();
      this.scrollTop(0);
    }

    /**
     * Set cursor position to start
     * @memberof WysiwygEditor
     * @param {number} value Scroll amount
     * @returns {boolean}
     */

  }, {
    key: 'scrollTop',
    value: function scrollTop(value) {
      if (_tuiCodeSnippet2.default.isUndefined(value)) {
        return this.$editorContainerEl.scrollTop();
      }

      return this.$editorContainerEl.scrollTop(value);
    }

    /**
     * _correctRangeAfterMoveCursor
     * For arrange Range after moveCursorToEnd api invocation. Squire has bug in Firefox, IE.
     * @memberof WysiwygEditor
     * @param {string} direction Direction of cursor move
     * @private
     */

  }, {
    key: '_correctRangeAfterMoveCursor',
    value: function _correctRangeAfterMoveCursor(direction) {
      var range = this.getRange();
      var cursorContainer = this.get$Body().get(0);

      if (direction === 'start') {
        while (cursorContainer.firstChild) {
          cursorContainer = cursorContainer.firstChild;
        }
      } else {
        while (cursorContainer.lastChild) {
          cursorContainer = cursorContainer.lastChild;
        }
      }

      // IE have problem with cursor after br
      if (cursorContainer.tagName === 'BR') {
        range.setStartBefore(cursorContainer);
      } else {
        range.setStartAfter(cursorContainer);
      }

      range.collapse(true);

      this.setRange(range);
    }

    /**
     * Get current Range object
     * @memberof WysiwygEditor
     * @returns {Range}
     */

  }, {
    key: 'getRange',
    value: function getRange() {
      return this.getEditor().getSelection().cloneRange();
    }

    /**
     * set range
     * @param {Range} range - range to set
     * @memberof WysiwygEditor
     */

  }, {
    key: 'setRange',
    value: function setRange(range) {
      this.getEditor().setSelection(range);
    }

    /**
     * Get text object of current range
     * @memberof WysiwygEditor
     * @param {Range} range Range object
     * @returns {WwTextObject}
     */

  }, {
    key: 'getTextObject',
    value: function getTextObject(range) {
      return new _wwTextObject2.default(this, range);
    }
  }, {
    key: 'defer',
    value: function defer(callback, delayOffset) {
      var _this8 = this;

      var delay = delayOffset ? delayOffset : 0;

      setTimeout(function () {
        if (_this8.isEditorValid()) {
          callback(_this8);
        }
      }, delay);
    }
  }, {
    key: 'isEditorValid',
    value: function isEditorValid() {
      return this.getEditor() && _jquery2.default.contains(this.$editorContainerEl[0].ownerDocument, this.$editorContainerEl[0]);
    }
  }, {
    key: '_isCursorNotInRestrictedAreaOfTabAction',
    value: function _isCursorNotInRestrictedAreaOfTabAction(editor) {
      return !editor.hasFormat('li') && !editor.hasFormat('blockquote') && !editor.hasFormat('table');
    }

    /**
     * WysiwygEditor factory method
     * @memberof WysiwygEditor
     * @param {jQuery} $el Container element for editor
     * @param {EventManager} eventManager EventManager instance
     * @param {object} [options={}] - option object
     *  @param {boolean} [options.useCommandShortcut=true] - whether to use squire command shortcuts
     * @returns {WysiwygEditor} wysiwygEditor
     */

  }], [{
    key: 'factory',
    value: function factory($el, eventManager, options) {
      var wwe = new WysiwygEditor($el, eventManager, options);

      wwe.init();

      wwe.componentManager.addManager(_wwListManager2.default);
      wwe.componentManager.addManager(_wwTaskManager2.default);
      wwe.componentManager.addManager(_wwTableSelectionManager2.default);
      wwe.componentManager.addManager(_wwTableManager2.default);
      wwe.componentManager.addManager(_wwHrManager2.default);
      wwe.componentManager.addManager(_wwPManager2.default);
      wwe.componentManager.addManager(_wwHeadingManager2.default);
      wwe.componentManager.addManager(_wwCodeBlockManager2.default);

      return wwe;
    }
  }]);

  return WysiwygEditor;
}();

exports.default = WysiwygEditor;

/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements wysiwyg editor clipboard manager
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _domUtils = __webpack_require__(4);

var _domUtils2 = _interopRequireDefault(_domUtils);

var _wwPasteContentHelper = __webpack_require__(68);

var _wwPasteContentHelper2 = _interopRequireDefault(_wwPasteContentHelper);

var _i18n = __webpack_require__(3);

var _i18n2 = _interopRequireDefault(_i18n);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var PASTE_TABLE_BOOKMARK = 'tui-paste-table-bookmark';
var PASTE_TABLE_CELL_BOOKMARK = 'tui-paste-table-cell-bookmark';

/**
 * Class WwClipboardManager
 */

var WwClipboardManager = function () {
  /**
   * Creates an instance of WwClipboardManager.
   * @param {WysiwygEditor} wwe - WysiwygEditor instance
   * @memberof WwClipboardManager
   */
  function WwClipboardManager(wwe) {
    _classCallCheck(this, WwClipboardManager);

    this.wwe = wwe;
    this._pch = new _wwPasteContentHelper2.default(this.wwe);
    this._selectedSellCount = 0;
    this._$clipboardArea = null;
  }

  /**
   * init
   * initialize
   * @memberof WwClipboardManager
   */


  _createClass(WwClipboardManager, [{
    key: 'init',
    value: function init() {
      var _this = this;

      this.wwe.eventManager.listen('willPaste', function (ev) {
        return _this._onWillPaste(ev.data);
      });
      this.wwe.eventManager.listen('copy', this._onCopyCut.bind(this));
      this.wwe.eventManager.listen('copyAfter', this._onCopyAfter.bind(this));
      this.wwe.eventManager.listen('cut', this._onCopyCut.bind(this));
      this.wwe.eventManager.listen('cutAfter', this._onCutAfter.bind(this));
    }
  }, {
    key: '_onCopyCut',
    value: function _onCopyCut(event) {
      var tableManager = this.wwe.componentManager.getManager('tableSelection');
      var selectedCellCount = tableManager.getSelectedCells().length;
      if (!selectedCellCount) {
        // preserve selection range in a cell, let squire do the job
        return;
      }
      if (!tableManager.mergedTableSelectionManager) {
        // set selection range to all contents in selected cells, then squire
        tableManager.createRangeBySelectedCells();
        tableManager.removeClassAttrbuteFromAllCellsIfNeed();

        return;
      }
      var editor = this.wwe.getEditor();
      var clipboardEvent = event.data;
      var range = editor.getSelection().cloneRange();
      var $clipboardContainer = (0, _jquery2.default)('<div />');

      this._extendRange(range);
      $clipboardContainer.append(range.cloneContents());
      this._updateCopyDataForListTypeIfNeed(range, $clipboardContainer);
      this.wwe.eventManager.emit('copyBefore', {
        source: 'wysiwyg',
        $clipboardContainer: $clipboardContainer
      });

      this._setClipboardData(clipboardEvent, $clipboardContainer.html(), $clipboardContainer.text());
    }
  }, {
    key: '_clearClipboardArea',
    value: function _clearClipboardArea() {
      if (this._$clipboardArea) {
        this._$clipboardArea.remove();
        this._$clipboardArea = null;
      }
    }
  }, {
    key: '_onCopyAfter',
    value: function _onCopyAfter() {
      this.wwe.getEditor().get$Body().focus();
      this._clearClipboardArea();
    }
  }, {
    key: '_onCutAfter',
    value: function _onCutAfter() {
      var range = this.wwe.getEditor().getSelection();
      range.deleteContents();
      this.wwe.getEditor().focus();
      this._clearClipboardArea();
    }
  }, {
    key: '_onWillPaste',
    value: function _onWillPaste(pasteData) {
      var _this2 = this;

      var $clipboardContainer = (0, _jquery2.default)('<div>').append(pasteData.fragment.cloneNode(true));

      this._setTableBookmark($clipboardContainer);

      if (this._pasteToTable($clipboardContainer)) {
        pasteData.preventDefault();
      } else {
        this._preparePaste($clipboardContainer);
        this._setTableBookmark($clipboardContainer);

        pasteData.fragment = document.createDocumentFragment();
        (0, _jquery2.default)($clipboardContainer[0].childNodes).each(function (index, element) {
          pasteData.fragment.appendChild(element);
        });
      }

      // once right after the squire insertHTML DOM.
      var handler = function handler() {
        _this2.wwe.getEditor().removeEventListener('input', handler);
        _this2.wwe.eventManager.emit('wysiwygRangeChangeAfter', _this2);
        _this2._focusTableBookmark();
      };
      this.wwe.getEditor().addEventListener('input', handler);
    }
  }, {
    key: '_setClipboardData',
    value: function _setClipboardData(clipboardEvent, htmlContent, textContent) {
      if (_tuiCodeSnippet2.default.browser.msie) {
        clipboardEvent.squirePrevented = true;
        this._$clipboardArea = this._createClipboardArea();
        this._$clipboardArea.html(htmlContent);
        this._$clipboardArea.focus();
        window.getSelection().selectAllChildren(this._$clipboardArea[0]);
      } else {
        clipboardEvent.preventDefault();
        clipboardEvent.stopPropagation();
        clipboardEvent.clipboardData.setData('text/html', htmlContent);
        clipboardEvent.clipboardData.setData('text/plain', textContent);
      }
    }
  }, {
    key: '_createClipboardArea',
    value: function _createClipboardArea() {
      return (0, _jquery2.default)('<DIV>').attr({
        contenteditable: 'true',
        style: 'position:fixed; overflow:hidden; top:0; right:100%; width:1px; height:1px;'
      }).appendTo(document.body);
    }

    /**
     * Update copy data, when commonAncestorContainer nodeName is list type like UL or OL.
     * @param {object} range - text range
     * @param {jQuery} $clipboardContainer - clibpard container jQuery element
     * @private
     */

  }, {
    key: '_updateCopyDataForListTypeIfNeed',
    value: function _updateCopyDataForListTypeIfNeed(range, $clipboardContainer) {
      var commonAncestorNodeName = range.commonAncestorContainer.nodeName;
      if (commonAncestorNodeName !== 'UL' && commonAncestorNodeName !== 'OL') {
        return;
      }

      var $newParent = (0, _jquery2.default)('<' + commonAncestorNodeName + ' />');
      $newParent.append($clipboardContainer.html());
      $clipboardContainer.html('');
      $clipboardContainer.append($newParent);
    }

    /**
     * Remove empty font elements.
     * @param {jQuery} $clipboardContainer - cliboard jQuery container
     * @private
     */

  }, {
    key: '_removeEmptyFontElement',
    value: function _removeEmptyFontElement($clipboardContainer) {
      // clipboard data from ms word tend to have unneccesary font tags
      $clipboardContainer.children('font').each(function (index, element) {
        var $element = (0, _jquery2.default)(element);

        if (!$element.text().trim()) {
          $element.remove();
        }
      });
    }

    /**
     * Paste to table.
     * @param {jQuery} $clipboardContainer - clibpard container
     * @returns {boolean} whether processed or not
     * @private
     */

  }, {
    key: '_pasteToTable',
    value: function _pasteToTable($clipboardContainer) {
      var tableManager = this.wwe.componentManager.getManager('table');
      var tableSelectionManager = this.wwe.componentManager.getManager('tableSelection');
      var range = this.wwe.getEditor().getSelection();
      var pastingToTable = tableManager.isInTable(range);

      var _$clipboardContainer$ = $clipboardContainer.get(0),
          childNodes = _$clipboardContainer$.childNodes;

      var containsOneTableOnly = childNodes.length === 1 && childNodes[0].nodeName === 'TABLE';
      var processed = false;

      if (pastingToTable) {
        if (containsOneTableOnly) {
          tableManager.pasteClipboardData($clipboardContainer.first());
          $clipboardContainer.html(''); // drains clipboard data as we've pasted everything here.
          processed = true;
        } else if (tableSelectionManager.getSelectedCells().length) {
          alert(_i18n2.default.get('Cannot paste values ​​other than a table in the cell selection state'));
          $clipboardContainer.html(''); // drains clipboard data
          processed = true;
        }
      }

      return processed;
    }

    /**
     * Prepare paste.
     * @param {jQuery} $clipboardContainer - temporary jQuery container for clipboard contents
     * @private
     */

  }, {
    key: '_preparePaste',
    value: function _preparePaste($clipboardContainer) {
      this._removeEmptyFontElement($clipboardContainer);

      this._pch.preparePaste($clipboardContainer);

      this.wwe.eventManager.emit('pasteBefore', {
        source: 'wysiwyg',
        $clipboardContainer: $clipboardContainer
      });
    }

    /**
     * set table bookmark which will gain focus after document modification ends.
     * @param {jQuery} $clipboardContainer - clipboard container
     * @memberof WwClipboardManager
     * @private
     */

  }, {
    key: '_setTableBookmark',
    value: function _setTableBookmark($clipboardContainer) {
      var $lastNode = (0, _jquery2.default)($clipboardContainer[0].childNodes).last();
      var isLastNodeTable = $lastNode[0] && $lastNode[0].nodeName === 'TABLE';

      if (isLastNodeTable) {
        $lastNode.addClass(PASTE_TABLE_BOOKMARK);
      }
    }

    /**
     * Focus to table after document modification.
     * @param {object} sq - squire editor instance
     * @private
     */

  }, {
    key: '_focusTableBookmark',
    value: function _focusTableBookmark() {
      var sq = this.wwe.getEditor();
      var range = sq.getSelection().cloneRange();
      var $bookmarkedTable = sq.get$Body().find('.' + PASTE_TABLE_BOOKMARK);
      var $bookmarkedCell = sq.get$Body().find('.' + PASTE_TABLE_CELL_BOOKMARK);

      if ($bookmarkedTable.length) {
        $bookmarkedTable.removeClass(PASTE_TABLE_BOOKMARK);
        range.setEndAfter($bookmarkedTable[0]);
        range.collapse(false);
        sq.setSelection(range);
      }
      if ($bookmarkedCell.length) {
        $bookmarkedCell.removeClass(PASTE_TABLE_CELL_BOOKMARK);
        range.selectNodeContents($bookmarkedCell[0]);
        range.collapse(false);
        sq.setSelection(range);
      }
    }

    /**
     * _extendRange
     * extend range if need
     * @memberof WwClipboardManager
     * @param {Range} range to extend
     * @private
     */

  }, {
    key: '_extendRange',
    value: function _extendRange(range) {
      // non-text node && not selected whole area, then expand the range
      if (_domUtils2.default.isTextNode(range.commonAncestorContainer) && (range.startOffset !== 0 || range.commonAncestorContainer.textContent.length !== range.endOffset) && range.commonAncestorContainer.nodeName !== 'TD') {
        return;
      }

      if (range.startOffset === 0) {
        range = this._extendStartRange(range);
      }

      if (range.endOffset === _domUtils2.default.getOffsetLength(range.endContainer)) {
        range = this._extendEndRange(range);
      }

      // commonAncestor if all of it's children has been selected
      if (this._isWholeCommonAncestorContainerSelected(range)) {
        range.selectNode(range.commonAncestorContainer);
      }
      this.wwe.getEditor().setSelection(range);
    }

    /**
     * Extends current range's startContainer
     * @memberof WwClipboardManager
     * @param {Range} range Range object
     * @returns {Range}
     * @private
     */

  }, {
    key: '_extendStartRange',
    value: function _extendStartRange(range) {
      var newBound = range.startContainer;

      // expand range
      while (newBound.parentNode !== range.commonAncestorContainer && newBound.parentNode !== this.wwe.get$Body()[0] && !newBound.previousSibling) {
        newBound = newBound.parentNode;
      }

      // expand range
      range.setStart(newBound.parentNode, _domUtils2.default.getNodeOffsetOfParent(newBound));

      return range;
    }

    /**
     * Extends current range's endContainer
     * @memberof WwClipboardManager
     * @param {Range} range Range object
     * @returns {Range}
     * @private
     */

  }, {
    key: '_extendEndRange',
    value: function _extendEndRange(range) {
      var newBound = range.endContainer;
      var boundNext = newBound.nextSibling;

      // expand range
      while (newBound.parentNode !== range.commonAncestorContainer && newBound.parentNode !== this.wwe.get$Body()[0] && (!boundNext || _domUtils2.default.getNodeName(boundNext) === 'BR' && newBound.parentNode.lastChild === boundNext)) {
        newBound = newBound.parentNode;
        boundNext = newBound.nextSibling;
      }

      // expand range level
      range.setEnd(newBound.parentNode, _domUtils2.default.getNodeOffsetOfParent(newBound) + 1);

      return range;
    }

    /**
     * _isWholeCommonAncestorContainerSelected
     * Check whether whole commonAncestorContainter textContent selected or not
     * @memberof WwClipboardManager
     * @param {Range} range Range object
     * @returns {boolean} result
     * @private
     */

  }, {
    key: '_isWholeCommonAncestorContainerSelected',
    value: function _isWholeCommonAncestorContainerSelected(range) {
      return range.commonAncestorContainer.nodeType === Node.ELEMENT_NODE && range.commonAncestorContainer !== this.wwe.get$Body()[0] && range.startOffset === 0 && range.endOffset === range.commonAncestorContainer.childNodes.length && range.commonAncestorContainer === range.startContainer && range.commonAncestorContainer === range.endContainer;
    }
  }]);

  return WwClipboardManager;
}();

exports.default = WwClipboardManager;

/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements WwPasteContentHelper
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _domUtils = __webpack_require__(4);

var _domUtils2 = _interopRequireDefault(_domUtils);

var _htmlSanitizer = __webpack_require__(33);

var _htmlSanitizer2 = _interopRequireDefault(_htmlSanitizer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Class WwPasteContentHelper
 */
var WwPasteContentHelper = function () {
  /**
   * Creates an instance of WwPasteContentHelper.
   * @param {WysiwygEditor} wwe - wysiwygEditor instance
   * @memberof WwPasteContentHelper
   */
  function WwPasteContentHelper(wwe) {
    _classCallCheck(this, WwPasteContentHelper);

    this.wwe = wwe;
  }

  /**
   * Process paste data before paste
   * @memberof WwPasteContentHelper
   * @param {jQuery} $container - clipboard container
   */


  _createClass(WwPasteContentHelper, [{
    key: 'preparePaste',
    value: function preparePaste($container) {
      var range = this.wwe.getEditor().getSelection().cloneRange();
      var wwCodeblockManager = this.wwe.componentManager.getManager('codeblock');
      var firstBlockIsTaken = false;
      var $tempContainer = (0, _jquery2.default)('<div />');

      var nodeName = void 0,
          node = void 0,
          isPastingList = void 0;

      this._pasteFirstAid($container);

      var childNodes = _tuiCodeSnippet2.default.toArray($container[0].childNodes);

      // prepare to paste as inline of first node if possible
      if (childNodes.length && childNodes[0].tagName === 'DIV') {
        $tempContainer.append(this._unwrapFragmentFirstChildForPasteAsInline(childNodes[0]));
        childNodes.shift();
      }

      while (childNodes.length) {
        node = childNodes[0];

        nodeName = _domUtils2.default.getNodeName(node);
        isPastingList = nodeName === 'LI' || nodeName === 'UL' || nodeName === 'OL';

        if (wwCodeblockManager.isInCodeBlock(range)) {
          $tempContainer.append(wwCodeblockManager.prepareToPasteOnCodeblock(childNodes));
        } else if (isPastingList) {
          $tempContainer.append(this._prepareToPasteList(childNodes, range, firstBlockIsTaken));
          firstBlockIsTaken = true;
        } else {
          $tempContainer.append(childNodes.shift());
        }
      }

      $container.html($tempContainer.html());
    }

    /**
     * Wrap orphan node(inline, text) with div element
     * @param {jQuery} $container - clipboard container
     * @memberof WwPasteContentHelper
     * @returns {DocumentFragment}
     * @private
     */

  }, {
    key: '_wrapOrphanNodeWithDiv',
    value: function _wrapOrphanNodeWithDiv($container) {
      var $tempContainer = (0, _jquery2.default)('<div />');
      var array = _tuiCodeSnippet2.default.toArray($container[0].childNodes);
      var currentDiv = void 0;

      _tuiCodeSnippet2.default.forEachArray(array, function (node) {
        var isTextNode = node.nodeType === 3;
        /* eslint-disable max-len */
        var isInlineNode = /^(SPAN|A|CODE|EM|I|STRONG|B|S|ABBR|ACRONYM|CITE|DFN|KBD|SAMP|VAR|BDO|Q|SUB|SUP)$/ig.test(node.tagName);
        /* eslint-enable max-len */

        if (isTextNode || isInlineNode) {
          if (!currentDiv) {
            currentDiv = document.createElement('div');
            $tempContainer.append(currentDiv);
            // newFrag.appendChild(currentDiv);
          }

          currentDiv.appendChild(node);
        } else {
          if (currentDiv && currentDiv.lastChild.tagName !== 'BR') {
            currentDiv.appendChild((0, _jquery2.default)('<br/>')[0]);
          }

          currentDiv = null;
          $tempContainer.append(node);
          // newFrag.appendChild(node);
        }
      });

      return $tempContainer.html();
    }

    /**
     * Processing paste data after paste
     * @param {jQuery} $container - clipboard container
     * @memberof WwPasteContentHelper
     * @private
     */

  }, {
    key: '_pasteFirstAid',
    value: function _pasteFirstAid($container) {
      var _this = this;

      var blockTags = 'div, section, article, aside, nav, menus, p';

      $container.html((0, _htmlSanitizer2.default)($container.html(), true));

      $container.find('*').each(function (i, node) {
        _this._removeStyles(node);
      });

      this._unwrapIfNonBlockElementHasBr($container);
      this._unwrapNestedBlocks($container, blockTags);
      this._removeUnnecessaryBlocks($container, blockTags);

      $container.html(this._wrapOrphanNodeWithDiv($container));

      this._preElementAid($container);

      this._tableElementAid($container);

      $container.children('br').remove();
    }

    /**
     * PRE tag formatting
     * @memberof WwPasteContentHelper
     * @private
     * @param {jQuery} $container - clipboard container
     */

  }, {
    key: '_preElementAid',
    value: function _preElementAid($container) {
      var wwCodeblockManager = this.wwe.componentManager.getManager('codeblock');

      wwCodeblockManager.splitCodeblockToEachLine($container);
    }

    /**
     * Unwrap span children of document fragment with div element
     * @param {jQuery} $container - clipboard container
     * @memberof WwPasteContentHelper
     * @private
     */

  }, {
    key: '_unwrapIfNonBlockElementHasBr',
    value: function _unwrapIfNonBlockElementHasBr($container) {
      var nonBlockElements = $container.find('span, a, b, em, i, s');

      nonBlockElements.each(function (i, node) {
        var brChildren = (0, _jquery2.default)(node).children('br');

        if (brChildren.length && node.nodeName !== 'LI' && node.nodeName !== 'UL') {
          brChildren.eq(0).unwrap();
        }
      });
    }

    /**
     * Unwrap nested block elements
     * @param {jQuery} $container - clipboard container
     * @param {string} blockTags - Tag names of block tag
     * @private
     */

  }, {
    key: '_unwrapNestedBlocks',
    value: function _unwrapNestedBlocks($container, blockTags) {
      var $leafElements = $container.find(':not(:has(*))').not('b,s,i,em,code,span');

      $leafElements.each(function (i, node) {
        var leafElement = node.nodeName === 'BR' ? (0, _jquery2.default)(node.parentNode) : (0, _jquery2.default)(node);

        while (leafElement.parents(blockTags).length) {
          var $parent = leafElement.parent(blockTags);

          if ($parent.length && $parent[0] !== $container[0]) {
            leafElement.unwrap();
          } else {
            leafElement = leafElement.parent();
          }
        }
      });
    }

    /**
     * Remove unnecessary block element in pasting data
     * @param {jQuery} $container - clipboard container
     * @param {string} blockTags - Tag names of block tag
     * @memberof WwPasteContentHelper
     * @private
     */

  }, {
    key: '_removeUnnecessaryBlocks',
    value: function _removeUnnecessaryBlocks($container, blockTags) {
      $container.find(blockTags).each(function (index, blockElement) {
        var $blockElement = (0, _jquery2.default)(blockElement);
        var tagName = blockElement.tagName;

        var isDivElement = tagName === 'DIV';
        var isInListItem = $blockElement.parent('li').length !== 0;
        var isInBlockquote = $blockElement.parent('blockquote').length !== 0;
        var hasBlockChildElement = $blockElement.children(blockTags).length;

        if (isDivElement && (isInListItem || isInBlockquote || !hasBlockChildElement)) {
          return;
        }

        $blockElement.replaceWith($blockElement.html());
      });
    }

    /**
     * Remove inline style
     * @param {Node} node Node for remove style attribute
     * @memberof WwPasteContentHelper
     * @private
     */

  }, {
    key: '_removeStyles',
    value: function _removeStyles(node) {
      var $node = (0, _jquery2.default)(node);
      var colorValue = void 0;

      if (_domUtils2.default.getNodeName($node[0]) !== 'SPAN') {
        $node.removeAttr('style');
      } else {
        // Most browser return computed color value even if without style attribute
        if ($node.attr('style')) {
          colorValue = $node.css('color');
        }

        $node.removeAttr('style');

        if (colorValue) {
          $node.css('color', colorValue);
        } else {
          $node.contents().unwrap();
        }
      }
    }

    /**
     * Processing before paste list
     * @param {Array.<HTMLElement>} nodes Pasting data
     * @param {object} rangeInfo Range information
     * @param {boolean} firstBlockIsTaken Whether first block element taken or not
     * @returns {DocumentFragment}
     * @memberof WwPasteContentHelper
     * @private
     */

  }, {
    key: '_prepareToPasteList',
    value: function _prepareToPasteList(nodes, rangeInfo, firstBlockIsTaken) {
      var nodeName = _domUtils2.default.getNodeName(nodes[0]);
      var node = nodes.shift();
      var newFragment = this.wwe.getEditor().getDocument().createDocumentFragment();

      // IE somethimes returns ul without li
      if (nodeName !== 'LI' && nodes.length && nodes[0].tagName === 'LI') {
        nodeName = 'LI';

        node = this._makeNodeAndAppend({
          tagName: nodeName
        }, node);
      }

      // pasting list into list, we should care indentation
      if (nodeName === 'OL' || nodeName === 'UL') {
        // ignore cursor if pasting data has block
        if (!firstBlockIsTaken && this.wwe.getEditor().hasFormat('LI')) {
          (0, _jquery2.default)(newFragment).append(this._wrapCurrentFormat(node));
        } else {
          (0, _jquery2.default)(newFragment).append(node);
        }
      } else if (nodeName === 'LI') {
        // handle list group
        var listGroup = this.wwe.getEditor().getDocument().createDocumentFragment();
        listGroup.appendChild(node);

        while (nodes.length && nodes[0].tagName === 'LI') {
          listGroup.appendChild(nodes.shift());
        }

        // pasting list into list, we should care indentation
        // ignore cursor if pasting data has block
        if (!firstBlockIsTaken && this.wwe.getEditor().hasFormat('LI')) {
          (0, _jquery2.default)(newFragment).append(this._wrapCurrentFormat(listGroup));
        } else if (rangeInfo && (rangeInfo.commonAncestorName === 'UL' || rangeInfo.commonAncestorName === 'OL')) {
          (0, _jquery2.default)(newFragment).append(this._makeNodeAndAppend({
            tagName: rangeInfo.commonAncestorName
          }, listGroup));
          // list from outside
        } else {
          (0, _jquery2.default)(newFragment).append(this._makeNodeAndAppend({
            tagName: 'UL'
          }, listGroup));
        }
      }

      return newFragment;
    }

    /**
     * Unwrap fragment first child for pasting node inline
     * @memberof WwPasteContentHelper
     * @private
     * @param {Node} node Pasting DocumentFragment
     * @returns {NodeList}
     */

  }, {
    key: '_unwrapFragmentFirstChildForPasteAsInline',
    value: function _unwrapFragmentFirstChildForPasteAsInline(node) {
      (0, _jquery2.default)(node).find('br').remove();

      return node.childNodes;
    }

    /**
     * Wrap nodes with current format
     * @param {DocumentFragment} nodes P
     * @returns {HTMLElement}
     * @private
     */

  }, {
    key: '_wrapCurrentFormat',
    value: function _wrapCurrentFormat(nodes) {
      var _this2 = this;

      var currentTagName = void 0;

      // expand to pasting area
      this._eachCurrentPath(function (path) {
        if (path.tagName !== 'DIV') {
          if (_domUtils2.default.isElemNode(nodes)) {
            currentTagName = nodes.tagName;
          } else {
            currentTagName = nodes.firstChild.tagName;
          }

          if (path.tagName !== currentTagName) {
            nodes = _this2._makeNodeAndAppend(path, nodes);
          }
        }
      });

      return nodes;
    }
  }, {
    key: '_eachCurrentPath',
    value: function _eachCurrentPath(iteratee) {
      var paths = _domUtils2.default.getPath(this.wwe.getEditor().getSelection().startContainer, this.wwe.get$Body()[0]);

      for (var i = paths.length - 1; i > -1; i -= 1) {
        iteratee(paths[i]);
      }
    }

    /** _makeNodeAndAppend
     * make node and append their own children
     * @param {HTMLElement} pathInfo HTMLElement to make
     * @param {HTMLElement} content Nodes to append
     * @returns {HTMLElement} node
     * @memberof WwPasteContentHelper
     * @private
     */

  }, {
    key: '_makeNodeAndAppend',
    value: function _makeNodeAndAppend(pathInfo, content) {
      var node = (0, _jquery2.default)('<' + pathInfo.tagName + '/>');

      node.append(content);

      if (pathInfo.id) {
        node.attr('id', pathInfo.id);
      }

      if (pathInfo.className) {
        node.addClass(pathInfo.className);
      }

      return node[0];
    }

    /**
     * Pasting table element pre-process
     * @param {jQuery} $container - clipboard container
     * @memberof WwPasteContentHelper
     * @private
     */

  }, {
    key: '_tableElementAid',
    value: function _tableElementAid($container) {
      this._removeColgroup($container);
      this._completeTableIfNeed($container);
      this._updateTableIDClassName($container);
    }

    /**
     * Remove colgroup tag
     * @param {jQuery} $container - clipboard container
     * @memberof WwPasteContentHelper
     * @private
     **/

  }, {
    key: '_removeColgroup',
    value: function _removeColgroup($container) {
      $container.find('colgroup').remove();
    }

    /**
     * Complete and append table to fragment
     * @param {jQuery} $container - clipboard container
     * @private
     */

  }, {
    key: '_completeTableIfNeed',
    value: function _completeTableIfNeed($container) {
      var tableManager = this.wwe.componentManager.getManager('table');
      var wrapperTr = tableManager.wrapDanglingTableCellsIntoTrIfNeed($container);

      if (wrapperTr) {
        $container.append(wrapperTr);
      }

      var wrapperTbody = tableManager.wrapTrsIntoTbodyIfNeed($container);

      if (wrapperTbody) {
        $container.append(wrapperTbody);
      }

      var wrapperTable = tableManager.wrapTheadAndTbodyIntoTableIfNeed($container);

      if (wrapperTable) {
        $container.append(wrapperTable);
      }
    }

    /**
     * Update table ID class name in fragment
     * @param {jQuery} $container - clipboard container
     * @private
     */

  }, {
    key: '_updateTableIDClassName',
    value: function _updateTableIDClassName($container) {
      var tableManager = this.wwe.componentManager.getManager('table');

      $container.find('table').each(function (index, table) {
        (0, _jquery2.default)(table).removeClass(function (idx, className) {
          return className.replace(/.*\s*(te-content-table-\d+)\s*.*/, '$1');
        });
      });

      $container.find('table').each(function (index, table) {
        (0, _jquery2.default)(table).addClass(tableManager.getTableIDClassName());
      });
    }
  }]);

  return WwPasteContentHelper;
}();

exports.default = WwPasteContentHelper;

/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements wysiwyg list manager
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _domUtils = __webpack_require__(4);

var _domUtils2 = _interopRequireDefault(_domUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var FIND_LI_ELEMENT = /<li/i;
var DIV_OR_LI = 'DIV,LI';
var UL_OR_OL = 'OL,UL';

/**
 * Class WwListManager
 */

var WwListManager = function () {
  /**
   * Creates an instance of WwListManager.
   * @param {WysiwygEditor} wwe - WysiwygEditor instance
   * @memberof WwListManager
   */
  function WwListManager(wwe) {
    _classCallCheck(this, WwListManager);

    this.wwe = wwe;
    this.eventManager = wwe.eventManager;

    /**
     * Name property
     * @memberof WwListManager#
     * @type {string}
     */
    this.name = 'list';

    this._init();
  }

  /**
   * _init
   * Initialize
   * @memberof WwListManager
   * @private
   */


  _createClass(WwListManager, [{
    key: '_init',
    value: function _init() {
      this._initEvent();
      this._initKeyHandler();
    }

    /**
     * _initEvent
     * Initialize event
     * @memberof WwListManager
     * @private
     */

  }, {
    key: '_initEvent',
    value: function _initEvent() {
      var _this = this;

      this.eventManager.listen('wysiwygSetValueBefore', function (html) {
        return _this._convertToArbitraryNestingList(html);
      });

      this.eventManager.listen('wysiwygRangeChangeAfter', function () {
        _this._findAndRemoveEmptyList();
        _this._removeBranchListAll();
      });

      this.eventManager.listen('wysiwygSetValueAfter', function () {
        _this._removeBranchListAll();
      });

      this.eventManager.listen('wysiwygProcessHTMLText', function (html) {
        html = _this._insertBlankToBetweenSameList(html);
        html = _this._convertFromArbitraryNestingList(html);

        return html;
      });

      this.eventManager.listen('convertorAfterHtmlToMarkdownConverted', function (markdown) {
        return markdown.replace(/:BLANK_LINE:\n/g, '');
      });
    }
  }, {
    key: '_initKeyHandler',
    value: function _initKeyHandler() {
      var _this2 = this;

      this.wwe.addKeyEventHandler('TAB', function (ev, range) {
        var isNeedNext = void 0;

        if (range.collapsed) {
          if (_this2.wwe.getEditor().hasFormat('LI')) {
            ev.preventDefault();
            _this2.eventManager.emit('command', 'Indent');

            isNeedNext = false;
          }
        }

        return isNeedNext;
      });

      this.wwe.addKeyEventHandler('SHIFT+TAB', function (ev, range) {
        var isNeedNext = void 0;

        if (range.collapsed) {
          if (_this2.wwe.getEditor().hasFormat('LI')) {
            ev.preventDefault();
            var $ul = (0, _jquery2.default)(range.startContainer).closest('li').children(UL_OR_OL);

            _this2.eventManager.emit('command', 'Outdent');

            if ($ul.length && !$ul.prev().length) {
              _this2._removeBranchList($ul);
            }

            isNeedNext = false;
          }
        }

        return isNeedNext;
      });

      this.wwe.addKeyEventHandler('ENTER', function (ev, range) {
        if (range.collapsed) {
          if (_this2.wwe.getEditor().hasFormat('LI')) {
            _this2.wwe.defer(function () {
              var afterRange = _this2.wwe.getRange();
              var $li = (0, _jquery2.default)(afterRange.startContainer).parents('li').eq(0);
              _this2._removeBranchListAll($li);
            });
          }
        }
      });

      this.wwe.addKeyEventHandler('BACK_SPACE', function (ev, range) {
        if (range.collapsed) {
          if (_this2.wwe.getEditor().hasFormat('LI')) {
            _this2.wwe.defer(function () {
              _this2._removeBranchListAll();
            });
          }
        }
      });
    }

    /**
     * Find empty list for whole container and remove it.
     * @memberof WwListManager
     * @private
     */

  }, {
    key: '_findAndRemoveEmptyList',
    value: function _findAndRemoveEmptyList() {
      this.wwe.get$Body().find(UL_OR_OL).each(function (index, node) {
        if (!FIND_LI_ELEMENT.test(node.innerHTML)) {
          (0, _jquery2.default)(node).remove();
        }
      });
    }

    /**
     * Remove branch lists all from body
     * @memberof WwListManager
     * @private
     * @param {jQuery|HTMLElement} $root root to remove branch list
     */

  }, {
    key: '_removeBranchListAll',
    value: function _removeBranchListAll($root) {
      var _this3 = this;

      $root = !$root ? this.wwe.get$Body() : (0, _jquery2.default)($root);

      $root.find('li ul, li ol').each(function (idx, node) {
        if (!node || node.previousSibling) {
          return;
        }
        _this3._removeBranchList(node);
      });
    }

    /**
     * Remove branch list of passed list(ul, ol)
     * @memberof WwListManager
     * @param {HTMLElement} list list
     * @private
     */

  }, {
    key: '_removeBranchList',
    value: function _removeBranchList(list) {
      var $list = (0, _jquery2.default)(list);
      var $branchRoot = $list;

      while (!$branchRoot[0].previousSibling && $branchRoot[0].parentElement.tagName.match(/UL|OL|LI/g)) {
        $branchRoot = $branchRoot.parent();
      }

      var $firstLi = $branchRoot.children('li').eq(0);

      $branchRoot.prepend($list.children().unwrap());

      $firstLi.remove();
    }
  }, {
    key: '_insertBlankToBetweenSameList',
    value: function _insertBlankToBetweenSameList(html) {
      return html.replace(/<\/(ul|ol)>(<br \/>|<br>){0,}<\1>/g, '</$1>:BLANK_LINE:<$1>');
    }

    /**
     * make arbitrary nesting list out of standard list
     * `<ul><li>text<ul><li>text2</li></ul></li></ul>` to
     * `<ul><li>text</li><ul><li>text2</li></ul></ul>`
     * @param {string} html string to convert
     * @returns {string} converted HTML text
     * @private
     */

  }, {
    key: '_convertToArbitraryNestingList',
    value: function _convertToArbitraryNestingList(html) {
      var NESTED_LIST_QUERY = 'li > ul, li > ol';
      var wrapper = document.createElement('div');
      wrapper.innerHTML = html;

      var nestedList = wrapper.querySelector(NESTED_LIST_QUERY);
      while (nestedList !== null) {
        var parentLI = nestedList.parentNode;
        var parentList = parentLI.parentNode;

        parentList.insertBefore(nestedList, parentLI.nextElementSibling);

        nestedList = wrapper.querySelector(NESTED_LIST_QUERY);
      }

      return wrapper.innerHTML;
    }

    /**
     * make standard list out of arbitrary nesting list
     * `<ul><li>text<ul><li>text2</li></ul></li></ul>` from
     * `<ul><li>text</li><ul><li>text2</li></ul></ul>`
     * @param {string} html string to convert
     * @returns {string} converted HTML text
     * @private
     */

  }, {
    key: '_convertFromArbitraryNestingList',
    value: function _convertFromArbitraryNestingList(html) {
      var NESTED_LIST_QUERY = 'ol > ol, ol > ul, ul > ol, ul > ul';
      var wrapperDiv = document.createElement('div');
      wrapperDiv.innerHTML = html;

      var nestedList = wrapperDiv.querySelector(NESTED_LIST_QUERY);
      while (nestedList !== null) {
        var prevLI = nestedList.previousElementSibling;
        while (prevLI.tagName !== 'LI') {
          prevLI = prevLI.previousElementSibling;
        }

        prevLI.appendChild(nestedList);

        nestedList = wrapperDiv.querySelector(NESTED_LIST_QUERY);
      }

      return wrapperDiv.innerHTML;
    }

    /**
     * Return lines in selection
     * @param {Node} start Start element
     * @param {Node} end End element
     * @param {HTMLElement} body Editor body element
     * @returns {Array.<HTMLElement>}
     * @private
     */

  }, {
    key: 'getLinesOfSelection',
    value: function getLinesOfSelection(start, end) {
      var lines = [];
      var isLastLine = false;
      var needNext = true;
      var nextLine = void 0;

      if (_domUtils2.default.isTextNode(start)) {
        start = (0, _jquery2.default)(start).parents(DIV_OR_LI).first().get(0);
      }

      if (_domUtils2.default.isTextNode(end)) {
        end = (0, _jquery2.default)(end).parents(DIV_OR_LI).first().get(0);
      }

      for (var line = start; needNext; line = nextLine) {
        if ((0, _jquery2.default)(line).is(DIV_OR_LI)) {
          lines.push(line);

          if (line === end) {
            isLastLine = true;
          } else {
            nextLine = this._getNextLine(line, end);
          }
        } else {
          break;
        }
        needNext = nextLine && !isLastLine;
      }

      return lines;
    }

    /**
     * get next line
     * @param {Node} currentLine - current line node
     * @param {Node} end - last node in selection
     * @returns {Node} - next line node
     * @private
     */

  }, {
    key: '_getNextLine',
    value: function _getNextLine(currentLine, end) {
      var nextLine = currentLine.nextElementSibling;

      if (!nextLine) {
        // current line was the last line in ul/ol
        // while we have lines those has not been processed yet.
        nextLine = currentLine.parentNode.nextElementSibling;
      } else if ((0, _jquery2.default)(nextLine).is(UL_OR_OL)) {
        // we don't sure firstChild is LI. arbtrary list can have another ol/ul
        nextLine = nextLine.querySelector('li');
      }

      if ((0, _jquery2.default)(nextLine).is(DIV_OR_LI) || nextLine === end) {
        return nextLine;
      }

      return this._getNextLine(nextLine);
    }

    /**
     * merge to previous list
     * consider remove this function when https://github.com/neilj/Squire/issues/294 resolved
     * @param {HTMLLIElement} currentLine - current li element
     * @ignore
     */

  }, {
    key: 'mergeList',
    value: function mergeList(currentLine) {
      var currentList = currentLine.parentNode;
      var prevList = currentList.previousElementSibling;
      var nextList = currentList.nextElementSibling;

      if (currentList.firstElementChild === currentLine) {
        if (prevList && (0, _jquery2.default)(prevList).is(UL_OR_OL)) {
          this._mergeList(currentList, prevList);
          currentList = prevList;
        }
      }

      if (currentList.lastElementChild === currentLine) {
        if (nextList && (0, _jquery2.default)(nextList).is(UL_OR_OL)) {
          this._mergeList(nextList, currentList);
        }
      }
    }

    /**
     * merge list to targetList
     * @param {HTMLOListElement|HTMLUListElement} list - list to merge
     * @param {HTMLOListElement|HTMLUListElement} targetList - target list
     * @ignore
     */

  }, {
    key: '_mergeList',
    value: function _mergeList(list, targetList) {
      var listItem = list.firstElementChild;

      if (targetList && (0, _jquery2.default)(targetList).is(UL_OR_OL)) {
        while (listItem) {
          var temp = listItem.nextElementSibling;
          targetList.appendChild(listItem);
          listItem = temp;
        }

        list.parentNode.removeChild(list);
      }
    }
  }]);

  return WwListManager;
}();

exports.default = WwListManager;

/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements wysiwyg task manager
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var TASK_CLASS_NAME = 'task-list-item';
var TASK_ATTR_NAME = 'data-te-task';
var TASK_CHECKED_CLASS_NAME = 'checked';

/**
 * Class WwTaskManager
 */

var WwTaskManager = function () {
  /**
   * Creates an instance of WwTaskManager.
   * @param {WysiwygEditor} wwe - WysiwygEditor instance
   * @memberof WwTaskManager
   */
  function WwTaskManager(wwe) {
    _classCallCheck(this, WwTaskManager);

    this.wwe = wwe;
    this.eventManager = wwe.eventManager;

    /**
     * Name property
     * @memberof WwTaskManager#
     * @type {string}
     */
    this.name = 'task';

    this._init();
  }

  /**
   * _init
   * Init
   * @memberof WwTaskManager
   * @private
   */


  _createClass(WwTaskManager, [{
    key: '_init',
    value: function _init() {
      this._initKeyHandler();
      this._initEvent();

      this.wwe.getEditor().addEventListener('mousedown', function (ev) {
        var isOnTaskBox = ev.offsetX < 18 && ev.offsetY < 18;

        if (ev.target.hasAttribute(TASK_ATTR_NAME) && isOnTaskBox) {
          (0, _jquery2.default)(ev.target).toggleClass(TASK_CHECKED_CLASS_NAME);
        }
      });
    }

    /**
     * _initEvent
     * Initialize event
     * @memberof WwTaskManager
     * @private
     */

  }, {
    key: '_initEvent',
    value: function _initEvent() {
      var _this = this;

      this.eventManager.listen('wysiwygSetValueAfter', function () {
        _this._removeTaskListClass();
      });
    }

    /**
     * _initKeyHandler
     * Initialize key event handler
     * @memberof WwTaskManager
     * @private
     */

  }, {
    key: '_initKeyHandler',
    value: function _initKeyHandler() {
      var _this2 = this;

      this.wwe.addKeyEventHandler('ENTER', function (ev, range) {
        if (_this2.isInTaskList(range)) {
          _this2.wwe.defer(function () {
            var newRange = _this2.wwe.getRange();
            var $li = (0, _jquery2.default)(newRange.startContainer).closest('li');
            $li.removeClass(TASK_CHECKED_CLASS_NAME);
          });
        }
      });
    }

    /**
     * isInTaskList
     * Check whether passed range is in task list or not
     * @param {Range} range range
     * @returns {boolean} result
     * @memberof WwTaskManager
     */

  }, {
    key: 'isInTaskList',
    value: function isInTaskList(range) {
      var li = void 0;

      if (!range) {
        range = this.wwe.getEditor().getSelection().cloneRange();
      }

      if (range.startContainer.nodeType === Node.ELEMENT_NODE && range.startContainer.tagName === 'LI') {
        li = range.startContainer;
      } else {
        li = (0, _jquery2.default)(range.startContainer).parents('li').get(0);
      }

      return (0, _jquery2.default)(li).hasClass(TASK_CLASS_NAME);
    }

    /**
     * unformatTask
     * Unforamt task
     * @param {Node} node target
     * @memberof WwTaskManager
     */

  }, {
    key: 'unformatTask',
    value: function unformatTask(node) {
      var $li = (0, _jquery2.default)(node).closest('li');

      $li.removeClass(TASK_CLASS_NAME);
      $li.removeClass(TASK_CHECKED_CLASS_NAME);

      $li.removeAttr(TASK_ATTR_NAME);

      if (!$li.attr('class')) {
        $li.removeAttr('class');
      }
    }

    /**
     * formatTask
     * Format task
     * @param {Node} node target
     * @memberof WwTaskManager
     */

  }, {
    key: 'formatTask',
    value: function formatTask(node) {
      var $selected = (0, _jquery2.default)(node);
      var $li = $selected.closest('li');

      $li.addClass(TASK_CLASS_NAME);
      $li.attr(TASK_ATTR_NAME, '');
    }

    /**
     * _formatTaskIfNeed
     * Format task if current range has task class name
     * @memberof WwTaskManager
     * @private
     */

  }, {
    key: '_formatTaskIfNeed',
    value: function _formatTaskIfNeed() {
      var range = this.wwe.getEditor().getSelection().cloneRange();

      if (this.isInTaskList(range)) {
        this.formatTask(range.startContainer);
      }
    }

    /**
     * _removeTaskListClass
     * Remove tasklist class
     * @memberof WwTaskManager
     * @private
     */

  }, {
    key: '_removeTaskListClass',
    value: function _removeTaskListClass() {
      // because task-list class is block merge normal list and task list
      this.wwe.get$Body().find('.task-list').each(function (index, node) {
        (0, _jquery2.default)(node).removeClass('task-list');
      });
    }
  }]);

  return WwTaskManager;
}();

exports.default = WwTaskManager;

/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements wysiwyg hr manager
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _domUtils = __webpack_require__(4);

var _domUtils2 = _interopRequireDefault(_domUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Class WwHrManager
 */
var WwHrManager = function () {
  /**
   * Creates an instance of WwHrManager.
   * @param {WysiwygEditor} wwe - WysiwygEditor instance
   * @memberof WwHrManager
   */
  function WwHrManager(wwe) {
    _classCallCheck(this, WwHrManager);

    this.wwe = wwe;
    this.eventManager = wwe.eventManager;

    /**
     * Name property
     * @memberof WwHrManager#
     * @type {string}
     */
    this.name = 'hr';

    this._init();
  }

  /**
   * _init
   * Initialize
   * @memberof WwHrManager
   * @private
   */


  _createClass(WwHrManager, [{
    key: '_init',
    value: function _init() {
      this._initKeyHandler();
      this._initEvent();
    }

    /**
     * _initEvent
     * Initialize eventmanager event
     * @memberof WwHrManager
     * @private
     */

  }, {
    key: '_initEvent',
    value: function _initEvent() {
      var _this = this;

      this.eventManager.listen('wysiwygSetValueAfter', function () {
        _this._unwrapDivOnHr();
      });

      this.eventManager.listen('wysiwygGetValueBefore', function () {
        _this._wrapDefaultBlockToOrphanTexts();
      });
    }

    /**
     * _initKeyHandler
     * Initialize key event handler
     * @memberof WwHrManager
     * @private
     */

  }, {
    key: '_initKeyHandler',
    value: function _initKeyHandler() {
      var _this2 = this;

      this.wwe.addKeyEventHandler(function (ev, range) {
        return _this2._onTypedInHr(range);
      });

      this.wwe.addKeyEventHandler('ENTER', function (ev, range) {
        if (range.collapsed) {
          return _this2._removeHrOnEnter(range, ev);
        }

        return true;
      });

      this.wwe.addKeyEventHandler('BACK_SPACE', function (ev, range) {
        if (range.collapsed) {
          return _this2._removeHrOnBackspace(range, ev);
        }

        return true;
      });
    }

    /**
     * _isInHr
     * Check whether passed range is in hr or not
     * @param {Range} range range
     * @returns {boolean} result
     * @memberof WwHrManager
     * @private
     */

  }, {
    key: '_isInHr',
    value: function _isInHr(range) {
      return _domUtils2.default.getNodeName(range.startContainer.childNodes[range.startOffset]) === 'HR';
    }

    /**
     * _isNearHr
     * Check whether passed range is near hr or not
     * @param {Range} range range
     * @returns {boolean} result
     * @memberof WwHrManager
     * @private
     */

  }, {
    key: '_isNearHr',
    value: function _isNearHr(range) {
      var prevNode = _domUtils2.default.getChildNodeByOffset(range.startContainer, range.startOffset - 1);

      return _domUtils2.default.getNodeName(prevNode) === 'HR';
    }

    /**
     * Handler for delete HR when user typing within
     * @param {Range} range Range object
     * @memberof WwHrManager
     * @private
     */

  }, {
    key: '_onTypedInHr',
    value: function _onTypedInHr(range) {
      var _this3 = this;

      // in case user try to input above hr
      if (this._isInHr(range) || this._isNearHr(range)) {
        this.wwe.defer(function (wwe) {
          wwe.saveSelection();
          _this3._wrapDefaultBlockToOrphanTexts();
          wwe.restoreSavedSelection();
        });
      }
    }

    /**
     * _removeHrOnEnter
     * Remove hr if need on enter
     * @param {Range} range range
     * @param {Event} ev event
     * @returns {boolean} return true if hr was removed
     * @memberof WwHrManager
     * @private
     */

  }, {
    key: '_removeHrOnEnter',
    value: function _removeHrOnEnter(range, ev) {
      var hrSuspect = void 0,
          blockPosition = void 0;

      if (this._isInHr(range)) {
        hrSuspect = _domUtils2.default.getChildNodeByOffset(range.startContainer, range.startOffset);
      } else if (this._isNearHr(range)) {
        hrSuspect = _domUtils2.default.getChildNodeByOffset(range.startContainer, range.startOffset - 1);
        blockPosition = 'before';
      }

      return this._changeHrToNewDefaultBlock(hrSuspect, range, ev, blockPosition);
    }

    /**
     * _removeHrOnBackspace
     * Remove hr if need on backspace
     * @param {Range} range range
     * @param {Event} ev event
     * @returns {boolean} return true if hr was removed
     * @memberof WwHrManager
     * @private
     */

  }, {
    key: '_removeHrOnBackspace',
    value: function _removeHrOnBackspace(range, ev) {
      var hrSuspect = void 0,
          blockPosition = void 0;

      if (this._isInHr(range)) {
        hrSuspect = _domUtils2.default.getChildNodeByOffset(range.startContainer, range.startOffset);
      } else if (range.startOffset === 0) {
        hrSuspect = _domUtils2.default.getTopPrevNodeUnder(range.startContainer, this.wwe.get$Body()[0]);
        blockPosition = 'none';
      } else if (this._isNearHr(range)) {
        hrSuspect = _domUtils2.default.getChildNodeByOffset(range.startContainer, range.startOffset - 1);
        blockPosition = 'before';
      }

      return this._changeHrToNewDefaultBlock(hrSuspect, range, ev, blockPosition);
    }

    /**
     * _changeHrToNewDefaultBlock
     * Remove hr and add new default block then set range to it
     * @param {Node} hrSuspect Node could be hr
     * @param {Range} range range
     * @param {Event} ev event
     * @param {strong} newBlockPosition new default block add position
     * @returns {boolean} return true if hr was removed
     * @memberof WwHrManager
     * @private
     */

  }, {
    key: '_changeHrToNewDefaultBlock',
    value: function _changeHrToNewDefaultBlock(hrSuspect, range, ev, newBlockPosition) {
      if (hrSuspect && _domUtils2.default.getNodeName(hrSuspect) === 'HR') {
        ev.preventDefault();

        if (newBlockPosition !== 'none') {
          this.wwe.breakToNewDefaultBlock(range, newBlockPosition);
        }

        (0, _jquery2.default)(hrSuspect).remove();

        return false;
      }

      return true;
    }

    /**
     * _unwrapDivOnHr
     * Unwrap default block on hr
     * @memberof WwHrManager
     * @private
     */

  }, {
    key: '_unwrapDivOnHr',
    value: function _unwrapDivOnHr() {
      var editorContentBody = this.wwe.get$Body().get(0);
      this.wwe.get$Body().find('hr').each(function (index, node) {
        var parentDiv = (0, _jquery2.default)(node).parent('div');
        if (parentDiv[0] !== editorContentBody) {
          parentDiv.find('br').remove();
          (0, _jquery2.default)(node).unwrap();
        }
      });
    }

    /**
     * _wrapDefaultBlockToOrphanTexts
     * Wrap default block to orphan texts
     * mainly, this is used for orphan text that made by controlling hr
     * @memberof WwHrManager
     * @private
     */

  }, {
    key: '_wrapDefaultBlockToOrphanTexts',
    value: function _wrapDefaultBlockToOrphanTexts() {
      var textNodes = this.wwe.get$Body().contents().filter(findTextNodeFilter);

      textNodes.each(function (i, node) {
        (0, _jquery2.default)(node).wrap('<div />');
      });
    }
  }]);

  return WwHrManager;
}();

/**
 * findTextNodeFilter
 * @function
 * @this Node
 * @returns {boolean}
 * @ignore
 */


function findTextNodeFilter() {
  return this.nodeType === Node.TEXT_NODE;
}

exports.default = WwHrManager;

/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements wysiwyg p tag manager
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Class WwPManager
 */
var WwPManager = function () {
  /**
   * Creates an instance of WwPManager.
   * @param {WysiwygEditor} wwe - wysiwygEditor instance
   * @memberof WwPManager
   */
  function WwPManager(wwe) {
    _classCallCheck(this, WwPManager);

    this.wwe = wwe;
    this.eventManager = wwe.eventManager;

    /**
     * Name property
     * @memberof WwPManager#
     * @type {string}
     */
    this.name = 'p';

    this._initEvent();
  }

  /**
   * _initEvent
   * Initialize event
   * @memberof WwPManager
   * @private
   */


  _createClass(WwPManager, [{
    key: '_initEvent',
    value: function _initEvent() {
      var _this = this;

      this.eventManager.listen('wysiwygSetValueBefore', function (html) {
        return _this._splitPtagContentLines(html);
      });

      this.eventManager.listen('wysiwygSetValueAfter', function () {
        _this._ensurePtagContentWrappedWithDiv();
        _this._unwrapPtags();
      });
    }

    /**
     * Split multiple line content of p tags
     * @param {string} html html text
     * @returns {string} result
     * @private
     */

  }, {
    key: '_splitPtagContentLines',
    value: function _splitPtagContentLines(html) {
      if (html) {
        var $wrapper = (0, _jquery2.default)('<div />');

        $wrapper.html(html);
        $wrapper.find('p').each(function (pIndex, para) {
          var content = para.innerHTML;
          var lines = content.split(/<br>/gi);
          var lastIndex = lines.length - 1;
          // cross browsing: old browser not has nextElementSibling attribute
          var nextElement = para.nextElementSibling || para.nextSibling;
          var splitedContent = '';

          splitedContent = lines.map(function (line, index) {
            var result = '';

            if (index > 0 && index < lastIndex) {
              line = line ? line : '<br>';
            }

            if (line) {
              result = '<div>' + line + '</div>';
            }

            return result;
          });

          // For paragraph, we add empty line
          if (nextElement && nextElement.nodeName === 'P') {
            splitedContent.push('<div><br></div>');
          }

          (0, _jquery2.default)(para).replaceWith((0, _jquery2.default)(splitedContent.join('')));
        });
        html = $wrapper.html();
      }

      return html;
    }

    /**
     * _ensurePtagContentWrappedWithDiv
     * Wrap new line inside P tag to DIV, and additional empty line added within too
     * @memberof WwPManager
     * @private
     */

  }, {
    key: '_ensurePtagContentWrappedWithDiv',
    value: function _ensurePtagContentWrappedWithDiv() {
      this.wwe.get$Body().find('p').each(function (index, node) {
        if ((0, _jquery2.default)(node).find('div').length <= 0) {
          (0, _jquery2.default)(node).wrapInner('<div />');
        }

        if ((0, _jquery2.default)(node).next().is('p')) {
          (0, _jquery2.default)(node).append('<div><br></div>');
        }
      });
    }

    /**
     * _unwrapPtags
     * Unwrap P tag
     * @memberof WwPManager
     * @private
     */

  }, {
    key: '_unwrapPtags',
    value: function _unwrapPtags() {
      this.wwe.get$Body().find('div').each(function (index, node) {
        if ((0, _jquery2.default)(node).parent().is('p')) {
          (0, _jquery2.default)(node).unwrap();
        }
      });
    }
  }]);

  return WwPManager;
}();

exports.default = WwPManager;

/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements wysiwyg heading manager
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _domUtils = __webpack_require__(4);

var _domUtils2 = _interopRequireDefault(_domUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var FIND_HEADING_RX = /h[\d]/i;

/**
 * Class WwHeadingManager
 */

var WwHeadingManager = function () {
  /**
   * Creates an instance of WwHeadingManager.
   * @param {WysiwygEditor} wwe - WysiwygEditor instance
   * @memberof WwHeadingManager
   */
  function WwHeadingManager(wwe) {
    _classCallCheck(this, WwHeadingManager);

    this.wwe = wwe;
    this.eventManager = wwe.eventManager;

    /**
     * Name property
     * @memberof WwHeadingManager#
     * @type {string}
     */
    this.name = 'heading';

    this._init();
  }

  /**
   * _init
   * Initialize
   * @memberof WwHeadingManager
   * @private
   */


  _createClass(WwHeadingManager, [{
    key: '_init',
    value: function _init() {
      this._initEvent();
      this._initKeyHandler();
    }
  }, {
    key: '_initEvent',
    value: function _initEvent() {
      var _this = this;

      this.eventManager.listen('wysiwygSetValueAfter', function () {
        _this._wrapDefaultBlockToHeadingInner();
      });
    }

    /**
     * _initKeyHandler
     * Initialize key event handler
     * @memberof WwHeadingManager
     * @private
     */

  }, {
    key: '_initKeyHandler',
    value: function _initKeyHandler() {
      var _this2 = this;

      this.wwe.addKeyEventHandler('ENTER', function (ev, range) {
        if (_this2.wwe.hasFormatWithRx(FIND_HEADING_RX)) {
          _this2._onEnter(ev, range);

          return false;
        }

        return true;
      });

      this.wwe.addKeyEventHandler('BACK_SPACE', function (ev, range) {
        if (_this2.wwe.hasFormatWithRx(FIND_HEADING_RX)) {
          _this2._removePrevTopNodeIfNeed(ev, range);

          return false;
        }

        return true;
      });
    }

    /**
     * _wrapDefaultBlockToHeadingInner
     * Wrap default block to heading inner contents
     * @private
     */

  }, {
    key: '_wrapDefaultBlockToHeadingInner',
    value: function _wrapDefaultBlockToHeadingInner() {
      this.wwe.get$Body().find('h1, h2, h3, h4, h5, h6').each(function (index, node) {
        if ((0, _jquery2.default)(node).children('div, p').length <= 0) {
          (0, _jquery2.default)(node).wrapInner('<div />');
        }
      });
    }

    /**
     * _unwrapHeading
     * Unwrap heading
     * @memberof WwHeadingManager
     * @private
     */

  }, {
    key: '_unwrapHeading',
    value: function _unwrapHeading() {
      this.wwe.unwrapBlockTag(function (node) {
        return FIND_HEADING_RX.test(node);
      });
    }

    /**
     * _onEnter
     * Enter key handler
     * @memberof WwHeadingManager
     * @param {Event} event event object
     * @param {Range} range range
     * @private
     */

  }, {
    key: '_onEnter',
    value: function _onEnter(event, range) {
      var _this3 = this;

      if (range.startOffset > 0) {
        // I hate this but there's no way
        this.wwe.defer(function (wwe) {
          _this3._unwrapHeading();
          wwe.getEditor().removeLastUndoStack();
        });
      } else {
        event.preventDefault();
        this._insertEmptyBlockToPrevious(range);
      }
    }

    /**
     * _insertEmptyBlockToPrevious
     * Insert empty block to previous of passed range
     * @memberof WwHeadingManager
     * @param {Range} range range
     * @private
     */

  }, {
    key: '_insertEmptyBlockToPrevious',
    value: function _insertEmptyBlockToPrevious(range) {
      this.wwe.getEditor().saveUndoState(range);
      (0, _jquery2.default)('<div><br></div>').insertBefore(_domUtils2.default.getParentUntil(range.startContainer, this.wwe.get$Body()[0]));
    }

    /**
     * _removePrevTopNodeIfNeed
     * Remove previous top node if need
     * @memberof WwHeadingManager
     * @param {Event} event event object
     * @param {Range} range range
     * @returns {Boolean} whether needed or not
     * @private
     */

  }, {
    key: '_removePrevTopNodeIfNeed',
    value: function _removePrevTopNodeIfNeed(event, range) {
      var isHandled = false;

      if (range.collapsed && range.startOffset === 0) {
        var startContainer = range.startContainer;

        var prevTopNode = _domUtils2.default.getTopPrevNodeUnder(startContainer, this.wwe.get$Body()[0]);
        var isPrevTopNodeEmpty = prevTopNode && prevTopNode.textContent.length === 0;
        var sq = this.wwe.getEditor();

        if (startContainer.textContent.length === 0) {
          isHandled = this._removeHedingAndChangeSelection(event, range, prevTopNode);
        } else if (isPrevTopNodeEmpty) {
          event.preventDefault();
          sq.saveUndoState(range);

          (0, _jquery2.default)(prevTopNode).remove();
          isHandled = true;
        }
      }

      return isHandled;
    }

    /**
     * Remove heading and change selection
     * @param {object} event Event object
     * @param {Range} range Range object
     * @param {HTMLElement} prevTopNode Previous top node
     * @returns {boolean}
     * @private
     */

  }, {
    key: '_removeHedingAndChangeSelection',
    value: function _removeHedingAndChangeSelection(event, range, prevTopNode) {
      var startContainer = range.startContainer;

      var sq = this.wwe.getEditor();
      var $Body = this.wwe.get$Body();
      var isHeading = FIND_HEADING_RX.test(_domUtils2.default.getNodeName(startContainer));
      var headingElement = isHeading ? startContainer : (0, _jquery2.default)(startContainer).parents('h1,h2,h3,h4,h5,h6')[0];
      var targetNode = prevTopNode;
      var offset = 1;

      if (!event.defaultPrevented) {
        event.preventDefault();
        sq.saveUndoState(range);
      }

      (0, _jquery2.default)(headingElement).remove();

      if (!prevTopNode) {
        targetNode = $Body.children('div').first().get(0);
        offset = 0;
      }

      range.setStart(targetNode, offset);
      range.collapse(true);
      sq.setSelection(range);

      return true;
    }
  }]);

  return WwHeadingManager;
}();

exports.default = WwHeadingManager;

/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _squireRte = __webpack_require__(75);

var _squireRte2 = _interopRequireDefault(_squireRte);

var _domUtils = __webpack_require__(4);

var _domUtils2 = _interopRequireDefault(_domUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements squire extension
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var FIND_BLOCK_TAGNAME_RX = /\b(H[\d]|LI|P|BLOCKQUOTE|TD)\b/;
var isIElt11 = /Trident\/[456]\./.test(navigator.userAgent);

/**
 * Class SquireExt
 * @extends {Squire}
 */

var SquireExt = function (_Squire) {
  _inherits(SquireExt, _Squire);

  /**
   * Creates an instance of SquireExt.
   * @augments Squire
   * @memberof SquireExt
   */
  function SquireExt() {
    var _ref;

    _classCallCheck(this, SquireExt);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var _this = _possibleConstructorReturn(this, (_ref = SquireExt.__proto__ || Object.getPrototypeOf(SquireExt)).call.apply(_ref, [this].concat(args)));

    _this._decorateHandlerToCancelable('copy');
    _this._decorateHandlerToCancelable(isIElt11 ? 'beforecut' : 'cut');
    _this._decorateHandlerToCancelable(isIElt11 ? 'beforepaste' : 'paste');

    _this.get$Body = function () {
      _this.$body = _this.$body || (0, _jquery2.default)(_this.getRoot());

      return _this.$body;
    };
    return _this;
  }

  /**
   * _decorateHandlerToCancelable
   * Decorate squire handler to cancelable cuz sometimes, we dont need squire handler process
   * event.preventDefault() will cancel squire and browser default behavior
   * event.squirePrevented = true will cancel squire but allow browser default behavior
   * @param {string} eventName event name
   * @private
   */


  _createClass(SquireExt, [{
    key: '_decorateHandlerToCancelable',
    value: function _decorateHandlerToCancelable(eventName) {
      var handlers = this._events[eventName];

      if (handlers.length > 1) {
        throw new Error('too many' + eventName + 'handlers in squire');
      }

      var handler = handlers[0].bind(this);

      handlers[0] = function (event) {
        if (!event.defaultPrevented && !event.squirePrevented) {
          handler(event);
        }
      };
    }
  }, {
    key: 'changeBlockFormat',
    value: function changeBlockFormat(srcCondition, targetTagName) {
      var _this2 = this;

      this.modifyBlocks(function (frag) {
        var current = void 0,
            newFrag = void 0,
            newBlock = void 0,
            nextBlock = void 0,
            tagName = void 0,
            lastNodeOfNextBlock = void 0,
            appendChidToNextBlock = void 0;

        // HR is non-block element, so frag don't have it
        // make a default block
        if (frag.childNodes.length) {
          current = frag.childNodes.item(0);
        } else {
          current = _this2.createDefaultBlock();
          frag.appendChild(current);
        }

        if (srcCondition) {
          // find last depth
          while (current.firstChild) {
            current = current.firstChild;
          }

          appendChidToNextBlock = function appendChidToNextBlock(node) {
            nextBlock.appendChild(node);
          };

          // find tag
          while (current !== frag) {
            var _current = current;
            tagName = _current.tagName;


            if (_tuiCodeSnippet2.default.isFunction(srcCondition) ? srcCondition(tagName) : tagName === srcCondition) {
              nextBlock = current.childNodes.item(0);

              // there is no next blocktag
              // eslint-disable-next-line max-depth
              if (!_domUtils2.default.isElemNode(nextBlock) || current.childNodes.length > 1) {
                nextBlock = _this2.createDefaultBlock();

                _tuiCodeSnippet2.default.forEachArray(_tuiCodeSnippet2.default.toArray(current.childNodes), appendChidToNextBlock);

                lastNodeOfNextBlock = nextBlock.lastChild;

                // remove unneccesary br
                // eslint-disable-next-line max-depth
                if (lastNodeOfNextBlock && _domUtils2.default.getNodeName(lastNodeOfNextBlock) === 'BR') {
                  nextBlock.removeChild(lastNodeOfNextBlock);
                }
              }

              // eslint-disable-next-line max-depth
              if (targetTagName) {
                newBlock = _this2.createElement(targetTagName, [nextBlock]);
              } else {
                newBlock = nextBlock;
              }

              newFrag = _this2.getDocument().createDocumentFragment();
              newFrag.appendChild(newBlock);

              frag = newFrag;

              break;
            }

            current = current.parentNode;
          }
        }

        // if source condition node is not founded, we wrap current div node with node named targetTagName
        if ((!newFrag || !srcCondition) && targetTagName && _domUtils2.default.getNodeName(frag.childNodes[0]) === 'DIV') {
          frag = _this2.createElement(targetTagName, [frag.childNodes[0]]);
        }

        return frag;
      });
    }
  }, {
    key: 'changeBlockFormatTo',
    value: function changeBlockFormatTo(targetTagName) {
      this.changeBlockFormat(function (tagName) {
        return FIND_BLOCK_TAGNAME_RX.test(tagName);
      }, targetTagName);
    }
  }, {
    key: 'getCaretPosition',
    value: function getCaretPosition() {
      return this.getCursorPosition();
    }
  }, {
    key: 'replaceSelection',
    value: function replaceSelection(content, selection) {
      if (selection) {
        this.setSelection(selection);
      }

      this._ignoreChange = true;
      this.insertHTML(content);
    }
  }, {
    key: 'replaceRelativeOffset',
    value: function replaceRelativeOffset(content, offset, overwriteLength) {
      var selection = this.getSelection().cloneRange();

      this._replaceRelativeOffsetOfSelection(content, offset, overwriteLength, selection);
    }
  }, {
    key: '_replaceRelativeOffsetOfSelection',
    value: function _replaceRelativeOffsetOfSelection(content, offset, overwriteLength, selection) {
      var startSelectionInfo = void 0,
          endSelectionInfo = void 0,
          finalOffset = void 0;
      var endOffsetNode = selection.endContainer;
      var endTextOffset = selection.endOffset;

      if (_domUtils2.default.getNodeName(endOffsetNode) !== 'TEXT') {
        endOffsetNode = this._getClosestTextNode(endOffsetNode, endTextOffset);

        if (endOffsetNode) {
          if (_domUtils2.default.isTextNode(endOffsetNode)) {
            endTextOffset = endOffsetNode.nodeValue.length;
          } else {
            endTextOffset = endOffsetNode.textContent.length;
          }
        }
      }

      if (endOffsetNode) {
        startSelectionInfo = this.getSelectionInfoByOffset(endOffsetNode, endTextOffset + offset);
        selection.setStart(startSelectionInfo.element, startSelectionInfo.offset);

        finalOffset = endTextOffset + (offset + overwriteLength);
        endSelectionInfo = this.getSelectionInfoByOffset(endOffsetNode, finalOffset);
        selection.setEnd(endSelectionInfo.element, endSelectionInfo.offset);

        this.replaceSelection(content, selection);
      } else {
        this.replaceSelection(content);
      }
    }
  }, {
    key: '_getClosestTextNode',
    value: function _getClosestTextNode(node, offset) {
      var foundNode = _domUtils2.default.getChildNodeByOffset(node, offset - 1);

      if (_domUtils2.default.getNodeName(foundNode) !== 'TEXT') {
        foundNode = foundNode.previousSibling;
      }

      return foundNode;
    }
  }, {
    key: 'getSelectionInfoByOffset',
    value: function getSelectionInfoByOffset(anchorElement, offset) {
      var traceElement = void 0,
          traceElementLength = void 0,
          traceOffset = void 0,
          stepLength = void 0;
      var direction = offset >= 0 ? 'next' : 'previous';
      var offsetAbs = Math.abs(offset);
      var latestAvailableElement = traceElement;

      if (direction === 'next') {
        traceElement = anchorElement;
      } else {
        traceElement = anchorElement.previousSibling;
      }

      traceOffset = offsetAbs;
      stepLength = 0;

      while (traceElement) {
        if (_domUtils2.default.isTextNode(traceElement)) {
          traceElementLength = traceElement.nodeValue.length;
        } else {
          traceElementLength = traceElement.textContent.length;
        }

        stepLength += traceElementLength;

        if (offsetAbs <= stepLength) {
          break;
        }

        traceOffset -= traceElementLength;

        if (_domUtils2.default.getTextLength(traceElement) > 0) {
          latestAvailableElement = traceElement;
        }

        traceElement = traceElement[direction + 'Sibling'];
      }

      if (!traceElement) {
        traceElement = latestAvailableElement;
        traceOffset = _domUtils2.default.getTextLength(traceElement);
      }

      if (direction === 'previous') {
        traceOffset = _domUtils2.default.getTextLength(traceElement) - traceOffset;
      }

      return {
        element: traceElement,
        offset: traceOffset
      };
    }
  }, {
    key: 'getSelectionPosition',
    value: function getSelectionPosition(selection, style, offset) {
      var marker = this.createElement('INPUT');
      var range = selection.cloneRange();
      var endSelectionInfo = this.getSelectionInfoByOffset(selection.endContainer, selection.endOffset + (offset || 0));
      range.setStart(range.startContainer, range.startOffset);
      range.setEnd(endSelectionInfo.element, endSelectionInfo.offset);

      // to prevent squire input event fire
      this._ignoreChange = true;
      this.insertElement(marker, range);

      var pos = (0, _jquery2.default)(marker).offset();

      if (style !== 'over') {
        pos.top += (0, _jquery2.default)(marker).outerHeight();
      }

      marker.parentNode.removeChild(marker);

      selection.setStart(selection.endContainer, selection.endOffset);
      selection.collapse(true);

      this.setSelection(selection);

      return pos;
    }
  }, {
    key: 'removeLastUndoStack',
    value: function removeLastUndoStack() {
      if (this._undoStack.length) {
        this._undoStackLength -= 1;
        this._undoIndex -= 1;
        this._undoStack.pop();
        this._isInUndoState = false;
      }
    }
  }, {
    key: 'replaceParent',
    value: function replaceParent(node, from, to) {
      var target = (0, _jquery2.default)(node).closest(from);

      if (target.length) {
        target.wrapInner('<' + to + '/>');
        target.children().unwrap();
      }
    }
  }, {
    key: 'preserveLastLine',
    value: function preserveLastLine() {
      var lastBlock = this.get$Body().children().last();

      if (_domUtils2.default.getNodeName(lastBlock[0]) !== 'DIV') {
        this._ignoreChange = true;
        (0, _jquery2.default)(this.createDefaultBlock()).insertAfter(lastBlock);
      }
    }
  }, {
    key: 'scrollTop',
    value: function scrollTop(top) {
      if (_tuiCodeSnippet2.default.isUndefined(top)) {
        return this.get$Body().scrollTop();
      }

      return this.get$Body().scrollTop(top);
    }
  }, {
    key: 'isIgnoreChange',
    value: function isIgnoreChange() {
      return this._ignoreChange;
    }
  }, {
    key: 'focus',
    value: function focus() {
      _squireRte2.default.prototype.focus.call(this);
    }
  }, {
    key: 'blockCommandShortcuts',
    value: function blockCommandShortcuts() {
      var _this3 = this;

      var isMac = /Mac/.test(navigator.platform);
      var meta = isMac ? 'meta' : 'ctrl';
      var keys = ['b', 'i', 'u', 'shift-7', 'shift-5', 'shift-6', 'shift-8', 'shift-9', '[', ']'];

      keys.forEach(function (key) {
        _this3.setKeyHandler(meta + '-' + key, function (editor, keyboardEvent) {
          keyboardEvent.preventDefault();
        });
      });
    }
  }]);

  return SquireExt;
}(_squireRte2.default);

exports.default = SquireExt;

/***/ }),
/* 75 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_75__;

/***/ }),
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements WwTextObject
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _domUtils = __webpack_require__(4);

var _domUtils2 = _interopRequireDefault(_domUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var isIE11 = _tuiCodeSnippet2.default.browser.msie && _tuiCodeSnippet2.default.browser.version === 11;
var isWindowChrome = navigator.appVersion.indexOf('Win') !== -1 && _tuiCodeSnippet2.default.browser.chrome;
var isNeedOffsetFix = isIE11 || isWindowChrome;

/**
 * Class WwTextObject
 */

var WwTextObject = function () {
  /**
   * Creates an instance of WwTextObject.
   * @param {WysiwygEditor} wwe - wysiwygEditor
   * @param {Range} range - Range object
   * @memberof WwTextObject
   */
  function WwTextObject(wwe, range) {
    _classCallCheck(this, WwTextObject);

    this._wwe = wwe;

    // msie11 and window chrome can't make start offset of range api correctly when compositing korean.
    // so we need fix this when compositing korean.(and maybe other languages that needs composition.)
    if (isNeedOffsetFix) {
      this.isComposition = false;
      this._initCompositionEvent();
    }

    this.setRange(range || this._wwe.getRange());
  }

  /**
   * Initialize composition event
   * @memberof WwTextObject
   * @private
   */


  _createClass(WwTextObject, [{
    key: '_initCompositionEvent',
    value: function _initCompositionEvent() {
      var _this = this;

      this._wwe.getEditor().addEventListener('compositionstart', function () {
        _this.isComposition = true;
      });

      this._wwe.getEditor().addEventListener('compositionend', function () {
        _this.isComposition = false;
      });
    }

    /**
     * Set _range object to given range object
     * @param {Range} range Range object
     * @memberof WwTextObject
     */

  }, {
    key: 'setRange',
    value: function setRange(range) {
      if (this._range) {
        this._range.detach();
      }

      this._range = range;
    }

    /**
     * Expand start offset by one
     * @memberof WwTextObject
     */

  }, {
    key: 'expandStartOffset',
    value: function expandStartOffset() {
      var range = this._range;

      if (_domUtils2.default.isTextNode(range.startContainer) && range.startOffset > 0) {
        range.setStart(range.startContainer, range.startOffset - 1);
      }
    }

    /**
     * Expand end offset by one
     * @memberof WwTextObject
     */

  }, {
    key: 'expandEndOffset',
    value: function expandEndOffset() {
      var range = this._range;

      if (_domUtils2.default.isTextNode(range.endContainer) && range.endOffset < range.endContainer.nodeValue.length) {
        range.setEnd(range.endContainer, range.endOffset + 1);
      }
    }

    /**
     * setEnd range on start
     * @param {Range} range Range object
     * @memberof WwTextObject
     */

  }, {
    key: 'setEndBeforeRange',
    value: function setEndBeforeRange(range) {
      var offset = range.startOffset;

      if (this.isComposition) {
        offset += 1;
      }

      this._range.setEnd(range.startContainer, offset);
    }

    /**
     * Get text content
     * @returns {string}
     * @memberof WwTextObject
     */

  }, {
    key: 'getTextContent',
    value: function getTextContent() {
      return this._range.cloneContents().textContent;
    }

    /**
     * Replace current selection content to given text
     * @param {string} content Text content
     * @memberof WwTextObject
     */

  }, {
    key: 'replaceContent',
    value: function replaceContent(content) {
      this._wwe.getEditor().setSelection(this._range);
      this._wwe.getEditor().insertHTML(content);
      this._range = this._wwe.getRange();
    }

    /**
     * Delete current selection content
     * @memberof WwTextObject
     */

  }, {
    key: 'deleteContent',
    value: function deleteContent() {
      this._wwe.getEditor().setSelection(this._range);
      this._wwe.getEditor().insertHTML('');
      this._range = this._wwe.getRange();
    }

    /**
     * Peek previous element's content
     * @param {number} offset Offset to peek
     * @returns {string}
     * @memberof WwTextObject
     */

  }, {
    key: 'peekStartBeforeOffset',
    value: function peekStartBeforeOffset(offset) {
      var range = this._range.cloneRange();

      range.setStart(range.startContainer, Math.max(range.startOffset - offset, 0));
      range.setEnd(this._range.startContainer, this._range.startOffset);

      return range.cloneContents().textContent;
    }
  }]);

  return WwTextObject;
}();

exports.default = WwTextObject;

/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _blockOverlay = __webpack_require__(78);

var _blockOverlay2 = _interopRequireDefault(_blockOverlay);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements UI code block gadget
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var EVENT_LANGUAGE_CHANGED = 'language-changed';
var GADGET_WIDTH = 250;
var GADGET_HEIGHT = 30;

/**
 * Class CodeBlockGadget
 * @extends {BlockOverlay}
 */

var CodeBlockGadget = function (_BlockOverlay) {
  _inherits(CodeBlockGadget, _BlockOverlay);

  /**
   * Creates an instance of CodeBlockGadget.
   * @param {Object} options - options
   * @param {EventManager} options.eventManager - event manager instance
   * @param {HTMLElement} options.container - container element
   * @param {WysiwygEditor} options.wysiwygEditor - wysiwyg editor instance
   * @memberof CodeBlockGadget
   */
  function CodeBlockGadget(_ref) {
    var eventManager = _ref.eventManager,
        container = _ref.container,
        wysiwygEditor = _ref.wysiwygEditor;

    _classCallCheck(this, CodeBlockGadget);

    var _this = _possibleConstructorReturn(this, (CodeBlockGadget.__proto__ || Object.getPrototypeOf(CodeBlockGadget)).call(this, {
      eventManager: eventManager,
      container: container,
      attachedSelector: 'pre'
    }));

    _this._wysiwygEditor = wysiwygEditor;
    _this._popupCodeBlockLanguages = null;

    _this._initDOM();
    _this._initDOMEvent();
    return _this;
  }

  _createClass(CodeBlockGadget, [{
    key: '_initDOM',
    value: function _initDOM() {
      this.$el.addClass('code-block-header');
      this._$languageLabel = (0, _jquery2.default)('<span>text</span>');
      this.$el.append(this._$languageLabel);
      this._$buttonOpenModalEditor = (0, _jquery2.default)('<button type="button">Editor</button>');
      this.$el.append(this._$buttonOpenModalEditor);
    }
  }, {
    key: '_initDOMEvent',
    value: function _initDOMEvent() {
      var _this2 = this;

      this._$buttonOpenModalEditor.on('click', function () {
        return _this2._openPopupCodeBlockEditor();
      });
    }
  }, {
    key: '_openPopupCodeBlockEditor',
    value: function _openPopupCodeBlockEditor() {
      this._eventManager.emit('openPopupCodeBlockEditor', this.getAttachedElement());
    }
  }, {
    key: '_updateLanguage',
    value: function _updateLanguage() {
      var attachedElement = this.getAttachedElement();
      var language = attachedElement ? attachedElement.getAttribute('data-language') : null;

      this._$languageLabel.text(language ? language : 'text');
    }

    /**
     * update gadget position
     * @memberof CodeBlockGadget
     * @protected
     * @override
     */

  }, {
    key: 'syncLayout',
    value: function syncLayout() {
      var $attachedElement = (0, _jquery2.default)(this.getAttachedElement());
      var offset = $attachedElement.offset();

      offset.left = offset.left + ($attachedElement.outerWidth() - GADGET_WIDTH);

      this.$el.offset(offset);
      this.$el.height(GADGET_HEIGHT);
      this.$el.width(GADGET_WIDTH);
    }

    /**
     * on show
     * @memberof CodeBlockGadget
     * @protected
     * @override
     */

  }, {
    key: 'onShow',
    value: function onShow() {
      var _this3 = this;

      _get(CodeBlockGadget.prototype.__proto__ || Object.getPrototypeOf(CodeBlockGadget.prototype), 'onShow', this).call(this);

      this._onAttachedElementChange = function () {
        return _this3._updateLanguage();
      };
      (0, _jquery2.default)(this.getAttachedElement()).on(EVENT_LANGUAGE_CHANGED, this._onAttachedElementChange);

      this._updateLanguage();
    }

    /**
     * on hide
     * @memberof CodeBlockGadget
     * @protected
     * @override
     */

  }, {
    key: 'onHide',
    value: function onHide() {
      (0, _jquery2.default)(this.getAttachedElement()).off(EVENT_LANGUAGE_CHANGED, this._onAttachedElementChange);

      _get(CodeBlockGadget.prototype.__proto__ || Object.getPrototypeOf(CodeBlockGadget.prototype), 'onHide', this).call(this);
    }
  }]);

  return CodeBlockGadget;
}(_blockOverlay2.default);

exports.default = CodeBlockGadget;

/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements UI block overlay
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Class BlockOverlay
 */
var BlockOverlay = function () {
  /**
   * Creates an instance of BlockOverlay.
   * @param {Object} options - options
   *  @param {EventManager} options.eventManager - event manager instance
   *  @param {HTMLElement} options.container - container element
   *  @param {string} options.attachedSelector - selector string to find attached element
   * @memberof BlockOverlay
   */
  function BlockOverlay(_ref) {
    var eventManager = _ref.eventManager,
        container = _ref.container,
        attachedSelector = _ref.attachedSelector;

    _classCallCheck(this, BlockOverlay);

    this._eventManager = eventManager;
    this._attachedSelector = '[contenteditable=true] ' + attachedSelector;
    this._$container = (0, _jquery2.default)(container);
    this._$attachedElement = null;

    /**
     * is activated.
     * if this blockOverlay is active, It always be visible unconditionally.
     * @type {boolean}
     */
    this.active = false;

    this._createElement();
    this._initEvent();
  }

  _createClass(BlockOverlay, [{
    key: '_createElement',
    value: function _createElement() {
      this.$el = (0, _jquery2.default)('<div class="te-ww-block-overlay">');
      this.$el.css({
        position: 'absolute',
        display: 'none',
        'z-index': 1
      });
      this._$container.append(this.$el);
    }
  }, {
    key: '_initEvent',
    value: function _initEvent() {
      var _this = this;

      this._eventManager.listen('change', this._onChange.bind(this));
      this._eventManager.listen('mouseover', this._onMouseOver.bind(this));
      this._eventManager.listen('focus', function () {
        _this.setVisibility(false);
      });
      this._eventManager.listen('mousedown', function () {
        _this.setVisibility(false);
      });
    }
  }, {
    key: '_onChange',
    value: function _onChange() {
      if (this._$attachedElement && _jquery2.default.contains(document, this._$attachedElement[0])) {
        this.syncLayout();
      } else {
        this.setVisibility(false);
      }
    }
  }, {
    key: '_onMouseOver',
    value: function _onMouseOver(ev) {
      var originalEvent = ev.data;
      var $eventTarget = (0, _jquery2.default)(originalEvent.target);
      var $attachedElement = $eventTarget.closest(this._attachedSelector);

      if ($attachedElement.length) {
        this._$attachedElement = $attachedElement;
        this.setVisibility(true);
      } else if ($eventTarget.closest(this.$el).length) {
        this.setVisibility(true);
      } else if (!this.active) {
        this.setVisibility(false);
      }
    }

    /**
     * update blockOverlay position & size update to attached element
     * you may want to override this to adjust position & size
     * @memberof BlockOverlay
     * @protected
     */

  }, {
    key: 'syncLayout',
    value: function syncLayout() {
      this.$el.offset(this._$attachedElement.offset());
      this.$el.width(this._$attachedElement.outerWidth());
      this.$el.height(this._$attachedElement.outerHeight());
    }

    /**
     * attached element
     * @protected
     * @returns {HTMLElement} - attached element
     * @memberof BlockOverlay
     */

  }, {
    key: 'getAttachedElement',
    value: function getAttachedElement() {
      return this._$attachedElement ? this._$attachedElement.get(0) : null;
    }

    /**
     * visibility
     * @protected
     * @returns {boolean} visibility
     * @memberof BlockOverlay
     */

  }, {
    key: 'getVisibility',
    value: function getVisibility() {
      return this.$el.css('display') === 'block';
    }

    /**
     * visibility
     * @param {boolean} visibility - is visible
     * @protected
     * @memberof BlockOverlay
     */

  }, {
    key: 'setVisibility',
    value: function setVisibility(visibility) {
      if (visibility && this._$attachedElement) {
        if (!this.getVisibility()) {
          this.$el.css('display', 'block');
          this.syncLayout();
          this.onShow();
        }
      } else if (!visibility) {
        if (this.getVisibility()) {
          this.$el.css('display', 'none');
          this.onHide();
        }
      }
    }

    /**
     * called on show. you may want to override to get the event
     * @memberof BlockOverlay
     * @protected
     * @abstract
     */

  }, {
    key: 'onShow',
    value: function onShow() {}

    /**
     * called on hide. you may want to override to get the event
     * @memberof BlockOverlay
     * @protected
     */

  }, {
    key: 'onHide',
    value: function onHide() {
      this.active = false;
      this._$attachedElement = null;
    }
  }]);

  return BlockOverlay;
}();

exports.default = BlockOverlay;

/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview editor layout
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Editor container template
 * @type {string}
 * @ignore
 */
var containerTmpl = ['<div class="tui-editor">', '<div class="te-md-container">', '<div class="te-editor" />', '<div class="te-md-splitter" />', '<div class="te-preview" />', '</div>', '<div class="te-ww-container">', '<div class="te-editor" />', '</div>', '</div>'].join('');

/**
 * Class Layout
 */

var Layout = function () {
  /**
   * Creates an instance of Layout.
   * @param {object} options - Option object
   * @param {EventManager} eventManager - Event manager instance
   * @memberof Layout
   */
  function Layout(options, eventManager) {
    _classCallCheck(this, Layout);

    this.$el = (0, _jquery2.default)(options.el);
    this.height = options.height;
    this.type = options.initialEditType;
    this.eventManager = eventManager;

    this.init();
    this._initEvent();
  }

  /**
   * Initializer
   * @memberof Layout
   */


  _createClass(Layout, [{
    key: 'init',
    value: function init() {
      this._renderLayout();

      this._initMarkdownAndPreviewSection();
      this._initWysiwygSection();
    }

    /**
     * Initialize show and hide event
     * @memberof Layout
     * @private
     */

  }, {
    key: '_initEvent',
    value: function _initEvent() {
      this.eventManager.listen('hide', this.hide.bind(this));
      this.eventManager.listen('show', this.show.bind(this));
    }

    /**
     * Create editor container with template
     * @memberof Layout
     * @private
     */

  }, {
    key: '_renderLayout',
    value: function _renderLayout() {
      this.$el.css('box-sizing', 'border-box');
      this.$containerEl = (0, _jquery2.default)(containerTmpl).appendTo(this.$el);
    }

    /**
     * Switch editor mode to WYSIWYG
     * @memberof Layout
     */

  }, {
    key: 'switchToWYSIWYG',
    value: function switchToWYSIWYG() {
      this.$containerEl.removeClass('te-md-mode');
      this.$containerEl.addClass('te-ww-mode');
    }

    /**
     * Switch editor mode to Markdown
     * @memberof Layout
     */

  }, {
    key: 'switchToMarkdown',
    value: function switchToMarkdown() {
      this.$containerEl.removeClass('te-ww-mode');
      this.$containerEl.addClass('te-md-mode');
    }

    /**
     * Initialize editor to Markdown and set preview section
     * @memberof Layout
     * @private
     */

  }, {
    key: '_initMarkdownAndPreviewSection',
    value: function _initMarkdownAndPreviewSection() {
      this.$mdEditorContainerEl = this.$containerEl.find('.te-md-container .te-editor');
      this.$previewEl = this.$containerEl.find('.te-md-container .te-preview');
    }

    /**
     * Initialize editor to WYSIWYG
     * @memberof Layout
     * @private
     */

  }, {
    key: '_initWysiwygSection',
    value: function _initWysiwygSection() {
      this.$wwEditorContainerEl = this.$containerEl.find('.te-ww-container .te-editor');
    }

    /**
     * Set preview to vertical split style
     * @memberof Layout
     * @private
     */

  }, {
    key: '_verticalSplitStyle',
    value: function _verticalSplitStyle() {
      this.$containerEl.find('.te-md-container').removeClass('te-preview-style-tab');
      this.$containerEl.find('.te-md-container').addClass('te-preview-style-vertical');
    }

    /**
     * Set tab style preview mode
     * @memberof Layout
     * @private
     */

  }, {
    key: '_tabStyle',
    value: function _tabStyle() {
      this.$containerEl.find('.te-md-container').removeClass('te-preview-style-vertical');
      this.$containerEl.find('.te-md-container').addClass('te-preview-style-tab');
    }

    /**
     * Toggle preview style between tab and vertical split
     * @memberof Layout
     * @param {string} style Preview style ('tab' or 'vertical')
     */

  }, {
    key: 'changePreviewStyle',
    value: function changePreviewStyle(style) {
      if (style === 'tab') {
        this._tabStyle();
      } else if (style === 'vertical') {
        this._verticalSplitStyle();
      }
    }

    /**
     * Hide Editor
     * @memberof Layout
     */

  }, {
    key: 'hide',
    value: function hide() {
      this.$el.find('.tui-editor').addClass('te-hide');
    }

    /**
     * Show Editor
     * @memberof Layout
     */

  }, {
    key: 'show',
    value: function show() {
      this.$el.find('.tui-editor').removeClass('te-hide');
    }

    /**
     * Remove Editor
     * @memberof Layout
     */

  }, {
    key: 'remove',
    value: function remove() {
      this.$el.find('.tui-editor').remove();
    }

    /**
     * Get jQuery wrapped editor container element
     * @memberof Layout
     * @returns {jQuery}
     */

  }, {
    key: 'getEditorEl',
    value: function getEditorEl() {
      return this.$containerEl;
    }

    /**
     * Get jQuery wrapped preview element
     * @memberof Layout
     * @returns {jQuery}
     */

  }, {
    key: 'getPreviewEl',
    value: function getPreviewEl() {
      return this.$previewEl;
    }

    /**
     * Get jQuery wrapped Markdown editor element
     * @memberof Layout
     * @returns {jQuery}
     */

  }, {
    key: 'getMdEditorContainerEl',
    value: function getMdEditorContainerEl() {
      return this.$mdEditorContainerEl;
    }

    /**
     * Get jQuery wrapped WYSIWYG editor element
     * @memberof Layout
     * @returns {jQuery}
     */

  }, {
    key: 'getWwEditorContainerEl',
    value: function getWwEditorContainerEl() {
      return this.$wwEditorContainerEl;
    }
  }]);

  return Layout;
}();

exports.default = Layout;

/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements Command
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Class Command
 */
var Command = function () {
  /**
   * @param {string} name Command name
   * @param {number} type Command type (Command.TYPE)
   * @param {Array.<string>} [keyMap] keyMap
   */
  function Command(name, type, keyMap) {
    _classCallCheck(this, Command);

    this.name = name;
    this.type = type;

    if (keyMap) {
      this.setKeyMap(keyMap);
    }
  }
  /**
   * getName
   * returns Name of command
   * @memberof Command
   * @returns {string} Command Name
   */


  _createClass(Command, [{
    key: 'getName',
    value: function getName() {
      return this.name;
    }

    /**
     * getType
     * returns Type of command
     * @memberof Command
     * @returns {number} Command Command type number
     */

  }, {
    key: 'getType',
    value: function getType() {
      return this.type;
    }

    /**
     * isMDType
     * returns whether Command Type is Markdown or not
     * @memberof Command
     * @returns {boolean} result
     */

  }, {
    key: 'isMDType',
    value: function isMDType() {
      return this.type === Command.TYPE.MD;
    }

    /**
     * isWWType
     * returns whether Command Type is Wysiwyg or not
     * @memberof Command
     * @returns {boolean} result
     */

  }, {
    key: 'isWWType',
    value: function isWWType() {
      return this.type === Command.TYPE.WW;
    }

    /**
     * isGlobalType
     * returns whether Command Type is Global or not
     * @memberof Command
     * @returns {boolean} result
     */

  }, {
    key: 'isGlobalType',
    value: function isGlobalType() {
      return this.type === Command.TYPE.GB;
    }

    /**
     * setKeyMap
     * Set keymap value for each os
     * @memberof Command
     * @param {string} win Windows Key(and etc)
     * @param {string} mac Mac osx key
     */

  }, {
    key: 'setKeyMap',
    value: function setKeyMap(win, mac) {
      this.keyMap = [win, mac];
    }
  }]);

  return Command;
}();

/**
 * Command factory method
 * @memberof Command
 * @param {string} typeStr Editor type name
 * @param {object} props Property
 *     @param {string} props.name Command name
 *     @param {number} props.type Command type number
 * @returns {Command}
 */


Command.factory = function (typeStr, props) {
  var type = void 0;

  if (typeStr === 'markdown') {
    type = Command.TYPE.MD;
  } else if (typeStr === 'wysiwyg') {
    type = Command.TYPE.WW;
  } else if (typeStr === 'global') {
    type = Command.TYPE.GB;
  }

  var command = new Command(props.name, type);

  _tuiCodeSnippet2.default.extend(command, props);

  return command;
};

/**
 * Command Type Constant
 * markdown : 0
 * wysiwyg : 1
 * global : 2
 * @memberof Command
 * @type {object}
 */
Command.TYPE = {
  MD: 0,
  WW: 1,
  GB: 2
};

exports.default = Command;

/***/ }),
/* 81 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_81__;

/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// Copyright (c) 2016, Revin Guillen.
// Distributed under an MIT license: https://github.com/revin/markdown-it-task-lists/

/**
 * @fileoverview Implements markdownitTaskPlugin
 * @modifier Sungho Kim(sungho-kim@nhnent.com) FE Development Lab/NHN Ent.
 * @modifier Junghwan Park(junghwan.park@nhnent.com) FE Development Lab/NHN Ent.
 */
/* eslint-disable */

/**
 * Task list renderer for Markdown-it
 * @param {object} markdownit Markdown-it instance
 * @ignore
 */
var MarkdownitTaskRenderer = function MarkdownitTaskRenderer(markdownit) {
    markdownit.core.ruler.after('inline', 'tui-task-list', function (state) {
        var TASK_LIST_ITEM_CLASS_NAME = 'task-list-item';
        var CHECKED_CLASS_NAME = 'checked';
        var tokens = state.tokens;
        var className;
        var tokenIndex;

        // tokenIndex=0 'ul', tokenIndex=1 'li', tokenIndex=2 'p_open'
        for (tokenIndex = 2; tokenIndex < tokens.length; tokenIndex += 1) {
            if (isTaskListItemToken(tokens, tokenIndex)) {
                if (isChecked(tokens[tokenIndex])) {
                    className = TASK_LIST_ITEM_CLASS_NAME + ' ' + CHECKED_CLASS_NAME;
                } else {
                    className = TASK_LIST_ITEM_CLASS_NAME;
                }

                removeMarkdownTaskFormatText(tokens[tokenIndex]);

                setTokenAttribute(tokens[tokenIndex - 2], 'class', className);
                setTokenAttribute(tokens[tokenIndex - 2], 'data-te-task', '');
            }
        }
    });
};

/**
 * Remove task format text for rendering
 * @param {object} token Token object
 * @ignore
 */
function removeMarkdownTaskFormatText(token) {
    // '[X] ' length is 4
    // FIXED: we don't need first space
    token.content = token.content.slice(4);
    token.children[0].content = token.children[0].content.slice(4);
}

/**
 * Return boolean value whether task checked or not
 * @param {object} token Token object
 * @returns {boolean}
 * @ignore
 */
function isChecked(token) {
    var checked = false;

    if (token.content.indexOf('[x]') === 0 || token.content.indexOf('[X]') === 0) {
        checked = true;
    }

    return checked;
}

/**
 * Set attribute of passed token
 * @param {object} token Token object
 * @param {string} attributeName Attribute name for set
 * @param {string} attributeValue Attribute value for set
 * @ignore
 */
function setTokenAttribute(token, attributeName, attributeValue) {
    var index = token.attrIndex(attributeName);
    var attr = [attributeName, attributeValue];

    if (index < 0) {
        token.attrPush(attr);
    } else {
        token.attrs[index] = attr;
    }
}

/**
 * Return boolean value whether task list item or not
 * @param {array} tokens Token object
 * @param {number} index Number of token index
 * @returns {boolean}
 * @ignore
 */
function isTaskListItemToken(tokens, index) {
    return tokens[index].type === 'inline' && tokens[index - 1].type === 'paragraph_open' && tokens[index - 2].type === 'list_item_open' && (tokens[index].content.indexOf('[ ]') === 0 || tokens[index].content.indexOf('[x]') === 0 || tokens[index].content.indexOf('[X]') === 0);
}
/* eslint-enable */

module.exports = MarkdownitTaskRenderer;

/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// Copyright (c) 2016, Revin Guillen.
// Distributed under an MIT license: https://github.com/revin/markdown-it-task-lists/
/* eslint-disable */
/**
 * @fileoverview Implements markdownitCodeBlockPlugin
 * @modifier NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */

/**
 * Code block renderer for Markdown-it
 * @param {object} markdownit Markdown-it instance
 * @ignore
 */
var MarkdownitCodeBlockRenderer = function MarkdownitCodeBlockRenderer(markdownit) {
    markdownit.core.ruler.after('block', 'tui-code-block', function (state) {
        var DEFAULT_NUMBER_OF_BACKTICKS = 3;
        var tokens = state.tokens;
        var currentToken, tokenIndex, numberOfBackticks;

        for (tokenIndex = 0; tokenIndex < tokens.length; tokenIndex += 1) {
            currentToken = tokens[tokenIndex];

            if (isCodeFenceToken(currentToken)) {
                numberOfBackticks = currentToken.markup.length;
                if (numberOfBackticks > DEFAULT_NUMBER_OF_BACKTICKS) {
                    setTokenAttribute(currentToken, 'data-backticks', numberOfBackticks, true);
                }
                if (currentToken.info) {
                    setTokenAttribute(currentToken, 'data-language', escape(currentToken.info.replace(' ', ''), true));
                }
            }
        }
    });
};

/**
 * Set attribute of passed token
 * @param {object} token Token object
 * @param {string} attributeName Attribute name for set
 * @param {string} attributeValue Attribute value for set
 * @ignore
 */
function setTokenAttribute(token, attributeName, attributeValue) {
    var index = token.attrIndex(attributeName);
    var attr = [attributeName, attributeValue];

    if (index < 0) {
        token.attrPush(attr);
    } else {
        token.attrs[index] = attr;
    }
}
/**
 * Return boolean value whether passed token is code fence or not
 * @param {object} token Token object
 * @returns {boolean}
 * @ignore
 */
function isCodeFenceToken(token) {
    return token.block === true && token.tag === 'code' && token.type === 'fence';
}

/**
 * escape code from markdown-it
 * @param {string} html HTML string
 * @param {string} encode Boolean value of whether encode or not
 * @returns {string}
 * @ignore
 */
function escape(html, encode) {
    return html.replace(!encode ? /&(?!#?\w+;)/g : /&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
}
/* eslint-enable */

module.exports = MarkdownitCodeBlockRenderer;

/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// Copyright (c) 2014 Vitaly Puzrin, Alex Kocharin.
// Distributed under an ISC license: https://github.com/markdown-it/markdown-it/
/**
 * @fileoverview Implements MarkdownItCodeRenderer
 * @modifier NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */

/* eslint-disable */
module.exports = function code(state, startLine, endLine /*, silent*/) {
    // Added by Junghwan Park
    var FIND_LIST_RX = / {0,3}(?:-|\*|\d\.) /;
    var lines = state.src.split('\n');
    var currentLine = lines[startLine];
    // Added by Junghwan Park

    var nextLine,
        last,
        token,
        emptyLines = 0;

    // Add condition by Junghwan Park
    if (currentLine.match(FIND_LIST_RX) || state.sCount[startLine] - state.blkIndent < 4) {
        // Add condition by Junghwan Park
        return false;
    }

    last = nextLine = startLine + 1;

    while (nextLine < endLine) {
        if (state.isEmpty(nextLine)) {
            emptyLines++;

            // workaround for lists: 2 blank lines should terminate indented
            // code block, but not fenced code block
            if (emptyLines >= 2 && state.parentType === 'list') {
                break;
            }

            nextLine++;
            continue;
        }

        emptyLines = 0;

        if (state.sCount[nextLine] - state.blkIndent >= 4) {
            nextLine++;
            last = nextLine;
            continue;
        }
        break;
    }

    state.line = last;

    token = state.push('code_block', 'code', 0);
    token.content = state.getLines(startLine, last, 4 + state.blkIndent, true);
    token.map = [startLine, state.line];

    return true;
};
/* eslint-enable */

/***/ }),
/* 85 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// Copyright (c) 2014 Vitaly Puzrin, Alex Kocharin.
// Distributed under MIT license: https://github.com/markdown-it/markdown-it/
/**
 * @fileoverview Implements markdownitCodeBlockQuoteRenderer
 * @modifier NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */

/* eslint-disable */

// Block quotes



// prevent quote, pre in list #811
// ref: #989
// #811 START
// var isSpace = require('../common/utils').isSpace;

function isSpace(code) {
  switch (code) {
    case 0x09:
    case 0x20:
      return true;
  }
  return false;
}
// #811 END

module.exports = function blockquote(state, startLine, endLine, silent) {
  var adjustTab,
      ch,
      i,
      initial,
      l,
      lastLineEmpty,
      lines,
      nextLine,
      offset,
      oldBMarks,
      oldBSCount,
      oldIndent,
      oldParentType,
      oldSCount,
      oldTShift,
      spaceAfterMarker,
      terminate,
      terminatorRules,
      token,
      wasOutdented,
      oldLineMax = state.lineMax,
      pos = state.bMarks[startLine] + state.tShift[startLine],
      max = state.eMarks[startLine];

  // #811 START
  var FIND_LIST_RX = /(?:-|\*|\d+\.) {1,4}(?:> {0,3})[^>]*$/;
  var sourceLines = state.src.split('\n');
  var currentLine = sourceLines[startLine];
  // #811 END

  // if it's indented more than 3 spaces, it should be a code block
  if (state.sCount[startLine] - state.blkIndent >= 4) {
    return false;
  }

  // check the block quote marker
  if (state.src.charCodeAt(pos++) !== 0x3E /* > */) {
      return false;
    }
  // #811 START
  // check block quote in list
  if (currentLine.match(FIND_LIST_RX) /*&& !currentLine.match(/^ {0,6}>/)*/) {
      return false;
    }
  // #811 END

  // we know that it's going to be a valid blockquote,
  // so no point trying to find the end of it in silent mode
  if (silent) {
    return true;
  }

  // skip spaces after ">" and re-calculate offset
  initial = offset = state.sCount[startLine] + pos - (state.bMarks[startLine] + state.tShift[startLine]);

  // skip one optional space after '>'
  if (state.src.charCodeAt(pos) === 0x20 /* space */) {
      // ' >   test '
      //     ^ -- position start of line here:
      pos++;
      initial++;
      offset++;
      adjustTab = false;
      spaceAfterMarker = true;
    } else if (state.src.charCodeAt(pos) === 0x09 /* tab */) {
      spaceAfterMarker = true;

      if ((state.bsCount[startLine] + offset) % 4 === 3) {
        // '  >\t  test '
        //       ^ -- position start of line here (tab has width===1)
        pos++;
        initial++;
        offset++;
        adjustTab = false;
      } else {
        // ' >\t  test '
        //    ^ -- position start of line here + shift bsCount slightly
        //         to make extra space appear
        adjustTab = true;
      }
    } else {
    spaceAfterMarker = false;
  }

  oldBMarks = [state.bMarks[startLine]];
  state.bMarks[startLine] = pos;

  while (pos < max) {
    ch = state.src.charCodeAt(pos);

    if (isSpace(ch)) {
      if (ch === 0x09) {
        offset += 4 - (offset + state.bsCount[startLine] + (adjustTab ? 1 : 0)) % 4;
      } else {
        offset++;
      }
    } else {
      break;
    }

    pos++;
  }

  oldBSCount = [state.bsCount[startLine]];
  state.bsCount[startLine] = state.sCount[startLine] + 1 + (spaceAfterMarker ? 1 : 0);

  lastLineEmpty = pos >= max;

  oldSCount = [state.sCount[startLine]];
  state.sCount[startLine] = offset - initial;

  oldTShift = [state.tShift[startLine]];
  state.tShift[startLine] = pos - state.bMarks[startLine];

  terminatorRules = state.md.block.ruler.getRules('blockquote');

  oldParentType = state.parentType;
  state.parentType = 'blockquote';
  wasOutdented = false;

  // Search the end of the block
  //
  // Block ends with either:
  //  1. an empty line outside:
  //     ```
  //     > test
  //
  //     ```
  //  2. an empty line inside:
  //     ```
  //     >
  //     test
  //     ```
  //  3. another tag:
  //     ```
  //     > test
  //      - - -
  //     ```
  for (nextLine = startLine + 1; nextLine < endLine; nextLine++) {
    // check if it's outdented, i.e. it's inside list item and indented
    // less than said list item:
    //
    // ```
    // 1. anything
    //    > current blockquote
    // 2. checking this line
    // ```
    if (state.sCount[nextLine] < state.blkIndent) wasOutdented = true;

    pos = state.bMarks[nextLine] + state.tShift[nextLine];
    max = state.eMarks[nextLine];

    if (pos >= max) {
      // Case 1: line is not inside the blockquote, and this line is empty.
      break;
    }

    if (state.src.charCodeAt(pos++) === 0x3E /* > */ && !wasOutdented) {
      // This line is inside the blockquote.

      // skip spaces after ">" and re-calculate offset
      initial = offset = state.sCount[nextLine] + pos - (state.bMarks[nextLine] + state.tShift[nextLine]);

      // skip one optional space after '>'
      if (state.src.charCodeAt(pos) === 0x20 /* space */) {
          // ' >   test '
          //     ^ -- position start of line here:
          pos++;
          initial++;
          offset++;
          adjustTab = false;
          spaceAfterMarker = true;
        } else if (state.src.charCodeAt(pos) === 0x09 /* tab */) {
          spaceAfterMarker = true;

          if ((state.bsCount[nextLine] + offset) % 4 === 3) {
            // '  >\t  test '
            //       ^ -- position start of line here (tab has width===1)
            pos++;
            initial++;
            offset++;
            adjustTab = false;
          } else {
            // ' >\t  test '
            //    ^ -- position start of line here + shift bsCount slightly
            //         to make extra space appear
            adjustTab = true;
          }
        } else {
        spaceAfterMarker = false;
      }

      oldBMarks.push(state.bMarks[nextLine]);
      state.bMarks[nextLine] = pos;

      while (pos < max) {
        ch = state.src.charCodeAt(pos);

        if (isSpace(ch)) {
          if (ch === 0x09) {
            offset += 4 - (offset + state.bsCount[nextLine] + (adjustTab ? 1 : 0)) % 4;
          } else {
            offset++;
          }
        } else {
          break;
        }

        pos++;
      }

      lastLineEmpty = pos >= max;

      oldBSCount.push(state.bsCount[nextLine]);
      state.bsCount[nextLine] = state.sCount[nextLine] + 1 + (spaceAfterMarker ? 1 : 0);

      oldSCount.push(state.sCount[nextLine]);
      state.sCount[nextLine] = offset - initial;

      oldTShift.push(state.tShift[nextLine]);
      state.tShift[nextLine] = pos - state.bMarks[nextLine];
      continue;
    }

    // Case 2: line is not inside the blockquote, and the last line was empty.
    if (lastLineEmpty) {
      break;
    }

    // Case 3: another tag found.
    terminate = false;
    for (i = 0, l = terminatorRules.length; i < l; i++) {
      if (terminatorRules[i](state, nextLine, endLine, true)) {
        terminate = true;
        break;
      }
    }

    if (terminate) {
      // Quirk to enforce "hard termination mode" for paragraphs;
      // normally if you call `tokenize(state, startLine, nextLine)`,
      // paragraphs will look below nextLine for paragraph continuation,
      // but if blockquote is terminated by another tag, they shouldn't
      state.lineMax = nextLine;

      if (state.blkIndent !== 0) {
        // state.blkIndent was non-zero, we now set it to zero,
        // so we need to re-calculate all offsets to appear as
        // if indent wasn't changed
        oldBMarks.push(state.bMarks[nextLine]);
        oldBSCount.push(state.bsCount[nextLine]);
        oldTShift.push(state.tShift[nextLine]);
        oldSCount.push(state.sCount[nextLine]);
        state.sCount[nextLine] -= state.blkIndent;
      }

      break;
    }

    oldBMarks.push(state.bMarks[nextLine]);
    oldBSCount.push(state.bsCount[nextLine]);
    oldTShift.push(state.tShift[nextLine]);
    oldSCount.push(state.sCount[nextLine]);

    // A negative indentation means that this is a paragraph continuation
    //
    state.sCount[nextLine] = -1;
  }

  oldIndent = state.blkIndent;
  state.blkIndent = 0;

  token = state.push('blockquote_open', 'blockquote', 1);
  token.markup = '>';
  token.map = lines = [startLine, 0];

  state.md.block.tokenize(state, startLine, nextLine);

  token = state.push('blockquote_close', 'blockquote', -1);
  token.markup = '>';

  state.lineMax = oldLineMax;
  state.parentType = oldParentType;
  lines[1] = state.line;

  // Restore original tShift; this might not be necessary since the parser
  // has already been here, but just to make sure we can do that.
  for (i = 0; i < oldTShift.length; i++) {
    state.bMarks[i + startLine] = oldBMarks[i];
    state.tShift[i + startLine] = oldTShift[i];
    state.sCount[i + startLine] = oldSCount[i];
    state.bsCount[i + startLine] = oldBSCount[i];
  }
  state.blkIndent = oldIndent;

  return true;
};

/***/ }),
/* 86 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// Copyright (c) 2014 Vitaly Puzrin, Alex Kocharin.
// Distributed under an ISC license: https://github.com/markdown-it/markdown-it/

/**
 * @fileoverview Implements markdownitTableRenderer
 * @modifier NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */

/*eslint-disable */
function getLine(state, line) {
    var pos = state.bMarks[line] + state.blkIndent,
        max = state.eMarks[line];

    return state.src.substr(pos, max - pos);
}

function escapedSplit(str) {
    var result = [],
        pos = 0,
        max = str.length,
        ch,
        escapes = 0,
        lastPos = 0,
        backTicked = false,
        lastBackTick = 0;

    ch = str.charCodeAt(pos);

    while (pos < max) {
        if (ch === 0x60 /* ` */ && escapes % 2 === 0) {
            backTicked = !backTicked;
            lastBackTick = pos;
        } else if (ch === 0x7c /* | */ && escapes % 2 === 0 && !backTicked) {
            result.push(str.substring(lastPos, pos));
            lastPos = pos + 1;
        } else if (ch === 0x5c /* \ */) {
                escapes += 1;
            } else {
            escapes = 0;
        }

        pos += 1;

        // If there was an un-closed backtick, go back to just after
        // the last backtick, but as if it was a normal character
        if (pos === max && backTicked) {
            backTicked = false;
            pos = lastBackTick + 1;
        }

        ch = str.charCodeAt(pos);
    }

    result.push(str.substring(lastPos));

    return result;
}

module.exports = function table(state, startLine, endLine, silent) {
    var ch, lineText, pos, i, nextLine, columns, columnCount, token, aligns, alignCount, t, tableLines, tbodyLines;

    // should have at least three lines
    if (startLine + 2 > endLine) {
        return false;
    }

    nextLine = startLine + 1;

    if (state.sCount[nextLine] < state.blkIndent) {
        return false;
    }

    // first character of the second line should be '|' or '-'

    pos = state.bMarks[nextLine] + state.tShift[nextLine];
    if (pos >= state.eMarks[nextLine]) {
        return false;
    }

    ch = state.src.charCodeAt(pos);
    if (ch !== 0x7C /* | */ && ch !== 0x2D /* - */ && ch !== 0x3A /* : */) {
            return false;
        }

    lineText = getLine(state, startLine + 1);
    if (!/^[-:| ]+$/.test(lineText)) {
        return false;
    }

    columns = lineText.split('|');
    aligns = [];
    for (i = 0; i < columns.length; i += 1) {
        t = columns[i].trim();
        if (!t) {
            // allow empty columns before and after table, but not in between columns;
            // e.g. allow ` |---| `, disallow ` ---||--- `
            if (i === 0 || i === columns.length - 1) {
                continue;
            } else {
                return false;
            }
        }

        if (!/^:?-+:?$/.test(t)) {
            return false;
        }
        if (t.charCodeAt(t.length - 1) === 0x3A /* : */) {
                aligns.push(t.charCodeAt(0) === 0x3A /* : */ ? 'center' : 'right');
            } else if (t.charCodeAt(0) === 0x3A /* : */) {
                aligns.push('left');
            } else {
            aligns.push('');
        }
    }
    alignCount = aligns.length;

    lineText = getLine(state, startLine).trim();
    if (lineText.indexOf('|') === -1) {
        return false;
    }
    columns = escapedSplit(lineText.replace(/^\||\|$/g, ''));

    // header row will define an amount of columns in the entire table,
    // and align row shouldn't be smaller than that (the rest of the rows can)
    columnCount = columns.length;
    if (columnCount > alignCount) {
        return false;
    } else if (columnCount < alignCount) {
        for (i = 0; i < alignCount - columnCount; i += 1) {
            columns.push('');
        }
        columnCount = columns.length;
    }

    if (silent) {
        return true;
    }

    token = state.push('table_open', 'table', 1);
    token.map = tableLines = [startLine, 0];

    token = state.push('thead_open', 'thead', 1);
    token.map = [startLine, startLine + 1];

    token = state.push('tr_open', 'tr', 1);
    token.map = [startLine, startLine + 1];

    for (i = 0; i < columnCount; i += 1) {
        token = state.push('th_open', 'th', 1);
        token.map = [startLine, startLine + 1];
        if (aligns[i]) {
            // FIXED: change property style to align
            token.attrs = [['align', aligns[i]]];
        }

        token = state.push('inline', '', 0);
        token.content = columns[i].trim();
        token.map = [startLine, startLine + 1];
        token.children = [];

        token = state.push('th_close', 'th', -1);
    }

    token = state.push('tr_close', 'tr', -1);
    token = state.push('thead_close', 'thead', -1);

    token = state.push('tbody_open', 'tbody', 1);
    token.map = tbodyLines = [startLine + 2, 0];

    for (nextLine = startLine + 2; nextLine < endLine; nextLine += 1) {
        if (state.sCount[nextLine] < state.blkIndent) {
            break;
        }

        lineText = getLine(state, nextLine);
        if (lineText.indexOf('|') === -1) {
            break;
        }

        // keep spaces at beginning of line to indicate an empty first cell, but
        // strip trailing whitespace
        columns = escapedSplit(lineText.replace(/^\||\|\s*$/g, ''));

        token = state.push('tr_open', 'tr', 1);
        for (i = 0; i < columnCount; i += 1) {
            token = state.push('td_open', 'td', 1);
            if (aligns[i]) {
                // FIXED: change property style to align
                token.attrs = [['align', aligns[i]]];
            }

            token = state.push('inline', '', 0);
            token.content = columns[i] ? columns[i].trim() : '';
            token.children = [];

            token = state.push('td_close', 'td', -1);
        }
        token = state.push('tr_close', 'tr', -1);
    }
    token = state.push('tbody_close', 'tbody', -1);
    token = state.push('table_close', 'table', -1);

    tableLines[1] = tbodyLines[1] = nextLine;
    state.line = nextLine;
    return true;
};

/***/ }),
/* 87 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// Copyright (c) 2014 Vitaly Puzrin, Alex Kocharin.
// Distributed under an ISC license: https://github.com/markdown-it/markdown-it/

/**
 * @fileoverview Implements markdownitHtmlBlockRenderer
 * @modifier NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */
/* eslint-disable */
// HTML block



// An array of opening and corresponding closing sequences for html tags,
// last argument defines whether it can terminate a paragraph or not
//

// void tag names --- Added by Junghwan Park

var voidTagNames = ['area', 'base', 'br', 'col', 'embed', 'hr', 'img', 'input', 'keygen', 'link', 'meta', 'param', 'source', 'track', 'wbr'];
var HTML_SEQUENCES = [[/^<(script|pre|style)(?=(\s|>|$))/i, /<\/(script|pre|style)>/i, true], [/^<!--/, /-->/, true], [/^<\?/, /\?>/, true], [/^<![A-Z]/, />/, true], [/^<!\[CDATA\[/, /\]\]>/, true], [new RegExp('^<(' + voidTagNames.join('|') + ')', 'i'), /^\/?>$/, true], [new RegExp('^</?(address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h1|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option|p|param|pre|section|source|title|summary|table|tbody|td|tfoot|th|thead|title|tr|track|ul)(?=(\\s|/?>|$))', 'i'), /^$/, true], [/^(?:<[A-Za-z][A-Za-z0-9\-]*(?:\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\s*=\s*(?:[^"'=<>`\x00-\x20]+|'[^']*'|"[^"]*"))?)*\s*\/?>|<\/[A-Za-z][A-Za-z0-9\-]*\s*>)\s*$/, /^$/, false]];

module.exports = function html_block(state, startLine, endLine, silent) {
    var i,
        nextLine,
        token,
        lineText,
        pos = state.bMarks[startLine] + state.tShift[startLine],
        max = state.eMarks[startLine];

    if (!state.md.options.html) {
        return false;
    }

    if (state.src.charCodeAt(pos) !== 0x3C /* < */) {
            return false;
        }

    lineText = state.src.slice(pos, max);

    for (i = 0; i < HTML_SEQUENCES.length; i++) {
        if (HTML_SEQUENCES[i][0].test(lineText)) {
            // add condition for return when meet void element --- Added by Junghwan Park
            if (i === 5) {
                return false;
            } else {
                break;
            }
        }
    }

    if (i === HTML_SEQUENCES.length) {
        return false;
    }

    if (silent) {
        // true if this sequence can be a terminator, false otherwise
        return HTML_SEQUENCES[i][2];
    }

    nextLine = startLine + 1;

    // If we are here - we detected HTML block.
    // Let's roll down till block end.
    if (!HTML_SEQUENCES[i][1].test(lineText)) {
        for (; nextLine < endLine; nextLine++) {
            if (state.sCount[nextLine] < state.blkIndent) {
                break;
            }

            pos = state.bMarks[nextLine] + state.tShift[nextLine];
            max = state.eMarks[nextLine];
            lineText = state.src.slice(pos, max);

            if (HTML_SEQUENCES[i][1].test(lineText)) {
                if (lineText.length !== 0) {
                    nextLine++;
                }
                break;
            }
        }
    }

    state.line = nextLine;

    token = state.push('html_block', '', 0);
    token.map = [startLine, nextLine];
    token.content = state.getLines(startLine, nextLine, state.blkIndent, true);

    return true;
};
/* eslint-enable */

/***/ }),
/* 88 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// Copyright (c) 2014 Vitaly Puzrin, Alex Kocharin.
// Distributed under MIT license: https://github.com/markdown-it/markdown-it/
/**
 * @fileoverview Implements markdownitBackticksRenderer
 * @modifier NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */
/* eslint-disable */

// Parse backticks
module.exports = function backtick(state, silent) {
  var start,
      max,
      marker,
      matchStart,
      matchEnd,
      token,
      pos = state.pos,
      ch = state.src.charCodeAt(pos);

  if (ch !== 0x60 /* ` */) {
      return false;
    }

  start = pos;
  pos++;
  max = state.posMax;

  while (pos < max && state.src.charCodeAt(pos) === 0x60 /* ` */) {
    pos++;
  }

  marker = state.src.slice(start, pos);

  matchStart = matchEnd = pos;

  while ((matchStart = state.src.indexOf('`', matchEnd)) !== -1) {
    matchEnd = matchStart + 1;

    while (matchEnd < max && state.src.charCodeAt(matchEnd) === 0x60 /* ` */) {
      matchEnd++;
    }

    if (matchEnd - matchStart === marker.length) {
      if (!silent) {
        token = state.push('code_inline', 'code', 0);
        token.markup = marker;
        token.content = state.src.slice(pos, matchStart).replace(/[ \n]+/g, ' ').trim();
        // TUI.EDITOR MODIFICATION START
        // store number of backtick in data-backtick
        // https://github.nhnent.com/fe/tui.editor/pull/981
        token.attrSet('data-backticks', token.markup.length);
        // TUI.EDITOR MODIFICATION END
      }
      state.pos = matchEnd;
      return true;
    }
  }

  if (!silent) {
    state.pending += marker;
  }
  state.pos += marker.length;
  return true;
};

/***/ }),
/* 89 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_89__;

/***/ }),
/* 90 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements editor preivew
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _mdPreview = __webpack_require__(31);

var _mdPreview2 = _interopRequireDefault(_mdPreview);

var _eventManager = __webpack_require__(37);

var _eventManager2 = _interopRequireDefault(_eventManager);

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

var _extManager = __webpack_require__(38);

var _extManager2 = _interopRequireDefault(_extManager);

var _convertor = __webpack_require__(39);

var _convertor2 = _interopRequireDefault(_convertor);

var _domUtils = __webpack_require__(4);

var _domUtils2 = _interopRequireDefault(_domUtils);

var _codeBlockManager = __webpack_require__(23);

var _codeBlockManager2 = _interopRequireDefault(_codeBlockManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var TASK_ATTR_NAME = 'data-te-task';
var TASK_CHECKED_CLASS_NAME = 'checked';

/**
 * Class ToastUIEditorViewer
 */

var ToastUIEditorViewer = function () {
  /**
     * Viewer
     * @param {object} options Option object
        * @param {string} options.initialValue Editor's initial value
        * @param {object} options.events eventlist Event list
            * @param {function} options.events.load It would be emitted when editor fully load
            * @param {function} options.events.change It would be emitted when content changed
            * @param {function} options.events.stateChange It would be emitted when format change by cursor position
            * @param {function} options.events.focus It would be emitted when editor get focus
            * @param {function} options.events.blur It would be emitted when editor loose focus
        * @param {object} options.hooks Hook list
            * @param {function} options.hooks.previewBeforeHook Submit preview to hook URL before preview be shown
    */
  function ToastUIEditorViewer(options) {
    var _this = this;

    _classCallCheck(this, ToastUIEditorViewer);

    this.options = _jquery2.default.extend({
      useDefaultHTMLSanitizer: true
    }, options);

    this.eventManager = new _eventManager2.default();
    this.commandManager = new _commandManager2.default(this);
    this.convertor = new _convertor2.default(this.eventManager);
    this.toMarkOptions = null;

    if (this.options.useDefaultHTMLSanitizer) {
      this.convertor.initHtmlSanitizer();
    }

    if (this.options.hooks) {
      _tuiCodeSnippet2.default.forEach(this.options.hooks, function (fn, key) {
        _this.addHook(key, fn);
      });
    }

    if (this.options.events) {
      _tuiCodeSnippet2.default.forEach(this.options.events, function (fn, key) {
        _this.on(key, fn);
      });
    }

    this.preview = new _mdPreview2.default((0, _jquery2.default)(this.options.el), this.eventManager, this.convertor, true);

    this.preview.$el.on('mousedown', _jquery2.default.proxy(this._toggleTask, this));

    _extManager2.default.applyExtension(this, this.options.exts);

    this.setValue(this.options.initialValue);

    this.eventManager.emit('load', this);
  }

  /**
   * Toggle task by detecting mousedown event.
   * @param {MouseEvent} ev - event
   * @private
   */


  _createClass(ToastUIEditorViewer, [{
    key: '_toggleTask',
    value: function _toggleTask(ev) {
      var isBeneathTaskBox = ev.offsetX < 18 && ev.offsetY > 18;

      if (ev.target.hasAttribute(TASK_ATTR_NAME) && !isBeneathTaskBox) {
        (0, _jquery2.default)(ev.target).toggleClass(TASK_CHECKED_CLASS_NAME);
        this.eventManager.emit('change', {
          source: 'viewer',
          data: ev
        });
      }
    }

    /**
     * Set content for preview
     * @memberof ToastUIEditorViewer
     * @param {string} markdown Markdown text
     */

  }, {
    key: 'setMarkdown',
    value: function setMarkdown(markdown) {
      this.markdownValue = markdown = markdown || '';

      this.preview.refresh(this.markdownValue);
      this.eventManager.emit('setMarkdownAfter', this.markdownValue);
    }

    /**
     * Set content for preview
     * @memberof ToastUIEditorViewer
     * @param {string} markdown Markdown text
     * @deprecated
     */

  }, {
    key: 'setValue',
    value: function setValue(markdown) {
      this.setMarkdown(markdown);
    }

    /**
     * Bind eventHandler to event type
     * @memberof ToastUIEditorViewer
     * @param {string} type Event type
     * @param {function} handler Event handler
     */

  }, {
    key: 'on',
    value: function on(type, handler) {
      this.eventManager.listen(type, handler);
    }

    /**
     * Unbind eventHandler from event type
     * @memberof ToastUIEditorViewer
     * @param {string} type Event type
     */

  }, {
    key: 'off',
    value: function off(type) {
      this.eventManager.removeEventHandler(type);
    }

    /**
     * Remove Viewer preview from document
     * @memberof ToastUIEditorViewer
     */

  }, {
    key: 'remove',
    value: function remove() {
      this.eventManager.emit('removeEditor');
      this.preview.$el.off('mousedown', _jquery2.default.proxy(this._toggleTask, this));
      this.options = null;
      this.eventManager = null;
      this.commandManager = null;
      this.convertor = null;
      this.preview = null;
    }

    /**
     * Add hook to Viewer preview's event
     * @memberof ToastUIEditorViewer
     * @param {string} type Event type
     * @param {function} handler Event handler
     */

  }, {
    key: 'addHook',
    value: function addHook(type, handler) {
      this.eventManager.removeEventHandler(type);
      this.eventManager.listen(type, handler);
    }

    /**
     * Return true
     * @memberof ToastUIEditorViewer
     * @returns {boolean}
     */

  }, {
    key: 'isViewer',
    value: function isViewer() {
      return true;
    }

    /**
     * Return false
     * @memberof ToastUIEditorViewer
     * @returns {boolean}
     */

  }, {
    key: 'isMarkdownMode',
    value: function isMarkdownMode() {
      return false;
    }

    /**
     * Return false
     * @memberof ToastUIEditorViewer
     * @returns {boolean}
     */

  }, {
    key: 'isWysiwygMode',
    value: function isWysiwygMode() {
      return false;
    }

    /**
     * Define extension
     * @memberof ToastUIEditorViewer
     * @param {string} name Extension name
     * @param {ExtManager~extension} ext extension
     */

  }], [{
    key: 'defineExtension',
    value: function defineExtension(name, ext) {
      _extManager2.default.defineExtension(name, ext);
    }
  }]);

  return ToastUIEditorViewer;
}();

/**
 * check whther is viewer
 * @type {boolean}
 */


ToastUIEditorViewer.isViewer = true;

/**
 * domUtil instance
 * @type {DomUtil}
 */
ToastUIEditorViewer.domUtils = _domUtils2.default;

/**
 * CodeBlockManager instance
 * @type {CodeBlockManager}
 */
ToastUIEditorViewer.codeBlockManager = _codeBlockManager2.default;

/**
 * MarkdownIt hightlight instance
 * @type {MarkdownIt}
 */
ToastUIEditorViewer.markdownitHighlight = _convertor2.default.getMarkdownitHighlightRenderer();

/**
 * @ignore
 */
ToastUIEditorViewer.i18n = null;

/**
 * @ignore
 */
ToastUIEditorViewer.Button = null;

/**
 * @ignore
 */
ToastUIEditorViewer.WwCodeBlockManager = null;

/**
 * @ignore
 */
ToastUIEditorViewer.WwTableManager = null;

/**
 * @ignore
 */
ToastUIEditorViewer.WwTableSelectionManager = null;

module.exports = ToastUIEditorViewer;

/***/ }),
/* 91 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview default UI
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _defaultToolbar = __webpack_require__(92);

var _defaultToolbar2 = _interopRequireDefault(_defaultToolbar);

var _tab = __webpack_require__(44);

var _tab2 = _interopRequireDefault(_tab);

var _layerpopup = __webpack_require__(7);

var _layerpopup2 = _interopRequireDefault(_layerpopup);

var _modeSwitch = __webpack_require__(96);

var _modeSwitch2 = _interopRequireDefault(_modeSwitch);

var _popupAddLink = __webpack_require__(97);

var _popupAddLink2 = _interopRequireDefault(_popupAddLink);

var _popupAddImage = __webpack_require__(98);

var _popupAddImage2 = _interopRequireDefault(_popupAddImage);

var _popupTableUtils = __webpack_require__(99);

var _popupTableUtils2 = _interopRequireDefault(_popupTableUtils);

var _popupAddTable = __webpack_require__(100);

var _popupAddTable2 = _interopRequireDefault(_popupAddTable);

var _popupAddHeading = __webpack_require__(101);

var _popupAddHeading2 = _interopRequireDefault(_popupAddHeading);

var _popupCodeBlockLanguages = __webpack_require__(102);

var _popupCodeBlockLanguages2 = _interopRequireDefault(_popupCodeBlockLanguages);

var _popupCodeBlockEditor = __webpack_require__(103);

var _popupCodeBlockEditor2 = _interopRequireDefault(_popupCodeBlockEditor);

var _i18n = __webpack_require__(3);

var _i18n2 = _interopRequireDefault(_i18n);

var _tooltip = __webpack_require__(28);

var _tooltip2 = _interopRequireDefault(_tooltip);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var CLASS_TOOLBAR = 'te-toolbar-section';
var CLASS_MARKDOWN_TAB = 'te-markdown-tab-section';
var CLASS_EDITOR = 'te-editor-section';
var CLASS_MODE_SWITCH = 'te-mode-switch-section';
var CONTAINER_TEMPLATE = '\n    <div class="tui-editor-defaultUI">\n        <div class="' + CLASS_TOOLBAR + '"><div class="' + CLASS_MARKDOWN_TAB + '"></div></div>\n        <div class="' + CLASS_EDITOR + '"></div>\n        <div class="' + CLASS_MODE_SWITCH + '"></div>\n    </div>\n';

/**
 * Class Default UI
 * initialize ui instances. toolbar, popups
 */

var DefaultUI = function () {

  /**
   * Creates an instance of DefaultUI.
   * @param {ToastUIEditor} editor - editor instance
   * @memberof DefaultUI
   */


  /**
   * mode switch instance
   * @memberof DefaultUI
   * @private
   * @type {ModeSwitch}
   */


  /**
   * markdown tab section jQuery element
   * @memberof DefaultUI
   * @private
   * @type {HTMLElement}
   */


  /**
   * editor type ww/md
   * @memberof DefaultUI
   * @private
   * @type {string}
   */


  /**
   * @memberof DefaultUI
   * @type {HTMLElement}
   * @private
   */


  /**
   * DefaultToolbar wrapper element
   * @memberof DefaultUI
   * @type {jQuery}
   */
  function DefaultUI(editor) {
    _classCallCheck(this, DefaultUI);

    Object.defineProperty(this, 'name', {
      enumerable: true,
      writable: true,
      value: 'default'
    });
    Object.defineProperty(this, '_popups', {
      enumerable: true,
      writable: true,
      value: []
    });

    this._editor = editor;
    this._initialEditType = editor.options.initialEditType;

    this._init(editor.options);
    this._initEvent();
  }

  /**
   * popup instances
   * @memberof DefaultUI
   * @private
   * @type {Array}
   */


  /**
   * markdown tab
   * @memberof DefaultUI
   * @private
   * @type {Tab}
   */


  /**
   * editor instance
   * @memberof DefaultUI
   * @private
   * @type {ToastUIEditor}
   */


  /**
   * editor section element
   * @memberof DefaultUI
   * @private
   * @type {HTMLElement}
   */


  /**
   * DefaultToolbar instance
   * @memberof DefaultUI
   * @type {DefaultToolbar}
   * @private
   */

  /**
   * UI name
   * @memberof DefaultUI
   * @type {string}
   */


  _createClass(DefaultUI, [{
    key: '_init',
    value: function _init(_ref) {
      var container = _ref.el,
          toolbarItems = _ref.toolbarItems,
          hideModeSwitch = _ref.hideModeSwitch;

      this.$el = (0, _jquery2.default)(CONTAINER_TEMPLATE).appendTo(container);
      this._container = container;
      this._editorSection = this.$el.find('.' + CLASS_EDITOR).get(0);
      this._editorSection.appendChild(this._editor.layout.getEditorEl().get(0));

      this._initToolbar(this._editor.eventManager, toolbarItems);
      this._initModeSwitch(hideModeSwitch);

      this._initPopupAddLink();
      this._initPopupAddImage();
      this._initPopupAddTable();
      this._initPopupAddHeading();
      this._initPopupTableUtils();
      this._initPopupCodeBlockLanguages();
      this._initPopupCodeBlockEditor();

      this._initMarkdownTab();
    }
  }, {
    key: '_initEvent',
    value: function _initEvent() {
      this._editor.eventManager.listen('hide', this.hide.bind(this));
      this._editor.eventManager.listen('show', this.show.bind(this));
      this._editor.eventManager.listen('changeMode', this._markdownTabControl.bind(this));
      this._editor.eventManager.listen('changePreviewStyle', this._markdownTabControl.bind(this));
    }
  }, {
    key: '_initToolbar',
    value: function _initToolbar(eventManager, toolbarItems) {
      var toolbar = new _defaultToolbar2.default(eventManager, toolbarItems);
      this._toolbar = toolbar;
      this.$el.find('.' + CLASS_TOOLBAR).append(toolbar.$el);
    }
  }, {
    key: '_initModeSwitch',
    value: function _initModeSwitch(hideModeSwitch) {
      var _this = this;

      var modeSwitchTabBar = this.$el.find('.' + CLASS_MODE_SWITCH);
      var editType = this._initialEditType === 'markdown' ? _modeSwitch2.default.TYPE.MARKDOWN : _modeSwitch2.default.TYPE.WYSIWYG;
      var modeSwitch = new _modeSwitch2.default(modeSwitchTabBar, editType);
      this._modeSwitch = modeSwitch;

      if (hideModeSwitch) {
        modeSwitch.hide();
      }

      modeSwitch.on('modeSwitched', function (ev, type) {
        return _this._editor.changeMode(type);
      });
    }
  }, {
    key: '_initMarkdownTab',
    value: function _initMarkdownTab() {
      var editor = this._editor;

      this._markdownTab = new _tab2.default({
        initName: _i18n2.default.get('Write'),
        items: [_i18n2.default.get('Write'), _i18n2.default.get('Preview')],
        sections: [editor.layout.getMdEditorContainerEl(), editor.layout.getPreviewEl()]
      });
      this._$markdownTabSection = this.$el.find('.' + CLASS_MARKDOWN_TAB);
      this._$markdownTabSection.append(this._markdownTab.$el);

      this._markdownTab.on('itemClick', function (ev, itemText) {
        if (itemText === _i18n2.default.get('Preview')) {
          editor.eventManager.emit('previewNeedsRefresh');
        } else {
          editor.getCodeMirror().focus();
        }
      });
    }
  }, {
    key: '_markdownTabControl',
    value: function _markdownTabControl() {
      if (this._editor.isMarkdownMode() && this._editor.getCurrentPreviewStyle() === 'tab') {
        this._$markdownTabSection.show();
        this._markdownTab.activate(_i18n2.default.get('Write'));
      } else {
        this._$markdownTabSection.hide();
      }
    }
  }, {
    key: '_initPopupAddLink',
    value: function _initPopupAddLink() {
      this._popups.push(new _popupAddLink2.default({
        $target: this.$el,
        editor: this._editor
      }));
    }
  }, {
    key: '_initPopupAddImage',
    value: function _initPopupAddImage() {
      this._popups.push(new _popupAddImage2.default({
        $target: this.$el,
        eventManager: this._editor.eventManager
      }));
    }
  }, {
    key: '_initPopupAddTable',
    value: function _initPopupAddTable() {
      this._popups.push(new _popupAddTable2.default({
        $target: this.$el,
        eventManager: this._editor.eventManager,
        $button: this.$el.find('button.tui-table'),
        css: {
          'position': 'fixed'
        }
      }));
    }
  }, {
    key: '_initPopupAddHeading',
    value: function _initPopupAddHeading() {
      this._popups.push(new _popupAddHeading2.default({
        $target: this.$el,
        eventManager: this._editor.eventManager,
        $button: this.$el.find('button.tui-heading'),
        css: {
          'position': 'fixed'
        }
      }));
    }
  }, {
    key: '_initPopupTableUtils',
    value: function _initPopupTableUtils() {
      var _this2 = this;

      this._editor.eventManager.listen('contextmenu', function (ev) {
        if ((0, _jquery2.default)(ev.data.target).parents('[contenteditable=true] table').length > 0) {
          ev.data.preventDefault();
          _this2._editor.eventManager.emit('openPopupTableUtils', ev.data);
        }
      });

      this._popups.push(new _popupTableUtils2.default({
        $target: this.$el,
        eventManager: this._editor.eventManager
      }));
    }
  }, {
    key: '_initPopupCodeBlockLanguages',
    value: function _initPopupCodeBlockLanguages() {
      var editor = this._editor;
      this._popups.push(new _popupCodeBlockLanguages2.default({
        $target: this.$el,
        eventManager: editor.eventManager,
        languages: editor.options.codeBlockLanguages
      }));
    }
  }, {
    key: '_initPopupCodeBlockEditor',
    value: function _initPopupCodeBlockEditor() {
      this._popups.push(new _popupCodeBlockEditor2.default({
        $target: this.$el,
        eventManager: this._editor.eventManager,
        convertor: this._editor.convertor
      }));
    }

    /**
     * get toolbar instance
     * @returns {DefaultToolbar} - toolbar instance
     * @memberof DefaultUI
     */

  }, {
    key: 'getToolbar',
    value: function getToolbar() {
      return this._toolbar;
    }

    /**
     * set toolbar instance
     * @param {DefaultToolbar} toolbar - toolbar
     * @memberof DefaultUI
     */

  }, {
    key: 'setToolbar',
    value: function setToolbar(toolbar) {
      this._toolbar.destroy();
      this._toolbar = toolbar;
    }

    /**
     * get mode switch instance
     * @memberof DefaultUI
     * @returns {ModeSwitch} - mode switch instance
     */

  }, {
    key: 'getModeSwitch',
    value: function getModeSwitch() {
      return this._modeSwitch;
    }

    /**
     * get editor section height
     * @returns {Number} - height of editor section
     * @memberof DefaultUI
     */

  }, {
    key: 'getEditorSectionHeight',
    value: function getEditorSectionHeight() {
      var clientRect = this._editorSection.getBoundingClientRect();

      return clientRect.bottom - clientRect.top;
    }

    /**
     * get editor height
     * @returns {Number} - height of editor
     * @memberof DefaultUI
     */

  }, {
    key: 'getEditorHeight',
    value: function getEditorHeight() {
      var clientRect = this._container.getBoundingClientRect();

      return clientRect.bottom - clientRect.top;
    }

    /**
     * hide
     * @memberof DefaultUI
     */

  }, {
    key: 'hide',
    value: function hide() {
      this.$el.addClass('te-hide');
    }

    /**
     * show
     * @memberof DefaultUI
     */

  }, {
    key: 'show',
    value: function show() {
      this.$el.removeClass('te-hide');
    }

    /**
     * remove
     * @memberof DefaultUI
     */

  }, {
    key: 'remove',
    value: function remove() {
      this.$el.remove();
      _tooltip2.default.hide();
    }

    /**
     * creates popup
     * @param {LayerPopupOption} options - layerPopup options
     * @returns {LayerPopup} - crated layerPopup
     * @memberof DefaultUI
     */

  }, {
    key: 'createPopup',
    value: function createPopup(options) {
      return new _layerpopup2.default(options);
    }
  }]);

  return DefaultUI;
}();

exports.default = DefaultUI;

/***/ }),
/* 92 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _resizeObserverPolyfill = __webpack_require__(93);

var _resizeObserverPolyfill2 = _interopRequireDefault(_resizeObserverPolyfill);

var _i18n = __webpack_require__(3);

var _i18n2 = _interopRequireDefault(_i18n);

var _toolbar = __webpack_require__(41);

var _toolbar2 = _interopRequireDefault(_toolbar);

var _popupDropdownToolbar = __webpack_require__(95);

var _popupDropdownToolbar2 = _interopRequireDefault(_popupDropdownToolbar);

var _toolbarItemFactory = __webpack_require__(43);

var _toolbarItemFactory2 = _interopRequireDefault(_toolbarItemFactory);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview implements DefaultToolbar
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var MORE_BUTTON_NAME = 'more';

/**
 * default toolbar
 * @extends Toolbar
 */

var DefaultToolbar = function (_Toolbar) {
  _inherits(DefaultToolbar, _Toolbar);

  /**
   * popup dropdown toolbar
   * @memberof DefaultToolbar
   * @private
   * @type {PopupDropdownToolbar}
   */
  function DefaultToolbar(eventManager, options) {
    _classCallCheck(this, DefaultToolbar);

    var _this = _possibleConstructorReturn(this, (DefaultToolbar.__proto__ || Object.getPrototypeOf(DefaultToolbar)).call(this, eventManager, options));

    _this._init(eventManager);
    _this._bindWidthChangedEvent();
    return _this;
  }

  /**
   * insert toolbar item
   * @param  {number} index - index at given item inserted
   * @param  {ToolbarItem|string|object} item - toolbar item
   * @memberof Toolbar
   */


  /**
   * resize observer
   * @memberof DefaultToolbar
   * @private
   * @type {ResizeObserver}
   */

  /**
   * more button
   * @memberof DefaultToolbar
   * @private
   * @type {ToolbarButton}
   */


  _createClass(DefaultToolbar, [{
    key: 'insertItem',
    value: function insertItem(index, item) {
      _get(DefaultToolbar.prototype.__proto__ || Object.getPrototypeOf(DefaultToolbar.prototype), 'insertItem', this).call(this, index, item);
      this._arrangeMoreButton();
    }
  }, {
    key: '_init',
    value: function _init(eventManager) {
      var moreButton = _toolbarItemFactory2.default.create('button', {
        name: MORE_BUTTON_NAME,
        className: 'tui-more',
        tooltip: _i18n2.default.get('More'),
        event: _popupDropdownToolbar2.default.OPEN_EVENT
      });
      this._moreButton = moreButton;

      this._popupDropdownToolbar = new _popupDropdownToolbar2.default({
        eventManager: eventManager,
        $target: this.$el,
        $button: moreButton.$el
      });

      this.addItem(moreButton);
    }
  }, {
    key: '_bindWidthChangedEvent',
    value: function _bindWidthChangedEvent() {
      var _this2 = this;

      this._observer = new _resizeObserverPolyfill2.default(function () {
        _this2._popupDropdownToolbar.hide();
        _this2._balanceButtons();
      });
      this._observer.observe(this.$el.get(0));
    }
  }, {
    key: '_balanceButtons',
    value: function _balanceButtons() {
      var _this3 = this;

      var dropDownToolbarItems = this._popupDropdownToolbar.getItems();
      dropDownToolbarItems.forEach(function (item) {
        _this3._popupDropdownToolbar.removeItem(item, false);

        var itemLength = _this3.getItems().length;
        _get(DefaultToolbar.prototype.__proto__ || Object.getPrototypeOf(DefaultToolbar.prototype), 'insertItem', _this3).call(_this3, itemLength, item);
      });

      this.removeItem(this._moreButton, false);
      _get(DefaultToolbar.prototype.__proto__ || Object.getPrototypeOf(DefaultToolbar.prototype), 'insertItem', this).call(this, 0, this._moreButton);

      var toolbarHeight = this.$el.height();
      var defaultToolbarItems = this.getItems();
      var overflowItems = defaultToolbarItems.filter(function (item) {
        return item.$el.position().top > toolbarHeight;
      });

      overflowItems.forEach(function (item) {
        _this3.removeItem(item, false);
        _this3._popupDropdownToolbar.addItem(item);
      });

      this._arrangeMoreButton();
    }
  }, {
    key: '_arrangeMoreButton',
    value: function _arrangeMoreButton() {
      if (!this._popupDropdownToolbar) {
        return;
      }

      this.removeItem(this._moreButton, false);

      var hasOverflow = this._popupDropdownToolbar.getItems().length > 0;
      var itemLength = this.getItems().length;
      if (hasOverflow) {
        _get(DefaultToolbar.prototype.__proto__ || Object.getPrototypeOf(DefaultToolbar.prototype), 'insertItem', this).call(this, itemLength, this._moreButton);
      }
    }

    /**
     * destroy
     * @override
     */

  }, {
    key: 'destroy',
    value: function destroy() {
      if (this._observer) {
        this._observer.disconnect();
      }
    }
  }]);

  return DefaultToolbar;
}(_toolbar2.default);

exports.default = DefaultToolbar;

/***/ }),
/* 93 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* WEBPACK VAR INJECTION */(function(global) {/**
 * A collection of shims that provide minimal functionality of the ES6 collections.
 *
 * These implementations are not meant to be used outside of the ResizeObserver
 * modules as they cover only a limited range of use cases.
 */
/* eslint-disable require-jsdoc, valid-jsdoc */
var MapShim = (function () {
    if (typeof Map !== 'undefined') {
        return Map;
    }

    /**
     * Returns index in provided array that matches the specified key.
     *
     * @param {Array<Array>} arr
     * @param {*} key
     * @returns {number}
     */
    function getIndex(arr, key) {
        var result = -1;

        arr.some(function (entry, index) {
            if (entry[0] === key) {
                result = index;

                return true;
            }

            return false;
        });

        return result;
    }

    return (function () {
        function anonymous() {
            this.__entries__ = [];
        }

        var prototypeAccessors = { size: { configurable: true } };

        /**
         * @returns {boolean}
         */
        prototypeAccessors.size.get = function () {
            return this.__entries__.length;
        };

        /**
         * @param {*} key
         * @returns {*}
         */
        anonymous.prototype.get = function (key) {
            var index = getIndex(this.__entries__, key);
            var entry = this.__entries__[index];

            return entry && entry[1];
        };

        /**
         * @param {*} key
         * @param {*} value
         * @returns {void}
         */
        anonymous.prototype.set = function (key, value) {
            var index = getIndex(this.__entries__, key);

            if (~index) {
                this.__entries__[index][1] = value;
            } else {
                this.__entries__.push([key, value]);
            }
        };

        /**
         * @param {*} key
         * @returns {void}
         */
        anonymous.prototype.delete = function (key) {
            var entries = this.__entries__;
            var index = getIndex(entries, key);

            if (~index) {
                entries.splice(index, 1);
            }
        };

        /**
         * @param {*} key
         * @returns {void}
         */
        anonymous.prototype.has = function (key) {
            return !!~getIndex(this.__entries__, key);
        };

        /**
         * @returns {void}
         */
        anonymous.prototype.clear = function () {
            this.__entries__.splice(0);
        };

        /**
         * @param {Function} callback
         * @param {*} [ctx=null]
         * @returns {void}
         */
        anonymous.prototype.forEach = function (callback, ctx) {
            var this$1 = this;
            if ( ctx === void 0 ) ctx = null;

            for (var i = 0, list = this$1.__entries__; i < list.length; i += 1) {
                var entry = list[i];

                callback.call(ctx, entry[1], entry[0]);
            }
        };

        Object.defineProperties( anonymous.prototype, prototypeAccessors );

        return anonymous;
    }());
})();

/**
 * Detects whether window and document objects are available in current environment.
 */
var isBrowser = typeof window !== 'undefined' && typeof document !== 'undefined' && window.document === document;

// Returns global object of a current environment.
var global$1 = (function () {
    if (typeof global !== 'undefined' && global.Math === Math) {
        return global;
    }

    if (typeof self !== 'undefined' && self.Math === Math) {
        return self;
    }

    if (typeof window !== 'undefined' && window.Math === Math) {
        return window;
    }

    // eslint-disable-next-line no-new-func
    return Function('return this')();
})();

/**
 * A shim for the requestAnimationFrame which falls back to the setTimeout if
 * first one is not supported.
 *
 * @returns {number} Requests' identifier.
 */
var requestAnimationFrame$1 = (function () {
    if (typeof requestAnimationFrame === 'function') {
        // It's required to use a bounded function because IE sometimes throws
        // an "Invalid calling object" error if rAF is invoked without the global
        // object on the left hand side.
        return requestAnimationFrame.bind(global$1);
    }

    return function (callback) { return setTimeout(function () { return callback(Date.now()); }, 1000 / 60); };
})();

// Defines minimum timeout before adding a trailing call.
var trailingTimeout = 2;

/**
 * Creates a wrapper function which ensures that provided callback will be
 * invoked only once during the specified delay period.
 *
 * @param {Function} callback - Function to be invoked after the delay period.
 * @param {number} delay - Delay after which to invoke callback.
 * @returns {Function}
 */
var throttle = function (callback, delay) {
    var leadingCall = false,
        trailingCall = false,
        lastCallTime = 0;

    /**
     * Invokes the original callback function and schedules new invocation if
     * the "proxy" was called during current request.
     *
     * @returns {void}
     */
    function resolvePending() {
        if (leadingCall) {
            leadingCall = false;

            callback();
        }

        if (trailingCall) {
            proxy();
        }
    }

    /**
     * Callback invoked after the specified delay. It will further postpone
     * invocation of the original function delegating it to the
     * requestAnimationFrame.
     *
     * @returns {void}
     */
    function timeoutCallback() {
        requestAnimationFrame$1(resolvePending);
    }

    /**
     * Schedules invocation of the original function.
     *
     * @returns {void}
     */
    function proxy() {
        var timeStamp = Date.now();

        if (leadingCall) {
            // Reject immediately following calls.
            if (timeStamp - lastCallTime < trailingTimeout) {
                return;
            }

            // Schedule new call to be in invoked when the pending one is resolved.
            // This is important for "transitions" which never actually start
            // immediately so there is a chance that we might miss one if change
            // happens amids the pending invocation.
            trailingCall = true;
        } else {
            leadingCall = true;
            trailingCall = false;

            setTimeout(timeoutCallback, delay);
        }

        lastCallTime = timeStamp;
    }

    return proxy;
};

// Minimum delay before invoking the update of observers.
var REFRESH_DELAY = 20;

// A list of substrings of CSS properties used to find transition events that
// might affect dimensions of observed elements.
var transitionKeys = ['top', 'right', 'bottom', 'left', 'width', 'height', 'size', 'weight'];

// Check if MutationObserver is available.
var mutationObserverSupported = typeof MutationObserver !== 'undefined';

/**
 * Singleton controller class which handles updates of ResizeObserver instances.
 */
var ResizeObserverController = function() {
    this.connected_ = false;
    this.mutationEventsAdded_ = false;
    this.mutationsObserver_ = null;
    this.observers_ = [];

    this.onTransitionEnd_ = this.onTransitionEnd_.bind(this);
    this.refresh = throttle(this.refresh.bind(this), REFRESH_DELAY);
};

/**
 * Adds observer to observers list.
 *
 * @param {ResizeObserverSPI} observer - Observer to be added.
 * @returns {void}
 */


/**
 * Holds reference to the controller's instance.
 *
 * @private {ResizeObserverController}
 */


/**
 * Keeps reference to the instance of MutationObserver.
 *
 * @private {MutationObserver}
 */

/**
 * Indicates whether DOM listeners have been added.
 *
 * @private {boolean}
 */
ResizeObserverController.prototype.addObserver = function (observer) {
    if (!~this.observers_.indexOf(observer)) {
        this.observers_.push(observer);
    }

    // Add listeners if they haven't been added yet.
    if (!this.connected_) {
        this.connect_();
    }
};

/**
 * Removes observer from observers list.
 *
 * @param {ResizeObserverSPI} observer - Observer to be removed.
 * @returns {void}
 */
ResizeObserverController.prototype.removeObserver = function (observer) {
    var observers = this.observers_;
    var index = observers.indexOf(observer);

    // Remove observer if it's present in registry.
    if (~index) {
        observers.splice(index, 1);
    }

    // Remove listeners if controller has no connected observers.
    if (!observers.length && this.connected_) {
        this.disconnect_();
    }
};

/**
 * Invokes the update of observers. It will continue running updates insofar
 * it detects changes.
 *
 * @returns {void}
 */
ResizeObserverController.prototype.refresh = function () {
    var changesDetected = this.updateObservers_();

    // Continue running updates if changes have been detected as there might
    // be future ones caused by CSS transitions.
    if (changesDetected) {
        this.refresh();
    }
};

/**
 * Updates every observer from observers list and notifies them of queued
 * entries.
 *
 * @private
 * @returns {boolean} Returns "true" if any observer has detected changes in
 *  dimensions of it's elements.
 */
ResizeObserverController.prototype.updateObservers_ = function () {
    // Collect observers that have active observations.
    var activeObservers = this.observers_.filter(function (observer) {
        return observer.gatherActive(), observer.hasActive();
    });

    // Deliver notifications in a separate cycle in order to avoid any
    // collisions between observers, e.g. when multiple instances of
    // ResizeObserver are tracking the same element and the callback of one
    // of them changes content dimensions of the observed target. Sometimes
    // this may result in notifications being blocked for the rest of observers.
    activeObservers.forEach(function (observer) { return observer.broadcastActive(); });

    return activeObservers.length > 0;
};

/**
 * Initializes DOM listeners.
 *
 * @private
 * @returns {void}
 */
ResizeObserverController.prototype.connect_ = function () {
    // Do nothing if running in a non-browser environment or if listeners
    // have been already added.
    if (!isBrowser || this.connected_) {
        return;
    }

    // Subscription to the "Transitionend" event is used as a workaround for
    // delayed transitions. This way it's possible to capture at least the
    // final state of an element.
    document.addEventListener('transitionend', this.onTransitionEnd_);

    window.addEventListener('resize', this.refresh);

    if (mutationObserverSupported) {
        this.mutationsObserver_ = new MutationObserver(this.refresh);

        this.mutationsObserver_.observe(document, {
            attributes: true,
            childList: true,
            characterData: true,
            subtree: true
        });
    } else {
        document.addEventListener('DOMSubtreeModified', this.refresh);

        this.mutationEventsAdded_ = true;
    }

    this.connected_ = true;
};

/**
 * Removes DOM listeners.
 *
 * @private
 * @returns {void}
 */
ResizeObserverController.prototype.disconnect_ = function () {
    // Do nothing if running in a non-browser environment or if listeners
    // have been already removed.
    if (!isBrowser || !this.connected_) {
        return;
    }

    document.removeEventListener('transitionend', this.onTransitionEnd_);
    window.removeEventListener('resize', this.refresh);

    if (this.mutationsObserver_) {
        this.mutationsObserver_.disconnect();
    }

    if (this.mutationEventsAdded_) {
        document.removeEventListener('DOMSubtreeModified', this.refresh);
    }

    this.mutationsObserver_ = null;
    this.mutationEventsAdded_ = false;
    this.connected_ = false;
};

/**
 * "Transitionend" event handler.
 *
 * @private
 * @param {TransitionEvent} event
 * @returns {void}
 */
ResizeObserverController.prototype.onTransitionEnd_ = function (ref) {
        var propertyName = ref.propertyName; if ( propertyName === void 0 ) propertyName = '';

    // Detect whether transition may affect dimensions of an element.
    var isReflowProperty = transitionKeys.some(function (key) {
        return !!~propertyName.indexOf(key);
    });

    if (isReflowProperty) {
        this.refresh();
    }
};

/**
 * Returns instance of the ResizeObserverController.
 *
 * @returns {ResizeObserverController}
 */
ResizeObserverController.getInstance = function () {
    if (!this.instance_) {
        this.instance_ = new ResizeObserverController();
    }

    return this.instance_;
};

ResizeObserverController.instance_ = null;

/**
 * Defines non-writable/enumerable properties of the provided target object.
 *
 * @param {Object} target - Object for which to define properties.
 * @param {Object} props - Properties to be defined.
 * @returns {Object} Target object.
 */
var defineConfigurable = (function (target, props) {
    for (var i = 0, list = Object.keys(props); i < list.length; i += 1) {
        var key = list[i];

        Object.defineProperty(target, key, {
            value: props[key],
            enumerable: false,
            writable: false,
            configurable: true
        });
    }

    return target;
});

/**
 * Returns the global object associated with provided element.
 *
 * @param {Object} target
 * @returns {Object}
 */
var getWindowOf = (function (target) {
    // Assume that the element is an instance of Node, which means that it
    // has the "ownerDocument" property from which we can retrieve a
    // corresponding global object.
    var ownerGlobal = target && target.ownerDocument && target.ownerDocument.defaultView;

    // Return the local global object if it's not possible extract one from
    // provided element.
    return ownerGlobal || global$1;
});

// Placeholder of an empty content rectangle.
var emptyRect = createRectInit(0, 0, 0, 0);

/**
 * Converts provided string to a number.
 *
 * @param {number|string} value
 * @returns {number}
 */
function toFloat(value) {
    return parseFloat(value) || 0;
}

/**
 * Extracts borders size from provided styles.
 *
 * @param {CSSStyleDeclaration} styles
 * @param {...string} positions - Borders positions (top, right, ...)
 * @returns {number}
 */
function getBordersSize(styles) {
    var positions = [], len = arguments.length - 1;
    while ( len-- > 0 ) positions[ len ] = arguments[ len + 1 ];

    return positions.reduce(function (size, position) {
        var value = styles['border-' + position + '-width'];

        return size + toFloat(value);
    }, 0);
}

/**
 * Extracts paddings sizes from provided styles.
 *
 * @param {CSSStyleDeclaration} styles
 * @returns {Object} Paddings box.
 */
function getPaddings(styles) {
    var positions = ['top', 'right', 'bottom', 'left'];
    var paddings = {};

    for (var i = 0, list = positions; i < list.length; i += 1) {
        var position = list[i];

        var value = styles['padding-' + position];

        paddings[position] = toFloat(value);
    }

    return paddings;
}

/**
 * Calculates content rectangle of provided SVG element.
 *
 * @param {SVGGraphicsElement} target - Element content rectangle of which needs
 *      to be calculated.
 * @returns {DOMRectInit}
 */
function getSVGContentRect(target) {
    var bbox = target.getBBox();

    return createRectInit(0, 0, bbox.width, bbox.height);
}

/**
 * Calculates content rectangle of provided HTMLElement.
 *
 * @param {HTMLElement} target - Element for which to calculate the content rectangle.
 * @returns {DOMRectInit}
 */
function getHTMLElementContentRect(target) {
    // Client width & height properties can't be
    // used exclusively as they provide rounded values.
    var clientWidth = target.clientWidth;
    var clientHeight = target.clientHeight;

    // By this condition we can catch all non-replaced inline, hidden and
    // detached elements. Though elements with width & height properties less
    // than 0.5 will be discarded as well.
    //
    // Without it we would need to implement separate methods for each of
    // those cases and it's not possible to perform a precise and performance
    // effective test for hidden elements. E.g. even jQuery's ':visible' filter
    // gives wrong results for elements with width & height less than 0.5.
    if (!clientWidth && !clientHeight) {
        return emptyRect;
    }

    var styles = getWindowOf(target).getComputedStyle(target);
    var paddings = getPaddings(styles);
    var horizPad = paddings.left + paddings.right;
    var vertPad = paddings.top + paddings.bottom;

    // Computed styles of width & height are being used because they are the
    // only dimensions available to JS that contain non-rounded values. It could
    // be possible to utilize the getBoundingClientRect if only it's data wasn't
    // affected by CSS transformations let alone paddings, borders and scroll bars.
    var width = toFloat(styles.width),
        height = toFloat(styles.height);

    // Width & height include paddings and borders when the 'border-box' box
    // model is applied (except for IE).
    if (styles.boxSizing === 'border-box') {
        // Following conditions are required to handle Internet Explorer which
        // doesn't include paddings and borders to computed CSS dimensions.
        //
        // We can say that if CSS dimensions + paddings are equal to the "client"
        // properties then it's either IE, and thus we don't need to subtract
        // anything, or an element merely doesn't have paddings/borders styles.
        if (Math.round(width + horizPad) !== clientWidth) {
            width -= getBordersSize(styles, 'left', 'right') + horizPad;
        }

        if (Math.round(height + vertPad) !== clientHeight) {
            height -= getBordersSize(styles, 'top', 'bottom') + vertPad;
        }
    }

    // Following steps can't be applied to the document's root element as its
    // client[Width/Height] properties represent viewport area of the window.
    // Besides, it's as well not necessary as the <html> itself neither has
    // rendered scroll bars nor it can be clipped.
    if (!isDocumentElement(target)) {
        // In some browsers (only in Firefox, actually) CSS width & height
        // include scroll bars size which can be removed at this step as scroll
        // bars are the only difference between rounded dimensions + paddings
        // and "client" properties, though that is not always true in Chrome.
        var vertScrollbar = Math.round(width + horizPad) - clientWidth;
        var horizScrollbar = Math.round(height + vertPad) - clientHeight;

        // Chrome has a rather weird rounding of "client" properties.
        // E.g. for an element with content width of 314.2px it sometimes gives
        // the client width of 315px and for the width of 314.7px it may give
        // 314px. And it doesn't happen all the time. So just ignore this delta
        // as a non-relevant.
        if (Math.abs(vertScrollbar) !== 1) {
            width -= vertScrollbar;
        }

        if (Math.abs(horizScrollbar) !== 1) {
            height -= horizScrollbar;
        }
    }

    return createRectInit(paddings.left, paddings.top, width, height);
}

/**
 * Checks whether provided element is an instance of the SVGGraphicsElement.
 *
 * @param {Element} target - Element to be checked.
 * @returns {boolean}
 */
var isSVGGraphicsElement = (function () {
    // Some browsers, namely IE and Edge, don't have the SVGGraphicsElement
    // interface.
    if (typeof SVGGraphicsElement !== 'undefined') {
        return function (target) { return target instanceof getWindowOf(target).SVGGraphicsElement; };
    }

    // If it's so, then check that element is at least an instance of the
    // SVGElement and that it has the "getBBox" method.
    // eslint-disable-next-line no-extra-parens
    return function (target) { return target instanceof getWindowOf(target).SVGElement && typeof target.getBBox === 'function'; };
})();

/**
 * Checks whether provided element is a document element (<html>).
 *
 * @param {Element} target - Element to be checked.
 * @returns {boolean}
 */
function isDocumentElement(target) {
    return target === getWindowOf(target).document.documentElement;
}

/**
 * Calculates an appropriate content rectangle for provided html or svg element.
 *
 * @param {Element} target - Element content rectangle of which needs to be calculated.
 * @returns {DOMRectInit}
 */
function getContentRect(target) {
    if (!isBrowser) {
        return emptyRect;
    }

    if (isSVGGraphicsElement(target)) {
        return getSVGContentRect(target);
    }

    return getHTMLElementContentRect(target);
}

/**
 * Creates rectangle with an interface of the DOMRectReadOnly.
 * Spec: https://drafts.fxtf.org/geometry/#domrectreadonly
 *
 * @param {DOMRectInit} rectInit - Object with rectangle's x/y coordinates and dimensions.
 * @returns {DOMRectReadOnly}
 */
function createReadOnlyRect(ref) {
    var x = ref.x;
    var y = ref.y;
    var width = ref.width;
    var height = ref.height;

    // If DOMRectReadOnly is available use it as a prototype for the rectangle.
    var Constr = typeof DOMRectReadOnly !== 'undefined' ? DOMRectReadOnly : Object;
    var rect = Object.create(Constr.prototype);

    // Rectangle's properties are not writable and non-enumerable.
    defineConfigurable(rect, {
        x: x, y: y, width: width, height: height,
        top: y,
        right: x + width,
        bottom: height + y,
        left: x
    });

    return rect;
}

/**
 * Creates DOMRectInit object based on the provided dimensions and the x/y coordinates.
 * Spec: https://drafts.fxtf.org/geometry/#dictdef-domrectinit
 *
 * @param {number} x - X coordinate.
 * @param {number} y - Y coordinate.
 * @param {number} width - Rectangle's width.
 * @param {number} height - Rectangle's height.
 * @returns {DOMRectInit}
 */
function createRectInit(x, y, width, height) {
    return { x: x, y: y, width: width, height: height };
}

/**
 * Class that is responsible for computations of the content rectangle of
 * provided DOM element and for keeping track of it's changes.
 */
var ResizeObservation = function(target) {
    this.broadcastWidth = 0;
    this.broadcastHeight = 0;
    this.contentRect_ = createRectInit(0, 0, 0, 0);

    this.target = target;
};

/**
 * Updates content rectangle and tells whether it's width or height properties
 * have changed since the last broadcast.
 *
 * @returns {boolean}
 */


/**
 * Reference to the last observed content rectangle.
 *
 * @private {DOMRectInit}
 */


/**
 * Broadcasted width of content rectangle.
 *
 * @type {number}
 */
ResizeObservation.prototype.isActive = function () {
    var rect = getContentRect(this.target);

    this.contentRect_ = rect;

    return rect.width !== this.broadcastWidth || rect.height !== this.broadcastHeight;
};

/**
 * Updates 'broadcastWidth' and 'broadcastHeight' properties with a data
 * from the corresponding properties of the last observed content rectangle.
 *
 * @returns {DOMRectInit} Last observed content rectangle.
 */
ResizeObservation.prototype.broadcastRect = function () {
    var rect = this.contentRect_;

    this.broadcastWidth = rect.width;
    this.broadcastHeight = rect.height;

    return rect;
};

var ResizeObserverEntry = function(target, rectInit) {
    var contentRect = createReadOnlyRect(rectInit);

    // According to the specification following properties are not writable
    // and are also not enumerable in the native implementation.
    //
    // Property accessors are not being used as they'd require to define a
    // private WeakMap storage which may cause memory leaks in browsers that
    // don't support this type of collections.
    defineConfigurable(this, { target: target, contentRect: contentRect });
};

var ResizeObserverSPI = function(callback, controller, callbackCtx) {
    this.activeObservations_ = [];
    this.observations_ = new MapShim();

    if (typeof callback !== 'function') {
        throw new TypeError('The callback provided as parameter 1 is not a function.');
    }

    this.callback_ = callback;
    this.controller_ = controller;
    this.callbackCtx_ = callbackCtx;
};

/**
 * Starts observing provided element.
 *
 * @param {Element} target - Element to be observed.
 * @returns {void}
 */


/**
 * Registry of the ResizeObservation instances.
 *
 * @private {Map<Element, ResizeObservation>}
 */


/**
 * Public ResizeObserver instance which will be passed to the callback
 * function and used as a value of it's "this" binding.
 *
 * @private {ResizeObserver}
 */

/**
 * Collection of resize observations that have detected changes in dimensions
 * of elements.
 *
 * @private {Array<ResizeObservation>}
 */
ResizeObserverSPI.prototype.observe = function (target) {
    if (!arguments.length) {
        throw new TypeError('1 argument required, but only 0 present.');
    }

    // Do nothing if current environment doesn't have the Element interface.
    if (typeof Element === 'undefined' || !(Element instanceof Object)) {
        return;
    }

    if (!(target instanceof getWindowOf(target).Element)) {
        throw new TypeError('parameter 1 is not of type "Element".');
    }

    var observations = this.observations_;

    // Do nothing if element is already being observed.
    if (observations.has(target)) {
        return;
    }

    observations.set(target, new ResizeObservation(target));

    this.controller_.addObserver(this);

    // Force the update of observations.
    this.controller_.refresh();
};

/**
 * Stops observing provided element.
 *
 * @param {Element} target - Element to stop observing.
 * @returns {void}
 */
ResizeObserverSPI.prototype.unobserve = function (target) {
    if (!arguments.length) {
        throw new TypeError('1 argument required, but only 0 present.');
    }

    // Do nothing if current environment doesn't have the Element interface.
    if (typeof Element === 'undefined' || !(Element instanceof Object)) {
        return;
    }

    if (!(target instanceof getWindowOf(target).Element)) {
        throw new TypeError('parameter 1 is not of type "Element".');
    }

    var observations = this.observations_;

    // Do nothing if element is not being observed.
    if (!observations.has(target)) {
        return;
    }

    observations.delete(target);

    if (!observations.size) {
        this.controller_.removeObserver(this);
    }
};

/**
 * Stops observing all elements.
 *
 * @returns {void}
 */
ResizeObserverSPI.prototype.disconnect = function () {
    this.clearActive();
    this.observations_.clear();
    this.controller_.removeObserver(this);
};

/**
 * Collects observation instances the associated element of which has changed
 * it's content rectangle.
 *
 * @returns {void}
 */
ResizeObserverSPI.prototype.gatherActive = function () {
        var this$1 = this;

    this.clearActive();

    this.observations_.forEach(function (observation) {
        if (observation.isActive()) {
            this$1.activeObservations_.push(observation);
        }
    });
};

/**
 * Invokes initial callback function with a list of ResizeObserverEntry
 * instances collected from active resize observations.
 *
 * @returns {void}
 */
ResizeObserverSPI.prototype.broadcastActive = function () {
    // Do nothing if observer doesn't have active observations.
    if (!this.hasActive()) {
        return;
    }

    var ctx = this.callbackCtx_;

    // Create ResizeObserverEntry instance for every active observation.
    var entries = this.activeObservations_.map(function (observation) {
        return new ResizeObserverEntry(observation.target, observation.broadcastRect());
    });

    this.callback_.call(ctx, entries, ctx);
    this.clearActive();
};

/**
 * Clears the collection of active observations.
 *
 * @returns {void}
 */
ResizeObserverSPI.prototype.clearActive = function () {
    this.activeObservations_.splice(0);
};

/**
 * Tells whether observer has active observations.
 *
 * @returns {boolean}
 */
ResizeObserverSPI.prototype.hasActive = function () {
    return this.activeObservations_.length > 0;
};

// Registry of internal observers. If WeakMap is not available use current shim
// for the Map collection as it has all required methods and because WeakMap
// can't be fully polyfilled anyway.
var observers = typeof WeakMap !== 'undefined' ? new WeakMap() : new MapShim();

/**
 * ResizeObserver API. Encapsulates the ResizeObserver SPI implementation
 * exposing only those methods and properties that are defined in the spec.
 */
var ResizeObserver = function(callback) {
    if (!(this instanceof ResizeObserver)) {
        throw new TypeError('Cannot call a class as a function.');
    }
    if (!arguments.length) {
        throw new TypeError('1 argument required, but only 0 present.');
    }

    var controller = ResizeObserverController.getInstance();
    var observer = new ResizeObserverSPI(callback, controller, this);

    observers.set(this, observer);
};

// Expose public methods of ResizeObserver.
['observe', 'unobserve', 'disconnect'].forEach(function (method) {
    ResizeObserver.prototype[method] = function () {
        return (ref = observers.get(this))[method].apply(ref, arguments);
        var ref;
    };
});

var index = (function () {
    // Export existing implementation if available.
    if (typeof global$1.ResizeObserver !== 'undefined') {
        return global$1.ResizeObserver;
    }

    return ResizeObserver;
})();

/* harmony default export */ __webpack_exports__["default"] = (index);

/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(12)))

/***/ }),
/* 94 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _button = __webpack_require__(20);

var _button2 = _interopRequireDefault(_button);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements UI Button
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


/**
 * Toolbar Button UI
 * @extends {ToolbarItem}
 */
var ToolbarButton = function (_Button) {
  _inherits(ToolbarButton, _Button);

  function ToolbarButton() {
    _classCallCheck(this, ToolbarButton);

    return _possibleConstructorReturn(this, (ToolbarButton.__proto__ || Object.getPrototypeOf(ToolbarButton)).apply(this, arguments));
  }

  return ToolbarButton;
}(_button2.default);

exports.default = ToolbarButton;

/***/ }),
/* 95 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _layerpopup = __webpack_require__(7);

var _layerpopup2 = _interopRequireDefault(_layerpopup);

var _toolbar = __webpack_require__(41);

var _toolbar2 = _interopRequireDefault(_toolbar);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview implements DefaultToolbar
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var PopupDropdownToolbar = function (_LayerPopup) {
  _inherits(PopupDropdownToolbar, _LayerPopup);

  /**
   * constructor
   * @param {object} options - popup options
   */
  function PopupDropdownToolbar(options) {
    _classCallCheck(this, PopupDropdownToolbar);

    options = _tuiCodeSnippet2.default.extend({
      header: false,
      className: 'te-dropdown-toolbar'
    }, options);
    return _possibleConstructorReturn(this, (PopupDropdownToolbar.__proto__ || Object.getPrototypeOf(PopupDropdownToolbar)).call(this, options));
  }

  /**
   * get toolbar instance it contains
   * @returns {Toolbar} - toolbar instance
   */

  /**
   * open event string
   * @memberof PopupDropdownToolbar
   * @static
   * @type {ToolbarButton}
   */


  _createClass(PopupDropdownToolbar, [{
    key: 'getToolbar',
    value: function getToolbar() {
      return this._toolbar;
    }

    /**
     * get toolbar items
     * @returns {ToolbarItem[]} - toolbar items
     * @memberof PopupDropdownToolbar
     */

  }, {
    key: 'getItems',
    value: function getItems() {
      return this.getToolbar().getItems();
    }

    /**
     * get toolbar item at given index
     * @param  {number} index - item index
     * @returns {ToolbarItem} - toolbar item at the index
     * @memberof PopupDropdownToolbar
     */

  }, {
    key: 'getItem',
    value: function getItem(index) {
      return this.getToolbar().getItem(index);
    }

    /**
     * set toolbar items
     * @param {ToolbarItem[]} items - toolbar items
     * @memberof PopupDropdownToolbar
     */

  }, {
    key: 'setItems',
    value: function setItems(items) {
      this.getToolbar().setItems(items);
    }

    /**
     * add toolbar item
     * @param {ToolbarItem|string|object} item - toolbar item
     * @memberof PopupDropdownToolbar
     */

  }, {
    key: 'addItem',
    value: function addItem(item) {
      this.getToolbar().addItem(item);
    }

    /**
     * insert toolbar item
     * @param  {number} index - index at given item inserted
     * @param  {ToolbarItem|string|object} item - toolbar item
     * @memberof PopupDropdownToolbar
     */

  }, {
    key: 'insertItem',
    value: function insertItem(index, item) {
      this.getToolbar().insertItem(index, item);
    }

    /**
     * get index of given item
     * @param  {ToolbarItem} item - toolbar item
     * @returns {number} - index of given toolbar item
     * @memberof PopupDropdownToolbar
     */

  }, {
    key: 'indexOfItem',
    value: function indexOfItem(item) {
      return this.getToolbar().indexOfItem(item);
    }

    /**
     * remove an item
     * @param  {number} index - item index to remove
     * @param  {boolean} destroy - destroy item or not
     * @returns {ToolbarItem} - removed item
     * @memberof PopupDropdownToolbar
     */

  }, {
    key: 'removeItem',
    value: function removeItem(index, destroy) {
      return this.getToolbar().removeItem(index, destroy);
    }

    /**
     * remove all toolbar items
     * @memberof PopupDropdownToolbar
     */

  }, {
    key: 'removeAllItems',
    value: function removeAllItems() {
      this.getToolbar().removeAllItems();
    }

    /**
     * init instance.
     * store properties & prepare before initialize DOM
     * @param {LayerPopupOption} options - layer popup options
     * @memberof PopupDropdownToolbar
     * @protected
     * @override
     */

  }, {
    key: '_initInstance',
    value: function _initInstance(options) {
      _get(PopupDropdownToolbar.prototype.__proto__ || Object.getPrototypeOf(PopupDropdownToolbar.prototype), '_initInstance', this).call(this, options);

      var $button = options.$button,
          eventManager = options.eventManager;


      this._$button = $button;
      this._eventManager = eventManager;
      this._toolbar = new _toolbar2.default(eventManager);
    }

    /**
     * initialize DOM, render popup
     * @memberof PopupDropdownToolbar
     * @protected
     */

  }, {
    key: '_initDOM',
    value: function _initDOM() {
      _get(PopupDropdownToolbar.prototype.__proto__ || Object.getPrototypeOf(PopupDropdownToolbar.prototype), '_initDOM', this).call(this);

      this.setContent(this._toolbar.$el);
    }

    /**
     * bind editor events
     * @memberof PopupDropdownToolbar
     * @protected
     */

  }, {
    key: '_initEditorEvent',
    value: function _initEditorEvent() {
      var _this2 = this;

      _get(PopupDropdownToolbar.prototype.__proto__ || Object.getPrototypeOf(PopupDropdownToolbar.prototype), '_initEditorEvent', this).call(this);

      this._eventManager.listen('focus', function () {
        return _this2.hide();
      });
      this._eventManager.listen('closeAllPopup', function () {
        return _this2.hide();
      });
      this._eventManager.listen(PopupDropdownToolbar.OPEN_EVENT, function () {
        var isShown = _this2.isShow();
        _this2._eventManager.emit('closeAllPopup');
        if (!isShown) {
          _this2.show();
        }

        // to give toolbar element enough width before the calculation
        _this2.$el.css({
          left: '-1000px'
        });
        var $button = _this2._$button;
        var position = $button.position();
        var buttonOuterHeightWithMargin = $button.outerHeight(true);
        var buttonMarginBottom = (buttonOuterHeightWithMargin - $button.outerHeight()) / 2;
        var top = position.top + buttonOuterHeightWithMargin - buttonMarginBottom;
        var left = position.left + $button.outerWidth(true) - _this2.$el.outerWidth(true);

        _this2.$el.css({
          top: top,
          left: left
        });
      });
    }
  }]);

  return PopupDropdownToolbar;
}(_layerpopup2.default);

Object.defineProperty(PopupDropdownToolbar, 'OPEN_EVENT', {
  enumerable: true,
  writable: true,
  value: 'openDropdownToolbar'
});
exports.default = PopupDropdownToolbar;

/***/ }),
/* 96 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _uicontroller = __webpack_require__(14);

var _uicontroller2 = _interopRequireDefault(_uicontroller);

var _i18n = __webpack_require__(3);

var _i18n2 = _interopRequireDefault(_i18n);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements ui mode switch
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var MARKDOWN = 'markdown';
var WYSIWYG = 'wysiwyg';

/**
 * Class ModeSwitch
 * UI Control for switch between Markdown and WYSIWYG
 * @extends {UIController}
 */

var ModeSwitch = function (_UIController) {
  _inherits(ModeSwitch, _UIController);

  /**
   * Creates an instance of ModeSwitch.
   * @param {jQuery} $rootElement - root jquery element
   * @param {string} initialType - initial type of editor
   * @memberof ModeSwitch
   */


  /**
   * current mode
   * @memberof ModeSwitch
   * @type {String}
   * @private
   */

  /**
   * mode switch type
   * @memberof ModeSwitch
   * @property {string} MARKDOWN - Markdown
   * @property {string} WYSIWYG - WYSIWYG
   * @static
   */
  function ModeSwitch($rootElement, initialType) {
    _classCallCheck(this, ModeSwitch);

    var _this = _possibleConstructorReturn(this, (ModeSwitch.__proto__ || Object.getPrototypeOf(ModeSwitch)).call(this, {
      tagName: 'div',
      className: 'te-mode-switch'
    }));

    Object.defineProperty(_this, '_buttons', {
      enumerable: true,
      writable: true,
      value: {}
    });


    _this._render($rootElement);
    _this._switchType(_tuiCodeSnippet2.default.isExisty(initialType) ? initialType : MARKDOWN);
    return _this;
  }

  /**
   * is the switch tab bar shown
   * @returns {Boolean} - showing status
   */


  /**
   * root element
   * @type {jQuery}
   */


  /**
   * mode switch buttons
   * @memberof ModeSwitch
   * @type {Object}
   * @private
   */


  _createClass(ModeSwitch, [{
    key: 'isShown',
    value: function isShown() {
      return this._$rootElement.css('display') === 'block';
    }

    /**
     * show switch tab bar
     * @memberof ModeSwitch
     */

  }, {
    key: 'show',
    value: function show() {
      this._$rootElement.css('display', 'block');
    }

    /**
     * hide switch tab bar
     * @memberof ModeSwitch
     */

  }, {
    key: 'hide',
    value: function hide() {
      this._$rootElement.css('display', 'none');
    }
  }, {
    key: '_render',
    value: function _render($rootElement) {
      this._buttons.$markdown = (0, _jquery2.default)('<button class="te-switch-button markdown" type="button">' + _i18n2.default.get('Markdown') + '</button>');
      this._buttons.$wysiwyg = (0, _jquery2.default)('<button class="te-switch-button wysiwyg" type="button">' + _i18n2.default.get('WYSIWYG') + '</button>');
      this.$el.append(this._buttons.$markdown);
      this.$el.append(this._buttons.$wysiwyg);

      if ($rootElement) {
        $rootElement.append(this.$el);
        this._$rootElement = $rootElement;
      }

      this.on('click .markdown', this._changeMarkdown.bind(this));
      this.on('click .wysiwyg', this._changeWysiwyg.bind(this));

      this.show();
    }
  }, {
    key: '_changeMarkdown',
    value: function _changeMarkdown() {
      this._switchType(MARKDOWN);
    }
  }, {
    key: '_changeWysiwyg',
    value: function _changeWysiwyg() {
      this._switchType(WYSIWYG);
    }
  }, {
    key: '_setActiveButton',
    value: function _setActiveButton(type) {
      this._buttons.$markdown.removeClass('active');
      this._buttons.$wysiwyg.removeClass('active');
      this._buttons['$' + type].addClass('active');
    }
  }, {
    key: '_switchType',
    value: function _switchType(type) {
      if (this._type === type) {
        return;
      }

      this._type = type;
      this._setActiveButton(type);
      this.trigger('modeSwitched', this._type);
    }
  }]);

  return ModeSwitch;
}(_uicontroller2.default);

Object.defineProperty(ModeSwitch, 'TYPE', {
  enumerable: true,
  writable: true,
  value: {
    MARKDOWN: MARKDOWN,
    WYSIWYG: WYSIWYG
  }
});
exports.default = ModeSwitch;

/***/ }),
/* 97 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _layerpopup = __webpack_require__(7);

var _layerpopup2 = _interopRequireDefault(_layerpopup);

var _i18n = __webpack_require__(3);

var _i18n2 = _interopRequireDefault(_i18n);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements PopupAddLink
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var URL_REGEX = /^(https?:\/\/)?([\da-z.-]+)\.([a-z.]{2,6})(\/([^\s]*))?$/;

/**
 * Class PopupAddLink
 * It implements a link Add Popup
 * @extends {LayerPopup}
 */

var PopupAddLink = function (_LayerPopup) {
  _inherits(PopupAddLink, _LayerPopup);

  /**
   * Creates an instance of PopupAddLink.
   * @param {LayerPopupOption} options - layer popup options
   * @memberof PopupAddLink
   */
  function PopupAddLink(options) {
    _classCallCheck(this, PopupAddLink);

    var POPUP_CONTENT = '\n            <label for="linkText">' + _i18n2.default.get('Link text') + '</label>\n            <input type="text" class="te-link-text-input" />\n            <label for="url">' + _i18n2.default.get('URL') + '</label>\n            <input type="text" class="te-url-input" />\n            <div class="te-button-section">\n                <button type="button" class="te-ok-button">' + _i18n2.default.get('OK') + '</button>\n                <button type="button" class="te-close-button">' + _i18n2.default.get('Cancel') + '</button>\n            </div>\n        ';
    options = _tuiCodeSnippet2.default.extend({
      header: true,
      title: _i18n2.default.get('Insert link'),
      className: 'te-popup-add-link tui-editor-popup',
      content: POPUP_CONTENT
    }, options);
    return _possibleConstructorReturn(this, (PopupAddLink.__proto__ || Object.getPrototypeOf(PopupAddLink)).call(this, options));
  }

  /**
   * init instance.
   * store properties & prepare before initialize DOM
   * @param {LayerPopupOption} options - layer popup options
   * @memberof PopupAddLink
   * @protected
   * @override
   */


  _createClass(PopupAddLink, [{
    key: '_initInstance',
    value: function _initInstance(options) {
      _get(PopupAddLink.prototype.__proto__ || Object.getPrototypeOf(PopupAddLink.prototype), '_initInstance', this).call(this, options);

      this._editor = options.editor;
      this._eventManager = options.editor.eventManager;
    }

    /**
     * initialize DOM, render popup
     * @memberof PopupAddLink
     * @protected
     * @override
     */

  }, {
    key: '_initDOM',
    value: function _initDOM() {
      _get(PopupAddLink.prototype.__proto__ || Object.getPrototypeOf(PopupAddLink.prototype), '_initDOM', this).call(this);

      var el = this.$el.get(0);
      this._inputText = el.querySelector('.te-link-text-input');
      this._inputURL = el.querySelector('.te-url-input');
    }

    /**
     * bind DOM events
     * @memberof PopupAddLink
     * @protected
     * @override
     */

  }, {
    key: '_initDOMEvent',
    value: function _initDOMEvent() {
      var _this2 = this;

      _get(PopupAddLink.prototype.__proto__ || Object.getPrototypeOf(PopupAddLink.prototype), '_initDOMEvent', this).call(this);

      this.on('click .te-close-button', function () {
        return _this2.hide();
      });
      this.on('click .te-ok-button', function () {
        return _this2._addLink();
      });

      this.on('shown', function () {
        var inputText = _this2._inputText;
        var inputURL = _this2._inputURL;

        var selectedText = _this2._editor.getSelectedText().trim();

        inputText.value = selectedText;
        if (URL_REGEX.exec(selectedText)) {
          inputURL.value = selectedText;
        }

        if (selectedText.length > 0 && inputURL.value.length < 1) {
          inputURL.focus();
        } else {
          inputText.focus();
          inputText.setSelectionRange(0, selectedText.length);
        }
      });

      this.on('hidden', function () {
        _this2._resetInputs();
      });
    }

    /**
     * bind editor events
     * @memberof PopupAddLink
     * @protected
     * @abstract
     */

  }, {
    key: '_initEditorEvent',
    value: function _initEditorEvent() {
      var _this3 = this;

      _get(PopupAddLink.prototype.__proto__ || Object.getPrototypeOf(PopupAddLink.prototype), '_initEditorEvent', this).call(this);

      var eventManager = this._eventManager;
      eventManager.listen('focus', function () {
        return _this3.hide();
      });
      eventManager.listen('closeAllPopup', function () {
        return _this3.hide();
      });
      eventManager.listen('openPopupAddLink', function () {
        eventManager.emit('closeAllPopup');
        _this3.show();
      });
    }
  }, {
    key: '_addLink',
    value: function _addLink() {
      var _getValue2 = this._getValue(),
          url = _getValue2.url,
          linkText = _getValue2.linkText;

      this._clearValidationStyle();

      if (linkText.length < 1) {
        this._inputText.classList.add('wrong');

        return;
      }
      if (url.length < 1) {
        this._inputURL.classList.add('wrong');

        return;
      }

      this._eventManager.emit('command', 'AddLink', {
        linkText: linkText,
        url: url
      });
      this.hide();
    }
  }, {
    key: '_getValue',
    value: function _getValue() {
      var url = this._inputURL.value;
      var linkText = this._inputText.value;

      return {
        url: url,
        linkText: linkText
      };
    }
  }, {
    key: '_clearValidationStyle',
    value: function _clearValidationStyle() {
      this._inputURL.classList.remove('wrong');
      this._inputText.classList.remove('wrong');
    }
  }, {
    key: '_resetInputs',
    value: function _resetInputs() {
      this._inputText.value = '';
      this._inputURL.value = '';
      this._clearValidationStyle();
    }
  }]);

  return PopupAddLink;
}(_layerpopup2.default);

exports.default = PopupAddLink;

/***/ }),
/* 98 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _layerpopup = __webpack_require__(7);

var _layerpopup2 = _interopRequireDefault(_layerpopup);

var _tab = __webpack_require__(44);

var _tab2 = _interopRequireDefault(_tab);

var _i18n = __webpack_require__(3);

var _i18n2 = _interopRequireDefault(_i18n);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements PopupAddImage
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var CLASS_IMAGE_URL_INPUT = 'te-image-url-input';
var CLASS_IMAGE_FILE_INPUT = 'te-image-file-input';
var CLASS_ALT_TEXT_INPUT = 'te-alt-text-input';
var CLASS_OK_BUTTON = 'te-ok-button';
var CLASS_CLOSE_BUTTON = 'te-close-button';
var CLASS_FILE_TYPE = 'te-file-type';
var CLASS_URL_TYPE = 'te-url-type';
var CLASS_TAB_SECTION = 'te-tab-section';
var TYPE_UI = 'ui';

/**
 * Class PopupAddImage
 * It implements a Image Add Popup
 * @extends {LayerPopup}
 */

var PopupAddImage = function (_LayerPopup) {
  _inherits(PopupAddImage, _LayerPopup);

  /**
   * Creates an instance of PopupAddImage.
   * @param {LayerPopupOption} options - layer popup option
   * @memberof PopupAddImage
   */
  function PopupAddImage(options) {
    _classCallCheck(this, PopupAddImage);

    var POPUP_CONTENT = '\n            <div class="' + CLASS_TAB_SECTION + '"></div>\n            <div class="' + CLASS_URL_TYPE + '">\n                <label for="">' + _i18n2.default.get('Image URL') + '</label>\n                <input type="text" class="' + CLASS_IMAGE_URL_INPUT + '" />\n            </div>\n            <form enctype="multipart/form-data" class="' + CLASS_FILE_TYPE + '">\n                <label for="">' + _i18n2.default.get('Select image file') + '</label>\n                <input type="file" class="' + CLASS_IMAGE_FILE_INPUT + '" accept="image/*" />\n            </form>\n            <label for="url">' + _i18n2.default.get('Description') + '</label>\n            <input type="text" class="' + CLASS_ALT_TEXT_INPUT + '" />\n            <div class="te-button-section">\n                <button type="button" class="' + CLASS_OK_BUTTON + '">' + _i18n2.default.get('OK') + '</button>\n                <button type="button" class="' + CLASS_CLOSE_BUTTON + '">' + _i18n2.default.get('Cancel') + '</button>\n            </div>\n        ';
    options = _tuiCodeSnippet2.default.extend({
      header: true,
      title: _i18n2.default.get('Insert image'),
      className: 'te-popup-add-image tui-editor-popup',
      content: POPUP_CONTENT
    }, options);
    return _possibleConstructorReturn(this, (PopupAddImage.__proto__ || Object.getPrototypeOf(PopupAddImage)).call(this, options));
  }

  /**
   * init instance.
   * store properties & prepare before initialize DOM
   * @param {LayerPopupOption} options - layer popup options
   * @memberof PopupAddImage
   * @protected
   * @override
   */


  _createClass(PopupAddImage, [{
    key: '_initInstance',
    value: function _initInstance(options) {
      _get(PopupAddImage.prototype.__proto__ || Object.getPrototypeOf(PopupAddImage.prototype), '_initInstance', this).call(this, options);

      this.eventManager = options.eventManager;
    }

    /**
     * initialize DOM, render popup
     * @memberof PopupAddImage
     * @protected
     * @override
     */

  }, {
    key: '_initDOM',
    value: function _initDOM() {
      _get(PopupAddImage.prototype.__proto__ || Object.getPrototypeOf(PopupAddImage.prototype), '_initDOM', this).call(this);

      var $popup = this.$el;

      this._$imageUrlInput = $popup.find('.' + CLASS_IMAGE_URL_INPUT);
      this._$imageFileInput = $popup.find('.' + CLASS_IMAGE_FILE_INPUT);
      this._$altTextInput = $popup.find('.' + CLASS_ALT_TEXT_INPUT);

      var $fileTypeSection = $popup.find('.' + CLASS_FILE_TYPE);
      var $urlTypeSection = $popup.find('.' + CLASS_URL_TYPE);
      var $tabSection = this.$body.find('.' + CLASS_TAB_SECTION);
      this.tab = new _tab2.default({
        initName: _i18n2.default.get('File'),
        items: [_i18n2.default.get('File'), _i18n2.default.get('URL')],
        sections: [$fileTypeSection, $urlTypeSection]
      });
      $tabSection.append(this.tab.$el);
    }

    /**
     * bind DOM events
     * @memberof PopupAddImage
     * @protected
     * @override
     */

  }, {
    key: '_initDOMEvent',
    value: function _initDOMEvent() {
      var _this2 = this;

      _get(PopupAddImage.prototype.__proto__ || Object.getPrototypeOf(PopupAddImage.prototype), '_initDOMEvent', this).call(this);

      this.on('shown', function () {
        return _this2._$imageUrlInput.focus();
      });
      this.on('hidden', function () {
        return _this2._resetInputs();
      });

      this.on('change .' + CLASS_IMAGE_FILE_INPUT, function () {
        var filename = _this2._$imageFileInput.val().split('\\').pop();
        _this2._$altTextInput.val(filename);
      });

      this.on('click .' + CLASS_CLOSE_BUTTON, function () {
        return _this2.hide();
      });
      this.on('click .' + CLASS_OK_BUTTON, function () {
        var imageUrl = _this2._$imageUrlInput.val();
        var altText = _this2._$altTextInput.val();

        if (imageUrl) {
          _this2._applyImage(imageUrl, altText);
        } else {
          var imageFile = _this2._$imageFileInput.get(0).files.item(0);
          var hookCallback = function hookCallback(url, text) {
            return _this2._applyImage(url, altText || text);
          };

          _this2.eventManager.emit('addImageBlobHook', imageFile, hookCallback, TYPE_UI);
        }

        _this2.hide();
      });

      this.tab.on('itemClick', function () {
        return _this2._resetInputs();
      });
    }

    /**
     * bind editor events
     * @memberof PopupAddImage
     * @protected
     * @abstract
     */

  }, {
    key: '_initEditorEvent',
    value: function _initEditorEvent() {
      var _this3 = this;

      _get(PopupAddImage.prototype.__proto__ || Object.getPrototypeOf(PopupAddImage.prototype), '_initEditorEvent', this).call(this);

      this.eventManager.listen('focus', function () {
        return _this3.hide();
      });
      this.eventManager.listen('closeAllPopup', function () {
        return _this3.hide();
      });

      this.eventManager.listen('openPopupAddImage', function () {
        _this3.eventManager.emit('closeAllPopup');
        _this3.show();
      });
    }
  }, {
    key: '_applyImage',
    value: function _applyImage(imageUrl, altText) {
      this.eventManager.emit('command', 'AddImage', {
        imageUrl: imageUrl,
        altText: altText || 'image'
      });
      this.hide();
    }
  }, {
    key: '_resetInputs',
    value: function _resetInputs() {
      this.$el.find('input').val('');
    }
  }]);

  return PopupAddImage;
}(_layerpopup2.default);

exports.default = PopupAddImage;

/***/ }),
/* 99 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _layerpopup = __webpack_require__(7);

var _layerpopup2 = _interopRequireDefault(_layerpopup);

var _i18n = __webpack_require__(3);

var _i18n2 = _interopRequireDefault(_i18n);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements PopupTableUtils
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


/**
 * PopupTableUtils
 * It implements table utils popup
 * @extends {LayerPopup}
 */
var PopupTableUtils = function (_LayerPopup) {
  _inherits(PopupTableUtils, _LayerPopup);

  /**
   * Creates an instance of PopupTableUtils.
   * @param {LayerPopupOption} options - layer popup options
   * @memberof PopupTableUtils
   */
  function PopupTableUtils(options) {
    _classCallCheck(this, PopupTableUtils);

    var POPUP_CONTENT = '\n            <button type="button" class="te-table-add-row">' + _i18n2.default.get('Add row') + '</button>\n            <button type="button" class="te-table-add-col">' + _i18n2.default.get('Add col') + '</button>\n            <button type="button" class="te-table-remove-row">' + _i18n2.default.get('Remove row') + '</button>\n            <button type="button" class="te-table-remove-col">' + _i18n2.default.get('Remove col') + '</button>\n            <hr/>\n            <button type="button" class="te-table-col-align-left">' + _i18n2.default.get('Align left') + '</button>\n            <button type="button" class="te-table-col-align-center">' + _i18n2.default.get('Align center') + '</button>\n            <button type="button" class="te-table-col-align-right">' + _i18n2.default.get('Align right') + '</button>\n            <hr/>\n            <button type="button" class="te-table-remove">' + _i18n2.default.get('Remove table') + '</button>\n        ';
    options = _tuiCodeSnippet2.default.extend({
      header: false,
      className: 'te-popup-table-utils',
      content: POPUP_CONTENT
    }, options);
    return _possibleConstructorReturn(this, (PopupTableUtils.__proto__ || Object.getPrototypeOf(PopupTableUtils)).call(this, options));
  }

  /**
   * init instance.
   * store properties & prepare before initialize DOM
   * @param {LayerPopupOption} options - layer popup options
   * @memberof PopupTableUtils
   * @protected
   * @override
   */


  _createClass(PopupTableUtils, [{
    key: '_initInstance',
    value: function _initInstance(options) {
      _get(PopupTableUtils.prototype.__proto__ || Object.getPrototypeOf(PopupTableUtils.prototype), '_initInstance', this).call(this, options);
      this.eventManager = options.eventManager;
    }

    /**
     * bind DOM events
     * @memberof PopupTableUtils
     * @protected
     * @override
     */

  }, {
    key: '_initDOMEvent',
    value: function _initDOMEvent() {
      var _this2 = this;

      _get(PopupTableUtils.prototype.__proto__ || Object.getPrototypeOf(PopupTableUtils.prototype), '_initDOMEvent', this).call(this);

      this.on('click .te-table-add-row', function () {
        return _this2.eventManager.emit('command', 'AddRow');
      });
      this.on('click .te-table-add-col', function () {
        return _this2.eventManager.emit('command', 'AddCol');
      });
      this.on('click .te-table-remove-row', function () {
        return _this2.eventManager.emit('command', 'RemoveRow');
      });
      this.on('click .te-table-col-align-left', function () {
        return _this2.eventManager.emit('command', 'AlignCol', 'left');
      });
      this.on('click .te-table-col-align-center', function () {
        return _this2.eventManager.emit('command', 'AlignCol', 'center');
      });
      this.on('click .te-table-col-align-right', function () {
        return _this2.eventManager.emit('command', 'AlignCol', 'right');
      });
      this.on('click .te-table-remove-col', function () {
        return _this2.eventManager.emit('command', 'RemoveCol');
      });
      this.on('click .te-table-remove', function () {
        return _this2.eventManager.emit('command', 'RemoveTable');
      });
    }

    /**
     * bind editor events
     * @memberof PopupTableUtils
     * @protected
     * @abstract
     */

  }, {
    key: '_initEditorEvent',
    value: function _initEditorEvent() {
      var _this3 = this;

      _get(PopupTableUtils.prototype.__proto__ || Object.getPrototypeOf(PopupTableUtils.prototype), '_initEditorEvent', this).call(this);

      this.eventManager.listen('focus', function () {
        return _this3.hide();
      });
      this.eventManager.listen('mousedown', function () {
        return _this3.hide();
      });
      this.eventManager.listen('closeAllPopup', function () {
        return _this3.hide();
      });

      this.eventManager.listen('openPopupTableUtils', function (event) {
        var offset = _this3.$el.parent().offset();
        var x = event.clientX - offset.left;
        var y = event.clientY - offset.top + (0, _jquery2.default)(window).scrollTop();

        _this3.eventManager.emit('closeAllPopup');

        _this3.$el.css({
          position: 'absolute',
          top: y + 5, // beside mouse pointer
          left: x + 10
        });

        _this3.show();
      });
    }
  }]);

  return PopupTableUtils;
}(_layerpopup2.default);

exports.default = PopupTableUtils;

/***/ }),
/* 100 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _layerpopup = __webpack_require__(7);

var _layerpopup2 = _interopRequireDefault(_layerpopup);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements PopupAddTable
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var CLASS_TABLE_SELECTION = 'te-table-selection';
var CLASS_TABLE_HEADER = 'te-table-header';
var CLASS_TABLE_BODY = 'te-table-body';
var CLASS_SELECTION_AREA = 'te-selection-area';
var CLASS_DESCRIPTION = 'te-description';

var POPUP_CONTENT = '\n    <div class="' + CLASS_TABLE_SELECTION + '">\n        <div class="' + CLASS_TABLE_HEADER + '"></div>\n        <div class="' + CLASS_TABLE_BODY + '"></div>\n        <div class="' + CLASS_SELECTION_AREA + '"></div>\n    </div>\n    <p class="' + CLASS_DESCRIPTION + '"></p>\n';

var CELL_WIDTH = 25;
var CELL_HEIGHT = 17;
var MIN_ROW_INDEX = 7;
var MAX_ROW_INDEX = 14;
var MIN_COL_INDEX = 5;
var MAX_COL_INDEX = 9;
var MIN_ROW_SELECTION_INDEX = 1;
var MIN_COL_SELECTION_INDEX = 1;
var HEADER_ROW_COUNT = 1;
var LAST_BORDER = 1;

/**
 * Class PopupAddTable
 * It implements Popup to add a table
 * @extends {LayerPopup}
 */

var PopupAddTable = function (_LayerPopup) {
  _inherits(PopupAddTable, _LayerPopup);

  /**
   * Creates an instance of PopupAddTable.
   * @param {LayerPopupOption} options - layer popup option
   * @memberof PopupAddTable
   */
  function PopupAddTable(options) {
    _classCallCheck(this, PopupAddTable);

    options = _tuiCodeSnippet2.default.extend({
      header: false,
      className: 'te-popup-add-table',
      content: POPUP_CONTENT
    }, options);
    return _possibleConstructorReturn(this, (PopupAddTable.__proto__ || Object.getPrototypeOf(PopupAddTable)).call(this, options));
  }

  /**
   * init instance.
   * store properties & prepare before initialize DOM
   * @param {LayerPopupOption} options - layer popup options
   * @memberof PopupAddTable
   * @protected
   * @override
   */


  _createClass(PopupAddTable, [{
    key: '_initInstance',
    value: function _initInstance(options) {
      _get(PopupAddTable.prototype.__proto__ || Object.getPrototypeOf(PopupAddTable.prototype), '_initInstance', this).call(this, options);

      this._selectedBound = {};
      this._tableBound = {};
      this._eventManager = options.eventManager;
      this.$button = options.$button;
    }

    /**
     * initialize DOM, render popup
     * @memberof PopupAddTable
     * @protected
     * @override
     */

  }, {
    key: '_initDOM',
    value: function _initDOM() {
      _get(PopupAddTable.prototype.__proto__ || Object.getPrototypeOf(PopupAddTable.prototype), '_initDOM', this).call(this);

      this._cacheElements();
      this._setTableSizeByBound(MIN_COL_INDEX, MIN_ROW_INDEX);
    }

    /**
     * bind DOM events
     * @memberof PopupAddTable
     * @protected
     * @override
     */

  }, {
    key: '_initDOMEvent',
    value: function _initDOMEvent(options) {
      var _this2 = this;

      _get(PopupAddTable.prototype.__proto__ || Object.getPrototypeOf(PopupAddTable.prototype), '_initDOMEvent', this).call(this, options);

      this.on('mousemove .' + CLASS_TABLE_SELECTION, function (ev) {
        var x = ev.pageX - _this2._selectionOffset.left;
        var y = ev.pageY - _this2._selectionOffset.top;
        var bound = _this2._getSelectionBoundByOffset(x, y);

        _this2._resizeTableBySelectionIfNeed(bound.col, bound.row);

        _this2._setSelectionAreaByBound(bound.col, bound.row);
        _this2._setDisplayText(bound.col, bound.row);
        _this2._setSelectedBound(bound.col, bound.row);
      });

      this.on('click .' + CLASS_TABLE_SELECTION, function () {
        var tableSize = _this2._getSelectedTableSize();
        _this2._eventManager.emit('command', 'Table', tableSize.col, tableSize.row);
      });
    }

    /**
     * bind editor events
     * @memberof PopupAddTable
     * @protected
     * @abstract
     */

  }, {
    key: '_initEditorEvent',
    value: function _initEditorEvent() {
      var _this3 = this;

      _get(PopupAddTable.prototype.__proto__ || Object.getPrototypeOf(PopupAddTable.prototype), '_initEditorEvent', this).call(this);

      this._eventManager.listen('focus', function () {
        return _this3.hide();
      });
      this._eventManager.listen('closeAllPopup', function () {
        return _this3.hide();
      });

      this._eventManager.listen('openPopupAddTable', function () {
        _this3._eventManager.emit('closeAllPopup');
        var $button = _this3.$button;
        var offset = $button.offset();
        _this3.$el.css({
          top: offset.top + $button.outerHeight(),
          left: offset.left
        });
        _this3.show();
        _this3._selectionOffset = _this3.$el.find('.' + CLASS_TABLE_SELECTION).offset();
      });
    }

    /**
     * _cacheElements
     * Cache elements for use
     * @private
     */

  }, {
    key: '_cacheElements',
    value: function _cacheElements() {
      this.$header = this.$el.find('.' + CLASS_TABLE_HEADER);
      this.$body = this.$el.find('.' + CLASS_TABLE_BODY);
      this.$selection = this.$el.find('.' + CLASS_SELECTION_AREA);
      this.$desc = this.$el.find('.' + CLASS_DESCRIPTION);
    }

    /**
     * _resizeTableBySelectionIfNeed
     * Resize table if need
     * @param {number} col column index
     * @param {number} row row index
     * @private
     */

  }, {
    key: '_resizeTableBySelectionIfNeed',
    value: function _resizeTableBySelectionIfNeed(col, row) {
      var resizedBound = this._getResizedTableBound(col, row);

      if (resizedBound) {
        this._setTableSizeByBound(resizedBound.col, resizedBound.row);
      }
    }

    /**
     * _getResizedTableBound
     * Get resized table bound if Need
     * @param {number} col column index
     * @param {number} row row index
     * @returns {object} bound
     * @private
     */

  }, {
    key: '_getResizedTableBound',
    value: function _getResizedTableBound(col, row) {
      var resizedCol = void 0,
          resizedRow = void 0,
          resizedBound = void 0;

      if (col >= MIN_COL_INDEX && col < MAX_COL_INDEX) {
        resizedCol = col + 1;
      } else if (col < MIN_COL_INDEX) {
        resizedCol = MIN_COL_INDEX;
      }

      if (row >= MIN_ROW_INDEX && row < MAX_ROW_INDEX) {
        resizedRow = row + 1;
      } else if (row < MIN_ROW_INDEX) {
        resizedRow = MIN_ROW_INDEX;
      }

      if (this._isNeedResizeTable(resizedCol, resizedRow)) {
        resizedBound = {
          row: resizedRow || this._tableBound.row,
          col: resizedCol || this._tableBound.col
        };
      }

      return resizedBound;
    }

    /**
     * _isNeedResizeTable
     * check if need resize table
     * @param {number} col column index
     * @param {number} row row index
     * @returns {boolean} result
     * @private
     */

  }, {
    key: '_isNeedResizeTable',
    value: function _isNeedResizeTable(col, row) {
      return col && col !== this._tableBound.col || row && row !== this._tableBound.row;
    }

    /**
     * _getBoundByOffset
     * Get bound by offset
     * @param {number} x offset
     * @param {number} y offset
     * @returns {object} bound
     * @private
     */

  }, {
    key: '_getBoundByOffset',
    value: function _getBoundByOffset(x, y) {
      var row = parseInt(y / CELL_HEIGHT, 10);
      var col = parseInt(x / CELL_WIDTH, 10);

      return {
        row: row,
        col: col
      };
    }

    /**
     * _getOffsetByBound
     * Get offset by bound
     * @param {number} col column index
     * @param {number} row row index
     * @returns {object} offset
     * @private
     */

  }, {
    key: '_getOffsetByBound',
    value: function _getOffsetByBound(col, row) {
      var x = col * CELL_WIDTH + CELL_WIDTH,
          y = row * CELL_HEIGHT + CELL_HEIGHT;

      return {
        x: x,
        y: y
      };
    }

    /**
     * _setTableSizeByBound
     * Set table size with bound
     * @param {number} col column index
     * @param {number} row row index
     * @private
     */

  }, {
    key: '_setTableSizeByBound',
    value: function _setTableSizeByBound(col, row) {
      var boundOffset = this._getOffsetByBound(col, row - HEADER_ROW_COUNT);
      this._setTableSize(boundOffset.x, boundOffset.y);
      this._tableBound.row = row;
      this._tableBound.col = col;
    }

    /**
     * _getSelectionBoundByOffset
     * Get selection bound that process with range by offset
     * @param {number} x offset
     * @param {number} y offset
     * @returns {object} bound
     * @private
     */

  }, {
    key: '_getSelectionBoundByOffset',
    value: function _getSelectionBoundByOffset(x, y) {
      var bound = this._getBoundByOffset(x, y);

      if (bound.row < MIN_ROW_SELECTION_INDEX) {
        bound.row = MIN_ROW_SELECTION_INDEX;
      } else if (bound.row > this._tableBound.row) {
        bound.row = this._tableBound.row;
      }

      if (bound.col < MIN_COL_SELECTION_INDEX) {
        bound.col = MIN_COL_SELECTION_INDEX;
      } else if (bound.col > this._tableBound.col) {
        bound.col = this._tableBound.col;
      }

      return bound;
    }

    /**
     * _setSelectionAreaByBound
     * Set selection area with bound
     * @param {number} col column index
     * @param {number} row row index
     * @private
     */

  }, {
    key: '_setSelectionAreaByBound',
    value: function _setSelectionAreaByBound(col, row) {
      var boundOffset = this._getOffsetByBound(col, row);
      this._setSelectionArea(boundOffset.x, boundOffset.y);
    }

    /**
     * _setSelectedBound
     * Set selected bound
     * @param {number} col column index
     * @param {number} row row index
     * @private
     */

  }, {
    key: '_setSelectedBound',
    value: function _setSelectedBound(col, row) {
      this._selectedBound.col = col;
      this._selectedBound.row = row;
    }

    /**
     * _getSelectedTableSize
     * Get selected table size
     * @returns {object} bound
     * @private
     */

  }, {
    key: '_getSelectedTableSize',
    value: function _getSelectedTableSize() {
      return {
        row: this._selectedBound.row + 1,
        col: this._selectedBound.col + 1
      };
    }

    /**
     * _setDisplayText
     * Set selected table size text for display
     * @param {number} col column index
     * @param {number} row row index
     * @private
     */

  }, {
    key: '_setDisplayText',
    value: function _setDisplayText(col, row) {
      this.$desc.html(col + 1 + ' x ' + (row + 1));
    }

    /**
     * _setTableSize
     * Set table element size
     * @param {number} x offset
     * @param {number} y offset
     * @private
     */

  }, {
    key: '_setTableSize',
    value: function _setTableSize(x, y) {
      x += LAST_BORDER;
      y += LAST_BORDER;

      this.$header.css({
        height: CELL_HEIGHT,
        width: x
      });

      this.$body.css({
        height: y,
        width: x
      });

      this.$el.css({
        width: x + 30
      });
    }

    /**
     * _setSelectionArea
     * Set selection element size
     * @param {number} x offset
     * @param {number} y offset
     * @private
     */

  }, {
    key: '_setSelectionArea',
    value: function _setSelectionArea(x, y) {
      x += LAST_BORDER;
      y += LAST_BORDER;

      this.$selection.css({
        height: y,
        width: x
      });
    }
  }]);

  return PopupAddTable;
}(_layerpopup2.default);

PopupAddTable.CELL_WIDTH = CELL_WIDTH;
PopupAddTable.CELL_HEIGHT = CELL_HEIGHT;
PopupAddTable.MIN_ROW_SELECTION_INDEX = MIN_ROW_SELECTION_INDEX;
PopupAddTable.MIN_COL_SELECTION_INDEX = MIN_COL_SELECTION_INDEX;

exports.default = PopupAddTable;

/***/ }),
/* 101 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _layerpopup = __webpack_require__(7);

var _layerpopup2 = _interopRequireDefault(_layerpopup);

var _i18n = __webpack_require__(3);

var _i18n2 = _interopRequireDefault(_i18n);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements PopupAddTable
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


/**
 * Class PopupHeading
 * It implements Popup to add headings
 * @extends {LayerPopup}
 */
var PopupAddHeading = function (_LayerPopup) {
  _inherits(PopupAddHeading, _LayerPopup);

  /**
   * Creates an instance of PopupAddHeading.
   * @param {LayerPopupOption} options - layer popup option
   * @memberof PopupAddHeading
   */
  function PopupAddHeading(options) {
    _classCallCheck(this, PopupAddHeading);

    var POPUP_CONTENT = '\n            <ul>\n                <li data-value="1" data-type="Heading"><h1>' + _i18n2.default.get('Heading') + ' 1</h1></li>\n                <li data-value="2" data-type="Heading"><h2>' + _i18n2.default.get('Heading') + ' 2</h2></li>\n                <li data-value="3" data-type="Heading"><h3>' + _i18n2.default.get('Heading') + ' 3</h3></li>\n                <li data-value="4" data-type="Heading"><h4>' + _i18n2.default.get('Heading') + ' 4</h4></li>\n                <li data-value="5" data-type="Heading"><h5>' + _i18n2.default.get('Heading') + ' 5</h5></li>\n                <li data-value="6" data-type="Heading"><h6>' + _i18n2.default.get('Heading') + ' 6</h6></li>\n                <li data-type="Paragraph"><div>' + _i18n2.default.get('Paragraph') + '</div></li>\n            </ul>\n        ';
    options = _tuiCodeSnippet2.default.extend({
      header: false,
      className: 'te-heading-add',
      content: POPUP_CONTENT
    }, options);
    return _possibleConstructorReturn(this, (PopupAddHeading.__proto__ || Object.getPrototypeOf(PopupAddHeading)).call(this, options));
  }

  /**
   * init instance.
   * store properties & prepare before initialize DOM
   * @param {LayerPopupOption} options - layer popup options
   * @memberof PopupAddHeading
   * @protected
   * @override
   */


  _createClass(PopupAddHeading, [{
    key: '_initInstance',
    value: function _initInstance(options) {
      _get(PopupAddHeading.prototype.__proto__ || Object.getPrototypeOf(PopupAddHeading.prototype), '_initInstance', this).call(this, options);

      this._eventManager = options.eventManager;
      this._$button = options.$button;
    }

    /**
     * bind DOM events
     * @memberof PopupAddHeading
     * @protected
     * @override
     */

  }, {
    key: '_initDOMEvent',
    value: function _initDOMEvent() {
      var _this2 = this;

      _get(PopupAddHeading.prototype.__proto__ || Object.getPrototypeOf(PopupAddHeading.prototype), '_initDOMEvent', this).call(this);

      this.on('click li', function (ev) {
        var $li = (0, _jquery2.default)(ev.target).closest('li');
        _this2._eventManager.emit('command', $li.data('type'), $li.data('value'));
      });
    }

    /**
     * bind editor events
     * @memberof PopupAddHeading
     * @protected
     * @abstract
     */

  }, {
    key: '_initEditorEvent',
    value: function _initEditorEvent() {
      var _this3 = this;

      _get(PopupAddHeading.prototype.__proto__ || Object.getPrototypeOf(PopupAddHeading.prototype), '_initEditorEvent', this).call(this);

      this._eventManager.listen('focus', this.hide.bind(this));
      this._eventManager.listen('closeAllPopup', this.hide.bind(this));
      this._eventManager.listen('openHeadingSelect', function () {
        _this3._eventManager.emit('closeAllPopup');

        var $button = _this3._$button;
        var offset = $button.offset();
        _this3.$el.css({
          top: offset.top + $button.outerHeight(),
          left: offset.left
        });

        _this3.show();
      });
    }
  }]);

  return PopupAddHeading;
}(_layerpopup2.default);

exports.default = PopupAddHeading;

/***/ }),
/* 102 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _layerpopup = __webpack_require__(7);

var _layerpopup2 = _interopRequireDefault(_layerpopup);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements popup code block languages
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var BUTTON_CLASS_PREFIX = 'te-popup-code-block-lang-';

/**
 * Class Popup code block languages select list
 * @extends {LayerPopup}
 */

var PopupCodeBlockLanguages = function (_LayerPopup) {
  _inherits(PopupCodeBlockLanguages, _LayerPopup);

  /**
   * Creates an instance of PopupCodeBlockLanguages.
   * @param {LayerPopupOption} options - layer popup option
   * @memberof PopupCodeBlockLanguages
   */
  function PopupCodeBlockLanguages(options) {
    _classCallCheck(this, PopupCodeBlockLanguages);

    var popupButtonsHTML = [];
    var _options = options,
        languages = _options.languages;

    languages.forEach(function (lang) {
      return popupButtonsHTML.push('<button type="button" class="' + BUTTON_CLASS_PREFIX + lang + '" data-lang="' + lang + '">' + lang + '</button>');
    });

    options = _tuiCodeSnippet2.default.extend({
      header: false,
      className: 'te-popup-code-block-languages',
      content: popupButtonsHTML.join('')
    }, options);
    return _possibleConstructorReturn(this, (PopupCodeBlockLanguages.__proto__ || Object.getPrototypeOf(PopupCodeBlockLanguages)).call(this, options));
  }

  /**
   * init instance.
   * store properties & prepare before initialize DOM
   * @param {LayerPopupOption} options - layer popup options
   * @memberof PopupCodeBlockLanguages
   * @protected
   * @override
   */


  _createClass(PopupCodeBlockLanguages, [{
    key: '_initInstance',
    value: function _initInstance(options) {
      _get(PopupCodeBlockLanguages.prototype.__proto__ || Object.getPrototypeOf(PopupCodeBlockLanguages.prototype), '_initInstance', this).call(this, options);

      this._onSelectedLanguage = null;
      this._onDismissed = null;
      this._currentButton = null;
      this._$buttons = null;
      this._languages = options.languages;

      this.eventManager = options.eventManager;
    }

    /**
     * initialize DOM, render popup
     * @memberof PopupCodeBlockLanguages
     * @protected
     * @override
     */

  }, {
    key: '_initDOM',
    value: function _initDOM(options) {
      _get(PopupCodeBlockLanguages.prototype.__proto__ || Object.getPrototypeOf(PopupCodeBlockLanguages.prototype), '_initDOM', this).call(this, options);

      this.$el.css('z-index', 10000);

      this._$buttons = this.$el.find('button');
      this._activateButtonByIndex(0);
    }

    /**
     * bind DOM events
     * @memberof PopupCodeBlockLanguages
     * @protected
     * @override
     */

  }, {
    key: '_initDOMEvent',
    value: function _initDOMEvent() {
      var _this2 = this;

      _get(PopupCodeBlockLanguages.prototype.__proto__ || Object.getPrototypeOf(PopupCodeBlockLanguages.prototype), '_initDOMEvent', this).call(this);

      var handler = function handler(event) {
        var language = (0, _jquery2.default)(event.target).data('lang');
        if (_this2._onSelectedLanguage) {
          _this2._onSelectedLanguage(language);
        }
        _this2.hide();
      };
      this._languages.forEach(function (lang) {
        return _this2.on('mousedown .' + BUTTON_CLASS_PREFIX + lang, handler);
      });
    }

    /**
     * bind editor events
     * @memberof PopupCodeBlockLanguages
     * @protected
     * @abstract
     */

  }, {
    key: '_initEditorEvent',
    value: function _initEditorEvent() {
      var _this3 = this;

      _get(PopupCodeBlockLanguages.prototype.__proto__ || Object.getPrototypeOf(PopupCodeBlockLanguages.prototype), '_initEditorEvent', this).call(this);

      this.eventManager.listen('openPopupCodeBlockLanguages', function (data) {
        _this3.show(data.callback);
        var elementStyle = _this3.$el.get(0).style;
        elementStyle.top = data.offset.top + 'px';
        elementStyle.left = data.offset.left + 'px';
        _this3.setCurrentLanguage(data.language);

        return _this3;
      });
      this.eventManager.listen('focus', function () {
        return _this3.hide();
      });
      this.eventManager.listen('mousedown', function () {
        return _this3.hide();
      });
      this.eventManager.listen('closeAllPopup', function () {
        return _this3.hide();
      });
      this.eventManager.listen('closePopupCodeBlockLanguages', function () {
        return _this3.hide();
      });
      this.eventManager.listen('scroll', function () {
        return _this3.hide();
      });
    }

    /**
     * activate an item by index
     * @param {number} index - item index
     * @private
     * @memberof PopupCodeBlockLanguages
     */

  }, {
    key: '_activateButtonByIndex',
    value: function _activateButtonByIndex(index) {
      if (this._currentButton) {
        (0, _jquery2.default)(this._currentButton).removeClass('active');
      }
      this._currentButton = this._$buttons.get(index);
      (0, _jquery2.default)(this._currentButton).addClass('active');
      this._currentButton.scrollIntoView();
    }

    /**
     * move to prev language
     * @memberof PopupCodeBlockLanguages
     */

  }, {
    key: 'prev',
    value: function prev() {
      var index = this._$buttons.index(this._currentButton) - 1;
      if (index < 0) {
        index = this._$buttons.length - 1;
      }
      this._activateButtonByIndex(index);
    }

    /**
     * move to next language
     * @memberof PopupCodeBlockLanguages
     */

  }, {
    key: 'next',
    value: function next() {
      var index = this._$buttons.index(this._currentButton) + 1;
      if (index >= this._$buttons.length) {
        index = 0;
      }
      this._activateButtonByIndex(index);
    }

    /**
     * current language
     * @public
     * @memberof PopupCodeBlockLanguages
     * @returns {string} language
     */

  }, {
    key: 'getCurrentLanguage',
    value: function getCurrentLanguage() {
      var language = (0, _jquery2.default)(this._currentButton).data('lang');

      return language;
    }

    /**
     * set current language
     * @param {string} language - current language
     * @memberof PopupCodeBlockLanguages
     */

  }, {
    key: 'setCurrentLanguage',
    value: function setCurrentLanguage(language) {
      var item = this._$buttons.filter('.' + BUTTON_CLASS_PREFIX + language);
      if (item.length > 0) {
        var index = this._$buttons.index(item);
        this._activateButtonByIndex(index);
      }
    }

    /**
     * show popup
     * @param {object} callback - to be called on language selected & dismissed
     * @protected
     * @memberof PopupCodeBlockLanguages
     */

  }, {
    key: 'show',
    value: function show(callback) {
      this._onSelectedLanguage = callback.selected;
      this._onDismissed = callback.dismissed;
      _get(PopupCodeBlockLanguages.prototype.__proto__ || Object.getPrototypeOf(PopupCodeBlockLanguages.prototype), 'show', this).call(this);
    }

    /**
     * hide popup
     * @memberof PopupCodeBlockLanguages
     * @protected
     */

  }, {
    key: 'hide',
    value: function hide() {
      if (this._onDismissed) {
        this._onDismissed();
      }
      this._onSelectedLanguage = null;
      this._onDismissed = null;
      _get(PopupCodeBlockLanguages.prototype.__proto__ || Object.getPrototypeOf(PopupCodeBlockLanguages.prototype), 'hide', this).call(this);
    }
  }]);

  return PopupCodeBlockLanguages;
}(_layerpopup2.default);

exports.default = PopupCodeBlockLanguages;

/***/ }),
/* 103 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _layerpopup = __webpack_require__(7);

var _layerpopup2 = _interopRequireDefault(_layerpopup);

var _scrollSyncSplit = __webpack_require__(104);

var _scrollSyncSplit2 = _interopRequireDefault(_scrollSyncSplit);

var _codeBlockEditor = __webpack_require__(105);

var _codeBlockEditor2 = _interopRequireDefault(_codeBlockEditor);

var _codeBlockPreview = __webpack_require__(106);

var _codeBlockPreview2 = _interopRequireDefault(_codeBlockPreview);

var _codeBlockLanguagesCombo = __webpack_require__(107);

var _codeBlockLanguagesCombo2 = _interopRequireDefault(_codeBlockLanguagesCombo);

var _i18n = __webpack_require__(3);

var _i18n2 = _interopRequireDefault(_i18n);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements popup code block editor
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var CLASS_PREFIX = 'popup-editor-';
var CLASS_OK_BUTTON = 'te-ok-button';
var CLASS_CLOSE_BUTTON = 'te-close-button';
var CLASS_POPUP_CLOSE_BUTTON = 'tui-popup-close-button';
var TEMPLATE_HEADER_BUTTONS = '\n    <button type="button" class="' + CLASS_PREFIX + 'toggle-scroll"></button>\n    <button type="button" class="' + CLASS_PREFIX + 'toggle-preview"></button>\n    <button type="button" class="' + CLASS_PREFIX + 'toggle-fit"></button>\n    <button type="button" class="' + CLASS_POPUP_CLOSE_BUTTON + '"></button>\n';

/**
 * Class popup code block editor
 * @extends {LayerPopup}
 */

var PopupCodeBlockEditor = function (_LayerPopup) {
  _inherits(PopupCodeBlockEditor, _LayerPopup);

  /**
   * Creates an instance of PopupCodeBlockEditor.
   * @param {LayerPopupOption} options - layer popup option
   * @memberof PopupCodeBlockEditor
   */
  function PopupCodeBlockEditor(options) {
    _classCallCheck(this, PopupCodeBlockEditor);

    var TEMPLATE_CONTENT = '\n            <div class="' + CLASS_PREFIX + 'body"></div>\n            <div class="te-button-section">\n                <button type="button" class="' + CLASS_OK_BUTTON + '">' + _i18n2.default.get('OK') + '</button>\n                <button type="button" class="' + CLASS_CLOSE_BUTTON + '">' + _i18n2.default.get('Cancel') + '</button>\n            </div>\n        ';
    options = _tuiCodeSnippet2.default.extend({
      header: true,
      title: 'CodeBlock Editor',
      content: TEMPLATE_CONTENT,
      className: 'tui-popup-code-block-editor',
      headerButtons: TEMPLATE_HEADER_BUTTONS,
      modal: true
    }, options);
    return _possibleConstructorReturn(this, (PopupCodeBlockEditor.__proto__ || Object.getPrototypeOf(PopupCodeBlockEditor)).call(this, options));
  }

  /**
   * init instance.
   * store properties & prepare before initialize DOM
   * @param {LayerPopupOption} options - layer popup options
   * @memberof PopupCodeBlockEditor
   * @protected
   * @override
   */


  _createClass(PopupCodeBlockEditor, [{
    key: '_initInstance',
    value: function _initInstance(options) {
      _get(PopupCodeBlockEditor.prototype.__proto__ || Object.getPrototypeOf(PopupCodeBlockEditor.prototype), '_initInstance', this).call(this, options);

      this.eventManager = options.eventManager;
      this.convertor = options.convertor;
    }

    /**
     * initialize DOM, render popup
     * @memberof PopupCodeBlockEditor
     * @protected
     * @override
     */

  }, {
    key: '_initDOM',
    value: function _initDOM(options) {
      _get(PopupCodeBlockEditor.prototype.__proto__ || Object.getPrototypeOf(PopupCodeBlockEditor.prototype), '_initDOM', this).call(this, options);

      var el = this.$el.get(0);
      this._body = el.querySelector('.' + CLASS_PREFIX + 'body');
      this._toggleFitButton = el.querySelector('.' + CLASS_PREFIX + 'toggle-fit');
      this._togglePreviewButton = el.querySelector('.' + CLASS_PREFIX + 'toggle-preview');
      this._toggleScrollButton = el.querySelector('.' + CLASS_PREFIX + 'toggle-scroll');
      this._okButton = el.querySelector('.' + CLASS_OK_BUTTON);
      this._closeButton = el.querySelector('.' + CLASS_CLOSE_BUTTON);

      this._codeMirrorWrapper = this._createCodeBlockEditor();
      this._previewWrapper = this._createPreview();
      this._scrollSyncSplit = new _scrollSyncSplit2.default(this._body, this._codeMirrorWrapper, this._previewWrapper);

      this._updateFitWindowButton();
      this._updatePreviewButton();
      this._updateScrollButton();

      this._codeBlockLanguagesCombo = this._createCodeBlockLanguagesCombo();
    }

    /**
     * bind DOM events
     * @memberof PopupCodeBlockEditor
     * @protected
     * @override
     */

  }, {
    key: '_initDOMEvent',
    value: function _initDOMEvent() {
      var _this2 = this;

      _get(PopupCodeBlockEditor.prototype.__proto__ || Object.getPrototypeOf(PopupCodeBlockEditor.prototype), '_initDOMEvent', this).call(this);

      this.on('scroll', function (ev) {
        return ev.preventDefault();
      });
      this.on('click .' + CLASS_PREFIX + 'toggle-fit', function () {
        return _this2._toggleFitToWindow();
      });
      this.on('click .' + CLASS_PREFIX + 'toggle-preview', function () {
        return _this2._togglePreview();
      });
      this.on('click .' + CLASS_PREFIX + 'toggle-scroll', function () {
        return _this2._toggleScroll();
      });
      this.on('click .' + CLASS_OK_BUTTON, function () {
        return _this2._save();
      });
      this.on('click .' + CLASS_CLOSE_BUTTON, function () {
        return _this2.hide();
      });
      this.on('click .' + CLASS_PREFIX + 'close', function () {
        return _this2.hide();
      });
      this.on('click .' + CLASS_PREFIX + 'editor-wrapper', function (ev) {
        if (ev.target === _this2._codeMirrorWrapper) {
          _this2._focusEditor(true);
        }
      });
    }

    /**
     * bind editor events
     * @memberof PopupCodeBlockEditor
     * @protected
     * @abstract
     */

  }, {
    key: '_initEditorEvent',
    value: function _initEditorEvent() {
      var _this3 = this;

      _get(PopupCodeBlockEditor.prototype.__proto__ || Object.getPrototypeOf(PopupCodeBlockEditor.prototype), '_initEditorEvent', this).call(this);

      this.eventManager.listen('openPopupCodeBlockEditor', function (codeBlockElement) {
        _this3.eventManager.emit('closeAllPopup');
        _this3.show(codeBlockElement);

        return _this3;
      });
      this.eventManager.listen('closeAllPopup', this.hide.bind(this));
      this.eventManager.listen('closePopupCodeBlockEditor', this.hide.bind(this));
    }
  }, {
    key: '_createCodeBlockEditor',
    value: function _createCodeBlockEditor() {
      var codeMirrorWrapper = document.createElement('div');
      codeMirrorWrapper.classList.add(CLASS_PREFIX + 'editor-wrapper');

      this._codeBlockEditor = new _codeBlockEditor2.default(codeMirrorWrapper, this.eventManager);

      return codeMirrorWrapper;
    }
  }, {
    key: '_createPreview',
    value: function _createPreview() {
      var previewWrapper = document.createElement('div');
      this._codeBlockPreview = new _codeBlockPreview2.default((0, _jquery2.default)(previewWrapper), this.eventManager, this.convertor, this._codeBlockEditor);

      return previewWrapper;
    }
  }, {
    key: '_createCodeBlockLanguagesCombo',
    value: function _createCodeBlockLanguagesCombo() {
      var _this4 = this;

      var titleElement = this.getTitleElement();
      var codeBlockLanguagesCombo = new _codeBlockLanguagesCombo2.default(this.eventManager);

      codeBlockLanguagesCombo.setOnLanguageSelected(function (selectedLanguage) {
        _this4._codeBlockEditor.setLanguage(selectedLanguage);
        _this4._codeBlockEditor.refresh();
        _this4._focusEditor();
      });

      titleElement.innerHTML = 'CodeBlock Editor';
      titleElement.appendChild(codeBlockLanguagesCombo.getElement());

      return codeBlockLanguagesCombo;
    }
  }, {
    key: '_updateFitWindowButton',
    value: function _updateFitWindowButton() {
      (0, _jquery2.default)(this._toggleFitButton).toggleClass('active', this.isFitToWindow());
    }
  }, {
    key: '_updatePreviewButton',
    value: function _updatePreviewButton() {
      (0, _jquery2.default)(this._togglePreviewButton).toggleClass('active', this._scrollSyncSplit.isSplitView());
    }
  }, {
    key: '_updateScrollButton',
    value: function _updateScrollButton() {
      if (this._scrollSyncSplit.isSplitView()) {
        this._toggleScrollButton.style.display = 'inline-block';
      } else {
        this._toggleScrollButton.style.display = 'none';
      }
      (0, _jquery2.default)(this._toggleScrollButton).toggleClass('active', this._scrollSyncSplit.isScrollSynced());
    }
  }, {
    key: '_focusEditor',
    value: function _focusEditor(cursorToEnd) {
      this._codeBlockEditor.focus();
      if (cursorToEnd) {
        this._codeBlockEditor.moveCursorToEnd();
      } else {
        this._codeBlockEditor.moveCursorToStart();
      }
    }
  }, {
    key: '_togglePreview',
    value: function _togglePreview() {
      this._scrollSyncSplit.toggleSplitView();
      this._updatePreviewButton();
      this._updateScrollButton();
      this._codeBlockEditor.refresh();
    }
  }, {
    key: '_toggleFitToWindow',
    value: function _toggleFitToWindow() {
      this.toggleFitToWindow();
      this._updateFitWindowButton();
      this._codeBlockEditor.refresh();
    }
  }, {
    key: '_toggleScroll',
    value: function _toggleScroll() {
      this._scrollSyncSplit.toggleScrollSync();
      this._updateScrollButton();
    }

    /**
     * store code mirror text to wysiwyg code block
     * @memberof PopupCodeBlockEditor
     * @private
     */

  }, {
    key: '_save',
    value: function _save() {
      this._codeBlockEditor.save(this._codeBlockElement);
      this.hide();
    }

    /**
     * load code mirror text from wysiwyg code block
     * @param {HTMLElement} codeBlockElement - code block element instance to load code from
     * @private
     * @memberof PopupCodeBlockEditor
     */

  }, {
    key: '_load',
    value: function _load(codeBlockElement) {
      this._codeBlockElement = codeBlockElement;
      this._codeBlockEditor.load(codeBlockElement);
      this._codeBlockLanguagesCombo.setLanguage(this._codeBlockEditor.getLanguage());
      this._focusEditor();
      this._codeBlockPreview.refresh();
    }

    /**
     * show popup
     * @param {HTMLElement} codeBlockElement - code block element
     * @memberof PopupCodeBlockEditor
     * @override
     */

  }, {
    key: 'show',
    value: function show(codeBlockElement) {
      _get(PopupCodeBlockEditor.prototype.__proto__ || Object.getPrototypeOf(PopupCodeBlockEditor.prototype), 'show', this).call(this);

      if (!codeBlockElement) {
        throw new Error('should be called with codeBlockElement');
      }
      this._load(codeBlockElement);
    }

    /**
     * hide popup
     * @memberof PopupCodeBlockEditor
     * @override
     */

  }, {
    key: 'hide',
    value: function hide() {
      this.setFitToWindow(false);

      if (this._codeBlockEditor) {
        this._codeBlockEditor.clear();
      }
      if (this._codeBlockPreview) {
        this._codeBlockPreview.clear();
      }
      this._codeBlockElement = null;

      _get(PopupCodeBlockEditor.prototype.__proto__ || Object.getPrototypeOf(PopupCodeBlockEditor.prototype), 'hide', this).call(this);
    }
  }]);

  return PopupCodeBlockEditor;
}(_layerpopup2.default);

exports.default = PopupCodeBlockEditor;

/***/ }),
/* 104 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements scroll sync split
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var CLASS_SPLIT_SCROLL = 'tui-split-scroll';
var CLASS_SINGLE_CONTENT = 'single-content';
var CLASS_SCROLL_SYNC = 'scroll-sync';
var CLASS_SCROLL_WRAPPER = 'tui-split-scroll-wrapper';
var CLASS_SCROLL_CONTENT = 'tui-split-scroll-content';
var CLASS_SPLITTER = 'tui-splitter';
var EVENT_REQUIRE_SCROLL_SYNC = 'requireScrollSync';
var EVENT_REQUIRE_SCROLL_INTO_VIEW = 'requireScrollIntoView';
var CLASS_CONTENT_LEFT = 'tui-split-content-left';
var CLASS_CONTENT_RIGHT = 'tui-split-content-right';
var CLASS_CONTENT = {
  'left': CLASS_CONTENT_LEFT,
  'right': CLASS_CONTENT_RIGHT
};

/**
 * Class ScrollSyncSplit
 */

var ScrollSyncSplit = function () {
  /**
   * Creates an instance of ScrollSyncSplit.
   * @param {Element} baseElement - an element which attach a splitSyncSplit
   * @param {Element} leftElement - an element to be on left side split view
   * @param {Element} rightElement - an element to be on right side split view
   * @param {object} options - options
   *  @param {boolean} [options.showScrollSyncButton=false] - show scroll sync button on top right corner
   *  @param {boolean} [options.scrollSync=true] - true for enable scroll sync
   *  @param {boolean} [options.splitView=true] - true for split, false for single view
   * @memberof ScrollSyncSplit
   */
  function ScrollSyncSplit(baseElement, leftElement, rightElement) {
    var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

    _classCallCheck(this, ScrollSyncSplit);

    options = _tuiCodeSnippet2.default.extend({
      showScrollSyncButton: false,
      scrollSync: true,
      splitView: true
    }, options);
    this._baseElement = baseElement;

    /**
       * left, right side content elements
       */
    this._contentElements = [];

    this._initDom(leftElement, rightElement, options);
    this._initDomEvent();
  }

  _createClass(ScrollSyncSplit, [{
    key: '_initDom',
    value: function _initDom(leftElement, rightElement, options) {
      var el = document.createElement('div');
      el.className = CLASS_SPLIT_SCROLL;
      this._el = el;

      var scrollWrapper = document.createElement('div');
      scrollWrapper.className = CLASS_SCROLL_WRAPPER;
      this._scrollWrapper = scrollWrapper;
      this._setScrollSync(options.scrollSync);
      this.setSplitView(options.splitView);

      var contentWrapper = document.createElement('div');
      contentWrapper.className = CLASS_SCROLL_CONTENT;
      this._contentWrapper = contentWrapper;

      var splitter = document.createElement('div');
      splitter.className = CLASS_SPLITTER;

      this._baseElement.appendChild(el);
      el.appendChild(scrollWrapper);
      scrollWrapper.appendChild(contentWrapper);
      scrollWrapper.appendChild(splitter);
      this._setLeft(leftElement);
      this._setRight(rightElement);
    }
  }, {
    key: '_initDomEvent',
    value: function _initDomEvent() {
      this._contentWrapper.addEventListener('scroll', this.sync.bind(this));
    }
  }, {
    key: '_requireScrollIntoView',
    value: function _requireScrollIntoView(event) {
      var element = event.target;

      var _element$getBoundingC = element.getBoundingClientRect(),
          targetTop = _element$getBoundingC.top,
          targetBottom = _element$getBoundingC.bottom;

      var wrapperTop = void 0,
          wrapperBottom = void 0,
          wrapperElement = void 0;

      if (this.isScrollSynced()) {
        wrapperElement = this._contentWrapper;
      } else if ((0, _jquery2.default)(element).parents(this._contentElements.left).length) {
        wrapperElement = this._contentElements.left;
      } else if ((0, _jquery2.default)(element).parents(this._contentElements.right).length) {
        wrapperElement = this._contentElements.right;
      } else {
        return;
      }

      var _wrapperElement$getBo = wrapperElement.getBoundingClientRect();

      wrapperTop = _wrapperElement$getBo.top;
      wrapperBottom = _wrapperElement$getBo.bottom;


      if (targetTop < wrapperTop) {
        wrapperElement.scrollTop = wrapperElement.scrollTop + targetTop - wrapperTop;
      } else if (targetBottom > wrapperBottom) {
        wrapperElement.scrollTop = wrapperElement.scrollTop + targetBottom - wrapperBottom;
      }

      this.sync();
    }

    /**
     * set content element for given side
     * @param {Element} element - content element
     * @param {string} side - 'left' | 'right'
     * @memberof ScrollSyncSplit
     * @private
     */

  }, {
    key: '_setContentElement',
    value: function _setContentElement(element, side) {
      var _this = this;

      var contentElement = this._contentElements[side];

      if (contentElement) {
        (0, _jquery2.default)(contentElement).off(EVENT_REQUIRE_SCROLL_INTO_VIEW);
        this._contentWrapper.removeChild(contentElement);
      }
      element.classList.add(CLASS_CONTENT[side]);
      this._contentWrapper.appendChild(element);
      (0, _jquery2.default)(element).on(EVENT_REQUIRE_SCROLL_INTO_VIEW, function (ev) {
        return _this._requireScrollIntoView(ev);
      });
      (0, _jquery2.default)(element).on(EVENT_REQUIRE_SCROLL_SYNC, function () {
        return _this.sync();
      });

      this._contentElements[side] = element;

      this.sync();
    }

    /**
     * set left side element
     * @param {Element} element - an element to be on left side split view
     * @memberof ScrollSyncSplit
     * @private
     */

  }, {
    key: '_setLeft',
    value: function _setLeft(element) {
      this._setContentElement(element, 'left');
    }

    /**
     * set right side element
     * @param {Element} element - an element to be on right side split view
     * @memberof ScrollSyncSplit
     * @private
     */

  }, {
    key: '_setRight',
    value: function _setRight(element) {
      this._setContentElement(element, 'right');
    }
  }, {
    key: '_setScrollSync',
    value: function _setScrollSync(activate) {
      (0, _jquery2.default)(this._el).toggleClass(CLASS_SCROLL_SYNC, activate);
    }

    /**
     * toggle multi scroll
     * @memberof ScrollSyncSplit
     */

  }, {
    key: 'toggleScrollSync',
    value: function toggleScrollSync() {
      this._el.classList.toggle(CLASS_SCROLL_SYNC);
    }
  }, {
    key: 'setSplitView',
    value: function setSplitView(activate) {
      (0, _jquery2.default)(this._el).toggleClass(CLASS_SINGLE_CONTENT, !activate);
    }

    /**
     * toggle split
     * @memberof ScrollSyncSplit
     */

  }, {
    key: 'toggleSplitView',
    value: function toggleSplitView() {
      this._el.classList.toggle(CLASS_SINGLE_CONTENT);
    }

    /**
     * is scroll synced
     * @returns {boolean} - true for synced, false for each scroll
     * @memberof ScrollSyncSplit
     */

  }, {
    key: 'isScrollSynced',
    value: function isScrollSynced() {
      return this._el.classList.contains(CLASS_SCROLL_SYNC);
    }

    /**
     * is split view
     * @returns {boolean} - true for split view, false for single view
     * @memberof ScrollSyncSplit
     */

  }, {
    key: 'isSplitView',
    value: function isSplitView() {
      return !this._el.classList.contains(CLASS_SINGLE_CONTENT);
    }

    /**
     * sync scroll
     * @memberof ScrollSyncSplit
     */

  }, {
    key: 'sync',
    value: function sync() {
      if (!this._contentElements.left || !this._contentElements.right) {
        return;
      }

      var wrapperHeight = this._contentWrapper.clientHeight;
      var scrollTop = this._contentWrapper.scrollTop;

      var leftElement = this._contentElements.left;
      var rightElement = this._contentElements.right;

      var scrollingElement = leftElement.offsetHeight - wrapperHeight > 0 ? leftElement : rightElement;
      var followingElement = scrollingElement === leftElement ? rightElement : leftElement;

      var scrollingElementHeight = scrollingElement.offsetHeight;
      var scrollingElementScrollMax = Math.max(scrollingElementHeight - wrapperHeight, 0);
      var followingElementHeight = Math.max(followingElement.offsetHeight, wrapperHeight);
      var followingElementTopMax = scrollingElementHeight - followingElementHeight;

      scrollingElement.style.top = '0px';
      followingElement.style.top = scrollTop / scrollingElementScrollMax * followingElementTopMax + 'px';
    }

    /**
     * scroll top
     * @param {number} top - scroll top in pixel
     * @memberof ScrollSyncSplit
     */

  }, {
    key: 'scrollTop',
    value: function scrollTop(top) {
      this._contentWrapper.scrollTop = top;
    }
  }]);

  return ScrollSyncSplit;
}();

exports.default = ScrollSyncSplit;

/***/ }),
/* 105 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _codeMirrorExt = __webpack_require__(29);

var _codeMirrorExt2 = _interopRequireDefault(_codeMirrorExt);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements code block editor
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var EVENT_LANGUAGE_CHANGED = 'language-changed';

/**
 * Class Code Block Editor
 * @extends {CodeMirrorExt}
 */

var CodeBlockEditor = function (_CodeMirrorExt) {
  _inherits(CodeBlockEditor, _CodeMirrorExt);

  /**
   * Creates an instance of CodeBlockEditor.
   * @param {HTMLElement} el - code block editor container element
   * @param {EventManager} eventManager - event manager
   * @memberof CodeBlockEditor
   */
  function CodeBlockEditor(el, eventManager) {
    _classCallCheck(this, CodeBlockEditor);

    var _this = _possibleConstructorReturn(this, (CodeBlockEditor.__proto__ || Object.getPrototypeOf(CodeBlockEditor)).call(this, el, {
      singleCursorHeightPerLine: false,
      theme: 'none'
    }));

    _this._language = '';
    _this._eventManager = eventManager;

    _this._initEvent();
    return _this;
  }

  _createClass(CodeBlockEditor, [{
    key: '_initEvent',
    value: function _initEvent() {
      var _this2 = this;

      this.on('cursorActivity', this._onRequireScrollIntoView.bind(this));
      this.on('beforeChange', function (cm, ev) {
        if (ev.origin === 'paste') {
          _this2._eventManager.emit('pasteBefore', {
            source: 'codeblock',
            data: ev
          });
        }
      });
    }
  }, {
    key: '_onRequireScrollIntoView',
    value: function _onRequireScrollIntoView() {
      var cursor = this.getCursor();
      var wrapper = this.getWrapperElement();

      // CodeMirror cursorActivity event fires before actually attach a new line element to DOM
      // we should proceed at next tick
      setTimeout(function () {
        var lineElement = wrapper.querySelector('pre:nth-child(' + (cursor.line + 1) + ')');
        (0, _jquery2.default)(lineElement).trigger('requireScrollIntoView');
      }, 0);
    }

    /**
     * load code from code block element
     * @param {HTMLElement} codeBlockElement - code block element
     * @memberof CodeBlockEditor
     */

  }, {
    key: 'load',
    value: function load(codeBlockElement) {
      var el = codeBlockElement.cloneNode(true);
      var texts = [];

      var divs = el.querySelectorAll('div');
      [].slice.call(divs).forEach(function (div) {
        texts.push(div.innerText.replace(/\n$/, ''));
      });

      this.setLanguage(el.getAttribute('data-language') || '');
      this.setEditorCodeText(texts.join('\n'));
    }

    /**
     * save code to code block element
     * @param {HTMLElement} codeBlockElement - code block element
     * @memberof CodeBlockEditor
     */

  }, {
    key: 'save',
    value: function save(codeBlockElement) {
      codeBlockElement.innerHTML = '';

      var codeLines = this.getEditorCodeText().split('\n');
      codeLines.forEach(function (codeLine) {
        var div = document.createElement('div');
        codeBlockElement.appendChild(div);

        var childElement = void 0;
        if (codeLine.length > 0) {
          childElement = document.createTextNode(codeLine);
        } else {
          childElement = document.createElement('br');
        }
        div.appendChild(childElement);
      });

      codeBlockElement.setAttribute('data-language', this._language);
      (0, _jquery2.default)(codeBlockElement).trigger(EVENT_LANGUAGE_CHANGED);
    }

    /**
     * clear code and language
     * @memberof CodeBlockEditor
     */

  }, {
    key: 'clear',
    value: function clear() {
      this.setLanguage('');
      this.setEditorCodeText('');
    }

    /**
     * get code language
     * @returns {string} - code language
     * @memberof CodeBlockEditor
     */

  }, {
    key: 'getLanguage',
    value: function getLanguage() {
      return this._language;
    }

    /**
     * set code language
     * @param {string} [language=''] - code language
     * @memberof CodeBlockEditor
     */

  }, {
    key: 'setLanguage',
    value: function setLanguage() {
      var language = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

      this._language = language;
    }

    /**
     * get code text
     * @returns {string} - code text
     * @memberof CodeBlockEditor
     */

  }, {
    key: 'getEditorCodeText',
    value: function getEditorCodeText() {
      return this.getValue();
    }

    /**
     * set code text
     * @param {string} [code=''] - code text
     * @memberof CodeBlockEditor
     */

  }, {
    key: 'setEditorCodeText',
    value: function setEditorCodeText() {
      var code = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

      this.setValue(code);
    }

    /**
     * refresh. call if codemirror resized
     * @memberof CodeBlockEditor
     */

  }, {
    key: 'refresh',
    value: function refresh() {
      this.cm.refresh();
    }
  }]);

  return CodeBlockEditor;
}(_codeMirrorExt2.default);

exports.default = CodeBlockEditor;

/***/ }),
/* 106 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _preview = __webpack_require__(32);

var _preview2 = _interopRequireDefault(_preview);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Implements CodeBlockPreview
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var EVENT_REQUIRE_SCROLL_SYNC = 'requireScrollSync';

/**
 * Class Code block preview
 * @extends {Preview}
 */

var CodeBlockPreview = function (_Preview) {
  _inherits(CodeBlockPreview, _Preview);

  /**
   * Creates an instance of CodeBlockPreview.
   * @param {jQuery} $el - base element
   * @param {EventManager} eventManager - event manager
   * @param {Convertor} convertor - convertor
   * @param {CodeBlockEditor} codeBlockEditor - code block editor
   * @memberof CodeBlockPreview
   */
  function CodeBlockPreview($el, eventManager, convertor, codeBlockEditor) {
    _classCallCheck(this, CodeBlockPreview);

    var _this = _possibleConstructorReturn(this, (CodeBlockPreview.__proto__ || Object.getPrototypeOf(CodeBlockPreview)).call(this, $el, eventManager, convertor, true));

    _this._codeBlockEditor = codeBlockEditor;

    _this._initEvent();
    return _this;
  }

  _createClass(CodeBlockPreview, [{
    key: '_initEvent',
    value: function _initEvent() {
      var _this2 = this;

      this._codeBlockEditor.on('update', function () {
        return _this2.lazyRunner.run('refresh');
      });
    }

    /**
     * refresh preview
     * @memberof CodeBlockPreview
     * @override
     */

  }, {
    key: 'refresh',
    value: function refresh() {
      var language = this._codeBlockEditor.getLanguage();
      var codeText = this._codeBlockEditor.getEditorCodeText();

      _get(CodeBlockPreview.prototype.__proto__ || Object.getPrototypeOf(CodeBlockPreview.prototype), 'refresh', this).call(this, '```' + language + '\n' + codeText + '\n```');
      this.$el.trigger(EVENT_REQUIRE_SCROLL_SYNC);
    }

    /**
     * clear preview
     * @memberof CodeBlockPreview
     */

  }, {
    key: 'clear',
    value: function clear() {
      _get(CodeBlockPreview.prototype.__proto__ || Object.getPrototypeOf(CodeBlockPreview.prototype), 'render', this).call(this, '');
    }
  }]);

  return CodeBlockPreview;
}(_preview2.default);

exports.default = CodeBlockPreview;

/***/ }),
/* 107 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @fileoverview Implements UI code block languages combo
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _i18n = __webpack_require__(3);

var _i18n2 = _interopRequireDefault(_i18n);

var _keyMapper = __webpack_require__(21);

var _keyMapper2 = _interopRequireDefault(_keyMapper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Class CodeBlockLanguagesCombo
 */
var CodeBlockLanguagesCombo = function () {
  /**
   * Creates an instance of CodeBlockLanguagesCombo.
   * @param {EventManager} eventManager - event manager instance
   * @memberof CodeBlockLanguagesCombo
   */
  function CodeBlockLanguagesCombo(eventManager) {
    _classCallCheck(this, CodeBlockLanguagesCombo);

    this._eventManager = eventManager;

    this._initDOM();
    this._initDOMEvent();
  }

  _createClass(CodeBlockLanguagesCombo, [{
    key: '_initDOM',
    value: function _initDOM() {
      this._inputLanguage = (0, _jquery2.default)('<input type="text" maxlength="20" placeholder="' + _i18n2.default.get('Choose language') + '">').get(0);
      this._wrapper = (0, _jquery2.default)('<span class="te-input-language">').get(0);
      this._wrapper.appendChild(this._inputLanguage);
    }
  }, {
    key: '_initDOMEvent',
    value: function _initDOMEvent() {
      var _this = this;

      this._inputLanguage.addEventListener('keydown', function (event) {
        return _this._onKeyEvent(event);
      });
      this._inputLanguage.addEventListener('focus', function () {
        return _this._showPopupCodeBlockLanguages();
      });
      this._inputLanguage.addEventListener('focusout', function () {
        return _this._onFocusOut();
      });
      this._wrapper.addEventListener('mousedown', function (ev) {
        if (ev.target !== _this._wrapper) {
          return;
        }
        ev.preventDefault();
        _this._toggleFocus();
      });
    }

    /**
     * show popup
     * @private
     * @memberof CodeBlockGadget
     */

  }, {
    key: '_showPopupCodeBlockLanguages',
    value: function _showPopupCodeBlockLanguages() {
      var _this2 = this;

      var clientRect = this._inputLanguage.getBoundingClientRect();
      this._wrapper.classList.toggle('active', true);
      this.active = true;

      this._popupCodeBlockLanguages = this._eventManager.emitReduce('openPopupCodeBlockLanguages', {
        language: this._prevStoredLanguage,
        offset: {
          left: clientRect.left,
          top: clientRect.bottom
        },
        callback: {
          selected: function selected(selectedLanguage) {
            return _this2._onLanguageSelectedFromList(selectedLanguage);
          },
          dismissed: function dismissed() {
            _this2._popupCodeBlockLanguages = null;
          }
        }
      });
    }
  }, {
    key: '_toggleFocus',
    value: function _toggleFocus() {
      var inputLanguage = this._inputLanguage;
      if (this._wrapper.classList.contains('active')) {
        inputLanguage.blur();
      } else {
        inputLanguage.focus();
      }
    }
  }, {
    key: '_onFocusOut',
    value: function _onFocusOut() {
      this._wrapper.classList.toggle('active', false);
      this._inputLanguage.value = this._prevStoredLanguage;
      this._hidePopupCodeBlockLanguages();
    }
  }, {
    key: '_onKeyEvent',
    value: function _onKeyEvent(event) {
      if (this._popupCodeBlockLanguages) {
        switch (event.which) {
          case _keyMapper2.default.keyCode('UP'):
            this._popupCodeBlockLanguages.prev();
            event.preventDefault();
            break;
          case _keyMapper2.default.keyCode('DOWN'):
            this._popupCodeBlockLanguages.next();
            event.preventDefault();
            break;
          case _keyMapper2.default.keyCode('ENTER'):
          case _keyMapper2.default.keyCode('TAB'):
            {
              var language = this._popupCodeBlockLanguages.getCurrentLanguage();
              this._inputLanguage.value = language;
              this._storeInputLanguage();
              event.preventDefault();
              break;
            }
          default:
            this._popupCodeBlockLanguages.hide();
        }
      } else if (event.which === _keyMapper2.default.keyCode('ENTER') || event.which === _keyMapper2.default.keyCode('TAB')) {
        this._storeInputLanguage();
        event.preventDefault();
      }
    }
  }, {
    key: '_onLanguageSelectedFromList',
    value: function _onLanguageSelectedFromList(selectedLanguage) {
      this._inputLanguage.value = selectedLanguage;
      this._storeInputLanguage();
    }

    /**
     * set a callback to be called on language selected
     * @param {function} callback - callback function
     * @memberof CodeBlockLanguagesCombo
     */

  }, {
    key: 'setOnLanguageSelected',
    value: function setOnLanguageSelected(callback) {
      this._onLanguageSelected = callback;
    }

    /**
     * hide popup
     * @private
     * @memberof CodeBlockGadget
     */

  }, {
    key: '_hidePopupCodeBlockLanguages',
    value: function _hidePopupCodeBlockLanguages() {
      this._eventManager.emit('closePopupCodeBlockLanguages');
    }

    /**
     * set language
     * @param {string} language - code block language
     * @memberof CodeBlockLanguagesCombo
     */

  }, {
    key: 'setLanguage',
    value: function setLanguage(language) {
      this._prevStoredLanguage = language;
      this._inputLanguage.value = language;
    }

    /**
     * store selection(typed) language & hide popup
     * @private
     * @memberof CodeBlockGadget
     */

  }, {
    key: '_storeInputLanguage',
    value: function _storeInputLanguage() {
      var selectedLanguage = this._inputLanguage.value;

      this.setLanguage(selectedLanguage);
      if (this._onLanguageSelected) {
        this._onLanguageSelected(selectedLanguage);
      }

      this._hidePopupCodeBlockLanguages();
    }

    /**
     * get element body
     * @returns {HTMLElement} - CodeBlockLanguagesCombo body element
     * @memberof CodeBlockLanguagesCombo
     */

  }, {
    key: 'getElement',
    value: function getElement() {
      return this._wrapper;
    }
  }]);

  return CodeBlockLanguagesCombo;
}();

exports.default = CodeBlockLanguagesCombo;

/***/ }),
/* 108 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var boldRegex = /^[*_]{2,}[^*_]*[*_]{2,}$/;

/**
 * Bold
 * Add bold markdown syntax to markdown editor
 * @extends Command
 * @module markdownCommands/Bold
 * @ignore
 */
/**
* @fileoverview Implements Bold markdown command
* @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
*/
var Bold = _commandManager2.default.command('markdown', /** @lends Bold */{
  name: 'Bold',
  keyMap: ['CTRL+B', 'META+B'],
  /**
   * Command Handler
   * @param {MarkdownEditor} mde MarkdownEditor instance
   */
  exec: function exec(mde) {
    var cm = mde.getEditor();
    var doc = cm.getDoc();

    var cursor = doc.getCursor();
    var selection = doc.getSelection();
    var isEmpty = !selection;

    // if selection is empty, expend selection to detect a syntax
    if (isEmpty && cursor.ch > 1) {
      var tmpSelection = this.expendSelection(doc, cursor);
      selection = tmpSelection || selection;
    }

    var isRemoved = this.isNeedRemove(selection);
    var result = isRemoved ? this.remove(selection) : this.append(selection);

    doc.replaceSelection(result, 'around');

    if (isEmpty && !isRemoved) {
      this.setCursorToCenter(doc, cursor);
    }

    cm.focus();
  },


  /**
   * test it has bold
   * @param {string} text - text selected
   * @returns {boolean} - true if it has bold
   */
  isNeedRemove: function isNeedRemove(text) {
    return boldRegex.test(text);
  },


  /**
   * apply bold
   * @param {string} text - text selected
   * @returns {string} - bold text
   */
  append: function append(text) {
    return '**' + text + '**';
  },


  /**
   * remove bold
   * @param {string} text - text selected
   * @returns {string} - un-bold text
   */
  remove: function remove(text) {
    return text.substr(2, text.length - 4);
  },


  /**
   * expand selection
   * @param {CodeMirror.doc} doc - codemirror document
   * @param {object} cursor - codemirror cursor
   * @returns {string} - text selected
   */
  expendSelection: function expendSelection(doc, cursor) {
    var tmpSelection = doc.getSelection();
    var result = void 0;
    var start = {
      line: cursor.line,
      ch: cursor.ch - 2
    };
    var end = {
      line: cursor.line,
      ch: cursor.ch + 2
    };

    doc.setSelection(start, end);

    if (tmpSelection === '****' || tmpSelection === '____') {
      result = tmpSelection;
    } else {
      doc.setSelection(cursor);
    }

    return result;
  },


  /**
   * move cursor to center
   * @param {CodeMirror.doc} doc - codemirror document
   * @param {object} cursor - codemirror cursor
   */
  setCursorToCenter: function setCursorToCenter(doc, cursor) {
    doc.setCursor(cursor.line, cursor.ch + 2);
  }
});

exports.default = Bold;

/***/ }),
/* 109 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var boldItalicRegex = /^[*_]{3,}[^*_]*[*_]{3,}$/; /**
                                                   * @fileoverview Implements Italic markdown command
                                                   * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                                   */

var italicRegex = /^[*_][^*_]*[*_]$/;

/**
 * Italic
 * Add italic markdown syntax to markdown editor
 * @extends Command
 * @module markdownCommands/Italic
 * @ignore
 */
var Italic = _commandManager2.default.command('markdown', /** @lends Italic */{
  name: 'Italic',
  keyMap: ['CTRL+I', 'META+I'],
  /**
   * Command handler
   * @param {MarkdownEditor} mde MarkdownEditor instance
   */
  exec: function exec(mde) {
    var cm = mde.getEditor();
    var doc = cm.getDoc();

    var cursor = doc.getCursor();
    var selection = doc.getSelection();
    var isEmpty = !selection;
    var isWithBold = false;
    var tmpSelection = void 0;

    // if selection is empty, expend selection to detect a syntax
    if (isEmpty) {
      if (cursor.ch > 2) {
        tmpSelection = this.expendWithBoldSelection(doc, cursor);

        if (tmpSelection) {
          isWithBold = 'with';
        }
      }

      if (isWithBold !== 'with' && cursor.ch > 1) {
        isWithBold = this.expendOnlyBoldSelection(doc, cursor);
      }

      if (!isWithBold && cursor.ch > 0) {
        this.expendSelection(doc, cursor);
        selection = tmpSelection || selection;
      }
    }

    var isRemoved = this.isNeedRemove(selection);
    var result = isRemoved ? this.remove(selection) : this.append(selection);

    doc.replaceSelection(result, 'around');

    if (isEmpty) {
      this.setCursorToCenter(doc, cursor, isRemoved);
    }

    cm.focus();
  },


  /**
   * isNeedRemove
   * test given text has italic or bold
   * @param {string} text - text to test
   * @returns {boolean} - true if it has italic or bold
   */
  isNeedRemove: function isNeedRemove(text) {
    return italicRegex.test(text) || boldItalicRegex.test(text);
  },


  /**
   * apply italic
   * @param {string} text - text to apply
   * @returns {string} - italic text
   */
  append: function append(text) {
    return '_' + text + '_';
  },


  /**
   * remove italic
   * @param {string} text - text to remove italic syntax
   * @returns {string} - italic syntax revmoed text
   */
  remove: function remove(text) {
    return text.substr(1, text.length - 2);
  },


  /**
   * expand selected area
   * @param {CodeMirror.doc} doc - codemirror document
   * @param {object} cursor - codemirror cursor
   * @returns {string} - text in range after it has been expaneded
   */
  expendWithBoldSelection: function expendWithBoldSelection(doc, cursor) {
    var tmpSelection = doc.getSelection();
    var result = void 0;
    var start = {
      line: cursor.line,
      ch: cursor.ch - 3
    };
    var end = {
      line: cursor.line,
      ch: cursor.ch + 3
    };

    doc.setSelection(start, end);

    if (tmpSelection === '******' || tmpSelection === '______') {
      result = tmpSelection;
    } else {
      doc.setSelection(cursor);
    }

    return result;
  },


  /**
   * expand only bold selection
   * @param {CodeMirror.doc} doc - codemirror document
   * @param {object} cursor - codemirror cursor
   * @returns {string} - text in area after it has been expaneded
   */
  expendOnlyBoldSelection: function expendOnlyBoldSelection(doc, cursor) {
    var tmpSelection = doc.getSelection();
    var result = false;
    var start = {
      line: cursor.line,
      ch: cursor.ch - 2
    };
    var end = {
      line: cursor.line,
      ch: cursor.ch + 2
    };

    doc.setSelection(start, end);

    if (tmpSelection === '****' || tmpSelection === '____') {
      doc.setSelection(cursor);
      result = 'only';
    }

    return result;
  },


  /**
   * expand only italic selection
   * @param {CodeMirror.doc} doc - codemirror document
   * @param {object} cursor - codemirror cursor
   * @returns {string} - text in area after it has been expaneded
   */
  expendSelection: function expendSelection(doc, cursor) {
    var tmpSelection = doc.getSelection();
    var result = void 0;
    var start = {
      line: cursor.line,
      ch: cursor.ch - 2
    };
    var end = {
      line: cursor.line,
      ch: cursor.ch + 2
    };

    doc.setSelection(start, end);

    if (tmpSelection === '****' || tmpSelection === '____') {
      result = tmpSelection;
    } else {
      doc.setSelection(cursor);
    }

    return result;
  },

  /**
   * move cursor to center
   * @param {CodeMirror.doc} doc - codemirror document
   * @param {object} cursor - codemirror cursor
   * @param {boolean} isRemoved - whether it involes deletion
   */
  setCursorToCenter: function setCursorToCenter(doc, cursor, isRemoved) {
    var pos = isRemoved ? -1 : 1;
    doc.setCursor(cursor.line, cursor.ch + pos);
  }
});

exports.default = Italic;

/***/ }),
/* 110 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var strikeRegex = /^[~~](.*[\s\n]*.*)*[~~]$/;

/**
 * Strike
 * Add strike markdown syntax to markdown editor
 * @extends Command
 * @module markdownCommands/Strike
 * @ignore
 */
/**
 * @fileoverview Implements StrikeThrough markdown command
 * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */
var Strike = _commandManager2.default.command('markdown', /** @lends Strike */{
  name: 'Strike',
  keyMap: ['CTRL+S', 'META+S'],
  /**
   * Command handler
   * @param {MarkdownEditor} mde MarkdownEditor instance
   */
  exec: function exec(mde) {
    var cm = mde.getEditor();
    var doc = cm.getDoc();
    var cursor = doc.getCursor();
    var selection = doc.getSelection();
    var isNeedToRemove = this.hasStrikeSyntax(selection);

    var result = void 0;

    if (isNeedToRemove) {
      result = this.remove(selection);
    } else {
      result = this.append(selection);
    }

    doc.replaceSelection(result, 'around');

    var isEmptySelection = !selection;

    if (isEmptySelection && !isNeedToRemove) {
      this.setCursorToCenter(doc, cursor, isNeedToRemove);
    }

    cm.focus();
  },


  /**
   * hasStrikeSyntax
   * @param {string} text Source text
   * @returns {boolean} Boolean value of strike syntax removal
   */
  hasStrikeSyntax: function hasStrikeSyntax(text) {
    return strikeRegex.test(text);
  },


  /**
   * append strike
   * @param {string} text - text to apply
   * @returns {string} - strike through text
   */
  append: function append(text) {
    return '~~' + text + '~~';
  },


  /**
   * remove strike
   * @param {string} text - text to remove
   * @returns {string} - strike removed text
   */
  remove: function remove(text) {
    return text.substr(2, text.length - 4);
  },


  /**
   * set cursor to center
   * @param {CodeMirror.doc} doc - codemirror document
   * @param {object} cursor - codemirror cursor
   * @param {boolean} isRemoved - whether it involes deletion
   */
  setCursorToCenter: function setCursorToCenter(doc, cursor, isRemoved) {
    var pos = isRemoved ? -2 : 2;
    doc.setCursor(cursor.line, cursor.ch + pos);
  }
});

exports.default = Strike;

/***/ }),
/* 111 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Blockquote
 * Add blockquote markdown syntax to markdown editor
 * @extends Command
 * @module markdownCommands/Blockquote
 * @ignore
 */
var Blockquote = _commandManager2.default.command('markdown', /** @lends Blockquote */{
  name: 'Blockquote',
  keyMap: ['CTRL+Q', 'META+Q'],
  /**
   * command handler
   * @param {MarkdownEditor} mde MarkdownEditor instance
   */
  exec: function exec(mde) {
    var cm = mde.getEditor();
    var doc = cm.getDoc();

    var range = mde.getCurrentRange();

    var from = {
      line: range.from.line,
      ch: 0
    };

    var to = {
      line: range.to.line,
      ch: doc.getLineHandle(range.to.line).text.length
    };

    var textToModify = doc.getRange(from, to);
    var textLinesToModify = textToModify.split('\n');
    var lineLength = textLinesToModify.length;

    for (var i = 0; i < lineLength; i += 1) {
      textLinesToModify[i] = '>' + textLinesToModify[i];
    }

    doc.replaceRange(textLinesToModify.join('\n'), from, to);

    range.to.ch += 1;

    doc.setCursor(range.to);

    cm.focus();
  }
}); /**
    * @fileoverview Implements Blockquote markdown command
    * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
    */
exports.default = Blockquote;

/***/ }),
/* 112 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @fileoverview Implements Heading markdown command
 * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */
var FIND_HEADING_RX = /^#+\s/g;

/**
 * Heading
 * Add heading markdown syntax to markdown editor
 * @extends Command
 * @module markdownCommands/Heading
 * @ignore
 */
var Heading = _commandManager2.default.command('markdown', /** @lends Heading */{
  name: 'Heading',
  /**
   * Command Handler
   * @param {MarkdownEditor} mde MarkdownEditor instance
   * @param {number} size heading size
   */
  exec: function exec(mde, size) {
    var cm = mde.getEditor();
    var doc = cm.getDoc();

    var range = mde.getCurrentRange();

    var from = {
      line: range.from.line,
      ch: 0
    };

    var to = {
      line: range.to.line,
      ch: doc.getLineHandle(range.to.line).text.length
    };

    var lengthOfCurrentLineBefore = doc.getLine(to.line).length;
    var textToModify = doc.getRange(from, to);
    var textLinesToModify = textToModify.split('\n');

    _tuiCodeSnippet2.default.forEachArray(textLinesToModify, function (line, index) {
      textLinesToModify[index] = getHeadingMarkdown(line, size);
    });

    doc.replaceRange(textLinesToModify.join('\n'), from, to);

    range.to.ch += doc.getLine(to.line).length - lengthOfCurrentLineBefore;

    doc.setSelection(from, range.to);

    cm.focus();
  }
});

/**
 * Get heading markdown
 * @param {string} text Source test
 * @param {number} size size
 * @returns {string}
 */
function getHeadingMarkdown(text, size) {
  var foundedHeading = text.match(FIND_HEADING_RX);
  var heading = '';

  do {
    heading += '#';
    size -= 1;
  } while (size > 0);

  if (foundedHeading) {
    var _text$split = text.split(foundedHeading[0]);

    text = _text$split[1];
  }

  return heading + ' ' + text;
}

exports.default = Heading;

/***/ }),
/* 113 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _tuiCodeSnippet = __webpack_require__(1);

var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Paragraph
 * Convert selected lines to paragraph
 * @extends Command
 * @module markdownCommands/Paragraph
 * @ignore
 */
/**
 * @fileoverview Implements Paragraph markdown command
 * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */
var Paragraph = _commandManager2.default.command('markdown', /** @lends Paragraph */{
  name: 'Paragraph',
  /**
   * Command Handler
   * @param {MarkdownEditor} mde MarkdownEditor instance
   */
  exec: function exec(mde) {
    var cm = mde.getEditor();
    var doc = cm.getDoc();
    var range = mde.getCurrentRange();
    var from = {
      line: range.from.line,
      ch: 0
    };
    var to = {
      line: range.to.line,
      ch: doc.getLineHandle(range.to.line).text.length
    };

    var lengthOfCurrentLineBefore = doc.getLine(to.line).length;
    var textToModify = doc.getRange(from, to);
    var textLines = textToModify.split('\n');

    _tuiCodeSnippet2.default.forEachArray(textLines, function (line, index) {
      textLines[index] = getParagraphMarkdown(line);
    });

    doc.replaceRange(textLines.join('\n'), from, to);

    range.to.ch += doc.getLine(to.line).length - lengthOfCurrentLineBefore;

    doc.setSelection(from, to);

    cm.focus();
  }
});
/**
 * Get paragraph markdown lineText
 * @param {string} lineText line lineText
 * @returns {string}
 */
function getParagraphMarkdown(lineText) {
  var headingRx = /^(#{1,6}| *((?:\*|-|\d\.)(?: \[[ xX]])?)) /;

  return lineText.replace(headingRx, '');
}

exports.default = Paragraph;

/***/ }),
/* 114 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * HR
 * Add HR markdown syntax to markdown editor
 * @extends Command
 * @module markdownCommands/HR
 * @ignore
 */
var HR = _commandManager2.default.command('markdown', /** @lends HR */{
  name: 'HR',
  keyMap: ['CTRL+L', 'META+L'],
  /**
   * Command handler
   * @param {MarkdownEditor} mde MarkdownEditor instance
   */
  exec: function exec(mde) {
    var cm = mde.getEditor();
    var doc = cm.getDoc();
    var replaceText = '';

    var range = mde.getCurrentRange();

    var from = {
      line: range.from.line,
      ch: range.from.ch
    };

    var to = {
      line: range.to.line,
      ch: range.to.ch
    };

    if (range.collapsed) {
      replaceText = doc.getLine(from.line);
      from.ch = 0;
      to.ch = doc.getLineHandle(range.to.line).text.length;
    }

    if (doc.getLine(from.line).length) {
      replaceText += '\n\n* * *\n\n';
    } else {
      replaceText += '\n* * *\n';
    }

    doc.replaceRange(replaceText, from, to);

    cm.focus();
  }
}); /**
     * @fileoverview Implements HR markdown command
     * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
     */

exports.default = HR;

/***/ }),
/* 115 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

var _importManager = __webpack_require__(22);

var _importManager2 = _interopRequireDefault(_importManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
* @fileoverview Implements Addlink markdown command
* @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
*/
var decodeURIGraceful = _importManager2.default.decodeURIGraceful,
    encodeMarkdownCharacters = _importManager2.default.encodeMarkdownCharacters,
    escapeMarkdownCharacters = _importManager2.default.escapeMarkdownCharacters;

/**
 * AddLink
 * Add link markdown syntax to markdown editor
 * @extends Command
 * @module markdownCommands/AddLink
 * @ignore
 */

var AddLink = _commandManager2.default.command('markdown', /** @lends AddLink */{
  name: 'AddLink',
  /**
   * command handler for AddLink
   * @param {MarkdownEditor} mde - MarkdownEditor instance
   * @param {object} data - data for image
   */
  exec: function exec(mde, data) {
    var cm = mde.getEditor();
    var doc = cm.getDoc();

    var range = mde.getCurrentRange();

    var from = {
      line: range.from.line,
      ch: range.from.ch
    };

    var to = {
      line: range.to.line,
      ch: range.to.ch
    };

    var linkText = data.linkText,
        url = data.url;

    linkText = decodeURIGraceful(linkText);
    linkText = escapeMarkdownCharacters(linkText);
    url = encodeMarkdownCharacters(url);

    var replaceText = '[' + linkText + '](' + url + ')';

    doc.replaceRange(replaceText, from, to);

    cm.focus();
  }
});

exports.default = AddLink;

/***/ }),
/* 116 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * AddImage
 * Add Image markdown syntax to markdown Editor
 * @extends Command
 * @module markdownCommands/AddImage
 * @ignore
 */
var AddImage = _commandManager2.default.command('markdown', /** @lends AddImage */{
  name: 'AddImage',
  /**
   * Command Handler
   * @param {MarkdownEditor} mde MarkdownEditor instance
   * @param {object} data data for image
   */
  exec: function exec(mde, data) {
    var cm = mde.getEditor();
    var doc = cm.getDoc();

    var range = mde.getCurrentRange();

    var from = {
      line: range.from.line,
      ch: range.from.ch
    };

    var to = {
      line: range.to.line,
      ch: range.to.ch
    };

    var replaceText = '![' + data.altText + '](' + data.imageUrl + ')';

    doc.replaceRange(replaceText, from, to, '+addImage');

    cm.focus();
  }
}); /**
    * @fileoverview Implments AddImage markdown command
    * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
    */
exports.default = AddImage;

/***/ }),
/* 117 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var FIND_MD_OL_RX = /^[ \t]*[\d]+\. .*/; /**
                                          * @fileoverview Implements UL markdown command
                                          * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                          */

var FIND_MD_UL_RX = /^[ \t]*[-*] .*/;
var FIND_MD_TASK_RX = /^[ \t]*[-*]( \[[ xX]])? .*/;

/**
 * UL
 * Add unordered list markdown syntax to markdown editor
 * @extends Command
 * @module markdownCommands/UL
 * @ignore
 */
var UL = _commandManager2.default.command('markdown', /** @lends UL */{
  name: 'UL',
  keyMap: ['CTRL+U', 'META+U'],
  /**
   * Command handler
   * @param {MarkdownEditor} mde MarkdownEditor instance
   */
  exec: function exec(mde) {
    var cm = mde.getEditor();
    var doc = cm.getDoc();
    var range = mde.getCurrentRange();
    var listManager = mde.componentManager.getManager('list');
    var lineRange = listManager.expandLineRangeIfNeed(doc, range, isOlOrTask);
    var startLineNumber = lineRange.start;
    var endLineNumber = lineRange.end;
    var line = void 0,
        currentLineStart = void 0;

    for (var i = startLineNumber; i <= endLineNumber; i += 1) {
      currentLineStart = {
        line: i,
        ch: 0
      };

      line = doc.getLine(i);

      if (listManager.isListOrParagraph(line)) {
        if (isOlOrTask(line)) {
          listManager.replaceLineText(doc, i, /[\d]+\. /, '* ');
        } else if (!line.match(FIND_MD_UL_RX)) {
          doc.replaceRange('* ', currentLineStart);
        }

        if (i === endLineNumber) {
          listManager.appendBlankLineIfNeed(cm, i, endLineNumber, startLineNumber);
        }
      } else {
        break;
      }
    }
    cm.focus();
  }
});

/**
 * Return whether passed line is OL or TASK or neither
 * @param {string} line Line text
 * @returns {boolean}
 */
function isOlOrTask(line) {
  return !!(line && (line.match(FIND_MD_TASK_RX) || line.match(FIND_MD_OL_RX)));
}

exports.default = UL;

/***/ }),
/* 118 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var FIND_MD_OL_RX = /^[ \t]*[\d]+\. .*/; /**
                                          * @fileoverview Implements OL markdown command
                                          * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                          */

var FIND_MD_UL_RX = /^[ \t]*[-*] .*/;
var FIND_MD_TASK_RX = /^[ \t]*[-*]( \[[ xX]])? .*/;

/**
 * OL
 * Add ordered list markdown syntax to markdown editor
 * @extends Command
 * @module markdownCommands/OL
 * @ignore
 */
var OL = _commandManager2.default.command('markdown', /** @lends OL */{
  name: 'OL',
  keyMap: ['CTRL+O', 'META+O'],
  /**
   * Command handler
   * @param {MarkdownEditor} mde MarkdownEditor instance
   */
  exec: function exec(mde) {
    var cm = mde.getEditor();
    var doc = cm.getDoc();
    var range = mde.getCurrentRange();
    var listManager = mde.componentManager.getManager('list');
    var lineRange = listManager.expandLineRangeIfNeed(doc, range, isUlOrTask);
    var startLineNumber = lineRange.start;
    var endLineNumber = lineRange.end;
    var ordinalNumber = 1;
    var line = void 0,
        currentLineStart = void 0;

    for (var i = startLineNumber; i <= endLineNumber; i += 1) {
      currentLineStart = {
        line: i,
        ch: 0
      };

      line = doc.getLine(i);

      if (listManager.isListOrParagraph(line)) {
        if (isUlOrTask(line)) {
          listManager.replaceLineText(doc, i, /[*-] /, ordinalNumber + '. ');
        } else if (!line.match(FIND_MD_OL_RX)) {
          doc.replaceRange(ordinalNumber + '. ', currentLineStart);
        }

        ordinalNumber += 1;

        if (i === endLineNumber) {
          listManager.appendBlankLineIfNeed(cm, i, endLineNumber, startLineNumber);
        }
      } else {
        break;
      }
    }
    cm.focus();
  }
});

/**
 * Return whether passed line is UL or TASK or neither
 * @param {string} line Line text
 * @returns {boolean}
 */
function isUlOrTask(line) {
  return !!(line && (line.match(FIND_MD_TASK_RX) || line.match(FIND_MD_UL_RX)));
}

exports.default = OL;

/***/ }),
/* 119 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Indent
 * Add Indent markdown syntax to markdown editor
 * @extends Command
 * @module markdownCommands/inent
 * @ignore
 */
var Indent = _commandManager2.default.command('markdown', /** @lends Indent */{
  name: 'Indent',
  /**
   * Command handler
   * @param {MarkdownEditor} mde MarkdownEditor instance
   */
  exec: function exec(mde) {
    var cm = mde.getEditor();
    cm.execCommand('subListIndentTab');
  }
}); /**
     * @fileoverview Implements Indent markdown command
     * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
     */

exports.default = Indent;

/***/ }),
/* 120 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Outdent
 * Add Outdent markdown syntax to markdown editor
 * @extends Command
 * @module markdownCommands/outdent
 * @ignore
 */
var Outdent = _commandManager2.default.command('markdown', /** @lends Outdent */{
  name: 'Outdent',
  /**
   * Command handler
   * @param {MarkdownEditor} mde MarkdownEditor instance
   */
  exec: function exec(mde) {
    var cm = mde.getEditor();
    cm.execCommand('indentLessOrderedList');
  }
}); /**
     * @fileoverview Implements Outdent markdown command
     * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
     */

exports.default = Outdent;

/***/ }),
/* 121 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Table
 * Add table markdown syntax to markdown editor
 * @extends Command
 * @module markdownCommands/Table
 * @ignore
 */
var Table = _commandManager2.default.command('markdown', /** @lends Table */{
  name: 'Table',
  /**
   * Command handler
   * @param {MarkdownEditor} mde MarkdownEditor instance
   * @param {number} col column count
   * @param {number} row row count
   * @param {Array} data initial table data
   */
  exec: function exec(mde, col, row, data) {
    var cm = mde.getEditor();
    var doc = cm.getDoc();
    var table = '\n';

    if (cm.getCursor().ch > 0) {
      table += '\n';
    }

    table += makeHeader(col, data);
    table += makeBody(col, row - 1, data);

    doc.replaceSelection(table);

    if (!data) {
      cm.setCursor(cm.getCursor().line - row, 2);
    }

    mde.focus();
  }
});

/**
 * makeHeader
 * make table header markdown string
 * @param {number} col Column count
 * @param {array} data Cell's text content
 * @returns {string} markdown string
 */
/**
 * @fileoverview Implements Table markdown command
 * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */

function makeHeader(col, data) {
  var header = '|';
  var border = '|';
  var index = 0;

  while (col) {
    if (data) {
      header += ' ' + data[index] + ' |';
      index += 1;
    } else {
      header += '  |';
    }

    border += ' --- |';

    col -= 1;
  }

  return header + '\n' + border + '\n';
}

/**
 * makeBody
 * make table body markdown string
 * @param {number} col column count
 * @param {number} row row count
 * @param {Array} data initial table data
 * @returns {string} html string
 */
function makeBody(col, row, data) {
  var body = '';
  var index = col;

  for (var irow = 0; irow < row; irow += 1) {
    body += '|';

    for (var icol = 0; icol < col; icol += 1) {
      if (data) {
        body += ' ' + data[index] + ' |';
        index += 1;
      } else {
        body += '  |';
      }
    }

    body += '\n';
  }

  body = body.replace(/\n$/g, '');

  return body;
}
exports.default = Table;

/***/ }),
/* 122 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var FIND_MD_OL_RX = /^[ \t]*[\d]+\. .*/; /**
                                          * @fileoverview Implements Task markdown command
                                          * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
                                          */

var FIND_MD_UL_RX = /^[ \t]*[-*] .*/;
var FIND_MD_TASK_RX = /^[ \t]*[-*]( \[[ xX]])? .*/;
var FIND_TASK_SYNTAX_RX = /([*-] |[\d]+\. )(\[[ xX]] )/;

/**
 * Task
 * @extends Command
 * @module markdownCommands/Task
 * @ignore
 */
var Task = _commandManager2.default.command('markdown', /** @lends Task */{
  name: 'Task',
  keyMap: ['CTRL+T', 'META+T'],
  /**
   * Command handler
   * @param {MarkdownEditor} mde MarkdownEditor instance
   */
  exec: function exec(mde) {
    var cm = mde.getEditor();
    var doc = cm.getDoc();
    var range = mde.getCurrentRange();
    var listManager = mde.componentManager.getManager('list');
    var lineRange = listManager.createSortedLineRange(range);
    var startLineNumber = lineRange.start;
    var endLineNumber = lineRange.end;
    var line = void 0,
        currentLineStart = void 0;

    for (var i = startLineNumber; i <= endLineNumber; i += 1) {
      currentLineStart = {
        line: i,
        ch: 0
      };

      line = doc.getLine(i);

      var hasTaskSyntax = !!line.match(FIND_TASK_SYNTAX_RX);

      if (listManager.isListOrParagraph(line)) {
        if (isOlOrUl(line) && hasTaskSyntax) {
          listManager.replaceLineText(doc, i, FIND_TASK_SYNTAX_RX, '$1');
        } else if (isOlOrUl(line) && !hasTaskSyntax) {
          listManager.replaceLineText(doc, i, /([*-] |[\d]+\. )/, '$1[ ] ');
        } else if (!line.match(FIND_MD_TASK_RX)) {
          doc.replaceRange('* [ ] ', currentLineStart);
        }

        if (i === endLineNumber) {
          listManager.appendBlankLineIfNeed(cm, i, endLineNumber, startLineNumber);
        }
      } else {
        break;
      }
    }
    cm.focus();
  }
});

/**
 * Return whether passed line is OL or UL or neither
 * @param {string} line Line text
 * @returns {boolean}
 */
function isOlOrUl(line) {
  return !!(line && (line.match(FIND_MD_UL_RX) || line.match(FIND_MD_OL_RX)));
}

exports.default = Task;

/***/ }),
/* 123 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Code
 * Add code markdown syntax to markdown editor
 * @extends Command
 * @module markdownCommands/Code
 * @ignore
 */
var Code = _commandManager2.default.command('markdown', /** @lends Code */{
  name: 'Code',
  keyMap: ['SHIFT+CTRL+C', 'SHIFT+META+C'],
  /**
   * Command Handler
   * @param {MarkdownEditor} mde MarkdownEditor instance
   */
  exec: function exec(mde) {
    var cm = mde.getEditor();
    var doc = cm.getDoc();

    var selection = doc.getSelection();
    var range = cm.getCursor();

    doc.replaceSelection(this.append(selection), 'around');

    if (!selection) {
      doc.setCursor(range.line, range.ch + 1);
    }

    cm.focus();
  },

  /**
   * apply Code
   * @param {string} text - selected text
   * @returns {string} - text after code syntax applied
   */
  append: function append(text) {
    return '`' + text + '`';
  }
}); /**
    * @fileoverview Implements Code markdown command
    * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
    */
exports.default = Code;

/***/ }),
/* 124 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * CodeBlock
 * Add CodeBlock markdown syntax to markdown editor
 * @extends Command
 * @module markdownCommands/CodeBlock
 * @ignore
 */
var CodeBlock = _commandManager2.default.command('markdown', /** @lends CodeBlock */{
  name: 'CodeBlock',
  keyMap: ['SHIFT+CTRL+P', 'SHIFT+META+P'],
  /**
   * Command handler
   * @param {MarkdownEditor} mde MarkdownEditor instance
   */
  exec: function exec(mde) {
    var cm = mde.getEditor();
    var doc = cm.getDoc();
    var range = mde.getCurrentRange();
    var replaceText = ['```', doc.getSelection(), '```'];
    var cursorOffset = 1;
    // insert a line break to the front if the selection starts in the middle of a text
    if (range.from.ch !== 0) {
      replaceText.unshift('');
      cursorOffset += 1;
    }
    // insert a line break to the end if the selection has trailing text
    if (range.to.ch !== doc.getLine(range.to.line).length) {
      replaceText.push('');
    }
    doc.replaceSelection(replaceText.join('\n'));

    cm.setCursor(range.from.line + cursorOffset, 0);

    cm.focus();
  }
}); /**
     * @fileoverview Implements CodeBlock markdown command
     * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
     */
exports.default = CodeBlock;

/***/ }),
/* 125 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _commandManager = __webpack_require__(2);

var _commandManager2 = _interopRequireDefault(_commandManager);

var _domUtils = __webpack_require__(4);

var _domUtils2 = _interopRequireDefault(_domUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Bold
 * Add bold to selected wysiwyg editor content
 * @extends Command
 * @module wysiwygCommands/Bold
 * @ignore
 */
/**
 * @fileoverview Implements bold WysiwygCommand
 * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 */
var Bold = _commandManager2.default.command('wysiwyg', /** @lends Bold */{
  name: 'Bold',
  keyMap: ['CTRL+B', 'META+B'],
  /**
   * command handler
   * @param {WysiwygEditor} wwe wysiwygEditor instance
   */
  exec: function exec(wwe) {
    var sq = wwe.getEditor();
    var tableSelectionManager = wwe.componentManager.getManager('tableSelection');

    wwe.focus();

    if (sq.hasFormat('table') && tableSelectionManager.getSelectedCells().length) {
      tableSelectionManager.styleToSelectedCells(styleBold);
    } else {
      styleBold(sq);
    }

    var range = sq.getSelection();
    if (sq.hasFormat('table') && !_domUtils2.default.isTextNode(range.commonAncestorContainer)) {
      range.collapse(true);
      sq.setSelection(range);
    }
  }
});

/**
 * Style bold.
 * @param {object} sq - squire editor instance
 */
functi