# @turf/bearing

# bearing

Takes two [points](http://geojson.org/geojson-spec.html#point) and finds the geographic bearing between them.

**Parameters**

-   `start` **[Feature](http://geojson.org/geojson-spec.html#feature-objects)&lt;[Point](http://geojson.org/geojson-spec.html#point)>** starting Point
-   `end` **[Feature](http://geojson.org/geojson-spec.html#feature-objects)&lt;[Point](http://geojson.org/geojson-spec.html#point)>** ending Point

**Examples**

```javascript
var point1 = {
  "type": "Feature",
  "properties": {
    "marker-color": '#f00'
  },
  "geometry": {
    "type": "Point",
    "coordinates": [-75.343, 39.984]
  }
};
var point2 = {
  "type": "Feature",
  "properties": {
    "marker-color": '#0f0'
  },
  "geometry": {
    "type": "Point",
    "coordinates": [-75.534, 39.123]
  }
};

var points = {
  "type": "FeatureCollection",
  "features": [point1, point2]
};

//=points

var bearing = turf.bearing(point1, point2);

//=bearing
```

Returns **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** bearing in decimal degrees

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/bearing
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
