# @turf/intersect

# intersect

Takes two [polygons](http://geojson.org/geojson-spec.html#polygon) and finds their intersection. If they share a border, returns the border; if they don't intersect, returns undefined.

**Parameters**

-   `poly1` **[Feature](http://geojson.org/geojson-spec.html#feature-objects)&lt;[Polygon](http://geojson.org/geojson-spec.html#polygon)>** the first polygon
-   `poly2` **[Feature](http://geojson.org/geojson-spec.html#feature-objects)&lt;[Polygon](http://geojson.org/geojson-spec.html#polygon)>** the second polygon

**Examples**

```javascript
var poly1 = turf.polygon([[
  [-122.801742, 45.48565],
  [-122.801742, 45.60491],
  [-122.584762, 45.60491],
  [-122.584762, 45.48565],
  [-122.801742, 45.48565]
]]);

var poly2 = turf.polygon([[
  [-122.520217, 45.535693],
  [-122.64038, 45.553967],
  [-122.720031, 45.526554],
  [-122.669906, 45.507309],
  [-122.723464, 45.446643],
  [-122.532577, 45.408574],
  [-122.487258, 45.477466],
  [-122.520217, 45.535693]
]]);

var intersection = turf.intersect(poly1, poly2);

//=intersection
```

Returns **([Feature](http://geojson.org/geojson-spec.html#feature-objects) \| [undefined](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/undefined))** returns a feature representing the point(s) they share (in case of a [Point](http://geojson.org/geojson-spec.html#point)  or [MultiPoint](http://geojson.org/geojson-spec.html#multipoint)), the borders they share (in case of a [LineString](http://geojson.org/geojson-spec.html#linestring) or a [MultiLineString](http://geojson.org/geojson-spec.html#multilinestring)), the area they share (in case of [Polygon](http://geojson.org/geojson-spec.html#polygon) or [MultiPolygon](http://geojson.org/geojson-spec.html#multipolygon)). If they do not share any point, returns `undefined`.

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/intersect
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
