# @turf/tesselate

# tesselate

Tesselates a [Feature&lt;Polygon>](Feature<Polygon>) into a [FeatureCollection&lt;Polygon>](FeatureCollection<Polygon>) of triangles
using [earcut](https://github.com/mapbox/earcut).

**Parameters**

-   `poly` **[Feature](http://geojson.org/geojson-spec.html#feature-objects)&lt;[Polygon](http://geojson.org/geojson-spec.html#polygon)>** the polygon to tesselate

**Examples**

```javascript
var poly = turf.random('polygon').features[0];

var triangles = turf.tesselate(poly);

//=triangles
```

Returns **[FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects)&lt;[Polygon](http://geojson.org/geojson-spec.html#polygon)>** a geometrycollection feature

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/tesselate
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
