# @turf/center

# center

Takes a [Feature](http://geojson.org/geojson-spec.html#feature-objects) or [FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects) and returns the absolute center point of all features.

**Parameters**

-   `geojson` **[GeoJSON](http://geojson.org/geojson-spec.html#geojson-objects)** GeoJSON to be centered
-   `properties` **\[[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)]** an Object that is used as the [Feature](http://geojson.org/geojson-spec.html#feature-objects)'s properties

**Examples**

```javascript
var features = turf.featureCollection([
  turf.point( [-97.522259, 35.4691]),
  turf.point( [-97.502754, 35.463455]),
  turf.point( [-97.508269, 35.463245])
]);

var center = turf.center(features);

//addToMap
var addToMap = [features, center]
center.properties['marker-size'] = 'large';
center.properties['marker-color'] = '#000';
```

Returns **[Feature](http://geojson.org/geojson-spec.html#feature-objects)&lt;[Point](http://geojson.org/geojson-spec.html#point)>** a Point feature at the absolute center point of all input features

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/center
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
