# @turf/clone

# clone

Returns a cloned copy of the passed GeoJSON Object.
By default it duplicates only the standard GeoJSON fields of the object; if `cloneAll` is set to `true` all
fields of the Object, thus including 'Foreign Members', will be cloned (3-20x slower).

**Parameters**

-   `geojson` **[GeoJSON](http://geojson.org/geojson-spec.html#geojson-objects)** GeoJSON Object
-   `cloneAll` **\[[Boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)]** clones entire GeoJSON object, using JSON.parse(JSON.stringify(geojson)) (optional, default `false`)

**Examples**

```javascript
var line = turf.lineString([[-74, 40], [-78, 42], [-82, 35]]);

var lineCloned = turf.clone(line);
```

Returns **[GeoJSON](http://geojson.org/geojson-spec.html#geojson-objects)** cloned GeoJSON Object

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/clone
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
