# @turf/clusters-kmeans

# clustersKmeans

Takes a set of [points](http://geojson.org/geojson-spec.html#point) and partition them into clusters using the k-mean .
It uses the [k-means algorithm](https://en.wikipedia.org/wiki/K-means_clustering)

**Parameters**

-   `points` **[FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects)&lt;[Point](http://geojson.org/geojson-spec.html#point)>** to be clustered
-   `numberOfClusters` **\[[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)]** numberOfClusters that will be generated (optional, default `Math.sqrt(numberOfPoints/2)`)
-   `mutate` **\[[boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)]** allows GeoJSON input to be mutated (significant performance increase if true) (optional, default `false`)

**Examples**

```javascript
// create random points with random z-values in their properties
var points = turf.random('point', 100, {
  bbox: [0, 30, 20, 50]
});
var numberOfClusters = 7;
var clustered = turf.clustersKmeans(points, numberOfClusters);

//addToMap
var addToMap = [clustered];
```

Returns **[FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects)&lt;[Point](http://geojson.org/geojson-spec.html#point)>** Clustered Points with an additional two properties associated to each Feature:-   {number} cluster - the associated clusterId
-   {[number, number]} centroid - Centroid of the cluster [Longitude, Latitude]

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/clusters-kmeans
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
