# @turf/explode

# explode

Takes a feature or set of features and returns all positions as [points](http://geojson.org/geojson-spec.html#point).

**Parameters**

-   `geojson` **([FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects) \| [Feature](http://geojson.org/geojson-spec.html#feature-objects)&lt;any>)** input features

**Examples**

```javascript
var polygon = turf.polygon([[[-81, 41], [-88, 36], [-84, 31], [-80, 33], [-77, 39], [-81, 41]]]);

var explode = turf.explode(polygon);

//addToMap
var addToMap = [polygon, explode]
```

-   Throws **[Error](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error)** if it encounters an unknown geometry type

Returns **[FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects)&lt;point>** points representing the exploded input features

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/explode
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
