# @turf/idw

# idw

Takes a FeatureCollection of points with known value, a power parameter, a cell depth, a unit of measurement
and returns a FeatureCollection of polygons in a square-grid with an interpolated value property "IDW" for each grid cell.
It finds application when in need of creating a continuous surface (i.e. rainfall, temperature, chemical dispersion surface...)
from a set of spatially scattered points.

**Parameters**

-   `controlPoints` **[FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects)&lt;[Point](http://geojson.org/geojson-spec.html#point)>** Sampled points with known value
-   `valueField` **[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** GeoJSON field containing the known value to interpolate on
-   `weight` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** Exponent regulating the distance-decay weighting
-   `cellWidth` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** The distance across each cell
-   `units` **\[[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)]** used in calculating cellSize, can be degrees, radians, miles, or kilometers (optional, default `kilometers`)

Returns **[FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects)&lt;[Polygon](http://geojson.org/geojson-spec.html#polygon)>** grid A grid of polygons with a property field named as `valueField`

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/idw
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
