# @turf/isobands

# isobands

Takes a grid [FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects) of [Point](http://geojson.org/geojson-spec.html#point) features with z-values and an array of
value breaks and generates filled contour isobands.

**Parameters**

-   `pointGrid` **[FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects)&lt;[Point](http://geojson.org/geojson-spec.html#point)>** input points
-   `breaks` **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)>** where to draw contours
-   `zProperty` **\[[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)]** the property name in `points` from which z-values will be pulled (optional, default `'elevation'`)
-   `options` **\[[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)]** options on output (optional, default `{}`)
    -   `options.isobandProperties` **\[[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)>]** GeoJSON properties passed, in order, to the correspondent isoband (order defined by breaks) (optional, default `[]`)
    -   `options.commonProperties` **\[[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)]** GeoJSON properties passed to ALL isobands (optional, default `{}`)

**Examples**

```javascript
// create a grid of points with random z-values in their properties
var extent = [-70.823364, -33.553984, -69.823364, -32.553984];
var cellWidth = 5;
var units = 'miles';
var pointGrid = turf.pointGrid(extent, cellWidth, units);
for (var i = 0; i < pointGrid.features.length; i++) {
    pointGrid.features[i].properties.elevation = Math.random() * 10;
}
var breaks = [0, 5, 8.5];

var isobands = turf.isobands(pointGrid, breaks);

//addToMap
var addToMap = [isobands];
```

Returns **[FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects)&lt;[MultiPolygon](http://geojson.org/geojson-spec.html#multipolygon)>** a FeatureCollection of [MultiPolygon](http://geojson.org/geojson-spec.html#multipolygon) features representing isobands

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/isobands
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
