# @turf/isolines

# isolines

Takes a grid [FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects) of [Point](http://geojson.org/geojson-spec.html#point) features with z-values and an array of
value breaks and generates [isolines](http://en.wikipedia.org/wiki/Isoline).

**Parameters**

-   `pointGrid` **[FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects)&lt;[Point](http://geojson.org/geojson-spec.html#point)>** input points
-   `breaks` **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)>** values of `zProperty` where to draw isolines
-   `zProperty` **\[[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)]** the property name in `points` from which z-values will be pulled (optional, default `'elevation'`)
-   `propertiesToAllIsolines` **\[[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)]** GeoJSON properties passed to ALL isolines (optional, default `{}`)
-   `propertiesPerIsoline` **\[[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)>]** GeoJSON properties passed, in order, to the correspondent isoline;
    the breaks array will define the order in which the isolines are created (optional, default `[]`)

**Examples**

```javascript
// create a grid of points with random z-values in their properties
var extent = [0, 30, 20, 50];
var cellWidth = 100;
var units = 'miles';
var pointGrid = turf.pointGrid(extent, cellWidth, units);
for (var i = 0; i < pointGrid.features.length; i++) {
    pointGrid.features[i].properties.temperature = Math.random() * 10;
}
var breaks = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10];

var isolines = turf.isolines(pointGrid, breaks, 'temperature');

//addToMap
var addToMap = [isolines];
```

Returns **[FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects)&lt;[MultiLineString](http://geojson.org/geojson-spec.html#multilinestring)>** a FeatureCollection of [MultiLineString](http://geojson.org/geojson-spec.html#multilinestring) features representing isolines

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/isolines
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
