# @turf/line-offset

# lineOffset

Takes a [line](http://geojson.org/geojson-spec.html#linestring) and returns a [line](http://geojson.org/geojson-spec.html#linestring) at offset by the specified distance.

**Parameters**

-   `geojson` **([Geometry](http://geojson.org/geojson-spec.html#geometry) \| [Feature](http://geojson.org/geojson-spec.html#feature-objects)&lt;([LineString](http://geojson.org/geojson-spec.html#linestring) \| [MultiLineString](http://geojson.org/geojson-spec.html#multilinestring))>)** input GeoJSON
-   `distance` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** distance to offset the line (can be of negative value)
-   `units` **\[[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)]** can be degrees, radians, miles, kilometers, inches, yards, meters (optional, default `kilometers`)

**Examples**

```javascript
var line = turf.lineString([[-83, 30], [-84, 36], [-78, 41]], { "stroke": "#F00" });

var offsetLine = turf.lineOffset(line, 2, "miles");

//addToMap
var addToMap = [offsetLine, line]
offsetLine.properties.stroke = "#00F"
```

Returns **[Feature](http://geojson.org/geojson-spec.html#feature-objects)&lt;([LineString](http://geojson.org/geojson-spec.html#linestring) \| [MultiLineString](http://geojson.org/geojson-spec.html#multilinestring))>** Line offset from the input line

# ab

<https://github.com/rook2pawn/node-intersection>

Author @rook2pawn

**Parameters**

-   `segment`  

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/line-offset
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
