# @turf/linestring-to-polygon

# lineStringToPolygon

Converts (Multi)LineString(s) to Polygon(s).

**Parameters**

-   `lines` **([FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects) \| [Feature](http://geojson.org/geojson-spec.html#feature-objects)&lt;([LineString](http://geojson.org/geojson-spec.html#linestring) \| [MultiLineString](http://geojson.org/geojson-spec.html#multilinestring))>)** Features to convert
-   `properties` **\[[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)]** translates GeoJSON properties to Feature
-   `autoComplete` **\[[boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)]** auto complete linestrings (matches first & last coordinates) (optional, default `true`)
-   `orderCoords` **\[[boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)]** sorts linestrings to place outer ring at the first position of the coordinates (optional, default `true`)

**Examples**

```javascript
var line = turf.lineString([[125, -30], [145, -30], [145, -20], [125, -20], [125, -30]]);

var polygon = turf.lineStringToPolygon(line);

//addToMap
var addToMap = [polygon];
```

Returns **[Feature](http://geojson.org/geojson-spec.html#feature-objects)&lt;([Polygon](http://geojson.org/geojson-spec.html#polygon) \| [MultiPolygon](http://geojson.org/geojson-spec.html#multipolygon))>** converted to Polygons

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/linestring-to-polygon
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
