# @turf/point-grid

# pointGrid

Creates a [Point](http://geojson.org/geojson-spec.html#point) grid from a bounding box, [FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects) or [Feature](http://geojson.org/geojson-spec.html#feature-objects).

**Parameters**

-   `bbox` **([Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)> | [FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects) \| [Feature](http://geojson.org/geojson-spec.html#feature-objects)&lt;any>)** extent in [minX, minY, maxX, maxY] order
-   `cellSide` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** the distance between points
-   `units` **\[[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)]** used in calculating cellSide, can be degrees, radians, miles, or kilometers (optional, default `kilometers`)
-   `centered` **\[[boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)]** adjust points position to center the grid into bbox. **This parameter is going to be removed** in the next major release, having the output always centered into bbox. (optional, default `true`)
-   `bboxIsMask` **\[[boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)]** if true, and bbox is a Polygon or MultiPolygon, the grid Point will be created
    only if inside the bbox Polygon(s) (optional, default `false`)

**Examples**

```javascript
var extent = [-70.823364, -33.553984, -70.473175, -33.302986];
var cellSide = 3;
var units = 'miles';

var grid = turf.pointGrid(extent, cellSide, units);

//addToMap
var addToMap = [grid];
```

Returns **[FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects)&lt;[Point](http://geojson.org/geojson-spec.html#point)>** grid of points

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/point-grid
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
