# @turf/point-on-surface

# pointOnSurface

Takes a feature and returns a [Point](http://geojson.org/geojson-spec.html#point) guaranteed to be on the surface of the feature.

-   Given a [Polygon](http://geojson.org/geojson-spec.html#polygon), the point will be in the area of the polygon
-   Given a [LineString](http://geojson.org/geojson-spec.html#linestring), the point will be along the string
-   Given a [Point](http://geojson.org/geojson-spec.html#point), the point will the same as the input

**Parameters**

-   `fc` **([Feature](http://geojson.org/geojson-spec.html#feature-objects) \| [FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects))** any feature or set of features

**Examples**

```javascript
// create a random polygon
var polygon = turf.random('polygon');

var pointOnPolygon = turf.pointOnSurface(polygon);

//addToMap
var addToMap = [polygon, pointOnPolygon];
```

Returns **[Feature](http://geojson.org/geojson-spec.html#feature-objects)** a point on the surface of `input`

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/point-on-surface
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
