# @turf/sample

# sample

Takes a [FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects) and returns a FeatureCollection with given number of [features](http://geojson.org/geojson-spec.html#feature-objects) at random.

**Parameters**

-   `featurecollection` **[FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects)** set of input features
-   `num` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** number of features to select

**Examples**

```javascript
var points = turf.random('points', 100, {
  bbox: [-80, 30, -60, 60]
});

var sample = turf.sample(points, 5);

//addToMap
var addToMap = [points, sample]
turf.featureEach(sample, function (currentFeature) {
  currentFeature.properties['marker-size'] = 'large';
  currentFeature.properties['marker-color'] = '#000';
});
```

Returns **[FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects)** a FeatureCollection with `n` features

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/sample
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
