# @turf/transform-rotate

# transformRotate

Rotates any geojson Feature or Geometry of a specified angle, around its `centroid` or a given `pivot` point;
all rotations follow the right-hand rule: <https://en.wikipedia.org/wiki/Right-hand_rule>

**Parameters**

-   `geojson` **[GeoJSON](http://geojson.org/geojson-spec.html#geojson-objects)** object to be rotated
-   `angle` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** of rotation (along the vertical axis), from North in decimal degrees, negative clockwise
-   `pivot` **\[([Geometry](http://geojson.org/geojson-spec.html#geometry) \| [Feature](http://geojson.org/geojson-spec.html#feature-objects)&lt;[Point](http://geojson.org/geojson-spec.html#point)> | [Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)>)]** point around which the rotation will be performed (optional, default `` `centroid` ``)
-   `mutate` **\[[boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)]** allows GeoJSON input to be mutated (significant performance increase if true) (optional, default `false`)

**Examples**

```javascript
var poly = turf.polygon([[[0,29],[3.5,29],[2.5,32],[0,29]]]);
var rotatedPoly = turf.transformRotate(poly, 10, [0, 25]);

//addToMap
var addToMap = [poly, rotatedPoly];
rotatedPoly.properties = {stroke: '#F00', 'stroke-width': 4};
```

Returns **[GeoJSON](http://geojson.org/geojson-spec.html#geojson-objects)** the rotated GeoJSON feature

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/transform-rotate
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
