# New minor release! Turf 4.5.2 🎉

TurfJS releases are being tracked using [Milestones](https://github.com/Turfjs/turf/milestone/9?closed=1).

## Contributors

- @wnordmann
- @rowanwins
- @stebogit
- @mcdeurloo
- @NickCis
- @dpmcmlxxvi
- @morganherlocker 
- @DenisCarriere

## 🚀 New Modules

- [`@turf/clusters`](https://github.com/Turfjs/turf/tree/master/packages/turf-clusters) Takes a set of points and partition them into clusters using the [k-means clustering](https://en.wikipedia.org/wiki/K-means_clustering) algorithm.
(PR https://github.com/Turfjs/turf/pull/787 - Author @stebogit )

- [`@turf/boolean-disjoint`](https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-disjoint) Boolean-disjoint returns (TRUE) if the intersection of the two geometries is an empty set.
(PR https://github.com/Turfjs/turf/pull/805 - Author @rowanwins)

- [`@turf/boolean-contains`](https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-contains) Boolean-contains returns True if the second geometry is completely contained by the first geometry. The interiors of both geometries must intersect and, the interior and boundary of the secondary (geometry b) must not intersect the exterior of the primary (geometry a). Boolean-contains returns the exact opposite result of the `@turf/boolean-within`.
(PR https://github.com/Turfjs/turf/pull/797 - Author @rowanwins)

- [`@turf/boolean-crosses`](https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-crosses) Boolean-Crosses returns True if the intersection results in a geometry whose dimension is one less than the maximum dimension of the two source geometries and the intersection set is interior to both source geometries.
Boolean-Crosses returns t (TRUE) for only multipoint/polygon, multipoint/linestring, linestring/linestring, linestring/polygon, and linestring/multipolygon comparisons.
(PR https://github.com/Turfjs/turf/pull/796 - Author @rowanwins)

- [`@turf/boolean-clockwise`](https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-clockwise) Takes a ring and return true or false whether or not the ring is clockwise or counter-clockwise.
(PR https://github.com/Turfjs/turf/pull/789 - Authors @morganherlocker @stebogit)

- [`@turf/clone`](https://github.com/Turfjs/turf/tree/master/packages/turf-clone) Prevents GeoJSON coordinates from being mutated, similar to `JSON.parse(JSON.stringify(geojson))`.
Only cloning the coordinates can be 3x-20x faster than the **parse + stringify** approach.
(PR https://github.com/Turfjs/turf/pull/824 - Author @DenisCarriere)

## 🏅 New Features/Enhancements

- [`convertArea`](https://github.com/Turfjs/turf/tree/master/packages/turf-helpers#convertarea) Converts a area to the requested unit. (PR https://github.com/Turfjs/turf/pull/821 - Author @wnordmann)
- Adds mask option to `@turf/point-grid` (PR https://github.com/Turfjs/turf/pull/791)
- New @turf/isolines based on MarchingSquares.js (PR https://github.com/Turfjs/turf/pull/781)
- Use ES6 modules / Add module.js to @turf/turf (PR https://github.com/Turfjs/turf/pull/793)
- Create-new-module script (PR https://github.com/Turfjs/turf/pull/823)

## 🐛 Bug Fixes

- Buffer - Drop circle buffer operation (PR https://github.com/Turfjs/turf/pull/786)
- Fixes `@turf/idw` bad property name #774  (PR https://github.com/Turfjs/turf/pull/800)
- Fix for @turf/polygon-tangents - Resolves #785 (PR https://github.com/Turfjs/turf/pull/792)

Twitter: https://twitter.com/DenisCarriere/status/880839653242408961
CC: @Turfjs/ownership 
Ref: https://github.com/Turfjs/turf/issues/825
