# @turf/combine

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## combine

Combines a [FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3) of [Point](https://tools.ietf.org/html/rfc7946#section-3.1.2), [LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4), or [Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6) features
into [MultiPoint](https://tools.ietf.org/html/rfc7946#section-3.1.3), [MultiLineString](https://tools.ietf.org/html/rfc7946#section-3.1.5), or [MultiPolygon](https://tools.ietf.org/html/rfc7946#section-3.1.7) features.

**Parameters**

-   `fc` **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;([Point](https://tools.ietf.org/html/rfc7946#section-3.1.2) \| [LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4) \| [Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6))>** a FeatureCollection of any type

**Examples**

```javascript
var fc = turf.featureCollection([
  turf.point([19.026432, 47.49134]),
  turf.point([19.074497, 47.509548])
]);

var combined = turf.combine(fc);

//addToMap
var addToMap = [combined]
```

Returns **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;([MultiPoint](https://tools.ietf.org/html/rfc7946#section-3.1.3) \| [MultiLineString](https://tools.ietf.org/html/rfc7946#section-3.1.5) \| [MultiPolygon](https://tools.ietf.org/html/rfc7946#section-3.1.7))>** a FeatureCollection of corresponding type to input

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/combine
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
