# @turf/great-circle

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## greatCircle

Calculate great circles routes as [LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4)

**Parameters**

-   `start` **[Coord](https://tools.ietf.org/html/rfc7946#section-3.1.1)** source point feature
-   `end` **[Coord](https://tools.ietf.org/html/rfc7946#section-3.1.1)** destination point feature
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** Optional parameters (optional, default `{}`)
    -   `options.properties` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** line feature properties (optional, default `{}`)
    -   `options.npoints` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** number of points (optional, default `100`)
    -   `options.offset` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** offset controls the likelyhood that lines will
        be split which cross the dateline. The higher the number the more likely. (optional, default `10`)

**Examples**

```javascript
var start = turf.point([-122, 48]);
var end = turf.point([-77, 39]);

var greatCircle = turf.greatCircle(start, end, {'name': 'Seattle to DC'});

//addToMap
var addToMap = [start, end, greatCircle]
```

Returns **[Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;[LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4)>** great circle line feature

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/great-circle
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
