# @turf/hex-grid

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## hexGrid

Takes a bounding box and the diameter of the cell and returns a [FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3) of flat-topped
hexagons or triangles ([Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6) features) aligned in an "odd-q" vertical grid as
described in [Hexagonal Grids](http://www.redblobgames.com/grids/hexagons/).

**Parameters**

-   `bbox` **[BBox](https://tools.ietf.org/html/rfc7946#section-5)** extent in [minX, minY, maxX, maxY] order
-   `cellSide` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** length of the side of the the hexagons or triangles, in units. It will also coincide with the
    radius of the circumcircle of the hexagons.
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** Optional parameters (optional, default `{}`)
    -   `options.units` **[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** used in calculating cell size, can be degrees, radians, miles, or kilometers (optional, default `'kilometers'`)
    -   `options.properties` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** passed to each hexagon or triangle of the grid (optional, default `{}`)
    -   `options.mask` **[Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;([Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6) \| [MultiPolygon](https://tools.ietf.org/html/rfc7946#section-3.1.7))>?** if passed a Polygon or MultiPolygon, the grid Points will be created only inside it
    -   `options.triangles` **[boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** whether to return as triangles instead of hexagons (optional, default `false`)

**Examples**

```javascript
var bbox = [-96,31,-84,40];
var cellSide = 50;
var options = {units: 'miles'};

var hexgrid = turf.hexGrid(bbox, cellSide, options);

//addToMap
var addToMap = [hexgrid];
```

Returns **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6)>** a hexagonal grid

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/hex-grid
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
