# @turf/line-split

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## lineSplit

Split a LineString by another GeoJSON Feature.

**Parameters**

-   `line` **[Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;[LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4)>** LineString Feature to split
-   `splitter` **[Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;any>** Feature used to split line

**Examples**

```javascript
var line = turf.lineString([[120, -25], [145, -25]]);
var splitter = turf.lineString([[130, -15], [130, -35]]);

var split = turf.lineSplit(line, splitter);

//addToMap
var addToMap = [line, splitter]
```

Returns **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4)>** Split LineStrings

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/line-split
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
