# @turf/points-within-polygon

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## pointsWithinPolygon

Finds [Points](https://tools.ietf.org/html/rfc7946#section-3.1.2) that fall within [(Multi)Polygon(s)](https://tools.ietf.org/html/rfc7946#section-3.1.6).

**Parameters**

-   `points` **(Feauture | [FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[Point](https://tools.ietf.org/html/rfc7946#section-3.1.2)>)** Points as input search
-   `polygons` **([FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3) | Geoemtry | [Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;([Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6) \| [MultiPolygon](https://tools.ietf.org/html/rfc7946#section-3.1.7))>)** Points must be within these (Multi)Polygon(s)

**Examples**

```javascript
var points = turf.points([
    [-46.6318, -23.5523],
    [-46.6246, -23.5325],
    [-46.6062, -23.5513],
    [-46.663, -23.554],
    [-46.643, -23.557]
]);

var searchWithin = turf.polygon([[
    [-46.653,-23.543],
    [-46.634,-23.5346],
    [-46.613,-23.543],
    [-46.614,-23.559],
    [-46.631,-23.567],
    [-46.653,-23.560],
    [-46.653,-23.543]
]]);

var ptsWithin = turf.pointsWithinPolygon(points, searchWithin);

//addToMap
var addToMap = [points, searchWithin, ptsWithin]
turf.featureEach(ptsWithin, function (currentFeature) {
  currentFeature.properties['marker-size'] = 'large';
  currentFeature.properties['marker-color'] = '#000';
});
```

Returns **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[Point](https://tools.ietf.org/html/rfc7946#section-3.1.2)>** points that land within at least one polygon

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/points-within-polygon
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
