# @turf/projection

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## toMercator

Converts a WGS84 GeoJSON object into Mercator (EPSG:900913) projection

**Parameters**

-   `geojson` **([GeoJSON](https://tools.ietf.org/html/rfc7946#section-3) | Position)** WGS84 GeoJSON object
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)?** Optional parameters
    -   `options.mutate` **[boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** allows GeoJSON input to be mutated (significant performance increase if true) (optional, default `false`)

**Examples**

```javascript
var pt = turf.point([-71,41]);
var converted = turf.toMercator(pt);

//addToMap
var addToMap = [pt, converted];
```

Returns **[GeoJSON](https://tools.ietf.org/html/rfc7946#section-3)** true/false

## toWgs84

Converts a Mercator (EPSG:900913) GeoJSON object into WGS84 projection

**Parameters**

-   `geojson` **([GeoJSON](https://tools.ietf.org/html/rfc7946#section-3) | Position)** Mercator GeoJSON object
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)?** Optional parameters
    -   `options.mutate` **[boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** allows GeoJSON input to be mutated (significant performance increase if true) (optional, default `false`)

**Examples**

```javascript
var pt = turf.point([-7903683.846322424, 5012341.663847514]);
var converted = turf.toWgs84(pt);

//addToMap
var addToMap = [pt, converted];
```

Returns **[GeoJSON](https://tools.ietf.org/html/rfc7946#section-3)** true/false

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/projection
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
