# @turf/tin

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## tin

Takes a set of [points](https://tools.ietf.org/html/rfc7946#section-3.1.2) and creates a
[Triangulated Irregular Network](http://en.wikipedia.org/wiki/Triangulated_irregular_network),
or a TIN for short, returned as a collection of Polygons. These are often used
for developing elevation contour maps or stepped heat visualizations.

If an optional z-value property is provided then it is added as properties called `a`, `b`,
and `c` representing its value at each of the points that represent the corners of the
triangle.

**Parameters**

-   `points` **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[Point](https://tools.ietf.org/html/rfc7946#section-3.1.2)>** input points
-   `z` **[String](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)?** name of the property from which to pull z values
    This is optional: if not given, then there will be no extra data added to the derived triangles.

**Examples**

```javascript
// generate some random point data
var points = turf.randomPoint(30, {bbox: [50, 30, 70, 50]});

// add a random property to each point between 0 and 9
for (var i = 0; i < points.features.length; i++) {
  points.features[i].properties.z = ~~(Math.random() * 9);
}
var tin = turf.tin(points, 'z');

//addToMap
var addToMap = [tin, points]
for (var i = 0; i < tin.features.length; i++) {
  var properties  = tin.features[i].properties;
  properties.fill = '#' + properties.a + properties.b + properties.c;
}
```

Returns **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6)>** TIN output

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/tin
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
