# @turf/directional-mean

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## DirectionalMeanLine

Type: [Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)

**Properties**

-   `cartesianAngle` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** the mean angle of all lines. (measure from due earth counterclockwise).
-   `bearingAngle` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** the mean angle of all lines. (bearing).
-   `circularVariance` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** the extent to which features all point in the same direction.
     the value ranges 0-1, the bigger the value, the more variation in directions between lines.
-   `averageX` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** the centroid of all lines.
-   `averageY` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** the centroid of all line.
-   `averageLength` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** the average length of line.
-   `countOfLines` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** the count of features.

## directionalMean

This module calculate the average angle of a set of lines, measuring the trend of it.
It can be used in both project coordinate system and geography coordinate system.
It can handle segments of line or the whole line.

**Parameters**

-   `lines` **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4)>** 
-   `options` **[object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)**  (optional, default `{}`)
    -   `options.planar` **[boolean](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** whether the spatial reference system is projected or geographical. (optional, default `true`)
    -   `options.segment` **[boolean](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** whether treat a LineString as a whole or a set of segments. (optional, default `false`)

**Examples**

```javascript
var lines = turf.lineStrings([
  [[110, 45], [120, 50]],
  [[100, 50], [115, 55]],
])
var directionalMeanLine = turf.directionalMean(lines);
// => directionalMeanLine
```

Returns **[DirectionalMeanLine](#directionalmeanline)** Directional Mean Line

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/directional-mean
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
