# @turf/quadrat-analysis

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## quadratAnalysis

Quadrat analysis lays a set of equal-size areas(quadrat) over the study area and counts 
the number of features in each quadrat and creates a frequency table.
The table lists the number of quadrats containing no features, the number containing one feature, two features, and so on,
all the way up to the quadrat containing the most features.
The method then creates the frequency table for the random distribution, usually based on a Poisson distribution.
The method uses the distribution to calculate the probability for 0 feature occuring, 1 feature occuring, 2 features, and so on,
and lists these probabilities in the frequency table.
By comparing the two frequency tables, you can see whether the features create a pattern.
If the table for the observed distribution has more quadrats containing many features than the table for the random distribution dose,
then the features create a clustered pattern.

It is hard to judge the frequency tables are similar or different just by looking at them.
So, we can use serval statistical tests to find out how much the frequency tables differ.
We use Kolmogorov-Smirnov test.This method calculates cumulative probabilities for both distributions, 
and then compares the cumulative probabilities at each class level and selects the largest absolute difference D.
Then, the test compares D to the critical value for a confidence level you specify.
If D is greater than the critical value, the difference between  the observed distribution and the random distribution is significant.
The greater the value the bigger the difference.

Traditionally, squares are used for the shape of the quadrats, in a regular grid(square-grid).
Some researchers suggest that the quadrat size equal twice the size of mean area per feature, 
which is simply the area of the study area divided by the number of features.

**Parameters**

-   `pointFeatureSet` **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[Point](https://tools.ietf.org/html/rfc7946#section-3.1.2)>** point set to study
-   `options` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** optional parameters (optional, default `{}`)
    -   `options.studyBbox` **bbox?** bbox representing the study area
    -   `options.confidenceLevel` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** a confidence level .The unit is percentage . 5 means 95% ,value must be in [K_TABLE](#k_table) (optional, default `20`)

**Examples**

```javascript
var bbox = [-65, 40, -63, 42];
var dataset = turf.randomPoint(100, { bbox: bbox });
var result = turf.quadratAnalysis(dataset);
```

Returns **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** result [QuadratAnalysisResult](#quadratanalysisresult)

## K_TABLE

the confidence level

**Properties**

-   `20` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** 
-   `15` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** 
-   `10` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** 
-   `5` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** 
-   `2` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** 
-   `1` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** 

## QuadratAnalysisResult

the return type of the quadratAnalysis

Type: [Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)

**Properties**

-   `criticalValue` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** 
-   `maxAbsoluteDifference` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** 
-   `isRandom` **[boolean](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** 
-   `observedDistribution` **[Array](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)>** the cumulative distribution of observed features, the index represents the number of features in the quadrat.

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/quadrat-analysis
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
