# @turf/rhumb-distance

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## rhumbDistance

Calculates the distance along a rhumb line between two [points][1] in degrees, radians,
miles, or kilometers.

**Parameters**

-   `from` **[Coord][2]** origin point
-   `to` **[Coord][2]** destination point
-   `options` **[Object][3]?** Optional parameters
    -   `options.units` **[string][4]** can be degrees, radians, miles, or kilometers (optional, default `"kilometers"`)

**Examples**

```javascript
var from = turf.point([-75.343, 39.984]);
var to = turf.point([-75.534, 39.123]);
var options = {units: 'miles'};

var distance = turf.rhumbDistance(from, to, options);

//addToMap
var addToMap = [from, to];
from.properties.distance = distance;
to.properties.distance = distance;
```

Returns **[number][5]** distance between the two points

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.1

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/rhumb-distance
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
