# @turf/tag

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## tag

Takes a set of [points][1] and a set of [polygons][2] and performs a spatial join.

**Parameters**

-   `points` **[FeatureCollection][3]&lt;[Point][4]>** input points
-   `polygons` **[FeatureCollection][3]&lt;[Polygon][5]>** input polygons
-   `field` **[string][6]** property in `polygons` to add to joined {<Point>} features
-   `outField` **[string][6]** property in `points` in which to store joined property from `polygons`

**Examples**

```javascript
var pt1 = turf.point([-77, 44]);
var pt2 = turf.point([-77, 38]);
var poly1 = turf.polygon([[
  [-81, 41],
  [-81, 47],
  [-72, 47],
  [-72, 41],
  [-81, 41]
]], {pop: 3000});
var poly2 = turf.polygon([[
  [-81, 35],
  [-81, 41],
  [-72, 41],
  [-72, 35],
  [-81, 35]
]], {pop: 1000});

var points = turf.featureCollection([pt1, pt2]);
var polygons = turf.featureCollection([poly1, poly2]);

var tagged = turf.tag(points, polygons, 'pop', 'population');

//addToMap
var addToMap = [tagged, polygons]
```

Returns **[FeatureCollection][3]&lt;[Point][4]>** points with `containingPolyId` property containing values from `polyId`

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[3]: https://tools.ietf.org/html/rfc7946#section-3.3

[4]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[5]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/tag
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
