import test from "tape";
import tesselate from "./index";
import { featureCollection as featurecollection } from "@turf/helpers";
import { point } from "@turf/helpers";

test("tesselate", function (t) {
  var polygon = {
    type: "Feature",
    id: "USA-CA",
    properties: { fips: "06", name: "California" },
    geometry: {
      type: "Polygon",
      coordinates: [
        [
          [-123.233256, 42.006186],
          [-122.378853, 42.011663],
          [-121.037003, 41.995232],
          [-120.001861, 41.995232],
          [-119.996384, 40.264519],
          [-120.001861, 38.999346],
          [-118.71478, 38.101128],
          [-117.498899, 37.21934],
          [-116.540435, 36.501861],
          [-115.85034, 35.970598],
          [-114.634459, 35.00118],
          [-114.634459, 34.87521],
          [-114.470151, 34.710902],
          [-114.333228, 34.448009],
          [-114.136058, 34.305608],
          [-114.256551, 34.174162],
          [-114.415382, 34.108438],
          [-114.535874, 33.933176],
          [-114.497536, 33.697668],
          [-114.524921, 33.54979],
          [-114.727567, 33.40739],
          [-114.661844, 33.034958],
          [-114.524921, 33.029481],
          [-114.470151, 32.843265],
          [-114.524921, 32.755634],
          [-114.72209, 32.717295],
          [-116.04751, 32.624187],
          [-117.126467, 32.536556],
          [-117.24696, 32.668003],
          [-117.252437, 32.876127],
          [-117.329114, 33.122589],
          [-117.471515, 33.297851],
          [-117.7837, 33.538836],
          [-118.183517, 33.763391],
          [-118.260194, 33.703145],
          [-118.413548, 33.741483],
          [-118.391641, 33.840068],
          [-118.566903, 34.042715],
          [-118.802411, 33.998899],
          [-119.218659, 34.146777],
          [-119.278905, 34.26727],
          [-119.558229, 34.415147],
          [-119.875891, 34.40967],
          [-120.138784, 34.475393],
          [-120.472878, 34.448009],
          [-120.64814, 34.579455],
          [-120.609801, 34.858779],
          [-120.670048, 34.902595],
          [-120.631709, 35.099764],
          [-120.894602, 35.247642],
          [-120.905556, 35.450289],
          [-121.004141, 35.461243],
          [-121.168449, 35.636505],
          [-121.283465, 35.674843],
          [-121.332757, 35.784382],
          [-121.716143, 36.195153],
          [-121.896882, 36.315645],
          [-121.935221, 36.638785],
          [-121.858544, 36.6114],
          [-121.787344, 36.803093],
          [-121.929744, 36.978355],
          [-122.105006, 36.956447],
          [-122.335038, 37.115279],
          [-122.417192, 37.241248],
          [-122.400761, 37.361741],
          [-122.515777, 37.520572],
          [-122.515777, 37.783465],
          [-122.329561, 37.783465],
          [-122.406238, 38.15042],
          [-122.488392, 38.112082],
          [-122.504823, 37.931343],
          [-122.701993, 37.893004],
          [-122.937501, 38.029928],
          [-122.97584, 38.265436],
          [-123.129194, 38.451652],
          [-123.331841, 38.566668],
          [-123.44138, 38.698114],
          [-123.737134, 38.95553],
          [-123.687842, 39.032208],
          [-123.824765, 39.366301],
          [-123.764519, 39.552517],
          [-123.85215, 39.831841],
          [-124.109566, 40.105688],
          [-124.361506, 40.259042],
          [-124.410798, 40.439781],
          [-124.158859, 40.877937],
          [-124.109566, 41.025814],
          [-124.158859, 41.14083],
          [-124.065751, 41.442061],
          [-124.147905, 41.715908],
          [-124.257444, 41.781632],
          [-124.213628, 42.000709],
          [-123.233256, 42.006186],
        ],
      ],
    },
  };

  var triangles = tesselate(polygon);

  t.equal(
    triangles.type,
    "FeatureCollection",
    "Polygon returns a FeatureCollection"
  );
  t.equal(
    triangles.features[0].geometry.type,
    "Polygon",
    "contains at least 1 triangle"
  );
  t.equal(
    triangles.features[0].geometry.coordinates[0].length,
    4,
    "triangle is valid"
  );

  var multipolygon = {
    type: "Feature",
    properties: { name: "Michigan" },
    geometry: {
      type: "MultiPolygon",
      coordinates: [
        [
          [
            [-88.684434, 48.115785],
            [-88.675628, 48.120444],
            [-88.676395, 48.124876],
            [-88.674192, 48.127165],
            [-88.656915, 48.139225],
            [-88.614026, 48.154797],
            [-88.578413, 48.16237],
            [-88.547033, 48.174891],
            [-88.524753, 48.165291],
            [-88.501088, 48.168181],
            [-88.491961, 48.175466],
            [-88.482039, 48.179915],
            [-88.459735, 48.183807],
            [-88.447236, 48.182916],
            [-88.422601, 48.190975],
            [-88.418244, 48.18037],
            [-88.419875, 48.170731],
            [-88.427373, 48.166764],
            [-88.449502, 48.163312],
            [-88.459697, 48.158551],
            [-88.469573, 48.152879],
            [-88.4857, 48.137683],
            [-88.511902, 48.121699],
            [-88.566938, 48.093719],
            [-88.578053, 48.084373],
            [-88.578395, 48.078003],
            [-88.575869, 48.075166],
            [-88.573924, 48.068861],
            [-88.575048, 48.064154],
            [-88.579784, 48.058669],
            [-88.670073, 48.011446],
            [-88.718555, 47.995134],
            [-88.772357, 47.981126],
            [-88.791959, 47.978938],
            [-88.832063, 47.965213],
            [-88.852923, 47.965322],
            [-88.899184, 47.9533],
            [-88.918029, 47.945605],
            [-88.923573, 47.937976],
            [-88.962664, 47.923512],
            [-88.968903, 47.909474],
            [-88.968903, 47.901675],
            [-88.957985, 47.895436],
            [-88.942387, 47.895436],
            [-88.899698, 47.902445],
            [-88.898986, 47.900685],
            [-88.911665, 47.891344],
            [-88.998939, 47.86749],
            [-89.022736, 47.858532],
            [-89.044463, 47.85575],
            [-89.056412, 47.852598],
            [-89.107991, 47.835705],
            [-89.124134, 47.828616],
            [-89.157738, 47.824015],
            [-89.19017, 47.831603],
            [-89.192681, 47.83343],
            [-89.192207, 47.84106],
            [-89.201812, 47.850243],
            [-89.234533, 47.851718],
            [-89.235552, 47.853774],
            [-89.234535, 47.855373],
            [-89.228507, 47.858039],
            [-89.246774, 47.871016],
            [-89.250936, 47.870377],
            [-89.255202, 47.876102],
            [-89.247127, 47.888503],
            [-89.226327, 47.895438],
            [-89.22071, 47.90085],
            [-89.221332, 47.908069],
            [-89.214499, 47.913895],
            [-89.179154, 47.93503],
            [-89.095207, 47.967922],
            [-89.018303, 47.992525],
            [-88.994163, 48.00229],
            [-88.940886, 48.01959],
            [-88.931487, 48.021637],
            [-88.927529, 48.019615],
            [-88.915032, 48.020681],
            [-88.895069, 48.029059],
            [-88.896327, 48.031801],
            [-88.893701, 48.03477],
            [-88.835714, 48.056752],
            [-88.816084, 48.057006],
            [-88.810461, 48.055247],
            [-88.787556, 48.063035],
            [-88.772077, 48.070502],
            [-88.77183, 48.079457],
            [-88.764256, 48.085189],
            [-88.744458, 48.092769],
            [-88.728198, 48.101914],
            [-88.705586, 48.111013],
            [-88.695353, 48.110549],
            [-88.684434, 48.115785],
          ],
        ],
        [
          [
            [-85.566441, 45.760222],
            [-85.54956, 45.757266],
            [-85.54375, 45.751413],
            [-85.53562, 45.750394],
            [-85.525237, 45.750462],
            [-85.506133, 45.754715],
            [-85.501267, 45.754415],
            [-85.497656, 45.746246],
            [-85.503758, 45.742771],
            [-85.508818, 45.742358],
            [-85.510091, 45.742888],
            [-85.508522, 45.744991],
            [-85.50904, 45.748488],
            [-85.515145, 45.749451],
            [-85.520569, 45.744745],
            [-85.521911, 45.739419],
            [-85.520803, 45.737247],
            [-85.510895, 45.734414],
            [-85.498777, 45.726291],
            [-85.494154, 45.705378],
            [-85.494016, 45.698476],
            [-85.5028, 45.690998],
            [-85.506104, 45.681148],
            [-85.503767, 45.670472],
            [-85.500451, 45.664298],
            [-85.490252, 45.652122],
            [-85.487026, 45.621211],
            [-85.491347, 45.609665],
            [-85.509276, 45.596475],
            [-85.518038, 45.592912],
            [-85.526895, 45.59159],
            [-85.530273, 45.589253],
            [-85.534064, 45.578198],
            [-85.541129, 45.575045],
            [-85.561634, 45.572213],
            [-85.618049, 45.582647],
            [-85.622741, 45.586028],
            [-85.630016, 45.598166],
            [-85.61985, 45.624547],
            [-85.608653, 45.632008],
            [-85.604521, 45.639256],
            [-85.604951, 45.647599],
            [-85.609295, 45.658067],
            [-85.604881, 45.681932],
            [-85.600842, 45.68886],
            [-85.590769, 45.698051],
            [-85.583724, 45.700796],
            [-85.572309, 45.711449],
            [-85.565132, 45.730719],
            [-85.564774, 45.745462],
            [-85.567128, 45.750419],
            [-85.567781, 45.757655],
            [-85.566441, 45.760222],
          ],
        ],
        [
          [
            [-87.590208, 45.095264],
            [-87.59188, 45.094689],
            [-87.614897, 45.100064],
            [-87.621609, 45.102399],
            [-87.62764, 45.103328],
            [-87.628829, 45.104039],
            [-87.629571, 45.105324],
            [-87.631535, 45.106224],
            [-87.63611, 45.105918],
            [-87.648191, 45.106368],
            [-87.652512, 45.108633],
            [-87.657135, 45.107568],
            [-87.659952, 45.107512],
            [-87.661211, 45.108279],
            [-87.661296, 45.112566],
            [-87.667102, 45.118109],
            [-87.671, 45.120069],
            [-87.672447, 45.121294],
            [-87.678209, 45.130084],
            [-87.678511, 45.131204],
            [-87.676024, 45.134089],
            [-87.675816, 45.135059],
            [-87.683902, 45.144135],
            [-87.688425, 45.147433],
            [-87.692375, 45.149505],
            [-87.695055, 45.150522],
            [-87.700618, 45.151188],
            [-87.703492, 45.152206],
            [-87.707391, 45.154679],
            [-87.708134, 45.156004],
            [-87.711322, 45.158946],
            [-87.717945, 45.161156],
            [-87.723121, 45.165141],
            [-87.724601, 45.167452],
            [-87.727768, 45.169596],
            [-87.730866, 45.170913],
            [-87.735135, 45.171538],
            [-87.736104, 45.172244],
            [-87.736509, 45.173389],
            [-87.73521, 45.177642],
            [-87.741805, 45.197051],
            [-87.741732, 45.198201],
            [-87.739492, 45.202126],
            [-87.736339, 45.204653],
            [-87.72796, 45.207956],
            [-87.726198, 45.209391],
            [-87.726175, 45.21264],
            [-87.727276, 45.216129],
            [-87.726952, 45.218949],
            [-87.722473, 45.223309],
            [-87.721354, 45.226847],
            [-87.721935, 45.228444],
            [-87.72492, 45.229977],
            [-87.725205, 45.231539],
            [-87.724156, 45.233236],
            [-87.718264, 45.238333],
            [-87.717051, 45.238743],
            [-87.713398, 45.238564],
            [-87.712184, 45.239014],
            [-87.711339, 45.239965],
            [-87.71148, 45.245224],
            [-87.709145, 45.254649],
            [-87.707779, 45.258343],
            [-87.709137, 45.260341],
            [-87.703053, 45.267041],
            [-87.69878, 45.26942],
            [-87.698456, 45.272072],
            [-87.699492, 45.276659],
            [-87.698248, 45.281512],
            [-87.693468, 45.287675],
            [-87.690364, 45.29027],
            [-87.687578, 45.296283],
            [-87.687498, 45.298055],
            [-87.679085, 45.305841],
            [-87.675328, 45.307907],
            [-87.667423, 45.31636],
            [-87.665243, 45.317115],
            [-87.663666, 45.318257],
            [-87.6615, 45.321386],
            [-87.662029, 45.326434],
            [-87.661603, 45.327608],
            [-87.65983, 45.329144],
            [-87.655775, 45.330847],
            [-87.648126, 45.339396],
            [-87.647454, 45.345232],
            [-87.647729, 45.350721],
            [-87.648476, 45.352243],
            [-87.650661, 45.353798],
            [-87.653568, 45.354204],
            [-87.656632, 45.358617],
            [-87.655807, 45.362706],
            [-87.656624, 45.367295],
            [-87.657349, 45.368752],
            [-87.673513, 45.376946],
            [-87.674403, 45.378065],
            [-87.67455, 45.381649],
            [-87.675017, 45.382454],
            [-87.682866, 45.38495],
            [-87.685934, 45.388711],
            [-87.690281, 45.389822],
            [-87.693956, 45.389893],
            [-87.699797, 45.387927],
            [-87.704337, 45.385462],
            [-87.706767, 45.383827],
            [-87.708329, 45.381218],
            [-87.718891, 45.377462],
            [-87.733409, 45.364432],
            [-87.737801, 45.359635],
            [-87.738352, 45.358243],
            [-87.750928, 45.355037],
            [-87.751626, 45.354169],
            [-87.751452, 45.351755],
            [-87.754104, 45.349442],
            [-87.762128, 45.348401],
            [-87.769172, 45.351195],
            [-87.771384, 45.35121],
            [-87.773901, 45.351226],
            [-87.783076, 45.349725],
            [-87.787967, 45.352612],
            [-87.790324, 45.353444],
            [-87.800464, 45.353608],
            [-87.810076, 45.351269],
            [-87.823028, 45.35265],
            [-87.823554, 45.351637],
            [-87.824855, 45.350713],
            [-87.826918, 45.350538],
            [-87.829775, 45.352005],
            [-87.832612, 45.352249],
            [-87.835303, 45.35098],
            [-87.836782, 45.346451],
            [-87.838141, 45.345101],
            [-87.848368, 45.340676],
            [-87.850133, 45.340435],
            [-87.851318, 45.341346],
            [-87.851475, 45.342335],
            [-87.849899, 45.344651],
            [-87.850418, 45.347492],
            [-87.852784, 45.349497],
            [-87.858617, 45.350378],
            [-87.860871, 45.351192],
            [-87.863489, 45.35302],
            [-87.864873, 45.354767],
            [-87.865274, 45.355969],
            [-87.865675, 45.358213],
            [-87.867037, 45.360137],
            [-87.86856, 45.360537],
            [-87.870243, 45.360617],
            [-87.871204, 45.360056],
            [-87.871285, 45.358614],
            [-87.871124, 45.357011],
            [-87.871685, 45.355729],
            [-87.873529, 45.354286],
            [-87.879835, 45.35149],
            [-87.881114, 45.351278],
            [-87.88517, 45.351736],
            [-87.886949, 45.35311],
            [-87.888052, 45.354697],
            [-87.887828, 45.358122],
            [-87.884855, 45.362792],
            [-87.876862, 45.368535],
            [-87.871485, 45.371546],
            [-87.871789, 45.373557],
            [-87.875692, 45.377052],
            [-87.875424, 45.379373],
            [-87.873568, 45.381357],
            [-87.870905, 45.383116],
            [-87.864677, 45.385232],
            [-87.859418, 45.388227],
            [-87.85683, 45.393106],
            [-87.859603, 45.396409],
            [-87.859773, 45.397278],
            [-87.859131, 45.398967],
            [-87.850969, 45.401925],
            [-87.849322, 45.403872],
            [-87.849668, 45.409518],
            [-87.850533, 45.411685],
            [-87.85181, 45.413103],
            [-87.856216, 45.416101],
            [-87.860432, 45.423504],
            [-87.860127, 45.429584],
            [-87.86195, 45.433072],
            [-87.861697, 45.434473],
            [-87.855298, 45.441379],
            [-87.847429, 45.444177],
            [-87.844815, 45.448411],
            [-87.836008, 45.450877],
            [-87.833042, 45.453596],
            [-87.832456, 45.45502],
            [-87.82743, 45.458076],
            [-87.821057, 45.459955],
            [-87.812976, 45.464159],
            [-87.812971, 45.4661],
            [-87.811469, 45.467991],
            [-87.805773, 45.473139],
            [-87.805873, 45.47438],
            [-87.807388, 45.477031],
            [-87.806891, 45.479092],
            [-87.79896, 45.485147],
            [-87.798362, 45.486564],
            [-87.797824, 45.491468],
            [-87.796409, 45.494679],
            [-87.793447, 45.498372],
            [-87.792769, 45.499967],
            [-87.793215, 45.505028],
            [-87.798794, 45.506287],
            [-87.802267, 45.514233],
            [-87.804203, 45.524676],
            [-87.80472, 45.531244],
            [-87.804528, 45.534373],
            [-87.803364, 45.537016],
            [-87.80339, 45.538272],
            [-87.807159, 45.543523],
            [-87.813737, 45.548616],
            [-87.818791, 45.5521],
            [-87.827215, 45.55562],
            [-87.832296, 45.558767],
            [-87.832968, 45.559461],
            [-87.833591, 45.562529],
            [-87.831689, 45.568035],
            [-87.829346, 45.568776],
            [-87.813745, 45.565175],
            [-87.806104, 45.562863],
            [-87.797536, 45.562124],
            [-87.792372, 45.563055],
            [-87.790874, 45.564096],
            [-87.788798, 45.565947],
            [-87.788326, 45.567941],
            [-87.787292, 45.574906],
            [-87.787534, 45.581376],
            [-87.786767, 45.58283],
            [-87.785647, 45.58396],
            [-87.781255, 45.585682],
            [-87.777199, 45.588499],
            [-87.776238, 45.597797],
            [-87.777671, 45.609204],
            [-87.780845, 45.614599],
            [-87.792016, 45.616756],
            [-87.79588, 45.618846],
            [-87.796179, 45.622074],
            [-87.796983, 45.623613],
            [-87.804481, 45.628933],
            [-87.810194, 45.638732],
            [-87.817277, 45.643926],
            [-87.821818, 45.645589],
            [-87.824102, 45.647138],
            [-87.824676, 45.653211],
            [-87.822693, 45.656077],
            [-87.822425, 45.658012],
            [-87.823672, 45.659817],
            [-87.823868, 45.66192],
            [-87.823164, 45.662732],
            [-87.80329, 45.666494],
            [-87.798903, 45.67014],
            [-87.795355, 45.671334],
            [-87.781623, 45.67328],
            [-87.781007, 45.673934],
            [-87.780737, 45.675458],
            [-87.780808, 45.680349],
            [-87.782226, 45.683053],
            [-87.787727, 45.68718],
            [-87.80188, 45.693862],
            [-87.804993, 45.695796],
            [-87.809075, 45.699717],
            [-87.809181, 45.700337],
            [-87.805076, 45.703556],
            [-87.805081, 45.704974],
            [-87.805867, 45.706841],
            [-87.810144, 45.71023],
            [-87.812338, 45.711303],
            [-87.831442, 45.714938],
            [-87.837343, 45.716919],
            [-87.85548, 45.726943],
            [-87.86432, 45.737139],
            [-87.863874, 45.74266],
            [-87.86305, 45.74309],
            [-87.864141, 45.745697],
            [-87.868111, 45.749477],
            [-87.873339, 45.750439],
            [-87.875813, 45.753888],
            [-87.879812, 45.754843],
            [-87.882261, 45.754779],
            [-87.891905, 45.754055],
            [-87.896032, 45.752285],
            [-87.898363, 45.752503],
            [-87.900005, 45.753497],
            [-87.901299, 45.756553],
            [-87.902707, 45.757932],
            [-87.904657, 45.759163],
            [-87.905873, 45.759364],
            [-87.907771, 45.75928],
            [-87.908933, 45.758297],
            [-87.921999, 45.756989],
            [-87.926611, 45.75959],
            [-87.92913, 45.760364],
            [-87.934585, 45.758094],
            [-87.944113, 45.757422],
            [-87.954459, 45.758414],
            [-87.959277, 45.757367],
            [-87.963452, 45.75822],
            [-87.964725, 45.759461],
            [-87.963996, 45.760794],
            [-87.96697, 45.764021],
            [-87.972451, 45.766319],
            [-87.976835, 45.767015],
            [-87.986429, 45.769596],
            [-87.989656, 45.772025],
            [-87.989829, 45.772945],
            [-87.985597, 45.774926],
            [-87.983392, 45.774696],
            [-87.981789, 45.775081],
            [-87.98087, 45.776977],
            [-87.982617, 45.782944],
            [-87.987942, 45.793075],
            [-87.989831, 45.794827],
            [-87.991447, 45.795393],
            [-87.995876, 45.795435],
            [-88.001593, 45.794091],
            [-88.007043, 45.792192],
            [-88.017588, 45.792455],
            [-88.0236, 45.790094],
            [-88.027228, 45.78919],
            [-88.031124, 45.789233],
            [-88.033568, 45.789816],
            [-88.039729, 45.789626],
            [-88.040221, 45.789236],
            [-88.040892, 45.786452],
            [-88.044697, 45.783718],
            [-88.048514, 45.782549],
            [-88.050634, 45.780972],
            [-88.072091, 45.780261],
            [-88.076375, 45.781606],
            [-88.078361, 45.784249],
            [-88.079764, 45.78495],
            [-88.08859, 45.784697],
            [-88.094047, 45.785658],
            [-88.099616, 45.790186],
            [-88.103247, 45.791361],
            [-88.106351, 45.797573],
            [-88.105518, 45.798839],
            [-88.105355, 45.800104],
            [-88.107506, 45.802668],
            [-88.109506, 45.803584],
            [-88.116024, 45.804079],
            [-88.129461, 45.809288],
            [-88.131834, 45.811312],
            [-88.13611, 45.819029],
            [-88.135067, 45.821694],
            [-88.13364, 45.823128],
            [-88.127808, 45.827173],
            [-88.122947, 45.829565],
            [-88.120723, 45.832995],
            [-88.114267, 45.837891],
            [-88.111726, 45.839196],
            [-88.109089, 45.839492],
            [-88.106622, 45.841072],
            [-88.098326, 45.850142],
            [-88.088825, 45.85586],
            [-88.087419, 45.857459],
            [-88.084985, 45.862443],
            [-88.08259, 45.864944],
            [-88.081641, 45.865087],
            [-88.077534, 45.863825],
            [-88.075146, 45.864832],
            [-88.073134, 45.871952],
            [-88.073944, 45.875593],
            [-88.081781, 45.880516],
            [-88.083965, 45.881186],
            [-88.095841, 45.880042],
            [-88.100218, 45.881205],
            [-88.101814, 45.883504],
            [-88.105447, 45.896593],
            [-88.105981, 45.897091],
            [-88.106136, 45.900811],
            [-88.105677, 45.904387],
            [-88.104576, 45.906847],
            [-88.101973, 45.91055],
            [-88.099172, 45.912362],
            [-88.095354, 45.913895],
            [-88.095409, 45.915175],
            [-88.096496, 45.917273],
            [-88.102908, 45.921869],
            [-88.104686, 45.922121],
            [-88.115346, 45.922211],
            [-88.118507, 45.92114],
            [-88.121864, 45.92075],
            [-88.126382, 45.921499],
            [-88.127594, 45.922414],
            [-88.12743, 45.923214],
            [-88.126122, 45.924639],
            [-88.127428, 45.926153],
            [-88.141001, 45.930608],
            [-88.145928, 45.933646],
            [-88.146419, 45.934194],
            [-88.146352, 45.935314],
            [-88.158704, 45.939064],
            [-88.163105, 45.939043],
            [-88.163959, 45.93834],
            [-88.170096, 45.93947],
            [-88.172628, 45.941015],
            [-88.175532, 45.944897],
            [-88.178008, 45.947111],
            [-88.189789, 45.952208],
            [-88.191991, 45.95274],
            [-88.196316, 45.953311],
            [-88.197627, 45.953082],
            [-88.202116, 45.949836],
            [-88.201852, 45.945173],
            [-88.209585, 45.94428],
            [-88.211158, 45.944531],
            [-88.215025, 45.946976],
            [-88.222167, 45.948513],
            [-88.223773, 45.948712],
            [-88.227988, 45.947688],
            [-88.23314, 45.947405],
            [-88.239672, 45.948982],
            [-88.242518, 45.950363],
            [-88.244452, 45.952142],
            [-88.245752, 45.954147],
            [-88.246579, 45.956597],
            [-88.245937, 45.958726],
            [-88.246307, 45.962983],
            [-88.249117, 45.963663],
            [-88.250133, 45.963572],
            [-88.250133, 45.963147],
            [-88.254816, 45.963538],
            [-88.256455, 45.962739],
            [-88.259343, 45.959494],
            [-88.26839, 45.957486],
            [-88.283335, 45.955091],
            [-88.292381, 45.951115],
            [-88.295264, 45.951253],
            [-88.296968, 45.953767],
            [-88.300965, 45.956168],
            [-88.30952, 45.959369],
            [-88.316894, 45.960969],
            [-88.320531, 45.959963],
            [-88.326003, 45.9553],
            [-88.326953, 45.955071],
            [-88.330296, 45.956625],
            [-88.327872, 45.958934],
            [-88.328333, 45.964054],
            [-88.330137, 45.965951],
            [-88.334628, 45.968808],
            [-88.380183, 45.991654],
            [-88.385234, 45.990239],
            [-88.384318, 45.988113],
            [-88.388847, 45.982675],
            [-88.395308, 45.980391],
            [-88.399046, 45.980278],
            [-88.402848, 45.981194],
            [-88.409864, 45.979688],
            [-88.411077, 45.979139],
            [-88.414849, 45.975483],
            [-88.416914, 45.975323],
            [-88.420356, 45.976764],
            [-88.423044, 45.978547],
            [-88.422322, 45.98017],
            [-88.423437, 45.98193],
            [-88.426125, 45.984102],
            [-88.43406, 45.986205],
            [-88.435798, 45.988125],
            [-88.439733, 45.990456],
            [-88.443078, 45.990685],
            [-88.448751, 45.98977],
            [-88.450325, 45.990181],
            [-88.454261, 45.993426],
            [-88.453868, 45.996169],
            [-88.454361, 45.997518],
            [-88.458658, 45.999391],
            [-88.465542, 46.000685],
            [-88.470855, 46.001004],
            [-88.474695, 45.99877],
            [-88.475152, 45.996598],
            [-88.474036, 45.994655],
            [-88.476002, 45.992826],
            [-88.478984, 45.991797],
            [-88.486755, 45.990949],
            [-88.492495, 45.992157],
            [-88.497417, 45.995149],
            [-88.498108, 45.99636],
            [-88.496897, 45.998281],
            [-88.496898, 45.999012],
            [-88.498765, 46.000393],
            [-88.500133, 46.000457],
            [-88.505946, 46.013385],
            [-88.506205, 46.017134],
            [-88.507188, 46.0183],
            [-88.509516, 46.019169],
            [-88.514601, 46.019926],
            [-88.523131, 46.019518],
            [-88.526673, 46.020822],
            [-88.532414, 46.021212],
            [-88.533825, 46.020915],
            [-88.53353, 46.019932],
            [-88.534876, 46.018104],
            [-88.539011, 46.014791],
            [-88.541078, 46.013763],
            [-88.550756, 46.012896],
            [-88.554987, 46.014977],
            [-88.565485, 46.015708],
            [-88.571553, 46.013811],
            [-88.572995, 46.011799],
            [-88.58067, 46.006975],
            [-88.589, 46.005077],
            [-88.589755, 46.005602],
            [-88.592874, 46.01159],
            [-88.593302, 46.014447],
            [-88.59386, 46.015132],
            [-88.598093, 46.017623],
            [-88.60144, 46.017599],
            [-88.603965, 46.016181],
            [-88.607438, 46.010991],
            [-88.611466, 46.003332],
            [-88.611563, 45.99881],
            [-88.613063, 45.990627],
            [-88.614176, 45.988775],
            [-88.616405, 45.9877],
            [-88.623947, 45.988633],
            [-88.634055, 45.987999],
            [-88.634842, 45.987565],
            [-88.635598, 45.985119],
            [-88.6375, 45.98496],
            [-88.65776, 45.989287],
            [-88.661312, 45.988819],
            [-88.662902, 45.98873],
            [-88.663697, 45.989084],
            [-88.664802, 45.989835],
            [-88.66436, 45.991337],
            [-88.663609, 45.992397],
            [-88.663923, 45.993242],
            [-88.667464, 45.995048],
            [-88.671267, 45.999026],
            [-88.670939, 45.999957],
            [-88.670115, 45.999957],
            [-88.671458, 46.005104],
            [-88.674606, 46.010567],
            [-88.679132, 46.013538],
            [-88.691662, 46.015435],
            [-88.698716, 46.017903],
            [-88.704687, 46.018154],
            [-88.710328, 46.016303],
            [-88.713049, 46.012668],
            [-88.718397, 46.013284],
            [-88.721319, 46.018608],
            [-88.721125, 46.022013],
            [-88.724801, 46.024503],
            [-88.730675, 46.026535],
            [-88.739994, 46.027308],
            [-88.746422, 46.025798],
            [-88.752176, 46.023584],
            [-88.754033, 46.02246],
            [-88.756295, 46.020173],
            [-88.758618, 46.019542],
            [-88.760044, 46.019815],
            [-88.763767, 46.021943],
            [-88.765208, 46.022086],
            [-88.766156, 46.022149],
            [-88.767104, 46.021896],
            [-88.76761, 46.021643],
            [-88.768305, 46.021201],
            [-88.768692, 46.020571],
            [-88.769712, 46.018968],
            [-88.776187, 46.015931],
            [-88.779915, 46.015436],
            [-88.782104, 46.016558],
            [-88.783891, 46.020934],
            [-88.784007, 46.022984],
            [-88.783635, 46.024357],
            [-88.778734, 46.028875],
            [-88.778628, 46.031271],
            [-88.779221, 46.031869],
            [-88.784411, 46.032709],
            [-88.791796, 46.032057],
            [-88.796182, 46.033712],
            [-88.80067, 46.030036],
            [-88.796242, 46.026853],
            [-88.79579, 46.024864],
            [-88.79646, 46.023605],
            [-88.801761, 46.023737],
            [-88.811948, 46.021609],
            [-88.815629, 46.02232],
            [-88.815427, 46.022954],
            [-88.816489, 46.023924],
            [-88.820592, 46.026261],
            [-88.831544, 46.02962],
            [-88.835249, 46.03033],
            [-88.837991, 46.030176],
            [-88.840584, 46.031112],
            [-88.843903, 46.03305],
            [-88.847599, 46.037161],
            [-88.848464, 46.038858],
            [-88.85027, 46.040274],
            [-88.943279, 46.077943],
            [-88.948698, 46.080205],
            [-88.990807, 46.097298],
            [-89.09163, 46.138505],
            [-89.125136, 46.144531],
            [-89.161757, 46.151816],
            [-89.166887, 46.152868],
            [-89.194508, 46.157942],
            [-89.201283, 46.159426],
            [-89.203289, 46.16002],
            [-89.205657, 46.160408],
            [-89.218156, 46.162988],
            [-89.219964, 46.163319],
            [-89.276489, 46.174047],
            [-89.276883, 46.174116],
            [-89.495723, 46.216301],
            [-89.533801, 46.224119],
            [-89.638416, 46.243804],
            [-89.667617, 46.249797],
            [-89.764506, 46.268082],
            [-89.908196, 46.296037],
            [-89.90991, 46.296402],
            [-89.918798, 46.297741],
            [-90.120489, 46.336852],
            [-90.121248, 46.337217],
            [-90.12138, 46.338131],
            [-90.121084, 46.338656],
            [-90.119468, 46.3397],
            [-90.118791, 46.342253],
            [-90.119572, 46.34418],
            [-90.120198, 46.345066],
            [-90.120614, 46.34642],
            [-90.119729, 46.348504],
            [-90.117466, 46.349487],
            [-90.116741, 46.350652],
            [-90.116844, 46.355153],
            [-90.118827, 46.359241],
            [-90.119691, 46.359755],
            [-90.119757, 46.359748],
            [-90.120973, 46.35972],
            [-90.122287, 46.360139],
            [-90.122785, 46.361259],
            [-90.122757, 46.362621],
            [-90.122923, 46.363603],
            [-90.126517, 46.366889],
            [-90.131036, 46.369199],
            [-90.133871, 46.371828],
            [-90.134663, 46.374947],
            [-90.134656, 46.374979],
            [-90.13225, 46.381249],
            [-90.133966, 46.382118],
            [-90.135253, 46.38221],
            [-90.13941, 46.384999],
            [-90.144359, 46.390255],
            [-90.146816, 46.397205],
            [-90.148347, 46.399258],
            [-90.152936, 46.401293],
            [-90.157851, 46.409291],
            [-90.158972, 46.413769],
            [-90.158241, 46.420485],
            [-90.158603, 46.422656],
            [-90.163422, 46.434605],
            [-90.166526, 46.437576],
            [-90.166909, 46.439311],
            [-90.166919, 46.439851],
            [-90.174556, 46.439656],
            [-90.17786, 46.440548],
            [-90.179212, 46.45309],
            [-90.180336, 46.456746],
            [-90.189162, 46.459054],
            [-90.190749, 46.460173],
            [-90.193294, 46.463143],
            [-90.192005, 46.465611],
            [-90.189426, 46.467004],
            [-90.188633, 46.468101],
            [-90.188996, 46.469015],
            [-90.193394, 46.472487],
            [-90.201727, 46.476074],
            [-90.204009, 46.478175],
            [-90.211753, 46.490351],
            [-90.214843, 46.498181],
            [-90.214866, 46.499947],
            [-90.216594, 46.501759],
            [-90.220532, 46.503403],
            [-90.222351, 46.50338],
            [-90.228735, 46.501573],
            [-90.230324, 46.501732],
            [-90.23102, 46.503354],
            [-90.230921, 46.504656],
            [-90.229402, 46.507992],
            [-90.230363, 46.509705],
            [-90.231587, 46.509842],
            [-90.236283, 46.507121],
            [-90.243395, 46.505245],
            [-90.246043, 46.504832],
            [-90.248194, 46.505357],
            [-90.25716, 46.504716],
            [-90.25865, 46.503483],
            [-90.260504, 46.502822],
            [-90.263018, 46.502777],
            [-90.265269, 46.503829],
            [-90.265143, 46.505089],
            [-90.265143, 46.506222],
            [-90.266528, 46.507356],
            [-90.26848, 46.507167],
            [-90.27018, 46.507356],
            [-90.270684, 46.508237],
            [-90.270558, 46.50956],
            [-90.270432, 46.510756],
            [-90.270422, 46.51169],
            [-90.274721, 46.515416],
            [-90.271971, 46.519756],
            [-90.272599, 46.521127],
            [-90.277131, 46.524487],
            [-90.278356, 46.523847],
            [-90.27892, 46.522271],
            [-90.283423, 46.518868],
            [-90.285707, 46.518846],
            [-90.292854, 46.520972],
            [-90.294311, 46.519876],
            [-90.294411, 46.518848],
            [-90.298284, 46.51782],
            [-90.303546, 46.517432],
            [-90.306558, 46.518484],
            [-90.307716, 46.518392],
            [-90.312581, 46.517113],
            [-90.313839, 46.516199],
            [-90.313894, 46.516199],
            [-90.316983, 46.517319],
            [-90.317777, 46.521637],
            [-90.314434, 46.523784],
            [-90.311886, 46.528695],
            [-90.310329, 46.536852],
            [-90.310859, 46.539365],
            [-90.320428, 46.546287],
            [-90.324699, 46.545602],
            [-90.326686, 46.54615],
            [-90.328044, 46.548046],
            [-90.327548, 46.550262],
            [-90.331887, 46.553278],
            [-90.336921, 46.554076],
            [-90.344338, 46.552087],
            [-90.347514, 46.547083],
            [-90.349462, 46.53808],
            [-90.350121, 46.537337],
            [-90.35158, 46.537074],
            [-90.353534, 46.537553],
            [-90.355689, 46.540317],
            [-90.357014, 46.540591],
            [-90.357676, 46.540271],
            [-90.3616, 46.541434],
            [-90.369964, 46.540549],
            [-90.374461, 46.539212],
            [-90.387228, 46.533663],
            [-90.39332, 46.532615],
            [-90.395272, 46.533941],
            [-90.395568, 46.536317],
            [-90.398742, 46.542738],
            [-90.400041, 46.544384],
            [-90.400429, 46.544384],
            [-90.402019, 46.544384],
            [-90.405593, 46.547584],
            [-90.407775, 46.552246],
            [-90.414464, 46.55732],
            [-90.414596, 46.55732],
            [-90.41562, 46.563169],
            [-90.418136, 46.566094],
            [-90.348407, 46.600635],
            [-90.327626, 46.607744],
            [-90.306609, 46.602741],
            [-90.265294, 46.618516],
            [-90.237609, 46.624485],
            [-90.164026, 46.645515],
            [-90.100695, 46.655132],
            [-90.04542, 46.668272],
            [-90.028392, 46.67439],
            [-89.996034, 46.693225],
            [-89.985817, 46.70319],
            [-89.973803, 46.710322],
            [-89.957101, 46.716929],
            [-89.918466, 46.740324],
            [-89.892355, 46.763088],
            [-89.848652, 46.795711],
            [-89.831956, 46.804053],
            [-89.790663, 46.818469],
            [-89.720277, 46.830413],
            [-89.673375, 46.833229],
            [-89.660625, 46.831056],
            [-89.642255, 46.82534],
            [-89.634938, 46.819488],
            [-89.619329, 46.81889],
            [-89.569808, 46.831859],
            [-89.535683, 46.835878],
            [-89.513938, 46.841835],
            [-89.49908, 46.841621],
            [-89.491252, 46.838448],
            [-89.47154, 46.837359],
            [-89.437047, 46.839512],
            [-89.415154, 46.843983],
            [-89.372032, 46.857386],
            [-89.249143, 46.903326],
            [-89.227914, 46.912954],
            [-89.201511, 46.931149],
            [-89.168244, 46.965536],
            [-89.142595, 46.984859],
            [-89.128698, 46.992599],
            [-89.118339, 46.99422],
            [-89.113158, 46.989356],
            [-89.106277, 46.98648],
            [-89.086742, 46.985298],
            [-89.063103, 46.988522],
            [-89.03949, 46.999419],
            [-89.02893, 47.00114],
            [-89.022994, 46.99512],
            [-88.998417, 46.995314],
            [-88.987197, 46.997239],
            [-88.972802, 47.002096],
            [-88.959409, 47.008496],
            [-88.944045, 47.020129],
            [-88.924492, 47.042156],
            [-88.914189, 47.059246],
            [-88.903706, 47.086161],
            [-88.88914, 47.100575],
            [-88.855372, 47.114263],
            [-88.848176, 47.115065],
            [-88.814834, 47.141399],
            [-88.789813, 47.150925],
            [-88.778022, 47.150465],
            [-88.764351, 47.155762],
            [-88.729688, 47.185834],
            [-88.69966, 47.204831],
            [-88.672395, 47.219137],
            [-88.656359, 47.225624],
            [-88.640323, 47.226784],
            [-88.623579, 47.232352],
            [-88.60983, 47.238894],
            [-88.584912, 47.242361],
            [-88.573997, 47.245989],
            [-88.50078, 47.293503],
            [-88.477733, 47.31346],
            [-88.470484, 47.327653],
            [-88.459262, 47.339903],
            [-88.418673, 47.371188],
            [-88.389459, 47.384431],
            [-88.324083, 47.403542],
            [-88.303447, 47.412204],
            [-88.285195, 47.422392],
            [-88.239161, 47.429969],
            [-88.227446, 47.435093],
            [-88.218424, 47.441585],
            [-88.216977, 47.445493],
            [-88.217822, 47.448738],
            [-88.18182, 47.457657],
            [-88.150571, 47.460093],
            [-88.139651, 47.462693],
            [-88.085252, 47.468961],
            [-88.076388, 47.467752],
            [-88.049326, 47.469785],
            [-88.048226, 47.470008],
            [-88.048077, 47.474973],
            [-88.040291, 47.475999],
            [-87.978934, 47.47942],
            [-87.929269, 47.478737],
            [-87.902416, 47.477045],
            [-87.898036, 47.474872],
            [-87.816958, 47.471998],
            [-87.801184, 47.473301],
            [-87.756739, 47.460717],
            [-87.730804, 47.449112],
            [-87.715942, 47.439816],
            [-87.710471, 47.4062],
            [-87.712421, 47.4014],
            [-87.721274, 47.401032],
            [-87.742417, 47.405823],
            [-87.75138, 47.405066],
            [-87.759057, 47.403013],
            [-87.765019, 47.398652],
            [-87.800294, 47.392148],
            [-87.815371, 47.38479],
            [-87.827115, 47.38616],
            [-87.834822, 47.390478],
            [-87.848252, 47.394864],
            [-87.8567, 47.395387],
            [-87.882245, 47.395588],
            [-87.941613, 47.390073],
            [-87.957058, 47.38726],
            [-87.965063, 47.37443],
            [-87.965598, 47.368645],
            [-87.962567, 47.362543],
            [-87.954796, 47.356809],
            [-87.947397, 47.355461],
            [-87.938787, 47.346777],
            [-87.93825, 47.342299],
            [-87.94336, 47.335899],
            [-87.946352, 47.334254],
            [-87.958386, 47.334435],
            [-87.968604, 47.332582],
            [-87.989133, 47.322633],
            [-88.016478, 47.306275],
            [-88.054849, 47.29824],
            [-88.06009, 47.295796],
            [-88.071476, 47.286768],
            [-88.096851, 47.261351],
            [-88.108833, 47.259131],
            [-88.117456, 47.255174],
            [-88.131943, 47.239554],
            [-88.163059, 47.216278],
            [-88.194218, 47.209242],
            [-88.204849, 47.210498],
            [-88.212361, 47.209423],
            [-88.228987, 47.199042],
            [-88.236892, 47.189236],
            [-88.242006, 47.174767],
            [-88.24266, 47.158426],
            [-88.23947, 47.151137],
            [-88.236721, 47.149287],
            [-88.231797, 47.149609],
            [-88.232164, 47.145975],
            [-88.239895, 47.139436],
            [-88.247628, 47.135981],
            [-88.249571, 47.136231],
            [-88.250785, 47.140209],
            [-88.255303, 47.14364],
            [-88.262972, 47.145174],
            [-88.272017, 47.143511],
            [-88.281701, 47.138212],
            [-88.28904, 47.129689],
            [-88.289543, 47.126604],
            [-88.28787, 47.125374],
            [-88.287173, 47.12042],
            [-88.288347, 47.114547],
            [-88.297625, 47.098505],
            [-88.340052, 47.080494],
            [-88.346709, 47.079372],
            [-88.349952, 47.076377],
            [-88.353191, 47.069063],
            [-88.353952, 47.058047],
            [-88.359054, 47.039739],
            [-88.367624, 47.019213],
            [-88.373966, 47.012262],
            [-88.385606, 47.004522],
            [-88.404498, 46.983353],
            [-88.411145, 46.977984],
            [-88.443901, 46.972251],
            [-88.44857, 46.946769],
            [-88.455404, 46.923321],
            [-88.475859, 46.886042],
            [-88.477935, 46.85056],
            [-88.483748, 46.831727],
            [-88.482579, 46.826197],
            [-88.473342, 46.806226],
            [-88.462349, 46.786711],
            [-88.438427, 46.786714],
            [-88.433835, 46.793502],
            [-88.415225, 46.811715],
            [-88.38141, 46.838466],
            [-88.382204, 46.844477],
            [-88.382052, 46.845437],
            [-88.390135, 46.851595],
            [-88.404008, 46.848331],
            [-88.389727, 46.8671],
            [-88.372591, 46.872812],
            [-88.375855, 46.863428],
            [-88.369848, 46.857568],
            [-88.368767, 46.857313],
            [-88.360868, 46.856202],
            [-88.35194, 46.857028],
            [-88.31029, 46.889748],
            [-88.281244, 46.906632],
            [-88.261593, 46.915516],
            [-88.244437, 46.929612],
            [-88.167227, 46.958855],
            [-88.155374, 46.965069],
            [-88.143688, 46.966665],
            [-88.132876, 46.962204],
            [-88.150114, 46.94363],
            [-88.187522, 46.918999],
            [-88.175197, 46.90458],
            [-88.161913, 46.904941],
            [-88.126927, 46.90984],
            [-88.101315, 46.917207],
            [-88.08187, 46.920458],
            [-88.065192, 46.918563],
            [-88.032408, 46.90889],
            [-88.004298, 46.906982],
            [-87.986113, 46.905957],
            [-87.956, 46.909051],
            [-87.900339, 46.909686],
            [-87.874538, 46.892578],
            [-87.846195, 46.883905],
            [-87.841228, 46.884363],
            [-87.827162, 46.889713],
            [-87.816794, 46.891154],
            [-87.813226, 46.888023],
            [-87.793194, 46.880822],
            [-87.782461, 46.879859],
            [-87.77693, 46.876726],
            [-87.776313, 46.872591],
            [-87.778752, 46.870422],
            [-87.776804, 46.866823],
            [-87.765989, 46.861316],
            [-87.755868, 46.860453],
            [-87.746646, 46.865427],
            [-87.741014, 46.865247],
            [-87.73487, 46.85012],
            [-87.736732, 46.847216],
            [-87.734325, 46.836955],
            [-87.731522, 46.831196],
            [-87.727358, 46.827656],
            [-87.713737, 46.825534],
            [-87.69459, 46.827182],
            [-87.685698, 46.83253],
            [-87.68793, 46.839159],
            [-87.687164, 46.841742],
            [-87.680668, 46.842496],
            [-87.674541, 46.836964],
            [-87.673177, 46.827593],
            [-87.674345, 46.82405],
            [-87.672015, 46.820415],
            [-87.662261, 46.815157],
            [-87.65151, 46.812411],
            [-87.641887, 46.813733],
            [-87.6333, 46.812107],
            [-87.628081, 46.805157],
            [-87.607988, 46.788408],
            [-87.595307, 46.78295],
            [-87.590767, 46.753009],
            [-87.582745, 46.730527],
            [-87.573203, 46.720471],
            [-87.523308, 46.688488],
            [-87.524444, 46.677586],
            [-87.503025, 46.647497],
            [-87.49286, 46.642561],
            [-87.467965, 46.635623],
            [-87.466537, 46.631555],
            [-87.467563, 46.626228],
            [-87.464108, 46.614811],
            [-87.451368, 46.605923],
            [-87.442612, 46.602776],
            [-87.411167, 46.601669],
            [-87.403275, 46.595215],
            [-87.383961, 46.59307],
            [-87.381649, 46.580059],
            [-87.392974, 46.572523],
            [-87.392828, 46.570852],
            [-87.382206, 46.553681],
            [-87.375613, 46.54714],
            [-87.3903, 46.542577],
            [-87.393985, 46.533183],
            [-87.38929, 46.524472],
            [-87.381349, 46.517292],
            [-87.366767, 46.507303],
            [-87.351071, 46.500749],
            [-87.310755, 46.492017],
            [-87.258732, 46.488255],
            [-87.202404, 46.490827],
            [-87.175065, 46.497548],
            [-87.12744, 46.494014],
            [-87.107559, 46.496124],
            [-87.09876, 46.503609],
            [-87.077279, 46.515339],
            [-87.046022, 46.519956],
            [-87.029892, 46.525599],
            [-87.017136, 46.53355],
            [-87.008724, 46.532723],
            [-86.976958, 46.526581],
            [-86.964534, 46.516549],
            [-86.962842, 46.509646],
            [-86.94698, 46.484567],
            [-86.946218, 46.479059],
            [-86.949526, 46.476315],
            [-86.947077, 46.472064],
            [-86.927725, 46.464566],
            [-86.903742, 46.466138],
            [-86.889094, 46.458499],
            [-86.883976, 46.450976],
            [-86.883919, 46.441514],
            [-86.875151, 46.43728],
            [-86.850111, 46.434114],
            [-86.837448, 46.434186],
            [-86.816026, 46.437892],
            [-86.810967, 46.449663],
            [-86.808817, 46.460611],
            [-86.803557, 46.466669],
            [-86.787905, 46.477729],
            [-86.768516, 46.479072],
            [-86.750157, 46.479109],
            [-86.735929, 46.475231],
            [-86.731096, 46.47176],
            [-86.730829, 46.468057],
            [-86.710573, 46.444908],
            [-86.70323, 46.439378],
            [-86.698139, 46.438624],
            [-86.686412, 46.454965],
            [-86.688816, 46.463152],
            [-86.686468, 46.471655],
            [-86.683819, 46.498079],
            [-86.696001, 46.50316],
            [-86.701929, 46.511571],
            [-86.709325, 46.543914],
            [-86.695645, 46.555026],
            [-86.678182, 46.561039],
            [-86.675764, 46.557061],
            [-86.670927, 46.556489],
            [-86.656479, 46.558453],
            [-86.652865, 46.560555],
            [-86.62738, 46.53371],
            [-86.629086, 46.518144],
            [-86.632109, 46.508865],
            [-86.63453, 46.504523],
            [-86.641088, 46.500438],
            [-86.645528, 46.492039],
            [-86.646393, 46.485776],
            [-86.636671, 46.478298],
            [-86.627441, 46.47754],
            [-86.620603, 46.483873],
            [-86.618061, 46.489452],
            [-86.612173, 46.493295],
            [-86.609393, 46.492976],
            [-86.606932, 46.478531],
            [-86.609039, 46.470239],
            [-86.586168, 46.463324],
            [-86.557731, 46.487434],
            [-86.524959, 46.505381],
            [-86.495054, 46.524874],
            [-86.484003, 46.535965],
            [-86.481956, 46.542709],
            [-86.469306, 46.551422],
            [-86.45993, 46.551928],
            [-86.44439, 46.548137],
            [-86.437167, 46.54896],
            [-86.390409, 46.563194],
            [-86.34989, 46.578035],
            [-86.188024, 46.654008],
            [-86.161681, 46.669475],
            [-86.138295, 46.672935],
            [-86.119862, 46.657256],
            [-86.112126, 46.655044],
            [-86.099843, 46.654615],
            [-86.074219, 46.657799],
            [-86.036969, 46.667627],
            [-85.995044, 46.673676],
            [-85.95367, 46.676869],
            [-85.924047, 46.684733],
            [-85.877908, 46.690914],
            [-85.841057, 46.688896],
            [-85.794923, 46.681083],
            [-85.750606, 46.677368],
            [-85.714415, 46.677156],
            [-85.668753, 46.680404],
            [-85.624573, 46.678862],
            [-85.587345, 46.674627],
            [-85.542517, 46.674263],
            [-85.50951, 46.675786],
            [-85.482096, 46.680432],
            [-85.369805, 46.713754],
            [-85.289846, 46.744644],
            [-85.25686, 46.75338],
            [-85.173042, 46.763634],
            [-85.063556, 46.757856],
            [-85.036286, 46.760435],
            [-85.00924, 46.769224],
            [-84.989497, 46.772403],
            [-84.964652, 46.772845],
            [-84.954009, 46.771362],
            [-84.95158, 46.769488],
            [-84.987539, 46.745483],
            [-85.007616, 46.728339],
            [-85.020159, 46.712463],
            [-85.027513, 46.697451],
            [-85.030078, 46.684769],
            [-85.028291, 46.675125],
            [-85.035504, 46.625021],
            [-85.037056, 46.600995],
            [-85.035476, 46.581547],
            [-85.031507, 46.568703],
            [-85.029594, 46.554419],
            [-85.027374, 46.553756],
            [-85.025491, 46.546397],
            [-85.027083, 46.543038],
            [-85.045534, 46.537694],
            [-85.052954, 46.532827],
            [-85.056133, 46.52652],
            [-85.054943, 46.51475],
            [-85.049847, 46.503963],
            [-85.033766, 46.48767],
            [-85.025598, 46.483028],
            [-85.015211, 46.479712],
            [-84.969464, 46.47629],
            [-84.955307, 46.480269],
            [-84.947269, 46.487399],
            [-84.937145, 46.489252],
            [-84.934432, 46.480315],
            [-84.921931, 46.469962],
            [-84.915184, 46.467515],
            [-84.893423, 46.465406],
            [-84.87507, 46.466781],
            [-84.861448, 46.46993],
            [-84.849767, 46.460245],
            [-84.843907, 46.448661],
            [-84.829491, 46.444071],
            [-84.800101, 46.446219],
            [-84.769151, 46.453523],
            [-84.723338, 46.468266],
            [-84.689672, 46.483923],
            [-84.678423, 46.487694],
            [-84.65388, 46.48225],
            [-84.63102, 46.484868],
            [-84.616489, 46.47187],
            [-84.607945, 46.456747],
            [-84.584167, 46.43941],
            [-84.573522, 46.427895],
            [-84.551496, 46.418522],
            [-84.503719, 46.43919],
            [-84.493401, 46.440313],
            [-84.479513, 46.432573],
            [-84.471848, 46.434289],
            [-84.462597, 46.44094],
            [-84.455527, 46.453897],
            [-84.455256, 46.462785],
            [-84.463322, 46.467435],
            [-84.445149, 46.489016],
            [-84.420274, 46.501077],
            [-84.394725, 46.499242],
            [-84.37504, 46.508669],
            [-84.373968, 46.509098],
            [-84.343599, 46.507713],
            [-84.337732, 46.505577],
            [-84.325371, 46.500021],
            [-84.293016, 46.492803],
            [-84.275814, 46.492821],
            [-84.265391, 46.494393],
            [-84.264266, 46.495055],
            [-84.254434, 46.500821],
            [-84.226131, 46.53392],
            [-84.193729, 46.53992],
            [-84.177428, 46.52692],
            [-84.166028, 46.52622],
            [-84.153027, 46.52832],
            [-84.146526, 46.531119],
            [-84.139426, 46.532219],
            [-84.128925, 46.530119],
            [-84.123325, 46.520919],
            [-84.117925, 46.517619],
            [-84.111225, 46.504119],
            [-84.125026, 46.470143],
            [-84.146172, 46.41852],
            [-84.138906, 46.372221],
            [-84.119122, 46.337014],
            [-84.106247, 46.321963],
            [-84.119629, 46.315013],
            [-84.115563, 46.268225],
            [-84.097766, 46.256512],
            [-84.108089, 46.241238],
            [-84.118175, 46.233968],
            [-84.125024, 46.232885],
            [-84.134652, 46.23214],
            [-84.14595, 46.224995],
            [-84.14715, 46.224184],
            [-84.14922, 46.223808],
            [-84.150725, 46.223808],
            [-84.151666, 46.224184],
            [-84.152042, 46.224937],
            [-84.15223, 46.226254],
            [-84.152499, 46.227875],
            [-84.159485, 46.233233],
            [-84.182732, 46.23545],
            [-84.219494, 46.231992],
            [-84.233117, 46.224037],
            [-84.249164, 46.206461],
            [-84.245233, 46.192571],
            [-84.247687, 46.17989],
            [-84.251424, 46.175888],
            [-84.221001, 46.163062],
            [-84.196669, 46.16615],
            [-84.177298, 46.183993],
            [-84.17164, 46.181731],
            [-84.125022, 46.180209],
            [-84.114941, 46.174114],
            [-84.113259, 46.16886],
            [-84.100126, 46.15077],
            [-84.095818, 46.147733],
            [-84.089309, 46.146432],
            [-84.060383, 46.146138],
            [-84.026536, 46.131648],
            [-84.031036, 46.123186],
            [-84.038696, 46.12562],
            [-84.0519, 46.11981],
            [-84.061329, 46.113482],
            [-84.069147, 46.103978],
            [-84.072398, 46.09669],
            [-84.071741, 46.092441],
            [-84.066257, 46.087438],
            [-84.051712, 46.079189],
            [-84.027861, 46.054784],
            [-84.006082, 46.044586],
            [-83.989526, 46.032823],
            [-83.963808, 46.027833],
            [-83.95141, 46.029042],
            [-83.943933, 46.031465],
            [-83.939012, 46.029226],
            [-83.93547, 46.020385],
            [-83.931175, 46.017871],
            [-83.908583, 46.011471],
            [-83.900535, 45.998918],
            [-83.896489, 45.989194],
            [-83.898594, 45.97953],
            [-83.901942, 45.97264],
            [-83.903923, 45.96621],
            [-83.916168, 45.955326],
            [-83.921257, 45.958075],
            [-83.952183, 45.965498],
            [-83.985141, 45.967133],
            [-83.996471, 45.961461],
            [-84.000033, 45.948452],
            [-84.017565, 45.959046],
            [-84.080071, 45.970822],
            [-84.090391, 45.967256],
            [-84.10537, 45.972948],
            [-84.107204, 45.977161],
            [-84.111174, 45.978675],
            [-84.140816, 45.975308],
            [-84.17225, 45.966072],
            [-84.17806, 45.969175],
            [-84.238174, 45.967595],
            [-84.254952, 45.956068],
            [-84.330021, 45.956247],
            [-84.353272, 45.941663],
            [-84.376429, 45.931962],
            [-84.428689, 45.958371],
            [-84.437633, 45.97375],
            [-84.443138, 45.977863],
            [-84.463128, 45.968925],
            [-84.480436, 45.977764],
            [-84.483062, 45.982242],
            [-84.482442, 45.985441],
            [-84.484009, 45.98825],
            [-84.507201, 45.991169],
            [-84.514123, 45.987242],
            [-84.514071, 45.971292],
            [-84.525052, 45.968578],
            [-84.532392, 45.969448],
            [-84.534422, 45.972762],
            [-84.534648, 45.978132],
            [-84.530444, 45.991385],
            [-84.533426, 46.00572],
            [-84.540995, 46.019501],
            [-84.544405, 46.02286],
            [-84.563891, 46.032459],
            [-84.581081, 46.031041],
            [-84.586592, 46.026584],
            [-84.609063, 46.026418],
            [-84.647609, 46.049704],
            [-84.656567, 46.052654],
            [-84.66671, 46.050486],
            [-84.675835, 46.046009],
            [-84.687322, 46.03488],
            [-84.692735, 46.027019],
            [-84.6927, 46.016963],
            [-84.686269, 45.979144],
            [-84.684368, 45.977499],
            [-84.685254, 45.973454],
            [-84.687712, 45.97126],
            [-84.703948, 45.970901],
            [-84.723039, 45.967279],
            [-84.730179, 45.961198],
            [-84.738849, 45.945792],
            [-84.73937, 45.941816],
            [-84.733041, 45.932837],
            [-84.718955, 45.927449],
            [-84.713614, 45.920366],
            [-84.713251, 45.916047],
            [-84.734002, 45.907026],
            [-84.721276, 45.873908],
            [-84.715481, 45.865934],
            [-84.701183, 45.853092],
            [-84.702295, 45.850464],
            [-84.706383, 45.848658],
            [-84.720836, 45.848107],
            [-84.722764, 45.846621],
            [-84.725734, 45.837045],
            [-84.746985, 45.835597],
            [-84.792763, 45.858691],
            [-84.831396, 45.872038],
            [-84.838472, 45.881512],
            [-84.837624, 45.889054],
            [-84.842243, 45.898194],
            [-84.852916, 45.900111],
            [-84.873254, 45.909815],
            [-84.879835, 45.915847],
            [-84.902913, 45.923673],
            [-84.917484, 45.93067],
            [-84.937134, 45.955949],
            [-84.973556, 45.986134],
            [-85.003597, 46.00613],
            [-85.01399, 46.010774],
            [-85.055581, 46.023148],
            [-85.088818, 46.028378],
            [-85.102899, 46.032488],
            [-85.130433, 46.046076],
            [-85.140835, 46.049601],
            [-85.152027, 46.050725],
            [-85.19063, 46.047622],
            [-85.197523, 46.044878],
            [-85.222511, 46.060689],
            [-85.266385, 46.065779],
            [-85.287693, 46.072276],
            [-85.316264, 46.086608],
            [-85.335911, 46.092595],
            [-85.356214, 46.092086],
            [-85.366622, 46.086778],
            [-85.381394, 46.082044],
            [-85.393832, 46.095465],
            [-85.412064, 46.101437],
            [-85.426916, 46.101964],
            [-85.441932, 46.095793],
            [-85.442293, 46.093941],
            [-85.440191, 46.092593],
            [-85.44699, 46.085164],
            [-85.480603, 46.096379],
            [-85.5001, 46.09694],
            [-85.512696, 46.094727],
            [-85.52157, 46.091257],
            [-85.540858, 46.079581],
            [-85.603785, 46.030363],
            [-85.617709, 46.008458],
            [-85.648581, 45.983695],
            [-85.654686, 45.973686],
            [-85.663966, 45.967013],
            [-85.697203, 45.960158],
            [-85.724246, 45.965409],
            [-85.743618, 45.965173],
            [-85.770938, 45.971349],
            [-85.790639, 45.977594],
            [-85.810442, 45.980087],
            [-85.817558, 45.979447],
            [-85.825819, 45.976292],
            [-85.832603, 45.967742],
            [-85.842404, 45.965247],
            [-85.861157, 45.968167],
            [-85.882442, 45.96862],
            [-85.893196, 45.967253],
            [-85.9091, 45.959074],
            [-85.922737, 45.948287],
            [-85.926213, 45.938093],
            [-85.926017, 45.932104],
            [-85.917238, 45.927782],
            [-85.910264, 45.922112],
            [-85.913769, 45.919439],
            [-85.920581, 45.920994],
            [-85.954063, 45.936629],
            [-85.998868, 45.950968],
            [-86.050956, 45.962205],
            [-86.072067, 45.965313],
            [-86.094753, 45.966704],
            [-86.123567, 45.964748],
            [-86.145714, 45.957372],
            [-86.150173, 45.954494],
            [-86.159415, 45.953765],
            [-86.196618, 45.963185],
            [-86.208255, 45.962978],
            [-86.220546, 45.958883],
            [-86.22906, 45.94857],
            [-86.233613, 45.945802],
            [-86.248008, 45.944849],
            [-86.254768, 45.94864],
            [-86.278007, 45.942057],
            [-86.315981, 45.915247],
            [-86.324232, 45.90608],
            [-86.332625, 45.851813],
            [-86.349134, 45.83416],
            [-86.355062, 45.805355],
            [-86.351658, 45.798132],
            [-86.363808, 45.790057],
            [-86.369918, 45.789254],
            [-86.395809, 45.78974],
            [-86.401656, 45.795412],
            [-86.415971, 45.793793],
            [-86.424828, 45.789747],
            [-86.428423, 45.785587],
            [-86.428946, 45.782524],
            [-86.427183, 45.77905],
            [-86.428294, 45.77562],
            [-86.431921, 45.767756],
            [-86.439661, 45.760669],
            [-86.455534, 45.75685],
            [-86.466039, 45.759741],
            [-86.47905, 45.757416],
            [-86.486028, 45.746608],
            [-86.496251, 45.749255],
            [-86.504216, 45.75423],
            [-86.51457, 45.752337],
            [-86.518281, 45.747688],
            [-86.523197, 45.736498],
            [-86.525166, 45.720797],
            [-86.53328, 45.710849],
            [-86.537258, 45.708361],
            [-86.54143, 45.70811],
            [-86.570627, 45.716412],
            [-86.580936, 45.71192],
            [-86.585847, 45.704922],
            [-86.584771, 45.682007],
            [-86.587528, 45.666456],
            [-86.593613, 45.665625],
            [-86.611306, 45.669733],
            [-86.62043, 45.667098],
            [-86.625132, 45.663819],
            [-86.627938, 45.659293],
            [-86.616972, 45.620581],
            [-86.60418, 45.606457],
            [-86.613803, 45.599583],
            [-86.616893, 45.606796],
            [-86.62387, 45.613262],
            [-86.633224, 45.618249],
            [-86.648439, 45.615992],
            [-86.666127, 45.621689],
            [-86.687208, 45.634253],
            [-86.688772, 45.639969],
            [-86.695275, 45.648175],
            [-86.708038, 45.649202],
            [-86.717828, 45.668106],
            [-86.718191, 45.67732],
            [-86.715781, 45.683949],
            [-86.705184, 45.690901],
            [-86.689102, 45.687862],
            [-86.676184, 45.691862],
            [-86.665677, 45.702217],
            [-86.665511, 45.70903],
            [-86.669263, 45.71086],
            [-86.67148, 45.72053],
            [-86.662762, 45.728964],
            [-86.647319, 45.732618],
            [-86.633138, 45.747654],
            [-86.634902, 45.763536],
            [-86.631018, 45.782019],
            [-86.617336, 45.783538],
            [-86.612137, 45.779356],
            [-86.597661, 45.775385],
            [-86.583391, 45.778242],
            [-86.576869, 45.788502],
            [-86.581071, 45.791802],
            [-86.581759, 45.794797],
            [-86.576858, 45.801473],
            [-86.571172, 45.805452],
            [-86.563392, 45.804469],
            [-86.557215, 45.808172],
            [-86.555547, 45.813499],
            [-86.559044, 45.822323],
            [-86.555186, 45.831696],
            [-86.549723, 45.836039],
            [-86.545602, 45.836495],
            [-86.538831, 45.840083],
            [-86.529208, 45.853043],
            [-86.528224, 45.856974],
            [-86.529573, 45.874974],
            [-86.532989, 45.882665],
            [-86.541464, 45.890234],
            [-86.553608, 45.896476],
            [-86.567719, 45.9005],
            [-86.583304, 45.898784],
            [-86.593184, 45.88511],
            [-86.603293, 45.876626],
            [-86.613536, 45.875982],
            [-86.625736, 45.868295],
            [-86.633168, 45.860068],
            [-86.632478, 45.843309],
            [-86.645998, 45.833888],
            [-86.721113, 45.845431],
            [-86.72852, 45.848759],
            [-86.742466, 45.864719],
            [-86.749638, 45.867796],
            [-86.758449, 45.867274],
            [-86.78208, 45.860195],
            [-86.784177, 45.854641],
            [-86.782259, 45.82995],
            [-86.777225, 45.827183],
            [-86.774612, 45.821696],
            [-86.773279, 45.811385],
            [-86.785722, 45.794517],
            [-86.805524, 45.791275],
            [-86.801476, 45.780027],
            [-86.821523, 45.770356],
            [-86.823743, 45.765486],
            [-86.820868, 45.760776],
            [-86.821814, 45.757164],
            [-86.838658, 45.741831],
            [-86.841818, 45.729051],
            [-86.838746, 45.722307],
            [-86.870392, 45.710087],
            [-86.876904, 45.711891],
            [-86.895342, 45.711464],
            [-86.904089, 45.709546],
            [-86.92106, 45.697868],
            [-86.944158, 45.695833],
            [-86.964275, 45.672761],
            [-86.966885, 45.675001],
            [-86.967315, 45.684923],
            [-86.969765, 45.691895],
            [-86.981349, 45.696463],
            [-86.984588, 45.705812],
            [-86.982413, 45.719873],
            [-86.977655, 45.728768],
            [-86.975224, 45.75313],
            [-86.981341, 45.76616],
            [-86.981624, 45.792221],
            [-86.988438, 45.810621],
            [-87.00508, 45.831718],
            [-87.018902, 45.838886],
            [-87.031435, 45.837238],
            [-87.039842, 45.834245],
            [-87.052043, 45.821879],
            [-87.057439, 45.812483],
            [-87.058844, 45.80151],
            [-87.058127, 45.779152],
            [-87.063975, 45.76651],
            [-87.064302, 45.758828],
            [-87.062406, 45.753296],
            [-87.05555, 45.751535],
            [-87.052908, 45.747983],
            [-87.057444, 45.736822],
            [-87.061721, 45.732821],
            [-87.070442, 45.718779],
            [-87.059533, 45.708497],
            [-87.095455, 45.701039],
            [-87.099401, 45.698614],
            [-87.099725, 45.695231],
            [-87.111638, 45.685905],
            [-87.129412, 45.68171],
            [-87.172241, 45.661788],
            [-87.196852, 45.636275],
            [-87.223647, 45.599338],
            [-87.234612, 45.588817],
            [-87.263488, 45.552032],
            [-87.288726, 45.501606],
            [-87.306122, 45.475513],
            [-87.319703, 45.464929],
            [-87.333147, 45.447208],
            [-87.334249, 45.442315],
            [-87.33324, 45.436897],
            [-87.329958, 45.431937],
            [-87.325834, 45.43004],
            [-87.327749, 45.425307],
            [-87.336152, 45.41536],
            [-87.350852, 45.407743],
            [-87.359512, 45.399829],
            [-87.364368, 45.388532],
            [-87.3925, 45.369028],
            [-87.399973, 45.349322],
            [-87.431684, 45.316383],
            [-87.437257, 45.3055],
            [-87.438908, 45.293405],
            [-87.465201, 45.273351],
            [-87.512336, 45.224252],
            [-87.548964, 45.191591],
            [-87.563417, 45.18407],
            [-87.585651, 45.166394],
            [-87.600796, 45.146842],
            [-87.60928, 45.13232],
            [-87.612019, 45.123377],
            [-87.610073, 45.114141],
            [-87.60012, 45.103011],
            [-87.59027, 45.096406],
            [-87.581969, 45.097206],
            [-87.590208, 45.095264],
          ],
        ],
        [
          [
            [-86.033174, 45.15842],
            [-86.005946, 45.155751],
            [-85.993194, 45.152805],
            [-85.989412, 45.151069],
            [-85.976803, 45.138363],
            [-85.976434, 45.120706],
            [-85.980433, 45.113046],
            [-85.984095, 45.087073],
            [-85.982799, 45.080787],
            [-85.977082, 45.072993],
            [-85.96059, 45.062223],
            [-85.95976, 45.058486],
            [-85.976883, 45.06266],
            [-85.99736, 45.055929],
            [-86.013073, 45.063774],
            [-86.019874, 45.071665],
            [-86.037129, 45.086576],
            [-86.052424, 45.095311],
            [-86.058653, 45.100776],
            [-86.060396, 45.104617],
            [-86.065016, 45.140266],
            [-86.059393, 45.152291],
            [-86.050473, 45.158418],
            [-86.04443, 45.159582],
            [-86.033174, 45.15842],
          ],
        ],
        [
          [
            [-86.093536, 45.007838],
            [-86.115699, 44.999093],
            [-86.133655, 44.996874],
            [-86.154824, 45.002394],
            [-86.156689, 45.010535],
            [-86.154557, 45.018102],
            [-86.141644, 45.040251],
            [-86.138095, 45.043038],
            [-86.117908, 45.048478],
            [-86.093166, 45.041492],
            [-86.079103, 45.030795],
            [-86.093451, 45.03166],
            [-86.097094, 45.030128],
            [-86.100315, 45.02624],
            [-86.101894, 45.022811],
            [-86.101214, 45.018101],
            [-86.093536, 45.007838],
          ],
        ],
        [
          [
            [-82.415937, 43.005555],
            [-82.422586, 43.000029],
            [-82.424206, 42.996938],
            [-82.42455, 42.993393],
            [-82.423086, 42.988728],
            [-82.420346, 42.984451],
            [-82.412965, 42.977041],
            [-82.416737, 42.966613],
            [-82.428603, 42.952001],
            [-82.447142, 42.937752],
            [-82.455027, 42.926866],
            [-82.46404, 42.901456],
            [-82.469912, 42.887459],
            [-82.470032, 42.881421],
            [-82.46822, 42.859107],
            [-82.468961, 42.852314],
            [-82.472681, 42.836784],
            [-82.47864, 42.825187],
            [-82.482045, 42.808629],
            [-82.481576, 42.805519],
            [-82.480394, 42.802272],
            [-82.471159, 42.784002],
            [-82.467394, 42.769298],
            [-82.467483, 42.76191],
            [-82.483604, 42.733624],
            [-82.48387, 42.71798],
            [-82.494491, 42.700823],
            [-82.510533, 42.665172],
            [-82.509935, 42.637294],
            [-82.518782, 42.613888],
            [-82.523337, 42.607486],
            [-82.548169, 42.591848],
            [-82.549717, 42.590338],
            [-82.554236, 42.583981],
            [-82.555938, 42.582425],
            [-82.569801, 42.573551],
            [-82.57738, 42.567078],
            [-82.579205, 42.56534],
            [-82.583996, 42.554041],
            [-82.589779, 42.550678],
            [-82.604686, 42.548592],
            [-82.607068, 42.548843],
            [-82.611059, 42.550419],
            [-82.616848, 42.554601],
            [-82.624907, 42.557229],
            [-82.633491, 42.557051],
            [-82.640916, 42.554973],
            [-82.64268, 42.554333],
            [-82.648776, 42.550401],
            [-82.661677, 42.541875],
            [-82.666596, 42.535084],
            [-82.679059, 42.52221],
            [-82.686417, 42.518597],
            [-82.685397, 42.528659],
            [-82.679522, 42.53552],
            [-82.670956, 42.537989],
            [-82.664335, 42.546244],
            [-82.680758, 42.557909],
            [-82.681036, 42.574695],
            [-82.688061, 42.588417],
            [-82.701152, 42.585991],
            [-82.711151, 42.590884],
            [-82.713042, 42.597904],
            [-82.700818, 42.606687],
            [-82.683482, 42.609433],
            [-82.681593, 42.618672],
            [-82.690124, 42.625033],
            [-82.689836, 42.627148],
            [-82.669103, 42.637225],
            [-82.645715, 42.631145],
            [-82.630922, 42.64211],
            [-82.626396, 42.647385],
            [-82.623043, 42.655951],
            [-82.623797, 42.665395],
            [-82.630851, 42.673341],
            [-82.635262, 42.675552],
            [-82.659781, 42.678618],
            [-82.674287, 42.687049],
            [-82.6855, 42.690036],
            [-82.700964, 42.689548],
            [-82.706135, 42.683578],
            [-82.726366, 42.682768],
            [-82.753317, 42.669732],
            [-82.765583, 42.655725],
            [-82.780817, 42.652232],
            [-82.792418, 42.655132],
            [-82.797318, 42.654032],
            [-82.813518, 42.640833],
            [-82.820118, 42.626333],
            [-82.819017, 42.616333],
            [-82.811017, 42.610933],
            [-82.789017, 42.603434],
            [-82.771844, 42.595517],
            [-82.76959, 42.59338],
            [-82.788612, 42.588501],
            [-82.788116, 42.582835],
            [-82.781514, 42.571634],
            [-82.782414, 42.564834],
            [-82.784514, 42.563634],
            [-82.789114, 42.568434],
            [-82.796715, 42.571034],
            [-82.821016, 42.570734],
            [-82.834216, 42.567849],
            [-82.845916, 42.560634],
            [-82.849316, 42.555734],
            [-82.851016, 42.548935],
            [-82.859316, 42.541935],
            [-82.874416, 42.523535],
            [-82.882316, 42.501035],
            [-82.883915, 42.471836],
            [-82.870347, 42.450888],
            [-82.886113, 42.408137],
            [-82.888413, 42.398237],
            [-82.894013, 42.389437],
            [-82.898413, 42.385437],
            [-82.915114, 42.378137],
            [-82.919114, 42.374437],
            [-82.928815, 42.359437],
            [-82.92397, 42.352068],
            [-82.945415, 42.347337],
            [-82.959416, 42.339638],
            [-82.988619, 42.332439],
            [-83.01832, 42.329739],
            [-83.064121, 42.317738],
            [-83.079721, 42.308638],
            [-83.096521, 42.290138],
            [-83.110922, 42.260638],
            [-83.128022, 42.238839],
            [-83.133923, 42.17474],
            [-83.121323, 42.125742],
            [-83.133511, 42.088143],
            [-83.157624, 42.085542],
            [-83.168759, 42.073601],
            [-83.188598, 42.066431],
            [-83.189115, 42.061853],
            [-83.186877, 42.061206],
            [-83.185526, 42.052243],
            [-83.18824, 42.031329],
            [-83.185858, 42.029451],
            [-83.17089, 42.022403],
            [-83.17089, 42.015185],
            [-83.193918, 41.997656],
            [-83.212479, 41.98872],
            [-83.216897, 41.988561],
            [-83.223354, 41.989191],
            [-83.228502, 41.987291],
            [-83.249204, 41.972402],
            [-83.257009, 41.959686],
            [-83.257292, 41.950745],
            [-83.253552, 41.944897],
            [-83.26455, 41.929086],
            [-83.270484, 41.939335],
            [-83.28713, 41.944397],
            [-83.295982, 41.944742],
            [-83.302904, 41.943073],
            [-83.315859, 41.935893],
            [-83.326024, 41.924961],
            [-83.333642, 41.907261],
            [-83.335961, 41.889721],
            [-83.341557, 41.879956],
            [-83.359467, 41.867849],
            [-83.366187, 41.865505],
            [-83.372445, 41.874477],
            [-83.381955, 41.870877],
            [-83.39622, 41.852965],
            [-83.409596, 41.830325],
            [-83.422316, 41.822278],
            [-83.434204, 41.818562],
            [-83.439612, 41.813162],
            [-83.441668, 41.808646],
            [-83.443364, 41.789118],
            [-83.437516, 41.769694],
            [-83.427308, 41.750214],
            [-83.424076, 41.740738],
            [-83.43436, 41.737058],
            [-83.451897, 41.734486],
            [-83.453832, 41.732647],
            [-83.497733, 41.731847],
            [-83.499733, 41.731647],
            [-83.503433, 41.731547],
            [-83.504334, 41.731547],
            [-83.585235, 41.729348],
            [-83.593835, 41.729148],
            [-83.595235, 41.729148],
            [-83.636636, 41.727849],
            [-83.639636, 41.727749],
            [-83.665937, 41.726949],
            [-83.685337, 41.726449],
            [-83.708937, 41.72515],
            [-83.763038, 41.72355],
            [-83.859541, 41.72125],
            [-83.880539, 41.720081],
            [-83.899764, 41.719961],
            [-83.998849, 41.716822],
            [-84.019373, 41.716668],
            [-84.134417, 41.712931],
            [-84.360546, 41.706621],
            [-84.396547, 41.705935],
            [-84.438067, 41.704903],
            [-84.749955, 41.698245],
            [-84.806082, 41.696089],
            [-84.806018, 41.707485],
            [-84.806042, 41.720544],
            [-84.806065, 41.732909],
            [-84.806074, 41.737603],
            [-84.806134, 41.743115],
            [-84.805883, 41.760216],
            [-84.818873, 41.760059],
            [-84.825196, 41.75999],
            [-84.932484, 41.759691],
            [-84.96086, 41.759438],
            [-84.961562, 41.759552],
            [-84.971551, 41.759527],
            [-84.972803, 41.759366],
            [-85.037817, 41.759801],
            [-85.039436, 41.759985],
            [-85.117267, 41.7597],
            [-85.123102, 41.759743],
            [-85.17223, 41.759618],
            [-85.196637, 41.759735],
            [-85.232835, 41.759839],
            [-85.272216, 41.759999],
            [-85.272951, 41.759911],
            [-85.273713, 41.75977],
            [-85.292099, 41.759962],
            [-85.298365, 41.760028],
            [-85.30814, 41.760097],
            [-85.318129, 41.759983],
            [-85.330623, 41.759982],
            [-85.350174, 41.759908],
            [-85.379133, 41.759875],
            [-85.427553, 41.759706],
            [-85.432471, 41.759684],
            [-85.515959, 41.759352],
            [-85.518251, 41.759513],
            [-85.607548, 41.759079],
            [-85.608312, 41.759193],
            [-85.622608, 41.759049],
            [-85.624987, 41.759093],
            [-85.632714, 41.759164],
            [-85.647683, 41.759125],
            [-85.650738, 41.759103],
            [-85.724534, 41.759085],
            [-85.749992, 41.759091],
            [-85.750469, 41.75909],
            [-85.775039, 41.759147],
            [-85.791363, 41.759051],
            [-85.872041, 41.759365],
            [-85.874997, 41.759341],
            [-85.888825, 41.759422],
            [-85.974901, 41.759849],
            [-85.97498, 41.759849],
            [-85.991302, 41.759949],
            [-86.041027, 41.760512],
            [-86.12506, 41.760576],
            [-86.12546, 41.76056],
            [-86.127844, 41.760592],
            [-86.21759, 41.760016],
            [-86.22607, 41.760016],
            [-86.265496, 41.760207],
            [-86.501773, 41.759553],
            [-86.519318, 41.759447],
            [-86.640044, 41.759671],
            [-86.641186, 41.759633],
            [-86.746521, 41.759982],
            [-86.748096, 41.759967],
            [-86.800611, 41.760251],
            [-86.800707, 41.76024],
            [-86.801578, 41.76024],
            [-86.804427, 41.76024],
            [-86.823628, 41.76024],
            [-86.824828, 41.76024],
            [-86.777227, 41.78474],
            [-86.717037, 41.819349],
            [-86.679355, 41.844793],
            [-86.619442, 41.893827],
            [-86.597899, 41.918291],
            [-86.582197, 41.942241],
            [-86.556421, 42.000042],
            [-86.501322, 42.08454],
            [-86.490122, 42.105139],
            [-86.485223, 42.118239],
            [-86.466262, 42.134406],
            [-86.404146, 42.196379],
            [-86.385179, 42.217279],
            [-86.356218, 42.254166],
            [-86.321803, 42.310743],
            [-86.297168, 42.358207],
            [-86.284448, 42.394563],
            [-86.284969, 42.401814],
            [-86.276878, 42.413317],
            [-86.261573, 42.443894],
            [-86.24971, 42.480212],
            [-86.240642, 42.54],
            [-86.23528, 42.564958],
            [-86.228082, 42.583397],
            [-86.225613, 42.594765],
            [-86.22905, 42.637693],
            [-86.226638, 42.644922],
            [-86.21602, 42.664413],
            [-86.208654, 42.69209],
            [-86.206834, 42.719424],
            [-86.208309, 42.762789],
            [-86.210863, 42.783832],
            [-86.211815, 42.833236],
            [-86.210737, 42.859128],
            [-86.214138, 42.883555],
            [-86.216209, 42.919007],
            [-86.226305, 42.988284],
            [-86.232707, 43.015762],
            [-86.244277, 43.049681],
            [-86.250069, 43.057489],
            [-86.250517, 43.066993],
            [-86.254646, 43.083409],
            [-86.280756, 43.136015],
            [-86.316259, 43.195114],
            [-86.39575, 43.316225],
            [-86.407832, 43.338436],
            [-86.435124, 43.396702],
            [-86.448743, 43.432013],
            [-86.468747, 43.491963],
            [-86.479276, 43.515335],
            [-86.520205, 43.576718],
            [-86.529507, 43.593462],
            [-86.538497, 43.617501],
            [-86.540916, 43.633158],
            [-86.540787, 43.644593],
            [-86.538482, 43.658795],
            [-86.529179, 43.677889],
            [-86.510319, 43.698625],
            [-86.481854, 43.725135],
            [-86.461554, 43.746685],
            [-86.445123, 43.771564],
            [-86.437391, 43.789334],
            [-86.431043, 43.815975],
            [-86.431198, 43.84072],
            [-86.433915, 43.855608],
            [-86.445455, 43.889726],
            [-86.447915, 43.918089],
            [-86.463136, 43.970976],
            [-86.483331, 44.001179],
            [-86.501738, 44.021912],
            [-86.508827, 44.032755],
            [-86.514742, 44.04792],
            [-86.514702, 44.058119],
            [-86.508764, 44.067881],
            [-86.500453, 44.075607],
            [-86.446883, 44.10597],
            [-86.429871, 44.119782],
            [-86.421108, 44.12948],
            [-86.400645, 44.156848],
            [-86.380062, 44.189472],
            [-86.362847, 44.208113],
            [-86.351638, 44.229429],
            [-86.343793, 44.249608],
            [-86.327287, 44.263057],
            [-86.316025, 44.28421],
            [-86.300264, 44.308197],
            [-86.26871, 44.345324],
            [-86.251926, 44.400984],
            [-86.248083, 44.420946],
            [-86.24832, 44.434758],
            [-86.251843, 44.451632],
            [-86.251605, 44.465443],
            [-86.248914, 44.483004],
            [-86.243745, 44.488929],
            [-86.238743, 44.501682],
            [-86.223788, 44.549043],
            [-86.220697, 44.566742],
            [-86.22545, 44.59459],
            [-86.231828, 44.609107],
            [-86.25395, 44.64808],
            [-86.259029, 44.663654],
            [-86.256796, 44.686769],
            [-86.254996, 44.691935],
            [-86.248474, 44.699046],
            [-86.232482, 44.70605],
            [-86.172201, 44.720623],
            [-86.160268, 44.728189],
            [-86.121125, 44.727972],
            [-86.106182, 44.731088],
            [-86.089186, 44.741496],
            [-86.077933, 44.758234],
            [-86.073506, 44.769803],
            [-86.071746, 44.804717],
            [-86.065966, 44.821522],
            [-86.066031, 44.834852],
            [-86.071112, 44.86542],
            [-86.072468, 44.884788],
            [-86.07099, 44.895876],
            [-86.066745, 44.905685],
            [-86.058862, 44.911012],
            [-86.038332, 44.915696],
            [-86.031194, 44.907349],
            [-86.021513, 44.902774],
            [-86.009355, 44.899454],
            [-85.992535, 44.900026],
            [-85.980219, 44.906136],
            [-85.972824, 44.914781],
            [-85.967169, 44.929484],
            [-85.961603, 44.935567],
            [-85.952721, 44.940758],
            [-85.942099, 44.954317],
            [-85.938589, 44.964559],
            [-85.9316, 44.968788],
            [-85.915851, 44.968307],
            [-85.897626, 44.962014],
            [-85.891543, 44.957783],
            [-85.879934, 44.943305],
            [-85.869852, 44.939031],
            [-85.854304, 44.938147],
            [-85.83615, 44.940256],
            [-85.815451, 44.945631],
            [-85.807403, 44.949814],
            [-85.780439, 44.977932],
            [-85.778278, 44.983075],
            [-85.776207, 45.000574],
            [-85.771395, 45.015181],
            [-85.761943, 45.023454],
            [-85.746444, 45.051229],
            [-85.740836, 45.055575],
            [-85.712262, 45.065622],
            [-85.695715, 45.076461],
            [-85.681096, 45.092693],
            [-85.675671, 45.10554],
            [-85.674861, 45.116216],
            [-85.656024, 45.145788],
            [-85.618639, 45.186771],
            [-85.613174, 45.184624],
            [-85.611684, 45.181104],
            [-85.606963, 45.178477],
            [-85.593064, 45.178527],
            [-85.585986, 45.180381],
            [-85.564654, 45.192546],
            [-85.561809, 45.200524],
            [-85.551072, 45.210742],
            [-85.540497, 45.210169],
            [-85.526734, 45.189316],
            [-85.531461, 45.177247],
            [-85.536892, 45.173385],
            [-85.552179, 45.167352],
            [-85.56168, 45.15894],
            [-85.554083, 45.142568],
            [-85.558373, 45.133209],
            [-85.564612, 45.137498],
            [-85.564612, 45.147247],
            [-85.570178, 45.155145],
            [-85.573893, 45.155488],
            [-85.590434, 45.153175],
            [-85.599801, 45.149286],
            [-85.614319, 45.127562],
            [-85.609266, 45.11351],
            [-85.595029, 45.103962],
            [-85.597496, 45.094454],
            [-85.583198, 45.071304],
            [-85.573353, 45.068382],
            [-85.566066, 45.059201],
            [-85.56613, 45.043633],
            [-85.57016, 45.041278],
            [-85.573976, 45.043361],
            [-85.597181, 45.040547],
            [-85.599652, 45.021749],
            [-85.609123, 45.013103],
            [-85.621878, 45.004529],
            [-85.606588, 44.990662],
            [-85.604301, 44.990983],
            [-85.602356, 44.974272],
            [-85.602034, 44.926743],
            [-85.621403, 44.923123],
            [-85.625497, 44.921107],
            [-85.639842, 44.890255],
            [-85.645456, 44.883645],
            [-85.648932, 44.87401],
            [-85.652355, 44.849092],
            [-85.651435, 44.831624],
            [-85.641652, 44.810816],
            [-85.637, 44.790078],
            [-85.640781, 44.775561],
            [-85.636097, 44.771329],
            [-85.627982, 44.767508],
            [-85.610776, 44.76516],
            [-85.599256, 44.765919],
            [-85.593571, 44.768783],
            [-85.590985, 44.783914],
            [-85.581717, 44.807784],
            [-85.545891, 44.864024],
            [-85.532931, 44.87319],
            [-85.530649, 44.889763],
            [-85.553509, 44.890924],
            [-85.559524, 44.888113],
            [-85.564509, 44.895246],
            [-85.539703, 44.916779],
            [-85.533553, 44.925762],
            [-85.520205, 44.960347],
            [-85.5221, 44.966727],
            [-85.520034, 44.973996],
            [-85.4926, 44.989834],
            [-85.475204, 44.991053],
            [-85.470462, 44.980745],
            [-85.464944, 44.961062],
            [-85.46665, 44.958844],
            [-85.472258, 44.959391],
            [-85.48574, 44.953626],
            [-85.491286, 44.927585],
            [-85.49249, 44.90822],
            [-85.488624, 44.901707],
            [-85.498007, 44.865451],
            [-85.502182, 44.855802],
            [-85.508617, 44.847872],
            [-85.519096, 44.845339],
            [-85.539924, 44.834166],
            [-85.555894, 44.818256],
            [-85.560231, 44.810072],
            [-85.560488, 44.789679],
            [-85.576566, 44.760208],
            [-85.571301, 44.755293],
            [-85.554326, 44.748744],
            [-85.538285, 44.746821],
            [-85.527216, 44.748235],
            [-85.504775, 44.768082],
            [-85.503935, 44.772951],
            [-85.505244, 44.781594],
            [-85.509251, 44.787334],
            [-85.499591, 44.803838],
            [-85.474796, 44.814959],
            [-85.462916, 44.825067],
            [-85.460445, 44.835667],
            [-85.425804, 44.881646],
            [-85.423003, 44.895019],
            [-85.406173, 44.911773],
            [-85.3958, 44.931018],
            [-85.378286, 44.998587],
            [-85.381654, 45.018407],
            [-85.380659, 45.046319],
            [-85.377586, 45.055713],
            [-85.366412, 45.069023],
            [-85.366908, 45.116938],
            [-85.372571, 45.126241],
            [-85.376948, 45.142881],
            [-85.380464, 45.180876],
            [-85.386726, 45.189497],
            [-85.388593, 45.23524],
            [-85.371593, 45.270834],
            [-85.355478, 45.282774],
            [-85.335016, 45.294027],
            [-85.323941, 45.303355],
            [-85.307646, 45.31314],
            [-85.294848, 45.316408],
            [-85.289568, 45.314052],
            [-85.273789, 45.315443],
            [-85.262996, 45.319507],
            [-85.25505, 45.325675],
            [-85.252193, 45.330863],
            [-85.235629, 45.339374],
            [-85.209673, 45.356937],
            [-85.196704, 45.360641],
            [-85.182471, 45.360824],
            [-85.143651, 45.370369],
            [-85.054805, 45.364091],
            [-85.043101, 45.361506],
            [-85.032813, 45.361251],
            [-85.022234, 45.366701],
            [-84.959119, 45.375973],
            [-84.91585, 45.393115],
            [-84.912537, 45.402828],
            [-84.912956, 45.409776],
            [-84.916165, 45.417639],
            [-84.922006, 45.421914],
            [-84.980953, 45.429382],
            [-84.990041, 45.427618],
            [-84.990785, 45.425264],
            [-84.983836, 45.420764],
            [-84.977116, 45.420035],
            [-84.978608, 45.418663],
            [-85.040936, 45.436701],
            [-85.069573, 45.459239],
            [-85.088386, 45.476928],
            [-85.109252, 45.521626],
            [-85.115479, 45.539406],
            [-85.119737, 45.569026],
            [-85.118637, 45.575175],
            [-85.111909, 45.585829],
            [-85.093525, 45.600121],
            [-85.079528, 45.617083],
            [-85.075686, 45.623688],
            [-85.07491, 45.629242],
            [-85.061488, 45.639505],
            [-85.015341, 45.651564],
            [-85.007026, 45.65636],
            [-85.001154, 45.661225],
            [-84.996336, 45.669685],
            [-84.992958, 45.679983],
            [-84.987847, 45.682997],
            [-84.975768, 45.683174],
            [-84.97095, 45.686334],
            [-84.943756, 45.71029],
            [-84.940526, 45.721832],
            [-84.942125, 45.72846],
            [-84.95084, 45.736893],
            [-84.982328, 45.75196],
            [-85.002914, 45.75394],
            [-85.048441, 45.760807],
            [-85.074563, 45.762182],
            [-85.077313, 45.765619],
            [-85.049129, 45.770431],
            [-85.030568, 45.769056],
            [-85.00741, 45.763168],
            [-84.995105, 45.759855],
            [-84.938312, 45.759892],
            [-84.924664, 45.756897],
            [-84.910398, 45.75001],
            [-84.866976, 45.752066],
            [-84.840981, 45.744751],
            [-84.806642, 45.746171],
            [-84.799558, 45.74713],
            [-84.788821, 45.752283],
            [-84.781373, 45.76108],
            [-84.7798, 45.76965],
            [-84.792337, 45.778497],
            [-84.793153, 45.780463],
            [-84.780313, 45.787224],
            [-84.772765, 45.789301],
            [-84.751571, 45.782733],
            [-84.742, 45.784134],
            [-84.734065, 45.788205],
            [-84.726192, 45.786905],
            [-84.718904, 45.777599],
            [-84.715996, 45.766174],
            [-84.681967, 45.756197],
            [-84.679546, 45.749095],
            [-84.644822, 45.73999],
            [-84.604712, 45.721668],
            [-84.573631, 45.710381],
            [-84.555496, 45.702268],
            [-84.553311, 45.698566],
            [-84.538998, 45.690383],
            [-84.46168, 45.652404],
            [-84.442348, 45.654771],
            [-84.435415, 45.664106],
            [-84.427495, 45.669201],
            [-84.413642, 45.669427],
            [-84.400283, 45.663345],
            [-84.376403, 45.655565],
            [-84.329537, 45.66438],
            [-84.289685, 45.653296],
            [-84.270238, 45.64479],
            [-84.215268, 45.634767],
            [-84.196043, 45.621456],
            [-84.180514, 45.604639],
            [-84.157121, 45.585305],
            [-84.139462, 45.573714],
            [-84.128867, 45.562284],
            [-84.126532, 45.556616],
            [-84.126971, 45.542428],
            [-84.122309, 45.523788],
            [-84.116687, 45.51305],
            [-84.109238, 45.505171],
            [-84.095905, 45.497298],
            [-84.075792, 45.490537],
            [-84.056138, 45.489349],
            [-84.039958, 45.493733],
            [-84.036286, 45.496245],
            [-84.028813, 45.497225],
            [-84.009582, 45.495069],
            [-83.99835, 45.491158],
            [-83.978017, 45.494138],
            [-83.939261, 45.493189],
            [-83.909472, 45.485784],
            [-83.881813, 45.467907],
            [-83.85856, 45.446865],
            [-83.841543, 45.435287],
            [-83.806622, 45.419159],
            [-83.788777, 45.416415],
            [-83.773171, 45.417302],
            [-83.755569, 45.411034],
            [-83.737321, 45.410943],
            [-83.721815, 45.413304],
            [-83.697316, 45.396239],
            [-83.667934, 45.384675],
            [-83.64379, 45.37171],
            [-83.599273, 45.352561],
            [-83.570361, 45.347198],
            [-83.550268, 45.350832],
            [-83.546799, 45.352637],
            [-83.545729, 45.358397],
            [-83.538306, 45.358167],
            [-83.520258, 45.347239],
            [-83.514717, 45.34646],
            [-83.496704, 45.357536],
            [-83.488826, 45.355872],
            [-83.477794, 45.341891],
            [-83.445672, 45.310612],
            [-83.43304, 45.303688],
            [-83.42514, 45.296808],
            [-83.422389, 45.290775],
            [-83.401091, 45.279572],
            [-83.388274, 45.276916],
            [-83.385104, 45.274195],
            [-83.381743, 45.268983],
            [-83.388034, 45.254976],
            [-83.412569, 45.245807],
            [-83.41241, 45.238905],
            [-83.405914, 45.227157],
            [-83.384265, 45.203472],
            [-83.381647, 45.203357],
            [-83.368896, 45.182168],
            [-83.368046, 45.172478],
            [-83.363678, 45.166469],
            [-83.359895, 45.16302],
            [-83.348684, 45.161516],
            [-83.337822, 45.14712],
            [-83.316118, 45.141958],
            [-83.315924, 45.139992],
            [-83.319315, 45.137684],
            [-83.318442, 45.12893],
            [-83.30788, 45.099093],
            [-83.298275, 45.090483],
            [-83.290827, 45.069157],
            [-83.291346, 45.062597],
            [-83.280272, 45.045962],
            [-83.277037, 45.044767],
            [-83.271464, 45.038114],
            [-83.265896, 45.026844],
            [-83.271506, 45.023417],
            [-83.287974, 45.026462],
            [-83.302153, 45.032315],
            [-83.340257, 45.041545],
            [-83.357609, 45.050613],
            [-83.36747, 45.062268],
            [-83.399255, 45.070364],
            [-83.433798, 45.057616],
            [-83.442052, 45.051056],
            [-83.453363, 45.035331],
            [-83.454168, 45.03188],
            [-83.446342, 45.016655],
            [-83.435249, 45.011883],
            [-83.431254, 45.007998],
            [-83.435822, 45.000012],
            [-83.438948, 45.000011],
            [-83.450013, 44.990219],
            [-83.443718, 44.952247],
            [-83.438856, 44.940843],
            [-83.433032, 44.93289],
            [-83.425311, 44.926741],
            [-83.404596, 44.918761],
            [-83.398879, 44.906417],
            [-83.39396, 44.903056],
            [-83.352815, 44.886164],
            [-83.320503, 44.880571],
            [-83.312903, 44.884191],
            [-83.314966, 44.86838],
            [-83.321241, 44.852962],
            [-83.314429, 44.84222],
            [-83.300648, 44.829831],
            [-83.299736, 44.823359],
            [-83.290906, 44.807888],
            [-83.295718, 44.784516],
            [-83.288844, 44.765955],
            [-83.298287, 44.754907],
            [-83.2973, 44.746134],
            [-83.290665, 44.729265],
            [-83.284128, 44.721766],
            [-83.273393, 44.713901],
            [-83.276836, 44.689354],
            [-83.289442, 44.652968],
            [-83.307504, 44.629816],
            [-83.314517, 44.608725],
            [-83.315603, 44.595079],
            [-83.313649, 44.564588],
            [-83.308918, 44.54836],
            [-83.308471, 44.539902],
            [-83.318279, 44.514416],
            [-83.31761, 44.486058],
            [-83.326824, 44.444411],
            [-83.327171, 44.429234],
            [-83.324616, 44.415039],
            [-83.321553, 44.409119],
            [-83.321648, 44.404502],
            [-83.333757, 44.372486],
            [-83.335248, 44.357995],
            [-83.332533, 44.340464],
            [-83.336988, 44.332919],
            [-83.343738, 44.329763],
            [-83.352115, 44.332366],
            [-83.364312, 44.33259],
            [-83.373607, 44.327784],
            [-83.401822, 44.301831],
            [-83.414301, 44.294543],
            [-83.419236, 44.2878],
            [-83.425762, 44.272487],
            [-83.445176, 44.252823],
            [-83.465111, 44.245949],
            [-83.442731, 44.265361],
            [-83.445805, 44.273378],
            [-83.463049, 44.278838],
            [-83.479531, 44.28009],
            [-83.500392, 44.27661],
            [-83.508839, 44.273711],
            [-83.524817, 44.261558],
            [-83.53771, 44.248171],
            [-83.549096, 44.227282],
            [-83.552872, 44.210718],
            [-83.553834, 44.197956],
            [-83.567744, 44.155899],
            [-83.568915, 44.126734],
            [-83.567714, 44.119652],
            [-83.573071, 44.101298],
            [-83.588004, 44.086758],
            [-83.591361, 44.079237],
            [-83.590437, 44.069569],
            [-83.58409, 44.056748],
            [-83.601173, 44.054686],
            [-83.621078, 44.056186],
            [-83.650116, 44.052404],
            [-83.679654, 44.036365],
            [-83.687892, 44.020709],
            [-83.680108, 43.994196],
            [-83.743806, 43.991529],
            [-83.746779, 43.988807],
            [-83.763774, 43.985158],
            [-83.787863, 43.985279],
            [-83.829077, 43.989095],
            [-83.848276, 43.981594],
            [-83.85493, 43.977067],
            [-83.856128, 43.972632],
            [-83.869406, 43.960719],
            [-83.877694, 43.959235],
            [-83.885328, 43.946691],
            [-83.890145, 43.934672],
            [-83.890912, 43.923314],
            [-83.907388, 43.918062],
            [-83.916815, 43.89905],
            [-83.917875, 43.856509],
            [-83.926345, 43.787398],
            [-83.929375, 43.777091],
            [-83.945426, 43.759946],
            [-83.954792, 43.760932],
            [-83.956021, 43.759286],
            [-83.954347, 43.750647],
            [-83.939297, 43.715369],
            [-83.909479, 43.672622],
            [-83.897078, 43.664022],
            [-83.852076, 43.644922],
            [-83.844118, 43.652896],
            [-83.83816, 43.654384],
            [-83.814674, 43.643022],
            [-83.806774, 43.641221],
            [-83.778919, 43.630056],
            [-83.770693, 43.628691],
            [-83.769886, 43.634924],
            [-83.725793, 43.618691],
            [-83.703446, 43.597646],
            [-83.669795, 43.59079],
            [-83.666052, 43.591292],
            [-83.654192, 43.59929],
            [-83.618602, 43.628891],
            [-83.595579, 43.650249],
            [-83.563157, 43.684564],
            [-83.553707, 43.685432],
            [-83.549044, 43.693798],
            [-83.55147, 43.699901],
            [-83.540187, 43.708746],
            [-83.524837, 43.716948],
            [-83.515853, 43.718157],
            [-83.513461, 43.714607],
            [-83.506657, 43.710907],
            [-83.48007, 43.714636],
            [-83.470053, 43.723418],
            [-83.46508, 43.733843],
            [-83.459628, 43.740931],
            [-83.440171, 43.761694],
            [-83.438878, 43.767135],
            [-83.441591, 43.770175],
            [-83.446752, 43.77186],
            [-83.438311, 43.786846],
            [-83.426068, 43.799915],
            [-83.416378, 43.801034],
            [-83.411453, 43.805033],
            [-83.410663, 43.80773],
            [-83.428481, 43.817907],
            [-83.442917, 43.811033],
            [-83.471788, 43.789723],
            [-83.480725, 43.791786],
            [-83.448416, 43.861902],
            [-83.427794, 43.861215],
            [-83.425732, 43.849529],
            [-83.417483, 43.841967],
            [-83.404422, 43.84128],
            [-83.384487, 43.85434],
            [-83.358869, 43.857395],
            [-83.33227, 43.880522],
            [-83.331788, 43.893901],
            [-83.333532, 43.89852],
            [-83.340976, 43.904541],
            [-83.403047, 43.910709],
            [-83.400985, 43.916208],
            [-83.338067, 43.915687],
            [-83.318656, 43.91762],
            [-83.30569, 43.922489],
            [-83.28231, 43.938031],
            [-83.26898, 43.956132],
            [-83.26185, 43.969021],
            [-83.26153, 43.973525],
            [-83.227093, 43.981003],
            [-83.195688, 43.983137],
            [-83.180618, 43.982109],
            [-83.145407, 43.989441],
            [-83.134881, 43.993147],
            [-83.120659, 44.00095],
            [-83.10782, 44.003245],
            [-83.079297, 44.001079],
            [-83.066026, 44.003366],
            [-83.058741, 44.006224],
            [-83.046577, 44.01571],
            [-83.029868, 44.041175],
            [-83.024604, 44.045174],
            [-82.999283, 44.04651],
            [-82.990728, 44.048846],
            [-82.967439, 44.066138],
            [-82.958688, 44.065774],
            [-82.956658, 44.063306],
            [-82.947368, 44.062187],
            [-82.928884, 44.069389],
            [-82.915976, 44.070503],
            [-82.889831, 44.050952],
            [-82.875889, 44.045046],
            [-82.833103, 44.036851],
            [-82.793205, 44.023247],
            [-82.788298, 44.013712],
            [-82.783198, 44.009366],
            [-82.765018, 44.006845],
            [-82.746255, 43.996037],
            [-82.738992, 43.989506],
            [-82.728528, 43.972615],
            [-82.712235, 43.94961],
            [-82.709839, 43.948226],
            [-82.693505, 43.91798],
            [-82.678642, 43.88373],
            [-82.65545, 43.867883],
            [-82.643166, 43.852468],
            [-82.642899, 43.846419],
            [-82.647467, 43.84449],
            [-82.647784, 43.842684],
            [-82.644345, 43.837539],
            [-82.633641, 43.831224],
            [-82.617955, 43.768596],
            [-82.619079, 43.756088],
            [-82.617213, 43.746788],
            [-82.612224, 43.739771],
            [-82.60483, 43.678884],
            [-82.605783, 43.669489],
            [-82.6005, 43.602935],
            [-82.597911, 43.590016],
            [-82.593785, 43.581467],
            [-82.585654, 43.543969],
            [-82.565691, 43.502904],
            [-82.565505, 43.497063],
            [-82.55354, 43.464111],
            [-82.539517, 43.437539],
            [-82.538578, 43.431594],
            [-82.53993, 43.422378],
            [-82.535627, 43.368062],
            [-82.536794, 43.34851],
            [-82.530128, 43.333805],
            [-82.529416, 43.316243],
            [-82.532396, 43.30577],
            [-82.523086, 43.225361],
            [-82.519123, 43.212737],
            [-82.508881, 43.196748],
            [-82.501656, 43.161656],
            [-82.494194, 43.143736],
            [-82.490614, 43.118172],
            [-82.486042, 43.102486],
            [-82.471053, 43.087581],
            [-82.457221, 43.061285],
            [-82.422768, 43.007956],
            [-82.415937, 43.005555],
          ],
        ],
        [
          [
            [-83.436745, 44.021656],
            [-83.442245, 44.02853],
            [-83.441551, 44.038841],
            [-83.425743, 44.02853],
            [-83.436745, 44.021656],
          ],
        ],
        [
          [
            [-83.414047, 43.877026],
            [-83.427109, 43.877026],
            [-83.436729, 43.882526],
            [-83.43261, 43.885273],
            [-83.414047, 43.877026],
          ],
        ],
        [
          [
            [-87.600342, 47.407711],
            [-87.617531, 47.407711],
            [-87.629898, 47.415272],
            [-87.65052, 47.416649],
            [-87.623718, 47.42696],
            [-87.585907, 47.419399],
            [-87.600342, 47.407711],
          ],
        ],
        [
          [
            [-83.761154, 46.086082],
            [-83.784348, 46.090248],
            [-83.805168, 46.092033],
            [-83.821236, 46.091438],
            [-83.828964, 46.09679],
            [-83.828964, 46.102741],
            [-83.81707, 46.111069],
            [-83.803978, 46.109879],
            [-83.787323, 46.108093],
            [-83.774239, 46.09798],
            [-83.763527, 46.093815],
            [-83.758179, 46.090248],
            [-83.761154, 46.086082],
          ],
        ],
        [
          [
            [-83.97345, 46.065285],
            [-84.003006, 46.079033],
            [-84.012634, 46.08728],
            [-84.00576, 46.097591],
            [-83.987885, 46.103779],
            [-83.974136, 46.073532],
            [-83.97345, 46.065285],
          ],
        ],
        [
          [
            [-83.853355, 46.050987],
            [-83.858116, 46.055149],
            [-83.858116, 46.062885],
            [-83.858711, 46.067047],
            [-83.865845, 46.069427],
            [-83.871201, 46.07597],
            [-83.864059, 46.083702],
            [-83.85276, 46.085487],
            [-83.847404, 46.082516],
            [-83.840271, 46.071808],
            [-83.839081, 46.064072],
            [-83.846214, 46.051582],
            [-83.853355, 46.050987],
          ],
        ],
        [
          [
            [-83.749252, 46.034328],
            [-83.758774, 46.036114],
            [-83.763527, 46.043846],
            [-83.77018, 46.043228],
            [-83.773781, 46.051472],
            [-83.764122, 46.065857],
            [-83.749847, 46.065857],
            [-83.733192, 46.053364],
            [-83.732002, 46.048012],
            [-83.737358, 46.043846],
            [-83.743896, 46.035519],
            [-83.749252, 46.034328],
          ],
        ],
        [
          [
            [-84.638847, 45.955563],
            [-84.640915, 45.971375],
            [-84.639633, 45.977913],
            [-84.634041, 45.980309],
            [-84.613937, 45.973629],
            [-84.60775, 45.967918],
            [-84.608704, 45.964111],
            [-84.619171, 45.957447],
            [-84.638847, 45.955563],
          ],
        ],
        [
          [
            [-84.568253, 45.950787],
            [-84.582527, 45.958874],
            [-84.583954, 45.963634],
            [-84.579674, 45.968391],
            [-84.575386, 45.970299],
            [-84.563492, 45.967442],
            [-84.559212, 45.958401],
            [-84.564919, 45.95126],
            [-84.568253, 45.950787],
          ],
        ],
        [
          [
            [-83.561836, 45.912563],
            [-83.583054, 45.91592],
            [-83.63221, 45.932285],
            [-83.657661, 45.945461],
            [-83.687691, 45.93539],
            [-83.719429, 45.934078],
            [-83.732986, 45.937641],
            [-83.742775, 45.938004],
            [-83.766235, 45.935223],
            [-83.768852, 45.932068],
            [-83.78611, 45.933376],
            [-83.801041, 45.93758],
            [-83.803329, 45.943363],
            [-83.808144, 45.945694],
            [-83.822807, 45.943985],
            [-83.827568, 45.941235],
            [-83.835503, 45.941841],
            [-83.840866, 45.952724],
            [-83.846436, 45.953182],
            [-83.864861, 45.959465],
            [-83.881058, 45.968185],
            [-83.884827, 45.977165],
            [-83.873146, 45.993427],
            [-83.868233, 45.995075],
            [-83.845398, 46.025681],
            [-83.830147, 46.022324],
            [-83.818199, 46.002426],
            [-83.794052, 45.9958],
            [-83.776436, 46.004204],
            [-83.765274, 46.018364],
            [-83.765259, 46.024681],
            [-83.759369, 46.027191],
            [-83.746872, 46.024811],
            [-83.735573, 46.026596],
            [-83.727837, 46.034924],
            [-83.711777, 46.040279],
            [-83.692146, 46.039089],
            [-83.686195, 46.046227],
            [-83.679657, 46.057529],
            [-83.677872, 46.064667],
            [-83.682632, 46.071808],
            [-83.699883, 46.075375],
            [-83.719513, 46.081326],
            [-83.731407, 46.086678],
            [-83.723297, 46.093811],
            [-83.719788, 46.101032],
            [-83.703857, 46.103367],
            [-83.661163, 46.100258],
            [-83.634979, 46.103954],
            [-83.625557, 46.102211],
            [-83.615341, 46.095978],
            [-83.59861, 46.090084],
            [-83.581314, 46.089615],
            [-83.576088, 46.083511],
            [-83.572639, 46.074921],
            [-83.572571, 46.069897],
            [-83.565353, 46.061897],
            [-83.554062, 46.058884],
            [-83.547203, 46.047867],
            [-83.543365, 46.037197],
            [-83.540848, 46.021248],
            [-83.532913, 46.01133],
            [-83.494843, 45.999542],
            [-83.48835, 45.999542],
            [-83.480637, 45.996162],
            [-83.473946, 45.98856],
            [-83.473221, 45.984421],
            [-83.481766, 45.971874],
            [-83.488808, 45.968739],
            [-83.51062, 45.929325],
            [-83.517242, 45.923615],
            [-83.526344, 45.918636],
            [-83.561836, 45.912563],
          ],
        ],
        [
          [
            [-84.861969, 45.851276],
            [-84.88121, 45.860901],
            [-84.87915, 45.868462],
            [-84.861969, 45.860214],
            [-84.861969, 45.851276],
          ],
        ],
        [
          [
            [-84.617607, 45.844925],
            [-84.638428, 45.850872],
            [-84.650917, 45.859798],
            [-84.651512, 45.86277],
            [-84.645561, 45.874668],
            [-84.647346, 45.884186],
            [-84.644974, 45.885376],
            [-84.624153, 45.88002],
            [-84.602142, 45.852062],
            [-84.607491, 45.8479],
            [-84.617607, 45.844925],
          ],
        ],
        [
          [
            [-85.590889, 45.833141],
            [-85.595177, 45.835522],
            [-85.593811, 45.839809],
            [-85.581467, 45.841042],
            [-85.584709, 45.834095],
            [-85.590889, 45.833141],
          ],
        ],
        [
          [
            [-84.595001, 45.821129],
            [-84.609871, 45.82589],
            [-84.613441, 45.834217],
            [-84.612846, 45.836002],
            [-84.596786, 45.833622],
            [-84.58905, 45.827675],
            [-84.589645, 45.821724],
            [-84.595001, 45.821129],
          ],
        ],
        [
          [
            [-85.611832, 45.806015],
            [-85.617538, 45.810776],
            [-85.617538, 45.814106],
            [-85.612305, 45.81601],
            [-85.606598, 45.81506],
            [-85.603264, 45.813156],
            [-85.601837, 45.811253],
            [-85.611832, 45.806015],
          ],
        ],
        [
          [
            [-85.683296, 45.769455],
            [-85.690704, 45.769455],
            [-85.696259, 45.774391],
            [-85.691933, 45.777477],
            [-85.683296, 45.769455],
          ],
        ],
        [
          [
            [-85.377129, 45.769012],
            [-85.396172, 45.774723],
            [-85.394264, 45.77853],
            [-85.379036, 45.789951],
            [-85.379036, 45.802326],
            [-85.377129, 45.812794],
            [-85.370468, 45.818504],
            [-85.360954, 45.817554],
            [-85.35334, 45.806133],
            [-85.351433, 45.795662],
            [-85.359047, 45.776627],
            [-85.377129, 45.769012],
          ],
        ],
        [
          [
            [-85.462578, 45.765865],
            [-85.495575, 45.772739],
            [-85.507263, 45.778236],
            [-85.532013, 45.798172],
            [-85.529259, 45.818108],
            [-85.524445, 45.829792],
            [-85.496948, 45.822231],
            [-85.45433, 45.800236],
            [-85.450203, 45.796677],
            [-85.44783, 45.790134],
            [-85.450203, 45.776451],
            [-85.455559, 45.768719],
            [-85.462578, 45.765865],
          ],
        ],
        [
          [
            [-84.420113, 45.718815],
            [-84.431412, 45.724762],
            [-84.434387, 45.726547],
            [-84.442719, 45.726547],
            [-84.452827, 45.725952],
            [-84.472458, 45.731304],
            [-84.481384, 45.729523],
            [-84.50042, 45.736065],
            [-84.510529, 45.75034],
            [-84.512314, 45.7551],
            [-84.525406, 45.761047],
            [-84.558716, 45.793766],
            [-84.580727, 45.801498],
            [-84.588455, 45.807449],
            [-84.59024, 45.812801],
            [-84.58905, 45.816372],
            [-84.580727, 45.819939],
            [-84.5718, 45.819347],
            [-84.550385, 45.811016],
            [-84.525406, 45.80864],
            [-84.511124, 45.811611],
            [-84.504585, 45.811611],
            [-84.50042, 45.811016],
            [-84.490303, 45.804474],
            [-84.439148, 45.789604],
            [-84.433197, 45.787819],
            [-84.427841, 45.790195],
            [-84.423088, 45.792576],
            [-84.421303, 45.796146],
            [-84.423088, 45.805069],
            [-84.427246, 45.811611],
            [-84.418922, 45.811611],
            [-84.408211, 45.795551],
            [-84.402267, 45.787224],
            [-84.398697, 45.785439],
            [-84.390961, 45.785439],
            [-84.375496, 45.777706],
            [-84.357056, 45.77235],
            [-84.35408, 45.770565],
            [-84.35408, 45.767593],
            [-84.364197, 45.75629],
            [-84.37133, 45.746773],
            [-84.379662, 45.739635],
            [-84.390366, 45.734875],
            [-84.392151, 45.729523],
            [-84.399292, 45.722977],
            [-84.409996, 45.720005],
            [-84.420113, 45.718815],
          ],
        ],
        [
          [
            [-85.672188, 45.696632],
            [-85.696869, 45.69725],
            [-85.696259, 45.712063],
            [-85.69529, 45.724697],
            [-85.701813, 45.73613],
            [-85.68885, 45.747238],
            [-85.651863, 45.743141],
            [-85.649353, 45.722553],
            [-85.672188, 45.696632],
          ],
        ],
        [
          [
            [-85.84375, 45.69046],
            [-85.84375, 45.710209],
            [-85.835114, 45.711445],
            [-85.83326, 45.696632],
            [-85.84375, 45.69046],
          ],
        ],
        [
          [
            [-86.682877, 45.594818],
            [-86.691704, 45.595818],
            [-86.702019, 45.602692],
            [-86.712326, 45.610939],
            [-86.69239, 45.617126],
            [-86.677269, 45.613689],
            [-86.669022, 45.609566],
            [-86.665749, 45.606239],
            [-86.670982, 45.600529],
            [-86.682877, 45.594818],
          ],
        ],
        [
          [
            [-86.636894, 45.542053],
            [-86.648788, 45.543243],
            [-86.654144, 45.555737],
            [-86.661285, 45.574177],
            [-86.661285, 45.582504],
            [-86.658905, 45.586075],
            [-86.654739, 45.587856],
            [-86.644035, 45.58548],
            [-86.62619, 45.573582],
            [-86.620239, 45.562279],
            [-86.622025, 45.556332],
            [-86.630348, 45.546814],
            [-86.636894, 45.542053],
          ],
        ],
        [
          [
            [-86.66069, 45.520042],
            [-86.666641, 45.520042],
            [-86.669609, 45.524208],
            [-86.670204, 45.52956],
            [-86.667236, 45.53194],
            [-86.6595, 45.532536],
            [-86.656525, 45.525993],
            [-86.66069, 45.520042],
          ],
        ],
        [
          [
            [-86.71508, 45.497517],
            [-86.728142, 45.522949],
            [-86.723328, 45.520889],
            [-86.715767, 45.509201],
            [-86.71508, 45.497517],
          ],
        ],
        [
          [
            [-86.758385, 45.476204],
            [-86.782448, 45.487206],
            [-86.782448, 45.506451],
            [-86.774193, 45.511951],
            [-86.756325, 45.50164],
            [-86.758385, 45.476204],
          ],
        ],
        [
          [
            [-85.770958, 45.461353],
            [-85.792961, 45.481976],
            [-85.782646, 45.491596],
            [-85.770958, 45.487473],
            [-85.766838, 45.475788],
            [-85.770958, 45.461353],
          ],
        ],
        [
          [
            [-85.833519, 45.378174],
            [-85.87339, 45.421482],
            [-85.883011, 45.443478],
            [-85.858261, 45.440041],
            [-85.834892, 45.428356],
            [-85.825958, 45.404297],
            [-85.833519, 45.378174],
          ],
        ],
        [
          [
            [-83.322464, 45.186062],
            [-83.338272, 45.189499],
            [-83.334145, 45.199123],
            [-83.31971, 45.194313],
            [-83.322464, 45.186062],
          ],
        ],
        [
          [
            [-83.190582, 45.033356],
            [-83.229767, 45.039539],
            [-83.233894, 45.054665],
            [-83.231827, 45.058102],
            [-83.213959, 45.056728],
            [-83.201584, 45.046413],
            [-83.190582, 45.033356],
          ],
        ],
        [
          [
            [-85.582054, 44.859333],
            [-85.583755, 44.861454],
            [-85.581207, 44.869938],
            [-85.569328, 44.873333],
            [-85.569756, 44.863152],
            [-85.582054, 44.859333],
          ],
        ],
        [
          [
            [-83.829224, 43.662632],
            [-83.831284, 43.669506],
            [-83.821663, 43.677067],
            [-83.816162, 43.672943],
            [-83.816162, 43.666756],
            [-83.829224, 43.662632],
          ],
        ],
      ],
    },
  };

  var multiTriangles = tesselate(multipolygon);

  t.equal(
    multiTriangles.type,
    "FeatureCollection",
    "MultiPolygon returns a FeatureCollection"
  );
  t.equal(
    multiTriangles.features[0].geometry.type,
    "Polygon",
    "contains at least 1 triangle"
  );
  t.equal(
    multiTriangles.features[0].geometry.coordinates[0].length,
    4,
    "triangle is valid"
  );

  t.throws(function () {
    tesselate(point([0, 0]));
  }, /input must be a Polygon or MultiPolygon/);

  t.throws(function () {
    tesselate(featurecollection([]));
  }, /input must be a Polygon or MultiPolygon/);

  t.end();
});
