# New minor release! Turf 4.6.0 🎉

TurfJS releases are being tracked using [Milestones](https://github.com/Turfjs/turf/milestone/10?closed=1).

## Contributors

- @stebogit
- @rowanwins
- @DenisCarriere
- @grundid
- @tcql 
- @thiagoxvo
- @andrewharvey

## 🚀 New Modules

- [`@turf/clean-coords`](https://github.com/Turfjs/turf/tree/master/packages/turf-clean-coords) Removes redundant coordinates from any GeoJSON Geometry.
(PR https://github.com/Turfjs/turf/pull/875 - Author @stebogit)
- [`@turf/interpolate`](https://github.com/Turfjs/turf/tree/master/packages/turf-interpolate) Takes a set of points and estimates their 'property' values on a grid using the [Inverse Distance Weighting (IDW) method.](https://en.wikipedia.org/wiki/Inverse_distance_weighting).
(PR https://github.com/Turfjs/turf/pull/832 - Author @stebogit)
- [`@turf/clusters-dbscan`](https://github.com/Turfjs/turf/tree/master/packages/turf-clusters-dbscan) Takes a set of Points and partition them into clusters according to [DBSCAN's](https://en.wikipedia.org/wiki/DBSCAN) data clustering algorithm.
(PR https://github.com/Turfjs/turf/pull/812 and https://github.com/Turfjs/turf/pull/851 - Author @DenisCarriere)
    > special mention to [this incredibly instructive and fun interactive map](https://github.com/DenisCarriere/turf-example-clusters-dbscan) by @DenisCarriere 😎👏 
- [`@turf/clusters`](https://github.com/Turfjs/turf/tree/master/packages/turf-clusters) Provides `getCluster`, `clusterEach`, and `clusterReduce` functions.
(PR https://github.com/Turfjs/turf/pull/847 - Author @DenisCarriere)
- [`@turf/boolean-point-on-line`](https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-point-on-line) Returns true if a point is on a line. Accepts a optional parameter to ignore the start and end vertices of the linestring.
(PR https://github.com/Turfjs/turf/pull/858 - Author @rowanwins)
- [`@turf/boolean-overlap`](https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-overlap) Takes two features and returns true or false whether or not they overlap, i.e. whether any pair of edges on the two polygons intersect. If there 
are any edge intersections, the polygons overlap.
(PR https://github.com/Turfjs/turf/pull/856 and https://github.com/Turfjs/turf/pull/868 - Author @stebogit @tcql)
- [`@turf/boolean-equal`](https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-equal) Determine whether two geometries of the same type have identical X,Y coordinate values.
(PR https://github.com/Turfjs/turf/pull/869 - Author @stebogit @tcql)

## 🏅 New Features/Enhancements

- Sets `centered` param default to `true` in [`@turf/point-grid`](https://github.com/Turfjs/turf/tree/master/packages/turf-point-grid) 
(PR https://github.com/Turfjs/turf/pull/836 - Contributor @stebogit)
- Adds `MultiLineString` support for [`@turf/point-on-line`](https://github.com/Turfjs/turf/tree/master/packages/turf-point-on-line) 
(PR https://github.com/Turfjs/turf/pull/838 - Contributor @stebogit)
- Renames `@turf/clusters` => `@turf/clusters-kmeans`, plus adds deprecated warning message to `@turf/clusters@4.5.2`
(See Issue https://github.com/Turfjs/turf/issues/845)
- Changes output type of `@turf/clusters-kmeans`
(See Issue https://github.com/Turfjs/turf/issues/850 - Contributor @DenisCarriere)
- Adds `segmentEach` and `segmentReduce` functions to `@turf/meta`
(See Issue https://github.com/Turfjs/turf/issues/850 - Contributor @DenisCarriere)
- Adds tests and linting on JSDoc in TurfJS core from `turf-www`; see Issue https://github.com/Turfjs/turf/issues/859
(PR https://github.com/Turfjs/turf/issues/857 + https://github.com/Turfjs/turf/issues/864 + https://github.com/Turfjs/turf/issues/870 - Contributor @DenisCarriere @stebogit)
- Introduces `null` Geometry support across TurfJS modules (See Issue https://github.com/Turfjs/turf/issues/853)
(PR https://github.com/Turfjs/turf/issues/866 - Contributor @DenisCarriere)
- Includes feature(Sub)Index in `coordEach`/`coordReduce` (@turf/meta) 🎉
(PR https://github.com/Turfjs/turf/issues/872 - Contributor @DenisCarriere)
- Adds `bbox` and `id` params plus `geometry` method to `@turf/helpers`
(PR https://github.com/Turfjs/turf/issues/877 - Contributor @DenisCarriere)


## 🐛 Bug Fixes

- Applies `@turf/truncate` to [`@turf/line-split`](https://github.com/Turfjs/turf/tree/master/packages/turf-line-split) 
`splitter` input to avoid approximation errors. Fixed #852 
(PR https://github.com/Turfjs/turf/pull/855)
- Fixes `@turf-mask` error (See Issue https://github.com/Turfjs/turf/issues/837)
(PR https://github.com/Turfjs/turf/pull/865 - Contributor @thiagoxvo)
- Fixes `create-new-module` script error on `LICENSE` file creation (See Issue https://github.com/Turfjs/turf/issues/861)
(commit [df6986e](https://github.com/Turfjs/turf/commit/df6986ec0a5c353babb60836ec97c21923913e79))
- Fixes `@turf/isobands` error on `commonProperties` (See Issue https://github.com/Turfjs/turf/issues/831)
(commit [1663f07](https://github.com/Turfjs/turf/commit/1663f077c075c8902dbeff4acf68b1c8e0151853))

Twitter: <Tweet>
CC: @Turfjs/ownership 
