# New minor release! Turf 4.7.0 🎉

TurfJS releases are being tracked using [Milestones](https://github.com/Turfjs/turf/milestone/11?closed=1).

## Contributors

- @stebogit
- @rowanwins
- @DenisCarriere
- @tjdett
- @vicvolk

## 🚀 New Modules
### [`@turf/projection`][projection]
- **toMercator**: Converts a WGS84 GeoJSON object into Mercator (EPSG:900913) projection
- **toWgs84**: Converts a Mercator (EPSG:900913) GeoJSON object into WGS84 projection

(PR https://github.com/Turfjs/turf/pull/927 - Author @stebogit)

### [`@turf/point-to-line-distance`][point-to-line-distance]

Returns the minimum distance between a {@link Point} and a {@link LineString}, being the distance from a line the minimum distance between the point and any segment of the `LineString`.

(PR https://github.com/Turfjs/turf/pull/925 - Author @stebogit)

### [`@turf/boolean-within`][boolean-within]

Boolean-within returns true if the first geometry is completely within the second geometry. The interiors of both geometries must intersect and, the interior and boundary of the primary (geometry a) must not intersect the exterior of the secondary (geometry b). Boolean-within returns the exact opposite result of the [`@turf/boolean-contains`][boolean-contains].

(PR https://github.com/Turfjs/turf/pull/924 - Author @rowanwins)

## 🏅 New Features/Enhancements
- Updates [`@turf/unkink-polygon`][unkink-polygon] testing & added `flattenEach` instead of using `flatten`.
(PR https://github.com/Turfjs/turf/pull/889)
- [`@turf/concave`][concave] refactoring, replacing [`@turf/union`][union] with `geojson-dissolve` to increase speed and added support to `null` geometries
(PR https://github.com/Turfjs/turf/pull/907 - Contributor @stebogit @DenisCarriere)
- Adds doc note on [`@turf/polygonize`][polygonize] about "Edges must be correctly noded"
(PR https://github.com/Turfjs/turf/pull/898 - Contributor @stebogit @NickCis)
- Adds support to foreign Members to [`@turf/clone`][clone]
(PR https://github.com/Turfjs/turf/pull/904 - Contributor @DenisCarriere)
- Extends support of any `GeoJSON` to [`@turf/simplify`][simplify]
(PR https://github.com/Turfjs/turf/pull/903 - Contributor @DenisCarriere @stebogit)
- Adds new `isNumber` function and improves type checking for few [`@turf/helpers`][helpers] methods
(PR https://github.com/Turfjs/turf/pull/920 - Contributor @DenisCarriere @stebogit)
- Adds throw errors to invalid `MultiPolygons` for [`@turf/simplify`][simplify]
(PR https://github.com/Turfjs/turf/pull/922 - Contributor @DenisCarriere)


## 🐛 Bug Fixes
- Fixes [`@turf/bbox-clip`](bbox-clip) point intersection handling, adding sanity-checks the lineclip output
(PR https://github.com/Turfjs/turf/pull/886)
- Fixes [`@turf/line-split`][line-split] endpoint case handling applying [`@turf/truncate`][truncate] on `splitter`
(PR https://github.com/Turfjs/turf/pull/892 and https://github.com/Turfjs/turf/pull/855 - Contributor @stebogit)
- Fixes [`@turf/intersect`][intersect] throwing "uncaught exception", adding [`@turf/truncate`][truncate] to inputs and returning `Feature<null>` if no geometry
(PR https://github.com/Turfjs/turf/pull/890 - Contributor @stebogit @vicvolk)
- Fixes [`@turf/hex-grid`][hex-grid] not properly cloning the last ring vertex
(PR https://github.com/Turfjs/turf/pull/897 - Contributor @stebogit @DenisCarriere)
- Fixes [`@turf/boolean-disjoint`][boolean-disjoint] incorrect behaviour where a poly was completely contained within another poly
(PR https://github.com/Turfjs/turf/pull/908 - Contributor @rowanwins)
- Fixes [`@turf/simplify`][simplify] process pending on particular geometries, applying [`@turf/clean-coords`][clean-coords] to input.
(PR https://github.com/Turfjs/turf/pull/903 - Contributor @stebogit @DenisCarriere)
- Fixes `boolean` properties not being translated with [`@turf/clone`][clone]
(PR https://github.com/Turfjs/turf/pull/909 - Contributor @DenisCarriere)
- Fixes [`@turf/boolean-contains`][boolean-contains] incorrect output when checking two polygons
(PR https://github.com/Turfjs/turf/pull/923 - Contributor @rowanwins @DenisCarriere)


Twitter: <Tweet>
CC: @Turfjs/ownership


[point-to-line-distance]: https://github.com/Turfjs/turf/tree/master/packages/turf-point-to-line-distance
[projection]: https://github.com/Turfjs/turf/tree/master/packages/turf-projection
[boolean-within]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-within

[helpers]: https://github.com/Turfjs/turf/tree/master/packages/turf-helpers
[invariant]: https://github.com/Turfjs/turf/tree/master/packages/turf-invariant
[meta]: https://github.com/Turfjs/turf/tree/master/packages/turf-meta
[clusters]: https://github.com/Turfjs/turf/tree/master/packages/turf-clusters
[isolines]: https://github.com/Turfjs/turf/tree/master/packages/turf-isolines
[convex]: https://github.com/Turfjs/turf/tree/master/packages/turf-convex
[within]: https://github.com/Turfjs/turf/tree/master/packages/turf-within
[concave]: https://github.com/Turfjs/turf/tree/master/packages/turf-concave
[difference]: https://github.com/Turfjs/turf/tree/master/packages/turf-difference
[dissolve]: https://github.com/Turfjs/turf/tree/master/packages/turf-dissolve
[collect]: https://github.com/Turfjs/turf/tree/master/packages/turf-collect
[flip]: https://github.com/Turfjs/turf/tree/master/packages/turf-flip
[simplify]: https://github.com/Turfjs/turf/tree/master/packages/turf-simplify
[bezier]: https://github.com/Turfjs/turf/tree/master/packages/turf-bezier
[tag]: https://github.com/Turfjs/turf/tree/master/packages/turf-tag
[sample]: https://github.com/Turfjs/turf/tree/master/packages/turf-sample
[envelope]: https://github.com/Turfjs/turf/tree/master/packages/turf-envelope
[square]: https://github.com/Turfjs/turf/tree/master/packages/turf-square
[circle]: https://github.com/Turfjs/turf/tree/master/packages/turf-circle
[midpoint]: https://github.com/Turfjs/turf/tree/master/packages/turf-midpoint
[buffer]: https://github.com/Turfjs/turf/tree/master/packages/turf-buffer
[center]: https://github.com/Turfjs/turf/tree/master/packages/turf-center
[center-of-mass]: https://github.com/Turfjs/turf/tree/master/packages/turf-center-of-mass
[centroid]: https://github.com/Turfjs/turf/tree/master/packages/turf-centroid
[combine]: https://github.com/Turfjs/turf/tree/master/packages/turf-combine
[distance]: https://github.com/Turfjs/turf/tree/master/packages/turf-distance
[explode]: https://github.com/Turfjs/turf/tree/master/packages/turf-explode
[bbox]: https://github.com/Turfjs/turf/tree/master/packages/turf-bbox
[tesselate]: https://github.com/Turfjs/turf/tree/master/packages/turf-tesselate
[bbox-polygon]: https://github.com/Turfjs/turf/tree/master/packages/turf-bbox-polygon
[inside]: https://github.com/Turfjs/turf/tree/master/packages/turf-inside
[intersect]: https://github.com/Turfjs/turf/tree/master/packages/turf-intersect
[nearest]: https://github.com/Turfjs/turf/tree/master/packages/turf-nearest
[planepoint]: https://github.com/Turfjs/turf/tree/master/packages/turf-planepoint
[random]: https://github.com/Turfjs/turf/tree/master/packages/turf-random
[tin]: https://github.com/Turfjs/turf/tree/master/packages/turf-tin
[union]: https://github.com/Turfjs/turf/tree/master/packages/turf-union
[bearing]: https://github.com/Turfjs/turf/tree/master/packages/turf-bearing
[destination]: https://github.com/Turfjs/turf/tree/master/packages/turf-destination
[kinks]: https://github.com/Turfjs/turf/tree/master/packages/turf-kinks
[point-on-surface]: https://github.com/Turfjs/turf/tree/master/packages/turf-point-on-surface
[area]: https://github.com/Turfjs/turf/tree/master/packages/turf-area
[along]: https://github.com/Turfjs/turf/tree/master/packages/turf-along
[line-distance]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-distance
[line-slice]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-slice
[line-slice-along]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-slice-along
[point-on-line]: https://github.com/Turfjs/turf/tree/master/packages/turf-point-on-line
[point-grid]: https://github.com/Turfjs/turf/tree/master/packages/turf-point-grid
[square-grid]: https://github.com/Turfjs/turf/tree/master/packages/turf-square-grid
[triangle-grid]: https://github.com/Turfjs/turf/tree/master/packages/turf-triangle-grid
[hex-grid]: https://github.com/Turfjs/turf/tree/master/packages/turf-hex-grid
[idw]: https://github.com/Turfjs/turf/tree/master/packages/turf-idw
[truncate]: https://github.com/Turfjs/turf/tree/master/packages/turf-truncate
[flatten]: https://github.com/Turfjs/turf/tree/master/packages/turf-flatten
[line-intersect]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-intersect
[mask]: https://github.com/Turfjs/turf/tree/master/packages/turf-mask
[line-chunk]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-chunk
[unkink-polygon]: https://github.com/Turfjs/turf/tree/master/packages/turf-unkink-polygon
[great-circle]: https://github.com/Turfjs/turf/tree/master/packages/turf-great-circle
[line-segment]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-segment
[line-split]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-split
[line-arc]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-arc
[polygon-to-linestring]: https://github.com/Turfjs/turf/tree/master/packages/turf-polygon-to-linestring
[linestring-to-polygon]: https://github.com/Turfjs/turf/tree/master/packages/turf-linestring-to-polygon
[bbox-clip]: https://github.com/Turfjs/turf/tree/master/packages/turf-bbox-clip
[line-overlap]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-overlap
[sector]: https://github.com/Turfjs/turf/tree/master/packages/turf-sector
[rhumb-bearing]: https://github.com/Turfjs/turf/tree/master/packages/turf-rhumb-bearing
[rhumb-distance]: https://github.com/Turfjs/turf/tree/master/packages/turf-rhumb-distance
[rhumb-destination]: https://github.com/Turfjs/turf/tree/master/packages/turf-rhumb-destination
[polygon-tangents]: https://github.com/Turfjs/turf/tree/master/packages/turf-polygon-tangents
[rewind]: https://github.com/Turfjs/turf/tree/master/packages/turf-rewind
[isobands]: https://github.com/Turfjs/turf/tree/master/packages/turf-isobands
[transform-rotate]: https://github.com/Turfjs/turf/tree/master/packages/turf-transform-rotate
[transform-scale]: https://github.com/Turfjs/turf/tree/master/packages/turf-transform-scale
[transform-translate]: https://github.com/Turfjs/turf/tree/master/packages/turf-transform-translate
[line-offset]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-offset
[polygonize]: https://github.com/Turfjs/turf/tree/master/packages/turf-polygonize
[boolean-disjoint]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-disjoint
[boolean-contains]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-contains
[boolean-crosses]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-crosses
[boolean-clockwise]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-clockwise
[boolean-overlap]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-overlap
[boolean-point-on-line]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-point-on-line
[boolean-equal]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-equal
[clone]: https://github.com/Turfjs/turf/tree/master/packages/turf-clone
[clean-coords]: https://github.com/Turfjs/turf/tree/master/packages/turf-clean-coords
[interpolate]: https://github.com/Turfjs/turf/tree/master/packages/turf-interpolate
[clusters-dbscan]: https://github.com/Turfjs/turf/tree/master/packages/turf-clusters-dbscan
[clusters-kmeans]: https://github.com/Turfjs/turf/tree/master/packages/turf-clusters-kmeans
