import { $, createEvent } from '../util/index';

export default function (UIkit) {

    const DATA = UIkit.data;

    UIkit.prototype.$mount = function (el) {

        var name = this.$options.name;

        if (!el[DATA]) {
            el[DATA] = {};
        }

        if (el[DATA][name]) {
            console.warn(`Component "${name}" is already mounted on element: `, el);
            return;
        }

        el[DATA][name] = this;

        this.$el = $(el);

        this._initProps();

        this._callHook('init');

        if (document.documentElement.contains(el)) {
            this._callConnected();
        }
    };

    UIkit.prototype.$emit = function (e) {
        this._callUpdate(e);
    };

    UIkit.prototype.$emitSync = function (e) {
        this._callUpdate(createEvent(e || 'update', true, false, {sync: true}));
    };

    UIkit.prototype.$update = function (e, parents) {
        UIkit.update(e, this.$el, parents);
    };

    UIkit.prototype.$updateSync = function (e, parents) {
        UIkit.update(createEvent(e || 'update', true, false, {sync: true}), this.$el, parents);
    };

    UIkit.prototype.$reset = function (data) {
        this._callDisconnected();
        this._initProps(data);
        this._callConnected();
        this._callUpdate();
    };

    UIkit.prototype.$destroy = function (remove = false) {

        var el = this.$options.el;

        if (el) {
            this._callDisconnected();
        }

        this._callHook('destroy');

        if (!el || !el[DATA]) {
            return;
        }

        delete el[DATA][this.$options.name];

        if (!Object.keys(el[DATA]).length) {
            delete el[DATA];
        }

        if (remove) {
            this.$el.remove();
        }
    };

}
