# Heading

<p class="uk-text-lead">Define different styles for headings.</p>

## Heading primary

To emphasize a heading with an alternative styling, for example a larger font size or a different color, add the `.uk-heading-primary` class. Usually, you would use this class on a `<h1>` element.

```html
<h1 class="uk-heading-primary"></h1>
```

```html : uikit
<h1 class="uk-heading-primary">Heading Primary</h1>
```

***

## Heading hero

You can further enlarge or highlight a heading, for example when using it inside a hero section. Just add the `.uk-heading-hero` class.

```html
<h1 class="uk-heading-hero"></h1>
```

```html : uikit
<h1 class="uk-heading-hero">Heading Hero</h1>
```

***

## Heading divider

To apply a divider to a heading, add the `.uk-heading-divider` class. You can combine this with one of the heading classes from the [Base component](base.md#headings).

```html
<h1 class="uk-heading-divider"></h1>
```

```html : uikit
<h1 class="uk-heading-divider">Heading Divider</h1>
```

***

## Heading bullet

To apply a bullet to a heading, add the `.uk-heading-bullet` class. You can combine this with one of the heading classes from the [Base component](base.md#headings). This modifier also works well with text alignment.

```html
<h1 class="uk-heading-bullet"></h1>
```

```html : uikit
<h1 class="uk-heading-bullet">Heading Bullet</h1>
```

***

## Heading line

To apply a vertically centered line to a heading, add the `.uk-heading-line` class and place a `<span>` element inside the heading element. You can combine this with one of the heading classes from the [Base component](base.md#headings). This modifier also works well with text alignment.

```html
<h1 class="uk-heading-line"><span></span></h1>
```

```html : uikit
<h1 class="uk-heading-line"><span>Heading Line</span></h1>

<h1 class="uk-heading-line uk-text-center"><span>Heading Line</span></h1>

<h1 class="uk-heading-line uk-text-right"><span>Heading Line</span></h1>
```

