(function () {
'use strict';

function bufferToHex(arr) {
  var i;
  var len;
  var hex = '';
  var c;

  for (i = 0, len = arr.length; i < len; i += 1) {
    c = arr[i].toString(16);
    if (c.length < 2) {
      c = '0' + c;
    }
    hex += c;
  }

  return hex;
}

function hexToBuffer(hex) {
  // TODO use Uint8Array or ArrayBuffer or DataView
  var i;
  var byteLen = hex.length / 2;
  var arr;
  var j = 0;

  if (byteLen !== parseInt(byteLen, 10)) {
    throw new Error("Invalid hex length '" + hex.length + "'");
  }

  arr = new Uint8Array(byteLen);

  for (i = 0; i < byteLen; i += 1) {
    arr[i] = parseInt(hex[j] + hex[j + 1], 16);
    j += 2;
  }

  return arr;
}

// Hex Convenience Functions
window.Unibabel.hexToBuffer = hexToBuffer;
window.Unibabel.bufferToHex = bufferToHex;

}());
