# Contributing

> This project has a [Code of Conduct][coc].  By interacting with this
> repository, organisation, or community you agree to abide by its terms.

Hi!  👋 Exciting that you’re interested in contributing!  Before doing so, take
a moment to read the following guidelines.  And thanks for contributing to
**unified**!  👏👌✨

Before anything else: people involved with this project often do so for fun,
next to their day job: you are not entitled to free customer service.

## Table of Contents

*   [Ecosystem](#ecosystem)
*   [Questions](#questions)
*   [Contributions](#contributions)
    *   [Improve documentation](#improve-documentation)
    *   [Improve issues](#improve-issues)
    *   [Give feedback on issues](#give-feedback-on-issues)
    *   [Write code](#write-code)
*   [Submitting an issue](#submitting-an-issue)
*   [Submitting a pull request](#submitting-a-pull-request)
*   [Resources](#resources)

## Ecosystem

The ecosystem consists of several organisations and separate projects: most of
them are tiny, and many of them have a utility
([`mdast-util-to-hast`][mdast-util-to-hast]), a plugin
([`remark-rehype`][remark-rehype]), and relate to an ecosystem
([`remark`][remark]).  Try and pick the right place to contribute to so we can
help you faster.

## Questions

Please chat and ask questions on Gitter!  Jump in there and lurk, talk to us,
and help others.

*   [**unified**](https://gitter.im/unifiedjs/Lobby)
    — Topics relating to [**unified**][unified] in general
*   [**vfile**](https://gitter.im/vfile/Lobby)
    — Topics relating to [**vfile**][vfile]: virtual files
*   [**syntax-tree**](https://gitter.im/syntax-tree/Lobby)
    — Topics relating to [**syntax-tree**][syntax-tree] and [**unist**][unist]
*   [**remark**](https://gitter.im/remarkjs/Lobby)
    — Topics relating to [**remark**][remark]s ecosystem, markdown,
    and [**mdast**][mdast]
*   [**rehype**](https://gitter.im/rehypejs/Lobby)
    — Topics relating to [**rehype**][rehype]s ecosystem, HTML,
    and [**hast**][hast]
*   [**retext**](https://gitter.im/retextjs/Lobby)
    — Topics relating to [**retext**][retext]s ecosystem, natural language,
    and [**nlcst**][nlcst]

## Contributions

There’s several ways to contribute, not just by writing code.

### Improve documentation

As a user of this project you’re perfect for helping us improve our docs.
Typo corrections, error fixes, better explanations, new examples, etcetera.
Anything!

### Improve issues

Some issues lack information, aren’t reproducible, or are just incorrect.
Help make them easier to resolve.

### Give feedback on issues

We’re always looking for more opinions on discussions in the issue tracker.

### Write code

Code contributions are very welcome.  It’s often good to first create an issue
to report a bug or suggest a new feature before creating a pull request to
prevent you from doing unnecessary work.

## Submitting an issue

*   The issue tracker is for issues.  Use chat for support
*   Search the issue tracker (including closed issues) before opening a new
    issue
*   Ensure you’re using the latest version of projects
*   Use a clear and descriptive title
*   Include as much information as possible: steps to reproduce the issue,
    error message, version, operating system, etcetera
*   The more time you put into an issue, the more we will
*   The best issue report is a [failing test][unit-test] proving it

## Submitting a pull request

*   Non-trivial changes are often best discussed in an issue first, to prevent
    you from doing unnecessary work
*   For ambitious tasks, you should try to get your work in front of the
    community for feedback as soon as possible
*   New features should be accompanied with tests and documentation
*   Don’t include unrelated changes
*   Lint and test before submitting code by running `$ npm test`
*   Write a convincing description of why we should land your pull request:
    it’s your job to convince us

## Resources

*   [How to Contribute to Open Source](https://opensource.guide/how-to-contribute/)
*   [Making your first contribution](https://medium.com/@vadimdemedes/making-your-first-contribution-de6576ddb190)
*   [Using Pull Requests](https://help.github.com/articles/about-pull-requests/)
*   [GitHub Help](https://help.github.com)

[coc]: https://github.com/unifiedjs/unified/blob/master/code-of-conduct.md

[vfile]: https://github.com/vfile

[syntax-tree]: https://github.com/syntax-tree

[unist]: https://github.com/syntax-tree/unist

[mdast]: https://github.com/syntax-tree/mdast

[nlcst]: https://github.com/syntax-tree/nlcst

[hast]: https://github.com/syntax-tree/hast

[unified]: https://github.com/unifiedjs/unified

[remark]: https://github.com/remarkjs/remark

[retext]: https://github.com/retextjs/retext

[rehype]: https://github.com/rehypejs/rehype

[mdast-util-to-hast]: https://github.com/syntax-tree/mdast-util-to-hast

[remark-rehype]: https://github.com/remarkjs/remark-rehype

[unit-test]: https://twitter.com/sindresorhus/status/579306280495357953
