var urls = [{
        name: 'scheme and domain',
        url: 'http://www.example.org',
        _url: 'http://www.example.org/',
        parts: {
            protocol: 'http',
            username: null,
            password: null,
            hostname: 'www.example.org',
            port: null,
            path: '/',
            query: null,
            fragment: null
        },
        accessors: {
            protocol: 'http',
            username: '',
            password: '',
            port: '',
            path: '/',
            query: '',
            fragment: '',
            resource: '/',
            authority: 'www.example.org',
            userinfo: '',
            subdomain: 'www',
            domain: 'example.org',
            tld: 'org',
            directory: '/',
            filename: '',
            suffix: '',
            hash: '', // location.hash style
            search: '', // location.search style
            host: 'www.example.org',
            hostname: 'www.example.org'
        },
        is: {
            urn: false,
            url: true,
            relative: false,
            name: true,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'second level domain',
        url: 'http://www.example.co.uk',
        _url: 'http://www.example.co.uk/',
        parts: {
            protocol: 'http',
            username: null,
            password: null,
            hostname: 'www.example.co.uk',
            port: null,
            path: '/',
            query: null,
            fragment: null
        },
        accessors: {
            protocol: 'http',
            username: '',
            password: '',
            port: '',
            path: '/',
            query: '',
            fragment: '',
            resource: '/',
            authority: 'www.example.co.uk',
            userinfo: '',
            subdomain: 'www',
            domain: 'example.co.uk',
            tld: 'co.uk',
            directory: '/',
            filename: '',
            suffix: '',
            hash: '', // location.hash style
            search: '', // location.search style
            host: 'www.example.co.uk',
            hostname: 'www.example.co.uk'
        },
        is: {
            urn: false,
            url: true,
            relative: false,
            name: true,
            sld: true,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    },{
        name: 'qualified HTTP',
        url: 'http://www.example.org/some/directory/file.html?query=string#fragment',
        parts: {
            protocol: 'http',
            username: null,
            password: null,
            hostname: 'www.example.org',
            port: null,
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment'
        },
        accessors: {
            protocol: 'http',
            username: '',
            password: '',
            port: '',
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment',
            resource: '/some/directory/file.html?query=string#fragment',
            authority: 'www.example.org',
            userinfo: '',
            subdomain: 'www',
            domain: 'example.org',
            tld: 'org',
            directory: '/some/directory',
            filename: 'file.html',
            suffix: 'html',
            hash: '#fragment',
            search: '?query=string',
            host: 'www.example.org',
            hostname: 'www.example.org'
        },
        is: {
            urn: false,
            url: true,
            relative: false,
            name: true,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'funky suffix',
        url: 'http://www.example.org/some/directory/file.html-is-awesome?query=string#fragment',
        parts: {
            protocol: 'http',
            username: null,
            password: null,
            hostname: 'www.example.org',
            port: null,
            path: '/some/directory/file.html-is-awesome',
            query: 'query=string',
            fragment: 'fragment'
        },
        accessors: {
            protocol: 'http',
            username: '',
            password: '',
            port: '',
            path: '/some/directory/file.html-is-awesome',
            query: 'query=string',
            fragment: 'fragment',
            resource: '/some/directory/file.html-is-awesome?query=string#fragment',
            authority: 'www.example.org',
            userinfo: '',
            subdomain: 'www',
            domain: 'example.org',
            tld: 'org',
            directory: '/some/directory',
            filename: 'file.html-is-awesome',
            suffix: '',
            hash: '#fragment',
            search: '?query=string',
            host: 'www.example.org',
            hostname: 'www.example.org'
        },
        is: {
            urn: false,
            url: true,
            relative: false,
            name: true,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'complete URL',
        url: 'scheme://user:pass@www.example.org:123/some/directory/file.html?query=string#fragment',
        parts: {
            protocol: 'scheme',
            username: 'user',
            password: 'pass',
            hostname: 'www.example.org',
            port: '123',
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment'
        },
        accessors: {
            protocol: 'scheme',
            username: 'user',
            password: 'pass',
            port: '123',
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment',
            resource: '/some/directory/file.html?query=string#fragment',
            authority: 'user:pass@www.example.org:123',
            userinfo: 'user:pass',
            subdomain: 'www',
            domain: 'example.org',
            tld: 'org',
            directory: '/some/directory',
            filename: 'file.html',
            suffix: 'html',
            hash: '#fragment',
            search: '?query=string',
            host: 'www.example.org:123',
            hostname: 'www.example.org'
        },
        is: {
            urn: false,
            url: true,
            relative: false,
            name: true,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'badly encoded userinfo',
        url: 'scheme://user:pass:word@www.example.org/',
        _url: 'scheme://user:pass%3Aword@www.example.org/',
        parts: {
            protocol: 'scheme',
            username: 'user',
            password: 'pass:word',
            hostname: 'www.example.org',
            port: null,
            path: '/',
            query: null,
            fragment: null
        },
        accessors: {
            protocol: 'scheme',
            username: 'user',
            password: 'pass:word',
            port: '',
            path: '/',
            query: '',
            fragment: '',
            resource: '/',
            authority: 'user:pass%3Aword@www.example.org',
            userinfo: 'user:pass%3Aword',
            subdomain: 'www',
            domain: 'example.org',
            tld: 'org',
            directory: '/',
            filename: '',
            suffix: '',
            hash: '',
            search: '',
            host: 'www.example.org',
            hostname: 'www.example.org'
        },
        is: {
            urn: false,
            url: true,
            relative: false,
            name: true,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'host-relative: URL',
        url: '/some/directory/file.html?query=string#fragment',
        parts: {
            protocol: null,
            username: null,
            password: null,
            hostname: null,
            port: null,
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment'
        },
        accessors: {
            protocol: '',
            username: '',
            password: '',
            port: '',
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment',
            resource: '/some/directory/file.html?query=string#fragment',
            authority: '',
            userinfo: '',
            subdomain: '',
            domain: '',
            tld: '',
            directory: '/some/directory',
            filename: 'file.html',
            suffix: 'html',
            hash: '#fragment',
            search: '?query=string',
            host: '',
            hostname: ''
        },
        is: {
            urn: false,
            url: true,
            relative: true,
            name: false,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'path-relative: URL',
        url: '../some/directory/file.html?query=string#fragment',
        parts: {
            protocol: null,
            username: null,
            password: null,
            hostname: null,
            port: null,
            path: '../some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment'
        },
        accessors: {
            protocol: '',
            username: '',
            password: '',
            port: '',
            path: '../some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment',
            resource: '../some/directory/file.html?query=string#fragment',
            authority: '',
            userinfo: '',
            subdomain: '',
            domain: '',
            tld: '',
            directory: '../some/directory',
            filename: 'file.html',
            suffix: 'html',
            hash: '#fragment',
            search: '?query=string',
            host: '',
            hostname: ''
        },
        is: {
            urn: false,
            url: true,
            relative: true,
            name: false,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'missing scheme',
        url: 'user:pass@www.example.org:123/some/directory/file.html?query=string#fragment',
        parts: {
            protocol: 'user',
            username: null,
            password: null,
            hostname: null,
            port: null,
            path: 'pass@www.example.org:123/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment'
        },
        accessors: {
            protocol: 'user',
            username: '',
            password: '',
            port: '',
            path: 'pass@www.example.org:123/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment',
            resource: 'pass@www.example.org:123/some/directory/file.html?query=string#fragment',
            authority: '',
            userinfo: '',
            subdomain: '',
            domain: '',
            tld: '',
            directory: '',
            filename: '',
            suffix: '',
            hash: '#fragment',
            search: '?query=string',
            host: '',
            hostname: ''
        },
        is: {
            urn: true,
            url: false,
            relative: false,
            name: false,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'ignoring scheme',
        url: '://user:pass@example.org:123/some/directory/file.html?query=string#fragment',
        _url: '//user:pass@example.org:123/some/directory/file.html?query=string#fragment',
        parts: {
            protocol: "",
            username: 'user',
            password: 'pass',
            hostname: 'example.org',
            port: '123',
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment'
        },
        accessors: {
            protocol: '',
            username: 'user',
            password: 'pass',
            port: '123',
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment',
            resource: '/some/directory/file.html?query=string#fragment',
            authority: 'user:pass@example.org:123',
            userinfo: 'user:pass',
            subdomain: '',
            domain: 'example.org',
            tld: 'org',
            directory: '/some/directory',
            filename: 'file.html',
            suffix: 'html',
            hash: '#fragment',
            search: '?query=string',
            host: 'example.org:123',
            hostname: 'example.org'
        },
        is: {
            urn: false,
            url: true,
            relative: false,
            name: true,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'scheme-relative URL',
        url: '//www.example.org/',
        parts: {
            protocol: '', // not null
            username: null,
            password: null,
            hostname: 'www.example.org',
            port: null,
            path: '/',
            query: null,
            fragment: null
        },
        accessors: {
            protocol: '',
            username: '',
            password: '',
            port: '',
            path: '/',
            query: '',
            fragment: '',
            resource: '/',
            authority: 'www.example.org',
            userinfo: '',
            subdomain: 'www',
            domain: 'example.org',
            tld: 'org',
            directory: '/',
            filename: '',
            suffix: '',
            hash: '',
            search: '',
            host: 'www.example.org',
            hostname: 'www.example.org'
        },
        is: {
            urn: false,
            url: true,
            relative: false,
            name: true,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'IPv4',
        url: 'http://user:pass@123.123.123.123:123/some/directory/file.html?query=string#fragment',
        parts: {
            protocol: 'http',
            username: 'user',
            password: 'pass',
            hostname: '123.123.123.123',
            port: '123',
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment'
        },
        accessors: {
            protocol: 'http',
            username: 'user',
            password: 'pass',
            port: '123',
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment',
            resource: '/some/directory/file.html?query=string#fragment',
            authority: 'user:pass@123.123.123.123:123',
            userinfo: 'user:pass',
            subdomain: '',
            domain: '',
            tld: '',
            directory: '/some/directory',
            filename: 'file.html',
            suffix: 'html',
            hash: '#fragment',
            search: '?query=string',
            host: '123.123.123.123:123',
            hostname: '123.123.123.123'
        },
        is: {
            urn: false,
            url: true,
            relative: false,
            name: false,
            sld: false,
            ip: true,
            ip4: true,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'IPv6',
        url: 'http://user:pass@fe80:0000:0000:0000:0204:61ff:fe9d:f156/some/directory/file.html?query=string#fragment',
        parts: {
            protocol: 'http',
            username: 'user',
            password: 'pass',
            hostname: 'fe80:0000:0000:0000:0204:61ff:fe9d:f156',
            port: null,
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment'
        },
        accessors: {
            protocol: 'http',
            username: 'user',
            password: 'pass',
            port: '',
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment',
            resource: '/some/directory/file.html?query=string#fragment',
            authority: 'user:pass@fe80:0000:0000:0000:0204:61ff:fe9d:f156',
            userinfo: 'user:pass',
            subdomain: '',
            domain: '',
            tld: '',
            directory: '/some/directory',
            filename: 'file.html',
            suffix: 'html',
            hash: '#fragment',
            search: '?query=string',
            host: 'fe80:0000:0000:0000:0204:61ff:fe9d:f156',
            hostname: 'fe80:0000:0000:0000:0204:61ff:fe9d:f156'
        },
        is: {
            urn: false,
            url: true,
            relative: false,
            name: false,
            sld: false,
            ip: true,
            ip4: false,
            ip6: true,
            idn: false,
            punycode: false
        }
    }, {
        name: 'IPv6 with port',
        url: 'http://user:pass@[fe80:0000:0000:0000:0204:61ff:fe9d:f156]:123/some/directory/file.html?query=string#fragment',
        parts: {
            protocol: 'http',
            username: 'user',
            password: 'pass',
            hostname: 'fe80:0000:0000:0000:0204:61ff:fe9d:f156',
            port: '123',
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment'
        },
        accessors: {
            protocol: 'http',
            username: 'user',
            password: 'pass',
            port: '123',
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment',
            resource: '/some/directory/file.html?query=string#fragment',
            authority: 'user:pass@[fe80:0000:0000:0000:0204:61ff:fe9d:f156]:123',
            userinfo: 'user:pass',
            subdomain: '',
            domain: '',
            tld: '',
            directory: '/some/directory',
            filename: 'file.html',
            suffix: 'html',
            hash: '#fragment',
            search: '?query=string',
            host: '[fe80:0000:0000:0000:0204:61ff:fe9d:f156]:123',
            hostname: 'fe80:0000:0000:0000:0204:61ff:fe9d:f156'
        },
        is: {
            urn: false,
            url: true,
            relative: false,
            name: false,
            sld: false,
            ip: true,
            ip4: false,
            ip6: true,
            idn: false,
            punycode: false
        }
    }, {
        name: 'IDN (punycode)',
        url: 'http://user:pass@xn--exmple-cua.org:123/some/directory/file.html?query=string#fragment',
        parts: {
            protocol: 'http',
            username: 'user',
            password: 'pass',
            hostname: 'xn--exmple-cua.org',
            port: '123',
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment'
        },
        accessors: {
            protocol: 'http',
            username: 'user',
            password: 'pass',
            port: '123',
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment',
            resource: '/some/directory/file.html?query=string#fragment',
            authority: 'user:pass@xn--exmple-cua.org:123',
            userinfo: 'user:pass',
            subdomain: '',
            domain: 'xn--exmple-cua.org',
            tld: 'org',
            directory: '/some/directory',
            filename: 'file.html',
            suffix: 'html',
            hash: '#fragment',
            search: '?query=string',
            host: 'xn--exmple-cua.org:123',
            hostname: 'xn--exmple-cua.org'
        },
        is: {
            urn: false,
            url: true,
            relative: false,
            name: true,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: true
        }
    }, {
        name: 'IDN',
        url: 'http://user:pass@exämple.org:123/some/directory/file.html?query=string#fragment',
        parts: {
            protocol: 'http',
            username: 'user',
            password: 'pass',
            hostname: 'exämple.org',
            port: '123',
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment'
        },
        accessors: {
            protocol: 'http',
            username: 'user',
            password: 'pass',
            port: '123',
            path: '/some/directory/file.html',
            query: 'query=string',
            fragment: 'fragment',
            resource: '/some/directory/file.html?query=string#fragment',
            authority: 'user:pass@exämple.org:123',
            userinfo: 'user:pass',
            subdomain: '',
            domain: 'exämple.org',
            tld: 'org',
            directory: '/some/directory',
            filename: 'file.html',
            suffix: 'html',
            hash: '#fragment',
            search: '?query=string',
            host: 'exämple.org:123',
            hostname: 'exämple.org'
        },
        is: {
            urn: false,
            url: true,
            relative: false,
            name: true,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: true,
            punycode: false
        }
    }, {
        name: 'file://',
        url: 'file:///foo/bar/baz.html',
        parts: {
            protocol: 'file',
            username: null,
            password: null,
            hostname: null,
            port: null,
            path: '/foo/bar/baz.html',
            query: null,
            fragment: null
        },
        accessors: {
            protocol: 'file',
            username: '',
            password: '',
            port: '',
            path: '/foo/bar/baz.html',
            query: '',
            fragment: '',
            resource: '/foo/bar/baz.html',
            authority: '',
            userinfo: '',
            subdomain: '',
            domain: '',
            tld: '',
            directory: '/foo/bar',
            filename: 'baz.html',
            suffix: 'html',
            hash: '',
            search: '',
            host: '',
            hostname: ''
        },
        is: {
            urn: false,
            url: true,
            relative: true,
            name: false,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'file:// Windows-Drive-Letter',
        url: 'file://C:/WINDOWS/foo.txt',
        parts: {
            protocol: 'file',
            username: null,
            password: null,
            hostname: null,
            port: null,
            path: 'C:/WINDOWS/foo.txt',
            query: null,
            fragment: null
        },
        accessors: {
            protocol: 'file',
            username: '',
            password: '',
            port: '',
            path: 'C:/WINDOWS/foo.txt',
            query: '',
            fragment: '',
            resource: 'C:/WINDOWS/foo.txt',
            authority: '',
            userinfo: '',
            subdomain: '',
            domain: '',
            tld: '',
            directory: 'C:/WINDOWS',
            filename: 'foo.txt',
            suffix: 'txt',
            hash: '',
            search: '',
            host: '',
            hostname: ''
        },
        is: {
            urn: false,
            url: true,
            relative: true,
            name: false,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'Path containing @',
        url: 'http://www.example.org/@foobar',
        parts: {
            protocol: 'http',
            username: null,
            password: null,
            hostname: 'www.example.org',
            port: null,
            path: '/@foobar',
            query: null,
            fragment: null
        },
        accessors: {
            protocol: 'http',
            username: '',
            password: '',
            port: '',
            path: '/@foobar',
            query: '',
            fragment: '',
            resource: '/@foobar',
            authority: 'www.example.org',
            userinfo: '',
            subdomain: 'www',
            domain: 'example.org',
            tld: 'org',
            directory: '/',
            filename: '@foobar',
            suffix: '',
            hash: '', // location.hash style
            search: '', // location.search style
            host: 'www.example.org',
            hostname: 'www.example.org'
        },
        is: {
            urn: false,
            url: true,
            relative: false,
            name: true,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'mailto:',
        url: 'mailto:hello@example.org?subject=hello',
        _url: 'mailto:hello@example.org?subject=hello',
        parts: {
            protocol: 'mailto',
            username: null,
            password: null,
            hostname: null,
            port: null,
            path: 'hello@example.org',
            query: 'subject=hello',
            fragment: null
        },
        accessors: {
            protocol: 'mailto',
            username: '',
            password: '',
            port: '',
            path: 'hello@example.org',
            query: 'subject=hello',
            fragment: '',
            resource: 'hello@example.org?subject=hello',
            authority: '',
            userinfo: '',
            subdomain: '',
            domain: '',
            tld: '',
            directory: '',
            filename: '',
            suffix: '',
            hash: '',
            search: '?subject=hello',
            host: '',
            hostname: ''
        },
        is: {
            urn: true,
            url: false,
            relative: false,
            name: false,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'magnet:',
        url: 'magnet:?xt=urn:btih:f8c020dac7a083defda1769a1196a13facc38ef6&dn=Linux+64x+server+11.10+Pt+Pt&tr=udp%3A%2F%2Ftracker.openbittorrent.com%3A80&tr=udp%3A%2F%2Ftracker.publicbt.com%3A80&tr=udp%3A%2F%2Ftracker.ccc.de%3A80',
        _url: 'magnet:?xt=urn:btih:f8c020dac7a083defda1769a1196a13facc38ef6&dn=Linux+64x+server+11.10+Pt+Pt&tr=udp%3A%2F%2Ftracker.openbittorrent.com%3A80&tr=udp%3A%2F%2Ftracker.publicbt.com%3A80&tr=udp%3A%2F%2Ftracker.ccc.de%3A80',
        parts: {
            protocol: 'magnet',
            username: null,
            password: null,
            hostname: null,
            port: null,
            path: '',
            query: 'xt=urn:btih:f8c020dac7a083defda1769a1196a13facc38ef6&dn=Linux+64x+server+11.10+Pt+Pt&tr=udp%3A%2F%2Ftracker.openbittorrent.com%3A80&tr=udp%3A%2F%2Ftracker.publicbt.com%3A80&tr=udp%3A%2F%2Ftracker.ccc.de%3A80',
            fragment: null
        },
        accessors: {
            protocol: 'magnet',
            username: '',
            password: '',
            port: '',
            path: '',
            query: 'xt=urn:btih:f8c020dac7a083defda1769a1196a13facc38ef6&dn=Linux+64x+server+11.10+Pt+Pt&tr=udp%3A%2F%2Ftracker.openbittorrent.com%3A80&tr=udp%3A%2F%2Ftracker.publicbt.com%3A80&tr=udp%3A%2F%2Ftracker.ccc.de%3A80',
            fragment: '',
            resource: '?xt=urn:btih:f8c020dac7a083defda1769a1196a13facc38ef6&dn=Linux+64x+server+11.10+Pt+Pt&tr=udp%3A%2F%2Ftracker.openbittorrent.com%3A80&tr=udp%3A%2F%2Ftracker.publicbt.com%3A80&tr=udp%3A%2F%2Ftracker.ccc.de%3A80',
            authority: '',
            userinfo: '',
            subdomain: '',
            domain: '',
            tld: '',
            directory: '',
            filename: '',
            suffix: '',
            hash: '',
            search: '?xt=urn:btih:f8c020dac7a083defda1769a1196a13facc38ef6&dn=Linux+64x+server+11.10+Pt+Pt&tr=udp%3A%2F%2Ftracker.openbittorrent.com%3A80&tr=udp%3A%2F%2Ftracker.publicbt.com%3A80&tr=udp%3A%2F%2Ftracker.ccc.de%3A80',
            host: '',
            hostname: ''
        },
        is: {
            urn: true,
            url: false,
            relative: false,
            name: false,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'javascript:',
        url: 'javascript:alert("hello world");',
        _url: 'javascript:alert("hello world");',
        parts: {
            protocol: 'javascript',
            username: null,
            password: null,
            hostname: null,
            port: null,
            path: 'alert("hello world");',
            query: null,
            fragment: null
        },
        accessors: {
            protocol: 'javascript',
            username: '',
            password: '',
            port: '',
            path: 'alert("hello world");',
            query: '',
            fragment: '',
            resource: 'alert("hello world");',
            authority: '',
            userinfo: '',
            subdomain: '',
            domain: '',
            tld: '',
            directory: '',
            filename: '',
            suffix: '',
            hash: '',
            search: '',
            host: '',
            hostname: ''
        },
        is: {
            urn: true,
            url: false,
            relative: false,
            name: false,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'colon in path',
        url: 'http://en.wikipedia.org/wiki/Help:IPA',
        _url: 'http://en.wikipedia.org/wiki/Help:IPA',
        parts: {
            protocol: 'http',
            username: null,
            password: null,
            hostname: 'en.wikipedia.org',
            port: null,
            path: '/wiki/Help:IPA',
            query: null,
            fragment: null
        },
        accessors: {
            protocol: 'http',
            username: '',
            password: '',
            port: '',
            path: '/wiki/Help:IPA',
            query: '',
            fragment: '',
            resource: '/wiki/Help:IPA',
            authority: 'en.wikipedia.org',
            userinfo: '',
            subdomain: 'en',
            domain: 'wikipedia.org',
            tld: 'org',
            directory: '/wiki',
            filename: 'Help:IPA',
            suffix: '',
            hash: '',
            search: '',
            host: 'en.wikipedia.org',
            hostname: 'en.wikipedia.org'
        },
        is: {
            urn: false,
            url: true,
            relative: false,
            name: true,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'colon in path without protocol',
        url: '/wiki/Help:IPA',
        _url: '/wiki/Help:IPA',
        parts: {
            protocol: null,
            username: null,
            password: null,
            hostname: null,
            port: null,
            path: '/wiki/Help:IPA',
            query: null,
            fragment: null
        },
        accessors: {
            protocol: '',
            username: '',
            password: '',
            port: '',
            path: '/wiki/Help:IPA',
            query: '',
            fragment: '',
            resource: '/wiki/Help:IPA',
            authority: '',
            userinfo: '',
            subdomain: '',
            domain: '',
            tld: '',
            directory: '/wiki',
            filename: 'Help:IPA',
            suffix: '',
            hash: '',
            search: '',
            host: '',
            hostname: ''
        },
        is: {
            urn: false,
            url: true,
            relative: true,
            name: false,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }, {
        name: 'colon dash dash in path without protocol',
        url: '/foo/xy://bar',
        _url: '/foo/xy://bar',
        parts: {
            protocol: null,
            username: null,
            password: null,
            hostname: null,
            port: null,
            path: '/foo/xy://bar',
            query: null,
            fragment: null
        },
        accessors: {
            protocol: '',
            username: '',
            password: '',
            port: '',
            path: '/foo/xy://bar',
            query: '',
            fragment: '',
            resource: '/foo/xy://bar',
            authority: '',
            userinfo: '',
            subdomain: '',
            domain: '',
            tld: '',
            directory: '/foo/xy:/', // sanitized empty directory!
            filename: 'bar',
            suffix: '',
            hash: '',
            search: '',
            host: '',
            hostname: ''
        },
        is: {
            urn: false,
            url: true,
            relative: true,
            name: false,
            sld: false,
            ip: false,
            ip4: false,
            ip6: false,
            idn: false,
            punycode: false
        }
    }
];

