![Bower version](https://badge.fury.io/bo/vaadin-core.svg)
[![Published on webcomponents.org](https://img.shields.io/badge/webcomponents.org-published-blue.svg)](https://www.webcomponents.org/author/vaadin)
[![Gitter](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/vaadin/vaadin-core-elements?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)

# Vaadin Core Elements

[Vaadin elements](https://vaadin.com/elements) are an evolving set of open sourced [Polymer](https://www.polymer-project.org/) web components, which seamlessly extend the [Polymer Element Catalog](https://www.webcomponents.org/collection/Polymer/elements) with high-quality user interface components commonly needed in modern mobile and desktop business web applications. The following elements are included:

| Element | Bower Version | Build Status | Polymer 2 support | Polymer 3 support |
|---------|---------------|--------------|-------------------|-------------------|
| [vaadin-button](https://github.com/vaadin/vaadin-button) | ![Bower version](https://badge.fury.io/bo/vaadin-button.svg) |  [![Build Status](https://travis-ci.org/vaadin/vaadin-button.svg?branch=master)](https://travis-ci.org/vaadin/vaadin-button) | ![Polymer 2 supported](https://img.shields.io/badge/Polymer2-supported-blue.svg) | ![Polymer 3 wip](https://img.shields.io/badge/Polymer3-wip-yellow.svg) |
| [vaadin-checkbox](https://github.com/vaadin/vaadin-checkbox) | ![Bower version](https://badge.fury.io/bo/vaadin-checkbox.svg) | [![Build Status](https://travis-ci.org/vaadin/vaadin-checkbox.svg?branch=master)](https://travis-ci.org/vaadin/vaadin-checkbox) | ![Polymer 2 supported](https://img.shields.io/badge/Polymer2-supported-blue.svg) |
| [vaadin-combo-box](https://github.com/vaadin/vaadin-combo-box) | ![Bower version](https://badge.fury.io/bo/vaadin-combo-box.svg) | [![Build Status](https://travis-ci.org/vaadin/vaadin-combo-box.svg?branch=master)](https://travis-ci.org/vaadin/vaadin-combo-box) | ![Polymer 2 supported](https://img.shields.io/badge/Polymer2-supported-blue.svg) |
| [vaadin-context-menu](https://github.com/vaadin/vaadin-context-menu) | ![Bower version](https://badge.fury.io/bo/vaadin-context-menu.svg) | [![Build Status](https://travis-ci.org/vaadin/vaadin-context-menu.svg?branch=master)](https://travis-ci.org/vaadin/vaadin-context-menu) | ![Polymer 2 supported](https://img.shields.io/badge/Polymer2-supported-blue.svg) |
| [vaadin-date-picker](https://github.com/vaadin/vaadin-date-picker) | ![Bower version](https://badge.fury.io/bo/vaadin-date-picker.svg) | [![Build Status](https://travis-ci.org/vaadin/vaadin-date-picker.svg?branch=master)](https://travis-ci.org/vaadin/vaadin-date-picker) | ![Polymer 2 supported](https://img.shields.io/badge/Polymer2-supported-blue.svg) |
| [vaadin-dialog](https://github.com/vaadin/vaadin-dialog) | ![Bower version](https://badge.fury.io/bo/vaadin-dialog.svg) | [![Build Status](https://travis-ci.org/vaadin/vaadin-dialog.svg?branch=master)](https://travis-ci.org/vaadin/vaadin-dialog) | ![Polymer 2 supported](https://img.shields.io/badge/Polymer2-supported-blue.svg) |
| [vaadin-form-layout](https://github.com/vaadin/vaadin-form-layout) | ![Bower version](https://badge.fury.io/bo/vaadin-form-layout.svg) | [![Build Status](https://travis-ci.org/vaadin/vaadin-form-layout.svg?branch=master)](https://travis-ci.org/vaadin/vaadin-form-layout) | ![Polymer 2 supported](https://img.shields.io/badge/Polymer2-supported-blue.svg) |
| [vaadin-grid](https://github.com/vaadin/vaadin-grid) | ![Bower version](https://badge.fury.io/bo/vaadin-grid.svg) | [![Build Status](https://travis-ci.org/vaadin/vaadin-grid.svg?branch=master)](https://travis-ci.org/vaadin/vaadin-grid) | ![Polymer 2 supported](https://img.shields.io/badge/Polymer2-supported-blue.svg) | ![Polymer 3 wip](https://img.shields.io/badge/Polymer3-wip-yellow.svg) |
| [vaadin-icons](https://github.com/vaadin/vaadin-icons) | ![Bower version](https://badge.fury.io/bo/vaadin-icons.svg) | [![Build status](https://travis-ci.org/vaadin/vaadin-icons.svg?branch=master)](https://travis-ci.org/vaadin/vaadin-icons) | ![Polymer 2 supported](https://img.shields.io/badge/Polymer2-supported-blue.svg) |
| [vaadin-progress-bar](https://github.com/vaadin/vaadin-progress-bar) | ![Bower version](https://badge.fury.io/bo/vaadin-progress-bar.svg) | [![Build status](https://travis-ci.org/vaadin/vaadin-progress-bar.svg?branch=master)](https://travis-ci.org/vaadin/vaadin-progress-bar) | ![Polymer 2 supported](https://img.shields.io/badge/Polymer2-supported-blue.svg) |
| [vaadin-radio-button](https://github.com/vaadin/vaadin-radio-button) | ![Bower version](https://badge.fury.io/bo/vaadin-radio-button.svg) | [![Build status](https://travis-ci.org/vaadin/vaadin-radio-button.svg?branch=master)](https://travis-ci.org/vaadin/vaadin-radio-button) | ![Polymer 2 supported](https://img.shields.io/badge/Polymer2-supported-blue.svg) |
| [vaadin-split-layout](https://github.com/vaadin/vaadin-split-layout) | ![Bower version](https://badge.fury.io/bo/vaadin-split-layout.svg) | [![Build status](https://travis-ci.org/vaadin/vaadin-split-layout.svg?branch=master)](https://travis-ci.org/vaadin/vaadin-split-layout) | ![Polymer 2 supported](https://img.shields.io/badge/Polymer2-supported-blue.svg) | ![Polymer 3 wip](https://img.shields.io/badge/Polymer3-wip-yellow.svg) |
| [vaadin-text-field](https://github.com/vaadin/vaadin-text-field) | ![Bower version](https://badge.fury.io/bo/vaadin-text-field.svg) | [![Build Status](https://travis-ci.org/vaadin/vaadin-text-field.svg?branch=master)](https://travis-ci.org/vaadin/vaadin-text-field) | ![Polymer 2 supported](https://img.shields.io/badge/Polymer2-supported-blue.svg) |
| [vaadin-upload](https://github.com/vaadin/vaadin-upload) | ![Bower version](https://badge.fury.io/bo/vaadin-upload.svg) | [![Build Status](https://travis-ci.org/vaadin/vaadin-upload.svg?branch=master)](https://travis-ci.org/vaadin/vaadin-upload) | ![Polymer 2 supported](https://img.shields.io/badge/Polymer2-supported-blue.svg) |

Vaadin Core Elements is a bundle that contains all the free elements, licensed under the Apache License 2.0. In addition, we have commercially licensed elements, such as [Vaadin Charts](https://github.com/vaadin/vaadin-charts).

## Learn more

See the list of elements, demos and documentation, instructions how to get started, video tutorials, application demos and more by visiting:

### [vaadin.com/elements ›](https://vaadin.com/elements)

---

## Roadmap

See https://vaadin.com/roadmap for a high level roadmap that is updated once a week.

## Contributing

We would absolutely love to get the community involved, and we welcome any form of contributions – comments and questions on different communication channels, issues and pull request in the repositories, and anything that you build and share using our elements.

### Get in touch with the team

The chat and the forum category are dedicated channels for this project, while the Twitter, Facebook and G+ pages are common for all Vaadin related discussion (including the Java framework).

- [Chat](https://gitter.im/vaadin/vaadin-core-elements)
- [Forum](https://vaadin.com/forum/#!/category/9848927)
- [Twitter](https://twitter.com/vaadin)
- [Facebook](https://www.facebook.com/vaadin/)
- [G+](https://plus.google.com/communities/108116678608923665301)

### Some ways to help:

- **Test the elements and provide feedback**: We would love to hear your feedback on anything related to the elements, like features, API and design. The best way to start is by [trying them out](https://vaadin.com/docs/-/part/elements/elements-getting-started.html). And to get a quick response, either drop a question/comment on the chat or open an issue in GitHub.
- **Report bugs**: File issues for the elements in their respective GitHub projects. You can find links to them from https://vaadin.com/elements
- **Send pull requests**: If you want to contribute code, check out the development instructions below.

We encourage you to read the [contribution instructions by GitHub](https://guides.github.com/activities/contributing-to-open-source/#contributing) also.

## Development

If you want to develop the elements yourself see the [development instructions](DEVELOPMENT.md) that apply to all Vaadin elements.

## License

Apache License 2.0
