---
layout: transform
title: Nest Transform
permalink: /docs/transforms/nest/index.html
---

The **nest** transform generates a hierarchical (tree) data structure from input data objects, based on dividing children into groups based on distinct field values. Internally, this transform generates a set of tree node objects that can then be processed by tree layout methods such as [tree](../tree), [treemap](../treemap), [pack](../pack), and [partition](../partition).

## Transform Parameters

| Property            | Type                           | Description   |
| :------------------ | :----------------------------: | :------------ |
| generate            | {% include type t="Boolean" %} | A boolean flag (default `false`) indicating if non-leaf nodes generated by this transform should be included in the output data stream. By default only the input data objects (leaf nodes) are included. If non-leaf nodes are included, be aware that they will have a different set of properties than the input objects: the generated internal nodes will include a `key` property (unrelated to the _key_ parameter discussed below!) corresponding to the values extracted using the _keys_ transform parameter.|
| keys                | {% include type t="Field[]" %} | An array of data fields by which to organize the data objects into a tree. Data objects will first be grouped into siblings based on the values of the first field in the parameter array. The process then continues, creating an additional depth level for each provided field. If unspecified, all data objects will treated as a single set of sibling nodes.|
| key                 | {% include type t="Field" %}   | A data field containing a unique key (identifier) for each node. If not specified, Vega will use internal data object ids. Key identifiers apply to non-leaf nodes only; if the _generate_ parameter is `true`, new internal nodes will be created without a corresponding identifier. In such cases, this parameter should not be used.|


## Usage

```json
{
  "type": "nest",
  "keys": ["job", "region"]
}
```

Builds a tree data structure from input data objects. Starting with a root node, a set of sibling groups are generated for each distinct value of the `job` field. Then, within each job, an additional set of sibling nodes are generated for each distinct value of the `region` field. Finally, all input data objects within that group are included as leaves.

For example, given this input data:

```json
[
  {"id": "A", "job": "Doctor", "region": "East"},
  {"id": "B", "job": "Doctor", "region": "East"},
  {"id": "C", "job": "Lawyer", "region": "East"},
  {"id": "D", "job": "Lawyer", "region": "East"},
  {"id": "E", "job": "Doctor", "region": "West"},
  {"id": "F", "job": "Doctor", "region": "West"},
  {"id": "G", "job": "Lawyer", "region": "West"},
  {"id": "H", "job": "Lawyer", "region": "West"}
]
```

The resulting tree structure is:

```
                  /- East - [A, B]
       /- Doctor -
      /           \- West - [E, F]
Root -
      \           /- East - [C, D]
       \- Lawyer -
                  \- West - [G, H]
```

If the _generate_ parameter is set to `true`, the output data stream will also include data objects for the generated internal nodes. In the example above, the output data stream is:

{: .suppress-error}
```js
[
  // original input nodes
  {"id": "A", "job": "Doctor", "region": "East"},
  {"id": "B", "job": "Doctor", "region": "East"},
  {"id": "C", "job": "Lawyer", "region": "East"},
  {"id": "D", "job": "Lawyer", "region": "East"},
  {"id": "E", "job": "Doctor", "region": "West"},
  {"id": "F", "job": "Doctor", "region": "West"},
  {"id": "G", "job": "Lawyer", "region": "West"},
  {"id": "H", "job": "Lawyer", "region": "West"},

  // generated internal nodes
  // for the root node, key is undefined
  // values arrays contain nested groups of objects
  {"values": [ ... ] },
  {"key": "Doctor", "values": [ ... ]},
  {"key": "Lawyer", "values": [ ... ] },
  {"key": "East", "values": [ ... ]},
  {"key": "West", "values": [ ... ]},
  {"key": "East", "values": [ ... ]},
  {"key": "West", "values": [ ... ]}
]
```
