var docData=[{comment:"/**\n* @file base-styles.js\n*\n* This code injects the required base styles in the head of the document.\n*/",meta:{range:[0,105],filename:"base-styles.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},name:"base-styles.js",kind:"file",description:"<p>base-styles.js</p>\n<p>This code injects the required base styles in the head of the document.</p>",preserveName:!0,longname:"base-styles.js",scope:"global"},{comment:"/**\n* @file big-play-button.js\n*/",meta:{range:[0,33],filename:"big-play-button.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},name:"big-play-button.js",kind:"file",description:"<p>big-play-button.js</p>",preserveName:!0,longname:"big-play-button.js",scope:"global"},{comment:"/**\n* Initial play button. Shows before the video has played. The hiding of the\n* big play button is done via CSS and player states.\n*\n* @param {Object} player  Main Player\n* @param {Object=} options Object of option names and values\n* @extends Button\n* @class BigPlayButton\n*/",meta:{range:[43,320],filename:"big-play-button.js",lineno:7,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Initial play button. Shows before the video has played. The hiding of the\nbig play button is done via CSS and player states.</p>",params:[{type:{names:["Object"]},description:"<p>Main Player</p>",name:"player"},{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"}],augments:["Button"],kind:"class",name:"BigPlayButton",longname:"BigPlayButton",scope:"global"},{comment:"/**\n* Allow sub components to stack CSS class names\n*\n* @return {String} The constructed class name\n* @method buildCSSClass\n*/",meta:{range:[339,465],filename:"big-play-button.js",lineno:22,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Allow sub components to stack CSS class names</p>",returns:[{type:{names:["String"]},description:"<p>The constructed class name</p>"}],kind:"function",name:"buildCSSClass",longname:"buildCSSClass",scope:"global"},{comment:"/**\n* Handles click for play\n*\n* @method handleClick\n*/",meta:{range:[478,533],filename:"big-play-button.js",lineno:32,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Handles click for play</p>",kind:"function",name:"handleClick",longname:"handleClick",scope:"global"},{comment:"/**\n* @file button.js\n*/",meta:{range:[0,24],filename:"button.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},name:"button.js",kind:"file",description:"<p>button.js</p>",preserveName:!0,longname:"button.js",scope:"global"},{comment:"/**\n* Base class for all buttons\n*\n* @param {Object} player  Main Player\n* @param {Object=} options Object of option names and values\n* @extends ClickableComponent\n* @class Button\n*/",meta:{range:[49,231],filename:"button.js",lineno:12,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Base class for all buttons</p>",params:[{type:{names:["Object"]},description:"<p>Main Player</p>",name:"player"},{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"}],augments:["ClickableComponent"],kind:"class",name:"Button",longname:"Button",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @param {String=} type Element's node type. e.g. 'div'\n* @param {Object=} props An object of properties that should be set on the element\n* @param {Object=} attributes An object of attributes that should be set on the element\n* @return {Element}\n* @method createEl\n*/",meta:{range:[250,561],filename:"button.js",lineno:26,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Create the component's DOM element</p>",params:[{type:{names:["String"]},optional:!0,description:"<p>Element's node type. e.g. 'div'</p>",name:"type"},{type:{names:["Object"]},optional:!0,description:"<p>An object of properties that should be set on the element</p>",name:"props"},{type:{names:["Object"]},optional:!0,description:"<p>An object of attributes that should be set on the element</p>",name:"attributes"}],returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Adds a child component inside this button\n*\n* @param {String|Component} child The class name or instance of a child to add\n* @param {Object=} options Options, including options to be passed to children of the child.\n* @return {Component} The child component (created by this process if a string was used)\n* @deprecated\n* @method addChild\n*/",meta:{range:[658,1004],filename:"button.js",lineno:67,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Adds a child component inside this button</p>",params:[{type:{names:["String","Component"]},description:"<p>The class name or instance of a child to add</p>",name:"child"},{type:{names:["Object"]},optional:!0,description:"<p>Options, including options to be passed to children of the child.</p>",name:"options"}],returns:[{type:{names:["Component"]},description:"<p>The child component (created by this process if a string was used)</p>"}],deprecated:!0,kind:"function",name:"addChild",longname:"addChild",scope:"global"},{comment:"/**\n* Handle KeyPress (document level) - Extend with specific functionality for button\n*\n* @method handleKeyPress\n*/",meta:{range:[1029,1145],filename:"button.js",lineno:84,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Handle KeyPress (document level) - Extend with specific functionality for button</p>",kind:"function",name:"handleKeyPress",longname:"handleKeyPress",scope:"global"},{comment:"/**\n* @file button.js\n*/",meta:{range:[0,24],filename:"clickable-component.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},name:"clickable-component.js",kind:"file",description:"<p>button.js</p>",preserveName:!0,longname:"clickable-component.js",scope:"global"},{comment:"/**\n* Clickable Component which is clickable or keyboard actionable, but is not a native HTML button\n*\n* @param {Object} player  Main Player\n* @param {Object=} options Object of option names and values\n* @extends Component\n* @class ClickableComponent\n*/",meta:{range:[49,302],filename:"clickable-component.js",lineno:12,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Clickable Component which is clickable or keyboard actionable, but is not a native HTML button</p>",params:[{type:{names:["Object"]},description:"<p>Main Player</p>",name:"player"},{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"}],augments:["Component"],kind:"class",name:"ClickableComponent",longname:"ClickableComponent",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @param {String=} type Element's node type. e.g. 'div'\n* @param {Object=} props An object of properties that should be set on the element\n* @param {Object=} attributes An object of attributes that should be set on the element\n* @return {Element}\n* @method createEl\n*/",meta:{range:[342,653],filename:"clickable-component.js",lineno:33,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Create the component's DOM element</p>",params:[{type:{names:["String"]},optional:!0,description:"<p>Element's node type. e.g. 'div'</p>",name:"type"},{type:{names:["Object"]},optional:!0,description:"<p>An object of properties that should be set on the element</p>",name:"props"},{type:{names:["Object"]},optional:!0,description:"<p>An object of attributes that should be set on the element</p>",name:"attributes"}],returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* create control text\n*\n* @param {Element} el Parent element for the control text\n* @return {Element}\n* @method controlText\n*/",meta:{range:[723,853],filename:"clickable-component.js",lineno:65,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>create control text</p>",params:[{type:{names:["Element"]},description:"<p>Parent element for the control text</p>",name:"el"}],returns:[{type:{names:["Element"]}}],kind:"function",name:"controlText",longname:"controlText",scope:"global"},{comment:"/**\n* Controls text - both request and localize\n*\n* @param {String}  text Text for element\n* @param {Element=} el Element to set the title on\n* @return {String}\n* @method controlText\n*/",meta:{range:[896,1081],filename:"clickable-component.js",lineno:86,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Controls text - both request and localize</p>",params:[{type:{names:["String"]},description:"<p>Text for element</p>",name:"text"},{type:{names:["Element"]},optional:!0,description:"<p>Element to set the title on</p>",name:"el"}],returns:[{type:{names:["String"]}}],kind:"function",name:"controlText",longname:"controlText",scope:"global"},{comment:"/**\n* Allows sub components to stack CSS class names\n*\n* @return {String}\n* @method buildCSSClass\n*/",meta:{range:[1118,1218],filename:"clickable-component.js",lineno:106,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Allows sub components to stack CSS class names</p>",returns:[{type:{names:["String"]}}],kind:"function",name:"buildCSSClass",longname:"buildCSSClass",scope:"global"},{comment:"/**\n* Adds a child component inside this clickable-component\n*\n* @param {String|Component} child The class name or instance of a child to add\n* @param {Object=} options Options, including options to be passed to children of the child.\n* @return {Component} The child component (created by this process if a string was used)\n* @method addChild\n*/",meta:{range:[1231,1576],filename:"clickable-component.js",lineno:116,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Adds a child component inside this clickable-component</p>",params:[{type:{names:["String","Component"]},description:"<p>The class name or instance of a child to add</p>",name:"child"},{type:{names:["Object"]},optional:!0,description:"<p>Options, including options to be passed to children of the child.</p>",name:"options"}],returns:[{type:{names:["Component"]},description:"<p>The child component (created by this process if a string was used)</p>"}],kind:"function",name:"addChild",longname:"addChild",scope:"global"},{comment:"/**\n* Enable the component element\n*\n* @return {Component}\n* @method enable\n*/",meta:{range:[1613,1691],filename:"clickable-component.js",lineno:136,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Enable the component element</p>",returns:[{type:{names:["Component"]}}],kind:"function",name:"enable",longname:"enable",scope:"global"},{comment:"/**\n* Disable the component element\n*\n* @return {Component}\n* @method disable\n*/",meta:{range:[1710,1790],filename:"clickable-component.js",lineno:148,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Disable the component element</p>",returns:[{type:{names:["Component"]}}],kind:"function",name:"disable",longname:"disable",scope:"global"},{comment:"/**\n* Handle Click - Override with specific functionality for component\n*\n* @method handleClick\n*/",meta:{range:[1809,1907],filename:"clickable-component.js",lineno:160,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Handle Click - Override with specific functionality for component</p>",kind:"function",name:"handleClick",longname:"handleClick",scope:"global"},{comment:"/**\n* Handle Focus - Add keyboard functionality to element\n*\n* @method handleFocus\n*/",meta:{range:[1914,1999],filename:"clickable-component.js",lineno:167,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Handle Focus - Add keyboard functionality to element</p>",kind:"function",name:"handleFocus",longname:"handleFocus",scope:"global"},{comment:"/**\n* Handle KeyPress (document level) - Trigger click when Space or Enter key is pressed\n*\n* @method handleKeyPress\n*/",meta:{range:[2012,2131],filename:"clickable-component.js",lineno:176,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Handle KeyPress (document level) - Trigger click when Space or Enter key is pressed</p>",kind:"function",name:"handleKeyPress",longname:"handleKeyPress",scope:"global"},{comment:"/**\n* Handle Blur - Remove keyboard triggers\n*\n* @method handleBlur\n*/",meta:{range:[2162,2232],filename:"clickable-component.js",lineno:191,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Handle Blur - Remove keyboard triggers</p>",kind:"function",name:"handleBlur",longname:"handleBlur",scope:"global"},{comment:'/**\n* The `CloseButton` component is a button which fires a "close" event\n* when it is activated.\n*\n* @extends Button\n* @class CloseButton\n*/',meta:{range:[9,150],filename:"close-button.js",lineno:4,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>The <code>CloseButton</code> component is a button which fires a &quot;close&quot; event\nwhen it is activated.</p>",augments:["Button"],kind:"class",name:"CloseButton",longname:"CloseButton",scope:"global"},{comment:"/**\n* @file component.js\n*\n* Player Component - Base class for all UI objects\n*/",meta:{range:[0,80],filename:"component.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},name:"component.js",kind:"file",description:"<p>component.js</p>\n<p>Player Component - Base class for all UI objects</p>",preserveName:!0,longname:"component.js",scope:"global"},{comment:"/**\n* Base UI Component class\n* Components are embeddable UI objects that are represented by both a\n* javascript object and an element in the DOM. They can be children of other\n* components, and can have many children themselves.\n* ```js\n*     // adding a button to the player\n*     var button = player.addChild('button');\n*     button.el(); // -> button element\n* ```\n* ```html\n*     <div class=\"video-js\">\n*       <div class=\"vjs-button\">Button</div>\n*     </div>\n* ```\n* Components are also event targets.\n* ```js\n*     button.on('click', function(){\n*       console.log('Button Clicked!');\n*     });\n*     button.trigger('customevent');\n* ```\n*\n* @param {Object} player  Main Player\n* @param {Object=} options Object of option names and values\n* @param {Function=} ready    Ready callback function\n* @class Component\n*/",meta:{range:[114,937],filename:"component.js",lineno:17,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Base UI Component class\nComponents are embeddable UI objects that are represented by both a\njavascript object and an element in the DOM. They can be children of other\ncomponents, and can have many children themselves.</p>\n<pre class=\"prettyprint source lang-js\"><code>    // adding a button to the player\n    var button = player.addChild('button');\n    button.el(); // -> button element</code></pre><pre class=\"prettyprint source lang-html\"><code>    &lt;div class=&quot;video-js&quot;>\n      &lt;div class=&quot;vjs-button&quot;>Button&lt;/div>\n    &lt;/div></code></pre><p>Components are also event targets.</p>\n<pre class=\"prettyprint source lang-js\"><code>    button.on('click', function(){\n      console.log('Button Clicked!');\n    });\n    button.trigger('customevent');</code></pre>",params:[{type:{names:["Object"]},description:"<p>Main Player</p>",name:"player"},{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"},{type:{names:["function"]},optional:!0,description:"<p>Ready callback function</p>",name:"ready"}],kind:"class",name:"Component",longname:"Component",scope:"global"},{comment:"/**\n* Dispose of the component and all child components\n*\n* @method dispose\n*/",meta:{range:[1103,1181],filename:"component.js",lineno:100,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Dispose of the component and all child components</p>",kind:"function",name:"dispose",longname:"dispose",scope:"global"},{comment:"/**\n* Return the component's player\n*\n* @return {Player}\n* @method player\n*/",meta:{range:[1269,1345],filename:"component.js",lineno:134,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Return the component's player</p>",returns:[{type:{names:["Player"]}}],kind:"function",name:"player",longname:"player",scope:"global"},{comment:"/**\n* Deep merge of options objects\n* Whenever a property is an object on both options objects\n* the two properties will be merged using mergeOptions.\n*\n* ```js\n*     Parent.prototype.options_ = {\n*       optionSet: {\n*         'childOne': { 'foo': 'bar', 'asdf': 'fdsa' },\n*         'childTwo': {},\n*         'childThree': {}\n*       }\n*     }\n*     newOptions = {\n*       optionSet: {\n*         'childOne': { 'foo': 'baz', 'abc': '123' }\n*         'childTwo': null,\n*         'childFour': {}\n*       }\n*     }\n*\n*     this.options(newOptions);\n* ```\n* RESULT\n* ```js\n*     {\n*       optionSet: {\n*         'childOne': { 'foo': 'baz', 'asdf': 'fdsa', 'abc': '123' },\n*         'childTwo': null, // Disabled. Won't be initialized.\n*         'childThree': {},\n*         'childFour': {}\n*       }\n*     }\n* ```\n*\n* @param  {Object} obj Object of new option values\n* @return {Object}     A NEW object of this.options_ and obj merged\n* @method options\n*/",meta:{range:[1358,2308],filename:"component.js",lineno:144,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Deep merge of options objects\nWhenever a property is an object on both options objects\nthe two properties will be merged using mergeOptions.</p>\n<pre class=\"prettyprint source lang-js\"><code>    Parent.prototype.options_ = {\n      optionSet: {\n        'childOne': { 'foo': 'bar', 'asdf': 'fdsa' },\n        'childTwo': {},\n        'childThree': {}\n      }\n    }\n    newOptions = {\n      optionSet: {\n        'childOne': { 'foo': 'baz', 'abc': '123' }\n        'childTwo': null,\n        'childFour': {}\n      }\n    }\n\n    this.options(newOptions);</code></pre><p>RESULT</p>\n<pre class=\"prettyprint source lang-js\"><code>    {\n      optionSet: {\n        'childOne': { 'foo': 'baz', 'asdf': 'fdsa', 'abc': '123' },\n        'childTwo': null, // Disabled. Won't be initialized.\n        'childThree': {},\n        'childFour': {}\n      }\n    }</code></pre>",params:[{type:{names:["Object"]},description:"<p>Object of new option values</p>",name:"obj"}],returns:[{type:{names:["Object"]},description:"<p>A NEW object of this.options_ and obj merged</p>"}],kind:"function",name:"options",longname:"options",scope:"global"},{comment:"/**\n* Get the component's DOM element\n* ```js\n*     var domEl = myComponent.el();\n* ```\n*\n* @return {Element}\n* @method el\n*/",meta:{range:[2342,2467],filename:"component.js",lineno:194,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>Get the component\'s DOM element</p>\n<pre class="prettyprint source lang-js"><code>    var domEl = myComponent.el();</code></pre>',returns:[{type:{names:["Element"]}}],kind:"function",name:"el",longname:"el",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @param  {String=} tagName  Element's node type. e.g. 'div'\n* @param  {Object=} properties An object of properties that should be set\n* @param  {Object=} attributes An object of attributes that should be set\n* @return {Element}\n* @method createEl\n*/",meta:{range:[2480,2773],filename:"component.js",lineno:207,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Create the component's DOM element</p>",params:[{type:{names:["String"]},optional:!0,description:"<p>Element's node type. e.g. 'div'</p>",name:"tagName"},{type:{names:["Object"]},optional:!0,description:"<p>An object of properties that should be set</p>",name:"properties"},{type:{names:["Object"]},optional:!0,description:"<p>An object of attributes that should be set</p>",name:"attributes"}],returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Return the component's DOM element where children are inserted.\n* Will either be the same as el() or a new element defined in createEl().\n*\n* @return {Element}\n* @method contentEl\n*/",meta:{range:[2858,3046],filename:"component.js",lineno:244,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Return the component's DOM element where children are inserted.\nWill either be the same as el() or a new element defined in createEl().</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"contentEl",longname:"contentEl",scope:"global"},{comment:"/**\n* Get the component's ID\n* ```js\n*     var id = myComponent.id();\n* ```\n*\n* @return {String}\n* @method id\n*/",meta:{range:[3059,3171],filename:"component.js",lineno:255,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>Get the component\'s ID</p>\n<pre class="prettyprint source lang-js"><code>    var id = myComponent.id();</code></pre>',returns:[{type:{names:["String"]}}],kind:"function",name:"id",longname:"id",scope:"global"},{comment:"/**\n* Get the component's name. The name is often used to reference the component.\n* ```js\n*     var name = myComponent.name();\n* ```\n*\n* @return {String}\n* @method name\n*/",meta:{range:[3184,3356],filename:"component.js",lineno:268,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>Get the component\'s name. The name is often used to reference the component.</p>\n<pre class="prettyprint source lang-js"><code>    var name = myComponent.name();</code></pre>',returns:[{type:{names:["String"]}}],kind:"function",name:"name",longname:"name",scope:"global"},{comment:"/**\n* Get an array of all child components\n* ```js\n*     var kids = myComponent.children();\n* ```\n*\n* @return {Array} The children\n* @method children\n*/",meta:{range:[3369,3521],filename:"component.js",lineno:281,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>Get an array of all child components</p>\n<pre class="prettyprint source lang-js"><code>    var kids = myComponent.children();</code></pre>',returns:[{type:{names:["Array"]},description:"<p>The children</p>"}],kind:"function",name:"children",longname:"children",scope:"global"},{comment:"/**\n* Returns a child component with the provided ID\n*\n* @return {Component}\n* @method getChildById\n*/",meta:{range:[3534,3636],filename:"component.js",lineno:294,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Returns a child component with the provided ID</p>",returns:[{type:{names:["Component"]}}],kind:"function",name:"getChildById",longname:"getChildById",scope:"global"},{comment:"/**\n* Returns a child component with the provided name\n*\n* @return {Component}\n* @method getChild\n*/",meta:{range:[3649,3749],filename:"component.js",lineno:304,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Returns a child component with the provided name</p>",returns:[{type:{names:["Component"]}}],kind:"function",name:"getChild",longname:"getChild",scope:"global"},{comment:"/**\n* Adds a child component inside this component\n* ```js\n*     myComponent.el();\n*     // -> <div class='my-component'></div>\n*     myComponent.children();\n*     // [empty array]\n*\n*     var myButton = myComponent.addChild('MyButton');\n*     // -> <div class='my-component'><div class=\"my-button\">myButton<div></div>\n*     // -> myButton === myComponent.children()[0];\n* ```\n* Pass in options for child constructors and options for children of the child\n* ```js\n*     var myButton = myComponent.addChild('MyButton', {\n*       text: 'Press Me',\n*       buttonChildExample: {\n*         buttonChildOption: true\n*       }\n*     });\n* ```\n*\n* @param {String|Component} child The class name or instance of a child to add\n* @param {Object=} options Options, including options to be passed to children of the child.\n* @param {Number} index into our children array to attempt to add the child\n* @return {Component} The child component (created by this process if a string was used)\n* @method addChild\n*/",meta:{range:[3762,4758],filename:"component.js",lineno:314,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Adds a child component inside this component</p>\n<pre class=\"prettyprint source lang-js\"><code>    myComponent.el();\n    // -> &lt;div class='my-component'>&lt;/div>\n    myComponent.children();\n    // [empty array]\n\n    var myButton = myComponent.addChild('MyButton');\n    // -> &lt;div class='my-component'>&lt;div class=&quot;my-button&quot;>myButton&lt;div>&lt;/div>\n    // -> myButton === myComponent.children()[0];</code></pre><p>Pass in options for child constructors and options for children of the child</p>\n<pre class=\"prettyprint source lang-js\"><code>    var myButton = myComponent.addChild('MyButton', {\n      text: 'Press Me',\n      buttonChildExample: {\n        buttonChildOption: true\n      }\n    });</code></pre>",params:[{type:{names:["String","Component"]},description:"<p>The class name or instance of a child to add</p>",name:"child"},{type:{names:["Object"]},optional:!0,description:"<p>Options, including options to be passed to children of the child.</p>",name:"options"},{type:{names:["Number"]},description:"<p>into our children array to attempt to add the child</p>",name:"index"}],returns:[{type:{names:["Component"]},description:"<p>The child component (created by this process if a string was used)</p>"}],kind:"function",name:"addChild",longname:"addChild",scope:"global"},{comment:"/**\n* Remove a child component from this component's list of children, and the\n* child component's element from this component's element\n*\n* @param  {Component} component Component to remove\n* @method removeChild\n*/",meta:{range:[4984,5199],filename:"component.js",lineno:417,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Remove a child component from this component's list of children, and the\nchild component's element from this component's element</p>",params:[{type:{names:["Component"]},description:"<p>Component to remove</p>",name:"component"}],kind:"function",name:"removeChild",longname:"removeChild",scope:"global"},{comment:"/**\n* Add and initialize default child components from options\n* ```js\n*     // when an instance of MyComponent is created, all children in options\n*     // will be added to the instance by their name strings and options\n*     MyComponent.prototype.options_ = {\n*       children: [\n*         'myChildComponent'\n*       ],\n*       myChildComponent: {\n*         myChildOption: true\n*       }\n*     };\n*\n*     // Or when creating the component\n*     var myComp = new MyComponent(player, {\n*       children: [\n*         'myChildComponent'\n*       ],\n*       myChildComponent: {\n*         myChildOption: true\n*       }\n*     });\n* ```\n* The children option can also be an array of\n* child options objects (that also include a 'name' key).\n* This can be used if you have two child components of the\n* same type that need different options.\n* ```js\n*     var myComp = new MyComponent(player, {\n*       children: [\n*         'button',\n*         {\n*           name: 'button',\n*           someOtherOption: true\n*         },\n*         {\n*           name: 'button',\n*           someOtherOption: false\n*         }\n*       ]\n*     });\n* ```\n*\n* @method initChildren\n*/",meta:{range:[5299,6453],filename:"component.js",lineno:457,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Add and initialize default child components from options</p>\n<pre class=\"prettyprint source lang-js\"><code>    // when an instance of MyComponent is created, all children in options\n    // will be added to the instance by their name strings and options\n    MyComponent.prototype.options_ = {\n      children: [\n        'myChildComponent'\n      ],\n      myChildComponent: {\n        myChildOption: true\n      }\n    };\n\n    // Or when creating the component\n    var myComp = new MyComponent(player, {\n      children: [\n        'myChildComponent'\n      ],\n      myChildComponent: {\n        myChildOption: true\n      }\n    });</code></pre><p>The children option can also be an array of\nchild options objects (that also include a 'name' key).\nThis can be used if you have two child components of the\nsame type that need different options.</p>\n<pre class=\"prettyprint source lang-js\"><code>    var myComp = new MyComponent(player, {\n      children: [\n        'button',\n        {\n          name: 'button',\n          someOtherOption: true\n        },\n        {\n          name: 'button',\n          someOtherOption: false\n        }\n      ]\n    });</code></pre>",kind:"function",name:"initChildren",longname:"initChildren",scope:"global"},{comment:"/**\n* Allows sub components to stack CSS class names\n*\n* @return {String} The constructed class name\n* @method buildCSSClass\n*/",meta:{range:[6730,6857],filename:"component.js",lineno:595,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Allows sub components to stack CSS class names</p>",returns:[{type:{names:["String"]},description:"<p>The constructed class name</p>"}],kind:"function",name:"buildCSSClass",longname:"buildCSSClass",scope:"global"},{comment:"/**\n* Add an event listener to this component's element\n* ```js\n*     var myFunc = function(){\n*       var myComponent = this;\n*       // Do something when the event is fired\n*     };\n*\n*     myComponent.on('eventType', myFunc);\n* ```\n* The context of myFunc will be myComponent unless previously bound.\n* Alternatively, you can add a listener to another element or component.\n* ```js\n*     myComponent.on(otherElement, 'eventName', myFunc);\n*     myComponent.on(otherComponent, 'eventName', myFunc);\n* ```\n* The benefit of using this over `VjsEvents.on(otherElement, 'eventName', myFunc)`\n* and `otherComponent.on('eventName', myFunc)` is that this way the listeners\n* will be automatically cleaned up when either component is disposed.\n* It will also bind myComponent as the context of myFunc.\n* **NOTE**: When using this on elements in the page other than window\n* and document (both permanent), if you remove the element from the DOM\n* you need to call `myComponent.trigger(el, 'dispose')` on it to clean up\n* references to it and allow the browser to garbage collect it.\n*\n* @param  {String|Component} first   The event type or other component\n* @param  {Function|String}      second  The event handler or event type\n* @param  {Function}             third   The event handler\n* @return {Component}\n* @method on\n*/",meta:{range:[6876,8194],filename:"component.js",lineno:607,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Add an event listener to this component's element</p>\n<pre class=\"prettyprint source lang-js\"><code>    var myFunc = function(){\n      var myComponent = this;\n      // Do something when the event is fired\n    };\n\n    myComponent.on('eventType', myFunc);</code></pre><p>The context of myFunc will be myComponent unless previously bound.\nAlternatively, you can add a listener to another element or component.</p>\n<pre class=\"prettyprint source lang-js\"><code>    myComponent.on(otherElement, 'eventName', myFunc);\n    myComponent.on(otherComponent, 'eventName', myFunc);</code></pre><p>The benefit of using this over <code>VjsEvents.on(otherElement, 'eventName', myFunc)</code>\nand <code>otherComponent.on('eventName', myFunc)</code> is that this way the listeners\nwill be automatically cleaned up when either component is disposed.\nIt will also bind myComponent as the context of myFunc.\n<strong>NOTE</strong>: When using this on elements in the page other than window\nand document (both permanent), if you remove the element from the DOM\nyou need to call <code>myComponent.trigger(el, 'dispose')</code> on it to clean up\nreferences to it and allow the browser to garbage collect it.</p>",
params:[{type:{names:["String","Component"]},description:"<p>The event type or other component</p>",name:"first"},{type:{names:["function","String"]},description:"<p>The event handler or event type</p>",name:"second"},{type:{names:["function"]},description:"<p>The event handler</p>",name:"third"}],returns:[{type:{names:["Component"]}}],kind:"function",name:"on",longname:"on",scope:"global"},{comment:"/**\n* Remove an event listener from this component's element\n* ```js\n*     myComponent.off('eventType', myFunc);\n* ```\n* If myFunc is excluded, ALL listeners for the event type will be removed.\n* If eventType is excluded, ALL listeners will be removed from the component.\n* Alternatively you can use `off` to remove listeners that were added to other\n* elements or components using `myComponent.on(otherComponent...`.\n* In this case both the event type and listener function are REQUIRED.\n* ```js\n*     myComponent.off(otherElement, 'eventType', myFunc);\n*     myComponent.off(otherComponent, 'eventType', myFunc);\n* ```\n*\n* @param  {String=|Component}  first  The event type or other component\n* @param  {Function=|String}       second The listener function or event type\n* @param  {Function=}              third  The listener for other component\n* @return {Component}\n* @method off\n*/",meta:{range:[8327,9213],filename:"component.js",lineno:682,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Remove an event listener from this component's element</p>\n<pre class=\"prettyprint source lang-js\"><code>    myComponent.off('eventType', myFunc);</code></pre><p>If myFunc is excluded, ALL listeners for the event type will be removed.\nIf eventType is excluded, ALL listeners will be removed from the component.\nAlternatively you can use <code>off</code> to remove listeners that were added to other\nelements or components using <code>myComponent.on(otherComponent...</code>.\nIn this case both the event type and listener function are REQUIRED.</p>\n<pre class=\"prettyprint source lang-js\"><code>    myComponent.off(otherElement, 'eventType', myFunc);\n    myComponent.off(otherComponent, 'eventType', myFunc);</code></pre>",params:[{type:{names:["String","Component"]},description:"<p>The event type or other component</p>",name:"first"},{type:{names:["function","String"]},description:"<p>The listener function or event type</p>",name:"second"},{type:{names:["function"]},optional:!0,description:"<p>The listener for other component</p>",name:"third"}],returns:[{type:{names:["Component"]}}],kind:"function",name:"off",longname:"off",scope:"global"},{comment:"/**\n* Add an event listener to be triggered only once and then removed\n* ```js\n*     myComponent.one('eventName', myFunc);\n* ```\n* Alternatively you can add a listener to another element or component\n* that will be triggered only once.\n* ```js\n*     myComponent.one(otherElement, 'eventName', myFunc);\n*     myComponent.one(otherComponent, 'eventName', myFunc);\n* ```\n*\n* @param  {String|Component}  first   The event type or other component\n* @param  {Function|String}       second  The listener function or event type\n* @param  {Function=}             third   The listener function for other component\n* @return {Component}\n* @method one\n*/",meta:{range:[9295,9937],filename:"component.js",lineno:730,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Add an event listener to be triggered only once and then removed</p>\n<pre class=\"prettyprint source lang-js\"><code>    myComponent.one('eventName', myFunc);</code></pre><p>Alternatively you can add a listener to another element or component\nthat will be triggered only once.</p>\n<pre class=\"prettyprint source lang-js\"><code>    myComponent.one(otherElement, 'eventName', myFunc);\n    myComponent.one(otherComponent, 'eventName', myFunc);</code></pre>",params:[{type:{names:["String","Component"]},description:"<p>The event type or other component</p>",name:"first"},{type:{names:["function","String"]},description:"<p>The listener function or event type</p>",name:"second"},{type:{names:["function"]},optional:!0,description:"<p>The listener function for other component</p>",name:"third"}],returns:[{type:{names:["Component"]}}],kind:"function",name:"one",longname:"one",scope:"global"},{comment:"/**\n* Trigger an event on an element\n* ```js\n*     myComponent.trigger('eventName');\n*     myComponent.trigger({'type':'eventName'});\n*     myComponent.trigger('eventName', {data: 'some data'});\n*     myComponent.trigger({'type':'eventName'}, {data: 'some data'});\n* ```\n*\n* @param  {Event|Object|String} event  A string (the type) or an event object with a type attribute\n* @param  {Object} [hash] data hash to pass along with the event\n* @return {Component}       self\n* @method trigger\n*/",meta:{range:[10004,10495],filename:"component.js",lineno:770,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Trigger an event on an element</p>\n<pre class=\"prettyprint source lang-js\"><code>    myComponent.trigger('eventName');\n    myComponent.trigger({'type':'eventName'});\n    myComponent.trigger('eventName', {data: 'some data'});\n    myComponent.trigger({'type':'eventName'}, {data: 'some data'});</code></pre>",params:[{type:{names:["Event","Object","String"]},description:"<p>A string (the type) or an event object with a type attribute</p>",name:"event"},{type:{names:["Object"]},optional:!0,description:"<p>data hash to pass along with the event</p>",name:"hash"}],returns:[{type:{names:["Component"]},description:"<p>self</p>"}],kind:"function",name:"trigger",longname:"trigger",scope:"global"},{comment:"/**\n* Bind a listener to the component's ready state.\n* Different from event listeners in that if the ready event has already happened\n* it will trigger the function immediately.\n*\n* @param  {Function} fn Ready listener\n* @param  {Boolean} sync Exec the listener synchronously if component is ready\n* @return {Component}\n* @method ready\n*/",meta:{range:[10511,10850],filename:"component.js",lineno:789,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Bind a listener to the component's ready state.\nDifferent from event listeners in that if the ready event has already happened\nit will trigger the function immediately.</p>",params:[{type:{names:["function"]},description:"<p>Ready listener</p>",name:"fn"},{type:{names:["Boolean"]},description:"<p>Exec the listener synchronously if component is ready</p>",name:"sync"}],returns:[{type:{names:["Component"]}}],kind:"function",name:"ready",longname:"ready",scope:"global"},{comment:"/**\n* Trigger the ready listeners\n*\n* @return {Component}\n* @method triggerReady\n*/",meta:{range:[10902,10985],filename:"component.js",lineno:816,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Trigger the ready listeners</p>",returns:[{type:{names:["Component"]}}],kind:"function",name:"triggerReady",longname:"triggerReady",scope:"global"},{comment:"/**\n* Finds a single DOM element matching `selector` within the component's\n* `contentEl` or another custom context.\n*\n* @method $\n* @param  {String} selector\n*         A valid CSS selector, which will be passed to `querySelector`.\n*\n* @param  {Element|String} [context=document]\n*         A DOM element within which to query. Can also be a selector\n*         string in which case the first matching element will be used\n*         as context. If missing (or no element matches selector), falls\n*         back to `document`.\n*\n* @return {Element|null}\n*/",meta:{range:[11049,11602],filename:"component.js",lineno:843,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Finds a single DOM element matching <code>selector</code> within the component's\n<code>contentEl</code> or another custom context.</p>",kind:"function",name:"$",params:[{type:{names:["String"]},description:"<p>A valid CSS selector, which will be passed to <code>querySelector</code>.</p>",name:"selector"},{type:{names:["Element","String"]},optional:!0,defaultvalue:"document",description:"<p>A DOM element within which to query. Can also be a selector\n        string in which case the first matching element will be used\n        as context. If missing (or no element matches selector), falls\n        back to <code>document</code>.</p>",name:"context"}],returns:[{type:{names:["Element","null"]}}],longname:"$",scope:"global"},{comment:"/**\n* Finds a all DOM elements matching `selector` within the component's\n* `contentEl` or another custom context.\n*\n* @method $$\n* @param  {String} selector\n*         A valid CSS selector, which will be passed to `querySelectorAll`.\n*\n* @param  {Element|String} [context=document]\n*         A DOM element within which to query. Can also be a selector\n*         string in which case the first matching element will be used\n*         as context. If missing (or no element matches selector), falls\n*         back to `document`.\n*\n* @return {NodeList}\n*/",meta:{range:[11615,12166],filename:"component.js",lineno:863,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Finds a all DOM elements matching <code>selector</code> within the component's\n<code>contentEl</code> or another custom context.</p>",kind:"function",name:"$$",params:[{type:{names:["String"]},description:"<p>A valid CSS selector, which will be passed to <code>querySelectorAll</code>.</p>",name:"selector"},{type:{names:["Element","String"]},optional:!0,defaultvalue:"document",description:"<p>A DOM element within which to query. Can also be a selector\n        string in which case the first matching element will be used\n        as context. If missing (or no element matches selector), falls\n        back to <code>document</code>.</p>",name:"context"}],returns:[{type:{names:["NodeList"]}}],longname:"$$",scope:"global"},{comment:"/**\n* Check if a component's element has a CSS class name\n*\n* @param {String} classToCheck Classname to check\n* @return {Component}\n* @method hasClass\n*/",meta:{range:[12179,12332],filename:"component.js",lineno:883,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Check if a component's element has a CSS class name</p>",params:[{type:{names:["String"]},description:"<p>Classname to check</p>",name:"classToCheck"}],returns:[{type:{names:["Component"]}}],kind:"function",name:"hasClass",longname:"hasClass",scope:"global"},{comment:"/**\n* Add a CSS class name to the component's element\n*\n* @param {String} classToAdd Classname to add\n* @return {Component}\n* @method addClass\n*/",meta:{range:[12345,12490],filename:"component.js",lineno:894,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Add a CSS class name to the component's element</p>",params:[{type:{names:["String"]},description:"<p>Classname to add</p>",name:"classToAdd"}],returns:[{type:{names:["Component"]}}],kind:"function",name:"addClass",longname:"addClass",scope:"global"},{comment:"/**\n* Remove a CSS class name from the component's element\n*\n* @param {String} classToRemove Classname to remove\n* @return {Component}\n* @method removeClass\n*/",meta:{range:[12506,12665],filename:"component.js",lineno:906,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Remove a CSS class name from the component's element</p>",params:[{type:{names:["String"]},description:"<p>Classname to remove</p>",name:"classToRemove"}],returns:[{type:{names:["Component"]}}],kind:"function",name:"removeClass",longname:"removeClass",scope:"global"},{comment:"/**\n* Add or remove a CSS class name from the component's element\n*\n* @param  {String} classToToggle\n* @param  {Boolean|Function} [predicate]\n*         Can be a function that returns a Boolean. If `true`, the class\n*         will be added; if `false`, the class will be removed. If not\n*         given, the class will be added if not present and vice versa.\n*\n* @return {Component}\n* @method toggleClass\n*/",meta:{range:[12681,13087],filename:"component.js",lineno:918,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Add or remove a CSS class name from the component's element</p>",params:[{type:{names:["String"]},name:"classToToggle"},{type:{names:["Boolean","function"]},optional:!0,description:"<p>Can be a function that returns a Boolean. If <code>true</code>, the class\n        will be added; if <code>false</code>, the class will be removed. If not\n        given, the class will be added if not present and vice versa.</p>",name:"predicate"}],returns:[{type:{names:["Component"]}}],kind:"function",name:"toggleClass",longname:"toggleClass",scope:"global"},{comment:"/**\n* Show the component element if hidden\n*\n* @return {Component}\n* @method show\n*/",meta:{range:[13103,13187],filename:"component.js",lineno:935,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Show the component element if hidden</p>",returns:[{type:{names:["Component"]}}],kind:"function",name:"show",longname:"show",scope:"global"},{comment:"/**\n* Hide the component element if currently showing\n*\n* @return {Component}\n* @method hide\n*/",meta:{range:[13203,13298],filename:"component.js",lineno:946,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Hide the component element if currently showing</p>",returns:[{type:{names:["Component"]}}],kind:"function",name:"hide",longname:"hide",scope:"global"},{comment:"/**\n* Lock an item in its visible state\n* To be used with fadeIn/fadeOut.\n*\n* @return {Component}\n* @private\n* @method lockShowing\n*/",meta:{range:[13314,13447],filename:"component.js",lineno:957,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Lock an item in its visible state\nTo be used with fadeIn/fadeOut.</p>",returns:[{type:{names:["Component"]}}],access:"private",kind:"function",name:"lockShowing",longname:"lockShowing",scope:"global"},{comment:"/**\n* Unlock an item to be hidden\n* To be used with fadeIn/fadeOut.\n*\n* @return {Component}\n* @private\n* @method unlockShowing\n*/",meta:{range:[13463,13592],filename:"component.js",lineno:970,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Unlock an item to be hidden\nTo be used with fadeIn/fadeOut.</p>",returns:[{type:{names:["Component"]}}],access:"private",kind:"function",name:"unlockShowing",longname:"unlockShowing",scope:"global"},{comment:"/**\n* Set or get the width of the component (CSS values)\n* Setting the video tag dimension values only works with values in pixels.\n* Percent values will not work.\n* Some percents can be used, but width()/height() will return the number + %,\n* not the actual computed width/height.\n*\n* @param  {Number|String=} num   Optional width number\n* @param  {Boolean} skipListeners Skip the 'resize' event trigger\n* @return {Component} This component, when setting the width\n* @return {Number|String} The width, when getting\n* @method width\n*/",meta:{range:[13608,14142],filename:"component.js",lineno:983,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Set or get the width of the component (CSS values)\nSetting the video tag dimension values only works with values in pixels.\nPercent values will not work.\nSome percents can be used, but width()/height() will return the number + %,\nnot the actual computed width/height.</p>",params:[{type:{names:["Number","String"]},description:"<p>Optional width number</p>",name:"num"},{type:{names:["Boolean"]},description:"<p>Skip the 'resize' event trigger</p>",name:"skipListeners"}],returns:[{type:{names:["Component"]},description:"<p>This component, when setting the width</p>"},{type:{names:["Number","String"]},description:"<p>The width, when getting</p>"}],kind:"function",name:"width",longname:"width",scope:"global"},{comment:"/**\n* Get or set the height of the component (CSS values)\n* Setting the video tag dimension values only works with values in pixels.\n* Percent values will not work.\n* Some percents can be used, but width()/height() will return the number + %,\n* not the actual computed width/height.\n*\n* @param  {Number|String=} num     New component height\n* @param  {Boolean=} skipListeners Skip the resize event trigger\n* @return {Component} This component, when setting the height\n* @return {Number|String} The height, when getting\n* @method height\n*/",meta:{range:[14155,14693],filename:"component.js",lineno:1e3,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get or set the height of the component (CSS values)\nSetting the video tag dimension values only works with values in pixels.\nPercent values will not work.\nSome percents can be used, but width()/height() will return the number + %,\nnot the actual computed width/height.</p>",params:[{type:{names:["Number","String"]},description:"<p>New component height</p>",name:"num"},{type:{names:["Boolean"]},optional:!0,description:"<p>Skip the resize event trigger</p>",name:"skipListeners"}],returns:[{type:{names:["Component"]},description:"<p>This component, when setting the height</p>"},{type:{names:["Number","String"]},description:"<p>The height, when getting</p>"}],kind:"function",name:"height",longname:"height",scope:"global"},{comment:"/**\n* Set both width and height at the same time\n*\n* @param  {Number|String} width Width of player\n* @param  {Number|String} height Height of player\n* @return {Component} The component\n* @method dimensions\n*/",meta:{range:[14706,14914],filename:"component.js",lineno:1017,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Set both width and height at the same time</p>",params:[{type:{names:["Number","String"]},description:"<p>Width of player</p>",name:"width"},{type:{names:["Number","String"]},description:"<p>Height of player</p>",name:"height"}],returns:[{type:{names:["Component"]},description:"<p>The component</p>"}],kind:"function",name:"dimensions",longname:"dimensions",scope:"global"},{comment:"/**\n* Get or set width or height\n* This is the shared code for the width() and height() methods.\n* All for an integer, integer + 'px' or integer + '%';\n* Known issue: Hidden elements officially have a width of 0. We're defaulting\n* to the style.width value and falling back to computedStyle which has the\n* hidden element issue. Info, but probably not an efficient fix:\n* http://www.foliotek.com/devblog/getting-the-width-of-a-hidden-element-with-jquery-using-width/\n*\n* @param  {String} widthOrHeight  'width' or 'height'\n* @param  {Number|String=} num     New dimension\n* @param  {Boolean=} skipListeners Skip resize event trigger\n* @return {Component} The component if a dimension was set\n* @return {Number|String} The dimension if nothing was set\n* @private\n* @method dimension\n*/",meta:{range:[14930,15714],filename:"component.js",lineno:1030,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get or set width or height\nThis is the shared code for the width() and height() methods.\nAll for an integer, integer + 'px' or integer + '%';\nKnown issue: Hidden elements officially have a width of 0. We're defaulting\nto the style.width value and falling back to computedStyle which has the\nhidden element issue. Info, but probably not an efficient fix:\nhttp://www.foliotek.com/devblog/getting-the-width-of-a-hidden-element-with-jquery-using-width/</p>",params:[{type:{names:["String"]},description:"<p>'width' or 'height'</p>",name:"widthOrHeight"},{type:{names:["Number","String"]},description:"<p>New dimension</p>",name:"num"},{type:{names:["Boolean"]},optional:!0,description:"<p>Skip resize event trigger</p>",name:"skipListeners"}],returns:[{type:{names:["Component"]},description:"<p>The component if a dimension was set</p>"},{type:{names:["Number","String"]},description:"<p>The dimension if nothing was set</p>"}],access:"private",kind:"function",name:"dimension",longname:"dimension",scope:"global"},{comment:"/**\n* Get width or height of computed style\n* @param  {String} widthOrHeight  'width' or 'height'\n* @return {Number|Boolean} The bolean false if nothing was set\n* @method currentDimension\n*/",meta:{range:[15853,16043],filename:"component.js",lineno:1093,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get width or height of computed style</p>",params:[{type:{names:["String"]},description:"<p>'width' or 'height'</p>",name:"widthOrHeight"}],returns:[{type:{names:["Number","Boolean"]},description:"<p>The bolean false if nothing was set</p>"}],kind:"function",name:"currentDimension",longname:"currentDimension",scope:"global"},{comment:"/**\n* Get an object which contains width and height values of computed style\n* @return {Object} The dimensions of element\n* @method currentDimensions\n*/",meta:{range:[16110,16262],filename:"component.js",lineno:1121,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get an object which contains width and height values of computed style</p>",returns:[{type:{names:["Object"]},description:"<p>The dimensions of element</p>"}],kind:"function",name:"currentDimensions",longname:"currentDimensions",scope:"global"},{comment:"/**\n* Get width of computed style\n* @return {Integer}\n* @method currentWidth\n*/",meta:{range:[16284,16363],filename:"component.js",lineno:1133,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get width of computed style</p>",returns:[{type:{names:["Integer"]}}],kind:"function",name:"currentWidth",longname:"currentWidth",scope:"global"},{comment:"/**\n* Get height of computed style\n* @return {Integer}\n* @method currentHeight\n*/",meta:{range:[16376,16457],filename:"component.js",lineno:1142,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get height of computed style</p>",returns:[{type:{names:["Integer"]}}],kind:"function",name:"currentHeight",longname:"currentHeight",scope:"global"},{comment:"/**\n* Emit 'tap' events when touch events are supported\n* This is used to support toggling the controls through a tap on the video.\n* We're requiring them to be enabled because otherwise every component would\n* have this extra overhead unnecessarily, on mobile devices where extra\n* overhead is especially bad.\n*\n* @private\n* @method emitTapEvents\n*/",meta:{range:[16470,16820],filename:"component.js",lineno:1151,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Emit 'tap' events when touch events are supported\nThis is used to support toggling the controls through a tap on the video.\nWe're requiring them to be enabled because otherwise every component would\nhave this extra overhead unnecessarily, on mobile devices where extra\noverhead is especially bad.</p>",access:"private",kind:"function",name:"emitTapEvents",longname:"emitTapEvents",scope:"global"},{comment:"/**\n* Report user touch activity when touch events occur\n* User activity is used to determine when controls should show/hide. It's\n* relatively simple when it comes to mouse events, because any mouse event\n* should show the controls. So we capture mouse events that bubble up to the\n* player and report activity when that happens.\n* With touch events it isn't as easy. We can't rely on touch events at the\n* player level, because a tap (touchstart + touchend) on the video itself on\n* mobile devices is meant to turn controls off (and on). User activity is\n* checked asynchronously, so what could happen is a tap event on the video\n* turns the controls off, then the touchend event bubbles up to the player,\n* which if it reported user activity, would turn the controls right back on.\n* (We also don't want to completely block touch events from bubbling up)\n* Also a touchmove, touch+hold, and anything other than a tap is not supposed\n* to turn the controls back on on a mobile device.\n* Here we're setting the default component behavior to report user activity\n* whenever touch events happen, and this can be turned off by components that\n* want touch events to act differently.\n*\n* @method enableTouchActivity\n*/",meta:{range:[17049,18264],filename:"component.js",lineno:1237,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Report user touch activity when touch events occur\nUser activity is used to determine when controls should show/hide. It's\nrelatively simple when it comes to mouse events, because any mouse event\nshould show the controls. So we capture mouse events that bubble up to the\nplayer and report activity when that happens.\nWith touch events it isn't as easy. We can't rely on touch events at the\nplayer level, because a tap (touchstart + touchend) on the video itself on\nmobile devices is meant to turn controls off (and on). User activity is\nchecked asynchronously, so what could happen is a tap event on the video\nturns the controls off, then the touchend event bubbles up to the player,\nwhich if it reported user activity, would turn the controls right back on.\n(We also don't want to completely block touch events from bubbling up)\nAlso a touchmove, touch+hold, and anything other than a tap is not supposed\nto turn the controls back on on a mobile device.\nHere we're setting the default component behavior to report user activity\nwhenever touch events happen, and this can be turned off by components that\nwant touch events to act differently.</p>",kind:"function",name:"enableTouchActivity",longname:"enableTouchActivity",scope:"global"},{comment:"/**\n* Creates timeout and sets up disposal automatically.\n*\n* @param {Function} fn The function to run after the timeout.\n* @param {Number} timeout Number of ms to delay before executing specified function.\n* @return {Number} Returns the timeout ID\n* @method setTimeout\n*/",meta:{range:[18361,18633],filename:"component.js",lineno:1290,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Creates timeout and sets up disposal automatically.</p>",params:[{type:{names:["function"]},description:"<p>The function to run after the timeout.</p>",name:"fn"},{type:{names:["Number"]},description:"<p>Number of ms to delay before executing specified function.</p>",name:"timeout"}],returns:[{type:{names:["Number"]},description:"<p>Returns the timeout ID</p>"}],kind:"function",name:"setTimeout",longname:"setTimeout",scope:"global"},{comment:"/**\n* Clears a timeout and removes the associated dispose listener\n*\n* @param {Number} timeoutId The id of the timeout to clear\n* @return {Number} Returns the timeout ID\n* @method clearTimeout\n*/",meta:{range:[18685,18880],filename:"component.js",lineno:1315,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Clears a timeout and removes the associated dispose listener</p>",params:[{type:{names:["Number"]},description:"<p>The id of the timeout to clear</p>",name:"timeoutId"}],returns:[{type:{names:["Number"]},description:"<p>Returns the timeout ID</p>"}],kind:"function",name:"clearTimeout",longname:"clearTimeout",scope:"global"},{comment:"/**\n* Creates an interval and sets up disposal automatically.\n*\n* @param {Function} fn The function to run every N seconds.\n* @param {Number} interval Number of ms to delay before executing specified function.\n* @return {Number} Returns the interval ID\n* @method setInterval\n*/",meta:{range:[18917,19194],filename:"component.js",lineno:1334,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Creates an interval and sets up disposal automatically.</p>",params:[{type:{names:["function"]},description:"<p>The function to run every N seconds.</p>",name:"fn"},{type:{names:["Number"]},description:"<p>Number of ms to delay before executing specified function.</p>",name:"interval"}],returns:[{type:{names:["Number"]},description:"<p>Returns the interval ID</p>"}],kind:"function",name:"setInterval",longname:"setInterval",scope:"global"},{comment:"/**\n* Clears an interval and removes the associated dispose listener\n*\n* @param {Number} intervalId The id of the interval to clear\n* @return {Number} Returns the interval ID\n* @method clearInterval\n*/",meta:{range:[19243,19444],filename:"component.js",lineno:1358,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Clears an interval and removes the associated dispose listener</p>",params:[{type:{names:["Number"]},description:"<p>The id of the interval to clear</p>",name:"intervalId"}],returns:[{type:{names:["Number"]},description:"<p>Returns the interval ID</p>"}],kind:"function",name:"clearInterval",longname:"clearInterval",scope:"global"},{comment:"/**\n* Registers a component\n*\n* @param {String} name Name of the component to register\n* @param {Object} comp The component to register\n* @static\n* @method registerComponent\n*/",meta:{range:[19481,19657],filename:"component.js",lineno:1377,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Registers a component</p>",params:[{type:{names:["String"]},description:"<p>Name of the component to register</p>",name:"name"},{type:{names:["Object"]},description:"<p>The component to register</p>",name:"comp"}],scope:"static",kind:"function",name:"registerComponent",longname:"registerComponent"},{comment:"/**\n* Gets a component by name\n*\n* @param {String} name Name of the component to get\n* @return {Component}\n* @static\n* @method getComponent\n*/",meta:{range:[19685,19827],filename:"component.js",lineno:1394,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Gets a component by name</p>",params:[{type:{names:["String"]},description:"<p>Name of the component to get</p>",name:"name"}],returns:[{type:{names:["Component"]}}],scope:"static",kind:"function",name:"getComponent",longname:"getComponent"},{comment:"/**\n* Sets up the constructor using the supplied init method\n* or uses the init of the parent object\n*\n* @param {Object} props An object of properties\n* @static\n* @deprecated\n* @method extend\n*/",meta:{range:[19861,20055],filename:"component.js",lineno:1413,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Sets up the constructor using the supplied init method\nor uses the init of the parent object</p>",params:[{type:{names:["Object"]},description:"<p>An object of properties</p>",name:"props"}],scope:"static",deprecated:!0,kind:"function",name:"extend",longname:"extend"},{comment:"/**\n* @file audio-track-button.js\n*/",meta:{range:[0,36],filename:"audio-track-button.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/audio-track-controls",code:{}},name:"control-bar/audio-track-controls/audio-track-button.js",kind:"file",description:"<p>audio-track-button.js</p>",preserveName:!0,longname:"control-bar/audio-track-controls/audio-track-button.js",scope:"global"},{comment:"/**\n* The base class for buttons that toggle specific text track types (e.g. subtitles)\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends TrackButton\n* @class AudioTrackButton\n*/",meta:{range:[52,252],filename:"audio-track-button.js",lineno:9,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/audio-track-controls",code:{}},description:"<p>The base class for buttons that toggle specific text track types (e.g. subtitles)</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["TrackButton"],kind:"class",name:"AudioTrackButton",longname:"AudioTrackButton",scope:"global"},{comment:"/**\n* Allow sub components to stack CSS class names\n*\n* @return {String} The constructed class name\n* @method buildCSSClass\n*/",meta:{range:[280,406],filename:"audio-track-button.js",lineno:26,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/audio-track-controls",code:{}},description:"<p>Allow sub components to stack CSS class names</p>",returns:[{type:{names:["String"]},description:"<p>The constructed class name</p>"}],kind:"function",name:"buildCSSClass",longname:"buildCSSClass",scope:"global"},{comment:"/**\n* Create a menu item for each audio track\n*\n* @return {Array} Array of menu items\n* @method createItems\n*/",
meta:{range:[419,529],filename:"audio-track-button.js",lineno:36,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/audio-track-controls",code:{}},description:"<p>Create a menu item for each audio track</p>",returns:[{type:{names:["Array"]},description:"<p>Array of menu items</p>"}],kind:"function",name:"createItems",longname:"createItems",scope:"global"},{comment:"/**\n* @file audio-track-menu-item.js\n*/",meta:{range:[0,39],filename:"audio-track-menu-item.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/audio-track-controls",code:{}},name:"control-bar/audio-track-controls/audio-track-menu-item.js",kind:"file",description:"<p>audio-track-menu-item.js</p>",preserveName:!0,longname:"control-bar/audio-track-controls/audio-track-menu-item.js",scope:"global"},{comment:"/**\n* The audio track menu item\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends MenuItem\n* @class AudioTrackMenuItem\n*/",meta:{range:[52,195],filename:"audio-track-menu-item.js",lineno:8,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/audio-track-controls",code:{}},description:"<p>The audio track menu item</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["MenuItem"],kind:"class",name:"AudioTrackMenuItem",longname:"AudioTrackMenuItem",scope:"global"},{comment:"/**\n* Handle click on audio track\n*\n* @method handleClick\n*/",meta:{range:[265,325],filename:"audio-track-menu-item.js",lineno:39,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/audio-track-controls",code:{}},description:"<p>Handle click on audio track</p>",kind:"function",name:"handleClick",longname:"handleClick",scope:"global"},{comment:"/**\n* Handle audio track change\n*\n* @method handleTracksChange\n*/",meta:{range:[368,433],filename:"audio-track-menu-item.js",lineno:58,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/audio-track-controls",code:{}},description:"<p>Handle audio track change</p>",kind:"function",name:"handleTracksChange",longname:"handleTracksChange",scope:"global"},{comment:"/**\n* @file control-bar.js\n*/",meta:{range:[0,29],filename:"control-bar.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},name:"control-bar/control-bar.js",kind:"file",description:"<p>control-bar.js</p>",preserveName:!0,longname:"control-bar/control-bar.js",scope:"global"},{comment:"/**\n* Container of main controls\n*\n* @extends Component\n* @class ControlBar\n*/",meta:{range:[96,174],filename:"control-bar.js",lineno:26,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Container of main controls</p>",augments:["Component"],kind:"class",name:"ControlBar",longname:"ControlBar",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[181,265],filename:"control-bar.js",lineno:34,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* @file fullscreen-toggle.js\n*/",meta:{range:[0,35],filename:"fullscreen-toggle.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},name:"control-bar/fullscreen-toggle.js",kind:"file",description:"<p>fullscreen-toggle.js</p>",preserveName:!0,longname:"control-bar/fullscreen-toggle.js",scope:"global"},{comment:"/**\n* Toggle fullscreen video\n*\n* @extends Button\n* @class FullscreenToggle\n*/",meta:{range:[45,123],filename:"fullscreen-toggle.js",lineno:7,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Toggle fullscreen video</p>",augments:["Button"],kind:"class",name:"FullscreenToggle",longname:"FullscreenToggle",scope:"global"},{comment:"/**\n* Allow sub components to stack CSS class names\n*\n* @return {String} The constructed class name\n* @method buildCSSClass\n*/",meta:{range:[145,271],filename:"fullscreen-toggle.js",lineno:20,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Allow sub components to stack CSS class names</p>",returns:[{type:{names:["String"]},description:"<p>The constructed class name</p>"}],kind:"function",name:"buildCSSClass",longname:"buildCSSClass",scope:"global"},{comment:"/**\n* Handles Fullscreenchange on the component and change control text accordingly\n*\n* @method handleFullscreenChange\n*/",meta:{range:[281,402],filename:"fullscreen-toggle.js",lineno:29,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Handles Fullscreenchange on the component and change control text accordingly</p>",kind:"function",name:"handleFullscreenChange",longname:"handleFullscreenChange",scope:"global"},{comment:"/**\n* Handles click for full screen\n*\n* @method handleClick\n*/",meta:{range:[424,486],filename:"fullscreen-toggle.js",lineno:41,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Handles click for full screen</p>",kind:"function",name:"handleClick",longname:"handleClick",scope:"global"},{comment:"/**\n* @file live-display.js\n*/",meta:{range:[0,30],filename:"live-display.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},name:"control-bar/live-display.js",kind:"file",description:"<p>live-display.js</p>",preserveName:!0,longname:"control-bar/live-display.js",scope:"global"},{comment:"/**\n* Displays the live indicator\n* TODO - Future make it click to snap to live\n*\n* @extends Component\n* @class LiveDisplay\n*/",meta:{range:[40,166],filename:"live-display.js",lineno:7,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Displays the live indicator\nTODO - Future make it click to snap to live</p>",augments:["Component"],kind:"class",name:"LiveDisplay",longname:"LiveDisplay",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[194,278],filename:"live-display.js",lineno:23,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* @file mute-toggle.js\n*/",meta:{range:[0,29],filename:"mute-toggle.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},name:"control-bar/mute-toggle.js",kind:"file",description:"<p>mute-toggle.js</p>",preserveName:!0,longname:"control-bar/mute-toggle.js",scope:"global"},{comment:"/**\n* A button component for muting the audio\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Button\n* @class MuteToggle\n*/",meta:{range:[42,189],filename:"mute-toggle.js",lineno:8,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>A button component for muting the audio</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Button"],kind:"class",name:"MuteToggle",longname:"MuteToggle",scope:"global"},{comment:"/**\n* Allow sub components to stack CSS class names\n*\n* @return {String} The constructed class name\n* @method buildCSSClass\n*/",meta:{range:[259,385],filename:"mute-toggle.js",lineno:39,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Allow sub components to stack CSS class names</p>",returns:[{type:{names:["String"]},description:"<p>The constructed class name</p>"}],kind:"function",name:"buildCSSClass",longname:"buildCSSClass",scope:"global"},{comment:"/**\n* Handle click on mute\n*\n* @method handleClick\n*/",meta:{range:[398,451],filename:"mute-toggle.js",lineno:49,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Handle click on mute</p>",kind:"function",name:"handleClick",longname:"handleClick",scope:"global"},{comment:"/**\n* Update volume\n*\n* @method update\n*/",meta:{range:[464,505],filename:"mute-toggle.js",lineno:58,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Update volume</p>",kind:"function",name:"update",longname:"update",scope:"global"},{comment:"/**\n* @file play-toggle.js\n*/",meta:{range:[0,29],filename:"play-toggle.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},name:"control-bar/play-toggle.js",kind:"file",description:"<p>play-toggle.js</p>",preserveName:!0,longname:"control-bar/play-toggle.js",scope:"global"},{comment:"/**\n* Button to toggle between play and pause\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Button\n* @class PlayToggle\n*/",meta:{range:[39,186],filename:"play-toggle.js",lineno:7,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Button to toggle between play and pause</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Button"],kind:"class",name:"PlayToggle",longname:"PlayToggle",scope:"global"},{comment:"/**\n* Allow sub components to stack CSS class names\n*\n* @return {String} The constructed class name\n* @method buildCSSClass\n*/",meta:{range:[214,340],filename:"play-toggle.js",lineno:24,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Allow sub components to stack CSS class names</p>",returns:[{type:{names:["String"]},description:"<p>The constructed class name</p>"}],kind:"function",name:"buildCSSClass",longname:"buildCSSClass",scope:"global"},{comment:"/**\n* Handle click to toggle between play and pause\n*\n* @method handleClick\n*/",meta:{range:[353,431],filename:"play-toggle.js",lineno:34,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Handle click to toggle between play and pause</p>",kind:"function",name:"handleClick",longname:"handleClick",scope:"global"},{comment:"/**\n* Add the vjs-playing class to the element so it can change appearance\n*\n* @method handlePlay\n*/",meta:{range:[456,556],filename:"play-toggle.js",lineno:47,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Add the vjs-playing class to the element so it can change appearance</p>",kind:"function",name:"handlePlay",longname:"handlePlay",scope:"global"},{comment:"/**\n* Add the vjs-paused class to the element so it can change appearance\n*\n* @method handlePause\n*/",meta:{range:[575,675],filename:"play-toggle.js",lineno:58,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Add the vjs-paused class to the element so it can change appearance</p>",kind:"function",name:"handlePause",longname:"handlePause",scope:"global"},{comment:"/**\n* @file playback-rate-menu-button.js\n*/",meta:{range:[0,43],filename:"playback-rate-menu-button.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/playback-rate-menu",code:{}},name:"control-bar/playback-rate-menu/playback-rate-menu-button.js",kind:"file",description:"<p>playback-rate-menu-button.js</p>",preserveName:!0,longname:"control-bar/playback-rate-menu/playback-rate-menu-button.js",scope:"global"},{comment:"/**\n* The component for controlling the playback rate\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends MenuButton\n* @class PlaybackRateMenuButton\n*/",meta:{range:[62,233],filename:"playback-rate-menu-button.js",lineno:10,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/playback-rate-menu",code:{}},description:"<p>The component for controlling the playback rate</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["MenuButton"],kind:"class",name:"PlaybackRateMenuButton",longname:"PlaybackRateMenuButton",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[270,354],filename:"playback-rate-menu-button.js",lineno:30,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/playback-rate-menu",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Allow sub components to stack CSS class names\n*\n* @return {String} The constructed class name\n* @method buildCSSClass\n*/",meta:{range:[394,520],filename:"playback-rate-menu-button.js",lineno:49,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/playback-rate-menu",code:{}},description:"<p>Allow sub components to stack CSS class names</p>",returns:[{type:{names:["String"]},description:"<p>The constructed class name</p>"}],kind:"function",name:"buildCSSClass",longname:"buildCSSClass",scope:"global"},{comment:"/**\n* Create the playback rate menu\n*\n* @return {Menu} Menu object populated with items\n* @method createMenu\n*/",meta:{range:[533,644],filename:"playback-rate-menu-button.js",lineno:59,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/playback-rate-menu",code:{}},description:"<p>Create the playback rate menu</p>",returns:[{type:{names:["Menu"]},description:"<p>Menu object populated with items</p>"}],kind:"function",name:"createMenu",longname:"createMenu",scope:"global"},{comment:"/**\n* Updates ARIA accessibility attributes\n*\n* @method updateARIAAttributes\n*/",meta:{range:[690,769],filename:"playback-rate-menu-button.js",lineno:80,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/playback-rate-menu",code:{}},description:"<p>Updates ARIA accessibility attributes</p>",kind:"function",name:"updateARIAAttributes",longname:"updateARIAAttributes",scope:"global"},{comment:"/**\n* Handle menu item click\n*\n* @method handleClick\n*/",meta:{range:[785,840],filename:"playback-rate-menu-button.js",lineno:90,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/playback-rate-menu",code:{}},description:"<p>Handle menu item click</p>",kind:"function",name:"handleClick",longname:"handleClick",scope:"global"},{comment:"/**\n* Get possible playback rates\n*\n* @return {Array} Possible playback rates\n* @method playbackRates\n*/",meta:{range:[889,993],filename:"playback-rate-menu-button.js",lineno:111,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/playback-rate-menu",code:{}},description:"<p>Get possible playback rates</p>",returns:[{type:{names:["Array"]},description:"<p>Possible playback rates</p>"}],kind:"function",name:"playbackRates",longname:"playbackRates",scope:"global"},{comment:"/**\n* Get whether playback rates is supported by the tech\n* and an array of playback rates exists\n*\n* @return {Boolean} Whether changing playback rate is supported\n* @method playbackRateSupported\n*/",meta:{range:[1006,1204],filename:"playback-rate-menu-button.js",lineno:121,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/playback-rate-menu",code:{}},description:"<p>Get whether playback rates is supported by the tech\nand an array of playback rates exists</p>",returns:[{type:{names:["Boolean"]},description:"<p>Whether changing playback rate is supported</p>"}],kind:"function",name:"playbackRateSupported",longname:"playbackRateSupported",scope:"global"},{comment:"/**\n* Hide playback rate controls when they're no playback rate options to select\n*\n* @method updateVisibility\n*/",meta:{range:[1229,1342],filename:"playback-rate-menu-button.js",lineno:136,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/playback-rate-menu",code:{}},description:"<p>Hide playback rate controls when they're no playback rate options to select</p>",kind:"function",name:"updateVisibility",longname:"updateVisibility",scope:"global"},{comment:"/**\n* Update button label when rate changed\n*\n* @method updateLabel\n*/",meta:{range:[1367,1437],filename:"playback-rate-menu-button.js",lineno:149,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/playback-rate-menu",code:{}},description:"<p>Update button label when rate changed</p>",kind:"function",name:"updateLabel",longname:"updateLabel",scope:"global"},{comment:"/**\n* @file playback-rate-menu-item.js\n*/",meta:{range:[0,41],filename:"playback-rate-menu-item.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/playback-rate-menu",code:{}},name:"control-bar/playback-rate-menu/playback-rate-menu-item.js",kind:"file",description:"<p>playback-rate-menu-item.js</p>",preserveName:!0,longname:"control-bar/playback-rate-menu/playback-rate-menu-item.js",scope:"global"},{comment:"/**\n* The specific menu item type for selecting a playback rate\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends MenuItem\n* @class PlaybackRateMenuItem\n*/",meta:{range:[51,228],filename:"playback-rate-menu-item.js",lineno:7,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/playback-rate-menu",code:{}},description:"<p>The specific menu item type for selecting a playback rate</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["MenuItem"],kind:"class",name:"PlaybackRateMenuItem",longname:"PlaybackRateMenuItem",scope:"global"},{comment:"/**\n* Handle click on menu item\n*\n* @method handleClick\n*/",meta:{range:[280,338],filename:"playback-rate-menu-item.js",lineno:32,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/playback-rate-menu",code:{}},description:"<p>Handle click on menu item</p>",kind:"function",name:"handleClick",longname:"handleClick",scope:"global"},{comment:"/**\n* Update playback rate with selected rate\n*\n* @method update\n*/",meta:{range:[354,421],filename:"playback-rate-menu-item.js",lineno:42,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/playback-rate-menu",code:{}},description:"<p>Update playback rate with selected rate</p>",kind:"function",name:"update",longname:"update",scope:"global"},{comment:"/**\n* @file load-progress-bar.js\n*/",meta:{range:[0,35],filename:"load-progress-bar.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},name:"control-bar/progress-control/load-progress-bar.js",kind:"file",description:"<p>load-progress-bar.js</p>",preserveName:!0,longname:"control-bar/progress-control/load-progress-bar.js",scope:"global"},{comment:"/**\n* Shows load progress\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Component\n* @class LoadProgressBar\n*/",meta:{range:[45,180],filename:"load-progress-bar.js",lineno:7,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Shows load progress</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Component"],kind:"class",name:"LoadProgressBar",longname:"LoadProgressBar",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[202,286],filename:"load-progress-bar.js",lineno:22,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Update progress bar\n*\n* @method update\n*/",meta:{range:[308,355],filename:"load-progress-bar.js",lineno:35,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Update progress bar</p>",kind:"function",name:"update",longname:"update",scope:"global"},{comment:"/**\n* @file mouse-time-display.js\n*/",meta:{range:[0,36],filename:"mouse-time-display.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},name:"control-bar/progress-control/mouse-time-display.js",kind:"file",description:"<p>mouse-time-display.js</p>",preserveName:!0,longname:"control-bar/progress-control/mouse-time-display.js",scope:"global"},{comment:"/**\n* The Mouse Time Display component shows the time you will seek to\n* when hovering over the progress bar\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Component\n* @class MouseTimeDisplay\n*/",meta:{range:[58,277],filename:"mouse-time-display.js",lineno:11,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>The Mouse Time Display component shows the time you will seek to\nwhen hovering over the progress bar</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Component"],kind:"class",name:"MouseTimeDisplay",longname:"MouseTimeDisplay",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[353,437],filename:"mouse-time-display.js",lineno:45,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* This takes in a horizontal position for the bar and returns a clamped position.\n* Clamped position means that it will keep the position greater than half the width\n* of the tooltip and smaller than the player width minus half the width o the tooltip.\n* It will only clamp the position if `keepTooltipsInside` option is set.\n*\n* @param {Number} position the position the bar wants to be\n* @return {Number} newPosition the (potentially) clamped position\n* @method clampPosition_\n*/",meta:{range:[543,1028],filename:"mouse-time-display.js",lineno:86,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>This takes in a horizontal position for the bar and returns a clamped position.\nClamped position means that it will keep the position greater than half the width\nof the tooltip and smaller than the player width minus half the width o the tooltip.\nIt will only clamp the position if <code>keepTooltipsInside</code> option is set.</p>",params:[{type:{names:["Number"]},description:"<p>the position the bar wants to be</p>",name:"position"}],returns:[{type:{names:["Number"]},description:"<p>newPosition the (potentially) clamped position</p>"}],kind:"function",name:"clampPosition_",longname:"clampPosition_",scope:"global"},{comment:"/**\n* @file play-progress-bar.js\n*/",meta:{range:[0,35],filename:"play-progress-bar.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},name:"control-bar/progress-control/play-progress-bar.js",kind:"file",description:"<p>play-progress-bar.js</p>",preserveName:!0,longname:"control-bar/progress-control/play-progress-bar.js",scope:"global"},{comment:"/**\n* Shows play progress\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Component\n* @class PlayProgressBar\n*/",meta:{range:[51,186],filename:"play-progress-bar.js",lineno:9,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Shows play progress</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Component"],kind:"class",name:"PlayProgressBar",longname:"PlayProgressBar",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[247,331],filename:"play-progress-bar.js",lineno:37,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* @file progress-control.js\n*/",meta:{range:[0,34],filename:"progress-control.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},name:"control-bar/progress-control/progress-control.js",kind:"file",description:"<p>progress-control.js</p>",preserveName:!0,longname:"control-bar/progress-control/progress-control.js",scope:"global"},{comment:"/**\n* The Progress Control component contains the seek bar, load progress,\n* and play progress\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Component\n* @class ProgressControl\n*/",meta:{range:[47,251],filename:"progress-control.js",lineno:8,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>The Progress Control component contains the seek bar, load progress,\nand play progress</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Component"],kind:"class",name:"ProgressControl",longname:"ProgressControl",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[258,342],filename:"progress-control.js",lineno:19,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* @file seek-bar.js\n*/",meta:{range:[0,26],filename:"seek-bar.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},name:"control-bar/progress-control/seek-bar.js",kind:"file",description:"<p>seek-bar.js</p>",preserveName:!0,longname:"control-bar/progress-control/seek-bar.js",scope:"global"},{comment:"/**\n* Seek Bar and holder for the progress bars\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Slider\n* @class SeekBar\n*/",meta:{range:[57,203],filename:"seek-bar.js",lineno:14,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Seek Bar and holder for the progress bars</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Slider"],kind:"class",name:"SeekBar",longname:"SeekBar",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[264,348],filename:"seek-bar.js",lineno:42,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Update ARIA accessibility attributes\n*\n* @method updateARIAAttributes\n*/",meta:{range:[373,451],filename:"seek-bar.js",lineno:56,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Update ARIA accessibility attributes</p>",kind:"function",name:"updateARIAAttributes",longname:"updateARIAAttributes",scope:"global"},{comment:"/**\n* Get percentage of video played\n*\n* @return {Number} Percentage played\n* @method getPercent\n*/",meta:{range:[521,620],filename:"seek-bar.js",lineno:84,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Get percentage of video played</p>",returns:[{type:{names:["Number"]},description:"<p>Percentage played</p>"}],kind:"function",name:"getPercent",longname:"getPercent",scope:"global"},{comment:"/**\n* Handle mouse down on seek bar\n*\n* @method handleMouseDown\n*/",meta:{range:[636,702],filename:"seek-bar.js",lineno:95,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Handle mouse down on seek bar</p>",kind:"function",name:"handleMouseDown",longname:"handleMouseDown",scope:"global"},{comment:"/**\n* Handle mouse move on seek bar\n*\n* @method handleMouseMove\n*/",meta:{range:[730,796],filename:"seek-bar.js",lineno:109,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Handle mouse move on seek bar</p>",kind:"function",name:"handleMouseMove",longname:"handleMouseMove",scope:"global"},{comment:"/**\n* Handle mouse up on seek bar\n*\n* @method handleMouseUp\n*/",meta:{range:[827,889],filename:"seek-bar.js",lineno:124,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Handle mouse up on seek bar</p>",kind:"function",name:"handleMouseUp",longname:"handleMouseUp",scope:"global"},{comment:"/**\n* Move more quickly fast forward for keyboard-only users\n*\n* @method stepForward\n*/",meta:{range:[917,1004],filename:"seek-bar.js",lineno:138,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Move more quickly fast forward for keyboard-only users</p>",kind:"function",name:"stepForward",longname:"stepForward",scope:"global"},{comment:"/**\n* Move more quickly rewind for keyboard-only users\n*\n* @method stepBack\n*/",meta:{range:[1017,1095],filename:"seek-bar.js",lineno:147,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Move more quickly rewind for keyboard-only users</p>",kind:"function",name:"stepBack",longname:"stepBack",scope:"global"},{comment:"/**\n* @file play-progress-bar.js\n*/",meta:{range:[0,35],filename:"tooltip-progress-bar.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},name:"control-bar/progress-control/tooltip-progress-bar.js",kind:"file",description:"<p>play-progress-bar.js</p>",preserveName:!0,longname:"control-bar/progress-control/tooltip-progress-bar.js",scope:"global"},{comment:"/**\n* Shows play progress\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Component\n* @class PlayProgressBar\n*/",meta:{range:[51,186],filename:"tooltip-progress-bar.js",lineno:9,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Shows play progress</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Component"],kind:"class",name:"PlayProgressBar",longname:"PlayProgressBar",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[214,298],filename:"tooltip-progress-bar.js",lineno:26,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* @file custom-control-spacer.js\n*/",meta:{range:[0,39],filename:"custom-control-spacer.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/spacer-controls",code:{}},name:"control-bar/spacer-controls/custom-control-spacer.js",kind:"file",description:"<p>custom-control-spacer.js</p>",preserveName:!0,longname:"control-bar/spacer-controls/custom-control-spacer.js",scope:"global"},{comment:"/**\n* Spacer specifically meant to be used as an insertion point for new plugins, etc.\n*\n* @extends Spacer\n* @class CustomControlSpacer\n*/",meta:{range:[49,187],filename:"custom-control-spacer.js",lineno:7,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/spacer-controls",code:{}},description:"<p>Spacer specifically meant to be used as an insertion point for new plugins, etc.</p>",augments:["Spacer"],kind:"class",name:"CustomControlSpacer",longname:"CustomControlSpacer",scope:"global"},{comment:"/**\n* Allow sub components to stack CSS class names\n*\n* @return {String} The constructed class name\n* @method buildCSSClass\n*/",meta:{range:[194,320],filename:"custom-control-spacer.js",lineno:15,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/spacer-controls",code:{}},description:"<p>Allow sub components to stack CSS class names</p>",returns:[{type:{names:["String"]},description:"<p>The constructed class name</p>"
}],kind:"function",name:"buildCSSClass",longname:"buildCSSClass",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[333,417],filename:"custom-control-spacer.js",lineno:25,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/spacer-controls",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* @file spacer.js\n*/",meta:{range:[0,24],filename:"spacer.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/spacer-controls",code:{}},name:"control-bar/spacer-controls/spacer.js",kind:"file",description:"<p>spacer.js</p>",preserveName:!0,longname:"control-bar/spacer-controls/spacer.js",scope:"global"},{comment:"/**\n* Just an empty spacer element that can be used as an append point for plugins, etc.\n* Also can be used to create space between elements when necessary.\n*\n* @extends Component\n* @class Spacer\n*/",meta:{range:[31,229],filename:"spacer.js",lineno:6,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/spacer-controls",code:{}},description:"<p>Just an empty spacer element that can be used as an append point for plugins, etc.\nAlso can be used to create space between elements when necessary.</p>",augments:["Component"],kind:"class",name:"Spacer",longname:"Spacer",scope:"global"},{comment:"/**\n* Allow sub components to stack CSS class names\n*\n* @return {String} The constructed class name\n* @method buildCSSClass\n*/",meta:{range:[236,362],filename:"spacer.js",lineno:15,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/spacer-controls",code:{}},description:"<p>Allow sub components to stack CSS class names</p>",returns:[{type:{names:["String"]},description:"<p>The constructed class name</p>"}],kind:"function",name:"buildCSSClass",longname:"buildCSSClass",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[375,459],filename:"spacer.js",lineno:25,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/spacer-controls",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* @file caption-settings-menu-item.js\n*/",meta:{range:[0,44],filename:"caption-settings-menu-item.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},name:"control-bar/text-track-controls/caption-settings-menu-item.js",kind:"file",description:"<p>caption-settings-menu-item.js</p>",preserveName:!0,longname:"control-bar/text-track-controls/caption-settings-menu-item.js",scope:"global"},{comment:"/**\n* The menu item for caption track settings menu\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends TextTrackMenuItem\n* @class CaptionSettingsMenuItem\n*/",meta:{range:[54,231],filename:"caption-settings-menu-item.js",lineno:7,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>The menu item for caption track settings menu</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["TextTrackMenuItem"],kind:"class",name:"CaptionSettingsMenuItem",longname:"CaptionSettingsMenuItem",scope:"global"},{comment:"/**\n* Handle click on menu item\n*\n* @method handleClick\n*/",meta:{range:[292,350],filename:"caption-settings-menu-item.js",lineno:35,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>Handle click on menu item</p>",kind:"function",name:"handleClick",longname:"handleClick",scope:"global"},{comment:"/**\n* @file captions-button.js\n*/",meta:{range:[0,33],filename:"captions-button.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},name:"control-bar/text-track-controls/captions-button.js",kind:"file",description:"<p>captions-button.js</p>",preserveName:!0,longname:"control-bar/text-track-controls/captions-button.js",scope:"global"},{comment:"/**\n* The button component for toggling and selecting captions\n*\n* @param {Object} player  Player object\n* @param {Object=} options Object of option names and values\n* @param {Function=} ready    Ready callback function\n* @extends TextTrackButton\n* @class CaptionsButton\n*/",meta:{range:[46,319],filename:"captions-button.js",lineno:8,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>The button component for toggling and selecting captions</p>",params:[{type:{names:["Object"]},description:"<p>Player object</p>",name:"player"},{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"},{type:{names:["function"]},optional:!0,description:"<p>Ready callback function</p>",name:"ready"}],augments:["TextTrackButton"],kind:"class",name:"CaptionsButton",longname:"CaptionsButton",scope:"global"},{comment:"/**\n* Allow sub components to stack CSS class names\n*\n* @return {String} The constructed class name\n* @method buildCSSClass\n*/",meta:{range:[341,467],filename:"captions-button.js",lineno:24,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>Allow sub components to stack CSS class names</p>",returns:[{type:{names:["String"]},description:"<p>The constructed class name</p>"}],kind:"function",name:"buildCSSClass",longname:"buildCSSClass",scope:"global"},{comment:"/**\n* Update caption menu items\n*\n* @method update\n*/",meta:{range:[480,533],filename:"captions-button.js",lineno:34,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>Update caption menu items</p>",kind:"function",name:"update",longname:"update",scope:"global"},{comment:"/**\n* Create caption menu items\n*\n* @return {Array} Array of menu items\n* @method createItems\n*/",meta:{range:[582,678],filename:"captions-button.js",lineno:55,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>Create caption menu items</p>",returns:[{type:{names:["Array"]},description:"<p>Array of menu items</p>"}],kind:"function",name:"createItems",longname:"createItems",scope:"global"},{comment:"/**\n* @file chapters-button.js\n*/",meta:{range:[0,33],filename:"chapters-button.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},name:"control-bar/text-track-controls/chapters-button.js",kind:"file",description:"<p>chapters-button.js</p>",preserveName:!0,longname:"control-bar/text-track-controls/chapters-button.js",scope:"global"},{comment:"/**\n* The button component for toggling and selecting chapters\n* Chapters act much differently than other text tracks\n* Cues are navigation vs. other tracks of alternative languages\n*\n* @param {Object} player  Player object\n* @param {Object=} options Object of option names and values\n* @param {Function=} ready    Ready callback function\n* @extends TextTrackButton\n* @class ChaptersButton\n*/",meta:{range:[64,456],filename:"chapters-button.js",lineno:14,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>The button component for toggling and selecting chapters\nChapters act much differently than other text tracks\nCues are navigation vs. other tracks of alternative languages</p>",params:[{type:{names:["Object"]},description:"<p>Player object</p>",name:"player"},{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"},{type:{names:["function"]},optional:!0,description:"<p>Ready callback function</p>",name:"ready"}],augments:["TextTrackButton"],kind:"class",name:"ChaptersButton",longname:"ChaptersButton",scope:"global"},{comment:"/**\n* Allow sub components to stack CSS class names\n*\n* @return {String} The constructed class name\n* @method buildCSSClass\n*/",meta:{range:[478,604],filename:"chapters-button.js",lineno:32,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>Allow sub components to stack CSS class names</p>",returns:[{type:{names:["String"]},description:"<p>The constructed class name</p>"}],kind:"function",name:"buildCSSClass",longname:"buildCSSClass",scope:"global"},{comment:"/**\n* Create a menu item for each text track\n*\n* @return {Array} Array of menu items\n* @method createItems\n*/",meta:{range:[617,726],filename:"chapters-button.js",lineno:42,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>Create a menu item for each text track</p>",returns:[{type:{names:["Array"]},description:"<p>Array of menu items</p>"}],kind:"function",name:"createItems",longname:"createItems",scope:"global"},{comment:"/**\n* Create menu from chapter buttons\n*\n* @return {Menu} Menu of chapter buttons\n* @method createMenu\n*/",meta:{range:[790,895],filename:"chapters-button.js",lineno:69,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>Create menu from chapter buttons</p>",returns:[{type:{names:["Menu"]},description:"<p>Menu of chapter buttons</p>"}],kind:"function",name:"createMenu",longname:"createMenu",scope:"global"},{comment:"/**\n* @file chapters-track-menu-item.js\n*/",meta:{range:[0,42],filename:"chapters-track-menu-item.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},name:"control-bar/text-track-controls/chapters-track-menu-item.js",kind:"file",description:"<p>chapters-track-menu-item.js</p>",preserveName:!0,longname:"control-bar/text-track-controls/chapters-track-menu-item.js",scope:"global"},{comment:"/**\n* The chapter track menu item\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends MenuItem\n* @class ChaptersTrackMenuItem\n*/",meta:{range:[55,203],filename:"chapters-track-menu-item.js",lineno:8,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>The chapter track menu item</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["MenuItem"],kind:"class",name:"ChaptersTrackMenuItem",longname:"ChaptersTrackMenuItem",scope:"global"},{comment:"/**\n* Handle click on menu item\n*\n* @method handleClick\n*/",meta:{range:[255,313],filename:"chapters-track-menu-item.js",lineno:33,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>Handle click on menu item</p>",kind:"function",name:"handleClick",longname:"handleClick",scope:"global"},{comment:"/**\n* Update chapter menu item\n*\n* @method update\n*/",meta:{range:[332,384],filename:"chapters-track-menu-item.js",lineno:44,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>Update chapter menu item</p>",kind:"function",name:"update",longname:"update",scope:"global"},{comment:"/**\n* @file descriptions-button.js\n*/",meta:{range:[0,37],filename:"descriptions-button.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},name:"control-bar/text-track-controls/descriptions-button.js",kind:"file",description:"<p>descriptions-button.js</p>",preserveName:!0,longname:"control-bar/text-track-controls/descriptions-button.js",scope:"global"},{comment:"/**\n* The button component for toggling and selecting descriptions\n*\n* @param {Object} player  Player object\n* @param {Object=} options Object of option names and values\n* @param {Function=} ready    Ready callback function\n* @extends TextTrackButton\n* @class DescriptionsButton\n*/",meta:{range:[50,331],filename:"descriptions-button.js",lineno:8,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>The button component for toggling and selecting descriptions</p>",params:[{type:{names:["Object"]},description:"<p>Player object</p>",name:"player"},{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"},{type:{names:["function"]},optional:!0,description:"<p>Ready callback function</p>",name:"ready"}],augments:["TextTrackButton"],kind:"class",name:"DescriptionsButton",longname:"DescriptionsButton",scope:"global"},{comment:"/**\n* Handle text track change\n*\n* @method handleTracksChange\n*/",meta:{range:[386,450],filename:"descriptions-button.js",lineno:35,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>Handle text track change</p>",kind:"function",name:"handleTracksChange",longname:"handleTracksChange",scope:"global"},{comment:"/**\n* Allow sub components to stack CSS class names\n*\n* @return {String} The constructed class name\n* @method buildCSSClass\n*/",meta:{range:[514,640],filename:"descriptions-button.js",lineno:61,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>Allow sub components to stack CSS class names</p>",returns:[{type:{names:["String"]},description:"<p>The constructed class name</p>"}],kind:"function",name:"buildCSSClass",longname:"buildCSSClass",scope:"global"},{comment:"/**\n* @file off-text-track-menu-item.js\n*/",meta:{range:[0,42],filename:"off-text-track-menu-item.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},name:"control-bar/text-track-controls/off-text-track-menu-item.js",kind:"file",description:"<p>off-text-track-menu-item.js</p>",preserveName:!0,longname:"control-bar/text-track-controls/off-text-track-menu-item.js",scope:"global"},{comment:"/**\n* A special menu item for turning of a specific type of text track\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends TextTrackMenuItem\n* @class OffTextTrackMenuItem\n*/",meta:{range:[52,245],filename:"off-text-track-menu-item.js",lineno:7,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>A special menu item for turning of a specific type of text track</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["TextTrackMenuItem"],kind:"class",name:"OffTextTrackMenuItem",longname:"OffTextTrackMenuItem",scope:"global"},{comment:"/**\n* Handle text track change\n*\n* @param {Object} event Event object\n* @method handleTracksChange\n*/",meta:{range:[306,407],filename:"off-text-track-menu-item.js",lineno:35,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>Handle text track change</p>",params:[{type:{names:["Object"]},description:"<p>Event object</p>",name:"event"}],kind:"function",name:"handleTracksChange",longname:"handleTracksChange",scope:"global"},{comment:"/**\n* @file subtitles-button.js\n*/",meta:{range:[0,34],filename:"subtitles-button.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},name:"control-bar/text-track-controls/subtitles-button.js",kind:"file",description:"<p>subtitles-button.js</p>",preserveName:!0,longname:"control-bar/text-track-controls/subtitles-button.js",scope:"global"},{comment:"/**\n* The button component for toggling and selecting subtitles\n*\n* @param {Object} player  Player object\n* @param {Object=} options Object of option names and values\n* @param {Function=} ready    Ready callback function\n* @extends TextTrackButton\n* @class SubtitlesButton\n*/",meta:{range:[44,319],filename:"subtitles-button.js",lineno:7,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>The button component for toggling and selecting subtitles</p>",params:[{type:{names:["Object"]},description:"<p>Player object</p>",name:"player"},{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"},{type:{names:["function"]},optional:!0,description:"<p>Ready callback function</p>",name:"ready"}],augments:["TextTrackButton"],kind:"class",name:"SubtitlesButton",longname:"SubtitlesButton",scope:"global"},{comment:"/**\n* Allow sub components to stack CSS class names\n*\n* @return {String} The constructed class name\n* @method buildCSSClass\n*/",meta:{range:[341,467],filename:"subtitles-button.js",lineno:23,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>Allow sub components to stack CSS class names</p>",returns:[{type:{names:["String"]},description:"<p>The constructed class name</p>"}],kind:"function",name:"buildCSSClass",longname:"buildCSSClass",scope:"global"},{comment:"/**\n* @file text-track-button.js\n*/",meta:{range:[0,35],filename:"text-track-button.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},name:"control-bar/text-track-controls/text-track-button.js",kind:"file",description:"<p>text-track-button.js</p>",preserveName:!0,longname:"control-bar/text-track-controls/text-track-button.js",scope:"global"},{comment:"/**\n* The base class for buttons that toggle specific text track types (e.g. subtitles)\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends MenuButton\n* @class TextTrackButton\n*/",meta:{range:[54,252],filename:"text-track-button.js",lineno:10,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>The base class for buttons that toggle specific text track types (e.g. subtitles)</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["MenuButton"],kind:"class",name:"TextTrackButton",longname:"TextTrackButton",scope:"global"},{comment:"/**\n* Create a menu item for each text track\n*\n* @return {Array} Array of menu items\n* @method createItems\n*/",meta:{range:[277,386],filename:"text-track-button.js",lineno:26,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>Create a menu item for each text track</p>",returns:[{type:{names:["Array"]},description:"<p>Array of menu items</p>"}],kind:"function",name:"createItems",longname:"createItems",scope:"global"},{comment:"/**\n* @file text-track-menu-item.js\n*/",meta:{range:[0,38],filename:"text-track-menu-item.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},name:"control-bar/text-track-controls/text-track-menu-item.js",kind:"file",description:"<p>text-track-menu-item.js</p>",preserveName:!0,longname:"control-bar/text-track-controls/text-track-menu-item.js",scope:"global"},{comment:"/**\n* The specific menu item type for selecting a language within a text track kind\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends MenuItem\n* @class TextTrackMenuItem\n*/",meta:{range:[57,251],filename:"text-track-menu-item.js",lineno:10,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>The specific menu item type for selecting a language within a text track kind</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["MenuItem"],kind:"class",name:"TextTrackMenuItem",longname:"TextTrackMenuItem",scope:"global"},{comment:"/**\n* Handle click on text track\n*\n* @method handleClick\n*/",meta:{range:[402,461],filename:"text-track-menu-item.js",lineno:68,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>Handle click on text track</p>",kind:"function",name:"handleClick",longname:"handleClick",scope:"global"},{comment:"/**\n* Handle text track change\n*\n* @method handleTracksChange\n*/",meta:{range:[531,595],filename:"text-track-menu-item.js",lineno:96,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls",code:{}},description:"<p>Handle text track change</p>",kind:"function",name:"handleTracksChange",longname:"handleTracksChange",scope:"global"},{comment:"/**\n* @file current-time-display.js\n*/",meta:{range:[0,38],filename:"current-time-display.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls",code:{}},name:"control-bar/time-controls/current-time-display.js",kind:"file",description:"<p>current-time-display.js</p>",preserveName:!0,longname:"control-bar/time-controls/current-time-display.js",scope:"global"},{comment:"/**\n* Displays the current time\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Component\n* @class CurrentTimeDisplay\n*/",meta:{range:[51,195],filename:"current-time-display.js",lineno:8,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls",code:{}},description:"<p>Displays the current time</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Component"],kind:"class",name:"CurrentTimeDisplay",longname:"CurrentTimeDisplay",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[220,304],filename:"current-time-display.js",lineno:24,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Update current time display\n*\n* @method updateContent\n*/",meta:{range:[359,421],filename:"current-time-display.js",lineno:48,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls",code:{}},description:"<p>Update current time display</p>",kind:"function",name:"updateContent",longname:"updateContent",scope:"global"},{comment:"/**\n* @file duration-display.js\n*/",meta:{range:[0,34],filename:"duration-display.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls",code:{}},name:"control-bar/time-controls/duration-display.js",kind:"file",description:"<p>duration-display.js</p>",preserveName:!0,longname:"control-bar/time-controls/duration-display.js",scope:"global"},{comment:"/**\n* Displays the duration\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Component\n* @class DurationDisplay\n*/",meta:{range:[47,184],filename:"duration-display.js",lineno:8,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls",code:{}},description:"<p>Displays the duration</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Component"],kind:"class",name:"DurationDisplay",longname:"DurationDisplay",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[227,311],filename:"duration-display.js",lineno:30,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Update duration time display\n*\n* @method updateContent\n*/",meta:{range:[366,429],filename:"duration-display.js",lineno:54,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls",code:{}},description:"<p>Update duration time display</p>",kind:"function",name:"updateContent",longname:"updateContent",scope:"global"},{comment:"/**\n* @file remaining-time-display.js\n*/",meta:{range:[0,40],filename:"remaining-time-display.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls",code:{}},name:"control-bar/time-controls/remaining-time-display.js",kind:"file",description:"<p>remaining-time-display.js</p>",preserveName:!0,longname:"control-bar/time-controls/remaining-time-display.js",scope:"global"},{comment:"/**\n* Displays the time left in the video\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Component\n* @class RemainingTimeDisplay\n*/",meta:{range:[53,209],filename:"remaining-time-display.js",lineno:8,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls",code:{}},description:"<p>Displays the time left in the video</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Component"],kind:"class",name:"RemainingTimeDisplay",longname:"RemainingTimeDisplay",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[237,321],filename:"remaining-time-display.js",lineno:25,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Update remaining time display\n*\n* @method updateContent\n*/",meta:{range:[376,440],filename:"remaining-time-display.js",lineno:49,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls",code:{}},description:"<p>Update remaining time display</p>",kind:"function",name:"updateContent",longname:"updateContent",scope:"global"},{comment:"/**\n* @file time-divider.js\n*/",meta:{range:[0,30],filename:"time-divider.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls",code:{}},name:"control-bar/time-controls/time-divider.js",kind:"file",description:"<p>time-divider.js</p>",preserveName:!0,longname:"control-bar/time-controls/time-divider.js",scope:"global"},{comment:"/**\n* The separator between the current time and duration.\n* Can be hidden if it's not needed in the design.\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Component\n* @class TimeDivider\n*/",meta:{range:[37,251],filename:"time-divider.js",lineno:6,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls",code:{}},description:"<p>The separator between the current time and duration.\nCan be hidden if it's not needed in the design.</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Component"],kind:"class",name:"TimeDivider",longname:"TimeDivider",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[258,342],filename:"time-divider.js",lineno:17,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* @file track-button.js\n*/",meta:{range:[0,30],filename:"track-button.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},name:"control-bar/track-button.js",kind:"file",description:"<p>track-button.js</p>",preserveName:!0,longname:"control-bar/track-button.js",scope:"global"},{comment:"/**\n* The base class for buttons that toggle specific text track types (e.g. subtitles)\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends MenuButton\n* @class TrackButton\n*/",meta:{range:[43,237],filename:"track-button.js",lineno:8,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>The base class for buttons that toggle specific text track types (e.g. subtitles)</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["MenuButton"],kind:"class",name:"TrackButton",longname:"TrackButton",scope:"global"},{comment:"/**\n* @file volume-bar.js\n*/",meta:{range:[0,28],filename:"volume-bar.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/volume-control",code:{}},name:"control-bar/volume-control/volume-bar.js",kind:"file",description:"<p>volume-bar.js</p>",preserveName:!0,longname:"control-bar/volume-control/volume-bar.js",scope:"global"},{comment:"/**\n* The bar that contains the volume level and can be clicked on to adjust the level\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Slider\n* @class VolumeBar\n*/",meta:{range:[50,237],filename:"volume-bar.js",lineno:11,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/volume-control",code:{}},description:"<p>The bar that contains the volume level and can be clicked on to adjust the level</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Slider"],kind:"class",name:"VolumeBar",longname:"VolumeBar",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[262,346],filename:"volume-bar.js",lineno:27,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/volume-control",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Handle mouse move on volume bar\n*\n* @method handleMouseMove\n*/",meta:{range:[371,439],filename:"volume-bar.js",lineno:41,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/volume-control",code:{}},description:"<p>Handle mouse move on volume bar</p>",kind:"function",name:"handleMouseMove",longname:"handleMouseMove",scope:"global"},{comment:"/**\n* Get percent of volume level\n*\n* @retun {Number} Volume level percent\n* @method getPercent\n*/",meta:{range:[473,571],filename:"volume-bar.js",lineno:57,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/volume-control",code:{}},description:"<p>Get percent of volume level</p>",tags:[{originalTitle:"retun",title:"retun",text:"{Number} Volume level percent",value:"{Number} Volume level percent"}],kind:"function",name:"getPercent",longname:"getPercent",scope:"global"},{comment:"/**\n* Increase volume level for keyboard users\n*\n* @method stepForward\n*/",meta:{range:[596,669],filename:"volume-bar.js",lineno:71,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/volume-control",code:{}},description:"<p>Increase volume level for keyboard users</p>",kind:"function",name:"stepForward",longname:"stepForward",scope:"global"},{comment:"/**\n* Decrease volume level for keyboard users\n*\n* @method stepBack\n*/",meta:{range:[685,755],filename:"volume-bar.js",lineno:81,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/volume-control",code:{}},description:"<p>Decrease volume level for keyboard users</p>",kind:"function",name:"stepBack",longname:"stepBack",scope:"global"},{comment:"/**\n* Update ARIA accessibility attributes\n*\n* @method updateARIAAttributes\n*/",meta:{range:[771,849],filename:"volume-bar.js",lineno:91,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/volume-control",code:{}},description:"<p>Update ARIA accessibility attributes</p>",kind:"function",name:"updateARIAAttributes",longname:"updateARIAAttributes",scope:"global"},{comment:"/**\n* @file volume-control.js\n*/",meta:{range:[0,32],filename:"volume-control.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/volume-control",code:{}},name:"control-bar/volume-control/volume-control.js",kind:"file",description:"<p>volume-control.js</p>",preserveName:!0,longname:"control-bar/volume-control/volume-control.js",scope:"global"},{comment:"/**\n* The component for controlling the volume level\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Component\n* @class VolumeControl\n*/",meta:{range:[48,208],filename:"volume-control.js",lineno:9,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/volume-control",code:{}},description:"<p>The component for controlling the volume level</p>",
params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Component"],kind:"class",name:"VolumeControl",longname:"VolumeControl",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[263,347],filename:"volume-control.js",lineno:35,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/volume-control",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* @file volume-level.js\n*/",meta:{range:[0,30],filename:"volume-level.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/volume-control",code:{}},name:"control-bar/volume-control/volume-level.js",kind:"file",description:"<p>volume-level.js</p>",preserveName:!0,longname:"control-bar/volume-control/volume-level.js",scope:"global"},{comment:"/**\n* Shows volume level\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Component\n* @class VolumeLevel\n*/",meta:{range:[37,167],filename:"volume-level.js",lineno:6,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/volume-control",code:{}},description:"<p>Shows volume level</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Component"],kind:"class",name:"VolumeLevel",longname:"VolumeLevel",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[174,258],filename:"volume-level.js",lineno:16,path:"/Users/mboles/git/docs/video.js/src/js/control-bar/volume-control",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* @file volume-menu-button.js\n*/",meta:{range:[0,36],filename:"volume-menu-button.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},name:"control-bar/volume-menu-button.js",kind:"file",description:"<p>volume-menu-button.js</p>",preserveName:!0,longname:"control-bar/volume-menu-button.js",scope:"global"},{comment:"/**\n* Button for volume popup\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends PopupButton\n* @class VolumeMenuButton\n*/",meta:{range:[58,200],filename:"volume-menu-button.js",lineno:11,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Button for volume popup</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["PopupButton"],kind:"class",name:"VolumeMenuButton",longname:"VolumeMenuButton",scope:"global"},{comment:"/**\n* Allow sub components to stack CSS class names\n*\n* @return {String} The constructed class name\n* @method buildCSSClass\n*/",meta:{range:[378,504],filename:"volume-menu-button.js",lineno:78,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Allow sub components to stack CSS class names</p>",returns:[{type:{names:["String"]},description:"<p>The constructed class name</p>"}],kind:"function",name:"buildCSSClass",longname:"buildCSSClass",scope:"global"},{comment:"/**\n* Allow sub components to stack CSS class names\n*\n* @return {Popup} The volume popup button\n* @method createPopup\n*/",meta:{range:[538,658],filename:"volume-menu-button.js",lineno:95,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Allow sub components to stack CSS class names</p>",returns:[{type:{names:["Popup"]},description:"<p>The volume popup button</p>"}],kind:"function",name:"createPopup",longname:"createPopup",scope:"global"},{comment:"/**\n* Handle click on volume popup and calls super\n*\n* @method handleClick\n*/",meta:{range:[710,787],filename:"volume-menu-button.js",lineno:118,path:"/Users/mboles/git/docs/video.js/src/js/control-bar",code:{}},description:"<p>Handle click on volume popup and calls super</p>",kind:"function",name:"handleClick",longname:"handleClick",scope:"global"},{comment:"/**\n* @file error-display.js\n*/",meta:{range:[0,31],filename:"error-display.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},name:"error-display.js",kind:"file",description:"<p>error-display.js</p>",preserveName:!0,longname:"error-display.js",scope:"global"},{comment:"/**\n* Display that an error has occurred making the video unplayable.\n*\n* @extends ModalDialog\n* @class ErrorDisplay\n*/",meta:{range:[50,169],filename:"error-display.js",lineno:10,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Display that an error has occurred making the video unplayable.</p>",augments:["ModalDialog"],kind:"class",name:"ErrorDisplay",longname:"ErrorDisplay",scope:"global"},{comment:"/**\n* Include the old class for backward-compatibility.\n*\n* This can be removed in 6.0.\n*\n* @method buildCSSClass\n* @deprecated\n* @return {String}\n*/",meta:{range:[294,443],filename:"error-display.js",lineno:29,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Include the old class for backward-compatibility.</p>\n<p>This can be removed in 6.0.</p>",kind:"function",name:"buildCSSClass",deprecated:!0,returns:[{type:{names:["String"]}}],longname:"buildCSSClass",scope:"global"},{comment:"/**\n* @file event-target.js\n*/",meta:{range:[0,30],filename:"event-target.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},name:"event-target.js",kind:"file",description:"<p>event-target.js</p>",preserveName:!0,longname:"event-target.js",scope:"global"},{comment:"/**\n* @file fullscreen-api.js\n*/",meta:{range:[0,32],filename:"fullscreen-api.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},name:"fullscreen-api.js",kind:"file",description:"<p>fullscreen-api.js</p>",preserveName:!0,longname:"fullscreen-api.js",scope:"global"},{comment:"/**\n* @file loading-spinner.js\n*/",meta:{range:[0,33],filename:"loading-spinner.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},name:"loading-spinner.js",kind:"file",description:"<p>loading-spinner.js</p>",preserveName:!0,longname:"loading-spinner.js",scope:"global"},{comment:"/**\n* Loading spinner for waiting events\n*\n* @extends Component\n* @class LoadingSpinner\n*/",meta:{range:[143,233],filename:"loading-spinner.js",lineno:8,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Loading spinner for waiting events</p>",augments:["Component"],kind:"class",name:"LoadingSpinner",longname:"LoadingSpinner",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @method createEl\n*/",meta:{range:[240,304],filename:"loading-spinner.js",lineno:16,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Create the component's DOM element</p>",kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* @file media-error.js\n*/",meta:{range:[0,29],filename:"media-error.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},name:"media-error.js",kind:"file",description:"<p>media-error.js</p>",preserveName:!0,longname:"media-error.js",scope:"global"},{comment:"/**\n* @file menu-button.js\n*/",meta:{range:[0,29],filename:"menu-button.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},name:"menu/menu-button.js",kind:"file",description:"<p>menu-button.js</p>",preserveName:!0,longname:"menu/menu-button.js",scope:"global"},{comment:"/**\n* A button class with a popup menu\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Button\n* @class MenuButton\n*/",meta:{range:[51,191],filename:"menu-button.js",lineno:11,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>A button class with a popup menu</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Button"],kind:"class",name:"MenuButton",longname:"MenuButton",scope:"global"},{comment:"/**\n* Update menu\n*\n* @method update\n*/",meta:{range:[234,273],filename:"menu-button.js",lineno:33,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Update menu</p>",kind:"function",name:"update",longname:"update",scope:"global"},{comment:"/**\n* Create menu\n*\n* @return {Menu} The constructed menu\n* @method createMenu\n*/",meta:{range:[409,490],filename:"menu-button.js",lineno:64,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Create menu</p>",returns:[{type:{names:["Menu"]},description:"<p>The constructed menu</p>"}],kind:"function",name:"createMenu",longname:"createMenu",scope:"global"},{comment:"/**\n* Create the list of menu items. Specific to each subclass.\n*\n* @method createItems\n*/",meta:{range:[569,659],filename:"menu-button.js",lineno:96,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Create the list of menu items. Specific to each subclass.</p>",kind:"function",name:"createItems",longname:"createItems",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[666,750],filename:"menu-button.js",lineno:103,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Allow sub components to stack CSS class names\n*\n* @return {String} The constructed class name\n* @method buildCSSClass\n*/",meta:{range:[769,895],filename:"menu-button.js",lineno:115,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Allow sub components to stack CSS class names</p>",returns:[{type:{names:["String"]},description:"<p>The constructed class name</p>"}],kind:"function",name:"buildCSSClass",longname:"buildCSSClass",scope:"global"},{comment:"/**\n* When you click the button it adds focus, which\n* will show the menu indefinitely.\n* So we'll remove focus when the mouse leaves the button.\n* Focus is needed for tab navigation.\n* Allow sub components to stack CSS class names\n*\n* @method handleClick\n*/",meta:{range:[935,1193],filename:"menu-button.js",lineno:134,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>When you click the button it adds focus, which\nwill show the menu indefinitely.\nSo we'll remove focus when the mouse leaves the button.\nFocus is needed for tab navigation.\nAllow sub components to stack CSS class names</p>",kind:"function",name:"handleClick",longname:"handleClick",scope:"global"},{comment:"/**\n* Handle key press on menu\n*\n* @param {Object} event Key press event\n* @method handleKeyPress\n*/",meta:{range:[1230,1330],filename:"menu-button.js",lineno:155,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Handle key press on menu</p>",params:[{type:{names:["Object"]},description:"<p>Key press event</p>",name:"event"}],kind:"function",name:"handleKeyPress",longname:"handleKeyPress",scope:"global"},{comment:"/**\n* Handle key press on submenu\n*\n* @param {Object} event Key press event\n* @method handleSubmenuKeyPress\n*/",meta:{range:[1397,1507],filename:"menu-button.js",lineno:183,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Handle key press on submenu</p>",params:[{type:{names:["Object"]},description:"<p>Key press event</p>",name:"event"}],kind:"function",name:"handleSubmenuKeyPress",longname:"handleSubmenuKeyPress",scope:"global"},{comment:"/**\n* Makes changes based on button pressed\n*\n* @method pressButton\n*/",meta:{range:[1550,1620],filename:"menu-button.js",lineno:203,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Makes changes based on button pressed</p>",kind:"function",name:"pressButton",longname:"pressButton",scope:"global"},{comment:"/**\n* Makes changes based on button unpressed\n*\n* @method unpressButton\n*/",meta:{range:[1648,1722],filename:"menu-button.js",lineno:217,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Makes changes based on button unpressed</p>",kind:"function",name:"unpressButton",longname:"unpressButton",scope:"global"},{comment:"/**\n* Disable the menu button\n*\n* @return {Component}\n* @method disable\n*/",meta:{range:[1750,1824],filename:"menu-button.js",lineno:231,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Disable the menu button</p>",returns:[{type:{names:["Component"]}}],kind:"function",name:"disable",longname:"disable",scope:"global"},{comment:"/**\n* Enable the menu button\n*\n* @return {Component}\n* @method disable\n*/",meta:{range:[1858,1931],filename:"menu-button.js",lineno:248,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Enable the menu button</p>",returns:[{type:{names:["Component"]}}],kind:"function",name:"disable",longname:"disable",scope:"global"},{comment:"/**\n* @file menu-item.js\n*/",meta:{range:[0,27],filename:"menu-item.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},name:"menu/menu-item.js",kind:"file",description:"<p>menu-item.js</p>",preserveName:!0,longname:"menu/menu-item.js",scope:"global"},{comment:"/**\n* The component for a menu item. `<li>`\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Button\n* @class MenuItem\n*/",meta:{range:[40,183],filename:"menu-item.js",lineno:8,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>The component for a menu item. <code>&lt;li&gt;</code></p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Button"],kind:"class",name:"MenuItem",longname:"MenuItem",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @param {String=} type Desc\n* @param {Object=} props Desc\n* @return {Element}\n* @method createEl\n*/",meta:{range:[238,381],filename:"menu-item.js",lineno:34,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Create the component's DOM element</p>",params:[{type:{names:["String"]},optional:!0,description:"<p>Desc</p>",name:"type"},{type:{names:["Object"]},optional:!0,description:"<p>Desc</p>",name:"props"}],returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Handle a click on the menu item, and set it to selected\n*\n* @method handleClick\n*/",meta:{range:[406,494],filename:"menu-item.js",lineno:50,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Handle a click on the menu item, and set it to selected</p>",kind:"function",name:"handleClick",longname:"handleClick",scope:"global"},{comment:"/**\n* Set this menu item as selected or not\n*\n* @param  {Boolean} selected\n* @method selected\n*/",meta:{range:[507,603],filename:"menu-item.js",lineno:59,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Set this menu item as selected or not</p>",params:[{type:{names:["Boolean"]},name:"selected"}],kind:"function",name:"selected",longname:"selected",scope:"global"},{comment:"/**\n* @file menu.js\n*/",meta:{range:[0,22],filename:"menu.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},name:"menu/menu.js",kind:"file",description:"<p>menu.js</p>",preserveName:!0,longname:"menu/menu.js",scope:"global"},{comment:"/**\n* The Menu component is used to build pop up menus, including subtitle and\n* captions selection menus.\n*\n* @extends Component\n* @class Menu\n*/",meta:{range:[38,184],filename:"menu.js",lineno:9,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>The Menu component is used to build pop up menus, including subtitle and\ncaptions selection menus.</p>",augments:["Component"],kind:"class",name:"Menu",longname:"Menu",scope:"global"},{comment:"/**\n* Add a menu item to the menu\n*\n* @param {Object|String} component Component or component type to add\n* @method addItem\n*/",meta:{range:[215,341],filename:"menu.js",lineno:26,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Add a menu item to the menu</p>",params:[{type:{names:["Object","String"]},description:"<p>Component or component type to add</p>",name:"component"}],kind:"function",name:"addItem",longname:"addItem",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[366,450],filename:"menu.js",lineno:40,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Handle key press for menu\n*\n* @param {Object} event Event object\n* @method handleKeyPress\n*/",meta:{range:[520,618],filename:"menu.js",lineno:69,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Handle key press for menu</p>",params:[{type:{names:["Object"]},description:"<p>Event object</p>",name:"event"}],kind:"function",name:"handleKeyPress",longname:"handleKeyPress",scope:"global"},{comment:"/**\n* Move to next (lower) menu item for keyboard users\n*\n* @method stepForward\n*/",meta:{range:[649,731],filename:"menu.js",lineno:85,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Move to next (lower) menu item for keyboard users</p>",kind:"function",name:"stepForward",longname:"stepForward",scope:"global"},{comment:"/**\n* Move to previous (higher) menu item for keyboard users\n*\n* @method stepBack\n*/",meta:{range:[759,843],filename:"menu.js",lineno:99,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Move to previous (higher) menu item for keyboard users</p>",kind:"function",name:"stepBack",longname:"stepBack",scope:"global"},{comment:"/**\n* Set focus on a menu item in the menu\n*\n* @param {Object|String} item Index of child item set focus on\n* @method focus\n*/",meta:{range:[871,997],filename:"menu.js",lineno:113,path:"/Users/mboles/git/docs/video.js/src/js/menu",code:{}},description:"<p>Set focus on a menu item in the menu</p>",params:[{type:{names:["Object","String"]},description:"<p>Index of child item set focus on</p>",name:"item"}],kind:"function",name:"focus",longname:"focus",scope:"global"},{comment:"/**\n* @file modal-dialog.js\n*/",meta:{range:[0,30],filename:"modal-dialog.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},name:"modal-dialog.js",kind:"file",description:"<p>modal-dialog.js</p>",preserveName:!0,longname:"modal-dialog.js",scope:"global"},{comment:'/**\n* The `ModalDialog` displays over the video and its controls, which blocks\n* interaction with the player until it is closed.\n*\n* Modal dialogs include a "Close" button and will close when that button\n* is activated - or when ESC is pressed anywhere.\n*\n* @extends Component\n* @class ModalDialog\n*/',meta:{range:[61,361],filename:"modal-dialog.js",lineno:14,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>The <code>ModalDialog</code> displays over the video and its controls, which blocks\ninteraction with the player until it is closed.</p>\n<p>Modal dialogs include a &quot;Close&quot; button and will close when that button\nis activated - or when ESC is pressed anywhere.</p>",augments:["Component"],kind:"class",name:"ModalDialog",longname:"ModalDialog",scope:"global"},{comment:"/**\n* Create the modal's DOM element\n*\n* @method createEl\n* @return {Element}\n*/",meta:{range:[1442,1522],filename:"modal-dialog.js",lineno:81,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Create the modal's DOM element</p>",kind:"function",name:"createEl",returns:[{type:{names:["Element"]}}],longname:"createEl",scope:"global"},{comment:"/**\n* Build the modal's CSS class.\n*\n* @method buildCSSClass\n* @return {String}\n*/",meta:{range:[1559,1641],filename:"modal-dialog.js",lineno:99,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Build the modal's CSS class.</p>",kind:"function",name:"buildCSSClass",returns:[{type:{names:["String"]}}],longname:"buildCSSClass",scope:"global"},{comment:"/**\n* Handles key presses on the document, looking for ESC, which closes\n* the modal.\n*\n* @method handleKeyPress\n* @param  {Event} e\n*/",meta:{range:[1654,1789],filename:"modal-dialog.js",lineno:109,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Handles key presses on the document, looking for ESC, which closes\nthe modal.</p>",kind:"function",name:"handleKeyPress",params:[{type:{names:["Event"]},name:"e"}],longname:"handleKeyPress",scope:"global"},{comment:"/**\n* Opens the modal.\n*\n* @method open\n* @return {ModalDialog}\n*/",meta:{range:[2071,2137],filename:"modal-dialog.js",lineno:148,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Opens the modal.</p>",kind:"function",name:"open",returns:[{type:{names:["ModalDialog"]}}],longname:"open",scope:"global"},{comment:"/**\n* Whether or not the modal is opened currently.\n*\n* @method opened\n* @param  {Boolean} [value]\n*         If given, it will open (`true`) or close (`false`) the modal.\n*\n* @return {Boolean}\n*/",meta:{range:[2240,2435],filename:"modal-dialog.js",lineno:188,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Whether or not the modal is opened currently.</p>",kind:"function",name:"opened",params:[{type:{names:["Boolean"]},optional:!0,description:"<p>If given, it will open (<code>true</code>) or close (<code>false</code>) the modal.</p>",name:"value"}],returns:[{type:{names:["Boolean"]}}],longname:"opened",scope:"global"},{comment:"/**\n* Closes the modal.\n*\n* @method close\n* @return {ModalDialog}\n*/",meta:{range:[2457,2525],filename:"modal-dialog.js",lineno:204,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Closes the modal.</p>",kind:"function",name:"close",returns:[{type:{names:["ModalDialog"]}}],longname:"close",scope:"global"},{comment:"/**\n* Whether or not the modal is closeable via the UI.\n*\n* @method closeable\n* @param  {Boolean} [value]\n*         If given as a Boolean, it will set the `closeable` option.\n*\n* @return {Boolean}\n*/",meta:{range:[2607,2806],filename:"modal-dialog.js",lineno:237,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Whether or not the modal is closeable via the UI.</p>",kind:"function",name:"closeable",params:[{type:{names:["Boolean"]},optional:!0,description:"<p>If given as a Boolean, it will set the <code>closeable</code> option.</p>",name:"value"}],returns:[{type:{names:["Boolean"]}}],longname:"closeable",scope:"global"},{comment:"/**\n* Fill the modal's content element with the modal's \"content\" option.\n*\n* The content element will be emptied before this change takes place.\n*\n* @method fill\n* @return {ModalDialog}\n*/",meta:{range:[2888,3077],filename:"modal-dialog.js",lineno:273,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fill the modal's content element with the modal's &quot;content&quot; option.</p>\n<p>The content element will be emptied before this change takes place.</p>",kind:"function",name:"fill",returns:[{type:{names:["ModalDialog"]}}],longname:"fill",scope:"global"},{comment:"/**\n* Fill the modal's content element with arbitrary content.\n*\n* The content element will be emptied before this change takes place.\n*\n* @method fillWith\n* @param  {Mixed} [content]\n*         The same rules apply to this as apply to the `content` option.\n*\n* @return {ModalDialog}\n*/",meta:{range:[3090,3375],filename:"modal-dialog.js",lineno:285,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fill the modal's content element with arbitrary content.</p>\n<p>The content element will be emptied before this change takes place.</p>",kind:"function",name:"fillWith",params:[{type:{names:["Mixed"]},optional:!0,description:"<p>The same rules apply to this as apply to the <code>content</code> option.</p>",name:"content"}],returns:[{type:{names:["ModalDialog"]}}],longname:"fillWith",scope:"global"},{comment:"/**\n* Empties the content element.\n*\n* This happens automatically anytime the modal is filled.\n*\n* @method empty\n* @return {ModalDialog}\n*/",meta:{range:[3451,3590],filename:"modal-dialog.js",lineno:321,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Empties the content element.</p>\n<p>This happens automatically anytime the modal is filled.</p>",kind:"function",name:"empty",returns:[{type:{names:["ModalDialog"]}}],longname:"empty",scope:"global"},{comment:'/**\n* Gets or sets the modal content, which gets normalized before being\n* rendered into the DOM.\n*\n* This does not update the DOM or fill the modal, but it is called during\n* that process.\n*\n* @method content\n* @param  {Mixed} [value]\n*         If defined, sets the internal content value to be used on the\n*         next call(s) to `fill`. This value is normalized before being\n*         inserted. To "clear" the internal content value, pass `null`.\n*\n* @return {Mixed}\n*/',meta:{range:[3612,4086],filename:"modal-dialog.js",lineno:336,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Gets or sets the modal content, which gets normalized before being\nrendered into the DOM.</p>\n<p>This does not update the DOM or fill the modal, but it is called during\nthat process.</p>",kind:"function",name:"content",params:[{type:{names:["Mixed"]},optional:!0,description:"<p>If defined, sets the internal content value to be used on the\n        next call(s) to <code>fill</code>. This value is normalized before being\n        inserted. To &quot;clear&quot; the internal content value, pass <code>null</code>.</p>",name:"value"}],returns:[{type:{names:["Mixed"]}}],longname:"content",scope:"global"},{comment:"/**\n* @file player.js\n*/",meta:{range:[0,24],filename:"player.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},name:"player.js",kind:"file",description:"<p>player.js</p>",preserveName:!0,longname:"player.js",scope:"global"},{comment:"/**\n* An instance of the `Player` class is created when any of the Video.js setup methods are used to initialize a video.\n* ```js\n* var myPlayer = videojs('example_video_1');\n* ```\n* In the following example, the `data-setup` attribute tells the Video.js library to create a player instance when the library is ready.\n* ```html\n* <video id=\"example_video_1\" data-setup='{}' controls>\n*   <source src=\"my-source.mp4\" type=\"video/mp4\">\n* </video>\n* ```\n* After an instance has been created it can be accessed globally using `Video('example_video_1')`.\n*\n* @param {Element} tag        The original video tag used for configuring options\n* @param {Object=} options    Object of option names and values\n* @param {Function=} ready    Ready callback function\n* @extends Component\n* @class Player\n*/",meta:{range:[142,933],filename:"player.js",lineno:43,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>An instance of the <code>Player</code> class is created when any of the Video.js setup methods are used to initialize a video.</p>\n<pre class=\"prettyprint source lang-js\"><code>var myPlayer = videojs('example_video_1');</code></pre><p>In the following example, the <code>data-setup</code> attribute tells the Video.js library to create a player instance when the library is ready.</p>\n<pre class=\"prettyprint source lang-html\"><code>&lt;video id=&quot;example_video_1&quot; data-setup='{}' controls>\n  &lt;source src=&quot;my-source.mp4&quot; type=&quot;video/mp4&quot;>\n&lt;/video></code></pre><p>After an instance has been created it can be accessed globally using <code>Video('example_video_1')</code>.</p>",params:[{type:{names:["Element"]},description:"<p>The original video tag used for configuring options</p>",name:"tag"},{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"},{type:{names:["function"]},optional:!0,description:"<p>Ready callback function</p>",name:"ready"}],augments:["Component"],kind:"class",name:"Player",longname:"Player",scope:"global"},{comment:"/**\n* player's constructor function\n*\n* @constructs\n* @method init\n* @param {Element} tag        The original video tag used for configuring options\n* @param {Object=} options    Player options\n* @param {Function=} ready    Ready callback function\n*/",meta:{range:[940,1190],filename:"player.js",lineno:64,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>player's constructor function</p>",alias:"{@thisClass}",kind:"function",name:"init",params:[{type:{names:["Element"]},description:"<p>The original video tag used for configuring options</p>",name:"tag"},{type:{names:["Object"]},optional:!0,description:"<p>Player options</p>",name:"options"},{type:{names:["function"]},optional:!0,description:"<p>Ready callback function</p>",name:"ready"}],longname:"init",scope:"global"},{comment:"/**\n* Destroys the video player and does any necessary cleanup\n* ```js\n*     myPlayer.dispose();\n* ```\n* This is especially helpful if you are dynamically adding and removing videos\n* to/from the DOM.\n*\n* @method dispose\n*/",meta:{range:[1801,2024],filename:"player.js",lineno:246,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>Destroys the video player and does any necessary cleanup</p>\n<pre class="prettyprint source lang-js"><code>    myPlayer.dispose();</code></pre><p>This is especially helpful if you are dynamically adding and removing videos\nto/from the DOM.</p>',kind:"function",name:"dispose",longname:"dispose",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[2082,2166],filename:"player.js",lineno:275,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Get/set player width\n*\n* @param {Number=} value Value for width\n* @return {Number} Width when getting\n* @method width\n*/",meta:{range:[2401,2527],filename:"player.js",lineno:359,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get/set player width</p>",params:[{type:{names:["Number"]},optional:!0,description:"<p>Value for width</p>",name:"value"}],returns:[{type:{names:["Number"]},description:"<p>Width when getting</p>"}],kind:"function",name:"width",longname:"width",scope:"global"},{comment:"/**\n* Get/set player height\n*\n* @param {Number=} value Value for height\n* @return {Number} Height when getting\n* @method height\n*/",meta:{range:[2540,2670],filename:"player.js",lineno:370,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get/set player height</p>",params:[{type:{names:["Number"]},optional:!0,description:"<p>Value for height</p>",name:"value"}],returns:[{type:{names:["Number"]},description:"<p>Height when getting</p>"}],kind:"function",name:"height",longname:"height",scope:"global"},{comment:"/**\n* Get/set dimension for player\n*\n* @param {String} dimension Either width or height\n* @param {Number=} value Value for dimension\n* @return {Component}\n* @method dimension\n*/",meta:{range:[2683,2860],filename:"player.js",lineno:381,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get/set dimension for player</p>",params:[{type:{names:["String"]},description:"<p>Either width or height</p>",name:"dimension"},{type:{names:["Number"]},optional:!0,description:"<p>Value for dimension</p>",name:"value"}],returns:[{type:{names:["Component"]}}],kind:"function",name:"dimension",longname:"dimension",scope:"global"},{comment:"/**\n* Add/remove the vjs-fluid class\n*\n* @param {Boolean} bool Value of true adds the class, value of false removes the class\n* @method fluid\n*/",
meta:{range:[2936,3080],filename:"player.js",lineno:414,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Add/remove the vjs-fluid class</p>",params:[{type:{names:["Boolean"]},description:"<p>Value of true adds the class, value of false removes the class</p>",name:"bool"}],kind:"function",name:"fluid",longname:"fluid",scope:"global"},{comment:"/**\n* Get/Set the aspect ratio\n*\n* @param {String=} ratio Aspect ratio for player\n* @return aspectRatio\n* @method aspectRatio\n*/",meta:{range:[3123,3251],filename:"player.js",lineno:434,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get/Set the aspect ratio</p>",params:[{type:{names:["String"]},optional:!0,description:"<p>Aspect ratio for player</p>",name:"ratio"}],returns:[{description:"<p>aspectRatio</p>"}],kind:"function",name:"aspectRatio",longname:"aspectRatio",scope:"global"},{comment:"/**\n* Update styles of the player element (height, width and aspect ratio)\n*\n* @method updateStyleEl_\n*/",meta:{range:[3306,3410],filename:"player.js",lineno:459,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Update styles of the player element (height, width and aspect ratio)</p>",kind:"function",name:"updateStyleEl_",longname:"updateStyleEl_",scope:"global"},{comment:"/**\n* Load the Media Playback Technology (tech)\n* Load/Create an instance of playback technology including element and API methods\n* And append playback element in player div.\n*\n* @param {String} techName Name of the playback technology\n* @param {String} source Video source\n* @method loadTech_\n* @private\n*/",meta:{range:[3651,3959],filename:"player.js",lineno:544,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Load the Media Playback Technology (tech)\nLoad/Create an instance of playback technology including element and API methods\nAnd append playback element in player div.</p>",params:[{type:{names:["String"]},description:"<p>Name of the playback technology</p>",name:"techName"},{type:{names:["String"]},description:"<p>Video source</p>",name:"source"}],kind:"function",name:"loadTech_",access:"private",longname:"loadTech_",scope:"global"},{comment:"/**\n* Unload playback technology\n*\n* @method unloadTech_\n* @private\n*/",meta:{range:[4299,4369],filename:"player.js",lineno:667,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Unload playback technology</p>",kind:"function",name:"unloadTech_",access:"private",longname:"unloadTech_",scope:"global"},{comment:"/**\n* Return a reference to the current tech.\n* It will only return a reference to the tech if given an object with the\n* `IWillNotUseThisInPlugins` property on it. This is try and prevent misuse\n* of techs by plugins.\n*\n* @param {Object}\n* @return {Object} The Tech\n* @method tech\n*/",meta:{range:[4412,4696],filename:"player.js",lineno:687,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Return a reference to the current tech.\nIt will only return a reference to the tech if given an object with the\n<code>IWillNotUseThisInPlugins</code> property on it. This is try and prevent misuse\nof techs by plugins.</p>",params:[{type:{names:["Object"]}}],returns:[{type:{names:["Object"]},description:"<p>The Tech</p>"}],kind:"function",name:"tech",longname:"tech",scope:"global"},{comment:"/**\n* Set up click and touch listeners for the playback element\n*\n* On desktops, a click on the video itself will toggle playback,\n* on a mobile device a click on the video toggles controls.\n* (toggling controls is done by toggling the user state between active and\n* inactive)\n* A tap can signal that a user has become active, or has become inactive\n* e.g. a quick tap on an iPhone movie should reveal the controls. Another\n* quick tap should hide them again (signaling the user is in an inactive\n* viewing state)\n* In addition to this, we still want the user to be considered inactive after\n* a few seconds of inactivity.\n* Note: the only part of iOS interaction we can't mimic with this setup\n* is a touch and hold on the video element counting as activity in order to\n* keep the controls showing, but that shouldn't be an issue. A touch and hold\n* on any controls will still keep the user active\n*\n* @private\n* @method addTechControlsListeners_\n*/",meta:{range:[4739,5690],filename:"player.js",lineno:711,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Set up click and touch listeners for the playback element</p>\n<p>On desktops, a click on the video itself will toggle playback,\non a mobile device a click on the video toggles controls.\n(toggling controls is done by toggling the user state between active and\ninactive)\nA tap can signal that a user has become active, or has become inactive\ne.g. a quick tap on an iPhone movie should reveal the controls. Another\nquick tap should hide them again (signaling the user is in an inactive\nviewing state)\nIn addition to this, we still want the user to be considered inactive after\na few seconds of inactivity.\nNote: the only part of iOS interaction we can't mimic with this setup\nis a touch and hold on the video element counting as activity in order to\nkeep the controls showing, but that shouldn't be an issue. A touch and hold\non any controls will still keep the user active</p>",access:"private",kind:"function",name:"addTechControlsListeners_",longname:"addTechControlsListeners_",scope:"global"},{comment:"/**\n* Remove the listeners used for click and tap controls. This is needed for\n* toggling to controls disabled, where a tap/touch should do nothing.\n*\n* @method removeTechControlsListeners_\n* @private\n*/",meta:{range:[5757,5960],filename:"player.js",lineno:754,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Remove the listeners used for click and tap controls. This is needed for\ntoggling to controls disabled, where a tap/touch should do nothing.</p>",kind:"function",name:"removeTechControlsListeners_",access:"private",longname:"removeTechControlsListeners_",scope:"global"},{comment:"/**\n* Player waits for the tech to be ready\n*\n* @method handleTechReady_\n* @private\n*/",meta:{range:[5991,6077],filename:"player.js",lineno:771,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Player waits for the tech to be ready</p>",kind:"function",name:"handleTechReady_",access:"private",longname:"handleTechReady_",scope:"global"},{comment:"/**\n* Fired when the user agent begins looking for media data\n*\n* @private\n* @method handleTechLoadStart_\n*/",meta:{range:[6165,6273],filename:"player.js",lineno:806,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired when the user agent begins looking for media data</p>",access:"private",kind:"function",name:"handleTechLoadStart_",longname:"handleTechLoadStart_",scope:"global"},{comment:"/**\n* Add/remove the vjs-has-started class\n*\n* @param {Boolean} hasStarted The value of true adds the class the value of false remove the class\n* @return {Boolean} Boolean value if has started\n* @private\n* @method hasStarted\n*/",meta:{range:[6337,6564],filename:"player.js",lineno:833,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Add/remove the vjs-has-started class</p>",params:[{type:{names:["Boolean"]},description:"<p>The value of true adds the class the value of false remove the class</p>",name:"hasStarted"}],returns:[{type:{names:["Boolean"]},description:"<p>Boolean value if has started</p>"}],access:"private",kind:"function",name:"hasStarted",longname:"hasStarted",scope:"global"},{comment:"/**\n* Fired whenever the media begins or resumes playback\n*\n* @private\n* @method handleTechPlay_\n*/",meta:{range:[6619,6718],filename:"player.js",lineno:859,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired whenever the media begins or resumes playback</p>",access:"private",kind:"function",name:"handleTechPlay_",longname:"handleTechPlay_",scope:"global"},{comment:"/**\n* Fired whenever the media begins waiting\n*\n* @private\n* @method handleTechWaiting_\n*/",meta:{range:[6755,6845],filename:"player.js",lineno:877,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired whenever the media begins waiting</p>",access:"private",kind:"function",name:"handleTechWaiting_",longname:"handleTechWaiting_",scope:"global"},{comment:"/**\n* A handler for events that signal that waiting has ended\n* which is not consistent between browsers. See #1351\n*\n* @private\n* @method handleTechCanPlay_\n*/",meta:{range:[6864,7024],filename:"player.js",lineno:889,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>A handler for events that signal that waiting has ended\nwhich is not consistent between browsers. See #1351</p>",access:"private",kind:"function",name:"handleTechCanPlay_",longname:"handleTechCanPlay_",scope:"global"},{comment:"/**\n* A handler for events that signal that waiting has ended\n* which is not consistent between browsers. See #1351\n*\n* @private\n* @method handleTechCanPlayThrough_\n*/",meta:{range:[7040,7207],filename:"player.js",lineno:901,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>A handler for events that signal that waiting has ended\nwhich is not consistent between browsers. See #1351</p>",access:"private",kind:"function",name:"handleTechCanPlayThrough_",longname:"handleTechCanPlayThrough_",scope:"global"},{comment:"/**\n* A handler for events that signal that waiting has ended\n* which is not consistent between browsers. See #1351\n*\n* @private\n* @method handleTechPlaying_\n*/",meta:{range:[7223,7383],filename:"player.js",lineno:913,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>A handler for events that signal that waiting has ended\nwhich is not consistent between browsers. See #1351</p>",access:"private",kind:"function",name:"handleTechPlaying_",longname:"handleTechPlaying_",scope:"global"},{comment:"/**\n* Fired whenever the player is jumping to a new time\n*\n* @private\n* @method handleTechSeeking_\n*/",meta:{range:[7399,7500],filename:"player.js",lineno:925,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired whenever the player is jumping to a new time</p>",access:"private",kind:"function",name:"handleTechSeeking_",longname:"handleTechSeeking_",scope:"global"},{comment:"/**\n* Fired when the player has finished jumping to a new time\n*\n* @private\n* @method handleTechSeeked_\n*/",meta:{range:[7516,7622],filename:"player.js",lineno:936,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired when the player has finished jumping to a new time</p>",access:"private",kind:"function",name:"handleTechSeeked_",longname:"handleTechSeeked_",scope:"global"},{comment:"/**\n* Fired the first time a video is played\n* Not part of the HLS spec, and we're not sure if this is the best\n* implementation yet, so use sparingly. If you don't have a reason to\n* prevent playback, use `myPlayer.one('play');` instead.\n*\n* @private\n* @method handleTechFirstPlay_\n*/",meta:{range:[7638,7923],filename:"player.js",lineno:947,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired the first time a video is played\nNot part of the HLS spec, and we're not sure if this is the best\nimplementation yet, so use sparingly. If you don't have a reason to\nprevent playback, use <code>myPlayer.one('play');</code> instead.</p>",access:"private",kind:"function",name:"handleTechFirstPlay_",longname:"handleTechFirstPlay_",scope:"global"},{comment:"/**\n* Fired whenever the media has been paused\n*\n* @private\n* @method handleTechPause_\n*/",meta:{range:[7957,8046],filename:"player.js",lineno:967,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired whenever the media has been paused</p>",access:"private",kind:"function",name:"handleTechPause_",longname:"handleTechPause_",scope:"global"},{comment:"/**\n* Fired while the user agent is downloading media data\n*\n* @private\n* @method handleTechProgress_\n*/",meta:{range:[8065,8169],filename:"player.js",lineno:979,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired while the user agent is downloading media data</p>",access:"private",kind:"function",name:"handleTechProgress_",longname:"handleTechProgress_",scope:"global"},{comment:"/**\n* Fired when the end of the media resource is reached (currentTime == duration)\n*\n* @private\n* @method handleTechEnded_\n*/",meta:{range:[8182,8308],filename:"player.js",lineno:989,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired when the end of the media resource is reached (currentTime == duration)</p>",access:"private",kind:"function",name:"handleTechEnded_",longname:"handleTechEnded_",scope:"global"},{comment:"/**\n* Fired when the duration of the media resource is first known or changed\n*\n* @private\n* @method handleTechDurationChange_\n*/",meta:{range:[8345,8474],filename:"player.js",lineno:1007,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired when the duration of the media resource is first known or changed</p>",access:"private",kind:"function",name:"handleTechDurationChange_",longname:"handleTechDurationChange_",scope:"global"},{comment:"/**\n* Handle a click on the media element to play/pause\n*\n* @param {Object=} event Event object\n* @private\n* @method handleTechClick_\n*/",meta:{range:[8487,8623],filename:"player.js",lineno:1017,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Handle a click on the media element to play/pause</p>",params:[{type:{names:["Object"]},optional:!0,description:"<p>Event object</p>",name:"event"}],access:"private",kind:"function",name:"handleTechClick_",longname:"handleTechClick_",scope:"global"},{comment:"/**\n* Handle a tap on the media element. It will toggle the user\n* activity state, which hides and shows the controls.\n*\n* @private\n* @method handleTechTap_\n*/",meta:{range:[8672,8831],filename:"player.js",lineno:1040,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Handle a tap on the media element. It will toggle the user\nactivity state, which hides and shows the controls.</p>",access:"private",kind:"function",name:"handleTechTap_",longname:"handleTechTap_",scope:"global"},{comment:"/**\n* Handle touch to start\n*\n* @private\n* @method handleTechTouchStart_\n*/",meta:{range:[8844,8919],filename:"player.js",lineno:1051,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Handle touch to start</p>",access:"private",kind:"function",name:"handleTechTouchStart_",longname:"handleTechTouchStart_",scope:"global"},{comment:"/**\n* Handle touch to move\n*\n* @private\n* @method handleTechTouchMove_\n*/",meta:{range:[8932,9005],filename:"player.js",lineno:1061,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Handle touch to move</p>",access:"private",kind:"function",name:"handleTechTouchMove_",longname:"handleTechTouchMove_",scope:"global"},{comment:"/**\n* Handle touch to end\n*\n* @private\n* @method handleTechTouchEnd_\n*/",meta:{range:[9024,9095],filename:"player.js",lineno:1073,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Handle touch to end</p>",access:"private",kind:"function",name:"handleTechTouchEnd_",longname:"handleTechTouchEnd_",scope:"global"},{comment:"/**\n* Fired when the player switches in or out of fullscreen mode\n*\n* @private\n* @method handleFullscreenChange_\n*/",meta:{range:[9111,9226],filename:"player.js",lineno:1084,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired when the player switches in or out of fullscreen mode</p>",access:"private",kind:"function",name:"handleFullscreenChange_",longname:"handleFullscreenChange_",scope:"global"},{comment:"/**\n* native click events on the SWF aren't triggered on IE11, Win8.1RT\n* use stageclick events triggered from inside the SWF instead\n*\n* @private\n* @method handleStageClick_\n*/",meta:{range:[9251,9428],filename:"player.js",lineno:1098,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>native click events on the SWF aren't triggered on IE11, Win8.1RT\nuse stageclick events triggered from inside the SWF instead</p>",access:"private",kind:"function",name:"handleStageClick_",longname:"handleStageClick_",scope:"global"},{comment:"/**\n* Handle Tech Fullscreen Change\n*\n* @private\n* @method handleTechFullscreenChange_\n*/",meta:{range:[9441,9530],filename:"player.js",lineno:1109,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Handle Tech Fullscreen Change</p>",access:"private",kind:"function",name:"handleTechFullscreenChange_",longname:"handleTechFullscreenChange_",scope:"global"},{comment:"/**\n* Fires when an error occurred during the loading of an audio/video\n*\n* @private\n* @method handleTechError_\n*/",meta:{range:[9552,9666],filename:"player.js",lineno:1122,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fires when an error occurred during the loading of an audio/video</p>",access:"private",kind:"function",name:"handleTechError_",longname:"handleTechError_",scope:"global"},{comment:"/**\n* Fires when the browser is intentionally not getting media data\n*\n* @private\n* @method handleTechSuspend_\n*/",meta:{range:[9682,9795],filename:"player.js",lineno:1133,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fires when the browser is intentionally not getting media data</p>",access:"private",kind:"function",name:"handleTechSuspend_",longname:"handleTechSuspend_",scope:"global"},{comment:"/**\n* Fires when the loading of an audio/video is aborted\n*\n* @private\n* @method handleTechAbort_\n*/",meta:{range:[9808,9908],filename:"player.js",lineno:1143,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fires when the loading of an audio/video is aborted</p>",access:"private",kind:"function",name:"handleTechAbort_",longname:"handleTechAbort_",scope:"global"},{comment:"/**\n* Fires when the current playlist is empty\n*\n* @private\n* @method handleTechEmptied_\n*/",meta:{range:[9921,10012],filename:"player.js",lineno:1153,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fires when the current playlist is empty</p>",access:"private",kind:"function",name:"handleTechEmptied_",longname:"handleTechEmptied_",scope:"global"},{comment:"/**\n* Fires when the browser is trying to get media data, but data is not available\n*\n* @private\n* @method handleTechStalled_\n*/",meta:{range:[10025,10153],filename:"player.js",lineno:1163,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fires when the browser is trying to get media data, but data is not available</p>",access:"private",kind:"function",name:"handleTechStalled_",longname:"handleTechStalled_",scope:"global"},{comment:"/**\n* Fires when the browser has loaded meta data for the audio/video\n*\n* @private\n* @method handleTechLoadedMetaData_\n*/",meta:{range:[10166,10287],filename:"player.js",lineno:1173,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fires when the browser has loaded meta data for the audio/video</p>",access:"private",kind:"function",name:"handleTechLoadedMetaData_",longname:"handleTechLoadedMetaData_",scope:"global"},{comment:"/**\n* Fires when the browser has loaded the current frame of the audio/video\n*\n* @private\n* @method handleTechLoadedData_\n*/",meta:{range:[10324,10448],filename:"player.js",lineno:1191,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fires when the browser has loaded the current frame of the audio/video</p>",access:"private",kind:"function",name:"handleTechLoadedData_",longname:"handleTechLoadedData_",scope:"global"},{comment:"/**\n* Fires when the current playback position has changed\n*\n* @private\n* @method handleTechTimeUpdate_\n*/",meta:{range:[10461,10567],filename:"player.js",lineno:1201,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fires when the current playback position has changed</p>",access:"private",kind:"function",name:"handleTechTimeUpdate_",longname:"handleTechTimeUpdate_",scope:"global"},{comment:"/**\n* Fires when the playing speed of the audio/video is changed\n*\n* @private\n* @method handleTechRateChange_\n*/",meta:{range:[10580,10692],filename:"player.js",lineno:1211,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fires when the playing speed of the audio/video is changed</p>",access:"private",kind:"function",name:"handleTechRateChange_",longname:"handleTechRateChange_",scope:"global"},{comment:"/**\n* Fires when the volume has been changed\n*\n* @private\n* @method handleTechVolumeChange_\n*/",meta:{range:[10705,10799],filename:"player.js",lineno:1221,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fires when the volume has been changed</p>",access:"private",kind:"function",name:"handleTechVolumeChange_",longname:"handleTechVolumeChange_",scope:"global"},{comment:"/**\n* Fires when the text track has been changed\n*\n* @private\n* @method handleTechTextTrackChange_\n*/",meta:{range:[10812,10913],filename:"player.js",lineno:1231,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fires when the text track has been changed</p>",access:"private",kind:"function",name:"handleTechTextTrackChange_",longname:"handleTechTextTrackChange_",scope:"global"},{comment:"/**\n* Get object for cached values.\n*\n* @return {Object}\n* @method getCache\n*/",meta:{range:[10926,11004],filename:"player.js",lineno:1241,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get object for cached values.</p>",returns:[{type:{names:["Object"]}}],kind:"function",name:"getCache",longname:"getCache",scope:"global"},{comment:"/**\n* Pass values to the playback tech\n*\n* @param {String=} method Method\n* @param {Object=} arg Argument\n* @private\n* @method techCall_\n*/",meta:{range:[11017,11156],filename:"player.js",lineno:1251,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Pass values to the playback tech</p>",params:[{type:{names:["String"]},optional:!0,description:"<p>Method</p>",name:"method"},{type:{names:["Object"]},optional:!0,description:"<p>Argument</p>",name:"arg"}],access:"private",kind:"function",name:"techCall_",longname:"techCall_",scope:"global"},{comment:"/**\n* Get calls can't wait for the tech, and sometimes don't need to.\n*\n* @param {String} method Tech method\n* @return {Method}\n* @private\n* @method techGet_\n*/",meta:{range:[11211,11371],filename:"player.js",lineno:1277,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get calls can't wait for the tech, and sometimes don't need to.</p>",params:[{type:{names:["String"]},description:"<p>Tech method</p>",name:"method"}],returns:[{type:{names:["Method"]}}],access:"private",kind:"function",name:"techGet_",longname:"techGet_",scope:"global"},{comment:"/**\n* start media playback\n* ```js\n*     myPlayer.play();\n* ```\n*\n* @return {Player} self\n* @method play\n*/",meta:{range:[11456,11563],filename:"player.js",lineno:1313,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>start media playback</p>\n<pre class="prettyprint source lang-js"><code>    myPlayer.play();</code></pre>',returns:[{type:{names:["Player"]},description:"<p>self</p>"}],kind:"function",name:"play",longname:"play",scope:"global"},{comment:"/**\n* Pause the video playback\n* ```js\n*     myPlayer.pause();\n* ```\n*\n* @return {Player} self\n* @method pause\n*/",meta:{range:[11603,11716],filename:"player.js",lineno:1335,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>Pause the video playback</p>\n<pre class="prettyprint source lang-js"><code>    myPlayer.pause();</code></pre>',returns:[{type:{names:["Player"]},description:"<p>self</p>"}],kind:"function",name:"pause",longname:"pause",scope:"global"},{comment:"/**\n* Check if the player is paused\n* ```js\n*     var isPaused = myPlayer.paused();\n*     var isPlaying = !myPlayer.paused();\n* ```\n*\n* @return {Boolean} false if the media is currently playing, or true otherwise\n* @method paused\n*/",meta:{range:[11732,11964],filename:"player.js",lineno:1349,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>Check if the player is paused</p>\n<pre class="prettyprint source lang-js"><code>    var isPaused = myPlayer.paused();\n    var isPlaying = !myPlayer.paused();</code></pre>',returns:[{type:{names:["Boolean"]},description:"<p>false if the media is currently playing, or true otherwise</p>"}],kind:"function",name:"paused",longname:"paused",scope:"global"},{comment:'/**\n* Returns whether or not the user is "scrubbing". Scrubbing is when the user\n* has clicked the progress bar handle and is dragging it along the progress bar.\n*\n* @param  {Boolean} isScrubbing   True/false the user is scrubbing\n* @return {Boolean}               The scrubbing status when getting\n* @return {Object}                The player when setting\n* @method scrubbing\n*/',meta:{range:[11980,12359],filename:"player.js",lineno:1364,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Returns whether or not the user is &quot;scrubbing&quot;. Scrubbing is when the user\nhas clicked the progress bar handle and is dragging it along the progress bar.</p>",params:[{type:{names:["Boolean"]},description:"<p>True/false the user is scrubbing</p>",name:"isScrubbing"}],returns:[{type:{names:["Boolean"]},description:"<p>The scrubbing status when getting</p>"},{type:{names:["Object"]},description:"<p>The player when setting</p>"}],kind:"function",name:"scrubbing",longname:"scrubbing",scope:"global"},{comment:"/**\n* Get or set the current time (in seconds)\n* ```js\n*     // get\n*     var whereYouAt = myPlayer.currentTime();\n*     // set\n*     myPlayer.currentTime(120); // 2 minutes into the video\n* ```\n*\n* @param  {Number|String=} seconds The time to seek to\n* @return {Number}        The time in seconds, when not setting\n* @return {Player}    self, when the current time is set\n* @method currentTime\n*/",meta:{range:[12408,12805],filename:"player.js",lineno:1389,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>Get or set the current time (in seconds)</p>\n<pre class="prettyprint source lang-js"><code>    // get\n    var whereYouAt = myPlayer.currentTime();\n    // set\n    myPlayer.currentTime(120); // 2 minutes into the video</code></pre>',params:[{type:{names:["Number","String"]},description:"<p>The time to seek to</p>",name:"seconds"}],returns:[{type:{names:["Number"]},description:"<p>The time in seconds, when not setting</p>"},{type:{names:["Player"]},description:"<p>self, when the current time is set</p>"}],kind:"function",name:"currentTime",longname:"currentTime",scope:"global"},{comment:"/**\n* Normally gets the length in time of the video in seconds;\n* in all but the rarest use cases an argument will NOT be passed to the method\n* ```js\n*     var lengthOfVideo = myPlayer.duration();\n* ```\n* **NOTE**: The video must have started loading before the duration can be\n* known, and in the case of Flash, may not be known until the video starts\n* playing.\n*\n* @param {Number} seconds Duration when setting\n* @return {Number} The duration of the video in seconds when getting\n* @method duration\n*/",meta:{range:[12857,13362],filename:"player.js",lineno:1420,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>Normally gets the length in time of the video in seconds;\nin all but the rarest use cases an argument will NOT be passed to the method</p>\n<pre class="prettyprint source lang-js"><code>    var lengthOfVideo = myPlayer.duration();</code></pre><p><strong>NOTE</strong>: The video must have started loading before the duration can be\nknown, and in the case of Flash, may not be known until the video starts\nplaying.</p>',params:[{type:{names:["Number"]},description:"<p>Duration when setting</p>",name:"seconds"}],returns:[{type:{names:["Number"]},description:"<p>The duration of the video in seconds when getting</p>"}],kind:"function",name:"duration",longname:"duration",scope:"global"},{comment:"/**\n* Calculates how much time is left.\n* ```js\n*     var timeLeft = myPlayer.remainingTime();\n* ```\n* Not a native video element function, but useful\n*\n* @return {Number} The time remaining in seconds\n* @method remainingTime\n*/",meta:{range:[13447,13675],filename:"player.js",lineno:1462,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>Calculates how much time is left.</p>\n<pre class="prettyprint source lang-js"><code>    var timeLeft = myPlayer.remainingTime();</code></pre><p>Not a native video element function, but useful</p>',returns:[{type:{names:["Number"]},description:"<p>The time remaining in seconds</p>"}],kind:"function",name:"remainingTime",longname:"remainingTime",scope:"global"},{comment:"/**\n* Get a TimeRange object with the times of the video that have been downloaded\n* If you just want the percent of the video that's been downloaded,\n* use bufferedPercent.\n* ```js\n*     // Number of different ranges of time have been buffered. Usually 1.\n*     numberOfRanges = bufferedTimeRange.length,\n*     // Time in seconds when the first range starts. Usually 0.\n*     firstRangeStart = bufferedTimeRange.start(0),\n*     // Time in seconds when the first range ends\n*     firstRangeEnd = bufferedTimeRange.end(0),\n*     // Length in seconds of the first time range\n*     firstRangeLength = firstRangeEnd - firstRangeStart;\n* ```\n*\n* @return {Object} A mock TimeRange object (following HTML spec)\n* @method buffered\n*/",meta:{range:[13700,14425],filename:"player.js",lineno:1480,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>Get a TimeRange object with the times of the video that have been downloaded\nIf you just want the percent of the video that\'s been downloaded,\nuse bufferedPercent.</p>\n<pre class="prettyprint source lang-js"><code>    // Number of different ranges of time have been buffered. Usually 1.\n    numberOfRanges = bufferedTimeRange.length,\n    // Time in seconds when the first range starts. Usually 0.\n    firstRangeStart = bufferedTimeRange.start(0),\n    // Time in seconds when the first range ends\n    firstRangeEnd = bufferedTimeRange.end(0),\n    // Length in seconds of the first time range\n    firstRangeLength = firstRangeEnd - firstRangeStart;</code></pre>',returns:[{type:{names:["Object"]},description:"<p>A mock TimeRange object (following HTML spec)</p>"}],kind:"function",name:"buffered",longname:"buffered",scope:"global"},{comment:"/**\n* Get the percent (as a decimal) of the video that's been downloaded\n* ```js\n*     var howMuchIsDownloaded = myPlayer.bufferedPercent();\n* ```\n* 0 means none, 1 means all.\n* (This method isn't in the HTML5 spec, but it's very convenient)\n*\n* @return {Number} A decimal between 0 and 1 representing the percent\n* @method bufferedPercent\n*/",meta:{range:[14456,14798],filename:"player.js",lineno:1508,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get the percent (as a decimal) of the video that's been downloaded</p>\n<pre class=\"prettyprint source lang-js\"><code>    var howMuchIsDownloaded = myPlayer.bufferedPercent();</code></pre><p>0 means none, 1 means all.\n(This method isn't in the HTML5 spec, but it's very convenient)</p>",returns:[{type:{names:["Number"]},description:"<p>A decimal between 0 and 1 representing the percent</p>"}],kind:"function",name:"bufferedPercent",longname:"bufferedPercent",scope:"global"},{comment:"/**\n* Get the ending time of the last buffered time range\n* This is used in the progress bar to encapsulate all time ranges.\n*\n* @return {Number} The end of the last buffered time range\n* @method bufferedEnd\n*/",meta:{range:[14811,15021],filename:"player.js",
lineno:1523,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get the ending time of the last buffered time range\nThis is used in the progress bar to encapsulate all time ranges.</p>",returns:[{type:{names:["Number"]},description:"<p>The end of the last buffered time range</p>"}],kind:"function",name:"bufferedEnd",longname:"bufferedEnd",scope:"global"},{comment:"/**\n* Get or set the current volume of the media\n* ```js\n*     // get\n*     var howLoudIsIt = myPlayer.volume();\n*     // set\n*     myPlayer.volume(0.5); // Set volume to half\n* ```\n* 0 is off (muted), 1.0 is all the way up, 0.5 is half way.\n*\n* @param  {Number} percentAsDecimal The new volume as a decimal percent\n* @return {Number}              The current volume when getting\n* @return {Player}              self when setting\n* @method volume\n*/",meta:{range:[15058,15507],filename:"player.js",lineno:1542,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>Get or set the current volume of the media</p>\n<pre class="prettyprint source lang-js"><code>    // get\n    var howLoudIsIt = myPlayer.volume();\n    // set\n    myPlayer.volume(0.5); // Set volume to half</code></pre><p>0 is off (muted), 1.0 is all the way up, 0.5 is half way.</p>',params:[{type:{names:["Number"]},description:"<p>The new volume as a decimal percent</p>",name:"percentAsDecimal"}],returns:[{type:{names:["Number"]},description:"<p>The current volume when getting</p>"},{type:{names:["Player"]},description:"<p>self when setting</p>"}],kind:"function",name:"volume",longname:"volume",scope:"global"},{comment:"/**\n* Get the current muted state, or turn mute on or off\n* ```js\n*     // get\n*     var isVolumeMuted = myPlayer.muted();\n*     // set\n*     myPlayer.muted(true); // mute the volume\n* ```\n*\n* @param  {Boolean=} muted True to mute, false to unmute\n* @return {Boolean} True if mute is on, false if not when getting\n* @return {Player} self when setting mute\n* @method muted\n*/",meta:{range:[15559,15933],filename:"player.js",lineno:1574,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>Get the current muted state, or turn mute on or off</p>\n<pre class="prettyprint source lang-js"><code>    // get\n    var isVolumeMuted = myPlayer.muted();\n    // set\n    myPlayer.muted(true); // mute the volume</code></pre>',params:[{type:{names:["Boolean"]},optional:!0,description:"<p>True to mute, false to unmute</p>",name:"muted"}],returns:[{type:{names:["Boolean"]},description:"<p>True if mute is on, false if not when getting</p>"},{type:{names:["Player"]},description:"<p>self when setting mute</p>"}],kind:"function",name:"muted",longname:"muted",scope:"global"},{comment:"/**\n* Check to see if fullscreen is supported\n*\n* @return {Boolean}\n* @method supportsFullScreen\n*/",meta:{range:[15964,16063],filename:"player.js",lineno:1598,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Check to see if fullscreen is supported</p>",returns:[{type:{names:["Boolean"]}}],kind:"function",name:"supportsFullScreen",longname:"supportsFullScreen",scope:"global"},{comment:"/**\n* Check if the player is in fullscreen mode\n* ```js\n*     // get\n*     var fullscreenOrNot = myPlayer.isFullscreen();\n*     // set\n*     myPlayer.isFullscreen(true); // tell the player it's in fullscreen\n* ```\n* NOTE: As of the latest HTML5 spec, isFullscreen is no longer an official\n* property and instead document.fullscreenElement is used. But isFullscreen is\n* still a valuable property for internal player workings.\n*\n* @param  {Boolean=} isFS Update the player's fullscreen state\n* @return {Boolean} true if fullscreen false if not when getting\n* @return {Player} self when setting\n* @method isFullscreen\n*/",meta:{range:[16076,16694],filename:"player.js",lineno:1608,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>Check if the player is in fullscreen mode</p>\n<pre class="prettyprint source lang-js"><code>    // get\n    var fullscreenOrNot = myPlayer.isFullscreen();\n    // set\n    myPlayer.isFullscreen(true); // tell the player it\'s in fullscreen</code></pre><p>NOTE: As of the latest HTML5 spec, isFullscreen is no longer an official\nproperty and instead document.fullscreenElement is used. But isFullscreen is\nstill a valuable property for internal player workings.</p>',params:[{type:{names:["Boolean"]},optional:!0,description:"<p>Update the player's fullscreen state</p>",name:"isFS"}],returns:[{type:{names:["Boolean"]},description:"<p>true if fullscreen false if not when getting</p>"},{type:{names:["Player"]},description:"<p>self when setting</p>"}],kind:"function",name:"isFullscreen",longname:"isFullscreen",scope:"global"},{comment:'/**\n* Increase the size of the video to full screen\n* ```js\n*     myPlayer.requestFullscreen();\n* ```\n* In some browsers, full screen is not supported natively, so it enters\n* "full window mode", where the video fills the browser window.\n* In browsers and devices that support native full screen, sometimes the\n* browser\'s default controls will be shown, and not the Video.js custom skin.\n* This includes most mobile devices (iOS, Android) and older versions of\n* Safari.\n*\n* @return {Player} self\n* @method requestFullscreen\n*/',meta:{range:[16719,17247],filename:"player.js",lineno:1633,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>Increase the size of the video to full screen</p>\n<pre class="prettyprint source lang-js"><code>    myPlayer.requestFullscreen();</code></pre><p>In some browsers, full screen is not supported natively, so it enters\n&quot;full window mode&quot;, where the video fills the browser window.\nIn browsers and devices that support native full screen, sometimes the\nbrowser\'s default controls will be shown, and not the Video.js custom skin.\nThis includes most mobile devices (iOS, Android) and older versions of\nSafari.</p>',returns:[{type:{names:["Player"]},description:"<p>self</p>"}],kind:"function",name:"requestFullscreen",longname:"requestFullscreen",scope:"global"},{comment:"/**\n* Return the video to its normal size after having been in full screen mode\n* ```js\n*     myPlayer.exitFullscreen();\n* ```\n*\n* @return {Player} self\n* @method exitFullscreen\n*/",meta:{range:[17371,17551],filename:"player.js",lineno:1689,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>Return the video to its normal size after having been in full screen mode</p>\n<pre class="prettyprint source lang-js"><code>    myPlayer.exitFullscreen();</code></pre>',returns:[{type:{names:["Player"]},description:"<p>self</p>"}],kind:"function",name:"exitFullscreen",longname:"exitFullscreen",scope:"global"},{comment:"/**\n* When fullscreen isn't supported we can stretch the video container to as wide as the browser will let us.\n*\n* @method enterFullWindow\n*/",meta:{range:[17603,17745],filename:"player.js",lineno:1715,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>When fullscreen isn't supported we can stretch the video container to as wide as the browser will let us.</p>",kind:"function",name:"enterFullWindow",longname:"enterFullWindow",scope:"global"},{comment:"/**\n* Check for call to either exit full window or full screen on ESC key\n*\n* @param {String} event Event to check for key press\n* @method fullWindowOnEscKey\n*/",meta:{range:[17800,17960],filename:"player.js",lineno:1738,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Check for call to either exit full window or full screen on ESC key</p>",params:[{type:{names:["String"]},description:"<p>Event to check for key press</p>",name:"event"}],kind:"function",name:"fullWindowOnEscKey",longname:"fullWindowOnEscKey",scope:"global"},{comment:"/**\n* Exit full window\n*\n* @method exitFullWindow\n*/",meta:{range:[17991,18043],filename:"player.js",lineno:1754,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Exit full window</p>",kind:"function",name:"exitFullWindow",longname:"exitFullWindow",scope:"global"},{comment:"/**\n* Check whether the player can play a given mimetype\n*\n* @param {String} type The mimetype to check\n* @return {String} 'probably', 'maybe', or '' (empty string)\n* @method canPlayType\n*/",meta:{range:[18089,18278],filename:"player.js",lineno:1774,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Check whether the player can play a given mimetype</p>",params:[{type:{names:["String"]},description:"<p>The mimetype to check</p>",name:"type"}],returns:[{type:{names:["String"]},description:"<p>'probably', 'maybe', or '' (empty string)</p>"}],kind:"function",name:"canPlayType",longname:"canPlayType",scope:"global"},{comment:"/**\n* Select source based on tech-order or source-order\n* Uses source-order selection if `options.sourceOrder` is truthy. Otherwise,\n* defaults to tech-order selection\n*\n* @param {Array} sources The sources for a media asset\n* @return {Object|Boolean} Object of source and tech order, otherwise false\n* @method selectSource\n*/",meta:{range:[18378,18704],filename:"player.js",lineno:1814,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Select source based on tech-order or source-order\nUses source-order selection if <code>options.sourceOrder</code> is truthy. Otherwise,\ndefaults to tech-order selection</p>",params:[{type:{names:["Array"]},description:"<p>The sources for a media asset</p>",name:"sources"}],returns:[{type:{names:["Object","Boolean"]},description:"<p>Object of source and tech order, otherwise false</p>"}],kind:"function",name:"selectSource",longname:"selectSource",scope:"global"},{comment:'/**\n* The source function updates the video source\n* There are three types of variables you can pass as the argument.\n* **URL String**: A URL to the the video file. Use this method if you are sure\n* the current playback technology (HTML5/Flash) can support the source you\n* provide. Currently only MP4 files can be used in both HTML5 and Flash.\n* ```js\n*     myPlayer.src("http://www.example.com/path/to/video.mp4");\n* ```\n* **Source Object (or element):* * A javascript object containing information\n* about the source file. Use this method if you want the player to determine if\n* it can support the file using the type information.\n* ```js\n*     myPlayer.src({ type: "video/mp4", src: "http://www.example.com/path/to/video.mp4" });\n* ```\n* **Array of Source Objects:* * To provide multiple versions of the source so\n* that it can be played using HTML5 across browsers you can use an array of\n* source objects. Video.js will detect which version is supported and load that\n* file.\n* ```js\n*     myPlayer.src([\n*       { type: "video/mp4", src: "http://www.example.com/path/to/video.mp4" },\n*       { type: "video/webm", src: "http://www.example.com/path/to/video.webm" },\n*       { type: "video/ogg", src: "http://www.example.com/path/to/video.ogv" }\n*     ]);\n* ```\n*\n* @param  {String|Object|Array=} source The source URL, object, or array of sources\n* @return {String} The current video source when getting\n* @return {String} The player when setting\n* @method src\n*/',meta:{range:[18894,20365],filename:"player.js",lineno:1886,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>The source function updates the video source\nThere are three types of variables you can pass as the argument.\n<strong>URL String</strong>: A URL to the the video file. Use this method if you are sure\nthe current playback technology (HTML5/Flash) can support the source you\nprovide. Currently only MP4 files can be used in both HTML5 and Flash.</p>\n<pre class="prettyprint source lang-js"><code>    myPlayer.src(&quot;http://www.example.com/path/to/video.mp4&quot;);</code></pre><p><em>*Source Object (or element):</em> * A javascript object containing information\nabout the source file. Use this method if you want the player to determine if\nit can support the file using the type information.</p>\n<pre class="prettyprint source lang-js"><code>    myPlayer.src({ type: &quot;video/mp4&quot;, src: &quot;http://www.example.com/path/to/video.mp4&quot; });</code></pre><p><em>*Array of Source Objects:</em> * To provide multiple versions of the source so\nthat it can be played using HTML5 across browsers you can use an array of\nsource objects. Video.js will detect which version is supported and load that\nfile.</p>\n<pre class="prettyprint source lang-js"><code>    myPlayer.src([\n      { type: &quot;video/mp4&quot;, src: &quot;http://www.example.com/path/to/video.mp4&quot; },\n      { type: &quot;video/webm&quot;, src: &quot;http://www.example.com/path/to/video.webm&quot; },\n      { type: &quot;video/ogg&quot;, src: &quot;http://www.example.com/path/to/video.ogv&quot; }\n    ]);</code></pre>',params:[{type:{names:["String","Object","Array"]},description:"<p>The source URL, object, or array of sources</p>",name:"source"}],returns:[{type:{names:["String"]},description:"<p>The current video source when getting</p>"},{type:{names:["String"]},description:"<p>The player when setting</p>"}],kind:"function",name:"src",longname:"src",scope:"global"},{comment:"/**\n* Handle an array of source objects\n*\n* @param  {Array} sources Array of source objects\n* @private\n* @method sourceList_\n*/",meta:{range:[20552,20679],filename:"player.js",lineno:1980,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Handle an array of source objects</p>",params:[{type:{names:["Array"]},description:"<p>Array of source objects</p>",name:"sources"}],access:"private",kind:"function",name:"sourceList_",longname:"sourceList_",scope:"global"},{comment:"/**\n* Begin loading the src data.\n*\n* @return {Player} Returns the player\n* @method load\n*/",meta:{range:[20749,20840],filename:"player.js",lineno:2010,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Begin loading the src data.</p>",returns:[{type:{names:["Player"]},description:"<p>Returns the player</p>"}],kind:"function",name:"load",longname:"load",scope:"global"},{comment:"/**\n* Reset the player. Loads the first tech in the techOrder,\n* and calls `reset` on the tech`.\n*\n* @return {Player} Returns the player\n* @method reset\n*/",meta:{range:[20856,21011],filename:"player.js",lineno:2021,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Reset the player. Loads the first tech in the techOrder,\nand calls <code>reset</code> on the tech`.</p>",returns:[{type:{names:["Player"]},description:"<p>Returns the player</p>"}],kind:"function",name:"reset",longname:"reset",scope:"global"},{comment:"/**\n* Returns the fully qualified URL of the current source value e.g. http://mysite.com/video.mp4\n* Can be used in conjuction with `currentType` to assist in rebuilding the current source object.\n*\n* @return {String} The current source\n* @method currentSrc\n*/",meta:{range:[21030,21290],filename:"player.js",lineno:2034,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Returns the fully qualified URL of the current source value e.g. http://mysite.com/video.mp4\nCan be used in conjuction with <code>currentType</code> to assist in rebuilding the current source object.</p>",returns:[{type:{names:["String"]},description:"<p>The current source</p>"}],kind:"function",name:"currentSrc",longname:"currentSrc",scope:"global"},{comment:"/**\n* Get the current source type e.g. video/mp4\n* This can allow you rebuild the current source object so that you could load the same\n* source and tech later\n*\n* @return {String} The source MIME type\n* @method currentType\n*/",meta:{range:[21303,21529],filename:"player.js",lineno:2045,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get the current source type e.g. video/mp4\nThis can allow you rebuild the current source object so that you could load the same\nsource and tech later</p>",returns:[{type:{names:["String"]},description:"<p>The source MIME type</p>"}],kind:"function",name:"currentType",longname:"currentType",scope:"global"},{comment:"/**\n* Get or set the preload attribute\n*\n* @param {Boolean} value Boolean to determine if preload should be used\n* @return {String} The preload attribute value when getting\n* @return {Player} Returns the player when setting\n* @method preload\n*/",meta:{range:[21542,21786],filename:"player.js",lineno:2057,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get or set the preload attribute</p>",params:[{type:{names:["Boolean"]},description:"<p>Boolean to determine if preload should be used</p>",name:"value"}],returns:[{type:{names:["String"]},description:"<p>The preload attribute value when getting</p>"},{type:{names:["Player"]},description:"<p>Returns the player when setting</p>"}],kind:"function",name:"preload",longname:"preload",scope:"global"},{comment:"/**\n* Get or set the autoplay attribute.\n*\n* @param {Boolean} value Boolean to determine if video should autoplay\n* @return {String} The autoplay attribute value when getting\n* @return {Player} Returns the player when setting\n* @method autoplay\n*/",meta:{range:[21814,22061],filename:"player.js",lineno:2074,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get or set the autoplay attribute.</p>",params:[{type:{names:["Boolean"]},description:"<p>Boolean to determine if video should autoplay</p>",name:"value"}],returns:[{type:{names:["String"]},description:"<p>The autoplay attribute value when getting</p>"},{type:{names:["Player"]},description:"<p>Returns the player when setting</p>"}],kind:"function",name:"autoplay",longname:"autoplay",scope:"global"},{comment:"/**\n* Get or set the loop attribute on the video element.\n*\n* @param {Boolean} value Boolean to determine if video should loop\n* @return {String} The loop attribute value when getting\n* @return {Player} Returns the player when setting\n* @method loop\n*/",meta:{range:[22089,22341],filename:"player.js",lineno:2091,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get or set the loop attribute on the video element.</p>",params:[{type:{names:["Boolean"]},description:"<p>Boolean to determine if video should loop</p>",name:"value"}],returns:[{type:{names:["String"]},description:"<p>The loop attribute value when getting</p>"},{type:{names:["Player"]},description:"<p>Returns the player when setting</p>"}],kind:"function",name:"loop",longname:"loop",scope:"global"},{comment:"/**\n* Get or set the poster image source url\n*\n* ##### EXAMPLE:\n* ```js\n*     // get\n*     var currentPoster = myPlayer.poster();\n*     // set\n*     myPlayer.poster('http://example.com/myImage.jpg');\n* ```\n*\n* @param  {String=} src Poster image source URL\n* @return {String} poster URL when getting\n* @return {Player} self when setting\n* @method poster\n*/",meta:{range:[22369,22724],filename:"player.js",lineno:2108,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get or set the poster image source url</p>\n<h5>EXAMPLE:</h5><pre class=\"prettyprint source lang-js\"><code>    // get\n    var currentPoster = myPlayer.poster();\n    // set\n    myPlayer.poster('http://example.com/myImage.jpg');</code></pre>",params:[{type:{names:["String"]},optional:!0,description:"<p>Poster image source URL</p>",name:"src"}],returns:[{type:{names:["String"]},description:"<p>poster URL when getting</p>"},{type:{names:["Player"]},description:"<p>self when setting</p>"}],kind:"function",name:"poster",longname:"poster",scope:"global"},{comment:"/**\n* Some techs (e.g. YouTube) can provide a poster source in an\n* asynchronous way. We want the poster component to use this\n* poster source so that it covers up the tech's controls.\n* (YouTube's play button). However we only want to use this\n* soruce if the player user hasn't set a poster through\n* the normal APIs.\n*\n* @private\n* @method handleTechPosterChange_\n*/",meta:{range:[22794,23163],filename:"player.js",lineno:2147,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Some techs (e.g. YouTube) can provide a poster source in an\nasynchronous way. We want the poster component to use this\nposter source so that it covers up the tech's controls.\n(YouTube's play button). However we only want to use this\nsoruce if the player user hasn't set a poster through\nthe normal APIs.</p>",access:"private",kind:"function",name:"handleTechPosterChange_",longname:"handleTechPosterChange_",scope:"global"},{comment:"/**\n* Get or set whether or not the controls are showing.\n*\n* @param  {Boolean} bool Set controls to showing or not\n* @return {Boolean}    Controls are showing\n* @method controls\n*/",meta:{range:[23191,23372],filename:"player.js",lineno:2167,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get or set whether or not the controls are showing.</p>",params:[{type:{names:["Boolean"]},description:"<p>Set controls to showing or not</p>",name:"bool"}],returns:[{type:{names:["Boolean"]},description:"<p>Controls are showing</p>"}],kind:"function",name:"controls",longname:"controls",scope:"global"},{comment:"/**\n* Toggle native controls on/off. Native controls are the controls built into\n* devices (e.g. default iPhone controls), Flash, or other techs\n* (e.g. Vimeo Controls)\n* **This should only be set by the current tech, because only the tech knows\n* if it can support native controls**\n*\n* @param  {Boolean} bool    True signals that native controls are on\n* @return {Player}      Returns the player\n* @private\n* @method usingNativeControls\n*/",meta:{range:[23475,23916],filename:"player.js",lineno:2208,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Toggle native controls on/off. Native controls are the controls built into\ndevices (e.g. default iPhone controls), Flash, or other techs\n(e.g. Vimeo Controls)\n<strong>This should only be set by the current tech, because only the tech knows\nif it can support native controls</strong></p>",params:[{type:{names:["Boolean"]},description:"<p>True signals that native controls are on</p>",name:"bool"}],returns:[{type:{names:["Player"]},description:"<p>Returns the player</p>"}],access:"private",kind:"function",name:"usingNativeControls",longname:"usingNativeControls",scope:"global"},{comment:"/**\n* player is using the native device controls\n*\n* @event usingnativecontrols\n* @memberof Player\n* @instance\n* @private\n*/",meta:{range:[23944,24068],filename:"player.js",lineno:2229,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>player is using the native device controls</p>",kind:"event",name:"usingnativecontrols",memberof:"Player",scope:"instance",access:"private",longname:"Player#event:usingnativecontrols"},{comment:"/**\n* player is using the custom HTML controls\n*\n* @event usingcustomcontrols\n* @memberof Player\n* @instance\n* @private\n*/",meta:{range:[24081,24203],filename:"player.js",lineno:2241,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>player is using the custom HTML controls</p>",kind:"event",name:"usingcustomcontrols",memberof:"Player",scope:"instance",access:"private",longname:"Player#event:usingcustomcontrols"},{comment:"/**\n* Set or get the current MediaError\n*\n* @param  {*} err A MediaError or a String/Number to be turned into a MediaError\n* @return {MediaError|null}     when getting\n* @return {Player}              when setting\n* @method error\n*/",meta:{range:[24228,24459],filename:"player.js",lineno:2257,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Set or get the current MediaError</p>",params:[{type:{names:["*"]},description:"<p>A MediaError or a String/Number to be turned into a MediaError</p>",name:"err"}],returns:[{type:{names:["MediaError","null"]},description:"<p>when getting</p>"},{type:{names:["Player"]},description:"<p>when setting</p>"}],kind:"function",name:"error",longname:"error",scope:"global"},{comment:'/**\n* Returns whether or not the player is in the "ended" state.\n*\n* @return {Boolean} True if the player is in the ended state, false if not.\n* @method ended\n*/',meta:{range:[24550,24711],filename:"player.js",lineno:2295,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Returns whether or not the player is in the &quot;ended&quot; state.</p>",returns:[{type:{names:["Boolean"]},description:"<p>True if the player is in the ended state, false if not.</p>"}],kind:"function",name:"ended",longname:"ended",scope:"global"},{comment:'/**\n* Returns whether or not the player is in the "seeking" state.\n*\n* @return {Boolean} True if the player is in the seeking state, false if not.\n* @method seeking\n*/',meta:{range:[24718,24885],filename:"player.js",lineno:2303,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Returns whether or not the player is in the &quot;seeking&quot; state.</p>",returns:[{type:{names:["Boolean"]},description:"<p>True if the player is in the seeking state, false if not.</p>"}],kind:"function",name:"seeking",longname:"seeking",scope:"global"},{comment:"/**\n* Returns the TimeRanges of the media that are currently available\n* for seeking to.\n*\n* @return {TimeRanges} the seekable intervals of the media timeline\n* @method seekable\n*/",meta:{range:[24892,25072],filename:"player.js",lineno:2311,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Returns the TimeRanges of the media that are currently available\nfor seeking to.</p>",returns:[{type:{names:["TimeRanges"]},description:"<p>the seekable intervals of the media timeline</p>"}],kind:"function",name:"seekable",longname:"seekable",scope:"global"},{comment:"/**\n* Report user activity\n*\n* @param {Object} event Event object\n* @method reportUserActivity\n*/",meta:{range:[25079,25176],filename:"player.js",lineno:2320,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Report user activity</p>",params:[{type:{names:["Object"]},description:"<p>Event object</p>",name:"event"}],kind:"function",name:"reportUserActivity",longname:"reportUserActivity",scope:"global"},{comment:"/**\n* Get/set if user is active\n*\n* @param {Boolean} bool Value when setting\n* @return {Boolean} Value if user is active user when getting\n* @method userActive\n*/",meta:{range:[25189,25351],filename:"player.js",lineno:2330,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get/set if user is active</p>",params:[{type:{names:["Boolean"]},description:"<p>Value when setting</p>",name:"bool"}],returns:[{type:{names:["Boolean"]},description:"<p>Value if user is active user when getting</p>"}],kind:"function",name:"userActive",longname:"userActive",scope:"global"},{comment:"/**\n* Listen for user activity based on timeout value\n*\n* @private\n* @method listenForUserActivity_\n*/",meta:{range:[25478,25580],filename:"player.js",lineno:2379,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Listen for user activity based on timeout value</p>",access:"private",kind:"function",name:"listenForUserActivity_",longname:"listenForUserActivity_",scope:"global"},{comment:"/**\n* Gets or sets the current playback rate.  A playback rate of\n* 1.0 represents normal speed and 0.5 would indicate half-speed\n* playback, for instance.\n* @see https://html.spec.whatwg.org/multipage/embedded-content.html#dom-media-playbackrate\n*\n* @param  {Number} rate    New playback rate to set.\n* @return {Number}         Returns the new playback rate when setting\n* @return {Number}         Returns the current playback rate when getting\n* @method playbackRate\n*/",meta:{range:[25815,26286],filename:"player.js",lineno:2463,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Gets or sets the current playback rate.  A playback rate of\n1.0 represents normal speed and 0.5 would indicate half-speed\nplayback, for instance.</p>",see:["https://html.spec.whatwg.org/multipage/embedded-content.html#dom-media-playbackrate"],params:[{type:{names:["Number"]},description:"<p>New playback rate to set.</p>",name:"rate"}],returns:[{type:{names:["Number"]},description:"<p>Returns the new playback rate when setting</p>"},{type:{names:["Number"]},description:"<p>Returns the current playback rate when getting</p>"}],kind:"function",name:"playbackRate",longname:"playbackRate",scope:"global"},{comment:"/**\n* Gets or sets the audio flag\n*\n* @param  {Boolean} bool    True signals that this is an audio player.\n* @return {Boolean}         Returns true if player is audio, false if not when getting\n* @return {Player}      Returns the player if setting\n* @private\n* @method isAudio\n*/",meta:{range:[26326,26605],filename:"player.js",lineno:2487,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Gets or sets the audio flag</p>",params:[{type:{names:["Boolean"]},description:"<p>True signals that this is an audio player.</p>",name:"bool"}],returns:[{type:{names:["Boolean"]},description:"<p>Returns true if player is audio, false if not when getting</p>"},{type:{names:["Player"]},description:"<p>Returns the player if setting</p>"}],access:"private",kind:"function",name:"isAudio",longname:"isAudio",scope:"global"},{comment:"/**\n* Returns the current state of network activity for the element, from\n* the codes in the list below.\n* - NETWORK_EMPTY (numeric value 0)\n*   The element has not yet been initialised. All attributes are in\n*   their initial states.\n* - NETWORK_IDLE (numeric value 1)\n*   The element's resource selection algorithm is active and has\n*   selected a resource, but it is not actually using the network at\n*   this time.\n* - NETWORK_LOADING (numeric value 2)\n*   The user agent is actively trying to download data.\n* - NETWORK_NO_SOURCE (numeric value 3)\n*   The element's resource selection algorithm is active, but it has\n*   not yet found a resource to use.\n*\n* @see https://html.spec.whatwg.org/multipage/embedded-content.html#network-states\n* @return {Number} the current network activity state\n* @method networkState\n*/",meta:{range:[26633,27456],filename:"player.js",lineno:2505,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Returns the current state of network activity for the element, from\nthe codes in the list below.</p>\n<ul>\n<li>NETWORK_EMPTY (numeric value 0)\nThe element has not yet been initialised. All attributes are in\ntheir initial states.</li>\n<li>NETWORK_IDLE (numeric value 1)\nThe element's resource selection algorithm is active and has\nselected a resource, but it is not actually using the network at\nthis time.</li>\n<li>NETWORK_LOADING (numeric value 2)\nThe user agent is actively trying to download data.</li>\n<li>NETWORK_NO_SOURCE (numeric value 3)\nThe element's resource selection algorithm is active, but it has\nnot yet found a resource to use.</li>\n</ul>",see:["https://html.spec.whatwg.org/multipage/embedded-content.html#network-states"],returns:[{type:{names:["Number"]},description:"<p>the current network activity state</p>"}],kind:"function",name:"networkState",longname:"networkState",scope:"global"},{comment:"/**\n* Returns a value that expresses the current state of the element\n* with respect to rendering the current playback position, from the\n* codes in the list below.\n* - HAVE_NOTHING (numeric value 0)\n*   No information regarding the media resource is available.\n* - HAVE_METADATA (numeric value 1)\n*   Enough of the resource has been obtained that the duration of the\n*   resource is available.\n* - HAVE_CURRENT_DATA (numeric value 2)\n*   Data for the immediate current playback position is available.\n* - HAVE_FUTURE_DATA (numeric value 3)\n*   Data for the immediate current playback position is available, as\n*   well as enough data for the user agent to advance the current\n*   playback position in the direction of playback.\n* - HAVE_ENOUGH_DATA (numeric value 4)\n*   The user agent estimates that enough data is available for\n*   playback to proceed uninterrupted.\n*\n* @see https://html.spec.whatwg.org/multipage/embedded-content.html#dom-media-readystate\n* @return {Number} the current playback rendering state\n* @method readyState\n*/",
meta:{range:[27469,28509],filename:"player.js",lineno:2529,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Returns a value that expresses the current state of the element\nwith respect to rendering the current playback position, from the\ncodes in the list below.</p>\n<ul>\n<li>HAVE_NOTHING (numeric value 0)\nNo information regarding the media resource is available.</li>\n<li>HAVE_METADATA (numeric value 1)\nEnough of the resource has been obtained that the duration of the\nresource is available.</li>\n<li>HAVE_CURRENT_DATA (numeric value 2)\nData for the immediate current playback position is available.</li>\n<li>HAVE_FUTURE_DATA (numeric value 3)\nData for the immediate current playback position is available, as\nwell as enough data for the user agent to advance the current\nplayback position in the direction of playback.</li>\n<li>HAVE_ENOUGH_DATA (numeric value 4)\nThe user agent estimates that enough data is available for\nplayback to proceed uninterrupted.</li>\n</ul>",see:["https://html.spec.whatwg.org/multipage/embedded-content.html#dom-media-readystate"],returns:[{type:{names:["Number"]},description:"<p>the current playback rendering state</p>"}],kind:"function",name:"readyState",longname:"readyState",scope:"global"},{comment:"/**\n* Get a video track list\n* @link https://html.spec.whatwg.org/multipage/embedded-content.html#videotracklist\n*\n* @return {VideoTrackList} thes current video track list\n* @method videoTracks\n*/",meta:{range:[28522,28718],filename:"player.js",lineno:2556,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get a video track list</p>",tags:[{originalTitle:"link",title:"link",text:"https://html.spec.whatwg.org/multipage/embedded-content.html#videotracklist",value:"https://html.spec.whatwg.org/multipage/embedded-content.html#videotracklist"}],returns:[{type:{names:["VideoTrackList"]},description:"<p>thes current video track list</p>"}],kind:"function",name:"videoTracks",longname:"videoTracks",scope:"global"},{comment:"/**\n* Get an audio track list\n* @link https://html.spec.whatwg.org/multipage/embedded-content.html#audiotracklist\n*\n* @return {AudioTrackList} thes current audio track list\n* @method audioTracks\n*/",meta:{range:[28752,28949],filename:"player.js",lineno:2574,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get an audio track list</p>",tags:[{originalTitle:"link",title:"link",text:"https://html.spec.whatwg.org/multipage/embedded-content.html#audiotracklist",value:"https://html.spec.whatwg.org/multipage/embedded-content.html#audiotracklist"}],returns:[{type:{names:["AudioTrackList"]},description:"<p>thes current audio track list</p>"}],kind:"function",name:"audioTracks",longname:"audioTracks",scope:"global"},{comment:"/**\n* Get an array of associated text tracks. captions, subtitles, chapters, descriptions\n* http://www.w3.org/html/wg/drafts/html/master/embedded-content-0.html#dom-media-texttracks\n*\n* @return {Array}           Array of track objects\n* @method textTracks\n*/",meta:{range:[29427,29685],filename:"player.js",lineno:2600,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get an array of associated text tracks. captions, subtitles, chapters, descriptions\nhttp://www.w3.org/html/wg/drafts/html/master/embedded-content-0.html#dom-media-texttracks</p>",returns:[{type:{names:["Array"]},description:"<p>Array of track objects</p>"}],kind:"function",name:"textTracks",longname:"textTracks",scope:"global"},{comment:"/**\n* Get an array of remote text tracks\n*\n* @return {Array}\n* @method remoteTextTracks\n*/",meta:{range:[29704,29794],filename:"player.js",lineno:2613,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get an array of remote text tracks</p>",returns:[{type:{names:["Array"]}}],kind:"function",name:"remoteTextTracks",longname:"remoteTextTracks",scope:"global"},{comment:"/**\n* Get an array of remote html track elements\n*\n* @return {HTMLTrackElement[]}\n* @method remoteTextTrackEls\n*/",meta:{range:[29807,29920],filename:"player.js",lineno:2623,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get an array of remote html track elements</p>",returns:[{type:{names:["Array.<HTMLTrackElement>"]}}],kind:"function",name:"remoteTextTrackEls",longname:"remoteTextTrackEls",scope:"global"},{comment:"/**\n* Add a text track\n* In addition to the W3C settings we allow adding additional info through options.\n* http://www.w3.org/html/wg/drafts/html/master/embedded-content-0.html#dom-media-addtexttrack\n*\n* @param {String}  kind        Captions, subtitles, chapters, descriptions, or metadata\n* @param {String=} label       Optional label\n* @param {String=} language    Optional language\n* @method addTextTrack\n*/",meta:{range:[29933,30343],filename:"player.js",lineno:2633,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Add a text track\nIn addition to the W3C settings we allow adding additional info through options.\nhttp://www.w3.org/html/wg/drafts/html/master/embedded-content-0.html#dom-media-addtexttrack</p>",params:[{type:{names:["String"]},description:"<p>Captions, subtitles, chapters, descriptions, or metadata</p>",name:"kind"},{type:{names:["String"]},optional:!0,description:"<p>Optional label</p>",name:"label"},{type:{names:["String"]},optional:!0,description:"<p>Optional language</p>",name:"language"}],kind:"function",name:"addTextTrack",longname:"addTextTrack",scope:"global"},{comment:"/**\n* Add a remote text track\n*\n* @param {Object} options    Options for remote text track\n* @method addRemoteTextTrack\n*/",meta:{range:[30356,30478],filename:"player.js",lineno:2647,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Add a remote text track</p>",params:[{type:{names:["Object"]},description:"<p>Options for remote text track</p>",name:"options"}],kind:"function",name:"addRemoteTextTrack",longname:"addRemoteTextTrack",scope:"global"},{comment:"/**\n* Remove a remote text track\n*\n* @param {Object} track    Remote text track to remove\n* @method removeRemoteTextTrack\n*/",meta:{range:[30491,30615],filename:"player.js",lineno:2657,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Remove a remote text track</p>",params:[{type:{names:["Object"]},description:"<p>Remote text track to remove</p>",name:"track"}],kind:"function",name:"removeRemoteTextTrack",longname:"removeRemoteTextTrack",scope:"global"},{comment:"/**\n* Get video width\n*\n* @return {Number} Video width\n* @method videoWidth\n*/",meta:{range:[30634,30712],filename:"player.js",lineno:2669,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get video width</p>",returns:[{type:{names:["Number"]},description:"<p>Video width</p>"}],kind:"function",name:"videoWidth",longname:"videoWidth",scope:"global"},{comment:"/**\n* Get video height\n*\n* @return {Number} Video height\n* @method videoHeight\n*/",meta:{range:[30725,30806],filename:"player.js",lineno:2679,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get video height</p>",returns:[{type:{names:["Number"]},description:"<p>Video height</p>"}],kind:"function",name:"videoHeight",longname:"videoHeight",scope:"global"},{comment:"/**\n* The player's language code\n* NOTE: The language should be set in the player options if you want the\n* the controls to be built with a specific language. Changing the lanugage\n* later will not update controls text.\n*\n* @param {String} code  The locale string\n* @return {String}      The locale string when getting\n* @return {Player}      self when setting\n* @method language\n*/",meta:{range:[30840,31222],filename:"player.js",lineno:2696,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>The player's language code\nNOTE: The language should be set in the player options if you want the\nthe controls to be built with a specific language. Changing the lanugage\nlater will not update controls text.</p>",params:[{type:{names:["String"]},description:"<p>The locale string</p>",name:"code"}],returns:[{type:{names:["String"]},description:"<p>The locale string when getting</p>"},{type:{names:["Player"]},description:"<p>self when setting</p>"}],kind:"function",name:"language",longname:"language",scope:"global"},{comment:"/**\n* Get the player's language dictionary\n* Merge every time, because a newly added plugin might call videojs.addLanguage() at any time\n* Languages specified directly in the player options have precedence\n*\n* @return {Array} Array of languages\n* @method languages\n*/",meta:{range:[31250,31517],filename:"player.js",lineno:2716,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get the player's language dictionary\nMerge every time, because a newly added plugin might call videojs.addLanguage() at any time\nLanguages specified directly in the player options have precedence</p>",returns:[{type:{names:["Array"]},description:"<p>Array of languages</p>"}],kind:"function",name:"languages",longname:"languages",scope:"global"},{comment:"/**\n* Converts track info to JSON\n*\n* @return {Object} JSON object of options\n* @method toJSON\n*/",meta:{range:[31530,31627],filename:"player.js",lineno:2728,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Converts track info to JSON</p>",returns:[{type:{names:["Object"]},description:"<p>JSON object of options</p>"}],kind:"function",name:"toJSON",longname:"toJSON",scope:"global"},{comment:"/**\n* Gets tag settings\n*\n* @param {Element} tag The player tag\n* @return {Array} An array of sources and track objects\n* @static\n* @method getTagSettings\n*/",meta:{range:[32247,32404],filename:"player.js",lineno:2784,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Gets tag settings</p>",params:[{type:{names:["Element"]},description:"<p>The player tag</p>",name:"tag"}],returns:[{type:{names:["Array"]},description:"<p>An array of sources and track objects</p>"}],scope:"static",kind:"function",name:"getTagSettings",longname:"getTagSettings"},{comment:"/**\n* Fired when the user agent begins looking for media data\n*\n* @event loadstart\n*/",meta:{range:[32870,32955],filename:"player.js",lineno:2891,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired when the user agent begins looking for media data</p>",kind:"event",name:"loadstart",longname:"event:loadstart",scope:"global"},{comment:"/**\n* Fired when the player has initial duration and dimension information\n*\n* @event loadedmetadata\n*/",meta:{range:[32962,33065],filename:"player.js",lineno:2898,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired when the player has initial duration and dimension information</p>",kind:"event",name:"loadedmetadata",longname:"event:loadedmetadata",scope:"global"},{comment:"/**\n* Fired when the player receives text data\n*\n* @event textdata\n*/",meta:{range:[33072,33141],filename:"player.js",lineno:2905,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired when the player receives text data</p>",kind:"event",name:"textdata",longname:"event:textdata",scope:"global"},{comment:"/**\n* Fired when the player has downloaded data at the current playback position\n*\n* @event loadeddata\n*/",meta:{range:[33148,33253],filename:"player.js",lineno:2912,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired when the player has downloaded data at the current playback position</p>",kind:"event",name:"loadeddata",longname:"event:loadeddata",scope:"global"},{comment:"/**\n* Fired when the user is active, e.g. moves the mouse over the player\n*\n* @event useractive\n*/",meta:{range:[33260,33358],filename:"player.js",lineno:2919,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired when the user is active, e.g. moves the mouse over the player</p>",kind:"event",name:"useractive",longname:"event:useractive",scope:"global"},{comment:"/**\n* Fired when the user is inactive, e.g. a short delay after the last mouse move or control interaction\n*\n* @event userinactive\n*/",meta:{range:[33365,33498],filename:"player.js",lineno:2926,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired when the user is inactive, e.g. a short delay after the last mouse move or control interaction</p>",kind:"event",name:"userinactive",longname:"event:userinactive",scope:"global"},{comment:"/**\n* Fired when the current playback position has changed *\n* During playback this is fired every 15-250 milliseconds, depending on the\n* playback technology in use.\n*\n* @event timeupdate\n*/",meta:{range:[33505,33696],filename:"player.js",lineno:2933,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired when the current playback position has changed *\nDuring playback this is fired every 15-250 milliseconds, depending on the\nplayback technology in use.</p>",kind:"event",name:"timeupdate",longname:"event:timeupdate",scope:"global"},{comment:"/**\n* Fired when video playback ends\n*\n* @event ended\n*/",meta:{range:[33703,33759],filename:"player.js",lineno:2942,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired when video playback ends</p>",kind:"event",name:"ended",longname:"event:ended",scope:"global"},{comment:"/**\n* Fired when the volume changes\n*\n* @event volumechange\n*/",meta:{range:[33766,33828],filename:"player.js",lineno:2949,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired when the volume changes</p>",kind:"event",name:"volumechange",longname:"event:volumechange",scope:"global"},{comment:"/**\n* Fired when an error occurs\n*\n* @event error\n*/",meta:{range:[33835,33887],filename:"player.js",lineno:2956,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Fired when an error occurs</p>",kind:"event",name:"error",longname:"event:error",scope:"global"},{comment:"/**\n* @file plugins.js\n*/",meta:{range:[0,25],filename:"plugins.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},name:"plugins.js",kind:"file",description:"<p>plugins.js</p>",preserveName:!0,longname:"plugins.js",scope:"global"},{comment:"/**\n* The method for registering a video.js plugin\n*\n* @param  {String} name The name of the plugin\n* @param  {Function} init The function that is run when the player inits\n* @method plugin\n*/",meta:{range:[32,224],filename:"plugins.js",lineno:6,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>The method for registering a video.js plugin</p>",params:[{type:{names:["String"]},description:"<p>The name of the plugin</p>",name:"name"},{type:{names:["function"]},description:"<p>The function that is run when the player inits</p>",name:"init"}],kind:"function",name:"plugin",longname:"plugin",scope:"global"},{comment:"/**\n* @file popup-button.js\n*/",meta:{range:[0,30],filename:"popup-button.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/popup",code:{}},name:"popup/popup-button.js",kind:"file",description:"<p>popup-button.js</p>",preserveName:!0,longname:"popup/popup-button.js",scope:"global"},{comment:"/**\n* A button class with a popup control\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends ClickableComponent\n* @class PopupButton\n*/",meta:{range:[52,208],filename:"popup-button.js",lineno:11,path:"/Users/mboles/git/docs/video.js/src/js/popup",code:{}},description:"<p>A button class with a popup control</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["ClickableComponent"],kind:"class",name:"PopupButton",longname:"PopupButton",scope:"global"},{comment:"/**\n* Update popup\n*\n* @method update\n*/",meta:{range:[233,273],filename:"popup-button.js",lineno:27,path:"/Users/mboles/git/docs/video.js/src/js/popup",code:{}},description:"<p>Update popup</p>",kind:"function",name:"update",longname:"update",scope:"global"},{comment:"/**\n* Create popup - Override with specific functionality for component\n*\n* @return {Popup} The constructed popup\n* @method createPopup\n*/",meta:{range:[325,463],filename:"popup-button.js",lineno:49,path:"/Users/mboles/git/docs/video.js/src/js/popup",code:{}},description:"<p>Create popup - Override with specific functionality for component</p>",returns:[{type:{names:["Popup"]},description:"<p>The constructed popup</p>"}],kind:"function",name:"createPopup",longname:"createPopup",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[470,554],filename:"popup-button.js",lineno:57,path:"/Users/mboles/git/docs/video.js/src/js/popup",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Allow sub components to stack CSS class names\n*\n* @return {String} The constructed class name\n* @method buildCSSClass\n*/",meta:{range:[573,699],filename:"popup-button.js",lineno:69,path:"/Users/mboles/git/docs/video.js/src/js/popup",code:{}},description:"<p>Allow sub components to stack CSS class names</p>",returns:[{type:{names:["String"]},description:"<p>The constructed class name</p>"}],kind:"function",name:"buildCSSClass",longname:"buildCSSClass",scope:"global"},{comment:"/**\n* @file popup.js\n*/",meta:{range:[0,23],filename:"popup.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/popup",code:{}},name:"popup/popup.js",kind:"file",description:"<p>popup.js</p>",preserveName:!0,longname:"popup/popup.js",scope:"global"},{comment:"/**\n* The Popup component is used to build pop up controls.\n*\n* @extends Component\n* @class Popup\n*/",meta:{range:[39,139],filename:"popup.js",lineno:9,path:"/Users/mboles/git/docs/video.js/src/js/popup",code:{}},description:"<p>The Popup component is used to build pop up controls.</p>",augments:["Component"],kind:"class",name:"Popup",longname:"Popup",scope:"global"},{comment:"/**\n* Add a popup item to the popup\n*\n* @param {Object|String} component Component or component type to add\n* @method addItem\n*/",meta:{range:[146,274],filename:"popup.js",lineno:17,path:"/Users/mboles/git/docs/video.js/src/js/popup",code:{}},description:"<p>Add a popup item to the popup</p>",params:[{type:{names:["Object","String"]},description:"<p>Component or component type to add</p>",name:"component"}],kind:"function",name:"addItem",longname:"addItem",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[296,380],filename:"popup.js",lineno:30,path:"/Users/mboles/git/docs/video.js/src/js/popup",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* @file poster-image.js\n*/",meta:{range:[0,30],filename:"poster-image.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},name:"poster-image.js",kind:"file",description:"<p>poster-image.js</p>",preserveName:!0,longname:"poster-image.js",scope:"global"},{comment:"/**\n* The component that handles showing the poster image.\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Button\n* @class PosterImage\n*/",meta:{range:[49,210],filename:"poster-image.js",lineno:10,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>The component that handles showing the poster image.</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Button"],kind:"class",name:"PosterImage",longname:"PosterImage",scope:"global"},{comment:"/**\n* Clean up the poster image\n*\n* @method dispose\n*/",meta:{range:[238,292],filename:"poster-image.js",lineno:27,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Clean up the poster image</p>",kind:"function",name:"dispose",longname:"dispose",scope:"global"},{comment:"/**\n* Create the poster's image element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[308,391],filename:"poster-image.js",lineno:37,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Create the poster's image element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Event handler for updates to the player's poster source\n*\n* @method update\n*/",meta:{range:[452,535],filename:"poster-image.js",lineno:63,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Event handler for updates to the player's poster source</p>",kind:"function",name:"update",longname:"update",scope:"global"},{comment:"/**\n* Set the poster source depending on the display method\n*\n* @param {String} url The URL to the poster source\n* @method setSrc\n*/",meta:{range:[578,710],filename:"poster-image.js",lineno:82,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Set the poster source depending on the display method</p>",params:[{type:{names:["String"]},description:"<p>The URL to the poster source</p>",name:"url"}],kind:"function",name:"setSrc",longname:"setSrc",scope:"global"},{comment:"/**\n* Event handler for clicks on the poster image\n*\n* @method handleClick\n*/",meta:{range:[756,833],filename:"poster-image.js",lineno:103,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Event handler for clicks on the poster image</p>",kind:"function",name:"handleClick",longname:"handleClick",scope:"global"},{comment:"/**\n* @file setup.js\n*\n* Functions for automatically setting up a player\n* based on the data-setup attribute of the video tag\n*/",meta:{range:[0,128],filename:"setup.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},name:"setup.js",kind:"file",description:"<p>setup.js</p>\n<p>Functions for automatically setting up a player\nbased on the data-setup attribute of the video tag</p>",preserveName:!0,longname:"setup.js",scope:"global"},{comment:"/**\n* @file slider.js\n*/",meta:{range:[0,24],filename:"slider.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/slider",code:{}},name:"slider/slider.js",kind:"file",description:"<p>slider.js</p>",preserveName:!0,longname:"slider/slider.js",scope:"global"},{comment:"/**\n* The base functionality for sliders like the volume bar and seek bar\n*\n* @param {Player|Object} player\n* @param {Object=} options\n* @extends Component\n* @class Slider\n*/",meta:{range:[37,211],filename:"slider.js",lineno:8,path:"/Users/mboles/git/docs/video.js/src/js/slider",code:{}},description:"<p>The base functionality for sliders like the volume bar and seek bar</p>",params:[{type:{names:["Player","Object"]},name:"player"},{type:{names:["Object"]},optional:!0,name:"options"}],augments:["Component"],kind:"class",name:"Slider",longname:"Slider",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @param {String} type Type of element to create\n* @param {Object=} props List of properties in Object form\n* @return {Element}\n* @method createEl\n*/",meta:{range:[275,467],filename:"slider.js",lineno:37,path:"/Users/mboles/git/docs/video.js/src/js/slider",code:{}},description:"<p>Create the component's DOM element</p>",params:[{type:{names:["String"]},description:"<p>Type of element to create</p>",name:"type"},{type:{names:["Object"]},optional:!0,description:"<p>List of properties in Object form</p>",name:"props"}],returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Handle mouse down on slider\n*\n* @param {Object} event Mouse down event object\n* @method handleMouseDown\n*/",meta:{range:[522,634],filename:"slider.js",lineno:63,path:"/Users/mboles/git/docs/video.js/src/js/slider",code:{}},description:"<p>Handle mouse down on slider</p>",params:[{type:{names:["Object"]},description:"<p>Mouse down event object</p>",name:"event"}],kind:"function",name:"handleMouseDown",longname:"handleMouseDown",scope:"global"},{comment:"/**\n* To be overridden by a subclass\n*\n* @method handleMouseMove\n*/",meta:{range:[686,753],filename:"slider.js",lineno:86,path:"/Users/mboles/git/docs/video.js/src/js/slider",code:{}},description:"<p>To be overridden by a subclass</p>",kind:"function",name:"handleMouseMove",longname:"handleMouseMove",scope:"global"},{comment:"/**\n* Handle mouse up on Slider\n*\n* @method handleMouseUp\n*/",meta:{range:[760,820],filename:"slider.js",lineno:93,path:"/Users/mboles/git/docs/video.js/src/js/slider",code:{}},description:"<p>Handle mouse up on Slider</p>",kind:"function",name:"handleMouseUp",longname:"handleMouseUp",scope:"global"},{comment:"/**\n* Update slider\n*\n* @method update\n*/",meta:{range:[869,910],filename:"slider.js",lineno:114,path:"/Users/mboles/git/docs/video.js/src/js/slider",code:{}},description:"<p>Update slider</p>",kind:"function",name:"update",longname:"update",scope:"global"},{comment:"/**\n* Calculate distance for slider\n*\n* @param {Object} event Event object\n* @method calculateDistance\n*/",meta:{range:[1010,1115],filename:"slider.js",lineno:152,path:"/Users/mboles/git/docs/video.js/src/js/slider",code:{}},description:"<p>Calculate distance for slider</p>",params:[{type:{names:["Object"]},description:"<p>Event object</p>",name:"event"}],kind:"function",name:"calculateDistance",longname:"calculateDistance",scope:"global"},{comment:"/**\n* Handle on focus for slider\n*\n* @method handleFocus\n*/",meta:{range:[1140,1199],filename:"slider.js",lineno:166,path:"/Users/mboles/git/docs/video.js/src/js/slider",code:{}},description:"<p>Handle on focus for slider</p>",kind:"function",name:"handleFocus",longname:"handleFocus",scope:"global"},{comment:"/**\n* Handle key press for slider\n*\n* @param {Object} event Event object\n* @method handleKeyPress\n*/",meta:{range:[1212,1312],filename:"slider.js",lineno:175,path:"/Users/mboles/git/docs/video.js/src/js/slider",code:{}},description:"<p>Handle key press for slider</p>",params:[{type:{names:["Object"]},description:"<p>Event object</p>",name:"event"}],kind:"function",name:"handleKeyPress",longname:"handleKeyPress",scope:"global"},{comment:"/**\n* Handle on blur for slider\n*\n* @method handleBlur\n*/",meta:{range:[1343,1400],filename:"slider.js",lineno:191,path:"/Users/mboles/git/docs/video.js/src/js/slider",code:{}},description:"<p>Handle on blur for slider</p>",kind:"function",name:"handleBlur",longname:"handleBlur",scope:"global"},{comment:"/**\n* Listener for click events on slider, used to prevent clicks\n*   from bubbling up to parent elements like button menus.\n*\n* @param {Object} event Event object\n* @method handleClick\n*/",meta:{range:[1413,1601],filename:"slider.js",lineno:200,path:"/Users/mboles/git/docs/video.js/src/js/slider",code:{}},description:"<p>Listener for click events on slider, used to prevent clicks\n  from bubbling up to parent elements like button menus.</p>",params:[{type:{names:["Object"]},description:"<p>Event object</p>",name:"event"}],kind:"function",name:"handleClick",longname:"handleClick",scope:"global"},{comment:"/**\n* Get/set if slider is horizontal for vertical\n*\n* @param {Boolean} bool True if slider is vertical, false is horizontal\n* @return {Boolean} True if slider is vertical, false is horizontal\n* @method vertical\n*/",meta:{range:[1617,1831],filename:"slider.js",lineno:212,path:"/Users/mboles/git/docs/video.js/src/js/slider",code:{}},description:"<p>Get/set if slider is horizontal for vertical</p>",params:[{type:{names:["Boolean"]},description:"<p>True if slider is vertical, false is horizontal</p>",name:"bool"}],returns:[{type:{names:["Boolean"]},description:"<p>True if slider is vertical, false is horizontal</p>"}],kind:"function",name:"vertical",longname:"vertical",scope:"global"},{comment:"/**\n* @file flash-rtmp.js\n*/",meta:{range:[0,28],filename:"flash-rtmp.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},name:"tech/flash-rtmp.js",kind:"file",description:"<p>flash-rtmp.js</p>",preserveName:!0,longname:"tech/flash-rtmp.js",scope:"global"},{comment:"/**\n* @file flash.js\n* VideoJS-SWF - Custom Flash Player with HTML5-ish API\n* https://github.com/zencoder/video-js-swf\n* Not using setupTriggers. Using global onEvent func to distribute events\n*/",meta:{range:[0,195],filename:"flash.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},name:"tech/flash.js",kind:"file",description:"<p>flash.js\nVideoJS-SWF - Custom Flash Player with HTML5-ish API\nhttps://github.com/zencoder/video-js-swf\nNot using setupTriggers. Using global onEvent func to distribute events</p>",preserveName:!0,longname:"tech/flash.js",scope:"global"},{comment:"/**\n* Flash Media Controller - Wrapper for fallback SWF API\n*\n* @param {Object=} options Object of option names and values\n* @param {Function=} ready Ready callback function\n* @extends Tech\n* @class Flash\n*/",meta:{range:[229,436],filename:"flash.js",lineno:18,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Flash Media Controller - Wrapper for fallback SWF API</p>",params:[{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"},{type:{names:["function"]},optional:!0,description:"<p>Ready callback function</p>",name:"ready"}],augments:["Tech"],kind:"class",name:"Flash",longname:"Flash",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[548,632],filename:"flash.js",lineno:63,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Play for flash tech\n*\n* @method play\n*/",meta:{range:[780,825],filename:"flash.js",lineno:118,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Play for flash tech</p>",kind:"function",name:"play",longname:"play",scope:"global"},{comment:"/**\n* Pause for flash tech\n*\n* @method pause\n*/",meta:{range:[847,894],filename:"flash.js",lineno:130,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Pause for flash tech</p>",kind:"function",name:"pause",longname:"pause",scope:"global"},{comment:"/**\n* Get/set video\n*\n* @param {Object=} src Source object\n* @return {Object}\n* @method src\n*/",meta:{range:[907,1001],filename:"flash.js",lineno:139,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get/set video</p>",params:[{type:{names:["Object"]},optional:!0,description:"<p>Source object</p>",name:"src"}],returns:[{type:{names:["Object"]}}],kind:"function",name:"src",longname:"src",scope:"global"},{comment:"/**\n* Set video\n*\n* @param {Object=} src Source object\n* @deprecated\n* @method setSrc\n*/",meta:{range:[1029,1117],filename:"flash.js",lineno:155,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Set video</p>",params:[{type:{names:["Object"]},optional:!0,description:"<p>Source object</p>",name:"src"}],deprecated:!0,kind:"function",name:"setSrc",longname:"setSrc",scope:"global"},{comment:"/**\n* Set current time\n*\n* @param {Number} time Current time of video\n* @method setCurrentTime\n*/",meta:{range:[1261,1358],filename:"flash.js",lineno:183,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Set current time</p>",params:[{type:{names:["Number"]},description:"<p>Current time of video</p>",name:"time"}],kind:"function",name:"setCurrentTime",longname:"setCurrentTime",scope:"global"},{comment:"/**\n* Get current time\n*\n* @param {Number=} time Current time of video\n* @return {Number} Current time\n* @method currentTime\n*/",meta:{range:[1401,1528],filename:"flash.js",lineno:203,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get current time</p>",
params:[{type:{names:["Number"]},optional:!0,description:"<p>Current time of video</p>",name:"time"}],returns:[{type:{names:["Number"]},description:"<p>Current time</p>"}],kind:"function",name:"currentTime",longname:"currentTime",scope:"global"},{comment:"/**\n* Get current source\n*\n* @method currentSrc\n*/",meta:{range:[1556,1606],filename:"flash.js",lineno:219,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get current source</p>",kind:"function",name:"currentSrc",longname:"currentSrc",scope:"global"},{comment:"/**\n* Load media into player\n*\n* @method load\n*/",meta:{range:[1723,1771],filename:"flash.js",lineno:246,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Load media into player</p>",kind:"function",name:"load",longname:"load",scope:"global"},{comment:"/**\n* Get poster\n*\n* @method poster\n*/",meta:{range:[1784,1822],filename:"flash.js",lineno:255,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get poster</p>",kind:"function",name:"poster",longname:"poster",scope:"global"},{comment:"/**\n* Poster images are not handled by the Flash tech so make this a no-op\n*\n* @method setPoster\n*/",meta:{range:[1835,1934],filename:"flash.js",lineno:264,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Poster images are not handled by the Flash tech so make this a no-op</p>",kind:"function",name:"setPoster",longname:"setPoster",scope:"global"},{comment:"/**\n* Determine if can seek in media\n*\n* @return {TimeRangeObject}\n* @method seekable\n*/",meta:{range:[1941,2029],filename:"flash.js",lineno:271,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Determine if can seek in media</p>",returns:[{type:{names:["TimeRangeObject"]}}],kind:"function",name:"seekable",longname:"seekable",scope:"global"},{comment:"/**\n* Get buffered time range\n*\n* @return {TimeRangeObject}\n* @method buffered\n*/",meta:{range:[2054,2135],filename:"flash.js",lineno:285,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get buffered time range</p>",returns:[{type:{names:["TimeRangeObject"]}}],kind:"function",name:"buffered",longname:"buffered",scope:"global"},{comment:"/**\n* Get fullscreen support -\n* Flash does not allow fullscreen through javascript\n* so always returns false\n*\n* @return {Boolean} false\n* @method supportsFullScreen\n*/",meta:{range:[2160,2329],filename:"flash.js",lineno:299,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get fullscreen support -\nFlash does not allow fullscreen through javascript\nso always returns false</p>",returns:[{type:{names:["Boolean"]},description:"<p>false</p>"}],kind:"function",name:"supportsFullScreen",longname:"supportsFullScreen",scope:"global"},{comment:"/**\n* Request to enter fullscreen\n* Flash does not allow fullscreen through javascript\n* so always returns false\n*\n* @return {Boolean} false\n* @method enterFullScreen\n*/",meta:{range:[2342,2511],filename:"flash.js",lineno:311,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Request to enter fullscreen\nFlash does not allow fullscreen through javascript\nso always returns false</p>",returns:[{type:{names:["Boolean"]},description:"<p>false</p>"}],kind:"function",name:"enterFullScreen",longname:"enterFullScreen",scope:"global"},{comment:"/**\n* @file html5.js\n* HTML5 Media Controller - Wrapper for HTML5 Media API\n*/",meta:{range:[0,78],filename:"html5.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},name:"tech/html5.js",kind:"file",description:"<p>html5.js\nHTML5 Media Controller - Wrapper for HTML5 Media API</p>",preserveName:!0,longname:"tech/html5.js",scope:"global"},{comment:"/**\n* HTML5 Media Controller - Wrapper for HTML5 Media API\n*\n* @param {Object=} options Object of option names and values\n* @param {Function=} ready Ready callback function\n* @extends Tech\n* @class Html5\n*/",meta:{range:[127,333],filename:"html5.js",lineno:21,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>HTML5 Media Controller - Wrapper for HTML5 Media API</p>",params:[{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"},{type:{names:["function"]},optional:!0,description:"<p>Ready callback function</p>",name:"ready"}],augments:["Tech"],kind:"class",name:"Html5",longname:"Html5",scope:"global"},{comment:"/**\n* Dispose of html5 media element\n*\n* @method dispose\n*/",meta:{range:[628,687],filename:"html5.js",lineno:127,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Dispose of html5 media element</p>",kind:"function",name:"dispose",longname:"dispose",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[757,841],filename:"html5.js",lineno:155,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Play for html5 tech\n*\n* @method play\n*/",meta:{range:[1855,1900],filename:"html5.js",lineno:423,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Play for html5 tech</p>",kind:"function",name:"play",longname:"play",scope:"global"},{comment:"/**\n* Pause for html5 tech\n*\n* @method pause\n*/",meta:{range:[1931,1978],filename:"html5.js",lineno:438,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Pause for html5 tech</p>",kind:"function",name:"pause",longname:"pause",scope:"global"},{comment:"/**\n* Paused for html5 tech\n*\n* @return {Boolean}\n* @method paused\n*/",meta:{range:[1985,2054],filename:"html5.js",lineno:445,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Paused for html5 tech</p>",returns:[{type:{names:["Boolean"]}}],kind:"function",name:"paused",longname:"paused",scope:"global"},{comment:"/**\n* Get current time\n*\n* @return {Number}\n* @method currentTime\n*/",meta:{range:[2061,2129],filename:"html5.js",lineno:453,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get current time</p>",returns:[{type:{names:["Number"]}}],kind:"function",name:"currentTime",longname:"currentTime",scope:"global"},{comment:"/**\n* Set current time\n*\n* @param {Number} seconds Current time of video\n* @method setCurrentTime\n*/",meta:{range:[2136,2236],filename:"html5.js",lineno:461,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Set current time</p>",params:[{type:{names:["Number"]},description:"<p>Current time of video</p>",name:"seconds"}],kind:"function",name:"setCurrentTime",longname:"setCurrentTime",scope:"global"},{comment:"/**\n* Get duration\n*\n* @return {Number}\n* @method duration\n*/",meta:{range:[2264,2325],filename:"html5.js",lineno:476,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get duration</p>",returns:[{type:{names:["Number"]}}],kind:"function",name:"duration",longname:"duration",scope:"global"},{comment:"/**\n* Get a TimeRange object that represents the intersection\n* of the time ranges for which the user agent has all\n* relevant media\n*\n* @return {TimeRangeObject}\n* @method buffered\n*/",meta:{range:[2332,2516],filename:"html5.js",lineno:484,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get a TimeRange object that represents the intersection\nof the time ranges for which the user agent has all\nrelevant media</p>",returns:[{type:{names:["TimeRangeObject"]}}],kind:"function",name:"buffered",longname:"buffered",scope:"global"},{comment:"/**\n* Get volume level\n*\n* @return {Number}\n* @method volume\n*/",meta:{range:[2523,2586],filename:"html5.js",lineno:494,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get volume level</p>",returns:[{type:{names:["Number"]}}],kind:"function",name:"volume",longname:"volume",scope:"global"},{comment:"/**\n* Set volume level\n*\n* @param {Number} percentAsDecimal Volume percent as a decimal\n* @method setVolume\n*/",meta:{range:[2593,2703],filename:"html5.js",lineno:502,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Set volume level</p>",params:[{type:{names:["Number"]},description:"<p>Volume percent as a decimal</p>",name:"percentAsDecimal"}],kind:"function",name:"setVolume",longname:"setVolume",scope:"global"},{comment:"/**\n* Get if muted\n*\n* @return {Boolean}\n* @method muted\n*/",meta:{range:[2710,2769],filename:"html5.js",lineno:510,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get if muted</p>",returns:[{type:{names:["Boolean"]}}],kind:"function",name:"muted",longname:"muted",scope:"global"},{comment:"/**\n* Set muted\n*\n* @param {Boolean} If player is to be muted or note\n* @method setMuted\n*/",meta:{range:[2776,2867],filename:"html5.js",lineno:518,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Set muted</p>",params:[{type:{names:["Boolean"]},description:"<p>player is to be muted or note</p>",name:"If"}],kind:"function",name:"setMuted",longname:"setMuted",scope:"global"},{comment:"/**\n* Get player width\n*\n* @return {Number}\n* @method width\n*/",meta:{range:[2874,2936],filename:"html5.js",lineno:526,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get player width</p>",returns:[{type:{names:["Number"]}}],kind:"function",name:"width",longname:"width",scope:"global"},{comment:"/**\n* Get player height\n*\n* @return {Number}\n* @method height\n*/",meta:{range:[2943,3007],filename:"html5.js",lineno:534,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get player height</p>",returns:[{type:{names:["Number"]}}],kind:"function",name:"height",longname:"height",scope:"global"},{comment:"/**\n* Get if there is fullscreen support\n*\n* @return {Boolean}\n* @method supportsFullScreen\n*/",meta:{range:[3014,3108],filename:"html5.js",lineno:542,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get if there is fullscreen support</p>",returns:[{type:{names:["Boolean"]}}],kind:"function",name:"supportsFullScreen",longname:"supportsFullScreen",scope:"global"},{comment:"/**\n* Request to enter fullscreen\n*\n* @method enterFullScreen\n*/",meta:{range:[3142,3206],filename:"html5.js",lineno:559,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Request to enter fullscreen</p>",kind:"function",name:"enterFullScreen",longname:"enterFullScreen",scope:"global"},{comment:"/**\n* Request to exit fullscreen\n*\n* @method exitFullScreen\n*/",meta:{range:[3294,3356],filename:"html5.js",lineno:593,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Request to exit fullscreen</p>",kind:"function",name:"exitFullScreen",longname:"exitFullScreen",scope:"global"},{comment:"/**\n* Get/set video\n*\n* @param {Object=} src Source object\n* @return {Object}\n* @method src\n*/",meta:{range:[3369,3463],filename:"html5.js",lineno:602,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get/set video</p>",params:[{type:{names:["Object"]},optional:!0,description:"<p>Source object</p>",name:"src"}],returns:[{type:{names:["Object"]}}],kind:"function",name:"src",longname:"src",scope:"global"},{comment:"/**\n* Set video\n*\n* @param {Object} src Source object\n* @deprecated\n* @method setSrc\n*/",meta:{range:[3491,3578],filename:"html5.js",lineno:618,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Set video</p>",params:[{type:{names:["Object"]},description:"<p>Source object</p>",name:"src"}],deprecated:!0,kind:"function",name:"setSrc",longname:"setSrc",scope:"global"},{comment:"/**\n* Load media into player\n*\n* @method load\n*/",meta:{range:[3591,3639],filename:"html5.js",lineno:629,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Load media into player</p>",kind:"function",name:"load",longname:"load",scope:"global"},{comment:"/**\n* Reset the tech. Removes all sources and calls `load`.\n*\n* @method reset\n*/",meta:{range:[3652,3732],filename:"html5.js",lineno:638,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Reset the tech. Removes all sources and calls <code>load</code>.</p>",kind:"function",name:"reset",longname:"reset",scope:"global"},{comment:"/**\n* Get current source\n*\n* @return {Object}\n* @method currentSrc\n*/",meta:{range:[3745,3814],filename:"html5.js",lineno:647,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get current source</p>",returns:[{type:{names:["Object"]}}],kind:"function",name:"currentSrc",longname:"currentSrc",scope:"global"},{comment:"/**\n* Get poster\n*\n* @return {String}\n* @method poster\n*/",meta:{range:[3839,3896],filename:"html5.js",lineno:661,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get poster</p>",returns:[{type:{names:["String"]}}],kind:"function",name:"poster",longname:"poster",scope:"global"},{comment:"/**\n* Get preload attribute\n*\n* @return {String}\n* @method preload\n*/",meta:{range:[3983,4052],filename:"html5.js",lineno:677,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get preload attribute</p>",returns:[{type:{names:["String"]}}],kind:"function",name:"preload",longname:"preload",scope:"global"},{comment:"/**\n* Set preload attribute\n*\n* @param {String} val Value for preload attribute\n* @method setPreload\n*/",meta:{range:[4059,4162],filename:"html5.js",lineno:685,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Set preload attribute</p>",params:[{type:{names:["String"]},description:"<p>Value for preload attribute</p>",name:"val"}],kind:"function",name:"setPreload",longname:"setPreload",scope:"global"},{comment:"/**\n* Get autoplay attribute\n*\n* @return {String}\n* @method autoplay\n*/",meta:{range:[4169,4240],filename:"html5.js",lineno:693,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get autoplay attribute</p>",returns:[{type:{names:["String"]}}],kind:"function",name:"autoplay",longname:"autoplay",scope:"global"},{comment:"/**\n* Set autoplay attribute\n*\n* @param {String} val Value for preload attribute\n* @method setAutoplay\n*/",meta:{range:[4247,4352],filename:"html5.js",lineno:701,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Set autoplay attribute</p>",params:[{type:{names:["String"]},description:"<p>Value for preload attribute</p>",name:"val"}],kind:"function",name:"setAutoplay",longname:"setAutoplay",scope:"global"},{comment:"/**\n* Get controls attribute\n*\n* @return {String}\n* @method controls\n*/",meta:{range:[4359,4430],filename:"html5.js",lineno:709,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get controls attribute</p>",returns:[{type:{names:["String"]}}],kind:"function",name:"controls",longname:"controls",scope:"global"},{comment:"/**\n* Set controls attribute\n*\n* @param {String} val Value for controls attribute\n* @method setControls\n*/",meta:{range:[4437,4543],filename:"html5.js",lineno:717,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Set controls attribute</p>",params:[{type:{names:["String"]},description:"<p>Value for controls attribute</p>",name:"val"}],kind:"function",name:"setControls",longname:"setControls",scope:"global"},{comment:"/**\n* Get loop attribute\n*\n* @return {String}\n* @method loop\n*/",meta:{range:[4550,4613],filename:"html5.js",lineno:725,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get loop attribute</p>",returns:[{type:{names:["String"]}}],kind:"function",name:"loop",longname:"loop",scope:"global"},{comment:"/**\n* Set loop attribute\n*\n* @param {String} val Value for loop attribute\n* @method setLoop\n*/",meta:{range:[4620,4714],filename:"html5.js",lineno:733,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Set loop attribute</p>",params:[{type:{names:["String"]},description:"<p>Value for loop attribute</p>",name:"val"}],kind:"function",name:"setLoop",longname:"setLoop",scope:"global"},{comment:"/**\n* Get error value\n*\n* @return {String}\n* @method error\n*/",meta:{range:[4721,4782],filename:"html5.js",lineno:741,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get error value</p>",returns:[{type:{names:["String"]}}],kind:"function",name:"error",longname:"error",scope:"global"},{comment:'/**\n* Get whether or not the player is in the "seeking" state\n*\n* @return {Boolean}\n* @method seeking\n*/',meta:{range:[4789,4893],filename:"html5.js",lineno:749,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get whether or not the player is in the &quot;seeking&quot; state</p>",returns:[{type:{names:["Boolean"]}}],kind:"function",name:"seeking",longname:"seeking",scope:"global"},{comment:"/**\n* Get a TimeRanges object that represents the\n* ranges of the media resource to which it is possible\n* for the user agent to seek.\n*\n* @return {TimeRangeObject}\n* @method seekable\n*/",meta:{range:[4900,5086],filename:"html5.js",lineno:757,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get a TimeRanges object that represents the\nranges of the media resource to which it is possible\nfor the user agent to seek.</p>",returns:[{type:{names:["TimeRangeObject"]}}],kind:"function",name:"seekable",longname:"seekable",scope:"global"},{comment:"/**\n* Get if video ended\n*\n* @return {Boolean}\n* @method ended\n*/",meta:{range:[5093,5158],filename:"html5.js",lineno:767,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get if video ended</p>",returns:[{type:{names:["Boolean"]}}],kind:"function",name:"ended",longname:"ended",scope:"global"},{comment:"/**\n* Get the value of the muted content attribute\n* This attribute has no dynamic effect, it only\n* controls the default state of the element\n*\n* @return {Boolean}\n* @method defaultMuted\n*/",meta:{range:[5165,5355],filename:"html5.js",lineno:775,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get the value of the muted content attribute\nThis attribute has no dynamic effect, it only\ncontrols the default state of the element</p>",returns:[{type:{names:["Boolean"]}}],kind:"function",name:"defaultMuted",longname:"defaultMuted",scope:"global"},{comment:"/**\n* Get desired speed at which the media resource is to play\n*\n* @return {Number}\n* @method playbackRate\n*/",meta:{range:[5362,5471],filename:"html5.js",lineno:785,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get desired speed at which the media resource is to play</p>",returns:[{type:{names:["Number"]}}],kind:"function",name:"playbackRate",longname:"playbackRate",scope:"global"},{comment:"/**\n* Set desired speed at which the media resource is to play\n*\n* @param {Number} val Speed at which the media resource is to play\n* @method setPlaybackRate\n*/",meta:{range:[5807,5967],filename:"html5.js",lineno:802,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Set desired speed at which the media resource is to play</p>",params:[{type:{names:["Number"]},description:"<p>Speed at which the media resource is to play</p>",name:"val"}],kind:"function",name:"setPlaybackRate",longname:"setPlaybackRate",scope:"global"},{comment:"/**\n* Get the current state of network activity for the element, from\n* the list below\n* NETWORK_EMPTY (numeric value 0)\n* NETWORK_IDLE (numeric value 1)\n* NETWORK_LOADING (numeric value 2)\n* NETWORK_NO_SOURCE (numeric value 3)\n*\n* @return {Number}\n* @method networkState\n*/",meta:{range:[5974,6248],filename:"html5.js",lineno:810,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get the current state of network activity for the element, from\nthe list below\nNETWORK_EMPTY (numeric value 0)\nNETWORK_IDLE (numeric value 1)\nNETWORK_LOADING (numeric value 2)\nNETWORK_NO_SOURCE (numeric value 3)</p>",returns:[{type:{names:["Number"]}}],kind:"function",name:"networkState",longname:"networkState",scope:"global"},{comment:"/**\n* Get a value that expresses the current state of the element\n* with respect to rendering the current playback position, from\n* the codes in the list below\n* HAVE_NOTHING (numeric value 0)\n* HAVE_METADATA (numeric value 1)\n* HAVE_CURRENT_DATA (numeric value 2)\n* HAVE_FUTURE_DATA (numeric value 3)\n* HAVE_ENOUGH_DATA (numeric value 4)\n*\n* @return {Number}\n* @method readyState\n*/",meta:{range:[6255,6638],filename:"html5.js",lineno:823,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get a value that expresses the current state of the element\nwith respect to rendering the current playback position, from\nthe codes in the list below\nHAVE_NOTHING (numeric value 0)\nHAVE_METADATA (numeric value 1)\nHAVE_CURRENT_DATA (numeric value 2)\nHAVE_FUTURE_DATA (numeric value 3)\nHAVE_ENOUGH_DATA (numeric value 4)</p>",returns:[{type:{names:["Number"]}}],kind:"function",name:"readyState",longname:"readyState",scope:"global"},{comment:"/**\n* Get width of video\n*\n* @return {Number}\n* @method videoWidth\n*/",meta:{range:[6645,6714],filename:"html5.js",lineno:838,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get width of video</p>",returns:[{type:{names:["Number"]}}],kind:"function",name:"videoWidth",longname:"videoWidth",scope:"global"},{comment:"/**\n* Get height of video\n*\n* @return {Number}\n* @method videoHeight\n*/",meta:{range:[6721,6792],filename:"html5.js",lineno:846,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get height of video</p>",returns:[{type:{names:["Number"]}}],kind:"function",name:"videoHeight",longname:"videoHeight",scope:"global"},{comment:"/**\n* Get text tracks\n*\n* @return {TextTrackList}\n* @method textTracks\n*/",meta:{range:[6799,6872],filename:"html5.js",lineno:854,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get text tracks</p>",returns:[{type:{names:["TextTrackList"]}}],kind:"function",name:"textTracks",longname:"textTracks",scope:"global"},{comment:"/**\n* Creates and returns a text track object\n*\n* @param {String} kind Text track kind (subtitles, captions, descriptions\n*                                       chapters and metadata)\n* @param {String=} label Label to identify the text track\n* @param {String=} language Two letter language abbreviation\n* @return {TextTrackObject}\n* @method addTextTrack\n*/",meta:{range:[6885,7242],filename:"html5.js",lineno:864,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Creates and returns a text track object</p>",params:[{type:{names:["String"]},description:"<p>Text track kind (subtitles, captions, descriptions\n                                      chapters and metadata)</p>",name:"kind"},{type:{names:["String"]},optional:!0,description:"<p>Label to identify the text track</p>",name:"label"},{type:{names:["String"]},optional:!0,description:"<p>Two letter language abbreviation</p>",name:"language"}],returns:[{type:{names:["TextTrackObject"]}}],kind:"function",name:"addTextTrack",longname:"addTextTrack",scope:"global"},{comment:"/**\n* Creates a remote text track object and returns a html track element\n*\n* @param {Object} options The object should contain values for\n* kind, language, label and src (location of the WebVTT file)\n* @return {HTMLTrackElement}\n* @method addRemoteTextTrack\n*/",meta:{range:[7267,7528],filename:"html5.js",lineno:882,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Creates a remote text track object and returns a html track element</p>",params:[{type:{names:["Object"]},description:"<p>The object should contain values for\nkind, language, label and src (location of the WebVTT file)</p>",name:"options"}],returns:[{type:{names:["HTMLTrackElement"]}}],kind:"function",name:"addRemoteTextTrack",longname:"addRemoteTextTrack",scope:"global"},{comment:"/**\n* Remove remote text track from TextTrackList object\n*\n* @param {TextTrackObject} track Texttrack object to remove\n* @method removeRemoteTextTrack\n*/",meta:{range:[7634,7787],filename:"html5.js",lineno:925,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Remove remote text track from TextTrackList object</p>",params:[{type:{names:["TextTrackObject"]},description:"<p>Texttrack object to remove</p>",name:"track"}],kind:"function",name:"removeRemoteTextTrack",longname:"removeRemoteTextTrack",scope:"global"},{comment:"/**\n* @file loader.js\n*/",meta:{range:[0,24],filename:"loader.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},name:"tech/loader.js",kind:"file",description:"<p>loader.js</p>",preserveName:!0,longname:"tech/loader.js",scope:"global"},{comment:"/**\n* The Media Loader is the component that decides which playback technology to load\n* when the player is initialized.\n*\n* @param {Object} player  Main Player\n* @param {Object=} options Object of option names and values\n* @param {Function=} ready    Ready callback function\n* @extends Component\n* @class MediaLoader\n*/",meta:{range:[40,360],filename:"loader.js",lineno:9,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>The Media Loader is the component that decides which playback technology to load\nwhen the player is initialized.</p>",params:[{type:{names:["Object"]},description:"<p>Main Player</p>",name:"player"},{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"},{type:{names:["function"]},optional:!0,description:"<p>Ready callback function</p>",name:"ready"}],augments:["Component"],kind:"class",name:"MediaLoader",longname:"MediaLoader",scope:"global"},{comment:"/**\n* @file tech.js\n* Media Technology Controller - Base class for media playback\n* technology controllers like Flash and HTML5\n*/",meta:{range:[0,130],filename:"tech.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},name:"tech/tech.js",kind:"file",description:"<p>tech.js\nMedia Technology Controller - Base class for media playback\ntechnology controllers like Flash and HTML5</p>",preserveName:!0,longname:"tech/tech.js",scope:"global"},{comment:"/**\n* Base class for media (HTML5 Video, Flash) controllers\n*\n* @param {Object=} options Options object\n* @param {Function=} ready Ready callback function\n* @extends Component\n* @class Tech\n*/",meta:{range:[188,380],filename:"tech.js",lineno:25,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Base class for media (HTML5 Video, Flash) controllers</p>",params:[{type:{names:["Object"]},optional:!0,description:"<p>Options object</p>",name:"options"},{type:{names:["function"]},optional:!0,description:"<p>Ready callback function</p>",name:"ready"}],augments:["Component"],kind:"class",name:"Tech",longname:"Tech",scope:"global"},{comment:"/**\n* Turn on progress events\n*\n* @method manualProgressOn\n*/",meta:{range:[653,714],filename:"tech.js",lineno:84,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Turn on progress events</p>",kind:"function",name:"manualProgressOn",longname:"manualProgressOn",scope:"global"},{comment:"/**\n* Turn off progress events\n*\n* @method manualProgressOff\n*/",meta:{range:[742,805],filename:"tech.js",lineno:98,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Turn off progress events</p>",kind:"function",name:"manualProgressOff",longname:"manualProgressOff",scope:"global"},{comment:"/**\n* Track progress\n*\n* @method trackProgress\n*/",meta:{range:[827,876],filename:"tech.js",lineno:110,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Track progress</p>",kind:"function",name:"trackProgress",longname:"trackProgress",scope:"global"},{comment:"/**\n* Update duration\n*\n* @method onDurationChange\n*/",meta:{range:[934,987],filename:"tech.js",lineno:134,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Update duration</p>",kind:"function",name:"onDurationChange",longname:"onDurationChange",scope:"global"},{comment:"/**\n* Create and get TimeRange object for buffering\n*\n* @return {TimeRangeObject}\n* @method buffered\n*/",meta:{range:[1e3,1103],filename:"tech.js",lineno:143,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Create and get TimeRange object for buffering</p>",returns:[{type:{names:["TimeRangeObject"]}}],kind:"function",name:"buffered",longname:"buffered",scope:"global"},{comment:"/**\n* Get buffered percent\n*\n* @return {Number}\n* @method bufferedPercent\n*/",meta:{range:[1116,1192],filename:"tech.js",lineno:153,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get buffered percent</p>",returns:[{type:{names:["Number"]}}],kind:"function",name:"bufferedPercent",longname:"bufferedPercent",scope:"global"},{comment:"/**\n* Stops tracking progress by clearing progress interval\n*\n* @method stopTrackingProgress\n*/",meta:{range:[1205,1300],filename:"tech.js",lineno:163,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Stops tracking progress by clearing progress interval</p>",kind:"function",name:"stopTrackingProgress",longname:"stopTrackingProgress",scope:"global"},{comment:"/**\n* Set event listeners for on play and pause and tracking current time\n*\n* @method manualTimeUpdatesOn\n*/",meta:{range:[1397,1505],filename:"tech.js",lineno:173,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Set event listeners for on play and pause and tracking current time</p>",kind:"function",name:"manualTimeUpdatesOn",longname:"manualTimeUpdatesOn",scope:"global"},{comment:"/**\n* Remove event listeners for on play and pause and tracking current time\n*\n* @method manualTimeUpdatesOff\n*/",meta:{range:[1527,1639],filename:"tech.js",lineno:185,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Remove event listeners for on play and pause and tracking current time</p>",kind:"function",name:"manualTimeUpdatesOff",longname:"manualTimeUpdatesOff",scope:"global"},{comment:"/**\n* Tracks current time\n*\n* @method trackCurrentTime\n*/",meta:{range:[1661,1718],filename:"tech.js",lineno:197,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Tracks current time</p>",kind:"function",name:"trackCurrentTime",longname:"trackCurrentTime",scope:"global"},{comment:"/**\n* Turn off play progress tracking (when paused or dragging)\n*\n* @method stopTrackingCurrentTime\n*/",meta:{range:[1740,1842],filename:"tech.js",lineno:209,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Turn off play progress tracking (when paused or dragging)</p>",kind:"function",name:"stopTrackingCurrentTime",longname:"stopTrackingCurrentTime",scope:"global"},{comment:"/**\n* Turn off any manual progress or timeupdate tracking\n*\n* @method dispose\n*/",meta:{range:[1867,1947],filename:"tech.js",lineno:222,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Turn off any manual progress or timeupdate tracking</p>",kind:"function",name:"dispose",longname:"dispose",scope:"global"},{comment:"/**\n* clear out a track list, or multiple track lists\n*\n* Note: Techs without source handlers should call this between\n* sources for video & audio tracks, as usually you don't want\n* to use them between tracks and we have no automatic way to do\n* it for you\n*\n* @method clearTracks\n* @param {Array|String} types type(s) of track lists to empty\n*/",meta:{range:[1987,2333],filename:"tech.js",lineno:240,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>clear out a track list, or multiple track lists</p>\n<p>Note: Techs without source handlers should call this between\nsources for video &amp; audio tracks, as usually you don't want\nto use them between tracks and we have no automatic way to do\nit for you</p>",
kind:"function",name:"clearTracks",params:[{type:{names:["Array","String"]},description:"<p>type(s) of track lists to empty</p>",name:"types"}],longname:"clearTracks",scope:"global"},{comment:"/**\n* Reset the tech. Removes all sources and resets readyState.\n*\n* @method reset\n*/",meta:{range:[2382,2467],filename:"tech.js",lineno:267,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Reset the tech. Removes all sources and resets readyState.</p>",kind:"function",name:"reset",longname:"reset",scope:"global"},{comment:"/**\n* When invoked without an argument, returns a MediaError object\n* representing the current error state of the player or null if\n* there is no error. When invoked with an argument, set the current\n* error state of the player.\n* @param {MediaError=} err    Optional an error object\n* @return {MediaError}        the current error object or null\n* @method error\n*/",meta:{range:[2474,2839],filename:"tech.js",lineno:274,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>When invoked without an argument, returns a MediaError object\nrepresenting the current error state of the player or null if\nthere is no error. When invoked with an argument, set the current\nerror state of the player.</p>",params:[{type:{names:["MediaError"]},optional:!0,description:"<p>Optional an error object</p>",name:"err"}],returns:[{type:{names:["MediaError"]},description:"<p>the current error object or null</p>"}],kind:"function",name:"error",longname:"error",scope:"global"},{comment:"/**\n* Return the time ranges that have been played through for the\n* current source. This implementation is incomplete. It does not\n* track the played time ranges, only whether the source has played\n* at all or not.\n* @return {TimeRangeObject} a single time range if this video has\n* played or an empty set of ranges if not.\n* @method played\n*/",meta:{range:[2864,3208],filename:"tech.js",lineno:291,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Return the time ranges that have been played through for the\ncurrent source. This implementation is incomplete. It does not\ntrack the played time ranges, only whether the source has played\nat all or not.</p>",returns:[{type:{names:["TimeRangeObject"]},description:"<p>a single time range if this video has\nplayed or an empty set of ranges if not.</p>"}],kind:"function",name:"played",longname:"played",scope:"global"},{comment:"/**\n* Set current time\n*\n* @method setCurrentTime\n*/",meta:{range:[3230,3282],filename:"tech.js",lineno:307,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Set current time</p>",kind:"function",name:"setCurrentTime",longname:"setCurrentTime",scope:"global"},{comment:"/**\n* Initialize texttrack listeners\n*\n* @method initTextTrackListeners\n*/",meta:{range:[3298,3372],filename:"tech.js",lineno:317,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Initialize texttrack listeners</p>",kind:"function",name:"initTextTrackListeners",longname:"initTextTrackListeners",scope:"global"},{comment:"/**\n* Initialize audio and video track listeners\n*\n* @method initTrackListeners\n*/",meta:{range:[3430,3512],filename:"tech.js",lineno:341,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Initialize audio and video track listeners</p>",kind:"function",name:"initTrackListeners",longname:"initTrackListeners",scope:"global"},{comment:"/**\n* Emulate texttracks\n*\n* @method emulateTextTracks\n*/",meta:{range:[3573,3630],filename:"tech.js",lineno:366,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Emulate texttracks</p>",kind:"function",name:"emulateTextTracks",longname:"emulateTextTracks",scope:"global"},{comment:"/**\n* Get videotracks\n*\n* @returns {VideoTrackList}\n* @method videoTracks\n*/",meta:{range:[3769,3845],filename:"tech.js",lineno:417,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get videotracks</p>",returns:[{type:{names:["VideoTrackList"]}}],kind:"function",name:"videoTracks",longname:"videoTracks",scope:"global"},{comment:"/**\n* Get audiotracklist\n*\n* @returns {AudioTrackList}\n* @method audioTracks\n*/",meta:{range:[3861,3940],filename:"tech.js",lineno:428,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get audiotracklist</p>",returns:[{type:{names:["AudioTrackList"]}}],kind:"function",name:"audioTracks",longname:"audioTracks",scope:"global"},{comment:"/**\n* Get texttracks\n*\n* @returns {TextTrackList}\n* @method textTracks\n*/",meta:{range:[4040,4113],filename:"tech.js",lineno:445,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get texttracks</p>",returns:[{type:{names:["TextTrackList"]}}],kind:"function",name:"textTracks",longname:"textTracks",scope:"global"},{comment:"/**\n* Get remote texttracks\n*\n* @returns {TextTrackList}\n* @method remoteTextTracks\n*/",meta:{range:[4129,4215],filename:"tech.js",lineno:456,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get remote texttracks</p>",returns:[{type:{names:["TextTrackList"]}}],kind:"function",name:"remoteTextTracks",longname:"remoteTextTracks",scope:"global"},{comment:"/**\n* Get remote htmltrackelements\n*\n* @returns {HTMLTrackElementList}\n* @method remoteTextTrackEls\n*/",meta:{range:[4231,4333],filename:"tech.js",lineno:467,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Get remote htmltrackelements</p>",returns:[{type:{names:["HTMLTrackElementList"]}}],kind:"function",name:"remoteTextTrackEls",longname:"remoteTextTrackEls",scope:"global"},{comment:"/**\n* Creates and returns a remote text track object\n*\n* @param {String} kind Text track kind (subtitles, captions, descriptions\n*                                       chapters and metadata)\n* @param {String=} label Label to identify the text track\n* @param {String=} language Two letter language abbreviation\n* @return {TextTrackObject}\n* @method addTextTrack\n*/",meta:{range:[4349,4713],filename:"tech.js",lineno:478,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Creates and returns a remote text track object</p>",params:[{type:{names:["String"]},description:"<p>Text track kind (subtitles, captions, descriptions\n                                      chapters and metadata)</p>",name:"kind"},{type:{names:["String"]},optional:!0,description:"<p>Label to identify the text track</p>",name:"label"},{type:{names:["String"]},optional:!0,description:"<p>Two letter language abbreviation</p>",name:"language"}],returns:[{type:{names:["TextTrackObject"]}}],kind:"function",name:"addTextTrack",longname:"addTextTrack",scope:"global"},{comment:"/**\n* Creates a remote text track object and returns a emulated html track element\n*\n* @param {Object} options The object should contain values for\n* kind, language, label and src (location of the WebVTT file)\n* @return {HTMLTrackElement}\n* @method addRemoteTextTrack\n*/",meta:{range:[4738,5008],filename:"tech.js",lineno:496,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Creates a remote text track object and returns a emulated html track element</p>",params:[{type:{names:["Object"]},description:"<p>The object should contain values for\nkind, language, label and src (location of the WebVTT file)</p>",name:"options"}],returns:[{type:{names:["HTMLTrackElement"]}}],kind:"function",name:"addRemoteTextTrack",longname:"addRemoteTextTrack",scope:"global"},{comment:"/**\n* Remove remote texttrack\n*\n* @param {TextTrackObject} track Texttrack to remove\n* @method removeRemoteTextTrack\n*/",meta:{range:[5060,5179],filename:"tech.js",lineno:521,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Remove remote texttrack</p>",params:[{type:{names:["TextTrackObject"]},description:"<p>Texttrack to remove</p>",name:"track"}],kind:"function",name:"removeRemoteTextTrack",longname:"removeRemoteTextTrack",scope:"global"},{comment:"/**\n* Provide a default setPoster method for techs\n* Poster support for techs should be optional, so we don't want techs to\n* break if they don't have a way to set a poster.\n*\n* @method setPoster\n*/",meta:{range:[5210,5408],filename:"tech.js",lineno:537,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Provide a default setPoster method for techs\nPoster support for techs should be optional, so we don't want techs to\nbreak if they don't have a way to set a poster.</p>",kind:"function",name:"setPoster",longname:"setPoster",scope:"global"},{comment:"/**\n* Registers a Tech\n*\n* @param {String} name Name of the Tech to register\n* @param {Object} tech The tech to register\n* @static\n* @method registerComponent\n*/",meta:{range:[5942,6103],filename:"tech.js",lineno:572,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Registers a Tech</p>",params:[{type:{names:["String"]},description:"<p>Name of the Tech to register</p>",name:"name"},{type:{names:["Object"]},description:"<p>The tech to register</p>",name:"tech"}],scope:"static",kind:"function",name:"registerComponent",longname:"registerComponent"},{comment:"/**\n* Gets a component by name\n*\n* @param {String} name Name of the component to get\n* @return {Component}\n* @static\n* @method getComponent\n*/",meta:{range:[6143,6285],filename:"tech.js",lineno:593,path:"/Users/mboles/git/docs/video.js/src/js/tech",code:{}},description:"<p>Gets a component by name</p>",params:[{type:{names:["String"]},description:"<p>Name of the component to get</p>",name:"name"}],returns:[{type:{names:["Component"]}}],scope:"static",kind:"function",name:"getComponent",longname:"getComponent"},{comment:"/**\n* @file audio-track-list.js\n*/",meta:{range:[0,34],filename:"audio-track-list.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},name:"tracks/audio-track-list.js",kind:"file",description:"<p>audio-track-list.js</p>",preserveName:!0,longname:"tracks/audio-track-list.js",scope:"global"},{comment:"/**\n* A list of possible audio tracks. All functionality is in the\n* base class Tracklist and the spec for AudioTrackList is located at:\n* @link https://html.spec.whatwg.org/multipage/embedded-content.html#audiotracklist\n*\n* interface AudioTrackList : EventTarget {\n*   readonly attribute unsigned long length;\n*   getter AudioTrack (unsigned long index);\n*   AudioTrack? getTrackById(DOMString id);\n*\n*   attribute EventHandler onchange;\n*   attribute EventHandler onaddtrack;\n*   attribute EventHandler onremovetrack;\n* };\n*\n* @param {AudioTrack[]} tracks a list of audio tracks to instantiate the list with\n* @extends TrackList\n* @class AudioTrackList\n*/",meta:{range:[294,951],filename:"audio-track-list.js",lineno:24,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>A list of possible audio tracks. All functionality is in the\nbase class Tracklist and the spec for AudioTrackList is located at:</p>",tags:[{originalTitle:"link",title:"link",text:"https://html.spec.whatwg.org/multipage/embedded-content.html#audiotracklist\n\ninterface AudioTrackList : EventTarget {\n  readonly attribute unsigned long length;\n  getter AudioTrack (unsigned long index);\n  AudioTrack? getTrackById(DOMString id);\n\n  attribute EventHandler onchange;\n  attribute EventHandler onaddtrack;\n  attribute EventHandler onremovetrack;\n};",value:"https://html.spec.whatwg.org/multipage/embedded-content.html#audiotracklist\n\ninterface AudioTrackList : EventTarget {\n  readonly attribute unsigned long length;\n  getter AudioTrack (unsigned long index);\n  AudioTrack? getTrackById(DOMString id);\n\n  attribute EventHandler onchange;\n  attribute EventHandler onaddtrack;\n  attribute EventHandler onremovetrack;\n};"}],params:[{type:{names:["Array.<AudioTrack>"]},description:"<p>a list of audio tracks to instantiate the list with</p>",name:"tracks"}],augments:["TrackList"],kind:"class",name:"AudioTrackList",longname:"AudioTrackList",scope:"global"},{comment:"/**\n* A single audio text track as defined in:\n* @link https://html.spec.whatwg.org/multipage/embedded-content.html#audiotrack\n*\n* interface AudioTrack {\n*   readonly attribute DOMString id;\n*   readonly attribute DOMString kind;\n*   readonly attribute DOMString label;\n*   readonly attribute DOMString language;\n*   attribute boolean enabled;\n* };\n*\n* @param {Object=} options Object of option names and values\n* @class AudioTrack\n*/",meta:{range:[15,449],filename:"audio-track.js",lineno:6,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>A single audio text track as defined in:</p>",tags:[{originalTitle:"link",title:"link",text:"https://html.spec.whatwg.org/multipage/embedded-content.html#audiotrack\n\ninterface AudioTrack {\n  readonly attribute DOMString id;\n  readonly attribute DOMString kind;\n  readonly attribute DOMString label;\n  readonly attribute DOMString language;\n  attribute boolean enabled;\n};",value:"https://html.spec.whatwg.org/multipage/embedded-content.html#audiotrack\n\ninterface AudioTrack {\n  readonly attribute DOMString id;\n  readonly attribute DOMString kind;\n  readonly attribute DOMString label;\n  readonly attribute DOMString language;\n  attribute boolean enabled;\n};"}],params:[{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"}],kind:"class",name:"AudioTrack",longname:"AudioTrack",scope:"global"},{comment:"/**\n* @file html-track-element-list.js\n*/",meta:{range:[0,41],filename:"html-track-element-list.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},name:"tracks/html-track-element-list.js",kind:"file",description:"<p>html-track-element-list.js</p>",preserveName:!0,longname:"tracks/html-track-element-list.js",scope:"global"},{comment:"/**\n* @file html-track-element.js\n*/",meta:{range:[0,36],filename:"html-track-element.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},name:"tracks/html-track-element.js",kind:"file",description:"<p>html-track-element.js</p>",preserveName:!0,longname:"tracks/html-track-element.js",scope:"global"},{comment:"/**\n* https://html.spec.whatwg.org/multipage/embedded-content.html#htmltrackelement\n*\n* interface HTMLTrackElement : HTMLElement {\n*   attribute DOMString kind;\n*   attribute DOMString src;\n*   attribute DOMString srclang;\n*   attribute DOMString label;\n*   attribute boolean default;\n*\n*   const unsigned short NONE = 0;\n*   const unsigned short LOADING = 1;\n*   const unsigned short LOADED = 2;\n*   const unsigned short ERROR = 3;\n*   readonly attribute unsigned short readyState;\n*\n*   readonly attribute TextTrack track;\n* };\n*\n* @param {Object} options TextTrack configuration\n* @class HTMLTrackElement\n*/",meta:{range:[70,680],filename:"html-track-element.js",lineno:15,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>https://html.spec.whatwg.org/multipage/embedded-content.html#htmltrackelement</p>\n<p>interface HTMLTrackElement : HTMLElement {\n  attribute DOMString kind;\n  attribute DOMString src;\n  attribute DOMString srclang;\n  attribute DOMString label;\n  attribute boolean default;</p>\n<p>  const unsigned short NONE = 0;\n  const unsigned short LOADING = 1;\n  const unsigned short LOADED = 2;\n  const unsigned short ERROR = 3;\n  readonly attribute unsigned short readyState;</p>\n<p>  readonly attribute TextTrack track;\n};</p>",params:[{type:{names:["Object"]},description:"<p>TextTrack configuration</p>",name:"options"}],kind:"class",name:"HTMLTrackElement",longname:"HTMLTrackElement",scope:"global"},{comment:"/**\n* @file text-track-cue-list.js\n*/",meta:{range:[0,37],filename:"text-track-cue-list.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},name:"tracks/text-track-cue-list.js",kind:"file",description:"<p>text-track-cue-list.js</p>",preserveName:!0,longname:"tracks/text-track-cue-list.js",scope:"global"},{comment:"/**\n* A List of text track cues as defined in:\n* https://html.spec.whatwg.org/multipage/embedded-content.html#texttrackcuelist\n*\n* interface TextTrackCueList {\n*   readonly attribute unsigned long length;\n*   getter TextTrackCue (unsigned long index);\n*   TextTrackCue? getCueById(DOMString id);\n* };\n*\n* @param {Array} cues A list of cues to be initialized with\n* @class TextTrackCueList\n*/",meta:{range:[47,438],filename:"text-track-cue-list.js",lineno:7,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>A List of text track cues as defined in:\nhttps://html.spec.whatwg.org/multipage/embedded-content.html#texttrackcuelist</p>\n<p>interface TextTrackCueList {\n  readonly attribute unsigned long length;\n  getter TextTrackCue (unsigned long index);\n  TextTrackCue? getCueById(DOMString id);\n};</p>",params:[{type:{names:["Array"]},description:"<p>A list of cues to be initialized with</p>",name:"cues"}],kind:"class",name:"TextTrackCueList",longname:"TextTrackCueList",scope:"global"},{comment:"/**\n* A setter for cues in this list\n*\n* @param {Array} cues an array of cues\n* @method setCues_\n* @private\n*/",meta:{range:[523,633],filename:"text-track-cue-list.js",lineno:48,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>A setter for cues in this list</p>",params:[{type:{names:["Array"]},description:"<p>an array of cues</p>",name:"cues"}],kind:"function",name:"setCues_",access:"private",longname:"setCues_",scope:"global"},{comment:"/**\n* Get a cue that is currently in the Cue list by id\n*\n* @param {String} id\n* @method getCueById\n* @return {Object} a single cue\n*/",meta:{range:[715,849],filename:"text-track-cue-list.js",lineno:82,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Get a cue that is currently in the Cue list by id</p>",params:[{type:{names:["String"]},name:"id"}],kind:"function",name:"getCueById",returns:[{type:{names:["Object"]},description:"<p>a single cue</p>"}],longname:"getCueById",scope:"global"},{comment:"/**\n* @file text-track-display.js\n*/",meta:{range:[0,36],filename:"text-track-display.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},name:"tracks/text-track-display.js",kind:"file",description:"<p>text-track-display.js</p>",preserveName:!0,longname:"tracks/text-track-display.js",scope:"global"},{comment:"/**\n* The component for displaying text track cues\n*\n* @param {Object} player  Main Player\n* @param {Object=} options Object of option names and values\n* @param {Function=} ready    Ready callback function\n* @extends Component\n* @class TextTrackDisplay\n*/",meta:{range:[106,361],filename:"text-track-display.js",lineno:27,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>The component for displaying text track cues</p>",params:[{type:{names:["Object"]},description:"<p>Main Player</p>",name:"player"},{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"},{type:{names:["function"]},optional:!0,description:"<p>Ready callback function</p>",name:"ready"}],augments:["Component"],kind:"class",name:"TextTrackDisplay",longname:"TextTrackDisplay",scope:"global"},{comment:"/**\n* Toggle display texttracks\n*\n* @method toggleDisplay\n*/",meta:{range:[530,590],filename:"text-track-display.js",lineno:92,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Toggle display texttracks</p>",kind:"function",name:"toggleDisplay",longname:"toggleDisplay",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[615,699],filename:"text-track-display.js",lineno:105,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Clear display texttracks\n*\n* @method clearDisplay\n*/",meta:{range:[727,785],filename:"text-track-display.js",lineno:120,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Clear display texttracks</p>",kind:"function",name:"clearDisplay",longname:"clearDisplay",scope:"global"},{comment:"/**\n* Update display texttracks\n*\n* @method updateDisplay\n*/",meta:{range:[804,864],filename:"text-track-display.js",lineno:131,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Update display texttracks</p>",kind:"function",name:"updateDisplay",longname:"updateDisplay",scope:"global"},{comment:"/**\n* Add texttrack to texttrack list\n*\n* @param {TextTrackObject} track Texttrack object to be added to list\n* @method updateForTrack\n*/",meta:{range:[970,1107],filename:"text-track-display.js",lineno:171,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Add texttrack to texttrack list</p>",params:[{type:{names:["TextTrackObject"]},description:"<p>Texttrack object to be added to list</p>",name:"track"}],kind:"function",name:"updateForTrack",longname:"updateForTrack",scope:"global"},{comment:"/**\n* Add cue HTML to display\n*\n* @param {Number} color Hex number for color, like #f0e\n* @param {Number} opacity Value for opacity,0.0 - 1.0\n* @return {RGBAColor} In the form 'rgba(255, 0, 0, 0.3)'\n* @method constructColor\n*/",meta:{range:[1345,1571],filename:"text-track-display.js",lineno:256,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Add cue HTML to display</p>",params:[{type:{names:["Number"]},description:"<p>Hex number for color, like #f0e</p>",name:"color"},{type:{names:["Number"]},description:"<p>Value for opacity,0.0 - 1.0</p>",name:"opacity"}],returns:[{type:{names:["RGBAColor"]},description:"<p>In the form 'rgba(255, 0, 0, 0.3)'</p>"}],kind:"function",name:"constructColor",longname:"constructColor",scope:"global"},{comment:"/**\n* Try to update style\n* Some style changes will throw an error, particularly in IE8. Those should be noops.\n*\n* @param {Element} el The element to be styles\n* @param {CSSProperty} style The CSS property to be styled\n* @param {CSSStyle} rule The actual style to be applied to the property\n* @method tryUpdateStyle\n*/",meta:{range:[1599,1918],filename:"text-track-display.js",lineno:273,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Try to update style\nSome style changes will throw an error, particularly in IE8. Those should be noops.</p>",params:[{type:{names:["Element"]},description:"<p>The element to be styles</p>",name:"el"},{type:{names:["CSSProperty"]},description:"<p>The CSS property to be styled</p>",name:"style"},{type:{names:["CSSStyle"]},description:"<p>The actual style to be applied to the property</p>",name:"rule"}],kind:"function",name:"tryUpdateStyle",longname:"tryUpdateStyle",scope:"global"},{comment:"/**\n* Utilities for capturing text track state and re-creating tracks\n* based on a capture.\n*\n* @file text-track-list-converter.js\n*/",meta:{range:[0,133],filename:"text-track-list-converter.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>text-track-list-converter.js</p>",name:"tracks/text-track-list-converter.js",kind:"file",preserveName:!0,longname:"tracks/text-track-list-converter.js",scope:"global"},{comment:"/**\n* Examine a tech and return a JSON-compatible javascript array that\n* represents the state of all text tracks currently configured. The\n* return array is compatible with `jsonToTextTracks`.\n* @param tech {tech} the tech object to query\n* @return {Array} a serializable javascript representation of the\n* @function textTracksToJson\n*/",meta:{range:[467,804],filename:"text-track-list-converter.js",lineno:38,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Examine a tech and return a JSON-compatible javascript array that\nrepresents the state of all text tracks currently configured. The\nreturn array is compatible with <code>jsonToTextTracks</code>.</p>",params:[{type:{names:["tech"]},description:"<p>the tech object to query</p>",name:"tech"}],returns:[{type:{names:["Array"]},description:"<p>a serializable javascript representation of the</p>"}],kind:"function",name:"textTracksToJson",longname:"textTracksToJson",scope:"global"},{comment:"/**\n* Creates a set of remote text tracks on a tech based on an array of\n* javascript text track representations.\n* @param json {Array} an array of text track representation objects,\n* like those that would be produced by `textTracksToJson`\n* @param tech {tech} the tech to create text tracks on\n* @function jsonToTextTracks\n*/",meta:{range:[859,1186],filename:"text-track-list-converter.js",lineno:64,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Creates a set of remote text tracks on a tech based on an array of\njavascript text track representations.</p>",params:[{type:{names:["Array"]},description:"<p>an array of text track representation objects,\nlike those that would be produced by <code>textTracksToJson</code></p>",name:"json"},{type:{names:["tech"]},description:"<p>the tech to create text tracks on</p>",name:"tech"}],kind:"function",name:"jsonToTextTracks",longname:"jsonToTextTracks",scope:"global"},{comment:"/**\n* @file text-track-list.js\n*/",meta:{range:[0,33],filename:"text-track-list.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},name:"tracks/text-track-list.js",kind:"file",description:"<p>text-track-list.js</p>",preserveName:!0,longname:"tracks/text-track-list.js",scope:"global"},{comment:"/**\n* A list of possible text tracks. All functionality is in the\n* base class TrackList. The spec for TextTrackList is located at:\n* @link https://html.spec.whatwg.org/multipage/embedded-content.html#texttracklist\n*\n* interface TextTrackList : EventTarget {\n*   readonly attribute unsigned long length;\n*   getter TextTrack (unsigned long index);\n*   TextTrack? getTrackById(DOMString id);\n*\n*   attribute EventHandler onchange;\n*   attribute EventHandler onaddtrack;\n*   attribute EventHandler onremovetrack;\n* };\n*\n* @param {TextTrack[]} tracks A list of tracks to initialize the list with\n* @extends TrackList\n* @class TextTrackList\n*/",meta:{range:[49,688],filename:"text-track-list.js",lineno:9,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>A list of possible text tracks. All functionality is in the\nbase class TrackList. The spec for TextTrackList is located at:</p>",tags:[{originalTitle:"link",title:"link",text:"https://html.spec.whatwg.org/multipage/embedded-content.html#texttracklist\n\ninterface TextTrackList : EventTarget {\n  readonly attribute unsigned long length;\n  getter TextTrack (unsigned long index);\n  TextTrack? getTrackById(DOMString id);\n\n  attribute EventHandler onchange;\n  attribute EventHandler onaddtrack;\n  attribute EventHandler onremovetrack;\n};",value:"https://html.spec.whatwg.org/multipage/embedded-content.html#texttracklist\n\ninterface TextTrackList : EventTarget {\n  readonly attribute unsigned long length;\n  getter TextTrack (unsigned long index);\n  TextTrack? getTrackById(DOMString id);\n\n  attribute EventHandler onchange;\n  attribute EventHandler onaddtrack;\n  attribute EventHandler onremovetrack;\n};"}],params:[{type:{names:["Array.<TextTrack>"]},description:"<p>A list of tracks to initialize the list with</p>",name:"tracks"}],augments:["TrackList"],kind:"class",name:"TextTrackList",longname:"TextTrackList",scope:"global"},{comment:"/**\n* Remove TextTrack from TextTrackList\n* NOTE: Be mindful of what is passed in as it may be a HTMLTrackElement\n*\n* @param {TextTrack} rtrack\n* @method removeTrack_\n* @private\n*/",meta:{range:[782,962],filename:"text-track-list.js",lineno:59,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Remove TextTrack from TextTrackList\nNOTE: Be mindful of what is passed in as it may be a HTMLTrackElement</p>",params:[{type:{names:["TextTrack"]},name:"rtrack"}],kind:"function",name:"removeTrack_",access:"private",longname:"removeTrack_",scope:"global"},{comment:"/**\n* Get a TextTrack from TextTrackList by a tracks id\n*\n* @param {String} id - the id of the track to get\n* @method getTrackById\n* @return {TextTrack}\n* @private\n*/",meta:{range:[1041,1207],filename:"text-track-list.js",lineno:93,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Get a TextTrack from TextTrackList by a tracks id</p>",params:[{type:{names:["String"]},description:"<p>the id of the track to get</p>",name:"id"}],kind:"function",name:"getTrackById",returns:[{type:{names:["TextTrack"]}}],access:"private",longname:"getTrackById",scope:"global"},{comment:"/**\n* @file text-track-settings.js\n*/",meta:{range:[0,37],filename:"text-track-settings.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},name:"tracks/text-track-settings.js",kind:"file",description:"<p>text-track-settings.js</p>",preserveName:!0,longname:"tracks/text-track-settings.js",scope:"global"},{comment:"/**\n* Manipulate settings of texttracks\n*\n* @param {Object} player  Main Player\n* @param {Object=} options Object of option names and values\n* @extends Component\n* @class TextTrackSettings\n*/",meta:{range:[59,250],filename:"text-track-settings.js",lineno:11,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Manipulate settings of texttracks</p>",params:[{type:{names:["Object"]},description:"<p>Main Player</p>",name:"player"},{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"}],augments:["Component"],kind:"class",name:"TextTrackSettings",longname:"TextTrackSettings",scope:"global"},{comment:"/**\n* Create the component's DOM element\n*\n* @return {Element}\n* @method createEl\n*/",meta:{range:[383,467],filename:"text-track-settings.js",lineno:63,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Create the component's DOM element</p>",returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Get texttrack settings\n* Settings are\n* .vjs-edge-style\n* .vjs-font-family\n* .vjs-fg-color\n* .vjs-text-opacity\n* .vjs-bg-color\n* .vjs-bg-opacity\n* .window-color\n* .vjs-window-opacity\n*\n* @return {Object}\n* @method getValues\n*/",meta:{range:[516,748],filename:"text-track-settings.js",lineno:85,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Get texttrack settings\nSettings are\n.vjs-edge-style\n.vjs-font-family\n.vjs-fg-color\n.vjs-text-opacity\n.vjs-bg-color\n.vjs-bg-opacity\n.window-color\n.vjs-window-opacity</p>",returns:[{type:{names:["Object"]}}],kind:"function",name:"getValues",longname:"getValues",scope:"global"},{comment:"/**\n* Set texttrack settings\n* Settings are\n* .vjs-edge-style\n* .vjs-font-family\n* .vjs-fg-color\n* .vjs-text-opacity\n* .vjs-bg-color\n* .vjs-bg-opacity\n* .window-color\n* .vjs-window-opacity\n*\n* @param {Object} values Object with texttrack setting values\n* @method setValues\n*/",meta:{range:[839,1114],filename:"text-track-settings.js",lineno:130,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Set texttrack settings\nSettings are\n.vjs-edge-style\n.vjs-font-family\n.vjs-fg-color\n.vjs-text-opacity\n.vjs-bg-color\n.vjs-bg-opacity\n.window-color\n.vjs-window-opacity</p>",params:[{type:{names:["Object"]},description:"<p>Object with texttrack setting values</p>",name:"values"}],kind:"function",name:"setValues",longname:"setValues",scope:"global"},{comment:"/**\n* Restore texttrack settings\n*\n* @method restoreSettings\n*/",meta:{range:[1172,1235],filename:"text-track-settings.js",lineno:164,path:"/Users/mboles/git/docs/video.js/src/js/tracks",
code:{}},description:"<p>Restore texttrack settings</p>",kind:"function",name:"restoreSettings",longname:"restoreSettings",scope:"global"},{comment:"/**\n* Save texttrack settings to local storage\n*\n* @method saveSettings\n*/",meta:{range:[1290,1364],filename:"text-track-settings.js",lineno:187,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Save texttrack settings to local storage</p>",kind:"function",name:"saveSettings",longname:"saveSettings",scope:"global"},{comment:"/**\n* Update display of texttrack settings\n*\n* @method updateDisplay\n*/",meta:{range:[1416,1487],filename:"text-track-settings.js",lineno:209,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Update display of texttrack settings</p>",kind:"function",name:"updateDisplay",longname:"updateDisplay",scope:"global"},{comment:"/**\n* @file text-track.js\n*/",meta:{range:[0,28],filename:"text-track.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},name:"tracks/text-track.js",kind:"file",description:"<p>text-track.js</p>",preserveName:!0,longname:"tracks/text-track.js",scope:"global"},{comment:"/**\n* A single text track as defined in:\n* @link https://html.spec.whatwg.org/multipage/embedded-content.html#texttrack\n*\n* interface TextTrack : EventTarget {\n*   readonly attribute TextTrackKind kind;\n*   readonly attribute DOMString label;\n*   readonly attribute DOMString language;\n*\n*   readonly attribute DOMString id;\n*   readonly attribute DOMString inBandMetadataTrackDispatchType;\n*\n*   attribute TextTrackMode mode;\n*\n*   readonly attribute TextTrackCueList? cues;\n*   readonly attribute TextTrackCueList? activeCues;\n*\n*   void addCue(TextTrackCue cue);\n*   void removeCue(TextTrackCue cue);\n*\n*   attribute EventHandler oncuechange;\n* };\n*\n* @param {Object=} options Object of option names and values\n* @extends Track\n* @class TextTrack\n*/",meta:{range:[568,1320],filename:"text-track.js",lineno:99,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>A single text track as defined in:</p>",tags:[{originalTitle:"link",title:"link",text:"https://html.spec.whatwg.org/multipage/embedded-content.html#texttrack\n\ninterface TextTrack : EventTarget {\n  readonly attribute TextTrackKind kind;\n  readonly attribute DOMString label;\n  readonly attribute DOMString language;\n\n  readonly attribute DOMString id;\n  readonly attribute DOMString inBandMetadataTrackDispatchType;\n\n  attribute TextTrackMode mode;\n\n  readonly attribute TextTrackCueList? cues;\n  readonly attribute TextTrackCueList? activeCues;\n\n  void addCue(TextTrackCue cue);\n  void removeCue(TextTrackCue cue);\n\n  attribute EventHandler oncuechange;\n};",value:"https://html.spec.whatwg.org/multipage/embedded-content.html#texttrack\n\ninterface TextTrack : EventTarget {\n  readonly attribute TextTrackKind kind;\n  readonly attribute DOMString label;\n  readonly attribute DOMString language;\n\n  readonly attribute DOMString id;\n  readonly attribute DOMString inBandMetadataTrackDispatchType;\n\n  attribute TextTrackMode mode;\n\n  readonly attribute TextTrackCueList? cues;\n  readonly attribute TextTrackCueList? activeCues;\n\n  void addCue(TextTrackCue cue);\n  void removeCue(TextTrackCue cue);\n\n  attribute EventHandler oncuechange;\n};"}],params:[{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"}],augments:["Track"],kind:"class",name:"TextTrack",longname:"TextTrack",scope:"global"},{comment:"/**\n* add a cue to the internal list of cues\n*\n* @param {Object} cue the cue to add to our internal list\n* @method addCue\n*/",meta:{range:[1732,1856],filename:"text-track.js",lineno:263,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>add a cue to the internal list of cues</p>",params:[{type:{names:["Object"]},description:"<p>the cue to add to our internal list</p>",name:"cue"}],kind:"function",name:"addCue",longname:"addCue",scope:"global"},{comment:"/**\n* remvoe a cue from our internal list\n*\n* @param {Object} removeCue the cue to remove from our internal list\n* @method removeCue\n*/",meta:{range:[1902,2037],filename:"text-track.js",lineno:284,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>remvoe a cue from our internal list</p>",params:[{type:{names:["Object"]},description:"<p>the cue to remove from our internal list</p>",name:"removeCue"}],kind:"function",name:"removeCue",longname:"removeCue",scope:"global"},{comment:"/**\n* @file track-kinds.js\n*/",meta:{range:[0,29],filename:"track-enums.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},name:"tracks/track-enums.js",kind:"file",description:"<p>track-kinds.js</p>",preserveName:!0,longname:"tracks/track-enums.js",scope:"global"},{comment:"/**\n* @file track-list.js\n*/",meta:{range:[0,28],filename:"track-list.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},name:"tracks/track-list.js",kind:"file",description:"<p>track-list.js</p>",preserveName:!0,longname:"tracks/track-list.js",scope:"global"},{comment:"/**\n* Common functionaliy between Text, Audio, and Video TrackLists\n* Interfaces defined in the following spec:\n* @link https://html.spec.whatwg.org/multipage/embedded-content.html\n*\n* @param {Track[]} tracks A list of tracks to initialize the list with\n* @param {Object} list the child object with inheritance done manually for ie8\n* @extends EventTarget\n* @class TrackList\n*/",meta:{range:[44,421],filename:"track-list.js",lineno:9,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Common functionaliy between Text, Audio, and Video TrackLists\nInterfaces defined in the following spec:</p>",tags:[{originalTitle:"link",title:"link",text:"https://html.spec.whatwg.org/multipage/embedded-content.html",value:"https://html.spec.whatwg.org/multipage/embedded-content.html"}],params:[{type:{names:["Array.<Track>"]},description:"<p>A list of tracks to initialize the list with</p>",name:"tracks"},{type:{names:["Object"]},description:"<p>the child object with inheritance done manually for ie8</p>",name:"list"}],augments:["EventTarget"],kind:"class",name:"TrackList",longname:"TrackList",scope:"global"},{comment:"/**\n* Add a Track from TrackList\n*\n* @param {Mixed} track\n* @method addTrack_\n* @private\n*/",meta:{range:[509,600],filename:"track-list.js",lineno:48,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Add a Track from TrackList</p>",params:[{type:{names:["Mixed"]},name:"track"}],kind:"function",name:"addTrack_",access:"private",longname:"addTrack_",scope:"global"},{comment:"/**\n* Remove a Track from TrackList\n*\n* @param {Track} rtrack track to be removed\n* @method removeTrack_\n* @private\n*/",meta:{range:[664,782],filename:"track-list.js",lineno:76,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Remove a Track from TrackList</p>",params:[{type:{names:["Track"]},description:"<p>track to be removed</p>",name:"rtrack"}],kind:"function",name:"removeTrack_",access:"private",longname:"removeTrack_",scope:"global"},{comment:"/**\n* Get a Track from the TrackList by a tracks id\n*\n* @param {String} id - the id of the track to get\n* @method getTrackById\n* @return {Track}\n* @private\n*/",meta:{range:[861,1019],filename:"track-list.js",lineno:109,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>Get a Track from the TrackList by a tracks id</p>",params:[{type:{names:["String"]},description:"<p>the id of the track to get</p>",name:"id"}],kind:"function",name:"getTrackById",returns:[{type:{names:["Track"]}}],access:"private",longname:"getTrackById",scope:"global"},{comment:"/**\n* @file track.js\n*/",meta:{range:[0,23],filename:"track.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},name:"tracks/track.js",kind:"file",description:"<p>track.js</p>",preserveName:!0,longname:"tracks/track.js",scope:"global"},{comment:"/**\n* setup the common parts of an audio, video, or text track\n* @link https://html.spec.whatwg.org/multipage/embedded-content.html\n*\n* @param {String} type The type of track we are dealing with audio|video|text\n* @param {Object=} options Object of option names and values\n* @extends EventTarget\n* @class Track\n*/",meta:{range:[39,352],filename:"track.js",lineno:9,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>setup the common parts of an audio, video, or text track</p>",tags:[{originalTitle:"link",title:"link",text:"https://html.spec.whatwg.org/multipage/embedded-content.html",value:"https://html.spec.whatwg.org/multipage/embedded-content.html"}],params:[{type:{names:["String"]},description:"<p>The type of track we are dealing with audio|video|text</p>",name:"type"},{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"}],augments:["EventTarget"],kind:"class",name:"Track",longname:"Track",scope:"global"},{comment:"/**\n* @file video-track-list.js\n*/",meta:{range:[0,34],filename:"video-track-list.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},name:"tracks/video-track-list.js",kind:"file",description:"<p>video-track-list.js</p>",preserveName:!0,longname:"tracks/video-track-list.js",scope:"global"},{comment:"/**\n* A list of possiblee video tracks. Most functionality is in the\n* base class Tracklist and the spec for VideoTrackList is located at:\n* @link https://html.spec.whatwg.org/multipage/embedded-content.html#videotracklist\n*\n* interface VideoTrackList : EventTarget {\n*   readonly attribute unsigned long length;\n*   getter VideoTrack (unsigned long index);\n*   VideoTrack? getTrackById(DOMString id);\n*   readonly attribute long selectedIndex;\n*\n*   attribute EventHandler onchange;\n*   attribute EventHandler onaddtrack;\n*   attribute EventHandler onremovetrack;\n* };\n*\n* @param {VideoTrack[]} tracks a list of video tracks to instantiate the list with\n# @extends TrackList\n* @class VideoTrackList\n*/",meta:{range:[243,945],filename:"video-track-list.js",lineno:24,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>A list of possiblee video tracks. Most functionality is in the\nbase class Tracklist and the spec for VideoTrackList is located at:</p>",tags:[{originalTitle:"link",title:"link",text:"https://html.spec.whatwg.org/multipage/embedded-content.html#videotracklist\n\ninterface VideoTrackList : EventTarget {\n  readonly attribute unsigned long length;\n  getter VideoTrack (unsigned long index);\n  VideoTrack? getTrackById(DOMString id);\n  readonly attribute long selectedIndex;\n\n  attribute EventHandler onchange;\n  attribute EventHandler onaddtrack;\n  attribute EventHandler onremovetrack;\n};",value:"https://html.spec.whatwg.org/multipage/embedded-content.html#videotracklist\n\ninterface VideoTrackList : EventTarget {\n  readonly attribute unsigned long length;\n  getter VideoTrack (unsigned long index);\n  VideoTrack? getTrackById(DOMString id);\n  readonly attribute long selectedIndex;\n\n  attribute EventHandler onchange;\n  attribute EventHandler onaddtrack;\n  attribute EventHandler onremovetrack;\n};"}],params:[{type:{names:["Array.<VideoTrack>"]},description:"<p>a list of video tracks to instantiate the list with</p>\n<h1>@extends TrackList</h1>",name:"tracks"}],kind:"class",name:"VideoTrackList",longname:"VideoTrackList",scope:"global"},{comment:"/**\n* A single video text track as defined in:\n* @link https://html.spec.whatwg.org/multipage/embedded-content.html#videotrack\n*\n* interface VideoTrack {\n*   readonly attribute DOMString id;\n*   readonly attribute DOMString kind;\n*   readonly attribute DOMString label;\n*   readonly attribute DOMString language;\n*   attribute boolean selected;\n* };\n*\n* @param {Object=} options Object of option names and values\n* @class VideoTrack\n*/",meta:{range:[15,450],filename:"video-track.js",lineno:6,path:"/Users/mboles/git/docs/video.js/src/js/tracks",code:{}},description:"<p>A single video text track as defined in:</p>",tags:[{originalTitle:"link",title:"link",text:"https://html.spec.whatwg.org/multipage/embedded-content.html#videotrack\n\ninterface VideoTrack {\n  readonly attribute DOMString id;\n  readonly attribute DOMString kind;\n  readonly attribute DOMString label;\n  readonly attribute DOMString language;\n  attribute boolean selected;\n};",value:"https://html.spec.whatwg.org/multipage/embedded-content.html#videotrack\n\ninterface VideoTrack {\n  readonly attribute DOMString id;\n  readonly attribute DOMString kind;\n  readonly attribute DOMString label;\n  readonly attribute DOMString language;\n  attribute boolean selected;\n};"}],params:[{type:{names:["Object"]},optional:!0,description:"<p>Object of option names and values</p>",name:"options"}],kind:"class",name:"VideoTrack",longname:"VideoTrack",scope:"global"},{comment:"/**\n* @file browser.js\n*/",meta:{range:[0,25],filename:"browser.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},name:"utils/browser.js",kind:"file",description:"<p>browser.js</p>",preserveName:!0,longname:"utils/browser.js",scope:"global"},{comment:"/**\n* @file buffer.js\n*/",meta:{range:[0,24],filename:"buffer.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},name:"utils/buffer.js",kind:"file",description:"<p>buffer.js</p>",preserveName:!0,longname:"utils/buffer.js",scope:"global"},{comment:"/**\n* Compute how much your video has been buffered\n*\n* @param  {Object} Buffered object\n* @param  {Number} Total duration\n* @return {Number} Percent buffered of the total duration\n* @private\n* @function bufferedPercent\n*/",meta:{range:[31,253],filename:"buffer.js",lineno:6,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Compute how much your video has been buffered</p>",params:[{type:{names:["Object"]},description:"<p>object</p>",name:"Buffered"},{type:{names:["Number"]},description:"<p>duration</p>",name:"Total"}],returns:[{type:{names:["Number"]},description:"<p>Percent buffered of the total duration</p>"}],access:"private",kind:"function",name:"bufferedPercent",longname:"bufferedPercent",scope:"global"},{comment:"/**\n* @file dom.js\n*/",meta:{range:[0,21],filename:"dom.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},name:"utils/dom.js",kind:"file",description:"<p>dom.js</p>",preserveName:!0,longname:"utils/dom.js",scope:"global"},{comment:"/**\n* Creates functions to query the DOM using a given method.\n*\n* @function createQuerier\n* @private\n* @param  {String} method\n* @return {Function}\n*/",meta:{range:[508,659],filename:"dom.js",lineno:43,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Creates functions to query the DOM using a given method.</p>",kind:"function",name:"createQuerier",access:"private",params:[{type:{names:["String"]},name:"method"}],returns:[{type:{names:["function"]}}],longname:"createQuerier",scope:"global"},{comment:"/**\n* Shorthand for document.getElementById()\n* Also allows for CSS (jQuery) ID syntax. But nothing other than IDs.\n*\n* @param  {String} id  Element ID\n* @return {Element}    Element with supplied ID\n* @function getEl\n*/",meta:{range:[696,916],filename:"dom.js",lineno:63,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Shorthand for document.getElementById()\nAlso allows for CSS (jQuery) ID syntax. But nothing other than IDs.</p>",params:[{type:{names:["String"]},description:"<p>Element ID</p>",name:"id"}],returns:[{type:{names:["Element"]},description:"<p>Element with supplied ID</p>"}],kind:"function",name:"getEl",longname:"getEl",scope:"global"},{comment:"/**\n* Creates an element and applies properties.\n*\n* @param  {String} [tagName='div'] Name of tag to be created.\n* @param  {Object} [properties={}] Element properties to be applied.\n* @param  {Object} [attributes={}] Element attributes to be applied.\n* @return {Element}\n* @function createEl\n*/",meta:{range:[941,1235],filename:"dom.js",lineno:79,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Creates an element and applies properties.</p>",params:[{type:{names:["String"]},optional:!0,defaultvalue:"'div'",description:"<p>Name of tag to be created.</p>",name:"tagName"},{type:{names:["Object"]},optional:!0,defaultvalue:"{}",description:"<p>Element properties to be applied.</p>",name:"properties"},{type:{names:["Object"]},optional:!0,defaultvalue:"{}",description:"<p>Element attributes to be applied.</p>",name:"attributes"}],returns:[{type:{names:["Element"]}}],kind:"function",name:"createEl",longname:"createEl",scope:"global"},{comment:"/**\n* Injects text into an element, replacing any existing contents entirely.\n*\n* @param  {Element} el\n* @param  {String} text\n* @return {Element}\n* @function textContent\n*/",meta:{range:[1317,1490],filename:"dom.js",lineno:115,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Injects text into an element, replacing any existing contents entirely.</p>",params:[{type:{names:["Element"]},name:"el"},{type:{names:["String"]},name:"text"}],returns:[{type:{names:["Element"]}}],kind:"function",name:"textContent",longname:"textContent",scope:"global"},{comment:"/**\n* Insert an element as the first child node of another\n*\n* @param  {Element} child   Element to insert\n* @param  {Element} parent Element to insert child into\n* @private\n* @function insertElFirst\n*/",meta:{range:[1515,1717],filename:"dom.js",lineno:131,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Insert an element as the first child node of another</p>",params:[{type:{names:["Element"]},description:"<p>Element to insert</p>",name:"child"},{type:{names:["Element"]},description:"<p>Element to insert child into</p>",name:"parent"}],access:"private",kind:"function",name:"insertElFirst",longname:"insertElFirst",scope:"global"},{comment:"/**\n* Returns the cache object where data for an element is stored\n*\n* @param  {Element} el Element to store data for.\n* @return {Object}\n* @function getElData\n*/",meta:{range:[2114,2276],filename:"dom.js",lineno:166,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Returns the cache object where data for an element is stored</p>",params:[{type:{names:["Element"]},description:"<p>Element to store data for.</p>",name:"el"}],returns:[{type:{names:["Object"]}}],kind:"function",name:"getElData",longname:"getElData",scope:"global"},{comment:"/**\n* Returns whether or not an element has cached data\n*\n* @param  {Element} el A dom element\n* @return {Boolean}\n* @private\n* @function hasElData\n*/",meta:{range:[2319,2469],filename:"dom.js",lineno:187,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Returns whether or not an element has cached data</p>",params:[{type:{names:["Element"]},description:"<p>A dom element</p>",name:"el"}],returns:[{type:{names:["Boolean"]}}],access:"private",kind:"function",name:"hasElData",longname:"hasElData",scope:"global"},{comment:"/**\n* Delete data for the element from the cache and the guid attr from getElementById\n*\n* @param  {Element} el Remove data for an element\n* @private\n* @function removeElData\n*/",meta:{range:[2500,2677],filename:"dom.js",lineno:205,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Delete data for the element from the cache and the guid attr from getElementById</p>",params:[{type:{names:["Element"]},description:"<p>Remove data for an element</p>",name:"el"}],access:"private",kind:"function",name:"removeElData",longname:"removeElData",scope:"global"},{comment:"/**\n* Check if an element has a CSS class\n*\n* @function hasElClass\n* @param {Element} element Element to check\n* @param {String} classToCheck Classname to check\n*/",meta:{range:[2747,2910],filename:"dom.js",lineno:235,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Check if an element has a CSS class</p>",kind:"function",name:"hasElClass",params:[{type:{names:["Element"]},description:"<p>Element to check</p>",name:"element"},{type:{names:["String"]},description:"<p>Classname to check</p>",name:"classToCheck"}],longname:"hasElClass",scope:"global"},{comment:"/**\n* Add a CSS class name to an element\n*\n* @function addElClass\n* @param {Element} element    Element to add class name to\n* @param {String} classToAdd Classname to add\n*/",meta:{range:[2938,3111],filename:"dom.js",lineno:251,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Add a CSS class name to an element</p>",kind:"function",name:"addElClass",params:[{type:{names:["Element"]},description:"<p>Element to add class name to</p>",name:"element"},{type:{names:["String"]},description:"<p>Classname to add</p>",name:"classToAdd"}],longname:"addElClass",scope:"global"},{comment:"/**\n* Remove a CSS class name from an element\n*\n* @function removeElClass\n* @param {Element} element    Element to remove from class name\n* @param {String} classToRemove Classname to remove\n*/",meta:{range:[3151,3343],filename:"dom.js",lineno:271,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Remove a CSS class name from an element</p>",kind:"function",name:"removeElClass",params:[{type:{names:["Element"]},description:"<p>Element to remove from class name</p>",name:"element"},{type:{names:["String"]},description:"<p>Classname to remove</p>",name:"classToRemove"}],longname:"removeElClass",scope:"global"},{comment:"/**\n* Adds or removes a CSS class name on an element depending on an optional\n* condition or the presence/absence of the class name.\n*\n* @function toggleElClass\n* @param    {Element} element\n* @param    {String} classToToggle\n* @param    {Boolean|Function} [predicate]\n*           Can be a function that returns a Boolean. If `true`, the class\n*           will be added; if `false`, the class will be removed. If not\n*           given, the class will be added if not present and vice versa.\n*/",meta:{range:[3383,3876],filename:"dom.js",lineno:291,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Adds or removes a CSS class name on an element depending on an optional\ncondition or the presence/absence of the class name.</p>",kind:"function",name:"toggleElClass",params:[{type:{names:["Element"]},name:"element"},{type:{names:["String"]},name:"classToToggle"},{type:{names:["Boolean","function"]},optional:!0,description:"<p>Can be a function that returns a Boolean. If <code>true</code>, the class\n          will be added; if <code>false</code>, the class will be removed. If not\n          given, the class will be added if not present and vice versa.</p>",name:"predicate"}],longname:"toggleElClass",scope:"global"},{comment:"/**\n* Apply attributes to an HTML element.\n*\n* @param  {Element} el         Target element.\n* @param  {Object=} attributes Element attributes to be applied.\n* @private\n* @function setElAttributes\n*/",meta:{range:[3967,4165],filename:"dom.js",lineno:333,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Apply attributes to an HTML element.</p>",params:[{type:{names:["Element"]},description:"<p>Target element.</p>",name:"el"},{type:{names:["Object"]},optional:!0,description:"<p>Element attributes to be applied.</p>",name:"attributes"}],access:"private",kind:"function",name:"setElAttributes",longname:"setElAttributes",scope:"global"},{comment:"/**\n* Get an element's attribute values, as defined on the HTML tag\n* Attributes are not the same as properties. They're defined on the tag\n* or with setAttribute (which shouldn't be used with HTML)\n* This will return true or false for boolean attributes.\n*\n* @param  {Element} tag Element from which to get tag attributes\n* @return {Object}\n* @private\n* @function getElAttributes\n*/",meta:{range:[4202,4585],filename:"dom.js",lineno:353,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Get an element's attribute values, as defined on the HTML tag\nAttributes are not the same as properties. They're defined on the tag\nor with setAttribute (which shouldn't be used with HTML)\nThis will return true or false for boolean attributes.</p>",params:[{type:{names:["Element"]},description:"<p>Element from which to get tag attributes</p>",name:"tag"}],returns:[{type:{names:["Object"]}}],access:"private",kind:"function",name:"getElAttributes",longname:"getElAttributes",scope:"global"},{comment:"/**\n* Attempt to block the ability to select text while dragging controls\n*\n* @return {Boolean}\n* @function blockTextSelection\n*/",meta:{range:[4685,4814],filename:"dom.js",lineno:397,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Attempt to block the ability to select text while dragging controls</p>",returns:[{type:{names:["Boolean"]}}],kind:"function",name:"blockTextSelection",longname:"blockTextSelection",scope:"global"},{comment:"/**\n* Turn off text selection blocking\n*\n* @return {Boolean}\n* @function unblockTextSelection\n*/",meta:{range:[4836,4932],filename:"dom.js",lineno:410,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Turn off text selection blocking</p>",returns:[{type:{names:["Boolean"]}}],kind:"function",name:"unblockTextSelection",longname:"unblockTextSelection",scope:"global"},{comment:"/**\n* Offset Left\n* getBoundingClientRect technique from\n* John Resig http://ejohn.org/blog/getboundingclientrect-is-awesome/\n*\n* @function findElPosition\n* @param {Element} el Element from which to get offset\n* @return {Object}\n*/",meta:{range:[4951,5182],filename:"dom.js",lineno:422,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Offset Left\ngetBoundingClientRect technique from\nJohn Resig http://ejohn.org/blog/getboundingclientrect-is-awesome/</p>",kind:"function",name:"findElPosition",params:[{type:{names:["Element"]},description:"<p>Element from which to get offset</p>",name:"el"}],returns:[{type:{names:["Object"]}}],longname:"findElPosition",scope:"global"},{comment:"/**\n* Get pointer position in element\n* Returns an object with x and y coordinates.\n* The base on the coordinates are the bottom left of the element.\n*\n* @function getPointerPosition\n* @param {Element} el Element on which to get the pointer position on\n* @param {Event} event Event object\n* @return {Object} This object will have x and y coordinates corresponding to the mouse position\n*/",meta:{range:[5279,5667],filename:"dom.js",lineno:463,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Get pointer position in element\nReturns an object with x and y coordinates.\nThe base on the coordinates are the bottom left of the element.</p>",kind:"function",name:"getPointerPosition",params:[{type:{names:["Element"]},description:"<p>Element on which to get the pointer position on</p>",name:"el"},{type:{names:["Event"]},description:"<p>Event object</p>",name:"event"}],returns:[{type:{names:["Object"]},description:"<p>This object will have x and y coordinates corresponding to the mouse position</p>"}],longname:"getPointerPosition",scope:"global"},{comment:"/**\n* Determines, via duck typing, whether or not a value is a DOM element.\n*\n* @function isEl\n* @param    {Mixed} value\n* @return   {Boolean}\n*/",meta:{range:[5734,5879],filename:"dom.js",lineno:495,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Determines, via duck typing, whether or not a value is a DOM element.</p>",kind:"function",name:"isEl",params:[{type:{names:["Mixed"]},name:"value"}],returns:[{type:{names:["Boolean"]}}],longname:"isEl",scope:"global"},{comment:"/**\n* Empties the contents of an element.\n*\n* @function emptyEl\n* @param    {Element} el\n* @return   {Element}\n*/",meta:{range:[6027,6140],filename:"dom.js",lineno:516,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Empties the contents of an element.</p>",kind:"function",name:"emptyEl",params:[{type:{names:["Element"]},name:"el"}],returns:[{type:{names:["Element"]}}],longname:"emptyEl",scope:"global"},{comment:"/**\n* Normalizes content for eventual insertion into the DOM.\n*\n* This allows a wide range of content definition methods, but protects\n* from falling into the trap of simply writing to `innerHTML`, which is\n* an XSS concern.\n*\n* The content for an element can be passed in multiple types and\n* combinations, whose behavior is as follows:\n*\n* - String\n*   Normalized into a text node.\n*\n* - Element, TextNode\n*   Passed through.\n*\n* - Array\n*   A one-dimensional array of strings, elements, nodes, or functions (which\n*   return single strings, elements, or nodes).\n*\n* - Function\n*   If the sole argument, is expected to produce a string, element,\n*   node, or array.\n*\n* @function normalizeContent\n* @param    {String|Element|TextNode|Array|Function} content\n* @return   {Array}\n*/",meta:{range:[6162,6944],filename:"dom.js",lineno:530,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Normalizes content for eventual insertion into the DOM.</p>\n<p>This allows a wide range of content definition methods, but protects\nfrom falling into the trap of simply writing to <code>innerHTML</code>, which is\nan XSS concern.</p>\n<p>The content for an element can be passed in multiple types and\ncombinations, whose behavior is as follows:</p>\n<ul>\n<li><p>String\nNormalized into a text node.</p>\n</li>\n<li><p>Element, TextNode\nPassed through.</p>\n</li>\n<li><p>Array\nA one-dimensional array of strings, elements, nodes, or functions (which\nreturn single strings, elements, or nodes).</p>\n</li>\n<li><p>Function\nIf the sole argument, is expected to produce a string, element,\nnode, or array.</p>\n</li>\n</ul>",kind:"function",name:"normalizeContent",params:[{type:{names:["String","Element","TextNode","Array","function"]},name:"content"}],returns:[{type:{names:["Array"]}}],longname:"normalizeContent",scope:"global"},{comment:"/**\n* Normalizes and appends content to an element.\n*\n* @function appendContent\n* @param    {Element} el\n* @param    {String|Element|TextNode|Array|Function} content\n*           See: `normalizeContent`\n* @return   {Element}\n*/",meta:{range:[7029,7255],filename:"dom.js",lineno:586,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Normalizes and appends content to an element.</p>",kind:"function",name:"appendContent",params:[{type:{names:["Element"]},name:"el"},{type:{names:["String","Element","TextNode","Array","function"]},description:"<p>See: <code>normalizeContent</code></p>",name:"content"}],returns:[{type:{names:["Element"]}}],longname:"appendContent",scope:"global"},{comment:"/**\n* Normalizes and inserts content into an element; this is identical to\n* `appendContent()`, except it empties the element first.\n*\n* @function insertContent\n* @param    {Element} el\n* @param    {String|Element|TextNode|Array|Function} content\n*           See: `normalizeContent`\n* @return   {Element}\n*/",meta:{range:[7271,7578],filename:"dom.js",lineno:600,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Normalizes and inserts content into an element; this is identical to\n<code>appendContent()</code>, except it empties the element first.</p>",kind:"function",name:"insertContent",params:[{type:{names:["Element"]},name:"el"},{type:{names:["String","Element","TextNode","Array","function"]},description:"<p>See: <code>normalizeContent</code></p>",name:"content"}],returns:[{type:{names:["Element"]}}],longname:"insertContent",scope:"global"},{comment:"/**\n* Finds a single DOM element matching `selector` within the optional\n* `context` of another DOM element (defaulting to `document`).\n*\n* @function $\n* @param    {String} selector\n*           A valid CSS selector, which will be passed to `querySelector`.\n*\n* @param    {Element|String} [context=document]\n*           A DOM element within which to query. Can also be a selector\n*           string in which case the first matching element will be used\n*           as context. If missing (or no element matches selector), falls\n*           back to `document`.\n*\n* @return   {Element|null}\n*/",
meta:{range:[7591,8181],filename:"dom.js",lineno:614,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Finds a single DOM element matching <code>selector</code> within the optional\n<code>context</code> of another DOM element (defaulting to <code>document</code>).</p>",kind:"function",name:"$",params:[{type:{names:["String"]},description:"<p>A valid CSS selector, which will be passed to <code>querySelector</code>.</p>",name:"selector"},{type:{names:["Element","String"]},optional:!0,defaultvalue:"document",description:"<p>A DOM element within which to query. Can also be a selector\n          string in which case the first matching element will be used\n          as context. If missing (or no element matches selector), falls\n          back to <code>document</code>.</p>",name:"context"}],returns:[{type:{names:["Element","null"]}}],longname:"$",scope:"global"},{comment:"/**\n* Finds a all DOM elements matching `selector` within the optional\n* `context` of another DOM element (defaulting to `document`).\n*\n* @function $$\n* @param    {String} selector\n*           A valid CSS selector, which will be passed to `querySelectorAll`.\n*\n* @param    {Element|String} [context=document]\n*           A DOM element within which to query. Can also be a selector\n*           string in which case the first matching element will be used\n*           as context. If missing (or no element matches selector), falls\n*           back to `document`.\n*\n* @return   {NodeList}\n*/",meta:{range:[8188,8776],filename:"dom.js",lineno:632,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Finds a all DOM elements matching <code>selector</code> within the optional\n<code>context</code> of another DOM element (defaulting to <code>document</code>).</p>",kind:"function",name:"$$",params:[{type:{names:["String"]},description:"<p>A valid CSS selector, which will be passed to <code>querySelectorAll</code>.</p>",name:"selector"},{type:{names:["Element","String"]},optional:!0,defaultvalue:"document",description:"<p>A DOM element within which to query. Can also be a selector\n          string in which case the first matching element will be used\n          as context. If missing (or no element matches selector), falls\n          back to <code>document</code>.</p>",name:"context"}],returns:[{type:{names:["NodeList"]}}],longname:"$$",scope:"global"},{comment:"/**\n* @file events.js\n*\n* Event System (John Resig - Secrets of a JS Ninja http://jsninja.com/)\n* (Original book version wasn't completely usable, so fixed some things and made Closure Compiler compatible)\n* This should work very similarly to jQuery's events, however it's based off the book version which isn't as\n* robust as jquery's, so there's probably some differences.\n*/",meta:{range:[0,377],filename:"events.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},name:"utils/events.js",kind:"file",description:"<p>events.js</p>\n<p>Event System (John Resig - Secrets of a JS Ninja http://jsninja.com/)\n(Original book version wasn't completely usable, so fixed some things and made Closure Compiler compatible)\nThis should work very similarly to jQuery's events, however it's based off the book version which isn't as\nrobust as jquery's, so there's probably some differences.</p>",preserveName:!0,longname:"utils/events.js",scope:"global"},{comment:"/**\n* Add an event listener to element\n* It stores the handler function in a separate cache object\n* and adds a generic handler to the element's event,\n* along with a unique id (guid) to the element.\n*\n* @param  {Element|Object}   elem Element or object to bind listeners to\n* @param  {String|Array}   type Type of event to bind to.\n* @param  {Function} fn   Event listener.\n* @method on\n*/",meta:{range:[399,789],filename:"events.js",lineno:16,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Add an event listener to element\nIt stores the handler function in a separate cache object\nand adds a generic handler to the element's event,\nalong with a unique id (guid) to the element.</p>",params:[{type:{names:["Element","Object"]},description:"<p>Element or object to bind listeners to</p>",name:"elem"},{type:{names:["String","Array"]},description:"<p>Type of event to bind to.</p>",name:"type"},{type:{names:["function"]},description:"<p>Event listener.</p>",name:"fn"}],kind:"function",name:"on",longname:"on",scope:"global"},{comment:"/**\n* Removes event listeners from an element\n*\n* @param  {Element|Object}   elem Object to remove listeners from\n* @param  {String|Array=}   type Type of listener to remove. Don't include to remove all events from element.\n* @param  {Function} fn   Specific listener to remove. Don't include to remove listeners for an event type.\n* @method off\n*/",meta:{range:[952,1300],filename:"events.js",lineno:81,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Removes event listeners from an element</p>",params:[{type:{names:["Element","Object"]},description:"<p>Object to remove listeners from</p>",name:"elem"},{type:{names:["String","Array"]},description:"<p>Type of listener to remove. Don't include to remove all events from element.</p>",name:"type"},{type:{names:["function"]},description:"<p>Specific listener to remove. Don't include to remove listeners for an event type.</p>",name:"fn"}],kind:"function",name:"off",longname:"off",scope:"global"},{comment:"/**\n* Trigger an event for an element\n*\n* @param  {Element|Object}      elem  Element to trigger an event on\n* @param  {Event|Object|String} event A string (the type) or an event object with a type attribute\n* @param  {Object} [hash] data hash to pass along with the event\n* @return {Boolean=} Returned only if default was prevented\n* @method trigger\n*/",meta:{range:[1445,1798],filename:"events.js",lineno:137,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Trigger an event for an element</p>",params:[{type:{names:["Element","Object"]},description:"<p>Element to trigger an event on</p>",name:"elem"},{type:{names:["Event","Object","String"]},description:"<p>A string (the type) or an event object with a type attribute</p>",name:"event"},{type:{names:["Object"]},optional:!0,description:"<p>data hash to pass along with the event</p>",name:"hash"}],returns:[{type:{names:["Boolean"]},optional:!0,description:"<p>Returned only if default was prevented</p>"}],kind:"function",name:"trigger",longname:"trigger",scope:"global"},{comment:"/**\n* Trigger a listener only once for an event\n*\n* @param  {Element|Object}   elem Element or object to\n* @param  {String|Array}   type Name/type of event\n* @param  {Function} fn Event handler function\n* @method one\n*/",meta:{range:[1940,2159],filename:"events.js",lineno:193,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Trigger a listener only once for an event</p>",params:[{type:{names:["Element","Object"]},description:"<p>Element or object to</p>",name:"elem"},{type:{names:["String","Array"]},description:"<p>Name/type of event</p>",name:"type"},{type:{names:["function"]},description:"<p>Event handler function</p>",name:"fn"}],kind:"function",name:"one",longname:"one",scope:"global"},{comment:"/**\n* Fix a native event to have standard property values\n*\n* @param  {Object} event Event object to fix\n* @return {Object}\n* @private\n* @method fixEvent\n*/",meta:{range:[2199,2355],filename:"events.js",lineno:214,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Fix a native event to have standard property values</p>",params:[{type:{names:["Object"]},description:"<p>Event object to fix</p>",name:"event"}],returns:[{type:{names:["Object"]}}],access:"private",kind:"function",name:"fixEvent",longname:"fixEvent",scope:"global"},{comment:"/**\n* Clean up the listener cache and dispatchers\n*\n* @param  {Element|Object} elem Element to clean up\n* @param  {String} type Type of event to clean up\n* @private\n* @method _cleanUpEvents\n*/",meta:{range:[2680,2872],filename:"events.js",lineno:330,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Clean up the listener cache and dispatchers</p>",params:[{type:{names:["Element","Object"]},description:"<p>Element to clean up</p>",name:"elem"},{type:{names:["String"]},description:"<p>Type of event to clean up</p>",name:"type"}],access:"private",kind:"function",name:"_cleanUpEvents",longname:"_cleanUpEvents",scope:"global"},{comment:"/**\n* Loops through an array of event types and calls the requested method for each type.\n*\n* @param  {Function} fn   The event method we want to use.\n* @param  {Element|Object} elem Element or object to bind listeners to\n* @param  {String}   type Type of event to bind to.\n* @param  {Function} callback   Event listener.\n* @private\n* @function _handleMultipleEvents\n*/",meta:{range:[2963,3332],filename:"events.js",lineno:368,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Loops through an array of event types and calls the requested method for each type.</p>",params:[{type:{names:["function"]},description:"<p>The event method we want to use.</p>",name:"fn"},{type:{names:["Element","Object"]},description:"<p>Element or object to bind listeners to</p>",name:"elem"},{type:{names:["String"]},description:"<p>Type of event to bind to.</p>",name:"type"},{type:{names:["function"]},description:"<p>Event listener.</p>",name:"callback"}],access:"private",kind:"function",name:"_handleMultipleEvents",longname:"_handleMultipleEvents",scope:"global"},{comment:"/**\n* @file fn.js\n*/",meta:{range:[0,20],filename:"fn.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},name:"utils/fn.js",kind:"file",description:"<p>fn.js</p>",preserveName:!0,longname:"utils/fn.js",scope:"global"},{comment:"/**\n* Bind (a.k.a proxy or Context). A simple method for changing the context of a function\n* It also stores a unique id on the function so it can be easily removed from events\n*\n* @param  {*}   context The object to bind as scope\n* @param  {Function} fn      The function to be bound to a scope\n* @param  {Number=}   uid     An optional unique ID for the function to be set\n* @return {Function}\n* @private\n* @method bind\n*/",meta:{range:[27,451],filename:"fn.js",lineno:6,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Bind (a.k.a proxy or Context). A simple method for changing the context of a function\nIt also stores a unique id on the function so it can be easily removed from events</p>",params:[{type:{names:["*"]},description:"<p>The object to bind as scope</p>",name:"context"},{type:{names:["function"]},description:"<p>The function to be bound to a scope</p>",name:"fn"},{type:{names:["Number"]},optional:!0,description:"<p>An optional unique ID for the function to be set</p>",name:"uid"}],returns:[{type:{names:["function"]}}],access:"private",kind:"function",name:"bind",longname:"bind",scope:"global"},{comment:"/**\n* @file format-time.js\n*\n* Format seconds as a time string, H:MM:SS or M:SS\n* Supplying a guide (in seconds) will force a number of leading zeros\n* to cover the length of the guide\n*\n* @param  {Number} seconds Number of seconds to be turned into a string\n* @param  {Number} guide   Number (in seconds) to model the string after\n* @return {String}         Time formatted as H:MM:SS or M:SS\n* @private\n* @function formatTime\n*/",meta:{range:[0,429],filename:"format-time.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},name:"formatTime",kind:"function",description:"<p>format-time.js</p>\n<p>Format seconds as a time string, H:MM:SS or M:SS\nSupplying a guide (in seconds) will force a number of leading zeros\nto cover the length of the guide</p>",preserveName:!0,params:[{type:{names:["Number"]},description:"<p>Number of seconds to be turned into a string</p>",name:"seconds"},{type:{names:["Number"]},description:"<p>Number (in seconds) to model the string after</p>",name:"guide"}],returns:[{type:{names:["String"]},description:"<p>Time formatted as H:MM:SS or M:SS</p>"}],access:"private",longname:"formatTime",scope:"global"},{comment:"/**\n* @file guid.js\n*\n* Unique ID for an element or function\n* @type {Number}\n* @private\n*/",meta:{range:[0,91],filename:"guid.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},name:"utils/guid.js",kind:"file",description:"<p>guid.js</p>\n<p>Unique ID for an element or function</p>",preserveName:!0,type:{names:["Number"]},access:"private",longname:"utils/guid.js",scope:"global"},{comment:"/**\n* Get the next unique ID\n*\n* @return {String} \n* @function newGUID\n*/",meta:{range:[98,171],filename:"guid.js",lineno:10,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Get the next unique ID</p>",returns:[{type:{names:["String"]}}],kind:"function",name:"newGUID",longname:"newGUID",scope:"global"},{comment:"/**\n* @file log.js\n*/",meta:{range:[0,21],filename:"log.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},name:"utils/log.js",kind:"file",description:"<p>log.js</p>",preserveName:!0,longname:"utils/log.js",scope:"global"},{comment:"/**\n* Log plain debug messages\n*\n* @function log\n*/",meta:{range:[600,651],filename:"log.js",lineno:66,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Log plain debug messages</p>",kind:"function",name:"log",longname:"log",scope:"global"},{comment:"/**\n* Log error messages\n*\n* @method error\n*/",meta:{range:[728,773],filename:"log.js",lineno:82,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Log error messages</p>",kind:"function",name:"error",longname:"error",scope:"global"},{comment:"/**\n* Log warning messages\n*\n* @method warn\n*/",meta:{range:[780,826],filename:"log.js",lineno:89,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Log warning messages</p>",kind:"function",name:"warn",longname:"warn",scope:"global"},{comment:"/**\n* @file merge-options.js\n*/",meta:{range:[0,31],filename:"merge-options.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},name:"utils/merge-options.js",kind:"file",description:"<p>merge-options.js</p>",preserveName:!0,longname:"utils/merge-options.js",scope:"global"},{comment:"/**\n* Merge one or more options objects, recursively merging **only**\n* plain object properties.  Previously `deepMerge`.\n*\n* @param  {...Object} source One or more objects to merge\n* @returns {Object}          a new object that is the union of all\n* provided objects\n* @function mergeOptions\n*/",meta:{range:[275,570],filename:"merge-options.js",lineno:35,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Merge one or more options objects, recursively merging <strong>only</strong>\nplain object properties.  Previously <code>deepMerge</code>.</p>",params:[{type:{names:["Object"]},variable:!0,description:"<p>One or more objects to merge</p>",name:"source"}],returns:[{type:{names:["Object"]},description:"<p>a new object that is the union of all\nprovided objects</p>"}],kind:"function",name:"mergeOptions",longname:"mergeOptions",scope:"global"},{comment:"/**\n* @file time-ranges.js\n*\n* Should create a fake TimeRange object\n* Mimics an HTML5 time range instance, which has functions that\n* return the start and end times for a range\n* TimeRanges are returned by the buffered() method\n*\n* @param  {(Number|Array)} Start of a single range or an array of ranges\n* @param  {Number} End of a single range\n* @private\n* @method createTimeRanges\n*/",meta:{range:[6,391],filename:"time-ranges.js",lineno:3,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},name:"createTimeRanges",kind:"function",description:"<p>time-ranges.js</p>\n<p>Should create a fake TimeRange object\nMimics an HTML5 time range instance, which has functions that\nreturn the start and end times for a range\nTimeRanges are returned by the buffered() method</p>",preserveName:!0,params:[{type:{names:["Number","Array"]},description:"<p>of a single range or an array of ranges</p>",name:"Start"},{type:{names:["Number"]},description:"<p>of a single range</p>",name:"End"}],access:"private",longname:"createTimeRanges",scope:"global"},{comment:"/**\n* @file to-title-case.js\n*\n* Uppercase the first letter of a string\n*\n* @param  {String} string String to be uppercased\n* @return {String}\n* @private\n* @method toTitleCase\n*/",meta:{range:[0,178],filename:"to-title-case.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},name:"toTitleCase",kind:"function",description:"<p>to-title-case.js</p>\n<p>Uppercase the first letter of a string</p>",preserveName:!0,params:[{type:{names:["String"]},description:"<p>String to be uppercased</p>",name:"string"}],returns:[{type:{names:["String"]}}],access:"private",longname:"toTitleCase",scope:"global"},{comment:"/**\n* @file url.js\n*/",meta:{range:[0,21],filename:"url.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},name:"utils/url.js",kind:"file",description:"<p>url.js</p>",preserveName:!0,longname:"utils/url.js",scope:"global"},{comment:"/**\n* Resolve and parse the elements of a URL\n*\n* @param  {String} url The url to parse\n* @return {Object}     An object of url details\n* @method parseUrl\n*/",meta:{range:[31,188],filename:"url.js",lineno:7,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Resolve and parse the elements of a URL</p>",params:[{type:{names:["String"]},description:"<p>The url to parse</p>",name:"url"}],returns:[{type:{names:["Object"]},description:"<p>An object of url details</p>"}],kind:"function",name:"parseUrl",longname:"parseUrl",scope:"global"},{comment:"/**\n* Get absolute version of relative URL. Used to tell flash correct URL.\n* http://stackoverflow.com/questions/470832/getting-an-absolute-url-from-a-relative-one-ie6-issue\n*\n* @param  {String} url URL to make absolute\n* @return {String}     Absolute URL\n* @private\n* @method getAbsoluteURL\n*/",meta:{range:[324,618],filename:"url.js",lineno:59,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Get absolute version of relative URL. Used to tell flash correct URL.\nhttp://stackoverflow.com/questions/470832/getting-an-absolute-url-from-a-relative-one-ie6-issue</p>",params:[{type:{names:["String"]},description:"<p>URL to make absolute</p>",name:"url"}],returns:[{type:{names:["String"]},description:"<p>Absolute URL</p>"}],access:"private",kind:"function",name:"getAbsoluteURL",longname:"getAbsoluteURL",scope:"global"},{comment:"/**\n* Returns the extension of the passed file name. It will return an empty string if you pass an invalid path\n*\n* @param {String}    path    The fileName path like '/path/to/file.mp4'\n* @returns {String}          The extension in lower case or an empty string if no extension could be found.\n* @method getFileExtension\n*/",meta:{range:[655,978],filename:"url.js",lineno:80,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Returns the extension of the passed file name. It will return an empty string if you pass an invalid path</p>",params:[{type:{names:["String"]},description:"<p>The fileName path like '/path/to/file.mp4'</p>",name:"path"}],returns:[{type:{names:["String"]},description:"<p>The extension in lower case or an empty string if no extension could be found.</p>"}],kind:"function",name:"getFileExtension",longname:"getFileExtension",scope:"global"},{comment:"/**\n* Returns whether the url passed is a cross domain request or not.\n*\n* @param {String} url The url to check\n* @return {Boolean}   Whether it is a cross domain request or not\n* @method isCrossOrigin\n*/",meta:{range:[1018,1222],filename:"url.js",lineno:100,path:"/Users/mboles/git/docs/video.js/src/js/utils",code:{}},description:"<p>Returns whether the url passed is a cross domain request or not.</p>",params:[{type:{names:["String"]},description:"<p>The url to check</p>",name:"url"}],returns:[{type:{names:["Boolean"]},description:"<p>Whether it is a cross domain request or not</p>"}],kind:"function",name:"isCrossOrigin",longname:"isCrossOrigin",scope:"global"},{comment:"/**\n* @file video.js\n*/",meta:{range:[0,23],filename:"video.js",lineno:1,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},name:"video.js",kind:"file",description:"<p>video.js</p>",preserveName:!0,longname:"video.js",scope:"global"},{comment:"/**\n* Doubles as the main function for users to create a player instance and also\n* the main library object.\n* The `videojs` function can be used to initialize or retrieve a player.\n* ```js\n*     var myPlayer = videojs('my_video_id');\n* ```\n*\n* @param  {String|Element} id      Video element or video element ID\n* @param  {Object=} options        Optional options object for config/settings\n* @param  {Function=} ready        Optional ready callback\n* @return {Player}                 A player instance\n* @mixes videojs\n* @method videojs\n*/",meta:{range:[135,675],filename:"video.js",lineno:41,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Doubles as the main function for users to create a player instance and also\nthe main library object.\nThe <code>videojs</code> function can be used to initialize or retrieve a player.</p>\n<pre class=\"prettyprint source lang-js\"><code>    var myPlayer = videojs('my_video_id');</code></pre>",params:[{type:{names:["String","Element"]},description:"<p>Video element or video element ID</p>",name:"id"},{type:{names:["Object"]},optional:!0,description:"<p>Optional options object for config/settings</p>",name:"options"},{type:{names:["function"]},optional:!0,description:"<p>Optional ready callback</p>",name:"ready"}],returns:[{type:{names:["Player"]},description:"<p>A player instance</p>"}],mixes:["videojs"],kind:"function",name:"videojs",longname:"videojs",scope:"global"},{comment:"/**\n* Get an object with the currently created players, keyed by player ID\n*\n* @return {Object} The created players\n* @mixes videojs\n* @method getPlayers\n*/",meta:{range:[1220,1376],filename:"video.js",lineno:147,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get an object with the currently created players, keyed by player ID</p>",returns:[{type:{names:["Object"]},description:"<p>The created players</p>"}],mixes:["videojs"],kind:"function",name:"getPlayers",longname:"getPlayers",scope:"global"},{comment:"/**\n* Get a component class object by name\n* ```js\n*     var VjsButton = videojs.getComponent('Button');\n*     // Create a new instance of the component\n*     var myButton = new VjsButton(myPlayer);\n* ```\n*\n* @return {Component} Component identified by name\n* @mixes videojs\n* @method getComponent\n*/",meta:{range:[1472,1772],filename:"video.js",lineno:164,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get a component class object by name</p>\n<pre class=\"prettyprint source lang-js\"><code>    var VjsButton = videojs.getComponent('Button');\n    // Create a new instance of the component\n    var myButton = new VjsButton(myPlayer);</code></pre>",returns:[{type:{names:["Component"]},description:"<p>Component identified by name</p>"}],mixes:["videojs"],kind:"function",name:"getComponent",longname:"getComponent",scope:"global"},{comment:"/**\n* Register a component so it can referred to by name\n* Used when adding to other\n* components, either through addChild\n* `component.addChild('myComponent')`\n* or through default children options\n* `{ children: ['myComponent'] }`.\n* ```js\n*     // Get a component to subclass\n*     var VjsButton = videojs.getComponent('Button');\n*     // Subclass the component (see 'extend' doc for more info)\n*     var MySpecialButton = videojs.extend(VjsButton, {});\n*     // Register the new component\n*     VjsButton.registerComponent('MySepcialButton', MySepcialButton);\n*     // (optionally) add the new component as a default player child\n*     myPlayer.addChild('MySepcialButton');\n* ```\n* NOTE: You could also just initialize the component before adding.\n* `component.addChild(new MyComponent());`\n*\n* @param {String} The class name of the component\n* @param {Component} The component class\n* @return {Component} The newly registered component\n* @mixes videojs\n* @method registerComponent\n*/",meta:{range:[1779,2767],filename:"video.js",lineno:178,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Register a component so it can referred to by name\nUsed when adding to other\ncomponents, either through addChild\n<code>component.addChild('myComponent')</code>\nor through default children options\n<code>{ children: ['myComponent'] }</code>.</p>\n<pre class=\"prettyprint source lang-js\"><code>    // Get a component to subclass\n    var VjsButton = videojs.getComponent('Button');\n    // Subclass the component (see 'extend' doc for more info)\n    var MySpecialButton = videojs.extend(VjsButton, {});\n    // Register the new component\n    VjsButton.registerComponent('MySepcialButton', MySepcialButton);\n    // (optionally) add the new component as a default player child\n    myPlayer.addChild('MySepcialButton');</code></pre><p>NOTE: You could also just initialize the component before adding.\n<code>component.addChild(new MyComponent());</code></p>",params:[{type:{names:["String"]},description:"<p>class name of the component</p>",name:"The"},{type:{names:["Component"]},description:"<p>component class</p>",name:"The"}],returns:[{type:{names:["Component"]},description:"<p>The newly registered component</p>"}],mixes:["videojs"],kind:"function",name:"registerComponent",longname:"registerComponent",scope:"global"},{comment:"/**\n* Get a Tech class object by name\n* ```js\n*     var Html5 = videojs.getTech('Html5');\n*     // Create a new instance of the component\n*     var html5 = new Html5(options);\n* ```\n*\n* @return {Tech} Tech identified by name\n* @mixes videojs\n* @method getComponent\n*/",meta:{range:[2792,3059],filename:"video.js",lineno:212,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get a Tech class object by name</p>\n<pre class=\"prettyprint source lang-js\"><code>    var Html5 = videojs.getTech('Html5');\n    // Create a new instance of the component\n    var html5 = new Html5(options);</code></pre>",returns:[{type:{names:["Tech"]},description:"<p>Tech identified by name</p>"}],mixes:["videojs"],kind:"function",name:"getComponent",longname:"getComponent",scope:"global"},{comment:"/**\n* Register a Tech so it can referred to by name.\n* This is used in the tech order for the player.\n*\n* ```js\n*     // get the Html5 Tech\n*     var Html5 = videojs.getTech('Html5');\n*     var MyTech = videojs.extend(Html5, {});\n*     // Register the new Tech\n*     VjsButton.registerTech('Tech', MyTech);\n*     var player = videojs('myplayer', {\n*       techOrder: ['myTech', 'html5']\n*     });\n* ```\n*\n* @param {String} The class name of the tech\n* @param {Tech} The tech class\n* @return {Tech} The newly registered Tech\n* @mixes videojs\n* @method registerTech\n*/",meta:{range:[3066,3632],filename:"video.js",lineno:226,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Register a Tech so it can referred to by name.\nThis is used in the tech order for the player.</p>\n<pre class=\"prettyprint source lang-js\"><code>    // get the Html5 Tech\n    var Html5 = videojs.getTech('Html5');\n    var MyTech = videojs.extend(Html5, {});\n    // Register the new Tech\n    VjsButton.registerTech('Tech', MyTech);\n    var player = videojs('myplayer', {\n      techOrder: ['myTech', 'html5']\n    });</code></pre>",params:[{type:{names:["String"]},description:"<p>class name of the tech</p>",name:"The"},{type:{names:["Tech"]},description:"<p>tech class</p>",name:"The"}],returns:[{type:{names:["Tech"]},description:"<p>The newly registered Tech</p>"}],mixes:["videojs"],kind:"function",name:"registerTech",longname:"registerTech",scope:"global"},{comment:"/**\n* Subclass an existing class\n* Mimics ES6 subclassing with the `extend` keyword\n* ```js\n*     // Create a basic javascript 'class'\n*     function MyClass(name){\n*       // Set a property at initialization\n*       this.myName = name;\n*     }\n*     // Create an instance method\n*     MyClass.prototype.sayMyName = function(){\n*       alert(this.myName);\n*     };\n*     // Subclass the exisitng class and change the name\n*     // when initializing\n*     var MySubClass = videojs.extend(MyClass, {\n*       constructor: function(name) {\n*         // Call the super class constructor for the subclass\n*         MyClass.call(this, name)\n*       }\n*     });\n*     // Create an instance of the new sub class\n*     var myInstance = new MySubClass('John');\n*     myInstance.sayMyName(); // -> should alert \"John\"\n* ```\n*\n* @param {Function} The Class to subclass\n* @param {Object} An object including instace methods for the new class\n*                   Optionally including a `constructor` function\n* @return {Function} The newly created subclass\n* @mixes videojs\n* @method extend\n*/",meta:{range:[3944,5022],filename:"video.js",lineno:267,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Subclass an existing class\nMimics ES6 subclassing with the <code>extend</code> keyword</p>\n<pre class=\"prettyprint source lang-js\"><code>    // Create a basic javascript 'class'\n    function MyClass(name){\n      // Set a property at initialization\n      this.myName = name;\n    }\n    // Create an instance method\n    MyClass.prototype.sayMyName = function(){\n      alert(this.myName);\n    };\n    // Subclass the exisitng class and change the name\n    // when initializing\n    var MySubClass = videojs.extend(MyClass, {\n      constructor: function(name) {\n        // Call the super class constructor for the subclass\n        MyClass.call(this, name)\n      }\n    });\n    // Create an instance of the new sub class\n    var myInstance = new MySubClass('John');\n    myInstance.sayMyName(); // -> should alert &quot;John&quot;</code></pre>",params:[{type:{names:["function"]},description:"<p>Class to subclass</p>",name:"The"},{type:{names:["Object"]},description:"<p>object including instace methods for the new class\n                  Optionally including a <code>constructor</code> function</p>",name:"An"}],returns:[{type:{names:["function"]},description:"<p>The newly created subclass</p>"}],mixes:["videojs"],kind:"function",name:"extend",longname:"extend",scope:"global"},{comment:"/**\n* Merge two options objects recursively\n* Performs a deep merge like lodash.merge but **only merges plain objects**\n* (not arrays, elements, anything else)\n* Other values will be copied directly from the second object.\n* ```js\n*     var defaultOptions = {\n*       foo: true,\n*       bar: {\n*         a: true,\n*         b: [1,2,3]\n*       }\n*     };\n*     var newOptions = {\n*       foo: false,\n*       bar: {\n*         b: [4,5,6]\n*       }\n*     };\n*     var result = videojs.mergeOptions(defaultOptions, newOptions);\n*     // result.foo = false;\n*     // result.bar.a = true;\n*     // result.bar.b = [4,5,6];\n* ```\n*\n* @param {Object} defaults  The options object whose values will be overriden\n* @param {Object} overrides The options object with values to override the first\n* @param {Object} etc       Any number of additional options objects\n*\n* @return {Object} a new object with the merged values\n* @mixes videojs\n* @method mergeOptions\n*/",meta:{range:[5029,5978],filename:"video.js",lineno:302,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:'<p>Merge two options objects recursively\nPerforms a deep merge like lodash.merge but <strong>only merges plain objects</strong>\n(not arrays, elements, anything else)\nOther values will be copied directly from the second object.</p>\n<pre class="prettyprint source lang-js"><code>    var defaultOptions = {\n      foo: true,\n      bar: {\n        a: true,\n        b: [1,2,3]\n      }\n    };\n    var newOptions = {\n      foo: false,\n      bar: {\n        b: [4,5,6]\n      }\n    };\n    var result = videojs.mergeOptions(defaultOptions, newOptions);\n    // result.foo = false;\n    // result.bar.a = true;\n    // result.bar.b = [4,5,6];</code></pre>',
params:[{type:{names:["Object"]},description:"<p>The options object whose values will be overriden</p>",name:"defaults"},{type:{names:["Object"]},description:"<p>The options object with values to override the first</p>",name:"overrides"},{type:{names:["Object"]},description:"<p>Any number of additional options objects</p>",name:"etc"}],returns:[{type:{names:["Object"]},description:"<p>a new object with the merged values</p>"}],mixes:["videojs"],kind:"function",name:"mergeOptions",longname:"mergeOptions",scope:"global"},{comment:"/**\n* Create a Video.js player plugin\n* Plugins are only initialized when options for the plugin are included\n* in the player options, or the plugin function on the player instance is\n* called.\n* **See the plugin guide in the docs for a more detailed example**\n* ```js\n*     // Make a plugin that alerts when the player plays\n*     videojs.plugin('myPlugin', function(myPluginOptions) {\n*       myPluginOptions = myPluginOptions || {};\n*\n*       var player = this;\n*       var alertText = myPluginOptions.text || 'Player is playing!'\n*\n*       player.on('play', function(){\n*         alert(alertText);\n*       });\n*     });\n*     // USAGE EXAMPLES\n*     // EXAMPLE 1: New player with plugin options, call plugin immediately\n*     var player1 = videojs('idOne', {\n*       myPlugin: {\n*         text: 'Custom text!'\n*       }\n*     });\n*     // Click play\n*     // --> Should alert 'Custom text!'\n*     // EXAMPLE 3: New player, initialize plugin later\n*     var player3 = videojs('idThree');\n*     // Click play\n*     // --> NO ALERT\n*     // Click pause\n*     // Initialize plugin using the plugin function on the player instance\n*     player3.myPlugin({\n*       text: 'Plugin added later!'\n*     });\n*     // Click play\n*     // --> Should alert 'Plugin added later!'\n* ```\n*\n* @param {String} name The plugin name\n* @param {Function} fn The plugin function that will be called with options\n* @mixes videojs\n* @method plugin\n*/",meta:{range:[6472,7900],filename:"video.js",lineno:354,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Create a Video.js player plugin\nPlugins are only initialized when options for the plugin are included\nin the player options, or the plugin function on the player instance is\ncalled.\n<strong>See the plugin guide in the docs for a more detailed example</strong></p>\n<pre class=\"prettyprint source lang-js\"><code>    // Make a plugin that alerts when the player plays\n    videojs.plugin('myPlugin', function(myPluginOptions) {\n      myPluginOptions = myPluginOptions || {};\n\n      var player = this;\n      var alertText = myPluginOptions.text || 'Player is playing!'\n\n      player.on('play', function(){\n        alert(alertText);\n      });\n    });\n    // USAGE EXAMPLES\n    // EXAMPLE 1: New player with plugin options, call plugin immediately\n    var player1 = videojs('idOne', {\n      myPlugin: {\n        text: 'Custom text!'\n      }\n    });\n    // Click play\n    // --> Should alert 'Custom text!'\n    // EXAMPLE 3: New player, initialize plugin later\n    var player3 = videojs('idThree');\n    // Click play\n    // --> NO ALERT\n    // Click pause\n    // Initialize plugin using the plugin function on the player instance\n    player3.myPlugin({\n      text: 'Plugin added later!'\n    });\n    // Click play\n    // --> Should alert 'Plugin added later!'</code></pre>",params:[{type:{names:["String"]},description:"<p>The plugin name</p>",name:"name"},{type:{names:["function"]},description:"<p>The plugin function that will be called with options</p>",name:"fn"}],mixes:["videojs"],kind:"function",name:"plugin",longname:"plugin",scope:"global"},{comment:"/**\n* Adding languages so that they're available to all players.\n* ```js\n*     videojs.addLanguage('es', { 'Hello': 'Hola' });\n* ```\n*\n* @param  {String} code The language code or dictionary property\n* @param  {Object} data The data values to be translated\n* @return {Object} The resulting language dictionary object\n* @mixes videojs\n* @method addLanguage\n*/",meta:{range:[7907,8265],filename:"video.js",lineno:401,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Adding languages so that they're available to all players.</p>\n<pre class=\"prettyprint source lang-js\"><code>    videojs.addLanguage('es', { 'Hello': 'Hola' });</code></pre>",params:[{type:{names:["String"]},description:"<p>The language code or dictionary property</p>",name:"code"},{type:{names:["Object"]},description:"<p>The data values to be translated</p>",name:"data"}],returns:[{type:{names:["Object"]},description:"<p>The resulting language dictionary object</p>"}],mixes:["videojs"],kind:"function",name:"addLanguage",longname:"addLanguage",scope:"global"},{comment:"/**\n* Creates an emulated TimeRange object.\n*\n* @param  {Number|Array} start Start time in seconds or an array of ranges\n* @param  {Number} end   End time in seconds\n* @return {Object}       Fake TimeRange object\n* @method createTimeRange\n*/",meta:{range:[8376,8617],filename:"video.js",lineno:425,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Creates an emulated TimeRange object.</p>",params:[{type:{names:["Number","Array"]},description:"<p>Start time in seconds or an array of ranges</p>",name:"start"},{type:{names:["Number"]},description:"<p>End time in seconds</p>",name:"end"}],returns:[{type:{names:["Object"]},description:"<p>Fake TimeRange object</p>"}],kind:"function",name:"createTimeRange",longname:"createTimeRange",scope:"global"},{comment:"/**\n* Format seconds as a time string, H:MM:SS or M:SS\n* Supplying a guide (in seconds) will force a number of leading zeros\n* to cover the length of the guide\n*\n* @param  {Number} seconds Number of seconds to be turned into a string\n* @param  {Number} guide   Number (in seconds) to model the string after\n* @return {String}         Time formatted as H:MM:SS or M:SS\n* @method formatTime\n*/",meta:{range:[8624,9015],filename:"video.js",lineno:435,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Format seconds as a time string, H:MM:SS or M:SS\nSupplying a guide (in seconds) will force a number of leading zeros\nto cover the length of the guide</p>",params:[{type:{names:["Number"]},description:"<p>Number of seconds to be turned into a string</p>",name:"seconds"},{type:{names:["Number"]},description:"<p>Number (in seconds) to model the string after</p>",name:"guide"}],returns:[{type:{names:["String"]},description:"<p>Time formatted as H:MM:SS or M:SS</p>"}],kind:"function",name:"formatTime",longname:"formatTime",scope:"global"},{comment:"/**\n* Resolve and parse the elements of a URL\n*\n* @param  {String} url The url to parse\n* @return {Object}     An object of url details\n* @method parseUrl\n*/",meta:{range:[9022,9179],filename:"video.js",lineno:447,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Resolve and parse the elements of a URL</p>",params:[{type:{names:["String"]},description:"<p>The url to parse</p>",name:"url"}],returns:[{type:{names:["Object"]},description:"<p>An object of url details</p>"}],kind:"function",name:"parseUrl",longname:"parseUrl",scope:"global"},{comment:"/**\n* Returns whether the url passed is a cross domain request or not.\n*\n* @param {String} url The url to check\n* @return {Boolean}   Whether it is a cross domain request or not\n* @method isCrossOrigin\n*/",meta:{range:[9186,9390],filename:"video.js",lineno:456,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Returns whether the url passed is a cross domain request or not.</p>",params:[{type:{names:["String"]},description:"<p>The url to check</p>",name:"url"}],returns:[{type:{names:["Boolean"]},description:"<p>Whether it is a cross domain request or not</p>"}],kind:"function",name:"isCrossOrigin",longname:"isCrossOrigin",scope:"global"},{comment:"/**\n* Add an event listener to element\n* It stores the handler function in a separate cache object\n* and adds a generic handler to the element's event,\n* along with a unique id (guid) to the element.\n*\n* @param  {Element|Object}   elem Element or object to bind listeners to\n* @param  {String|Array}   type Type of event to bind to.\n* @param  {Function} fn   Event listener.\n* @method on\n*/",meta:{range:[9453,9843],filename:"video.js",lineno:472,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Add an event listener to element\nIt stores the handler function in a separate cache object\nand adds a generic handler to the element's event,\nalong with a unique id (guid) to the element.</p>",params:[{type:{names:["Element","Object"]},description:"<p>Element or object to bind listeners to</p>",name:"elem"},{type:{names:["String","Array"]},description:"<p>Type of event to bind to.</p>",name:"type"},{type:{names:["function"]},description:"<p>Event listener.</p>",name:"fn"}],kind:"function",name:"on",longname:"on",scope:"global"},{comment:"/**\n* Trigger a listener only once for an event\n*\n* @param  {Element|Object}   elem Element or object to\n* @param  {String|Array}   type Name/type of event\n* @param  {Function} fn Event handler function\n* @method one\n*/",meta:{range:[9850,10069],filename:"video.js",lineno:485,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Trigger a listener only once for an event</p>",params:[{type:{names:["Element","Object"]},description:"<p>Element or object to</p>",name:"elem"},{type:{names:["String","Array"]},description:"<p>Name/type of event</p>",name:"type"},{type:{names:["function"]},description:"<p>Event handler function</p>",name:"fn"}],kind:"function",name:"one",longname:"one",scope:"global"},{comment:"/**\n* Removes event listeners from an element\n*\n* @param  {Element|Object}   elem Object to remove listeners from\n* @param  {String|Array=}   type Type of listener to remove. Don't include to remove all events from element.\n* @param  {Function} fn   Specific listener to remove. Don't include to remove listeners for an event type.\n* @method off\n*/",meta:{range:[10076,10424],filename:"video.js",lineno:495,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Removes event listeners from an element</p>",params:[{type:{names:["Element","Object"]},description:"<p>Object to remove listeners from</p>",name:"elem"},{type:{names:["String","Array"]},description:"<p>Type of listener to remove. Don't include to remove all events from element.</p>",name:"type"},{type:{names:["function"]},description:"<p>Specific listener to remove. Don't include to remove listeners for an event type.</p>",name:"fn"}],kind:"function",name:"off",longname:"off",scope:"global"},{comment:"/**\n* Trigger an event for an element\n*\n* @param  {Element|Object}      elem  Element to trigger an event on\n* @param  {Event|Object|String} event A string (the type) or an event object with a type attribute\n* @param  {Object} [hash] data hash to pass along with the event\n* @return {Boolean=} Returned only if default was prevented\n* @method trigger\n*/",meta:{range:[10431,10784],filename:"video.js",lineno:505,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Trigger an event for an element</p>",params:[{type:{names:["Element","Object"]},description:"<p>Element to trigger an event on</p>",name:"elem"},{type:{names:["Event","Object","String"]},description:"<p>A string (the type) or an event object with a type attribute</p>",name:"event"},{type:{names:["Object"]},optional:!0,description:"<p>data hash to pass along with the event</p>",name:"hash"}],returns:[{type:{names:["Boolean"]},optional:!0,description:"<p>Returned only if default was prevented</p>"}],kind:"function",name:"trigger",longname:"trigger",scope:"global"},{comment:"/**\n* Determines, via duck typing, whether or not a value is a DOM element.\n*\n* @method isEl\n* @param  {Mixed} value\n* @return {Boolean}\n*/",meta:{range:[11740,11879],filename:"video.js",lineno:562,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Determines, via duck typing, whether or not a value is a DOM element.</p>",kind:"function",name:"isEl",params:[{type:{names:["Mixed"]},name:"value"}],returns:[{type:{names:["Boolean"]}}],longname:"isEl",scope:"global"},{comment:"/**\n* Determines, via duck typing, whether or not a value is a text node.\n*\n* @method isTextNode\n* @param  {Mixed} value\n* @return {Boolean}\n*/",meta:{range:[11886,12029],filename:"video.js",lineno:571,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Determines, via duck typing, whether or not a value is a text node.</p>",kind:"function",name:"isTextNode",params:[{type:{names:["Mixed"]},name:"value"}],returns:[{type:{names:["Boolean"]}}],longname:"isTextNode",scope:"global"},{comment:"/**\n* Creates an element and applies properties.\n*\n* @method createEl\n* @param  {String} [tagName='div'] Name of tag to be created.\n* @param  {Object} [properties={}] Element properties to be applied.\n* @param  {Object} [attributes={}] Element attributes to be applied.\n* @return {Element}\n*/",meta:{range:[12036,12328],filename:"video.js",lineno:580,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Creates an element and applies properties.</p>",kind:"function",name:"createEl",params:[{type:{names:["String"]},optional:!0,defaultvalue:"'div'",description:"<p>Name of tag to be created.</p>",name:"tagName"},{type:{names:["Object"]},optional:!0,defaultvalue:"{}",description:"<p>Element properties to be applied.</p>",name:"properties"},{type:{names:["Object"]},optional:!0,defaultvalue:"{}",description:"<p>Element attributes to be applied.</p>",name:"attributes"}],returns:[{type:{names:["Element"]}}],longname:"createEl",scope:"global"},{comment:"/**\n* Check if an element has a CSS class\n*\n* @method hasClass\n* @param {Element} element Element to check\n* @param {String} classToCheck Classname to check\n*/",meta:{range:[12335,12494],filename:"video.js",lineno:591,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Check if an element has a CSS class</p>",kind:"function",name:"hasClass",params:[{type:{names:["Element"]},description:"<p>Element to check</p>",name:"element"},{type:{names:["String"]},description:"<p>Classname to check</p>",name:"classToCheck"}],longname:"hasClass",scope:"global"},{comment:"/**\n* Add a CSS class name to an element\n*\n* @method addClass\n* @param {Element} element    Element to add class name to\n* @param {String} classToAdd Classname to add\n*/",meta:{range:[12501,12670],filename:"video.js",lineno:600,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Add a CSS class name to an element</p>",kind:"function",name:"addClass",params:[{type:{names:["Element"]},description:"<p>Element to add class name to</p>",name:"element"},{type:{names:["String"]},description:"<p>Classname to add</p>",name:"classToAdd"}],longname:"addClass",scope:"global"},{comment:"/**\n* Remove a CSS class name from an element\n*\n* @method removeClass\n* @param {Element} element    Element to remove from class name\n* @param {String} classToRemove Classname to remove\n*/",meta:{range:[12677,12865],filename:"video.js",lineno:609,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Remove a CSS class name from an element</p>",kind:"function",name:"removeClass",params:[{type:{names:["Element"]},description:"<p>Element to remove from class name</p>",name:"element"},{type:{names:["String"]},description:"<p>Classname to remove</p>",name:"classToRemove"}],longname:"removeClass",scope:"global"},{comment:"/**\n* Adds or removes a CSS class name on an element depending on an optional\n* condition or the presence/absence of the class name.\n*\n* @method toggleElClass\n* @param  {Element} element\n* @param  {String} classToToggle\n* @param  {Boolean|Function} [predicate]\n*         Can be a function that returns a Boolean. If `true`, the class\n*         will be added; if `false`, the class will be removed. If not\n*         given, the class will be added if not present and vice versa.\n*/",meta:{range:[12872,13351],filename:"video.js",lineno:618,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Adds or removes a CSS class name on an element depending on an optional\ncondition or the presence/absence of the class name.</p>",kind:"function",name:"toggleElClass",params:[{type:{names:["Element"]},name:"element"},{type:{names:["String"]},name:"classToToggle"},{type:{names:["Boolean","function"]},optional:!0,description:"<p>Can be a function that returns a Boolean. If <code>true</code>, the class\n        will be added; if <code>false</code>, the class will be removed. If not\n        given, the class will be added if not present and vice versa.</p>",name:"predicate"}],longname:"toggleElClass",scope:"global"},{comment:"/**\n* Apply attributes to an HTML element.\n*\n* @method setAttributes\n* @param  {Element} el         Target element.\n* @param  {Object=} attributes Element attributes to be applied.\n*/",meta:{range:[13358,13541],filename:"video.js",lineno:632,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Apply attributes to an HTML element.</p>",kind:"function",name:"setAttributes",params:[{type:{names:["Element"]},description:"<p>Target element.</p>",name:"el"},{type:{names:["Object"]},optional:!0,description:"<p>Element attributes to be applied.</p>",name:"attributes"}],longname:"setAttributes",scope:"global"},{comment:"/**\n* Get an element's attribute values, as defined on the HTML tag\n* Attributes are not the same as properties. They're defined on the tag\n* or with setAttribute (which shouldn't be used with HTML)\n* This will return true or false for boolean attributes.\n*\n* @method getAttributes\n* @param  {Element} tag Element from which to get tag attributes\n* @return {Object}\n*/",meta:{range:[13548,13916],filename:"video.js",lineno:641,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Get an element's attribute values, as defined on the HTML tag\nAttributes are not the same as properties. They're defined on the tag\nor with setAttribute (which shouldn't be used with HTML)\nThis will return true or false for boolean attributes.</p>",kind:"function",name:"getAttributes",params:[{type:{names:["Element"]},description:"<p>Element from which to get tag attributes</p>",name:"tag"}],returns:[{type:{names:["Object"]}}],longname:"getAttributes",scope:"global"},{comment:"/**\n* Empties the contents of an element.\n*\n* @method emptyEl\n* @param  {Element} el\n* @return {Element}\n*/",meta:{range:[13923,14030],filename:"video.js",lineno:653,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Empties the contents of an element.</p>",kind:"function",name:"emptyEl",params:[{type:{names:["Element"]},name:"el"}],returns:[{type:{names:["Element"]}}],longname:"emptyEl",scope:"global"},{comment:"/**\n* Normalizes and appends content to an element.\n*\n* The content for an element can be passed in multiple types and\n* combinations, whose behavior is as follows:\n*\n* - String\n*   Normalized into a text node.\n*\n* - Element, TextNode\n*   Passed through.\n*\n* - Array\n*   A one-dimensional array of strings, elements, nodes, or functions (which\n*   return single strings, elements, or nodes).\n*\n* - Function\n*   If the sole argument, is expected to produce a string, element,\n*   node, or array.\n*\n* @method appendContent\n* @param  {Element} el\n* @param  {String|Element|TextNode|Array|Function} content\n* @return {Element}\n*/",meta:{range:[14037,14662],filename:"video.js",lineno:662,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Normalizes and appends content to an element.</p>\n<p>The content for an element can be passed in multiple types and\ncombinations, whose behavior is as follows:</p>\n<ul>\n<li><p>String\nNormalized into a text node.</p>\n</li>\n<li><p>Element, TextNode\nPassed through.</p>\n</li>\n<li><p>Array\nA one-dimensional array of strings, elements, nodes, or functions (which\nreturn single strings, elements, or nodes).</p>\n</li>\n<li><p>Function\nIf the sole argument, is expected to produce a string, element,\nnode, or array.</p>\n</li>\n</ul>",kind:"function",name:"appendContent",params:[{type:{names:["Element"]},name:"el"},{type:{names:["String","Element","TextNode","Array","function"]},name:"content"}],returns:[{type:{names:["Element"]}}],longname:"appendContent",scope:"global"},{comment:"/**\n* Normalizes and inserts content into an element; this is identical to\n* `appendContent()`, except it empties the element first.\n*\n* The content for an element can be passed in multiple types and\n* combinations, whose behavior is as follows:\n*\n* - String\n*   Normalized into a text node.\n*\n* - Element, TextNode\n*   Passed through.\n*\n* - Array\n*   A one-dimensional array of strings, elements, nodes, or functions (which\n*   return single strings, elements, or nodes).\n*\n* - Function\n*   If the sole argument, is expected to produce a string, element,\n*   node, or array.\n*\n* @method insertContent\n* @param  {Element} el\n* @param  {String|Element|TextNode|Array|Function} content\n* @return {Element}\n*/",meta:{range:[14669,15375],filename:"video.js",lineno:689,path:"/Users/mboles/git/docs/video.js/src/js",code:{}},description:"<p>Normalizes and inserts content into an element; this is identical to\n<code>appendContent()</code>, except it empties the element first.</p>\n<p>The content for an element can be passed in multiple types and\ncombinations, whose behavior is as follows:</p>\n<ul>\n<li><p>String\nNormalized into a text node.</p>\n</li>\n<li><p>Element, TextNode\nPassed through.</p>\n</li>\n<li><p>Array\nA one-dimensional array of strings, elements, nodes, or functions (which\nreturn single strings, elements, or nodes).</p>\n</li>\n<li><p>Function\nIf the sole argument, is expected to produce a string, element,\nnode, or array.</p>\n</li>\n</ul>",kind:"function",name:"insertContent",params:[{type:{names:["Element"]},name:"el"},{type:{names:["String","Element","TextNode","Array","function"]},name:"content"}],returns:[{type:{names:["Element"]}}],longname:"insertContent",scope:"global"},{kind:"package",longname:"package:undefined",files:["/Users/mboles/git/docs/video.js/src/js/base-styles.js","/Users/mboles/git/docs/video.js/src/js/big-play-button.js","/Users/mboles/git/docs/video.js/src/js/button.js","/Users/mboles/git/docs/video.js/src/js/clickable-component.js","/Users/mboles/git/docs/video.js/src/js/close-button.js","/Users/mboles/git/docs/video.js/src/js/component.js","/Users/mboles/git/docs/video.js/src/js/control-bar/audio-track-controls/audio-track-button.js","/Users/mboles/git/docs/video.js/src/js/control-bar/audio-track-controls/audio-track-menu-item.js","/Users/mboles/git/docs/video.js/src/js/control-bar/control-bar.js","/Users/mboles/git/docs/video.js/src/js/control-bar/fullscreen-toggle.js","/Users/mboles/git/docs/video.js/src/js/control-bar/live-display.js","/Users/mboles/git/docs/video.js/src/js/control-bar/mute-toggle.js","/Users/mboles/git/docs/video.js/src/js/control-bar/play-toggle.js","/Users/mboles/git/docs/video.js/src/js/control-bar/playback-rate-menu/playback-rate-menu-button.js","/Users/mboles/git/docs/video.js/src/js/control-bar/playback-rate-menu/playback-rate-menu-item.js","/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control/load-progress-bar.js","/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control/mouse-time-display.js","/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control/play-progress-bar.js","/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control/progress-control.js","/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control/seek-bar.js","/Users/mboles/git/docs/video.js/src/js/control-bar/progress-control/tooltip-progress-bar.js","/Users/mboles/git/docs/video.js/src/js/control-bar/spacer-controls/custom-control-spacer.js","/Users/mboles/git/docs/video.js/src/js/control-bar/spacer-controls/spacer.js","/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls/caption-settings-menu-item.js","/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls/captions-button.js","/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls/chapters-button.js","/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls/chapters-track-menu-item.js","/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls/descriptions-button.js","/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls/off-text-track-menu-item.js","/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls/subtitles-button.js","/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls/text-track-button.js","/Users/mboles/git/docs/video.js/src/js/control-bar/text-track-controls/text-track-menu-item.js","/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls/current-time-display.js","/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls/duration-display.js","/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls/remaining-time-display.js","/Users/mboles/git/docs/video.js/src/js/control-bar/time-controls/time-divider.js","/Users/mboles/git/docs/video.js/src/js/control-bar/track-button.js","/Users/mboles/git/docs/video.js/src/js/control-bar/volume-control/volume-bar.js","/Users/mboles/git/docs/video.js/src/js/control-bar/volume-control/volume-control.js","/Users/mboles/git/docs/video.js/src/js/control-bar/volume-control/volume-level.js","/Users/mboles/git/docs/video.js/src/js/control-bar/volume-menu-button.js","/Users/mboles/git/docs/video.js/src/js/error-display.js","/Users/mboles/git/docs/video.js/src/js/event-target.js","/Users/mboles/git/docs/video.js/src/js/extend.js","/Users/mboles/git/docs/video.js/src/js/fullscreen-api.js","/Users/mboles/git/docs/video.js/src/js/loading-spinner.js","/Users/mboles/git/docs/video.js/src/js/media-error.js","/Users/mboles/git/docs/video.js/src/js/menu/menu-button.js","/Users/mboles/git/docs/video.js/src/js/menu/menu-item.js","/Users/mboles/git/docs/video.js/src/js/menu/menu.js","/Users/mboles/git/docs/video.js/src/js/modal-dialog.js","/Users/mboles/git/docs/video.js/src/js/player.js","/Users/mboles/git/docs/video.js/src/js/plugins.js","/Users/mboles/git/docs/video.js/src/js/popup/popup-button.js","/Users/mboles/git/docs/video.js/src/js/popup/popup.js","/Users/mboles/git/docs/video.js/src/js/poster-image.js","/Users/mboles/git/docs/video.js/src/js/setup.js","/Users/mboles/git/docs/video.js/src/js/slider/slider.js","/Users/mboles/git/docs/video.js/src/js/tech/flash-rtmp.js","/Users/mboles/git/docs/video.js/src/js/tech/flash.js","/Users/mboles/git/docs/video.js/src/js/tech/html5.js","/Users/mboles/git/docs/video.js/src/js/tech/loader.js","/Users/mboles/git/docs/video.js/src/js/tech/tech.js","/Users/mboles/git/docs/video.js/src/js/tracks/audio-track-list.js","/Users/mboles/git/docs/video.js/src/js/tracks/audio-track.js","/Users/mboles/git/docs/video.js/src/js/tracks/html-track-element-list.js","/Users/mboles/git/docs/video.js/src/js/tracks/html-track-element.js","/Users/mboles/git/docs/video.js/src/js/tracks/text-track-cue-list.js","/Users/mboles/git/docs/video.js/src/js/tracks/text-track-display.js","/Users/mboles/git/docs/video.js/src/js/tracks/text-track-list-converter.js","/Users/mboles/git/docs/video.js/src/js/tracks/text-track-list.js","/Users/mboles/git/docs/video.js/src/js/tracks/text-track-settings.js","/Users/mboles/git/docs/video.js/src/js/tracks/text-track.js","/Users/mboles/git/docs/video.js/src/js/tracks/track-enums.js","/Users/mboles/git/docs/video.js/src/js/tracks/track-list.js","/Users/mboles/git/docs/video.js/src/js/tracks/track.js","/Users/mboles/git/docs/video.js/src/js/tracks/video-track-list.js","/Users/mboles/git/docs/video.js/src/js/tracks/video-track.js","/Users/mboles/git/docs/video.js/src/js/utils/browser.js","/Users/mboles/git/docs/video.js/src/js/utils/buffer.js","/Users/mboles/git/docs/video.js/src/js/utils/dom.js","/Users/mboles/git/docs/video.js/src/js/utils/events.js","/Users/mboles/git/docs/video.js/src/js/utils/fn.js","/Users/mboles/git/docs/video.js/src/js/utils/format-time.js","/Users/mboles/git/docs/video.js/src/js/utils/guid.js","/Users/mboles/git/docs/video.js/src/js/utils/log.js","/Users/mboles/git/docs/video.js/src/js/utils/merge-options.js","/Users/mboles/git/docs/video.js/src/js/utils/stylesheet.js","/Users/mboles/git/docs/video.js/src/js/utils/time-ranges.js","/Users/mboles/git/docs/video.js/src/js/utils/to-title-case.js","/Users/mboles/git/docs/video.js/src/js/utils/url.js","/Users/mboles/git/docs/video.js/src/js/video.js"]}];