# vue-router [![Build Status](https://img.shields.io/circleci/project/vuejs/vue-router/master.svg)](https://circleci.com/gh/vuejs/vue-router) [![npm package](https://img.shields.io/npm/v/vue-router.svg)](https://www.npmjs.com/package/vue-router) [![bitHound Overall Score](https://www.bithound.io/github/vuejs/vue-router/badges/score.svg)](https://www.bithound.io/github/vuejs/vue-router) [![Issue Stats](http://issuestats.com/github/vuejs/vue-router/badge/issue?style=flat)](http://issuestats.com/github/vuejs/vue-router)

**Compatibility Note:** `vue-router` requires Vue.js 0.12.10+

### Introduction

`vue-router` is the official router for [Vue.js](http://vuejs.org). It deeply integrates with Vue.js core to make building Single Page Applications with Vue.js a breeze. Features include:

- Nested route/view mapping
- Modular, component-based router configuration
- Route params, query, wildcards
- View transition effects powered by Vue.js' transition system
- Fine-grained navigation control
- Links with automatic active CSS classes
- HTML5 history mode or hash mode, with auto-fallback in IE9
- Restore scroll position when going back in history mode

Get started with the [documentation](http://vuejs.github.io/vue-router).

### Development Setup

``` bash
# install deps
npm install

# build dist files
npm run build

# serve example app at localhost:8080
# and unit tests at localhost:8081
npm run dev

# lint & run all tests
npm test

# run unit tests only
npm run unit

# run e2e tests only
npm run e2e-local
```

## Questions

For questions and support please use the [Gitter chat room](https://gitter.im/vuejs/vue) or [the official forum](http://forum.vuejs.org). The issue list of this repo is **exclusively** for bug reports and feature requests.

## Issues

Please make sure to read the [Issue Reporting Checklist](https://github.com/vuejs/vue/blob/dev/CONTRIBUTING.md#issue-reporting-guidelines) before opening an issue. Issues not conforming to the guidelines may be closed immediately.

## Contribution

Please make sure to read the [Contributing Guide](https://github.com/vuejs/vue/blob/dev/CONTRIBUTING.md) before making a pull request.

## Changelog

Details changes for each release are documented in the [release notes](https://github.com/vuejs/vue-router/releases).

## Stay In Touch

- For latest releases and announcements, follow on Twitter: [@vuejs](https://twitter.com/vuejs)

## License

[MIT](http://opensource.org/licenses/MIT)

Copyright (c) 2013-2016 Evan You


