import { toNumber, looseEqual } from '../../../util/index'

export default {

  bind () {
    var self = this
    var el = this.el

    this.getValue = function () {
      // value overwrite via v-bind:value
      if (el.hasOwnProperty('_value')) {
        return el._value
      }
      var val = el.value
      if (self.params.number) {
        val = toNumber(val)
      }
      return val
    }

    this.listener = function () {
      self.set(self.getValue())
    }
    this.on('change', this.listener)

    if (el.checked) {
      this.afterBind = this.listener
    }
  },

  update (value) {
    this.el.checked = looseEqual(value, this.getValue())
  }
}
