var _ = require('../../../util')

module.exports = {

  bind: function () {
    var self = this
    var el = this.el

    this.getValue = function () {
      // value overwrite via v-bind:value
      if (el.hasOwnProperty('_value')) {
        return el._value
      }
      var val = el.value
      if (self.params.number) {
        val = _.toNumber(val)
      }
      return val
    }

    this.listener = function () {
      self.set(self.getValue())
    }
    this.on('change', this.listener)

    if (el.checked) {
      this.afterBind = this.listener
    }
  },

  update: function (value) {
    this.el.checked = _.looseEqual(value, this.getValue())
  }
}
