/**
 * @description to html
 * @author wangfupeng
 */

import { Element } from 'slate'
import { TableCellElement, TableRowElement, TableElement } from './custom-types'

function tableToHtml(elemNode: Element, childrenHtml: string): string {
  const { fullWidth = false } = elemNode as TableElement

  let styleStr = ''
  if (fullWidth) styleStr += 'width: 100%;'

  return `<table style="${styleStr}"><tbody>${childrenHtml}</tbody></table>`
}

function tableRowToHtml(elem: Element, childrenHtml: string): string {
  return `<tr>${childrenHtml}</tr>`
}

function tableCellToHtml(cellNode: Element, childrenHtml: string): string {
  const { colSpan = 1, rowSpan = 1, isHeader = false } = cellNode as TableCellElement
  const tag = isHeader ? 'th' : 'td'
  return `<${tag} colSpan="${colSpan}" rowSpan="${rowSpan}">${childrenHtml}</${tag}>`
}

export const tableToHtmlConf = {
  type: 'table',
  elemToHtml: tableToHtml,
}

export const tableRowToHtmlConf = {
  type: 'table-row',
  elemToHtml: tableRowToHtml,
}

export const tableCellToHtmlConf = {
  type: 'table-cell',
  elemToHtml: tableCellToHtml,
}
