# ![ZUI](https://raw.githubusercontent.com/easysoft/zui/master/docs/img/zui-logo-48.png)

[![npm version](https://badge.fury.io/js/zui.svg)](https://badge.fury.io/js/zui)
[![Bower version](https://badge.fury.io/bo/zui.svg)](https://badge.fury.io/bo/zui)
[![License](https://img.shields.io/badge/license-MIT-blue.svg)](https://github.com/easysoft/zui/blob/master/LICENSE)
[![官方QQ群](https://img.shields.io/badge/QQ%E7%BE%A4-384135104-03b8cf.svg)](http://shang.qq.com/wpa/qunwpa?idkey=7ae4c241aab7cca58f55ac03b2b5fb48b71242475a9f1be06b5af053008d6bfc)

一个基于 Bootstrap 深度定制开源前端实践方案，帮助你快速构建现代跨屏应用。

从官方网站了解更多： http://zui.sexy/ 。

💎 &nbsp;为移动端设计，基于 Flex 的 UI 框架： [MZUI](http://zui.sexy/m/)。

## 特色

- 简单易用，快速构建美观的现代 Web 应用；
- 轻量级高性能，只包含关键功能特性，但具备高可扩展性，只让你的应用更快；
- 跨平台支持，多屏幕响应；最大限度的利用现代浏览器特性，但也支持 IE8 等古老的浏览器；
- 完整方案，内置大量实用第三方组件，并进行了优化，适用大部分 Web 应用的开发；
- 易于定制，有多个版本供选择，主要版本包含大部分特性，额外的内容按需加载。

## 快速使用

详细使用说明访问 http://zui.sexy/#basic/download 。

### NPM

```
npm install zui
```

### Bower

```
bower install zui
```

### CDN

由 <a href="https://cdnjs.com/libraries/zui" target="_blank">cdnjs</a> 提供：

```html
<!-- ZUI 标准版压缩后的 CSS 文件 -->
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/zui/1.6.0/css/zui.min.css">

<!-- ZUI Javascript 依赖 jQuery -->
<script src="//cdnjs.cloudflare.com/ajax/libs/zui/1.6.0/lib/jquery/jquery.js"></script>
<!-- ZUI 标准版压缩后的 JavaScript 文件 -->
<script src="//cdnjs.cloudflare.com/ajax/libs/zui/1.6.0/js/zui.min.js"></script>
```

其他 CDN:

 - 由国内 <a href="http://www.bootcdn.cn/" target="_blank">BootCDN</a> 提供

### 下载

 - [v 1.6.0 生产包](https://github.com/easysoft/zui/releases/download/v1.6.0/zui-1.6.0-dist.zip)
 - [v 1.6.0 源码](https://github.com/easysoft/zui/archive/v1.6.0.zip)

### 文档

文档请直接访问官方网站 http://zui.sexy/ 。

开发中的文档请访问 https://easysoft.github.io/zui/ 。

你也可以自己部署文档网站：下载源码后，请使用 `http:` 或 `https:` 协议访问源码根目录下的 `index.html`。

如果你的安装了 [Node.js](https://nodejs.org/) 环境，则可以按照如下步骤轻松启动网站：

1. 进入 ZUI 源码目录；
2. 执行 `npm install`；
3. 执行 `npm start`；
4. 在浏览器中访问 `http://127.0.0.1:8088`。

## 使用 ZUI 开发的项目

- [禅道](http://zentao.net)
- [蝉知](http://chanzhi.org)
- [然之](http://ranzhi.org)
