/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   api-headers-document.html
 */

/// <reference path="../polymer/types/polymer-element.d.ts" />
/// <reference path="../polymer/types/lib/elements/dom-if.d.ts" />
/// <reference path="../raml-aware/raml-aware.d.ts" />
/// <reference path="../iron-flex-layout/iron-flex-layout.d.ts" />
/// <reference path="../api-type-document/api-type-document.d.ts" />
/// <reference path="../iron-collapse/iron-collapse.d.ts" />
/// <reference path="../iron-icon/iron-icon.d.ts" />
/// <reference path="../arc-icons/arc-icons.d.ts" />
/// <reference path="../paper-button/paper-button.d.ts" />

declare namespace ApiElements {

  /**
   * `api-headers-document`
   *
   * A documentation for API headers.
   *
   * It uses [AMF](https://github.com/mulesoft/amf) json/ld model to render
   * the view.
   *
   * ## Example
   *
   * ```html
   * <api-headers-document headers="[...]" opened></api-headers-document>
   * ```
   *
   * ## Styling
   *
   * `<api-headers-document>` provides the following custom properties and mixins for styling:
   *
   * Custom property | Description | Default
   * ----------------|-------------|----------
   * `--api-headers-document` | Mixin applied to this elment | `{}`
   * `--api-headers-document-title-border-color` | Border color of the title area | `#e5e5e5`
   * `--api-headers-document-toggle-view-color` | Color of the toggle button | `--arc-toggle-view-icon-color` or `rgba(0, 0, 0, 0.74)`
   * `--toggle-button` | Theme style, mixin apllied to toggle button | `{}`
   * `--api-headers-document-toggle-view-hover-color` | Color of the toggle button when hovering. Please, mind that hover is not available on all devices.| `--arc-toggle-view-icon-hover-color` or `rgba(0, 0, 0, 0.88)`
   * `--toggle-button-hover` | Theme style, mixin apllied to toggle button when hovered. | `{}`
   * `--api-headers-document-title` | Mixin applied to the title element | `{}`
   * `--api-headers-document-title-narrow` | Mixin applied to the title when in narrow layout | `{}`
   * `--no-info-message` | Theme mixin, applied to all empty info messages | `{}`
   */
  class ApiHeadersDocument extends Polymer.Element {

    /**
     * `raml-aware` scope property to use.
     */
    aware: string|null|undefined;

    /**
     * Generated AMF json/ld model form the API spec.
     * The element assumes the object of the first array item to be a
     * type of `"http://raml.org/vocabularies/document#Document`
     * on AMF vocabulary.
     *
     * It is only usefult for the element to resolve references.
     */
    amfModel: object|any[]|null;

    /**
     * The headers AMF model Array.
     */
    headers: any[]|null|undefined;

    /**
     * Computed value from the `headers`. True if has headers.
     */
    readonly hasHeaders: boolean|null|undefined;

    /**
     * Set to true to open the view.
     * Autormatically set when the view is toggle from the UI.
     */
    opened: boolean|null|undefined;

    /**
     * A property passed to the type document element to render
     * a mogile friendly view.
     */
    narrow: boolean|null|undefined;

    /**
     * Computes value for `hasHeaders` property
     *
     * @param record `headers` change record
     */
    _computeHasHeaders(record: object|null): Boolean|null;

    /**
     * Computes a label for the section toggle buttons.
     */
    _computeToggleActionLabel(opened: any): any;

    /**
     * Computes class for the toggle's button icon.
     */
    _computeToggleIconClass(opened: any): any;

    /**
     * Toggles the view.
     * Use `opened` property instead.
     */
    toggle(): void;
  }
}

interface HTMLElementTagNameMap {
  "api-headers-document": ApiElements.ApiHeadersDocument;
}
