/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   api-headers-editor.html
 */


// tslint:disable:variable-name Describing an API that's defined elsewhere.
// tslint:disable:no-any describes the API as best we are able today

/// <reference path="../polymer/types/polymer-element.d.ts" />
/// <reference path="../polymer/types/lib/elements/dom-if.d.ts" />
/// <reference path="../polymer/types/lib/utils/render-status.d.ts" />
/// <reference path="../api-view-model-transformer/api-view-model-transformer.d.ts" />
/// <reference path="../iron-validatable-behavior/iron-validatable-behavior.d.ts" />
/// <reference path="../raml-aware/raml-aware.d.ts" />
/// <reference path="../api-headers-form/api-headers-form.d.ts" />
/// <reference path="../code-mirror/code-mirror.d.ts" />
/// <reference path="../code-mirror-hint/code-mirror-hint.d.ts" />
/// <reference path="../code-mirror-hint/headers-addon.d.ts" />
/// <reference path="../code-mirror-hint/hint-http-headers.d.ts" />
/// <reference path="../arc-icons/arc-icons.d.ts" />
/// <reference path="../paper-icon-button/paper-icon-button.d.ts" />
/// <reference path="../headers-parser-behavior/headers-parser-behavior.d.ts" />
/// <reference path="../events-target-behavior/events-target-behavior.d.ts" />
/// <reference path="../clipboard-copy/clipboard-copy.d.ts" />
/// <reference path="../api-form-mixin/api-form-styles.d.ts" />
/// <reference path="../api-form-mixin/api-form-mixin.d.ts" />
/// <reference path="../amf-helper-mixin/amf-helper-mixin.d.ts" />

declare namespace ApiElements {

  /**
   * `api-headers-editor`
   * An element to render headers edior based on AMF data model.
   *
   * By default it renders headers form. The user has an option to switch to
   * source editing mode. `code-mirror` element is used in the later case.
   *
   * ## AMF data model
   *
   * This element renders pre-configured form of headers based on
   * [AMF's](https://github.com/mulesoft/amf) json/ld data model.
   * From the model select `http://raml.org/vocabularies/http#header`
   * node which contains list of headers defined for current object
   * (it can be method, trait, security scheme etc).
   * The model is resolved to internal data model by `api-view-model-transformer`
   * element.
   *
   * If the element is used without AMF model `allowCustom` property must be
   * set or otherwise user won't be able to add new header to the editor.
   *
   * ### Example
   *
   * ```html
   * <api-headers-editor id="editor" allow-disable-params></api-headers-editor>
   * <script>
   * let data = await getAmfModel();
   * editor.amfModel = data;
   * data = data[0]['http://raml.org/vocabularies/document#encodes'][0];
   * data = data['http://raml.org/vocabularies/http#endpoint'][0];
   * data = data['http://www.w3.org/ns/hydra/core#supportedOperation'][0];
   * data = data['http://www.w3.org/ns/hydra/core#expects'][0];
   * data = data['http://raml.org/vocabularies/http#header'];
   * (first endpoint, first method, headers array)
   * editor.amfHeaders = data;
   * editor.addEventListener('value-changed', (e) => console.log(e.detail.value));
   * < /script>
   * ```
   *
   * ### Example without AMF
   *
   * ```html
   * <api-headers-editor id="editor" allow-disable-params allow-custom></api-headers-editor>
   * <script>
   * editor.addEventListener('value-changed', (e) => console.log(e.detail.value));
   * < /script>
   * ```
   *
   * ## Setting value when model is set
   *
   * Model values has priority over value set on the editor.
   * If `amfModel` is set and value has been altered programatically there
   * are two possible outcomes:
   *
   * 1) If `allowDisableParams` is set, model values are automatically
   * disabled if model item is not in the value
   * 2) If `allowDisableParams` is not set, model values are always
   * added to generated values. Or rather new value is added to the existing
   * model as custom values.
   */
  class ApiHeadersEditor extends
    ArcBehaviors.HeadersParserBehavior(
    ArcBehaviors.EventsTargetBehavior(
    ArcBehaviors.ApiFormMixin(
    Polymer.IronValidatableBehavior(
    ApiElements.AmfHelperMixin(
    Object))))) {

    /**
     * Generated AMF json/ld model form the API spec.
     * The element assumes the object of the first array item to be a
     * type of `"http://raml.org/vocabularies/document#Document`
     * on AMF vocabulary.
     */
    amfModel: object|any[]|null;

    /**
     * Reference to currently rendered headers editor.
     */
    readonly currentPanel: HTMLElement|null;

    /**
     * `raml-aware` scope property to use.
     */
    aware: string|null|undefined;

    /**
     * List of headers defined in AMF model to render.
     */
    amfHeaders: any[]|null|undefined;

    /**
     * Headers value.
     */
    value: string|null|undefined;

    /**
     * Generated view model fore the headers from `amfModel`.
     * This is automatically set when `amfModel` is set.
     */
    viewModel: any[]|null|undefined;

    /**
     * Value of a Content-Type header.
     * When this value change then editor update the value for the content type. However,
     * to change a single header value, please, use `request-headers-changed` event with `name`
     * and `value` properties set on the detail object.
     */
    contentType: Stirng|null;

    /**
     * When set to true then the source edit mode is enabled
     */
    sourceMode: boolean|null|undefined;

    /**
     * Events target for tranformer
     */
    _transformerTarget: object|null|undefined;

    /**
     * Regexp to search for content type value
     */
    _contentTypeRe: object|null|undefined;

    /**
     * Prohibits rendering of the documentation (the icon and the
     * description).
     * Note, Set is separately for `api-view-model-transformer`
     * component as this only affects "custom" items.
     */
    noDocs: boolean|null|undefined;

    /**
     * When set the editor is in read only mode.
     */
    readonly: boolean|null|undefined;

    /**
     * Automatically validates headers agains AMF model when value change.
     * Note, it only works with form editor.
     */
    autoValidate: boolean|null|undefined;
    _attachListeners(node: any): void;
    _detachListeners(node: any): void;

    /**
     * attribute automatically, which should be used for styling.
     */
    _getValidity(): any;

    /**
     * Handler for `sourceMode` change.
     *
     * Opens desired editr.
     */
    _sourceModeChanged(isSource: Boolean|null): void;
    _attachSourceEditor(): void;

    /**
     * Sets current value of `readonly` on the source editor.
     */
    _readonlyChanged(value: Boolean|null): void;

    /**
     * Updates the value when current editor's value change.
     */
    _editorValueChanged(e: CustomEvent|null): void;

    /**
     * Creates a headers string from a model.
     *
     * @param model Optional, model to process. If not set it uses
     * `this.viewModel`
     * @returns Generated headers
     */
    modelToValue(model: any[]|null): String|null;

    /**
     * Code mirror's ctrl+space key handler.
     * Opens headers fill support.
     *
     * @param cm Code mirror instance.
     */
    _cmKeysHandler(cm: object|null): void;

    /**
     * Called when switching from source view to form view.
     * Updates view model with values defined in text editor.
     *
     * Only headers existing in `value` are going to be present in the model.
     * Otherwise headers will be disabled.
     *
     * It does nothing if `value` or `viewModel` is not defined.
     */
    _modelFromValue(value: String|null): void;

    /**
     * Finds item position in model by name.
     *
     * @param model Model items
     * @param name Header name to search for
     * @returns Items position or `-1` if not found.
     */
    _findModelIndex(model: any[]|null, name: String|null): Number|null;

    /**
     * Creates a custom header model item.
     *
     * @param defaults Default data
     * @returns View model item
     */
    createCustom(defaults: object|null): object|null;

    /**
     * Handler tor the `request-headers-changed` event.
     * Updates the editor value to the value of the event detail object.
     */
    _headersChangedHandler(e: CustomEvent|null): void;

    /**
     * Handler for the `request-header-changed` event.
     * It updates value for a single header.
     */
    _headerChangedHandler(e: CustomEvent|null): void;

    /**
     * Handler for `content-type-changed` event.
     * Uppdates it's value if from external source.
     */
    _contentTypeChangedHandler(e: CustomEvent|null): void;

    /**
     * Handler for `request-header-deleted` custom event.
     * Deletes header from the editor.
     */
    _headerDeletedHandler(e: CustomEvent|null): void;

    /**
     * Detects and sets content type value from changed headers value.
     *
     * @param value Headers new value.
     */
    _detectContentType(value: String|null): void;

    /**
     * Called by CodeMirror editor.
     * When something change n the headers list, detect content type header.
     */
    _valueChanged(value: String|null): void;
    _onContentTypeChanged(currentCt: any): void;
    _notifyContentType(type: any): void;

    /**
     * Updates `value` when new value is computed by the editor.
     *
     * @param value A value to set.
     */
    _setValues(value: String|null): void;

    /**
     * Coppies current response text value to clipboard.
     */
    _copyToClipboard(): void;
    _resetCopyButtonState(button: any): void;

    /**
     * Refreshes the CodeMirror editor when in `sourceMode`.
     */
    refresh(): void;
  }
}

interface HTMLElementTagNameMap {
  "api-headers-editor": ApiElements.ApiHeadersEditor;
}
