/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   api-headers-form.html
 */

/// <reference path="../polymer/types/polymer-element.d.ts" />
/// <reference path="../polymer/types/lib/elements/dom-if.d.ts" />
/// <reference path="../polymer/types/lib/elements/dom-repeat.d.ts" />
/// <reference path="../polymer/types/lib/utils/render-status.d.ts" />
/// <reference path="../iron-form/iron-form.d.ts" />
/// <reference path="../paper-icon-button/paper-icon-button.d.ts" />
/// <reference path="../arc-icons/arc-icons.d.ts" />
/// <reference path="../arc-definitions/arc-definitions.d.ts" />
/// <reference path="../paper-checkbox/paper-checkbox.d.ts" />
/// <reference path="../api-form-mixin/api-form-mixin.d.ts" />
/// <reference path="../api-form-mixin/api-form-styles.d.ts" />
/// <reference path="api-headers-form-item.d.ts" />

/**
 * HTTP headers form build from AMF json/ld model.
 * The form is pre-populated with predefined values from the AMF model
 * using `api-view-model-transformer` element. This element is included in
 * `api-headers-editor`.
 *
 * **This API component replaces `raml-headers-form` component**. Old
 * component uses RAML data model generated by raml JS parser only.
 * If you need RAML form only or component that works with Polymer 1.0
 * use `raml-headers-form` instead.
 *
 * ## Building the view model
 *
 * For practical reasons this element consumes different data model than the
 * one used in AMF. Use `api-view-model-transformer` element to generate
 * data view model from AMF JSON ld schema. See demo page for example of
 * use.
 *
 * ### Generating view model from AMF
 *
 * ```html
 * <api-view-model-transformer on-view-model-changed="_updateView"></api-view-model-transformer>
 * <api-headers-form model="{{viewModel}}" value="{{headers}}"></api-headers-form>
 * <script>
 * const amfModel = getAmfFromRamlOrOas();
 * const processor = document.querySelector('api-view-model-transformer');
 * if (amfModel['@context']) {
 *  processor.amfContext = amfModel['@context'];
 * }
 * processor.amfModel = extractHeadersForMethod(amfModel);
 * processor.addEventListener('view-model-changed', (e) => {
 *  document.querySelector('api-headers-form') = e.detail.value;
 * });
 * < /script>
 * ```
 *
 * This example uses `getAmfFromRamlOrOas()` function where you implement
 * the logic of getting AMF json/ld data. It can be stored in file or parsed
 * using AMF parsers. The `extractHeadersForMethod()` function implements a
 * logic of extracting headers definition from a method (for example).
 *
 * ### Manually generating view model
 *
 * You can use `api-view-model-transformer` and `buildProperty()` function
 * to generate basic view model. You can also construct it on your own.
 * See `api-view-model-transformer` element documentation for model schema.
 *
 * ## Changes in v2
 *
 * The component won't listen for `headers-value-changed` custom event.
 * Components / applications using this element should handle headers change
 * event in the application and generate new model for the view.
 * Setting `value` makes no effect on the element. Only way to change
 * generated UI is to change the model.
 *
 * ## Styling
 *
 * Custom property | Description | Default
 * ----------------|-------------|----------
 * `--api-headers-form` | Mixin applied to this element | `{}`
 * `--api-headers-form-delete-icon-margin-top` | Margin top of the delete button | `16px`
 * `--api-headers-form-delete-icon-margin-top-narrow` | Margin top of the delete button in narrow layout | `16px`
 * `--api-headers-form-enable-checkbox-margin-top` | Margin top of the enable checkbox | `32px`
 * `--api-headers-form-enable-checkbox-margin-top` | Margin top of the enable checkbox in narrow layout | `32px`
 * `--api-headers-form-item` | Mixin applied to each form item. Each for item is separate element. | `{}`
 * `--api-headers-editore-hint-icon-margin-top` | Margin top of help icon. | `16px`
 * `--api-headers-editore-hint-icon-margin-top-narrow` | Margin top of help icon in narrow layout. | `16px`
 * `--api-headers-form-name-input` | Mixin applied to header name input | `{}`
 * `--api-headers-form-name-input-narrow` | Mixin applied to header name input in narrow layout | `{}`
 * `--api-headers-form-array-parameter` | Mixin applied to the value input when the input is an array | `{}`
 *
 * See `api-headers-form-item` and `api-form-mixin/api-form-styles` for more styling API.
 */
declare class ApiHeadersForm extends
  Polymer.IronValidatableBehavior(
  ArcBehaviors.ApiFormMixin(
  Object)) {

  /**
   * Current value of the headers. Changing the value will update the list
   * of the headers.
   */
  value: string|null|undefined;

  /**
   * Prohibits rendering of the documentation (the icon and the
   * description).
   * Note, Set is separately for `api-view-model-transformer`
   * component as this only affects "custom" items.
   */
  noDocs: boolean|null|undefined;

  /**
   * When set the editor is in read only mode.
   */
  readonly: boolean|null|undefined;
  autoValidate: boolean|null|undefined;
  _getValidity(): any;

  /**
   * Appends an empty header to the list.
   */
  add(): void;
  _modelChanged(record: any, readonly: any): void;

  /**
   * Updates value of the element when model change.
   *
   * @param validate When true then it performs validation after setting
   * the value.
   */
  _updateValue(validate: Boolean|null): void;

  /**
   * Adds documentation for headers that doesn't have it already.
   *
   * @param model View model
   */
  _autoDescribeModel(model: any[]|null): void;

  /**
   * Queries for header information and updates header info if needed.
   *
   * @param item View model item
   * @param index Position of the item in `model` array
   */
  _fillModelDescription(item: object|null, index: Number|null): void;

  /**
   * Queries for a header definition.
   *
   * @param name header name to query
   * @returns Header definition or undefined.
   */
  _queryHeaderData(name: String|null): object|null|undefined;
}

interface HTMLElementTagNameMap {
  "api-headers-form": ApiHeadersForm;
}
