/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   api-request-editor.html
 */


// tslint:disable:variable-name Describing an API that's defined elsewhere.
// tslint:disable:no-any describes the API as best we are able today

/// <reference path="../polymer/types/polymer-element.d.ts" />
/// <reference path="../polymer/types/lib/elements/dom-if.d.ts" />
/// <reference path="../polymer/types/lib/utils/render-status.d.ts" />
/// <reference path="../api-url-data-model/api-url-data-model.d.ts" />
/// <reference path="../api-url-editor/api-url-editor.d.ts" />
/// <reference path="../api-url-params-editor/api-url-params-editor.d.ts" />
/// <reference path="../authorization-panel/authorization-panel.d.ts" />
/// <reference path="../api-headers-editor/api-headers-editor.d.ts" />
/// <reference path="../api-body-editor/api-body-editor.d.ts" />
/// <reference path="../raml-aware/raml-aware.d.ts" />
/// <reference path="../paper-tabs/paper-tabs.d.ts" />
/// <reference path="../paper-tabs/paper-tab.d.ts" />
/// <reference path="../iron-flex-layout/iron-flex-layout.d.ts" />
/// <reference path="../iron-pages/iron-pages.d.ts" />
/// <reference path="../paper-button/paper-button.d.ts" />
/// <reference path="../paper-spinner/paper-spinner.d.ts" />
/// <reference path="../paper-toast/paper-toast.d.ts" />
/// <reference path="../api-form-mixin/api-form-styles.d.ts" />
/// <reference path="../uuid-generator/uuid-generator.d.ts" />
/// <reference path="../events-target-behavior/events-target-behavior.d.ts" />
/// <reference path="../amf-helper-mixin/amf-helper-mixin.d.ts" />

declare namespace ApiElements {

  /**
   * `api-request-editor`
   * A request editor that builds the UI based on
   * [AMF](https://github.com/mulesoft/amf/) model.
   *
   * The fors are generated automatically based on endponit's definition.
   *
   * Set AMF json/ld model to `amfModel` property. It accepts the generated
   * API specification model (first element is a shape of
   * `http://raml.org/vocabularies/document#Document` type).
   *
   * To build request editor view for an endpoint defined in an API, set `selected`
   * property to the id of the operation that is defined in the spec. The
   * element lookup for the definition and applies it to the editors.
   *
   * This element is to replace deprecated `advanced-rest-client/raml-request-editor`.
   *
   * ## Changes in version 2
   *
   * - XHR element is not included in the element. Use
   * `advanced-rest-client/xhr-simple-request` in your application or handle
   * `api-request` custom event to make a request
   * - The element does not include any polyfills
   * - `redirectUrl` is now `redirectUri`
   * - `api-console-request` event is now `api-request` event
   * - `api-console-response` event is now `api-response` event
   * - Added more details to `api-request` custom event (comparing to
   * `api-console-request`)
   * - The user is able to enable/disable query parameters and headers. Set
   * `allow-disable-params` attribute to enable this behavior.
   * - The user is able to add custom query parameters or headers.
   * Set `allow-custom` attribute to enable this behavior.
   * - From authorization panel changes:
   *  - `auth-settings-changed` custom event is stopped from bubbling.
   *  Listen for `authorization-settings-changed` event instead.
   * - From auth-method-oauth2 changes:
   *  - Added `deliveryMethod` and `deliveryName` properties to the
   *  `detail.setting` object.
   * - From auth-method-oauth1 changes:
   *  - Crypto library is no longer included into the element. Use
   *  `advanced-rest-client/cryptojs-lib` component to include the library
   *  if your project doesn't use crypto libraries already.
   *
   * ## api-request event
   *
   * Dispatched when "send" button is pressed by the user and the element passes
   * validation.
   * The application should handle the event and make the connection to remote
   * server using passed parameters. When the response is ready the application
   * must inform the elements about the response by dispatching `api-response`
   * custom event.
   *
   * Note that if you set `eventsTarget` property the event must be dispatched
   * at most on `eventsTarget` node (or any child node).
   *
   * API components has `advanced-rest-client/xhr-simple-request` element to
   * handle `api-request` and `abort-api-request` events and to use XHR to
   * make the connection. Note that it may not always work if the API does not
   * allows CORS.
   *
   * The api-request event has the following properties:
   *
   * - url (`String`) - Endpoint full and final url. Note that if the API does
   * not specify base uri and `baseUri` property is not set then the `url`
   * can be relative url to the resource.
   * - method (`String`) - HTTP method. User cannot change this value, it is
   * encoded in the endpoint description
   * - headers (`String`) - valid HTTP headers string
   * - payload (`String|FormData|File|Blob|undefined`) - Request body
   * - id (`String`) - A unique request identifier. This ID has to be
   *   reported back by `api-response` event. It is generated when `execute()`
   *   function is called.
   * - auth (`Object|undefined`) - Current authorization settings received
   *   from the authorization panel.
   *   In case of basic, oauth 1 and oauth 2 authorizations, the token is
   *   applied to the headers or query parameters so no action is required.
   * - authType (`String|undefined`) - Name of the authorization methods.
   *   One of `advanced-rest-client/auth-methods`.
   * - queryModel (`Array<Object>`) - Query parameters data view model.
   * - pathModel (`Array<Object>`) - URI parameters data view model
   * - headersModel (`Array<Object>`) - Headers data view model
   *
   * Do not change `queryModel`, `pathModel` and `headersModel` as it would
   * make it out of sync with the application and any change won't be
   * reflected in the editor. In future release this may be read only object.
   *
   * ## abort-api-request event
   *
   * The event is dispatched when the user press `abort` button.
   * The transport must send `api-response` custom event with error message
   * so the state of the UI is updated.
   *
   * The event contains the following properties:
   *
   * - url (`String`) The request URL. Can be empty string. Also, it may be
   * different URL that the one used to send the request if the user changed
   * it in between. Use the `id` property to compare requests.
   * - id (`String`)  Generated UUID of the request with `api-request` event.
   *
   * ## api-response event
   *
   * This element does not act on this event. See `api-request-panel`
   * documentation for more information.
   *
   * ## Limitations
   *
   * Editors used in this element usually don't perform operations right after
   * a property change. Body/Headers/Auth editors uses
   * `Polymer.RenderStatus.afterNextRender` method before they start computing
   * properties from model. Then, if DOM change is required then this operation
   * is also async. This causes a delay between selection/AMF model change
   * and reseting the properties. For example authorization state can be passed
   * to this element after at least 2 calls to `requestAnimationFrame()`.
   * Take this into the ccount when using element's API.
   *
   * ## Styling
   *
   * `<api-request-editor>` provides the following custom properties and
   * mixins for styling:
   *
   * Custom property | Description | Default
   * ----------------|-------------|----------
   * `--api-request-editor` | Mixin applied to this elment | `{}`
   * `--api-request-editor-container` | Mixin applied to the main container | `{}`
   * `--warning-primary-color` | Theme property, warning primary color | `#FF7043`
   * `--arc-font-body1` | Theme mixin, default font definition | `{}`
   * `--error-color` | Theme variable, error color.  | ``
   * `--api-request-editor-editors-border-color | Border color of editors in tabs | `transparent`
   * `--primary-button-background-color` | Theme property, background color
   * of the primary action button. Applied to "send" and "abort" buttons | `--primary-color`
   * `--primary-button-color` | Theme property, font color of the primary
   * action button. Applied to "send" and "abort" buttons  | `#fff`
   * `--action-button` | Theme mixin, applied to "send" and "abort" buttons | `{}`
   * `--primary-button-hover-background-color` | Theme property, background
   * color of the primary action button when hovering. Applied to "send" and
   * "abort" buttons | `--accent-color`
   * `--primary-button-hover-color` | Theme property, font color of the
   * primary action button when hovering. Applied to "send" and "abort" buttons  | `#fff`
   * `--action-button-hover` | Theme mixin, applied to "send" and "abort"
   * buttons when hovering | `{}`
   * `--primary-button-disabled-background-color` | Theme property, background
   * color of the primary action button when disabled. Applied to "send"
   * and "abort" buttons | `--accent-color`
   * `--primary-button-disabled-color` | Theme property, font color of the
   * primary action button when disabled. Applied to "send" and "abort"
   * buttons  | `#fff`
   * `--action-button-disabled` | Theme mixin, applied to "send" and "abort"
   * buttons when disabled | `{}`
   * `--api-request-editor-container-narrow` | Mixin applied to the main
   * container when `narrow` property is set. | `{}`
   * `--api-request-editor-send-valid-button` | Mixin applied to the send
   * button when request is valid | `{}`
   * `--api-request-editor-abort-button` | Mixin applied to the abort button | `{}`
   */
  class ApiRequestEditor extends
    ArcBehaviors.EventsTargetBehavior(
    ApiElements.AmfHelperMixin(
    Object)) {

    /**
     * AMF API model.
     * The element extracts method definition from passed model
     * and by using `selected`.
     */
    amfModel: object|null|undefined;

    /**
     * `raml-aware` scope property to use.
     */
    aware: string|null|undefined;

    /**
     * An `@id` of selected AMF shape. When changed it computes
     * method model for the selection.
     */
    selected: string|null|undefined;
    readonly _webApi: object|null|undefined;

    /**
     * Computed method declaration in the AMF model.
     */
    readonly _methodModel: object|null|undefined;

    /**
     * Hides the URL editor from the view.
     * The editor is still in the DOM and the `urlInvalid` property still will be set.
     */
    noUrlEditor: boolean|null|undefined;

    /**
     * A base URI for the API. To be set if RAML spec is missing `baseUri`
     * declaration and this produces invalid URL input. This information
     * is passed to the URL editor that prefixes the URL with `baseUri` value
     * if passed URL is a relative URL.
     */
    baseUri: string|null|undefined;

    /**
     * Computed from AMF model for the metod HTTP method name.
     */
    readonly httpMethod: String|null;

    /**
     * Headers for the request.
     */
    headers: String|null|undefined;

    /**
     * Body for the request. The type of the body depends on
     * defined in the API media type.
     */
    payload: String|FormData|File|null;

    /**
     * Final request URL including settings like `baseUri`, AMF
     * model settings and user provided parameters.
     * This value is always compoted by `api-url-editor` even if it's
     * hidden from the view.
     */
    url: string|null|undefined;

    /**
     * Selected request tab.
     */
    selectedTab: number|null|undefined;

    /**
     * Current content type.
     */
    contentType: String|null|undefined;

    /**
     * Computed value of security scheme from selected method.
     */
    readonly securedBy: Array<object|null>|null;

    /**
     * Computed list of headers in the AMF model
     */
    readonly apiHeaders: Array<object|null>|null;

    /**
     * Defined by the API payload data.
     */
    readonly apiPayload: Array<object|null>|null|undefined;

    /**
     * Computed value if the method can carry a payload.
     */
    readonly isPayloadRequest: boolean|null|undefined;

    /**
     * OAuth2 redirect URI.
     * This value **must** be set in order for OAuth 1/2 to work properly.
     */
    redirectUri: string|null|undefined;

    /**
     * Inheritet from the authorization panel state if authorization is
     * required. Authorization may be not required if one of the
     * authorization methods is `nil` (RAML).
     */
    authRequired: boolean|null|undefined;

    /**
     * Inheritet from the authorization panel state if authorization
     * data is valid.
     */
    authValid: boolean|null|undefined;

    /**
     * If set it will renders the view in the narrow layout.
     */
    narrow: boolean|null|undefined;

    /**
     * Computed value of if authorization is required for the endpoint.
     * If the auth is not required then the authorization tab is removed
     * from the view.
     */
    readonly authNotRequired: boolean|null|undefined;

    /**
     * Flag set when the request is being made.
     */
    loadingRequest: boolean|null|undefined;

    /**
     * If set it computes `hasOptional` property and shows checkbox in the
     * form to show / hide optional properties.
     */
    allowHideOptional: boolean|null|undefined;

    /**
     * If set, enable / disable param checkbox is rendered next to each
     * form item.
     */
    allowDisableParams: boolean|null|undefined;

    /**
     * When set, renders "add custom" item button.
     * If the element is to be used withouth AMF model this should always
     * be enabled. Otherwise users won't be able to add a parameter.
     */
    allowCustom: boolean|null|undefined;

    /**
     * Selected by the user auth method (if any)
     */
    authMethod: string|null|undefined;

    /**
     * Current authorization settings.
     */
    authSettings: object|null|undefined;

    /**
     * Generated request ID when the request is sent. This value is reported
     * in send and abort events
     */
    requestId: string|null|undefined;

    /**
     * Request query parameters view model
     */
    queryModel: Array<object|null>|null;

    /**
     * Request path parameters view model
     */
    pathModel: Array<object|null>|null;

    /**
     * Computed when URL params editor is invalid.
     */
    paramsInvalid: boolean|null|undefined;

    /**
     * Computed when headers editor is invalid.
     */
    headersInvalid: boolean|null|undefined;

    /**
     * Prohibits rendering of the documentation (the icon and the
     * description).
     */
    noDocs: boolean|null|undefined;

    /**
     * Computed value, true if any of the editors has invalid state.
     */
    readonly invalid: boolean|null|undefined;

    /**
     * Validity state of the URL editor
     */
    urlInvalid: boolean|null|undefined;
    _attachListeners(node: any): void;
    _detachListeners(node: any): void;

    /**
     * Computes model definition for headers.
     *
     * @param model Method model
     * @returns List of headers or undefined.
     */
    _computeHeaders(model: object|null): any[]|null|undefined;

    /**
     * Dispatches bubbling and composed custom event.
     * By default the event is cancelable until `cancelable` property is set to false.
     *
     * @param type Event type
     * @param detail A detail to set
     * @param cancelable When false the event is not cancelable.
     */
    _dispatch(type: String|null, detail: any|null, cancelable: Boolean|null): CustomEvent|null;

    /**
     * Sends usage google analytics event
     *
     * @param action Action description
     * @param label Event label
     */
    _sendGaEvent(action: String|null, label: String|null): CustomEvent|null;

    /**
     * Clears the request properties.
     */
    clearRequest(): void;

    /**
     * Computes AMF model for authorization panel.
     *
     * @param model Current method model.
     * @returns List of security definitions for the endpoint.
     */
    _computeSecuredBy(model: object|null): any[]|null|undefined;

    /**
     * Computes if authorization for the endpoint is set.
     *
     * @param model Operation model.
     */
    _computeNoAuth(model: object|null): Boolean|null;

    /**
     * Computes value for `httpMethod` property from AMF model for current
     * operation.
     *
     * @param model Operation model.
     * @returns Method name.
     */
    _computeHttpMethod(model: object|null): String|null;

    /**
     * Computes value for `apiPayload` property from AMF model for current
     * method.
     *
     * @param model Operation model.
     * @returns Method payload.
     */
    _computeApiPayload(model: object|null): Array<object|null>|null|undefined;

    /**
     * Computes value for `isPayloadRequest`.
     * Only `GET` and `HEAD` methods are known as ones that can't carry a
     * payload. For any other HTTP method this always returns true.
     *
     * @param method HTTP method value
     */
    _computeIsPayloadRequest(method: String|null): Boolean|null;

    /**
     * Updates tabs selection when `authNotRequired` property change.
     * It changes selection to the next tab if there's no authorization
     * and current selected editor is authorization.
     *
     * @param value Current value for `authNotRequired`
     */
    _noAuthChanged(value: Boolean|null): void;

    /**
     * Updates the state of the body editor when switching to it.
     * Code mirror does not property calculate it's value when
     * the editor is not visible. This forces to refresh the value of the
     * editor.
     *
     * @param selected Selected tam index.
     */
    _selectedTabChanged(selected: Number|null): void;

    /**
     * Refreshes tabs selection when `isPayloadRequest` peroperty chnage.
     */
    _isPayloadChanged(state: Boolean|null): void;

    /**
     * Refreshes tabs selection. To be called when number of tabs changes.
     */
    _refreshTabs(): void;

    /**
     * Handles send button click.
     * Depending on authorization validity it either sends the
     * request or forces authorization and sends the request.
     */
    _sendHandler(): void;

    /**
     * To be called when the user want to execute the request but
     * authorization is invalid (missin values).
     * This function brings the auth panel to front and displays error toast
     *
     * TODO: There is a case when the user didn't requested OAuth2 token
     * but provided all the data. This function should check for this
     * condition and call authorization function automatically.
     */
    authAndExecute(): void;

    /**
     * Executes the request by dispatching `api-request` custom event.
     * The event must be handled by hosting application to ensure transport.
     * Use `advanced-rest-client/xhr-simple-request` component to add logic
     * that uses XHR as a transport.
     *
     * Hosting application also must reset state of `loadingRequest` property
     * once the response is ready. It also can dispatch `api-response`
     * custom event handled by this element to reset state. This is also
     * handled by `xhr-simple-request` component.
     */
    execute(): void;

    /**
     * Sends the `abort-api-request` custom event to cancel the request.
     * Calling this method befor sending request may have unexpected
     * behavior because `requestId` is only set with `execute()` method.
     */
    abort(): void;

    /**
     * Event handler for abort click.
     */
    _abortRequest(): void;

    /**
     * Returns an object with the request properties.
     * The object contains:
     * - `method` (String)
     * - `url` (String)
     * - `headers` (String)
     * - `payload` (String)
     * - `auth` (Object)
     *
     * The `auth` property is optional and is only added to the request if
     * simple `authorization` header will not work. For example NTLM auth
     * method has to be made on a single socket connection (authorization
     * and the request) so it can't be made before the request.
     *
     * The `auth` object contains 2 properties:
     * - `type` (String) the authorization type - one of from the
     * `auth-methods` element
     * - `settings` (Object) Authorization parameters entered by the user.
     * It vary and depends on selected auth method.
     * For example in case of the NTLM it will be: `username`, `password` and
     * `domain`. See `advanced-rest-client/auth-methods` for model descriptions.
     */
    serializeRequest(): object|null;

    /**
     * Handler for the `authorization-settings-changed` dispatched by
     * authorization panel. Sets auth settings and executes the request if
     * any pending if valid.
     */
    _authSettingsChanged(e: CustomEvent|null): void;

    /**
     * Handler for the `api-response` custom event.
     * Clears the loading state.
     */
    _responseHandler(e: CustomEvent|null): void;

    /**
     * Handler for the `oauth2-redirect-uri-changed` custom event. Changes
     * the `redirectUri` property.
     */
    _authRedirectChangedHandler(e: CustomEvent|null): void;

    /**
     * Handler for path model change
     *
     * @param record Polymer's change record
     */
    _pathModelChanged(record: object|null): void;

    /**
     * Handler for query model change
     *
     * @param record Polymer's change record
     */
    _queryModelChanged(record: object|null): void;

    /**
     * Dispatches model change event
     *
     * @param type Model name
     * @param model Current model value.
     */
    _notifyModelChanged(type: String|null, model: any[]|null): void;

    /**
     * Dispatches `url-value-changed` event when url value change.
     */
    _urlChanged(value: String|null): void;

    /**
     * Computes value if `invalid` property.
     */
    _computeInvalid(urlInvalid: Boolean|null, paramsInvalid: Boolean|null, headersInvalid: Boolean|null, authValid: Boolean|null, authNotRequired: Boolean|null): Boolean|null;

    /**
     * Sets `invalid` and `aria-invalid` attributes on the element.
     *
     * @param invalid Current state of ivalid state
     */
    _invalidChnaged(invalid: Boolean|null): void;

    /**
     * Computes label for the send button.
     * If authorization state is ivalid then label is different.
     *
     * @param authValid [description]
     */
    _computeSendLabel(authValid: Boolean|null): String|null;

    /**
     * Computes value to disable send button when the form is invalid.
     * THe button is active when auth is the only invalid state
     */
    _computeSendDisabled(urlInvalid: any, paramsInvalid: any, headersInvalid: any): Boolean|null;
  }
}

interface HTMLElementTagNameMap {
  "api-request-editor": ApiElements.ApiRequestEditor;
}
