/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   api-view-model-transformer.html
 */


// tslint:disable:variable-name Describing an API that's defined elsewhere.
// tslint:disable:no-any describes the API as best we are able today

/// <reference path="../polymer/types/polymer-element.d.ts" />
/// <reference path="../events-target-behavior/events-target-behavior.d.ts" />
/// <reference path="../amf-helper-mixin/amf-helper-mixin.d.ts" />
/// <reference path="../api-example-generator/api-example-generator.d.ts" />

declare namespace ApiElements {

  /**
   * An element to transform AMF LD model into a form view model.
   *
   * Note, this element does not include polyfills for `Promise` and `Array.from`.
   *
   * The model should be used to build a form view for request parameters
   * like header, query parameters, uri parameters or the body.
   *
   * ### Data model
   * - binding {String} - one of `path`, `query`, `header`
   * - name {String} - property (form) name
   * - required {Boolean} - is property required
   * - value {any} - Value of the property
   * - description {String} - The description of the property
   * - hasDescription {Boolean} - Flag describing if the property has a
   * description.
   * - properties {Array<Object>} - If the model is a type of object it is a list
   * of this model objects.
   * - schema {Object} - Property schma information
   * - schema.type {String} - Data type of the property
   * - schema.inputLabel {String} Label for the form control
   * - schema.inputType {String} - type attribute of the `input` element.
   * - schema.pattern {String} - Regex pattern of the property
   * - schema.minLength {Number} - String property minimum length
   * - schema.maxLength {Number} - String property maximum length
   * - schema.defaultValue {any} - Default value of the property
   * - schema.examples {Array<Object>} - List of examples for the form property.
   * - schema.multipleOf {Number} - For numeric values, a `step` attribute of
   * the `input` element.
   * Each object may contain `name` (may be undefined) and must contain `value`
   * property of the example.
   * - schema.minimum {Number} - For numeric values, minimum value of the property
   * - schema.maximum {Number} - For numeric values, maximum value of the property
   * - schema.isEnum {Boolean} - Flag describing enumerable value
   * - schema.enum {Array<any>} - Only if `schema.isEnum` is set. Values for enum
   * input.
   * - schema.isArray {Boolean} - Flag describing array value for the property
   * - schema.items {Object} - Lsit of items definitions
   * - schema.isBool {Boolean} - Flag describing boolean value for the property
   * - schema.isFile {Boolean} - Flag describing File value for the property
   * - schema.isObject {Boolean} - Flag describing Object value for the property
   * - schema.isNillable {Boolean} - True when it is an union and one of union
   * items is nil.
   * - schema.inputPlaceholder {?String} - A placeholder value for the input.
   * - schema.inputFloatLabel {Boolean} - Only if placeholder is set. Instructs
   * input control to float a label.
   * - schema.isUnion {Boolean} - Flag describing union value
   * - schema.anyOf {Array<Object>} - List of possible types of the union.
   * - schema.enabled {Boolean} - Always `true`
   * - schema.fileTypes {Array<String>} List of file types defined for a file
   * type.
   * - schema.readOnly {Boolean} - Nil types gets `readOnly` property
   * ## Example
   *
   * ```html
   * <api-view-model-transformer on-view-model-changed="_updateView"></api-view-model-transformer>
   * <script>
   * const amfModel = getAmfFromRamlOrOas();
   * const processor = document.querySelector('api-view-model-transformer');
   * processor.amfModel = amfModel;
   * processor.shape = extractHeadersForMethod(amfModel);
   * processor.addEventListener('view-model-changed', (e) => {
   *  console.log(e.detail.value);
   * });
   * < /script>
   * ```
   *
   * This example uses `getAmfFromRamlOrOas()` function where you implement
   * the logic of getting AMF json/ld data. It can be stored in file or parsed
   * using AMF parsers. The `extractHeadersForMethod()` represents a logic to
   * extract properties that you want to transform. It can be headers, query
   * parameters or body type.
   *
   * ## JSON ld context
   *
   * JSON schema may contain `@context` property. It can be used to reduce size
   * of the schema by replacing namespace ids with defined in `@context` keywords.
   * This transformer does not consume whole AMF model, but only the portion that
   * should be transformed. Because of that the tranformer is missing context
   * for namespace resolving. Set `@context` value of the model to `amfContext`
   * property so it can be expanded to the canonical form.
   * **Tranformation won't work properly if namespace name are altered by context
   * and `amfContext` property is not set.**
   */
  class ApiViewModelTransformer extends
    ArcBehaviors.EventsTargetBehavior(
    ApiElements.AmfHelperMixin(
    Object)) {

    /**
     * Generated AMF json/ld model form the API spec.
     * The element assumes the object of the first array item to be a
     * type of `"http://raml.org/vocabularies/document#Document`
     * on AMF vocabulary.
     *
     * It is only used to resolve references.
     */
    amfModel: object|any[]|null;
    readonly _exampleGenerator: Element|null;

    /**
     * An array of propertues for which view model is to be generated.
     * It accepts model for headers, query parameters, uri parameters and
     * body.
     * If `manualModel` is not set, assigning a value to this property will
     * trigger model computation. Otherwise call `computeViewModel()`
     * function manually to generate the model.
     */
    shape: any[]|null|undefined;

    /**
     * Generated view model from the `shape`
     */
    readonly viewModel: Array<object|null>|null;

    /**
     * If set, assigning a value to `shape` will not trigger view model
     * computation.
     */
    manualModel: boolean|null|undefined;

    /**
     * The declarations model computed from the AMF object. It is used when the
     * transformer attempt to transform link value.
     *
     * If this property is not set then it dispatches `amf-resolve-link`
     * custom event.
     */
    readonly _references: any[]|null|undefined;

    /**
     * Makes the model to always have `hasDescription` to false and
     * clears and documentation from ther model.
     */
    noDocs: boolean|null|undefined;
    disconnectedCallback(): void;
    _attachListeners(node: any): void;
    _detachListeners(node: any): void;

    /**
     * Clears cache for computed models.
     * All computed models are kept in in-memory cache to another call for computation
     * of the same model will result with reference to already computed value.
     * This function clears all cached objects.
     *
     * Note, the memory won't be freed for objects that are in use.
     */
    clearCache(): void;

    /**
     * Called when either `shape` or `manualModel` propeties changed.
     * If `manualModel` is falsy then it calls `computeViewModel()` function.
     *
     * Note, this function won't be called when sub property of the model
     * change. For peformance rerasons it won't be supported.
     *
     * Note, `computeViewModel` is called asynchronusly so `amfContext`
     * property can be set.
     *
     * @param shape Model for shape
     */
    _shapeChanged(shape: any[]|null): void;

    /**
     * Computes view model from AMF data model. This should not be called if
     * `manualModel` is not set. Use `shape` property instead.
     *
     * @param shape AMF type model. If not set it uses `shape`
     * property of the element.
     * @returns A promise resolved to generated model.
     */
    computeViewModel(shape: any[]|object|null): Array<object|null>|null;

    /**
     * Conputes model for each item recursively. It allows browser to return
     * the event loop and prohibit ANR to show.
     *
     * @param items List of remanding AMF model items.
     * This shuld be copy of the model since this function removes items from
     * the list.
     * @returns Promise resolved to the view model.
     */
    _computeViewModel(items: any[]|null): Array<object|null>|null;

    /**
     * Creates a UI model item from AMF json/ld model.
     *
     * @param amfItem AMF model with schema for
     * `http://raml.org/vocabularies/http#Parameter`
     * @returns UI data model.
     */
    uiModelForAmfItem(amfItem: object|null): object|null;

    /**
     * Creates a UI model item from AMF json/ld model for a parameter.
     *
     * @param amfItem AMF model with schema for
     * `http://raml.org/vocabularies/http#Parameter`
     * @returns UI data model.
     */
    _uiModelForParameter(amfItem: object|null): object|null;

    /**
     * Creates a UI model item from AMF json/ld model for a parameter.
     *
     * @param amfItem AMF model with schema for
     * `http://raml.org/vocabularies/http#Parameter`
     * @returns UI data model.
     */
    _uiModelForPropertyShape(amfItem: object|null): object|null;

    /**
     * Creates a view model for an object definition. Object definition can be
     * part of trait or annotation properties description.
     *
     * @param model Model to extract data from.
     * @returns View model for items.
     */
    modelForRawObject(model: object|null, processOptions: object|null): any[]|null;

    /**
     * Creates a view model from "raw" item (model before resolving).
     *
     * @param key Key of the item in the model.
     * @param model Item model
     * @returns View model
     */
    _uiModelForRawObject(key: String|null, model: String|null): object|null;

    /**
     * Sets up additional properties like `value` or placeholder from
     * values read from the AMF model.
     *
     * @param item Computed UI model.
     * @param processOptions Model creation options
     */
    _processAfterItemCreated(item: object|null, processOptions: object|null): object|null;

    /**
     * Completes computation of input label.
     *
     * @param displayName Value of the `displayName` property
     * @param name Property name
     * @param required Is item required
     * @returns Common input label construction.
     */
    _completeInputLabel(displayName: String|null, name: String|null, required: Boolean|null): String|null;

    /**
     * Computes list of examples from the Raw data model.
     */
    _computeRawExamples(model: object|null): any[]|null|undefined;

    /**
     * Computes value of the `binding` property of the UI model.
     *
     * @param model AMF item model
     * @returns Binding property or undefined if not found.
     */
    _computeBinding(model: object|null): String|null|undefined;

    /**
     * Computes fomm (parameter) name from AMF model.
     *
     * @param model AMF item model
     * @returns Name property or undefined if not found.
     */
    _computeFormName(model: object|null): String|null|undefined;

    /**
     * Computes `required` property from AMF model.
     *
     * @param model AMF item model
     * @returns True if the property is required.
     */
    _computeRequired(model: object|null): Boolean|null;

    /**
     * Computes `minCount` property from AMF model for PropertyShape object.
     *
     * @param model AMF item model
     * @returns True if `minCount` equals `1`
     */
    _computeRequiredPropertyShape(model: object|null): Boolean|null;

    /**
     * Computes type of the model. It's RAML data type property.
     *
     * @param shape Property schema.
     * @returns Type of the nproperty.
     */
    _computeModelType(shape: object|null): String|null;

    /**
     * Computes type of the raw model.
     *
     * @param model Property schema.
     * @returns Type of the nproperty.
     */
    _computeRawModelValue(model: any[]|null): String|null|undefined;

    /**
     * Computes scalar value that has proper type.
     *
     * @param item Shape to test for a value.
     */
    _computeRawScalarValue(item: object|null): String|Number|Boolean|null;
    _computeRawArrayValue(item: any): any;

    /**
     * Computes form input label value.
     *
     * @param def Property definition
     * @param required True if the property is required
     * @param name Property name
     * @returns Input display name.
     */
    _computeInputLabel(def: object|null, required: Boolean|null, name: String|null): String|null;

    /**
     * Computes the value of a property that namespace starts with
     * `http://www.w3.org/ns/shacl`.
     *
     * @param shape Property AMF definition
     * @param property Name of the schema.
     * @returns Value of the property or undefined if not set.
     */
    _computeShaclProperty(shape: object|null, property: String|null): any|null|undefined;

    /**
     * Computes the value of a property that namespace starts with
     * `http://raml.org/vocabularies/shapes`.
     *
     * @param shape Property AMF definition
     * @param property Name of the schema.
     * @returns Value of the property or undefined if not set.
     */
    _computeVocabularyShapeProperty(shape: object|null, property: String|null): any|null|undefined;

    /**
     * Computes default value for a shape.
     *
     * @param shape Amf shape
     * @returns Default value for the model or undefined.
     */
    _computeDefaultValue(shape: object|null): any|null|undefined;

    /**
     * Computes enum values for the view model.
     *
     * @param def Model definition.
     * @returns List of values.
     */
    _computeModelEnum(def: object|null): any[]|null;

    /**
     * Computes list of examples for the Property model.
     *
     * @param model AMF property model
     * @returns List of examples or `undefined` if not
     * defined.
     */
    _computeModelExamples(model: object|null): Array<object|null>|null|undefined;

    /**
     * Computes `items` property for AMF array property
     *
     * @param model AMF property model
     * @returns Array definition model
     */
    _computeModelItems(model: object|null): object|null;
    _computeValueDelimiter(binding: any): any;
    _computeDecodeValues(binding: any): any;

    /**
     * Parses a string from example or enum value to be used as default value.
     *
     * @param example Example value to process as a value
     * @param opts Options:
     * - name {String} Processed property name
     * - valueDelimiter {?String} either `:` for headers or `=` for query params
     * - decodeValues {Boolean} True to url decode value.
     * @returns [description]
     */
    _exampleAsValue(example: String|null, opts: object|null): any;

    /**
     * Computes rendered item input field type based on RAML definition.
     *
     * It will be either numeric or text. Type will be determined from
     * item's type or, in case of array, item's items property.
     *
     * @param type Property data type.
     * @param items Array items if any
     * @returns Input field type.
     */
    _computeModelInputType(type: String|null, items: any[]|null): String|null;

    /**
     * Computes pattern for the input.
     *
     * @param modelType Type of the property item.
     * @param pattern Pattern declared on the property
     * @param format For `datetime` type additional format value.
     * `rfc3339` is assumed by default
     * @returns Pattern or undefined if does not exists.
     */
    _computeModelPattern(modelType: String|null, pattern: String|null, format: String|null): String|null|undefined;

    /**
     * Computes a placeholder value for data and time inputs.
     *
     * @param type Model type.
     * @param format For `datetime` type additional format value.
     * `rfc3339` is assumed by default
     * @returns Placeholder value.
     */
    _computeTypePlaceholder(type: String|null, format: String|null): String|null|undefined;

    /**
     * Handler for the `api-property-model-build` custom event.
     * Builds a property view model using event detail object as a base object.
     *
     * All changes are applied to the `detail` object. Requesting element must
     * use the same object.
     */
    _buildPropertyHandler(e: CustomEvent|null): void;

    /**
     * Builds empty view model without traversing AMF model.
     *
     * @param defaults View model with default values. This values won't
     * be set.
     * @returns Generated basic view model.
     */
    buildProperty(defaults: object|null): object|null;

    /**
     * Computes if model item has documentation to display.
     * This would be extended documentation by adding additional description
     * properties that helps the user to input values into the editor.
     *
     * @param item Model item
     * @returns True if documentation can be rendered.
     */
    _computeHasExtendedDocumentation(item: object|null): Boolean|null;

    /**
     * Computes documentation as a markdown to be placed in the `marked-element`
     *
     * @param item View model
     * @returns Generated documentation
     */
    _computeExtendedDocumentation(item: object|null): String|null;

    /**
     * Returns `true` only when passed shape has `shapes#anyOf` array and
     * one of the union properties is of a type od NilShape.
     *
     * @param shape Schape test for nillable union.
     */
    _computeIsNillable(shape: object|null): Boolean|null;
  }
}

interface HTMLElementTagNameMap {
  "api-view-model-transformer": ApiElements.ApiViewModelTransformer;
}
